/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.io;

import com.twelvemonkeys.io.AbstractCachedSeekableStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public final class MemoryCacheSeekableStream
extends AbstractCachedSeekableStream {
    public MemoryCacheSeekableStream(InputStream inputStream) {
        super(inputStream, new MemoryCache());
    }

    @Override
    public final boolean isCachedMemory() {
        return true;
    }

    @Override
    public final boolean isCachedFile() {
        return false;
    }

    static final class MemoryCache
    extends AbstractCachedSeekableStream.StreamCache {
        static final int BLOCK_SIZE = 8192;
        private final List<byte[]> cache = new ArrayList<byte[]>();
        private long length;
        private long position;
        private long start;

        MemoryCache() {
        }

        private byte[] getBlock() throws IOException {
            long l15 = this.position - this.start;
            if (l15 < 0L) {
                throw new IOException("StreamCache flushed before read position");
            }
            long l16 = l15 / 8192L;
            if (l16 >= Integer.MAX_VALUE) {
                throw new IOException("Memory cache max size exceeded");
            }
            if (l16 >= (long)this.cache.size()) {
                try {
                    this.cache.add(new byte[8192]);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    throw new IOException("No more memory for cache: " + this.cache.size() * 8192);
                }
            }
            return this.cache.get((int)l16);
        }

        @Override
        public void write(int n15) throws IOException {
            byte[] byArray = this.getBlock();
            int n16 = (int)(this.position % 8192L);
            byArray[n16] = (byte)n15;
            ++this.position;
            if (this.position > this.length) {
                this.length = this.position;
            }
        }

        @Override
        public void write(byte[] byArray, int n15, int n16) throws IOException {
            byte[] byArray2 = this.getBlock();
            for (int i15 = 0; i15 < n16; ++i15) {
                int n17 = (int)this.position % 8192;
                if (n17 == 0) {
                    byArray2 = this.getBlock();
                }
                byArray2[n17] = byArray[n15 + i15];
                ++this.position;
            }
            if (this.position > this.length) {
                this.length = this.position;
            }
        }

        @Override
        public int read() throws IOException {
            if (this.position >= this.length) {
                return -1;
            }
            byte[] byArray = this.getBlock();
            int n15 = (int)(this.position % 8192L);
            ++this.position;
            return byArray[n15] & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n15, int n16) throws IOException {
            int n17;
            if (this.position >= this.length) {
                return -1;
            }
            byte[] byArray2 = this.getBlock();
            int n18 = (int)(this.position % 8192L);
            int n19 = (int)Math.min((long)Math.min(n16, byArray2.length - n18), this.length - this.position);
            for (n17 = 0; n17 < n19; ++n17) {
                byArray[n15 + n17] = byArray2[n18 + n17];
            }
            this.position += (long)n17;
            return n17;
        }

        @Override
        public void seek(long l15) throws IOException {
            if (l15 < this.start) {
                throw new IOException("Seek before flush position");
            }
            this.position = l15;
        }

        @Override
        public void flush(long l15) {
            int n15 = (int)(l15 / 8192L) - 1;
            for (int i15 = 0; i15 < n15; ++i15) {
                this.cache.remove(0);
            }
            this.start = l15;
        }

        @Override
        void close() throws IOException {
            this.cache.clear();
        }

        @Override
        public long getPosition() {
            return this.position;
        }
    }
}

