/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.color;

import com.twelvemonkeys.lang.Validate;
import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public final class DiscreteAlphaIndexColorModel
extends ColorModel {
    private final IndexColorModel icm;
    private final int extraSamples;
    private final int samples;

    public DiscreteAlphaIndexColorModel(IndexColorModel indexColorModel) {
        this(indexColorModel, 1, true);
    }

    public DiscreteAlphaIndexColorModel(IndexColorModel indexColorModel, int n15, boolean bl4) {
        super(Validate.notNull(indexColorModel, "IndexColorModel").getPixelSize() * (1 + n15), new int[]{indexColorModel.getPixelSize(), indexColorModel.getPixelSize(), indexColorModel.getPixelSize(), indexColorModel.getPixelSize()}, indexColorModel.getColorSpace(), bl4, false, bl4 ? 3 : 1, indexColorModel.getTransferType());
        this.icm = indexColorModel;
        this.extraSamples = n15;
        this.samples = 1 + n15;
    }

    @Override
    public int getNumComponents() {
        return this.getNumColorComponents() + this.extraSamples;
    }

    @Override
    public int getRed(int n15) {
        return this.icm.getRed(n15);
    }

    @Override
    public int getGreen(int n15) {
        return this.icm.getGreen(n15);
    }

    @Override
    public int getBlue(int n15) {
        return this.icm.getBlue(n15);
    }

    @Override
    public int getAlpha(int n15) {
        return this.hasAlpha() ? (int)((float)n15 / (float)((1 << this.getComponentSize(3)) - 1) * 255.0f + 0.5f) : 255;
    }

    private int getSample(Object object, int n15) {
        int n16;
        switch (this.transferType) {
            case 0: {
                byte[] byArray = (byte[])object;
                n16 = byArray[n15] & 0xFF;
                break;
            }
            case 1: {
                short[] sArray = (short[])object;
                n16 = sArray[n15] & 0xFFFF;
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                n16 = nArray[n15];
                break;
            }
            default: {
                throw new UnsupportedOperationException("This method has not been implemented for transferType " + this.transferType);
            }
        }
        return n16;
    }

    @Override
    public int getRed(Object object) {
        return this.getRed(this.getSample(object, 0));
    }

    @Override
    public int getGreen(Object object) {
        return this.getGreen(this.getSample(object, 0));
    }

    @Override
    public int getBlue(Object object) {
        return this.getBlue(this.getSample(object, 0));
    }

    @Override
    public int getAlpha(Object object) {
        return this.hasAlpha() ? this.getAlpha(this.getSample(object, 1)) : 255;
    }

    @Override
    public SampleModel createCompatibleSampleModel(int n15, int n16) {
        return new PixelInterleavedSampleModel(this.transferType, n15, n16, this.samples, n15 * this.samples, this.createOffsets(this.samples));
    }

    private int[] createOffsets(int n15) {
        int[] nArray = new int[n15];
        for (int i15 = 0; i15 < n15; ++i15) {
            nArray[i15] = i15;
        }
        return nArray;
    }

    @Override
    public boolean isCompatibleSampleModel(SampleModel sampleModel) {
        return sampleModel instanceof PixelInterleavedSampleModel && sampleModel.getNumBands() == this.samples;
    }

    @Override
    public WritableRaster createCompatibleWritableRaster(int n15, int n16) {
        return Raster.createWritableRaster(this.createCompatibleSampleModel(n15, n16), new Point(0, 0));
    }

    @Override
    public boolean isCompatibleRaster(Raster raster) {
        int n15 = raster.getSampleModel().getSampleSize(0);
        return raster.getTransferType() == this.transferType && raster.getNumBands() == this.samples && 1 << n15 >= this.icm.getMapSize();
    }

    @Override
    public boolean equals(Object object) {
        return this == object || object != null && this.getClass() == object.getClass() && this.icm.equals(((DiscreteAlphaIndexColorModel)object).icm);
    }

    @Override
    public String toString() {
        return "DiscreteAlphaIndexColorModel: #pixelBits = " + this.pixel_bits + " numComponents = " + this.getNumComponents() + " color space = " + this.getColorSpace() + " transparency = " + this.getTransparency() + " has alpha = " + this.hasAlpha() + " isAlphaPre = " + this.isAlphaPremultiplied();
    }
}

