/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.filter;

import com.github.weisj.jsvg.util.ImageUtil;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jetbrains.annotations.NotNull;

final class InplaceBoxBlurFilter {
    private InplaceBoxBlurFilter() {
    }

    public static void horizontalPass(@NotNull Raster src, @NotNull WritableRaster dst, int skipX, int skipY, int boxSize, int loc) {
        int width = src.getWidth();
        int height = src.getHeight();
        if (width < 2 * skipX + boxSize) {
            return;
        }
        if (height < 2 * skipY) {
            return;
        }
        int srcScanStride = ImageUtil.getINT_RGBA_ScanlineStride(src);
        int dstScanStride = ImageUtil.getINT_RGBA_ScanlineStride(dst);
        int srcOff = ImageUtil.getINT_RGBA_DataOffset(src);
        int dstOff = ImageUtil.getINT_RGBA_DataOffset(dst);
        int[] srcPixels = ImageUtil.getINT_RGBA_DataBank(src);
        int[] dstPixels = ImageUtil.getINT_RGBA_DataBank(dst);
        int[] buffer = new int[boxSize];
        int scale = 0x1000000 / boxSize;
        for (int y15 = skipY; y15 < height - skipY; ++y15) {
            int curr;
            int sp4 = srcOff + y15 * srcScanStride;
            int dp4 = dstOff + y15 * dstScanStride;
            int rowEnd = sp4 + (width - skipX);
            int k15 = 0;
            int sumA = 0;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int end = (sp4 += skipX) + boxSize;
            while (sp4 < end) {
                curr = buffer[k15] = srcPixels[sp4];
                sumA += curr >>> 24;
                sumR += curr >> 16 & 0xFF;
                sumG += curr >> 8 & 0xFF;
                sumB += curr & 0xFF;
                ++k15;
                ++sp4;
            }
            int prev = dstPixels[dp4 += skipX + loc] = sumA * scale & 0xFF000000 | (sumR * scale & 0xFF000000) >>> 8 | (sumG * scale & 0xFF000000) >>> 16 | (sumB * scale & 0xFF000000) >>> 24;
            ++dp4;
            k15 = 0;
            while (sp4 < rowEnd) {
                curr = buffer[k15];
                if (curr == srcPixels[sp4]) {
                    dstPixels[dp4] = prev;
                } else {
                    sumA -= curr >>> 24;
                    sumR -= curr >> 16 & 0xFF;
                    sumG -= curr >> 8 & 0xFF;
                    sumB -= curr & 0xFF;
                    curr = buffer[k15] = srcPixels[sp4];
                    prev = dstPixels[dp4] = (sumA += curr >>> 24) * scale & 0xFF000000 | ((sumR += curr >> 16 & 0xFF) * scale & 0xFF000000) >>> 8 | ((sumG += curr >> 8 & 0xFF) * scale & 0xFF000000) >>> 16 | ((sumB += curr & 0xFF) * scale & 0xFF000000) >>> 24;
                }
                k15 = (k15 + 1) % boxSize;
                ++sp4;
                ++dp4;
            }
        }
    }

    public static void verticalPass(@NotNull Raster src, @NotNull WritableRaster dst, int skipX, int skipY, int boxSize, int loc) {
        int w15 = src.getWidth();
        int h15 = src.getHeight();
        if (w15 < 2 * skipX) {
            return;
        }
        if (h15 < 2 * skipY + boxSize) {
            return;
        }
        int srcScanStride = ImageUtil.getINT_RGBA_ScanlineStride(src);
        int dstScanStride = ImageUtil.getINT_RGBA_ScanlineStride(dst);
        int srcOff = ImageUtil.getINT_RGBA_DataOffset(src);
        int dstOff = ImageUtil.getINT_RGBA_DataOffset(dst);
        int[] srcPixels = ImageUtil.getINT_RGBA_DataBank(src);
        int[] dstPixels = ImageUtil.getINT_RGBA_DataBank(dst);
        int[] buffer = new int[boxSize];
        int scale = 0x1000000 / boxSize;
        for (int x15 = skipX; x15 < w15 - skipX; ++x15) {
            int curr;
            int sp4 = srcOff + x15;
            int dp4 = dstOff + x15;
            int colEnd = sp4 + (h15 - skipY) * srcScanStride;
            int k15 = 0;
            int sumA = 0;
            int sumR = 0;
            int sumG = 0;
            int sumB = 0;
            int end = (sp4 += skipY * srcScanStride) + boxSize * srcScanStride;
            while (sp4 < end) {
                curr = buffer[k15] = srcPixels[sp4];
                sumA += curr >>> 24;
                sumR += curr >> 16 & 0xFF;
                sumG += curr >> 8 & 0xFF;
                sumB += curr & 0xFF;
                ++k15;
                sp4 += srcScanStride;
            }
            int prev = dstPixels[dp4 += (skipY + loc) * dstScanStride] = sumA * scale & 0xFF000000 | (sumR * scale & 0xFF000000) >>> 8 | (sumG * scale & 0xFF000000) >>> 16 | (sumB * scale & 0xFF000000) >>> 24;
            dp4 += dstScanStride;
            k15 = 0;
            while (sp4 < colEnd) {
                curr = buffer[k15];
                if (curr == srcPixels[sp4]) {
                    dstPixels[dp4] = prev;
                } else {
                    sumA -= curr >>> 24;
                    sumR -= curr >> 16 & 0xFF;
                    sumG -= curr >> 8 & 0xFF;
                    sumB -= curr & 0xFF;
                    curr = buffer[k15] = srcPixels[sp4];
                    prev = dstPixels[dp4] = (sumA += curr >>> 24) * scale & 0xFF000000 | ((sumR += curr >> 16 & 0xFF) * scale & 0xFF000000) >>> 8 | ((sumG += curr >> 8 & 0xFF) * scale & 0xFF000000) >>> 16 | ((sumB += curr & 0xFF) * scale & 0xFF000000) >>> 24;
                }
                k15 = (k15 + 1) % boxSize;
                sp4 += srcScanStride;
                dp4 += dstScanStride;
            }
        }
    }
}

