/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class SparseArray<E> {
    private static final Object DELETED = new Object();
    private boolean mGarbage = false;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    public SparseArray() {
        this(10);
    }

    public SparseArray(int initialCapacity) {
        this.mKeys = new int[initialCapacity];
        this.mValues = new Object[initialCapacity];
        this.mSize = 0;
    }

    public E get(int key) {
        return this.get(key, null);
    }

    public E get(int key, E valueIfKeyNotFound) {
        int i15 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i15 < 0 || this.mValues[i15] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i15];
    }

    public void delete(int key) {
        int i15 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i15 >= 0 && this.mValues[i15] != DELETED) {
            this.mValues[i15] = DELETED;
            this.mGarbage = true;
        }
    }

    public void remove(int key) {
        this.delete(key);
    }

    private void gc() {
        int n15 = this.mSize;
        int o15 = 0;
        int[] keys2 = this.mKeys;
        Object[] values2 = this.mValues;
        for (int i15 = 0; i15 < n15; ++i15) {
            Object val = values2[i15];
            if (val == DELETED) continue;
            if (i15 != o15) {
                keys2[o15] = keys2[i15];
                values2[o15] = val;
            }
            ++o15;
        }
        this.mGarbage = false;
        this.mSize = o15;
    }

    public void put(int key, E value) {
        int i15 = SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
        if (i15 >= 0) {
            this.mValues[i15] = value;
        } else {
            if ((i15 ^= 0xFFFFFFFF) < this.mSize && this.mValues[i15] == DELETED) {
                this.mKeys[i15] = key;
                this.mValues[i15] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i15 = ~SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
            }
            if (this.mSize >= this.mKeys.length) {
                int n15 = Math.max(this.mSize + 1, this.mKeys.length * 2);
                int[] nkeys = new int[n15];
                Object[] nvalues = new Object[n15];
                System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
                System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
                this.mKeys = nkeys;
                this.mValues = nvalues;
            }
            if (this.mSize - i15 != 0) {
                System.arraycopy(this.mKeys, i15, this.mKeys, i15 + 1, this.mSize - i15);
                System.arraycopy(this.mValues, i15, this.mValues, i15 + 1, this.mSize - i15);
            }
            this.mKeys[i15] = key;
            this.mValues[i15] = value;
            ++this.mSize;
        }
    }

    public int size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    public int keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    public E valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    public void setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    public int indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return SparseArray.binarySearch(this.mKeys, 0, this.mSize, key);
    }

    public int indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i15 = 0; i15 < this.mSize; ++i15) {
            if (this.mValues[i15] != value) continue;
            return i15;
        }
        return -1;
    }

    public void clear() {
        int n15 = this.mSize;
        Object[] values2 = this.mValues;
        for (int i15 = 0; i15 < n15; ++i15) {
            values2[i15] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    public void append(int key, E value) {
        int pos;
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if ((pos = this.mSize) >= this.mKeys.length) {
            int n15 = Math.max(pos + 1, this.mKeys.length * 2);
            int[] nkeys = new int[n15];
            Object[] nvalues = new Object[n15];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
        this.mKeys[pos] = key;
        this.mValues[pos] = value;
        this.mSize = pos + 1;
    }

    public void ensureCapacity(int capacity) {
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        if (this.mKeys.length < capacity) {
            int[] nkeys = new int[capacity];
            Object[] nvalues = new Object[capacity];
            System.arraycopy(this.mKeys, 0, nkeys, 0, this.mKeys.length);
            System.arraycopy(this.mValues, 0, nvalues, 0, this.mValues.length);
            this.mKeys = nkeys;
            this.mValues = nvalues;
        }
    }

    private static int binarySearch(int[] a15, int start, int len, int key) {
        int high = start + len;
        int low = start - 1;
        while (high - low > 1) {
            int guess = (high + low) / 2;
            if (a15[guess] < key) {
                low = guess;
                continue;
            }
            high = guess;
        }
        if (high == start + len) {
            return ~(start + len);
        }
        if (a15[high] == key) {
            return high;
        }
        return ~high;
    }

    public List<E> getValues() {
        return Collections.unmodifiableList(Arrays.asList(this.mValues));
    }
}

