/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.build.bundletool.sdkmodule;

import com.android.bundle.RuntimeEnabledSdkConfigProto;
import com.android.bundle.SdkModulesConfigOuterClass;
import com.android.tools.build.bundletool.model.BundleModule;
import com.android.tools.build.bundletool.model.ModuleEntry;
import com.android.tools.build.bundletool.model.ZipPath;
import com.android.tools.build.bundletool.sdkmodule.DexRepackager;
import com.android.tools.build.bundletool.sdkmodule.JavaResourceRepackager;
import com.android.tools.build.bundletool.xml.XmlUtils;
import com.google.common.base.Preconditions;
import com.google.common.io.ByteSource;
import java.nio.charset.StandardCharsets;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class DexAndResourceRepackager {
    private static final String COMPAT_CONFIG_ELEMENT_NAME = "compat-config";
    private static final String COMPAT_ENTRYPOINT_ELEMENT_NAME = "compat-entrypoint";
    private static final String DEX_PATH_ELEMENT_NAME = "dex-path";
    private static final String JAVA_RESOURCES_ROOT_PATH_ELEMENT_NAME = "java-resources-root-path";
    private static final String RESOURCES_PACKAGE_ID_ELEMENT_NAME = "resources-package-id";
    private static final String R_PACKAGE_CLASS_NAME_ELEMENT_NAME = "r-package-class";
    private static final String RESOURCE_ID_REMAPPING_ELEMENT_NAME = "resource-id-remapping";
    private static final String R_PACKAGE_CLASS_NAME = "RPackage";
    private static final String COMPAT_SDK_CONFIG_FILE_NAME = "CompatSdkConfig.xml";
    private static final String ASSETS_DIRECTORY = "assets";
    private static final String ASSETS_SUBDIRECTORY_PREFIX = "RuntimeEnabledSdk-";
    private final SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig;
    private final RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp inheritedAppProperties;
    private final DexRepackager dexRepackager;
    private final JavaResourceRepackager javaResourceRepackager;

    DexAndResourceRepackager(SdkModulesConfigOuterClass.SdkModulesConfig sdkModulesConfig, RuntimeEnabledSdkConfigProto.SdkSplitPropertiesInheritedFromApp inheritedAppProperties) {
        this.sdkModulesConfig = sdkModulesConfig;
        this.inheritedAppProperties = inheritedAppProperties;
        this.dexRepackager = new DexRepackager(sdkModulesConfig);
        this.javaResourceRepackager = new JavaResourceRepackager(sdkModulesConfig);
    }

    BundleModule repackage(BundleModule module) {
        Preconditions.checkArgument(!module.getEntry(this.getCompatSdkConfigPath()).isPresent(), "Unable to generate %s for %s, because file already exists.", (Object)COMPAT_SDK_CONFIG_FILE_NAME, (Object)this.sdkModulesConfig.getSdkPackageName());
        module = this.dexRepackager.applyMutation(module);
        module = this.javaResourceRepackager.applyMutation(module);
        return module.toBuilder().addEntry(this.getCompatSdkConfigModuleEntry(module)).setResourcesPackageId(this.inheritedAppProperties.getResourcesPackageId()).build();
    }

    public static String getCompatSdkConfigPathInAssets(String sdkPackageName) {
        return ASSETS_SUBDIRECTORY_PREFIX + sdkPackageName + "/" + COMPAT_SDK_CONFIG_FILE_NAME;
    }

    private ZipPath getCompatSdkConfigPath() {
        return ZipPath.create("assets/" + DexAndResourceRepackager.getCompatSdkConfigPathInAssets(this.sdkModulesConfig.getSdkPackageName()));
    }

    private ModuleEntry getCompatSdkConfigModuleEntry(BundleModule repackagedModule) {
        return ModuleEntry.builder().setPath(this.getCompatSdkConfigPath()).setContent(ByteSource.wrap(XmlUtils.documentToString(this.getCompatSdkConfig(repackagedModule)).getBytes(StandardCharsets.UTF_8))).build();
    }

    private Document getCompatSdkConfig(BundleModule repackagedModule) {
        Document compatSdkConfig;
        try {
            compatSdkConfig = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e15) {
            throw new IllegalStateException(e15);
        }
        compatSdkConfig.appendChild(this.createCompatConfigXmlNode(compatSdkConfig, repackagedModule));
        return compatSdkConfig;
    }

    private Node createCompatConfigXmlNode(Document xmlFactory, BundleModule repackagedModule) {
        Element compatConfigElement = xmlFactory.createElement(COMPAT_CONFIG_ELEMENT_NAME);
        this.appendCompatEntrypointElement(compatConfigElement, xmlFactory);
        this.appendResourceIdRemappingElement(compatConfigElement, xmlFactory);
        this.appendDexPathsToElement(compatConfigElement, xmlFactory, repackagedModule);
        this.appendJavaResourcesRootPathToElement(compatConfigElement, xmlFactory, repackagedModule);
        return compatConfigElement;
    }

    private void appendCompatEntrypointElement(Element compatConfigElement, Document xmlFactory) {
        if (!this.sdkModulesConfig.getCompatSdkProviderClassName().isEmpty()) {
            Element compatEntrypointElement = xmlFactory.createElement(COMPAT_ENTRYPOINT_ELEMENT_NAME);
            compatEntrypointElement.setTextContent(this.sdkModulesConfig.getCompatSdkProviderClassName());
            compatConfigElement.appendChild(compatEntrypointElement);
        }
    }

    private void appendResourceIdRemappingElement(Element compatConfigElement, Document xmlFactory) {
        Element resourceIdRemappingElement = xmlFactory.createElement(RESOURCE_ID_REMAPPING_ELEMENT_NAME);
        this.appendResourcesPackageIdElement(resourceIdRemappingElement, xmlFactory);
        this.appendRPackageClassNameElement(resourceIdRemappingElement, xmlFactory);
        compatConfigElement.appendChild(resourceIdRemappingElement);
    }

    private void appendResourcesPackageIdElement(Element resourceIdRemappingElement, Document xmlFactory) {
        Element resourcesPackageIdElement = xmlFactory.createElement(RESOURCES_PACKAGE_ID_ELEMENT_NAME);
        resourcesPackageIdElement.setTextContent(Integer.toString(this.inheritedAppProperties.getResourcesPackageId()));
        resourceIdRemappingElement.appendChild(resourcesPackageIdElement);
    }

    private void appendRPackageClassNameElement(Element resourceIdRemappingElement, Document xmlFactory) {
        Element rPackageClassNameElement = xmlFactory.createElement(R_PACKAGE_CLASS_NAME_ELEMENT_NAME);
        rPackageClassNameElement.setTextContent(this.sdkModulesConfig.getSdkPackageName() + "." + R_PACKAGE_CLASS_NAME);
        resourceIdRemappingElement.appendChild(rPackageClassNameElement);
    }

    private void appendDexPathsToElement(Element compatConfigElement, Document xmlFactory, BundleModule repackagedModule) {
        repackagedModule.getEntries().stream().filter(entry -> entry.getPath().startsWith(this.dexRepackager.getNewDexDirectoryPath())).map(entry -> {
            Element dexPathElement = xmlFactory.createElement(DEX_PATH_ELEMENT_NAME);
            dexPathElement.setTextContent(this.dexRepackager.getNewDexDirectoryPathInsideAssets() + "/" + entry.getPath().getFileName().toString());
            return dexPathElement;
        }).forEach(compatConfigElement::appendChild);
    }

    private void appendJavaResourcesRootPathToElement(Element compatConfigElement, Document xmlFactory, BundleModule repackagedModule) {
        if (this.getRepackagedJavaResourcesCount(repackagedModule) > 0L) {
            Element javaResourcesRootPathElement = xmlFactory.createElement(JAVA_RESOURCES_ROOT_PATH_ELEMENT_NAME);
            javaResourcesRootPathElement.setTextContent(this.javaResourceRepackager.getNewJavaResourceDirectoryPathInsideAssets());
            compatConfigElement.appendChild(javaResourcesRootPathElement);
        }
    }

    private long getRepackagedJavaResourcesCount(BundleModule repackagedModule) {
        return repackagedModule.getEntries().stream().filter(entry -> entry.getPath().startsWith(this.javaResourceRepackager.getNewJavaResourceDirectoryPath())).count();
    }
}

