/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.vertica.model;

import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.generic.model.GenericDataSource;
import org.jkiss.dbeaver.ext.generic.model.GenericObjectContainer;
import org.jkiss.dbeaver.ext.generic.model.GenericTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaDataSource;
import org.jkiss.dbeaver.ext.vertica.model.VerticaNode;
import org.jkiss.dbeaver.ext.vertica.model.VerticaProjection;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSchema;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSequence;
import org.jkiss.dbeaver.ext.vertica.model.VerticaSystemTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaTable;
import org.jkiss.dbeaver.ext.vertica.model.VerticaView;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectType;

public enum VerticaObjectType implements DBSObjectType
{
    TABLE("Table", "Vertica table", VerticaTable.class, (DBPImage)DBIcon.TREE_TABLE),
    SYSTEM_TABLE("System table", "Vertica system table", VerticaSystemTable.class, (DBPImage)DBIcon.TREE_TABLE),
    VIEW("View", "Vertica View", VerticaView.class, (DBPImage)DBIcon.TREE_VIEW),
    PROJECTION("Projection", "Vertica Projection", VerticaProjection.class, (DBPImage)DBIcon.TREE_TABLE_INDEX),
    NODE("Node", "Vertica Node", VerticaNode.class, (DBPImage)DBIcon.TREE_SERVERS),
    SEQUENCE("Sequence", "Vertica Sequence", VerticaSequence.class, (DBPImage)DBIcon.TREE_SEQUENCE);

    private final String typeName;
    private final String description;
    private final Class<? extends DBSObject> theClass;
    private final DBPImage icon;
    private static final Log log;

    private VerticaObjectType(String type, String description, Class<? extends DBSObject> theClass, DBPImage icon) {
        this.typeName = type;
        this.description = description;
        this.theClass = theClass;
        this.icon = icon;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public DBPImage getImage() {
        return this.icon;
    }

    public Class<? extends DBSObject> getTypeClass() {
        return this.theClass;
    }

    public DBSObject findObject(DBRProgressMonitor monitor, GenericObjectContainer schema, String objectName) throws DBException {
        if (schema == null) {
            log.debug((Object)("Null schema in table " + objectName + " search (" + objectName + ")"));
            return null;
        }
        if (GenericTable.class.isAssignableFrom(this.theClass) || VerticaView.class.isAssignableFrom(this.theClass)) {
            return schema.getChild(monitor, objectName);
        }
        if (schema instanceof VerticaSchema && VerticaProjection.class.isAssignableFrom(this.theClass)) {
            return ((VerticaSchema)schema).getProjection(monitor, objectName);
        }
        GenericDataSource dataSource = schema.getDataSource();
        if (dataSource instanceof VerticaDataSource && VerticaNode.class.isAssignableFrom(this.theClass)) {
            return ((VerticaDataSource)dataSource).getClusterNode(monitor, objectName);
        }
        log.debug((Object)("Unsupported object for Vertica search: " + this.name()));
        return null;
    }

    static {
        log = Log.getLog(VerticaObjectType.class);
    }
}

