/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.ha.session;

import java.util.Map;
import org.apache.catalina.ha.ClusterListener;
import org.apache.catalina.ha.ClusterManager;
import org.apache.catalina.ha.ClusterMessage;
import org.apache.catalina.ha.session.SessionMessage;
import org.apache.catalina.ha.session.SessionMessageImpl;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class ClusterSessionListener
extends ClusterListener {
    private static final Log log = LogFactory.getLog(ClusterSessionListener.class);
    private static final StringManager sm = StringManager.getManager(ClusterSessionListener.class);

    @Override
    public void messageReceived(ClusterMessage clusterMessage) {
        if (clusterMessage instanceof SessionMessage) {
            SessionMessage sessionMessage = (SessionMessage)clusterMessage;
            String string = sessionMessage.getContextName();
            Map<String, ClusterManager> map = this.cluster.getManagers();
            if (string == null) {
                for (Map.Entry<String, ClusterManager> entry : map.entrySet()) {
                    if (entry.getValue() != null) {
                        entry.getValue().messageDataReceived(sessionMessage);
                        continue;
                    }
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("clusterSessionListener.noManager", new Object[]{entry.getKey()}));
                }
            } else {
                ClusterManager clusterManager = map.get(string);
                if (clusterManager != null) {
                    clusterManager.messageDataReceived(sessionMessage);
                } else {
                    if (log.isWarnEnabled()) {
                        log.warn((Object)sm.getString("clusterSessionListener.noManager", new Object[]{string}));
                    }
                    if (sessionMessage.getEventType() == 4) {
                        SessionMessageImpl sessionMessageImpl = new SessionMessageImpl(string, 16, null, "NO-CONTEXT-MANAGER", "NO-CONTEXT-MANAGER-" + string);
                        this.cluster.send(sessionMessageImpl, sessionMessage.getAddress());
                    }
                }
            }
        }
    }

    @Override
    public boolean accept(ClusterMessage clusterMessage) {
        return clusterMessage instanceof SessionMessage;
    }
}

