/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.update;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.Bits;
import org.apache.solr.common.MapSerializable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.Hash;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.core.SolrCore;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.update.VersionInfo;
import org.apache.solr.util.RTimer;
import org.apache.solr.util.RefCounted;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexFingerprint
implements MapSerializable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private long maxVersionSpecified;
    private long maxVersionEncountered;
    private long maxInHash;
    private long versionsHash;
    private long numVersions;
    private long numDocs;
    private long maxDoc;

    public IndexFingerprint() {
    }

    public IndexFingerprint(long maxVersionSpecified) {
        this.maxVersionSpecified = maxVersionSpecified;
    }

    public long getMaxVersionSpecified() {
        return this.maxVersionSpecified;
    }

    public long getMaxVersionEncountered() {
        return this.maxVersionEncountered;
    }

    public long getMaxInHash() {
        return this.maxInHash;
    }

    public long getVersionsHash() {
        return this.versionsHash;
    }

    public long getNumVersions() {
        return this.numVersions;
    }

    public long getNumDocs() {
        return this.numDocs;
    }

    public long getMaxDoc() {
        return this.maxDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IndexFingerprint getFingerprint(SolrCore core, long maxVersion) throws IOException {
        RTimer timer = new RTimer();
        core.getUpdateHandler().getUpdateLog().openRealtimeSearcher();
        RefCounted<SolrIndexSearcher> newestSearcher = core.getUpdateHandler().getUpdateLog().uhandler.core.getRealtimeSearcher();
        try {
            IndexFingerprint f = newestSearcher.get().getIndexFingerprint(maxVersion);
            double duration = timer.stop();
            log.info("IndexFingerprint millis:{} result:{}", (Object)duration, (Object)f);
            IndexFingerprint indexFingerprint = f;
            return indexFingerprint;
        }
        finally {
            if (newestSearcher != null) {
                newestSearcher.decref();
            }
        }
    }

    public static IndexFingerprint getFingerprint(SolrIndexSearcher searcher, LeafReaderContext ctx, Long maxVersion) throws IOException {
        SchemaField versionField = VersionInfo.getAndCheckVersionField(searcher.getSchema());
        ValueSource vs = versionField.getType().getValueSource(versionField, null);
        Map funcContext = ValueSource.newContext((IndexSearcher)searcher);
        vs.createWeight(funcContext, (IndexSearcher)searcher);
        IndexFingerprint f = new IndexFingerprint();
        f.maxVersionSpecified = maxVersion;
        f.maxDoc = ctx.reader().maxDoc();
        f.numDocs = ctx.reader().numDocs();
        int maxDoc = ctx.reader().maxDoc();
        Bits liveDocs = ctx.reader().getLiveDocs();
        FunctionValues fv = vs.getValues(funcContext, ctx);
        for (int doc = 0; doc < maxDoc; ++doc) {
            if (liveDocs != null && !liveDocs.get(doc)) continue;
            long v = fv.longVal(doc);
            f.maxVersionEncountered = Math.max(v, f.maxVersionEncountered);
            if (v > f.maxVersionSpecified) continue;
            f.maxInHash = Math.max(v, f.maxInHash);
            f.versionsHash += Hash.fmix64((long)v);
            ++f.numVersions;
        }
        return f;
    }

    public static IndexFingerprint reduce(IndexFingerprint acc, IndexFingerprint f2) {
        acc.maxDoc = Math.max(acc.maxDoc, f2.maxDoc);
        acc.numDocs += f2.numDocs;
        acc.maxVersionEncountered = Math.max(acc.maxVersionEncountered, f2.maxVersionEncountered);
        acc.maxInHash = Math.max(acc.maxInHash, f2.maxInHash);
        acc.versionsHash += f2.versionsHash;
        acc.numVersions += f2.numVersions;
        return acc;
    }

    public static int compare(IndexFingerprint f1, IndexFingerprint f2) {
        int cmp;
        if (f1.maxVersionSpecified == Long.MAX_VALUE && (cmp = Long.compare(f1.maxVersionEncountered, f2.maxVersionEncountered)) != 0) {
            return cmp;
        }
        cmp = Long.compare(f1.maxInHash, f2.maxInHash);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(f1.numVersions, f2.numVersions);
        if (cmp != 0) {
            return cmp;
        }
        cmp = Long.compare(f1.versionsHash, f2.versionsHash);
        return cmp;
    }

    public Map<String, Object> toMap(Map<String, Object> map) {
        map.put("maxVersionSpecified", this.maxVersionSpecified);
        map.put("maxVersionEncountered", this.maxVersionEncountered);
        map.put("maxInHash", this.maxInHash);
        map.put("versionsHash", this.versionsHash);
        map.put("numVersions", this.numVersions);
        map.put("numDocs", this.numDocs);
        map.put("maxDoc", this.maxDoc);
        return map;
    }

    private static long getLong(Map<String, Object> m, String key, long def) {
        Object oval = m.get(key);
        return oval != null ? ((Number)oval).longValue() : def;
    }

    public static IndexFingerprint fromObject(Object o) {
        if (o instanceof IndexFingerprint) {
            return (IndexFingerprint)o;
        }
        Map map = null;
        if (o instanceof Map) {
            map = (Map)o;
        } else if (o instanceof NamedList) {
            map = ((NamedList)o).asShallowMap();
        } else {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unknown type " + String.valueOf(o));
        }
        IndexFingerprint f = new IndexFingerprint();
        f.maxVersionSpecified = IndexFingerprint.getLong(map, "maxVersionSpecified", Long.MAX_VALUE);
        f.maxVersionEncountered = IndexFingerprint.getLong(map, "maxVersionEncountered", -1L);
        f.maxInHash = IndexFingerprint.getLong(map, "maxInHash", -1L);
        f.versionsHash = IndexFingerprint.getLong(map, "versionsHash", -1L);
        f.numVersions = IndexFingerprint.getLong(map, "numVersions", -1L);
        f.numDocs = IndexFingerprint.getLong(map, "numDocs", -1L);
        f.maxDoc = IndexFingerprint.getLong(map, "maxDoc", -1L);
        return f;
    }

    public String toString() {
        return this.toMap(new LinkedHashMap<String, Object>()).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IndexFingerprint)) {
            return false;
        }
        IndexFingerprint other = (IndexFingerprint)o;
        return this.maxVersionSpecified == other.maxVersionSpecified && this.maxVersionEncountered == other.maxVersionEncountered && this.maxInHash == other.maxInHash && this.versionsHash == other.versionsHash && this.numVersions == other.numVersions && this.numDocs == other.numDocs && this.maxDoc == other.maxDoc;
    }

    public int hashCode() {
        return Objects.hash(this.maxVersionSpecified, this.maxVersionEncountered, this.maxInHash, this.versionsHash, this.numVersions, this.numDocs, this.maxDoc);
    }
}

