/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gml;

import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.xml.XmlUtilities;

public final class UniversalTimeAdapter
extends XmlAdapter<XMLGregorianCalendar, Date> {
    private static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    @Override
    public Date unmarshal(XMLGregorianCalendar xMLGregorianCalendar) {
        return xMLGregorianCalendar != null ? XmlUtilities.toDate(Context.current(), xMLGregorianCalendar) : null;
    }

    @Override
    public XMLGregorianCalendar marshal(Date date) {
        if (date != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(UTC, Locale.ROOT);
            gregorianCalendar.setTime(date);
            try {
                XMLGregorianCalendar xMLGregorianCalendar = XmlUtilities.getDatatypeFactory().newXMLGregorianCalendar(gregorianCalendar);
                if (xMLGregorianCalendar.getMillisecond() == 0) {
                    xMLGregorianCalendar.setMillisecond(Integer.MIN_VALUE);
                }
                return xMLGregorianCalendar;
            }
            catch (DatatypeConfigurationException datatypeConfigurationException) {
                Context.warningOccured(Context.current(), XmlAdapter.class, "marshal", datatypeConfigurationException, true);
            }
        }
        return null;
    }
}

