/*
 * Decompiled with CFR 0.152.
 */
package com.j256.simplemagic.entries;

import com.j256.simplemagic.ContentInfo;
import com.j256.simplemagic.ContentInfoUtil;
import com.j256.simplemagic.entries.MagicEntry;
import com.j256.simplemagic.entries.MagicEntryParser;
import com.j256.simplemagic.logger.Logger;
import com.j256.simplemagic.logger.LoggerFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MagicEntries {
    private static final int MAX_LEVELS = 20;
    private static final int FIRST_BYTE_LIST_SIZE = 256;
    private static Logger logger = LoggerFactory.getLogger(MagicEntries.class);
    private final List<MagicEntry> entryList = new ArrayList<MagicEntry>();
    private final List<MagicEntry>[] firstByteEntryLists = new ArrayList[256];

    public void readEntries(BufferedReader lineReader, ContentInfoUtil.ErrorCallBack errorCallBack) throws IOException {
        String line;
        MagicEntry[] levelParents = new MagicEntry[20];
        MagicEntry previousEntry = null;
        while ((line = lineReader.readLine()) != null) {
            MagicEntry entry;
            block8: {
                if (line.length() == 0 || line.charAt(0) == '#') continue;
                try {
                    entry = MagicEntryParser.parseLine(previousEntry, line, errorCallBack);
                    if (entry == null) {
                    }
                    break block8;
                }
                catch (IllegalArgumentException e) {
                    if (errorCallBack == null) continue;
                    errorCallBack.error(line, e.getMessage(), e);
                }
                continue;
            }
            int level = entry.getLevel();
            if (previousEntry == null && level != 0) {
                if (errorCallBack == null) continue;
                errorCallBack.error(line, "first entry of the file but the level " + level + " should be 0", null);
                continue;
            }
            if (level == 0) {
                this.entryList.add(entry);
            } else {
                if (levelParents[level - 1] == null) {
                    if (errorCallBack == null) continue;
                    errorCallBack.error(line, "entry has level " + level + " but no parent entry with level " + (level - 1), null);
                    continue;
                }
                levelParents[level - 1].addChild(entry);
            }
            levelParents[level] = entry;
            previousEntry = entry;
        }
    }

    public void optimizeFirstBytes() {
        for (MagicEntry entry : this.entryList) {
            byte[] startingBytes = entry.getStartsWithByte();
            if (startingBytes == null || startingBytes.length == 0) continue;
            int index = 0xFF & startingBytes[0];
            if (this.firstByteEntryLists[index] == null) {
                this.firstByteEntryLists[index] = new ArrayList<MagicEntry>();
            }
            this.firstByteEntryLists[index].add(entry);
        }
    }

    public ContentInfo findMatch(byte[] bytes) {
        ContentInfo info;
        if (bytes.length == 0) {
            return ContentInfo.EMPTY_INFO;
        }
        int index = 0xFF & bytes[0];
        if (index < this.firstByteEntryLists.length && this.firstByteEntryLists[index] != null && (info = this.findMatch(bytes, this.firstByteEntryLists[index])) != null) {
            return info;
        }
        return this.findMatch(bytes, this.entryList);
    }

    private ContentInfo findMatch(byte[] bytes, List<MagicEntry> entryList) {
        ContentInfo partialMatchInfo = null;
        for (MagicEntry entry : entryList) {
            ContentInfo info = entry.matchBytes(bytes);
            if (info == null) continue;
            if (!info.isPartial()) {
                logger.trace("found full match {}", entry);
                logger.trace("returning full match {}", info);
                return info;
            }
            if (partialMatchInfo != null) continue;
            logger.trace("found partial match {}", entry);
            partialMatchInfo = info;
        }
        if (partialMatchInfo == null) {
            logger.trace("returning no match");
            return null;
        }
        logger.trace("returning partial match {}", partialMatchInfo);
        return partialMatchInfo;
    }
}

