from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

BRETON_LANG_MODEL = {
    23: {  # 'A'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.LIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    26: {  # 'B'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.POSITIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    35: {  # 'C'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.LIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    27: {  # 'D'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.POSITIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.LIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.LIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    28: {  # 'E'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.LIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.LIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    44: {  # 'F'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    30: {  # 'G'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    40: {  # 'H'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.UNLIKELY,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    32: {  # 'I'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.POSITIVE,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.LIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.POSITIVE,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.POSITIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.POSITIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.LIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.LIKELY,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    46: {  # 'J'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    31: {  # 'K'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.LIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.UNLIKELY,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.LIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    37: {  # 'L'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.LIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.UNLIKELY,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.LIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    33: {  # 'M'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    41: {  # 'N'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.LIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.UNLIKELY,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    47: {  # 'O'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.UNLIKELY,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    36: {  # 'P'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.LIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    58: {  # 'Q'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    38: {  # 'R'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.LIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    29: {  # 'S'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.LIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    39: {  # 'T'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.LIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.LIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.LIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.UNLIKELY,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    42: {  # 'U'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.LIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.LIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.POSITIVE,  # 'R'
        29: SequenceLikelihood.LIKELY,  # 'S'
        39: SequenceLikelihood.LIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    43: {  # 'V'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.LIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.POSITIVE,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    48: {  # 'W'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.LIKELY,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    50: {  # 'X'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.POSITIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.POSITIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.LIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    49: {  # 'Y'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    53: {  # 'Z'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.LIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.LIKELY,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    2: {  # 'a'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    18: {  # 'b'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.LIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    20: {  # 'c'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.LIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    9: {  # 'd'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.LIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    1: {  # 'e'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.POSITIVE,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    24: {  # 'f'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    15: {  # 'g'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.LIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.LIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.LIKELY,  # 'è'
        45: SequenceLikelihood.POSITIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    11: {  # 'h'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.LIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.POSITIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    6: {  # 'i'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.POSITIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.POSITIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.LIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.LIKELY,  # 'è'
        45: SequenceLikelihood.LIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    25: {  # 'j'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    17: {  # 'k'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.POSITIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    8: {  # 'l'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.LIKELY,  # 'à'
        55: SequenceLikelihood.POSITIVE,  # 'â'
        57: SequenceLikelihood.LIKELY,  # 'è'
        45: SequenceLikelihood.POSITIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    16: {  # 'm'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    4: {  # 'n'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.LIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.POSITIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    5: {  # 'o'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.UNLIKELY,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.LIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.POSITIVE,  # 'ù'
        59: SequenceLikelihood.LIKELY,  # 'û'
    },
    19: {  # 'p'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    52: {  # 'q'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    3: {  # 'r'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.POSITIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.LIKELY,  # 'è'
        45: SequenceLikelihood.LIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.LIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    13: {  # 's'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.LIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    7: {  # 't'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.LIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.LIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.LIKELY,  # 'è'
        45: SequenceLikelihood.POSITIVE,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    10: {  # 'u'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.UNLIKELY,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.UNLIKELY,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.POSITIVE,  # 'b'
        20: SequenceLikelihood.POSITIVE,  # 'c'
        9: SequenceLikelihood.POSITIVE,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.POSITIVE,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.POSITIVE,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.POSITIVE,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.POSITIVE,  # 'p'
        52: SequenceLikelihood.LIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.POSITIVE,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.POSITIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.POSITIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.LIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    14: {  # 'v'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.LIKELY,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.LIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.POSITIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.LIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    22: {  # 'w'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.LIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.POSITIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    51: {  # 'x'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.UNLIKELY,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.UNLIKELY,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.UNLIKELY,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.UNLIKELY,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.LIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.LIKELY,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.LIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.LIKELY,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.NEGATIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    34: {  # 'y'
        23: SequenceLikelihood.UNLIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.UNLIKELY,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.UNLIKELY,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.LIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.POSITIVE,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.LIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.UNLIKELY,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
    12: {  # 'z'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.UNLIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.UNLIKELY,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.UNLIKELY,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.UNLIKELY,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.UNLIKELY,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.POSITIVE,  # 'a'
        18: SequenceLikelihood.LIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.LIKELY,  # 'd'
        1: SequenceLikelihood.POSITIVE,  # 'e'
        24: SequenceLikelihood.LIKELY,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.POSITIVE,  # 'h'
        6: SequenceLikelihood.POSITIVE,  # 'i'
        25: SequenceLikelihood.LIKELY,  # 'j'
        17: SequenceLikelihood.POSITIVE,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.POSITIVE,  # 'n'
        5: SequenceLikelihood.POSITIVE,  # 'o'
        19: SequenceLikelihood.LIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.POSITIVE,  # 'u'
        14: SequenceLikelihood.POSITIVE,  # 'v'
        22: SequenceLikelihood.LIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.LIKELY,  # 'y'
        12: SequenceLikelihood.LIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.UNLIKELY,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.UNLIKELY,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.UNLIKELY,  # 'î'
        54: SequenceLikelihood.UNLIKELY,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    61: {  # 'À'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    63: {  # 'Â'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    65: {  # 'È'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.NEGATIVE,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    67: {  # 'Ê'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.NEGATIVE,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    64: {  # 'Î'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.NEGATIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    66: {  # 'Ô'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.UNLIKELY,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    62: {  # 'Ù'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    68: {  # 'Û'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.NEGATIVE,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.NEGATIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.NEGATIVE,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.NEGATIVE,  # 'l'
        16: SequenceLikelihood.NEGATIVE,  # 'm'
        4: SequenceLikelihood.NEGATIVE,  # 'n'
        5: SequenceLikelihood.NEGATIVE,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.NEGATIVE,  # 'r'
        13: SequenceLikelihood.NEGATIVE,  # 's'
        7: SequenceLikelihood.NEGATIVE,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    56: {  # 'à'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.NEGATIVE,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.NEGATIVE,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    55: {  # 'â'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.NEGATIVE,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.UNLIKELY,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    57: {  # 'è'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.LIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.LIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.LIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.LIKELY,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    45: {  # 'ê'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.POSITIVE,  # 'r'
        13: SequenceLikelihood.LIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    60: {  # 'î'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.NEGATIVE,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.NEGATIVE,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.UNLIKELY,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    54: {  # 'ô'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.POSITIVE,  # 'g'
        11: SequenceLikelihood.NEGATIVE,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.UNLIKELY,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.LIKELY,  # 'm'
        4: SequenceLikelihood.LIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.UNLIKELY,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.UNLIKELY,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    21: {  # 'ù'
        23: SequenceLikelihood.LIKELY,  # 'A'
        26: SequenceLikelihood.UNLIKELY,  # 'B'
        35: SequenceLikelihood.UNLIKELY,  # 'C'
        27: SequenceLikelihood.LIKELY,  # 'D'
        28: SequenceLikelihood.UNLIKELY,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.UNLIKELY,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.UNLIKELY,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.UNLIKELY,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.UNLIKELY,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.UNLIKELY,  # 'R'
        29: SequenceLikelihood.UNLIKELY,  # 'S'
        39: SequenceLikelihood.UNLIKELY,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.UNLIKELY,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.UNLIKELY,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.LIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.NEGATIVE,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.UNLIKELY,  # 't'
        10: SequenceLikelihood.UNLIKELY,  # 'u'
        14: SequenceLikelihood.UNLIKELY,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.UNLIKELY,  # 'y'
        12: SequenceLikelihood.UNLIKELY,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.NEGATIVE,  # 'û'
    },
    59: {  # 'û'
        23: SequenceLikelihood.NEGATIVE,  # 'A'
        26: SequenceLikelihood.NEGATIVE,  # 'B'
        35: SequenceLikelihood.NEGATIVE,  # 'C'
        27: SequenceLikelihood.NEGATIVE,  # 'D'
        28: SequenceLikelihood.NEGATIVE,  # 'E'
        44: SequenceLikelihood.NEGATIVE,  # 'F'
        30: SequenceLikelihood.NEGATIVE,  # 'G'
        40: SequenceLikelihood.NEGATIVE,  # 'H'
        32: SequenceLikelihood.NEGATIVE,  # 'I'
        46: SequenceLikelihood.NEGATIVE,  # 'J'
        31: SequenceLikelihood.NEGATIVE,  # 'K'
        37: SequenceLikelihood.NEGATIVE,  # 'L'
        33: SequenceLikelihood.NEGATIVE,  # 'M'
        41: SequenceLikelihood.NEGATIVE,  # 'N'
        47: SequenceLikelihood.NEGATIVE,  # 'O'
        36: SequenceLikelihood.NEGATIVE,  # 'P'
        58: SequenceLikelihood.NEGATIVE,  # 'Q'
        38: SequenceLikelihood.NEGATIVE,  # 'R'
        29: SequenceLikelihood.NEGATIVE,  # 'S'
        39: SequenceLikelihood.NEGATIVE,  # 'T'
        42: SequenceLikelihood.NEGATIVE,  # 'U'
        43: SequenceLikelihood.NEGATIVE,  # 'V'
        48: SequenceLikelihood.NEGATIVE,  # 'W'
        50: SequenceLikelihood.NEGATIVE,  # 'X'
        49: SequenceLikelihood.NEGATIVE,  # 'Y'
        53: SequenceLikelihood.NEGATIVE,  # 'Z'
        2: SequenceLikelihood.NEGATIVE,  # 'a'
        18: SequenceLikelihood.UNLIKELY,  # 'b'
        20: SequenceLikelihood.UNLIKELY,  # 'c'
        9: SequenceLikelihood.UNLIKELY,  # 'd'
        1: SequenceLikelihood.UNLIKELY,  # 'e'
        24: SequenceLikelihood.NEGATIVE,  # 'f'
        15: SequenceLikelihood.UNLIKELY,  # 'g'
        11: SequenceLikelihood.UNLIKELY,  # 'h'
        6: SequenceLikelihood.UNLIKELY,  # 'i'
        25: SequenceLikelihood.NEGATIVE,  # 'j'
        17: SequenceLikelihood.UNLIKELY,  # 'k'
        8: SequenceLikelihood.UNLIKELY,  # 'l'
        16: SequenceLikelihood.UNLIKELY,  # 'm'
        4: SequenceLikelihood.UNLIKELY,  # 'n'
        5: SequenceLikelihood.UNLIKELY,  # 'o'
        19: SequenceLikelihood.UNLIKELY,  # 'p'
        52: SequenceLikelihood.UNLIKELY,  # 'q'
        3: SequenceLikelihood.UNLIKELY,  # 'r'
        13: SequenceLikelihood.UNLIKELY,  # 's'
        7: SequenceLikelihood.LIKELY,  # 't'
        10: SequenceLikelihood.NEGATIVE,  # 'u'
        14: SequenceLikelihood.NEGATIVE,  # 'v'
        22: SequenceLikelihood.NEGATIVE,  # 'w'
        51: SequenceLikelihood.NEGATIVE,  # 'x'
        34: SequenceLikelihood.NEGATIVE,  # 'y'
        12: SequenceLikelihood.NEGATIVE,  # 'z'
        61: SequenceLikelihood.NEGATIVE,  # 'À'
        63: SequenceLikelihood.NEGATIVE,  # 'Â'
        65: SequenceLikelihood.NEGATIVE,  # 'È'
        67: SequenceLikelihood.NEGATIVE,  # 'Ê'
        64: SequenceLikelihood.NEGATIVE,  # 'Î'
        66: SequenceLikelihood.NEGATIVE,  # 'Ô'
        62: SequenceLikelihood.NEGATIVE,  # 'Ù'
        68: SequenceLikelihood.NEGATIVE,  # 'Û'
        56: SequenceLikelihood.NEGATIVE,  # 'à'
        55: SequenceLikelihood.NEGATIVE,  # 'â'
        57: SequenceLikelihood.NEGATIVE,  # 'è'
        45: SequenceLikelihood.NEGATIVE,  # 'ê'
        60: SequenceLikelihood.NEGATIVE,  # 'î'
        54: SequenceLikelihood.NEGATIVE,  # 'ô'
        21: SequenceLikelihood.NEGATIVE,  # 'ù'
        59: SequenceLikelihood.UNLIKELY,  # 'û'
    },
}

# Character Mapping Table(s):
CP037_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 55,  # 'â'
    67: 0,  # 'ä'
    68: 56,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '¢'
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '|'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 45,  # 'ê'
    83: 0,  # 'ë'
    84: 57,  # 'è'
    85: 0,  # 'í'
    86: 60,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # '!'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '¬'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 63,  # 'Â'
    99: 0,  # 'Ä'
    100: 61,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 67,  # 'Ê'
    115: 0,  # 'Ë'
    116: 65,  # 'È'
    117: 0,  # 'Í'
    118: 64,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 2,  # 'a'
    130: 18,  # 'b'
    131: 20,  # 'c'
    132: 9,  # 'd'
    133: 1,  # 'e'
    134: 24,  # 'f'
    135: 15,  # 'g'
    136: 11,  # 'h'
    137: 6,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 25,  # 'j'
    146: 17,  # 'k'
    147: 8,  # 'l'
    148: 16,  # 'm'
    149: 4,  # 'n'
    150: 5,  # 'o'
    151: 19,  # 'p'
    152: 52,  # 'q'
    153: 3,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 13,  # 's'
    163: 7,  # 't'
    164: 10,  # 'u'
    165: 14,  # 'v'
    166: 22,  # 'w'
    167: 51,  # 'x'
    168: 34,  # 'y'
    169: 12,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '^'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '['
    187: CharacterCategory.SYMBOL,  # ']'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 23,  # 'A'
    194: 26,  # 'B'
    195: 35,  # 'C'
    196: 27,  # 'D'
    197: 28,  # 'E'
    198: 44,  # 'F'
    199: 30,  # 'G'
    200: 40,  # 'H'
    201: 32,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 54,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 46,  # 'J'
    210: 31,  # 'K'
    211: 37,  # 'L'
    212: 33,  # 'M'
    213: 41,  # 'N'
    214: 47,  # 'O'
    215: 36,  # 'P'
    216: 58,  # 'Q'
    217: 38,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 59,  # 'û'
    220: 0,  # 'ü'
    221: 21,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 29,  # 'S'
    227: 39,  # 'T'
    228: 42,  # 'U'
    229: 43,  # 'V'
    230: 48,  # 'W'
    231: 50,  # 'X'
    232: 49,  # 'Y'
    233: 53,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 66,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 68,  # 'Û'
    252: 0,  # 'Ü'
    253: 62,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP037_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="CP037",
    language="Breton",
    char_to_order_map=CP037_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

CP437_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 55,  # 'â'
    132: 0,  # 'ä'
    133: 56,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 45,  # 'ê'
    137: 0,  # 'ë'
    138: 57,  # 'è'
    139: 0,  # 'ï'
    140: 60,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 54,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 59,  # 'û'
    151: 21,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: CharacterCategory.SYMBOL,  # '¢'
    156: CharacterCategory.SYMBOL,  # '£'
    157: CharacterCategory.SYMBOL,  # '¥'
    158: CharacterCategory.SYMBOL,  # '₧'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '⌐'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'α'
    225: 0,  # 'ß'
    226: 0,  # 'Γ'
    227: 0,  # 'π'
    228: 0,  # 'Σ'
    229: 0,  # 'σ'
    230: 0,  # 'µ'
    231: 0,  # 'τ'
    232: 0,  # 'Φ'
    233: 0,  # 'Θ'
    234: 0,  # 'Ω'
    235: 0,  # 'δ'
    236: CharacterCategory.SYMBOL,  # '∞'
    237: 0,  # 'φ'
    238: 0,  # 'ε'
    239: CharacterCategory.SYMBOL,  # '∩'
    240: CharacterCategory.SYMBOL,  # '≡'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: CharacterCategory.SYMBOL,  # '⌠'
    245: CharacterCategory.SYMBOL,  # '⌡'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP437_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="CP437",
    language="Breton",
    char_to_order_map=CP437_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903481319922338,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

CP500_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: CharacterCategory.CONTROL,  # '\xa0'
    66: 55,  # 'â'
    67: 0,  # 'ä'
    68: 56,  # 'à'
    69: 0,  # 'á'
    70: 0,  # 'ã'
    71: 0,  # 'å'
    72: 0,  # 'ç'
    73: 0,  # 'ñ'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 0,  # 'é'
    82: 45,  # 'ê'
    83: 0,  # 'ë'
    84: 57,  # 'è'
    85: 0,  # 'í'
    86: 60,  # 'î'
    87: 0,  # 'ï'
    88: 0,  # 'ì'
    89: 0,  # 'ß'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 63,  # 'Â'
    99: 0,  # 'Ä'
    100: 61,  # 'À'
    101: 0,  # 'Á'
    102: 0,  # 'Ã'
    103: 0,  # 'Å'
    104: 0,  # 'Ç'
    105: 0,  # 'Ñ'
    106: CharacterCategory.SYMBOL,  # '¦'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: 0,  # 'ø'
    113: 0,  # 'É'
    114: 67,  # 'Ê'
    115: 0,  # 'Ë'
    116: 65,  # 'È'
    117: 0,  # 'Í'
    118: 64,  # 'Î'
    119: 0,  # 'Ï'
    120: 0,  # 'Ì'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: 0,  # 'Ø'
    129: 2,  # 'a'
    130: 18,  # 'b'
    131: 20,  # 'c'
    132: 9,  # 'd'
    133: 1,  # 'e'
    134: 24,  # 'f'
    135: 15,  # 'g'
    136: 11,  # 'h'
    137: 6,  # 'i'
    138: CharacterCategory.SYMBOL,  # '«'
    139: CharacterCategory.SYMBOL,  # '»'
    140: 0,  # 'ð'
    141: 0,  # 'ý'
    142: 0,  # 'þ'
    143: CharacterCategory.SYMBOL,  # '±'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 25,  # 'j'
    146: 17,  # 'k'
    147: 8,  # 'l'
    148: 16,  # 'm'
    149: 4,  # 'n'
    150: 5,  # 'o'
    151: 19,  # 'p'
    152: 52,  # 'q'
    153: 3,  # 'r'
    154: 0,  # 'ª'
    155: 0,  # 'º'
    156: 0,  # 'æ'
    157: CharacterCategory.SYMBOL,  # '¸'
    158: 0,  # 'Æ'
    159: CharacterCategory.SYMBOL,  # '¤'
    160: 0,  # 'µ'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 13,  # 's'
    163: 7,  # 't'
    164: 10,  # 'u'
    165: 14,  # 'v'
    166: 22,  # 'w'
    167: 51,  # 'x'
    168: 34,  # 'y'
    169: 12,  # 'z'
    170: CharacterCategory.SYMBOL,  # '¡'
    171: CharacterCategory.SYMBOL,  # '¿'
    172: 0,  # 'Ð'
    173: 0,  # 'Ý'
    174: 0,  # 'Þ'
    175: CharacterCategory.SYMBOL,  # '®'
    176: CharacterCategory.SYMBOL,  # '¢'
    177: CharacterCategory.SYMBOL,  # '£'
    178: CharacterCategory.SYMBOL,  # '¥'
    179: CharacterCategory.SYMBOL,  # '·'
    180: CharacterCategory.SYMBOL,  # '©'
    181: CharacterCategory.SYMBOL,  # '§'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.DIGIT,  # '¼'
    184: CharacterCategory.DIGIT,  # '½'
    185: CharacterCategory.DIGIT,  # '¾'
    186: CharacterCategory.SYMBOL,  # '¬'
    187: CharacterCategory.SYMBOL,  # '|'
    188: CharacterCategory.SYMBOL,  # '¯'
    189: CharacterCategory.SYMBOL,  # '¨'
    190: CharacterCategory.SYMBOL,  # '´'
    191: CharacterCategory.SYMBOL,  # '×'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 23,  # 'A'
    194: 26,  # 'B'
    195: 35,  # 'C'
    196: 27,  # 'D'
    197: 28,  # 'E'
    198: 44,  # 'F'
    199: 30,  # 'G'
    200: 40,  # 'H'
    201: 32,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 54,  # 'ô'
    204: 0,  # 'ö'
    205: 0,  # 'ò'
    206: 0,  # 'ó'
    207: 0,  # 'õ'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 46,  # 'J'
    210: 31,  # 'K'
    211: 37,  # 'L'
    212: 33,  # 'M'
    213: 41,  # 'N'
    214: 47,  # 'O'
    215: 36,  # 'P'
    216: 58,  # 'Q'
    217: 38,  # 'R'
    218: CharacterCategory.DIGIT,  # '¹'
    219: 59,  # 'û'
    220: 0,  # 'ü'
    221: 21,  # 'ù'
    222: 0,  # 'ú'
    223: 0,  # 'ÿ'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.SYMBOL,  # '÷'
    226: 29,  # 'S'
    227: 39,  # 'T'
    228: 42,  # 'U'
    229: 43,  # 'V'
    230: 48,  # 'W'
    231: 50,  # 'X'
    232: 49,  # 'Y'
    233: 53,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: 66,  # 'Ô'
    236: 0,  # 'Ö'
    237: 0,  # 'Ò'
    238: 0,  # 'Ó'
    239: 0,  # 'Õ'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: 68,  # 'Û'
    252: 0,  # 'Ü'
    253: 62,  # 'Ù'
    254: 0,  # 'Ú'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP500_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="CP500",
    language="Breton",
    char_to_order_map=CP500_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

CP850_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 55,  # 'â'
    132: 0,  # 'ä'
    133: 56,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 45,  # 'ê'
    137: 0,  # 'ë'
    138: 57,  # 'è'
    139: 0,  # 'ï'
    140: 60,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 54,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 59,  # 'û'
    151: 21,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 63,  # 'Â'
    183: 61,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 67,  # 'Ê'
    211: 0,  # 'Ë'
    212: 65,  # 'È'
    213: 0,  # 'ı'
    214: 0,  # 'Í'
    215: 64,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 66,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 68,  # 'Û'
    235: 62,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP850_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="CP850",
    language="Breton",
    char_to_order_map=CP850_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

CP858_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ç'
    129: 0,  # 'ü'
    130: 0,  # 'é'
    131: 55,  # 'â'
    132: 0,  # 'ä'
    133: 56,  # 'à'
    134: 0,  # 'å'
    135: 0,  # 'ç'
    136: 45,  # 'ê'
    137: 0,  # 'ë'
    138: 57,  # 'è'
    139: 0,  # 'ï'
    140: 60,  # 'î'
    141: 0,  # 'ì'
    142: 0,  # 'Ä'
    143: 0,  # 'Å'
    144: 0,  # 'É'
    145: 0,  # 'æ'
    146: 0,  # 'Æ'
    147: 54,  # 'ô'
    148: 0,  # 'ö'
    149: 0,  # 'ò'
    150: 59,  # 'û'
    151: 21,  # 'ù'
    152: 0,  # 'ÿ'
    153: 0,  # 'Ö'
    154: 0,  # 'Ü'
    155: 0,  # 'ø'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 0,  # 'Ø'
    158: CharacterCategory.SYMBOL,  # '×'
    159: 0,  # 'ƒ'
    160: 0,  # 'á'
    161: 0,  # 'í'
    162: 0,  # 'ó'
    163: 0,  # 'ú'
    164: 0,  # 'ñ'
    165: 0,  # 'Ñ'
    166: 0,  # 'ª'
    167: 0,  # 'º'
    168: CharacterCategory.SYMBOL,  # '¿'
    169: CharacterCategory.SYMBOL,  # '®'
    170: CharacterCategory.SYMBOL,  # '¬'
    171: CharacterCategory.DIGIT,  # '½'
    172: CharacterCategory.DIGIT,  # '¼'
    173: CharacterCategory.SYMBOL,  # '¡'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 0,  # 'Á'
    182: 63,  # 'Â'
    183: 61,  # 'À'
    184: CharacterCategory.SYMBOL,  # '©'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '¢'
    190: CharacterCategory.SYMBOL,  # '¥'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 0,  # 'ã'
    199: 0,  # 'Ã'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '¤'
    208: 0,  # 'ð'
    209: 0,  # 'Ð'
    210: 67,  # 'Ê'
    211: 0,  # 'Ë'
    212: 65,  # 'È'
    213: CharacterCategory.SYMBOL,  # '€'
    214: 0,  # 'Í'
    215: 64,  # 'Î'
    216: 0,  # 'Ï'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '¦'
    222: 0,  # 'Ì'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 0,  # 'Ó'
    225: 0,  # 'ß'
    226: 66,  # 'Ô'
    227: 0,  # 'Ò'
    228: 0,  # 'õ'
    229: 0,  # 'Õ'
    230: 0,  # 'µ'
    231: 0,  # 'þ'
    232: 0,  # 'Þ'
    233: 0,  # 'Ú'
    234: 68,  # 'Û'
    235: 62,  # 'Ù'
    236: 0,  # 'ý'
    237: 0,  # 'Ý'
    238: CharacterCategory.SYMBOL,  # '¯'
    239: CharacterCategory.SYMBOL,  # '´'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '‗'
    243: CharacterCategory.DIGIT,  # '¾'
    244: CharacterCategory.SYMBOL,  # '¶'
    245: CharacterCategory.SYMBOL,  # '§'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '¸'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.DIGIT,  # '¹'
    252: CharacterCategory.DIGIT,  # '³'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP858_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="CP858",
    language="Breton",
    char_to_order_map=CP858_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

ISO_8859_1_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 61,  # 'À'
    193: 0,  # 'Á'
    194: 63,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 65,  # 'È'
    201: 0,  # 'É'
    202: 67,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 64,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 66,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 62,  # 'Ù'
    218: 0,  # 'Ú'
    219: 68,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 56,  # 'à'
    225: 0,  # 'á'
    226: 55,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 57,  # 'è'
    233: 0,  # 'é'
    234: 45,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 60,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 54,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 21,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_1_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-1",
    language="Breton",
    char_to_order_map=ISO_8859_1_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

ISO_8859_14_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: 0,  # 'Ḃ'
    162: 0,  # 'ḃ'
    163: CharacterCategory.SYMBOL,  # '£'
    164: 0,  # 'Ċ'
    165: 0,  # 'ċ'
    166: 0,  # 'Ḋ'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'Ẁ'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'Ẃ'
    171: 0,  # 'ḋ'
    172: 0,  # 'Ỳ'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: 0,  # 'Ÿ'
    176: 0,  # 'Ḟ'
    177: 0,  # 'ḟ'
    178: 0,  # 'Ġ'
    179: 0,  # 'ġ'
    180: 0,  # 'Ṁ'
    181: 0,  # 'ṁ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: 0,  # 'Ṗ'
    184: 0,  # 'ẁ'
    185: 0,  # 'ṗ'
    186: 0,  # 'ẃ'
    187: 0,  # 'Ṡ'
    188: 0,  # 'ỳ'
    189: 0,  # 'Ẅ'
    190: 0,  # 'ẅ'
    191: 0,  # 'ṡ'
    192: 61,  # 'À'
    193: 0,  # 'Á'
    194: 63,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 65,  # 'È'
    201: 0,  # 'É'
    202: 67,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 64,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ŵ'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 66,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: 0,  # 'Ṫ'
    216: 0,  # 'Ø'
    217: 62,  # 'Ù'
    218: 0,  # 'Ú'
    219: 68,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Ŷ'
    223: 0,  # 'ß'
    224: 56,  # 'à'
    225: 0,  # 'á'
    226: 55,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 57,  # 'è'
    233: 0,  # 'é'
    234: 45,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 60,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ŵ'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 54,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: 0,  # 'ṫ'
    248: 0,  # 'ø'
    249: 21,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'ŷ'
    255: 0,  # 'ÿ'
}

ISO_8859_14_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-14",
    language="Breton",
    char_to_order_map=ISO_8859_14_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

ISO_8859_15_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: 0,  # 'Š'
    167: CharacterCategory.SYMBOL,  # '§'
    168: 0,  # 'š'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: 0,  # 'Ž'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 0,  # 'ž'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 0,  # 'Œ'
    189: 0,  # 'œ'
    190: 0,  # 'Ÿ'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 61,  # 'À'
    193: 0,  # 'Á'
    194: 63,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 65,  # 'È'
    201: 0,  # 'É'
    202: 67,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 64,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 66,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 62,  # 'Ù'
    218: 0,  # 'Ú'
    219: 68,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 56,  # 'à'
    225: 0,  # 'á'
    226: 55,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 57,  # 'è'
    233: 0,  # 'é'
    234: 45,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 60,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 54,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 21,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

ISO_8859_15_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-15",
    language="Breton",
    char_to_order_map=ISO_8859_15_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

MACROMAN_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: 0,  # 'Å'
    130: 0,  # 'Ç'
    131: 0,  # 'É'
    132: 0,  # 'Ñ'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: 0,  # 'á'
    136: 56,  # 'à'
    137: 55,  # 'â'
    138: 0,  # 'ä'
    139: 0,  # 'ã'
    140: 0,  # 'å'
    141: 0,  # 'ç'
    142: 0,  # 'é'
    143: 57,  # 'è'
    144: 45,  # 'ê'
    145: 0,  # 'ë'
    146: 0,  # 'í'
    147: 0,  # 'ì'
    148: 60,  # 'î'
    149: 0,  # 'ï'
    150: 0,  # 'ñ'
    151: 0,  # 'ó'
    152: 0,  # 'ò'
    153: 54,  # 'ô'
    154: 0,  # 'ö'
    155: 0,  # 'õ'
    156: 0,  # 'ú'
    157: 21,  # 'ù'
    158: 59,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: CharacterCategory.SYMBOL,  # '°'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '§'
    165: CharacterCategory.SYMBOL,  # '•'
    166: CharacterCategory.SYMBOL,  # '¶'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.SYMBOL,  # '™'
    171: CharacterCategory.SYMBOL,  # '´'
    172: CharacterCategory.SYMBOL,  # '¨'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: 0,  # 'Æ'
    175: 0,  # 'Ø'
    176: CharacterCategory.SYMBOL,  # '∞'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '∂'
    183: CharacterCategory.SYMBOL,  # '∑'
    184: CharacterCategory.SYMBOL,  # '∏'
    185: 0,  # 'π'
    186: CharacterCategory.SYMBOL,  # '∫'
    187: 0,  # 'ª'
    188: 0,  # 'º'
    189: 0,  # 'Ω'
    190: 0,  # 'æ'
    191: 0,  # 'ø'
    192: CharacterCategory.SYMBOL,  # '¿'
    193: CharacterCategory.SYMBOL,  # '¡'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: CharacterCategory.SYMBOL,  # '√'
    196: 0,  # 'ƒ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: CharacterCategory.SYMBOL,  # '∆'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 61,  # 'À'
    204: 0,  # 'Ã'
    205: 0,  # 'Õ'
    206: 0,  # 'Œ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '—'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: CharacterCategory.SYMBOL,  # '◊'
    216: 0,  # 'ÿ'
    217: 0,  # 'Ÿ'
    218: CharacterCategory.SYMBOL,  # '⁄'
    219: CharacterCategory.SYMBOL,  # '€'
    220: CharacterCategory.SYMBOL,  # '‹'
    221: CharacterCategory.SYMBOL,  # '›'
    222: 0,  # 'ﬁ'
    223: 0,  # 'ﬂ'
    224: CharacterCategory.SYMBOL,  # '‡'
    225: CharacterCategory.SYMBOL,  # '·'
    226: CharacterCategory.SYMBOL,  # '‚'
    227: CharacterCategory.SYMBOL,  # '„'
    228: CharacterCategory.SYMBOL,  # '‰'
    229: 63,  # 'Â'
    230: 67,  # 'Ê'
    231: 0,  # 'Á'
    232: 0,  # 'Ë'
    233: 65,  # 'È'
    234: 0,  # 'Í'
    235: 64,  # 'Î'
    236: 0,  # 'Ï'
    237: 0,  # 'Ì'
    238: 0,  # 'Ó'
    239: 66,  # 'Ô'
    240: CharacterCategory.CONTROL,  # '\uf8ff'
    241: 0,  # 'Ò'
    242: 0,  # 'Ú'
    243: 68,  # 'Û'
    244: 62,  # 'Ù'
    245: 0,  # 'ı'
    246: 0,  # 'ˆ'
    247: CharacterCategory.SYMBOL,  # '˜'
    248: CharacterCategory.SYMBOL,  # '¯'
    249: CharacterCategory.SYMBOL,  # '˘'
    250: CharacterCategory.SYMBOL,  # '˙'
    251: CharacterCategory.SYMBOL,  # '˚'
    252: CharacterCategory.SYMBOL,  # '¸'
    253: CharacterCategory.SYMBOL,  # '˝'
    254: CharacterCategory.SYMBOL,  # '˛'
    255: 0,  # 'ˇ'
}

MACROMAN_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="MacRoman",
    language="Breton",
    char_to_order_map=MACROMAN_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)

WINDOWS_1252_BRETON_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 23,  # 'A'
    66: 26,  # 'B'
    67: 35,  # 'C'
    68: 27,  # 'D'
    69: 28,  # 'E'
    70: 44,  # 'F'
    71: 30,  # 'G'
    72: 40,  # 'H'
    73: 32,  # 'I'
    74: 46,  # 'J'
    75: 31,  # 'K'
    76: 37,  # 'L'
    77: 33,  # 'M'
    78: 41,  # 'N'
    79: 47,  # 'O'
    80: 36,  # 'P'
    81: 58,  # 'Q'
    82: 38,  # 'R'
    83: 29,  # 'S'
    84: 39,  # 'T'
    85: 42,  # 'U'
    86: 43,  # 'V'
    87: 48,  # 'W'
    88: 50,  # 'X'
    89: 49,  # 'Y'
    90: 53,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 2,  # 'a'
    98: 18,  # 'b'
    99: 20,  # 'c'
    100: 9,  # 'd'
    101: 1,  # 'e'
    102: 24,  # 'f'
    103: 15,  # 'g'
    104: 11,  # 'h'
    105: 6,  # 'i'
    106: 25,  # 'j'
    107: 17,  # 'k'
    108: 8,  # 'l'
    109: 16,  # 'm'
    110: 4,  # 'n'
    111: 5,  # 'o'
    112: 19,  # 'p'
    113: 52,  # 'q'
    114: 3,  # 'r'
    115: 13,  # 's'
    116: 7,  # 't'
    117: 10,  # 'u'
    118: 14,  # 'v'
    119: 22,  # 'w'
    120: 51,  # 'x'
    121: 34,  # 'y'
    122: 12,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: 0,  # 'ˆ'
    137: CharacterCategory.SYMBOL,  # '‰'
    138: 0,  # 'Š'
    139: CharacterCategory.SYMBOL,  # '‹'
    140: 0,  # 'Œ'
    141: CharacterCategory.UNDEFINED,  # None
    142: 0,  # 'Ž'
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.SYMBOL,  # '˜'
    153: CharacterCategory.SYMBOL,  # '™'
    154: 0,  # 'š'
    155: CharacterCategory.SYMBOL,  # '›'
    156: 0,  # 'œ'
    157: CharacterCategory.UNDEFINED,  # None
    158: 0,  # 'ž'
    159: 0,  # 'Ÿ'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '¡'
    162: CharacterCategory.SYMBOL,  # '¢'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ª'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '¯'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '´'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: CharacterCategory.SYMBOL,  # '¸'
    185: CharacterCategory.DIGIT,  # '¹'
    186: 0,  # 'º'
    187: CharacterCategory.SYMBOL,  # '»'
    188: CharacterCategory.DIGIT,  # '¼'
    189: CharacterCategory.DIGIT,  # '½'
    190: CharacterCategory.DIGIT,  # '¾'
    191: CharacterCategory.SYMBOL,  # '¿'
    192: 61,  # 'À'
    193: 0,  # 'Á'
    194: 63,  # 'Â'
    195: 0,  # 'Ã'
    196: 0,  # 'Ä'
    197: 0,  # 'Å'
    198: 0,  # 'Æ'
    199: 0,  # 'Ç'
    200: 65,  # 'È'
    201: 0,  # 'É'
    202: 67,  # 'Ê'
    203: 0,  # 'Ë'
    204: 0,  # 'Ì'
    205: 0,  # 'Í'
    206: 64,  # 'Î'
    207: 0,  # 'Ï'
    208: 0,  # 'Ð'
    209: 0,  # 'Ñ'
    210: 0,  # 'Ò'
    211: 0,  # 'Ó'
    212: 66,  # 'Ô'
    213: 0,  # 'Õ'
    214: 0,  # 'Ö'
    215: CharacterCategory.SYMBOL,  # '×'
    216: 0,  # 'Ø'
    217: 62,  # 'Ù'
    218: 0,  # 'Ú'
    219: 68,  # 'Û'
    220: 0,  # 'Ü'
    221: 0,  # 'Ý'
    222: 0,  # 'Þ'
    223: 0,  # 'ß'
    224: 56,  # 'à'
    225: 0,  # 'á'
    226: 55,  # 'â'
    227: 0,  # 'ã'
    228: 0,  # 'ä'
    229: 0,  # 'å'
    230: 0,  # 'æ'
    231: 0,  # 'ç'
    232: 57,  # 'è'
    233: 0,  # 'é'
    234: 45,  # 'ê'
    235: 0,  # 'ë'
    236: 0,  # 'ì'
    237: 0,  # 'í'
    238: 60,  # 'î'
    239: 0,  # 'ï'
    240: 0,  # 'ð'
    241: 0,  # 'ñ'
    242: 0,  # 'ò'
    243: 0,  # 'ó'
    244: 54,  # 'ô'
    245: 0,  # 'õ'
    246: 0,  # 'ö'
    247: CharacterCategory.SYMBOL,  # '÷'
    248: 0,  # 'ø'
    249: 21,  # 'ù'
    250: 0,  # 'ú'
    251: 59,  # 'û'
    252: 0,  # 'ü'
    253: 0,  # 'ý'
    254: 0,  # 'þ'
    255: 0,  # 'ÿ'
}

WINDOWS_1252_BRETON_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1252",
    language="Breton",
    char_to_order_map=WINDOWS_1252_BRETON_CHAR_TO_ORDER,
    language_model=BRETON_LANG_MODEL,
    typical_positive_ratio=0.9903366122568247,
    keep_ascii_letters=True,
    alphabet="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzÀÂÈÊÎÔÙÛàâèêîôùû",
)
