/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.chart.command;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.chart.ChartDiagram;
import net.sourceforge.plantuml.chart.ChartSeries;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandChartLine
extends SingleLineCommand2<ChartDiagram> {
    public CommandChartLine() {
        super(false, CommandChartLine.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandChartLine.class.getName(), RegexLeaf.start(), new RegexLeaf("line"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "STEREO", "(\\<\\<.+?\\>\\>)")), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "NAME", "\"([^\"]+)\"")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf(1, "DATA", "\\[(.*)\\]"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf(1, "COLOR", "#([0-9a-fA-F]{6}|[0-9a-fA-F]{3}|\\w+)")), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "V2", "(v2)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "LABELS", "(labels)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(ChartDiagram diagram, LineLocation location, RegexResult arg, ParserPass currentPass) throws NoSuchColorException {
        String labelsStr;
        String v2Str;
        ChartSeries series;
        String seriesName;
        String stereo = arg.getLazzy("STEREO", 0);
        String name = arg.getLazzy("NAME", 0);
        String data = arg.get("DATA", 0);
        String colorStr = arg.getLazzy("COLOR", 0);
        String string = seriesName = name != null ? name : "line" + diagram.getSeries().size();
        if (data.contains("(")) {
            ArrayList<Double> xValues = new ArrayList<Double>();
            ArrayList<Double> yValues = new ArrayList<Double>();
            if (!this.parseCoordinatePairs(data, xValues, yValues)) {
                return CommandExecutionResult.error("Invalid coordinate pair format in line data");
            }
            series = new ChartSeries(seriesName, ChartSeries.SeriesType.LINE, xValues, yValues);
        } else {
            List<Double> values = this.parseValues(data);
            if (values == null) {
                return CommandExecutionResult.error("Invalid number format in line data");
            }
            series = new ChartSeries(seriesName, ChartSeries.SeriesType.LINE, values);
        }
        if (stereo != null) {
            series.setStereotype(Stereotype.build(stereo));
        }
        if (colorStr != null) {
            HColor color = diagram.getSkinParam().getIHtmlColorSet().getColor("#" + colorStr);
            series.setColor(color);
        }
        if ((v2Str = arg.getLazzy("V2", 0)) != null) {
            series.setUseSecondaryAxis(true);
        }
        if ((labelsStr = arg.getLazzy("LABELS", 0)) != null) {
            series.setShowLabels(true);
        }
        return diagram.addSeries(series);
    }

    private List<Double> parseValues(String data) {
        String[] parts;
        ArrayList<Double> result = new ArrayList<Double>();
        if (data == null || data.trim().isEmpty()) {
            return result;
        }
        for (String part : parts = data.split(",")) {
            try {
                result.add(Double.parseDouble(part.trim()));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return result;
    }

    private boolean parseCoordinatePairs(String data, List<Double> xValues, List<Double> yValues) {
        String[] pairs;
        if (data == null || data.trim().isEmpty()) {
            return false;
        }
        String cleaned = data.replaceAll("\\s+", "");
        for (String pair : pairs = cleaned.split("\\),\\(")) {
            String trimmedPair = pair.trim();
            trimmedPair = trimmedPair.replaceAll("^[\\[\\(]+", "");
            String[] coords = (trimmedPair = trimmedPair.replaceAll("[\\]\\)]+$", "")).split(",");
            if (coords.length != 2) {
                return false;
            }
            try {
                double x = Double.parseDouble(coords[0].trim());
                double y = Double.parseDouble(coords[1].trim());
                xValues.add(x);
                yValues.add(y);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }
}

