/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.tools.cli.fips.truststore;

import java.security.Provider;
import java.security.Security;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.opensearch.tools.cli.fips.truststore.ConfigurationProperties;

public class ConfigureSystemTrustStore {
    private static final String PKCS_11 = "PKCS11";
    private static final String TRUST_STORE_PASSWORD = Security.getProperty("javax.net.ssl.trustStorePassword");
    private static final String SYSTEMSTORE_PASSWORD = Objects.requireNonNullElse(TRUST_STORE_PASSWORD, "");

    public static List<Provider.Service> findPKCS11ProviderService() {
        return Arrays.stream(Security.getProviders()).filter(it -> it.getName().toUpperCase(Locale.ROOT).contains(PKCS_11)).map(it -> it.getService("KeyStore", PKCS_11)).filter(Objects::nonNull).toList();
    }

    public static ConfigurationProperties configurePKCS11TrustStore(Provider.Service pkcs11ProviderService) {
        return new ConfigurationProperties("NONE", PKCS_11, SYSTEMSTORE_PASSWORD, pkcs11ProviderService.getProvider().getName());
    }
}

