/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.io.File;
import java.io.FileOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.api.BytePoster;
import javajs.util.CU;
import javajs.util.Lst;
import javajs.util.OC;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.JFrame;
import jspecview.api.ExportInterface;
import jspecview.api.JSVFileHelper;
import jspecview.api.JSVMainPanel;
import jspecview.api.JSVPanel;
import jspecview.api.JSVPrintDialog;
import jspecview.api.JSVTree;
import jspecview.api.JSVTreeNode;
import jspecview.api.ScriptInterface;
import jspecview.api.VisibleInterface;
import jspecview.api.js.JSVAppletObject;
import jspecview.api.js.JSVToJSmolInterface;
import jspecview.common.Annotation;
import jspecview.common.ColorParameters;
import jspecview.common.Coordinate;
import jspecview.common.ExportType;
import jspecview.common.GraphSet;
import jspecview.common.JSVFileManager;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.common.PeakPickEvent;
import jspecview.common.PrintLayout;
import jspecview.common.RepaintManager;
import jspecview.common.ScaleData;
import jspecview.common.ScriptToken;
import jspecview.common.ScriptTokenizer;
import jspecview.common.Spectrum;
import jspecview.common.SyncManager;
import jspecview.dialog.DialogManager;
import jspecview.dialog.JSVDialog;
import jspecview.exception.JSVException;
import jspecview.popup.JSVGenericPopup;
import jspecview.source.JDXReader;
import jspecview.source.JDXSource;
import jspecview.tree.SimpleTree;
import org.jmol.api.GenericFileInterface;
import org.jmol.api.GenericGraphics;
import org.jmol.api.GenericPlatform;
import org.jmol.api.PlatformViewer;
import org.jmol.util.Logger;

public class JSViewer
implements PlatformViewer,
BytePoster {
    public static final String sourceLabel = "Original...";
    public static final int FILE_OPEN_OK = 0;
    public static final int FILE_OPEN_ALREADY = -1;
    public static final int FILE_OPEN_ERROR = -3;
    public static final int FILE_OPEN_NO_DATA = -4;
    public static final int OVERLAY_DIALOG = -1;
    public static final int OVERLAY_OFFSET = 99;
    public static final int PORTRAIT = 1;
    public static final int PDF_PAGE_EXISTS = 0;
    public static final int PDF_NO_SUCH_PAGE = 1;
    private static final int NLEVEL_MAX = 100;
    private static final String THIS_STRUCTURE = "<this structure>";
    private JFrame parentFrame;
    public ScriptInterface si;
    public GenericGraphics g2d;
    public JSVTree spectraTree;
    public JDXSource currentSource;
    public Lst<PanelNode> panelNodes;
    public ColorParameters parameters;
    public RepaintManager repaintManager;
    public JSVPanel selectedPanel;
    public JSVMainPanel mainPanel;
    public Properties properties;
    public Lst<String> scriptQueue;
    public JSVFileHelper fileHelper;
    public JSVGenericPopup jsvpPopupMenu;
    private DialogManager dialogManager;
    private JSVDialog viewDialog;
    private JSVDialog overlayLegendDialog;
    private Spectrum.IRMode irMode = Spectrum.IRMode.NO_CONVERT;
    public boolean isEmbedded;
    public boolean loadImaginary;
    public boolean interfaceOverlaid;
    public boolean autoIntegrate;
    public boolean autoShowLegend;
    public Boolean obscureTitleFromUser;
    public boolean allowMenu = true;
    public int initialStartIndex = -1;
    public int initialEndIndex = -1;
    public boolean isSingleThreaded;
    public boolean isApplet;
    public static boolean isJS;
    public static boolean isSwingJS;
    public boolean isSigned;
    private String recentScript = "";
    public String appletName;
    public String fullName;
    public String syncID;
    public JSVAppletObject html5Applet;
    public Object display;
    private int maximumSize = Integer.MAX_VALUE;
    private int screenHeight;
    private int screenWidth;
    private int fileCount;
    private int nViews;
    private int scriptLevelCount;
    private String integrationRatios;
    public GenericPlatform apiPlatform;
    public boolean hasDisplay;
    public static JSVToJSmolInterface jsmolObject;
    public String peakInfoModelSentToJmol;
    private boolean popupAllowMenu = true;
    private boolean popupZoomEnabled = true;
    private String defaultLoadScript;
    public float nmrMaxY = Float.NaN;
    private int recentStackPercent = 5;
    private PrintLayout lastPrintLayout;
    private String recentOpenURL = "http://";
    private String recentURL;
    public String recentSimulation = "tylenol";

    public void setParentFrame(JFrame parentFrame) {
        this.parentFrame = parentFrame;
    }

    public void setProperty(String key, String value) {
        if (this.properties != null) {
            this.properties.setProperty(key, value);
        }
    }

    public void setNode(PanelNode node) {
        if (node.jsvp != this.selectedPanel) {
            this.si.siSetSelectedPanel(node.jsvp);
        }
        this.si.siSendPanelChange();
        this.si.siNodeSet(node);
    }

    public JSViewer(ScriptInterface si, boolean isApplet, boolean isJSApplet, boolean hasDisplay) {
        this.si = si;
        this.isApplet = isApplet;
        this.hasDisplay = hasDisplay;
        isJS = isApplet && isJSApplet;
        Object jmol = null;
        jsmolObject = jmol;
        this.isSigned = si.isSigned();
        this.apiPlatform = (GenericPlatform)this.getPlatformInterface("Platform");
        this.apiPlatform.setViewer(this, this.display);
        this.g2d = (GenericGraphics)this.getPlatformInterface("G2D");
        this.spectraTree = new SimpleTree(this);
        this.parameters = (ColorParameters)this.getPlatformInterface("Parameters");
        this.parameters.setName("applet");
        this.fileHelper = ((JSVFileHelper)this.getPlatformInterface("FileHelper")).set(this);
        this.isSingleThreaded = this.apiPlatform.isSingleThreaded();
        this.panelNodes = new Lst();
        this.repaintManager = new RepaintManager(this);
        if (!isApplet) {
            this.setPopupMenu(true, true);
        }
    }

    public void setPopupMenu(boolean allowMenu, boolean zoomEnabled) {
        this.popupAllowMenu = allowMenu;
        this.popupZoomEnabled = zoomEnabled;
    }

    public void showMenu(int x, int y) {
        if (!this.popupAllowMenu) {
            return;
        }
        if (this.jsvpPopupMenu == null) {
            try {
                this.jsvpPopupMenu = (JSVGenericPopup)this.getPlatformInterface("Popup");
                this.jsvpPopupMenu.jpiInitialize(this, this.isApplet ? "appletMenu" : "appMenu");
                this.jsvpPopupMenu.setEnabled(this.popupAllowMenu, this.popupZoomEnabled);
            }
            catch (Exception e) {
                Logger.error(e + " initializing popup menu");
                return;
            }
        }
        this.jsvpPopupMenu.jpiShow(x, y);
    }

    public boolean runScriptNow(String script) {
        System.out.println(this.checkScript(script));
        int pt = script.indexOf("JSpecView:");
        if (pt >= 0) {
            script = script.substring(pt + 10);
        }
        ++this.scriptLevelCount;
        if (script == null) {
            script = "";
        }
        if ((script = script.trim()).startsWith("!")) {
            script = script.substring(1).trim();
        } else if (script.startsWith(">")) {
            Logger.error(script);
            return true;
        }
        if (script.indexOf("<PeakData") >= 0) {
            this.syncScript(script);
            return true;
        }
        Logger.info("RUNSCRIPT " + script);
        boolean isOK = true;
        int nErrorsLeft = 10;
        ScriptTokenizer commandTokens = new ScriptTokenizer(script, true);
        String msg = null;
        block55: while (commandTokens != null && commandTokens.hasMoreTokens() && nErrorsLeft > 0 && isOK) {
            String token = commandTokens.nextToken();
            ScriptTokenizer eachParam = new ScriptTokenizer(token, false);
            String key = ScriptToken.getKey(eachParam);
            if (key == null) continue;
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            try {
                block1 : switch (st) {
                    case UNKNOWN: {
                        Logger.info("Unrecognized parameter: " + key);
                        --nErrorsLeft;
                        break;
                    }
                    default: {
                        if (this.selectedPanel == null) break;
                        this.parameters.set(this.pd(), st, value);
                        this.si.siUpdateBoolean(st, Parameters.isTrue(value));
                        break;
                    }
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: 
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: {
                        this.si.siExecSetCallback(st, value);
                        break;
                    }
                    case DEFAULTLOADSCRIPT: {
                        value = PT.rep(value, "''", "\"");
                        this.defaultLoadScript = value.length() > 0 ? value : null;
                        break;
                    }
                    case DEFAULTNMRNORMALIZATION: {
                        this.nmrMaxY = PT.parseFloat(value);
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(value);
                        break;
                    }
                    case CLOSE: {
                        this.execClose(value);
                        break;
                    }
                    case DEBUG: {
                        Logger.setLogLevel(value.toLowerCase().equals("high") ? 6 : (Parameters.isTrue(value) ? 5 : 4));
                        break;
                    }
                    case GETPROPERTY: {
                        Map<String, Object> info = this.selectedPanel == null ? null : this.getPropertyAsJavaObject(value);
                        if (info == null) continue block55;
                        this.selectedPanel.showMessage(PT.toJSON(null, info), value);
                        break;
                    }
                    case HELP: {
                        this.execHelp(value);
                        break;
                    }
                    case HIDDEN: {
                        this.si.siExecHidden(Parameters.isTrue(value));
                        break;
                    }
                    case INTEGRATIONRATIOS: {
                        this.integrationRatios = value;
                        this.execIntegrate(null);
                        break;
                    }
                    case INTERFACE: {
                        this.interfaceOverlaid = this.checkOvelayInterface(value);
                        break;
                    }
                    case INTEGRALOFFSET: 
                    case INTEGRALRANGE: {
                        this.execSetIntegralParameter(st, Double.parseDouble(value));
                        break;
                    }
                    case INVERTY: {
                        this.execZoom("invertY");
                        break;
                    }
                    case JMOL: {
                        this.syncToJmol(value);
                        break;
                    }
                    case JSV: {
                        this.syncScript(PT.trimQuotes(value));
                        break;
                    }
                    case LOAD: {
                        if (value.length() == 0) {
                            if (this.defaultLoadScript == null) continue block55;
                            this.runScriptNow(this.defaultLoadScript);
                            break;
                        }
                        this.execLoad(value, (this.defaultLoadScript == null ? "" : this.defaultLoadScript + ";") + commandTokens.getRemainingScript());
                        msg = this.selectedPanel == null ? null : this.si.siLoaded(value);
                        commandTokens = null;
                        break;
                    }
                    case LOADIMAGINARY: {
                        this.loadImaginary = Parameters.isTrue(value);
                        break;
                    }
                    case PEAK: {
                        this.execPeak(value);
                        break;
                    }
                    case PEAKLIST: {
                        this.execPeakList(value);
                        break;
                    }
                    case SCALEBY: {
                        this.scaleSelectedBy(this.panelNodes, value);
                        break;
                    }
                    case SCRIPT: {
                        if (value.equals("") || value.toLowerCase().startsWith("inline")) {
                            this.execScriptInline(value);
                            break;
                        }
                        String s = JSVFileManager.getFileAsString(value);
                        if (s == null || this.scriptLevelCount >= 100) continue block55;
                        this.runScriptNow(s);
                        break;
                    }
                    case SELECT: {
                        this.execSelect(value);
                        break;
                    }
                    case SPECTRUM: 
                    case SPECTRUMNUMBER: {
                        if (this.setSpectrum(value)) continue block55;
                        isOK = false;
                        break;
                    }
                    case STACKOFFSETY: {
                        this.execOverlayOffsetY(PT.parseInt("" + PT.parseFloat(value)));
                        break;
                    }
                    case TEST: {
                        this.si.siExecTest(value);
                        break;
                    }
                    case OVERLAY: 
                    case VIEW: {
                        this.execView(value, true);
                        break;
                    }
                    case HIGHLIGHT: {
                        isOK = this.highlight(token);
                        break;
                    }
                    case FINDX: 
                    case GETSOLUTIONCOLOR: 
                    case INTEGRATION: 
                    case INTEGRATE: 
                    case IRMODE: 
                    case LABEL: 
                    case LINK: 
                    case OVERLAYSTACKED: 
                    case PRINT: 
                    case SETPEAK: 
                    case SETX: 
                    case SHIFTX: 
                    case SHOWERRORS: 
                    case SHOWINTEGRATION: 
                    case SHOWMEASUREMENTS: 
                    case SHOWMENU: 
                    case SHOWPEAKLIST: 
                    case SHOWPROPERTIES: 
                    case SHOWSOURCE: 
                    case YSCALE: 
                    case WRITE: 
                    case ZOOM: {
                        if (this.isClosed()) {
                            isOK = false;
                            break;
                        }
                        switch (st) {
                            default: {
                                break block1;
                            }
                            case FINDX: {
                                this.pd().findX(null, Double.parseDouble(value));
                                break block1;
                            }
                            case GETSOLUTIONCOLOR: {
                                this.show("solutioncolor" + value.toLowerCase());
                                break block1;
                            }
                            case INTEGRATION: 
                            case INTEGRATE: {
                                this.execIntegrate(value);
                                break block1;
                            }
                            case IRMODE: {
                                this.execIRMode(value);
                                break block1;
                            }
                            case LABEL: {
                                this.pd().addAnnotation(ScriptToken.getTokens(value));
                                break block1;
                            }
                            case LINK: {
                                this.pd().linkSpectra(PanelData.LinkMode.getMode(value));
                                break block1;
                            }
                            case OVERLAYSTACKED: {
                                this.pd().splitStack(!Parameters.isTrue(value));
                                break block1;
                            }
                            case PRINT: {
                                msg = this.execWrite(null);
                                break block1;
                            }
                            case SETPEAK: 
                            case SETX: 
                            case SHIFTX: {
                                this.execShiftSpectrum(st, token);
                                break block1;
                            }
                            case SHOWERRORS: {
                                this.show("errors");
                                break block1;
                            }
                            case SHOWINTEGRATION: {
                                this.pd().showAnnotation(Annotation.AType.Integration, Parameters.getTFToggle(value));
                                break block1;
                            }
                            case SHOWMEASUREMENTS: {
                                this.pd().showAnnotation(Annotation.AType.Measurements, Parameters.getTFToggle(value));
                                break block1;
                            }
                            case SHOWMENU: {
                                this.showMenu(Integer.MIN_VALUE, 0);
                                break block1;
                            }
                            case SHOWPEAKLIST: {
                                this.pd().showAnnotation(Annotation.AType.PeakList, Parameters.getTFToggle(value));
                                break block1;
                            }
                            case SHOWPROPERTIES: {
                                this.show("properties");
                                break block1;
                            }
                            case SHOWSOURCE: {
                                this.show("source");
                                break block1;
                            }
                            case YSCALE: {
                                this.setYScale(value);
                                break block1;
                            }
                            case WINDOW: {
                                this.si.siNewWindow(Parameters.isTrue(value), false);
                                break block1;
                            }
                            case WRITE: {
                                msg = this.execWrite(value);
                                break block1;
                            }
                            case ZOOM: 
                        }
                        isOK = this.execZoom(value);
                    }
                }
            }
            catch (Exception e) {
                msg = e.toString();
                Logger.error(e.toString());
                isOK = false;
                --nErrorsLeft;
            }
        }
        --this.scriptLevelCount;
        this.si.siExecScriptComplete(msg, true);
        return isOK;
    }

    private void execShiftSpectrum(ScriptToken st, String script) {
        Lst<String> tokens = ScriptToken.getTokens(script);
        double xOld = Double.NaN;
        double xNew = Double.NaN;
        switch (tokens.size()) {
            case 2: {
                String value = (String)tokens.get(1);
                if (value.equals("")) {
                    value = "?";
                }
                xNew = value.equalsIgnoreCase("NONE") ? Double.MAX_VALUE : (value.equalsIgnoreCase("?") ? Double.NaN : Double.parseDouble(value));
                break;
            }
            case 3: {
                xOld = Double.parseDouble((String)tokens.get(1));
                xNew = Double.parseDouble((String)tokens.get(2));
                break;
            }
            default: {
                Double.parseDouble("");
            }
        }
        int mode = 0;
        switch (st) {
            case SETPEAK: {
                mode = 1;
                break;
            }
            case SETX: {
                mode = 2;
                break;
            }
            case SHIFTX: {
                mode = 3;
                if (!Double.isNaN(xNew)) break;
                Double.parseDouble("");
                break;
            }
            default: {
                return;
            }
        }
        this.pd().shiftSpectrum(mode, xOld, xNew);
    }

    private void execClose(String value) {
        boolean fromScript;
        boolean bl = fromScript = !value.startsWith("!");
        if (!fromScript) {
            value = value.substring(1);
        }
        this.close(PT.trimQuotes(value));
        if (!fromScript || this.panelNodes.size() == 0) {
            this.si.siValidateAndRepaint(true);
        }
    }

    public boolean checkOvelayInterface(String value) {
        return value.equalsIgnoreCase("single") || value.equalsIgnoreCase("overlay");
    }

    private void execPeak(String value) {
        try {
            Lst<String> tokens = ScriptToken.getTokens(PT.rep(value, "#", "INDEX="));
            value = " type=\"" + ((String)tokens.get(0)).toUpperCase() + "\" _match=\"" + PT.trimQuotes(((String)tokens.get(1)).toUpperCase()) + "\"";
            if (tokens.size() > 2 && ((String)tokens.get(2)).equalsIgnoreCase("all")) {
                value = value + " title=\"ALL\"";
            }
            this.processPeakPickEvent(new PeakInfo(value), false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void execPeakList(String value) {
        ColorParameters p = this.parameters;
        Boolean b = Parameters.getTFToggle(value);
        if (value.indexOf("=") < 0) {
            if (!this.isClosed()) {
                this.pd().getPeakListing(null, b);
            }
        } else {
            Lst<String> tokens = ScriptToken.getTokens(value);
            double threshold = p.peakListThreshold;
            String interp = p.peakListInterpolation;
            try {
                int i = tokens.size();
                while (--i >= 0) {
                    String token = (String)tokens.get(i);
                    int pt = token.indexOf("=");
                    if (pt <= 0) continue;
                    String key = token.substring(0, pt);
                    value = token.substring(pt + 1);
                    if (key.startsWith("thr")) {
                        threshold = Double.valueOf(value);
                        continue;
                    }
                    if (!key.startsWith("int")) continue;
                    interp = value.equalsIgnoreCase("none") ? "NONE" : "parabolic";
                }
                p.peakListThreshold = threshold;
                p.peakListInterpolation = interp;
                if (!this.isClosed()) {
                    this.pd().getPeakListing(p, Boolean.TRUE);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean highlight(String value) {
        Lst<String> tokens = ScriptToken.getTokens(value);
        int n = tokens.size();
        switch (n) {
            case 3: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 2: 
            case 4: {
                if (((String)tokens.get(n - 1)).equalsIgnoreCase("OFF")) break;
            }
            default: {
                return false;
            }
        }
        if (!this.isClosed()) {
            float x1 = PT.parseFloat(n > 1 ? (String)tokens.get(1) : "");
            float x2 = PT.parseFloat(n > 2 ? (String)tokens.get(2) : "");
            int r = this.getRGB(n > 3 ? (String)tokens.get(3) : "100");
            int g = this.getRGB(n > 4 ? (String)tokens.get(4) : "100");
            int b = this.getRGB(n > 5 ? (String)tokens.get(5) : "100");
            int a = this.getRGB(n > 6 ? (String)tokens.get(6) : "100");
            if (Float.isNaN(x1) || Float.isNaN(x2)) {
                this.pd().removeAllHighlights();
            } else {
                this.pd().removeHighlight(x1, x2);
                if (a < 0) {
                    a = 150;
                }
                if (r >= 0 && g >= 0 && b >= 0) {
                    this.pd().addHighlight(null, x1, x2, null, r, g, b, a);
                }
            }
            this.repaint(true);
        }
        return true;
    }

    private int getRGB(String s) {
        float f = PT.parseFloat(s);
        return (int)(Float.isNaN(f) ? -1.0f : (f > 1.0f ? f : f * 255.0f));
    }

    private boolean execZoom(String value) {
        double x1 = 0.0;
        double x2 = 0.0;
        double y1 = 0.0;
        double y2 = 0.0;
        value = PT.rep(value, " - ", " ").replace(',', ' ');
        Lst<String> tokens = ScriptToken.getTokens(value);
        switch (tokens.size()) {
            default: {
                return false;
            }
            case 0: {
                ScaleData v = this.pd().getCurrentGraphSet().getCurrentView();
                value = (float)Math.round(v.minXOnScale * 100.0) / 100.0f + "," + (float)Math.round(v.maxXOnScale * 100.0) / 100.0f;
                value = this.selectedPanel.getInput("Enter zoom range x1 x2", "Zoom", value);
                return value == null || this.execZoom(value);
            }
            case 1: {
                value = (String)tokens.get(0);
                if (value.equalsIgnoreCase("next")) {
                    this.pd().nextView();
                } else if (value.toLowerCase().startsWith("prev")) {
                    this.pd().previousView();
                } else if (value.equalsIgnoreCase("out")) {
                    this.pd().resetView();
                } else if (value.equalsIgnoreCase("clear")) {
                    this.pd().clearAllView();
                } else if (value.equalsIgnoreCase("invertY")) {
                    this.pd().getCurrentGraphSet().invertYAxis();
                }
                return true;
            }
            case 2: {
                x1 = Double.parseDouble((String)tokens.get(0));
                x2 = Double.parseDouble((String)tokens.get(1));
                break;
            }
            case 3: {
                String xy = (String)tokens.get(0);
                if (xy.equalsIgnoreCase("X")) {
                    x1 = Double.parseDouble((String)tokens.get(1));
                    x2 = Double.parseDouble((String)tokens.get(2));
                    break;
                }
                if (!xy.equalsIgnoreCase("Y")) break;
                y1 = Double.parseDouble((String)tokens.get(1));
                y2 = Double.parseDouble((String)tokens.get(2));
                break;
            }
            case 4: {
                x1 = Double.parseDouble((String)tokens.get(0));
                y1 = Double.parseDouble((String)tokens.get(1));
                x2 = Double.parseDouble((String)tokens.get(2));
                y2 = Double.parseDouble((String)tokens.get(3));
            }
        }
        this.pd().setZoom(x1, y1, x2, y2);
        return true;
    }

    private void scaleSelectedBy(Lst<PanelNode> nodes, String value) {
        try {
            double f = Double.parseDouble(value);
            int i = nodes.size();
            while (--i >= 0) {
                ((PanelNode)nodes.get(i)).pd().scaleSelectedBy(f);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PanelData pd() {
        return this.selectedPanel == null ? null : this.selectedPanel.getPanelData();
    }

    private boolean isClosed() {
        return this.pd() == null;
    }

    private void execSelect(String value) {
        if (value.startsWith("ID ")) {
            if (!this.isClosed()) {
                try {
                    this.pd().selectSpectrum(null, "ID", PT.trimQuotes(value.substring(3)), true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return;
        }
        boolean isFirst = value.equalsIgnoreCase("first");
        boolean isLast = value.equalsIgnoreCase("last");
        if (isFirst || isLast) {
            PanelData pd = this.selectedPanel.getPanelData();
            Lst<GraphSet> gsets = pd.graphSets;
            if (gsets == null || gsets.size() == 0) {
                return;
            }
            GraphSet gs = (GraphSet)gsets.get(isFirst ? 0 : gsets.size() - 1);
            pd.setCurrentGraphSet(gs, -1);
            return;
        }
        Lst<PanelNode> nodes = this.panelNodes;
        int i = nodes.size();
        while (--i >= 0) {
            ((PanelNode)nodes.get(i)).pd().selectFromEntireSet(Integer.MIN_VALUE);
        }
        Lst<Spectrum> speclist = new Lst<Spectrum>();
        this.fillSpecList(value, speclist, false);
    }

    public void execView(String value, boolean fromScript) {
        if (value.equals("")) {
            this.checkOverlay();
            return;
        }
        Lst<Spectrum> speclist = new Lst<Spectrum>();
        String strlist = this.fillSpecList(value, speclist, true);
        if (speclist.size() > 0) {
            this.si.siOpenDataOrFile(null, strlist, speclist, strlist, -1, -1, false, null, null);
        }
        if (!fromScript) {
            this.si.siValidateAndRepaint(false);
        }
    }

    private void execIRMode(String value) {
        Spectrum.IRMode mode = Spectrum.IRMode.getMode(value);
        String type = this.pd().getSpectrum().dataType;
        int i = this.panelNodes.size();
        while (--i >= 0) {
            ((PanelNode)this.panelNodes.get(i)).pd().setIRMode(mode, type);
        }
        this.setIRmode(value);
    }

    private void execIntegrate(String value) {
        if (this.isClosed()) {
            return;
        }
        this.pd().checkIntegral(this.parameters, value);
        if (this.integrationRatios != null) {
            this.pd().setIntegrationRatios(this.integrationRatios);
        }
        this.integrationRatios = null;
        this.repaint(true);
    }

    void repaint(boolean andTaintAll) {
        this.selectedPanel.doRepaint(andTaintAll);
    }

    private void execSetIntegralParameter(ScriptToken st, double value) {
        ColorParameters p = this.parameters;
        switch (st) {
            case INTEGRALRANGE: {
                p.integralRange = value;
                break;
            }
            case INTEGRALOFFSET: {
                p.integralOffset = value;
            }
        }
        if (!this.isClosed()) {
            this.pd().checkIntegral(this.parameters, "update");
        }
    }

    private void setYScale(String value) {
        Lst<String> tokens = ScriptToken.getTokens(value);
        int pt = 0;
        boolean isAll = false;
        if (tokens.size() > 1 && ((String)tokens.get(0)).equalsIgnoreCase("ALL")) {
            isAll = true;
        }
        int n = ++pt;
        double y1 = Double.parseDouble((String)tokens.get(n));
        double y2 = Double.parseDouble((String)tokens.get(++pt));
        if (isAll) {
            Spectrum spec = this.pd().getSpectrum();
            int i = this.panelNodes.size();
            while (--i >= 0) {
                PanelNode node = (PanelNode)this.panelNodes.get(i);
                if (node.source != this.currentSource || !Spectrum.areXScalesCompatible(spec, node.getSpectrum(), false, false)) continue;
                node.pd().setZoom(0.0, y1, 0.0, y2);
            }
        } else {
            this.pd().setZoom(0.0, y1, 0.0, y2);
        }
    }

    void newStructToJmol(String data) {
        Logger.info("sending new structure to Jmol:\n" + data);
        this.syncToJmol("struct:" + data);
    }

    public void sendPanelChange() {
        PanelData pd = this.pd();
        Spectrum spec = pd.getSpectrum();
        PeakInfo pi = spec.getSelectedPeak();
        if (pi == null) {
            pi = spec.getModelPeakInfoForAutoSelectOnLoad();
        }
        if (pi == null) {
            pi = spec.getBasePeakInfo();
        }
        pd.addPeakHighlight(pi);
        Logger.info(Thread.currentThread() + "JSViewer sendFrameChange " + this.selectedPanel);
        this.notifyJmol(pi);
    }

    public Map<String, Object> getPropertyAsJavaObject(String key) {
        Hashtable<String, Object> map = new Hashtable<String, Object>();
        if ("SOURCEID".equalsIgnoreCase(key)) {
            map.put(key, this.pd() == null ? "" : this.pd().getSpectrum().sourceID);
            return map;
        }
        if (key != null && key.startsWith("DATA_")) {
            map.put(key, "" + JSVFileManager.cacheGet(key.substring(5)));
            return map;
        }
        boolean isAll = false;
        if (key != null && key.toUpperCase().startsWith("ALL ") || "all".equalsIgnoreCase(key)) {
            key = key.substring(3).trim();
            isAll = true;
        }
        if ("".equals(key)) {
            key = null;
        }
        if ("NAMES".equalsIgnoreCase(key) || "KEYS".equalsIgnoreCase(key)) {
            key = "";
        }
        Map<String, Object> map0 = this.pd().getInfo(true, key);
        if (!isAll && map0 != null) {
            return map0;
        }
        if (map0 != null) {
            map.put("current", map0);
        }
        Lst<Map<String, Object>> info = new Lst<Map<String, Object>>();
        for (int i = 0; i < this.panelNodes.size(); ++i) {
            JSVPanel jsvp = ((PanelNode)this.panelNodes.get((int)i)).jsvp;
            if (jsvp == null) continue;
            info.addLast(((PanelNode)this.panelNodes.get(i)).getInfo(key));
        }
        map.put("items", info);
        return map;
    }

    public String getCoordinate() {
        Coordinate coord;
        if (!this.isClosed() && (coord = this.pd().getClickedCoordinate()) != null) {
            return coord.getXVal() + " " + coord.getYVal();
        }
        return "";
    }

    private String fillSpecList(String value, Lst<Spectrum> speclist, boolean isView) {
        PanelNode node;
        Lst<String> list;
        SB sb;
        String prefix = "1.";
        Lst<String> list0 = null;
        boolean isNone = value.equalsIgnoreCase("NONE");
        if (isNone || value.equalsIgnoreCase("all")) {
            value = "*";
        }
        if (value.indexOf("*") < 0) {
            String[] tokens = value.split(" ");
            sb = new SB();
            for (int i = 0; i < tokens.length; ++i) {
                int pt = tokens[i].indexOf(46);
                if (pt != tokens[i].lastIndexOf(46)) {
                    tokens[i] = tokens[i].substring(0, pt + 1) + tokens[i].substring(pt + 1).replace('.', '_');
                }
                sb.append(tokens[i]).append(" ");
            }
            value = sb.toString().trim();
        }
        if (value.equals("*")) {
            list = ScriptToken.getTokens(PanelNode.getSpectrumListAsString(this.panelNodes));
        } else if (value.startsWith("\"") || value.startsWith("'")) {
            list = ScriptToken.getTokens(value);
        } else {
            value = PT.rep(value, "_", " _ ");
            value = PT.rep(value, "-", " - ");
            list = ScriptToken.getTokens(value);
            list0 = ScriptToken.getTokens(PanelNode.getSpectrumListAsString(this.panelNodes));
            if (list0.size() == 0) {
                return null;
            }
        }
        String id0 = this.isClosed() ? prefix : PanelNode.findNode((JSVPanel)this.selectedPanel, this.panelNodes).id;
        id0 = id0.substring(0, id0.indexOf(".") + 1);
        sb = new SB();
        int n = list.size();
        String idLast = null;
        for (int i = 0; i < n; ++i) {
            PanelNode node2;
            String id = (String)list.get(i);
            double userYFactor = Double.NaN;
            int isubspec = -1;
            if (i + 1 < n && ((String)list.get(i + 1)).equals("*")) {
                userYFactor = Double.parseDouble((String)list.get(i += 2));
            } else if (i + 1 < n && ((String)list.get(i + 1)).equals("_")) {
                isubspec = Integer.parseInt((String)list.get(i += 2));
            }
            if (id.equals("-")) {
                int pt;
                if (idLast == null) {
                    idLast = (String)list0.get(0);
                }
                String string = id = i + 1 == n ? (String)list0.get(list0.size() - 1) : (String)list.get(++i);
                if (!id.contains(".")) {
                    id = id0 + id;
                }
                for (pt = 0; pt < list0.size() && !((String)list0.get(pt)).equals(idLast); ++pt) {
                }
                ++pt;
                while (pt < list0.size() && !idLast.equals(id)) {
                    idLast = (String)list0.get(pt++);
                    PanelNode node3 = PanelNode.findNodeById(idLast, this.panelNodes);
                    speclist.addLast(node3.pd().getSpectrumAt(0));
                    sb.append(",").append(idLast);
                }
                continue;
            }
            if (id.startsWith("'") && id.endsWith("'")) {
                id = "\"" + PT.trim(id, "'") + "\"";
            }
            if (id.startsWith("\"")) {
                id = PT.trim(id, "\"");
                int pn = this.panelNodes.size();
                for (int j = 0; j < pn; ++j) {
                    PanelNode node4 = (PanelNode)this.panelNodes.get(j);
                    if ((node4.fileName == null || !node4.fileName.startsWith(id)) && (node4.frameTitle == null || !node4.frameTitle.startsWith(id))) continue;
                    this.addSpecToList(node4.pd(), userYFactor, -1, speclist, isView);
                    sb.append(",").append(node4.id);
                }
                continue;
            }
            if (!id.contains(".")) {
                id = id0 + id;
            }
            if ((node2 = PanelNode.findNodeById(id, this.panelNodes)) == null) continue;
            idLast = id;
            this.addSpecToList(node2.pd(), userYFactor, isubspec, speclist, isView);
            sb.append(",").append(id);
            if (isubspec <= 0) continue;
            sb.append(".").appendI(isubspec);
        }
        if (isView && speclist.size() > 0 && (node = PanelNode.findNodeById(sb.substring(1), this.panelNodes)) != null) {
            this.setNode(node);
            speclist.clear();
        }
        return isNone ? "NONE" : (sb.length() > 0 ? sb.toString().substring(1) : null);
    }

    private void addSpecToList(PanelData pd, double userYFactor, int isubspec, Lst<Spectrum> list, boolean isView) {
        if (isView) {
            Spectrum spec = pd.getSpectrumAt(0);
            spec.setUserYFactor(Double.isNaN(userYFactor) ? 1.0 : userYFactor);
            pd.addToList(isubspec - 1, list);
        } else {
            pd.selectFromEntireSet(isubspec - 1);
        }
    }

    public int getSolutionColor(boolean asFitted) {
        Spectrum spectrum = this.pd().getSpectrum();
        VisibleInterface vi = spectrum.canShowSolutionColor() ? (VisibleInterface)JSViewer.getInterface("jspecview.common.Visible") : null;
        return vi == null ? -1 : vi.getColour(spectrum, asFitted);
    }

    public int openDataOrFile(Object data, String name, Lst<Spectrum> specs, String strUrl, int firstSpec, int lastSpec, boolean isAppend, String id) {
        boolean combine;
        if ("NONE".equals(name)) {
            this.close("View*");
            return 0;
        }
        this.si.writeStatus("");
        String filePath = null;
        String newPath = null;
        String fileName = null;
        boolean isView = false;
        if (strUrl == null || strUrl.startsWith("cache://")) {
            // empty if block
        }
        GenericFileInterface file = null;
        if (data != null) {
            try {
                fileName = name;
                newPath = filePath = JSVFileManager.getFullPathName(name);
            }
            catch (JSVException jSVException) {}
        } else if (specs != null) {
            isView = true;
            fileName = filePath = "View" + ++this.nViews;
            newPath = filePath;
        } else if (strUrl != null) {
            try {
                file = this.apiPlatform.newFile(strUrl);
                URL u = new URL(JSVFileManager.appletDocumentBase, strUrl, null);
                this.recentURL = filePath = u.toString();
                fileName = JSVFileManager.getTagName(filePath);
            }
            catch (MalformedURLException e) {
                fileName = file.getName();
                newPath = filePath = file.getFullPath();
                this.recentURL = null;
            }
        }
        int pt = -1;
        pt = PanelNode.isOpen(this.panelNodes, filePath);
        if (pt >= 0 || (pt = PanelNode.isOpen(this.panelNodes, strUrl)) >= 0) {
            if (isView) {
                --this.nViews;
                this.setNode((PanelNode)this.panelNodes.get(pt));
            } else {
                this.si.writeStatus(filePath + " is already open");
            }
            return -1;
        }
        if (!isAppend && !isView) {
            this.close("all");
        }
        this.si.setCursor(3);
        try {
            this.si.siSetCurrentSource(isView ? JDXSource.createView(specs) : JDXReader.createJDXSource(file, data, filePath, this.obscureTitleFromUser == Boolean.TRUE, this.loadImaginary, firstSpec, lastSpec, this.nmrMaxY));
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error(e.toString());
            if (Logger.debugging) {
                e.printStackTrace();
            }
            this.si.writeStatus(e.getMessage());
            this.si.setCursor(0);
            if (this.isApplet) {
                this.selectedPanel.showMessage(e.toString(), "Error Opening File");
            }
            return -3;
        }
        this.si.setCursor(0);
        System.gc();
        if (newPath == null) {
            newPath = this.currentSource.getFilePath();
            if (newPath != null) {
                fileName = newPath.substring(newPath.lastIndexOf("/") + 1);
            }
        } else {
            this.currentSource.setFilePath(newPath);
        }
        if (id == null && !isView) {
            id = newPath;
        }
        if (id != null) {
            this.currentSource.setID(id);
        }
        this.si.siSetLoaded(fileName, newPath);
        Spectrum spec = this.currentSource.getJDXSpectrum(0);
        if (spec == null) {
            return -4;
        }
        specs = this.currentSource.getSpectra();
        Spectrum.process(specs, this.irMode);
        boolean autoOverlay = this.interfaceOverlaid || spec.isAutoOverlayFromJmolClick();
        boolean bl = combine = isView || autoOverlay && this.currentSource.isCompoundSource;
        if (combine) {
            this.combineSpectra(isView ? strUrl : null);
        } else {
            this.splitSpectra();
        }
        this.pd().setTaintedAll();
        if (!isView) {
            this.si.siUpdateRecentMenus(filePath);
        }
        return 0;
    }

    public void close(String value) {
        JDXSource source;
        int i;
        boolean isAll;
        int pt;
        int n0 = 0;
        int n = pt = value == null ? -2 : value.indexOf(">");
        if (pt > 0) {
            n0 = PT.parseInt(value.substring(pt + 1).trim());
            value = value.substring(0, pt).trim();
        }
        if ("*".equals(value)) {
            value = "all";
        }
        boolean bl = isAll = value == "all";
        if (value == null || n0 == 0 && value.equalsIgnoreCase("all")) {
            this.closeSource(null);
            return;
        }
        boolean isViews = value.equalsIgnoreCase("views");
        Lst<JDXSource> list = new Lst<JDXSource>();
        value = value.replace('\\', '/');
        int n2 = this.panelNodes.size();
        int nMax = n2 - n0;
        if (value.endsWith("*")) {
            value = value.substring(0, value.length() - 1);
            int i2 = n2;
            while (--i2 >= 0) {
                if (!((PanelNode)this.panelNodes.get((int)i2)).fileName.startsWith(value)) continue;
                list.addLast(((PanelNode)this.panelNodes.get((int)i2)).source);
            }
        } else if (value.equalsIgnoreCase("selected")) {
            JDXSource lastSource = null;
            i = n2;
            while (--i >= 0) {
                source = ((PanelNode)this.panelNodes.get((int)i)).source;
                if (((PanelNode)this.panelNodes.get((int)i)).isSelected && (lastSource == null || lastSource != source)) {
                    list.addLast(source);
                }
                lastSource = source;
            }
        } else if (isAll || isViews || value.equalsIgnoreCase("simulations")) {
            int n1 = 0;
            i = n2;
            while (--i >= 0 && n1 < nMax) {
                if (!isAll && !(isViews ? ((PanelNode)this.panelNodes.get((int)i)).isView : ((PanelNode)this.panelNodes.get((int)i)).isSimulation)) continue;
                list.addLast(((PanelNode)this.panelNodes.get((int)i)).source);
                ++n1;
            }
        } else {
            JDXSource jDXSource = source = value.length() == 0 ? this.currentSource : PanelNode.findSourceByNameOrId(value, this.panelNodes);
            if (source != null) {
                list.addLast(source);
            }
        }
        int i3 = list.size();
        while (--i3 >= 0) {
            this.closeSource((JDXSource)list.get(i3));
        }
        if (this.selectedPanel == null && this.panelNodes.size() > 0) {
            this.si.siSetSelectedPanel(PanelNode.getLastFileFirstNode(this.panelNodes));
        }
    }

    public void execLoad(String value, String script) {
        boolean isSimulation;
        boolean isCheck;
        boolean isAppend;
        JSVAppletObject applet = this.html5Applet;
        boolean isID = false;
        if (isID) {
            applet._search(value);
            return;
        }
        Lst<String> tokens = ScriptToken.getTokens(value);
        String filename = (String)tokens.get(0);
        String id = null;
        int pt = 0;
        if (filename.equalsIgnoreCase("ID")) {
            id = PT.trimQuotes((String)tokens.get(1));
            filename = (String)tokens.get(2);
            pt = 2;
        }
        if ((isAppend = filename.equalsIgnoreCase("APPEND")) && ++pt > 0) {
            filename = (String)tokens.get(pt);
        }
        if (isCheck = filename.equalsIgnoreCase("CHECK")) {
            ++pt;
        }
        if (pt > 0) {
            filename = (String)tokens.get(pt);
        }
        if (script == null) {
            script = this.defaultLoadScript;
        }
        if (filename.equals("?")) {
            this.openFileFromDialog(isAppend, false, null, script);
            return;
        }
        if (filename.equals("http://?")) {
            this.openFileFromDialog(isAppend, true, null, null);
            return;
        }
        if (filename.equals("$?") || filename.equals("$H1?")) {
            this.openFileFromDialog(isAppend, true, "H1", null);
            return;
        }
        if (filename.equals("$C13?")) {
            this.openFileFromDialog(isAppend, true, "C13", null);
            return;
        }
        boolean isH1 = filename.equalsIgnoreCase("MOL") || filename.equalsIgnoreCase("H1");
        boolean isC13 = filename.equalsIgnoreCase("C13");
        if (isH1 || isC13) {
            filename = "http://SIMULATION/" + (isH1 ? "H1/" : "C13/") + "MOL=" + PT.trimQuotes((String)tokens.get(++pt));
        }
        if (!isCheck && !isAppend) {
            if (filename.equals("\"\"") && this.currentSource != null) {
                filename = this.currentSource.getFilePath();
            }
            this.close("all");
        }
        if (isSimulation = (filename = PT.trimQuotes(filename)).startsWith("$")) {
            if (!filename.startsWith("$H1") && !filename.startsWith("$C13")) {
                filename = "$H1/" + filename.substring(1);
            }
            filename = "http://SIMULATION/" + filename.substring(1);
        }
        int firstSpec = pt + 1 < tokens.size() ? Integer.valueOf((String)tokens.get(++pt)) : -1;
        int lastSpec = pt + 1 < tokens.size() ? Integer.valueOf((String)tokens.get(++pt)) : firstSpec;
        this.si.siOpenDataOrFile(null, null, null, filename, firstSpec, lastSpec, isAppend, script, id);
        if (isSimulation) {
            this.close("views");
            this.execView("*", true);
        }
    }

    public void combineSpectra(String name) {
        JDXSource source = this.currentSource;
        Lst<Spectrum> specs = source.getSpectra();
        boolean haveSimulation = false;
        int i = specs.size();
        while (--i >= 0) {
            if (!((Spectrum)specs.get((int)i)).isSimulation) continue;
            haveSimulation = true;
            break;
        }
        JSVPanel jsvp = this.si.siGetNewJSVPanel2(specs);
        jsvp.setTitle(source.getTitle());
        if (jsvp.getTitle().equals("")) {
            jsvp.getPanelData().setViewTitle("");
            jsvp.setTitle(name);
        }
        this.si.siSetPropertiesFromPreferences(jsvp, true);
        ++this.fileCount;
        (new JSVPanel[1])[0] = jsvp;
        this.spectraTree.createTree((int)(this.fileCount + 1), (JDXSource)source, (JSVPanel[])new JSVPanel[1]).getPanelNode().isView = true;
        PanelNode node = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        node.setFrameTitle(name);
        node.isView = true;
        if (this.autoShowLegend && this.pd().getNumberOfGraphSets() == 1) {
            node.setLegend(this.getDialog(Annotation.AType.OverlayLegend, null));
        }
        this.si.siSetMenuEnables(node, false);
        if (haveSimulation) {
            this.pd().splitStack(true);
        }
    }

    public void closeSource(JDXSource source) {
        JSVTreeNode rootNode = this.spectraTree.getRootNode();
        String fileName = source == null ? null : source.getFilePath();
        Lst<JSVTreeNode> toDelete = new Lst<JSVTreeNode>();
        Enumeration<JSVTreeNode> enume = rootNode.children();
        while (enume.hasMoreElements()) {
            JSVTreeNode node = enume.nextElement();
            if (fileName != null && !node.getPanelNode().source.matchesFilePath(fileName)) continue;
            Logger.info("Closing " + node.getPanelNode().source.getFilePath());
            Enumeration<JSVTreeNode> e = node.children();
            while (e.hasMoreElements()) {
                JSVTreeNode childNode = e.nextElement();
                toDelete.addLast(childNode);
                this.panelNodes.removeObj(childNode.getPanelNode());
            }
            toDelete.addLast(node);
            if (fileName == null) continue;
            break;
        }
        this.spectraTree.deleteNodes(toDelete);
        if (source == null) {
            if (this.currentSource != null) {
                this.currentSource.dispose();
            }
            this.currentSource = null;
            if (this.selectedPanel != null) {
                this.selectedPanel.dispose();
            }
        }
        if (this.currentSource == source) {
            this.si.siSetSelectedPanel(null);
            this.si.siSetCurrentSource(null);
        }
        int max = 0;
        for (int i = 0; i < this.panelNodes.size(); ++i) {
            float f = PT.parseFloat(((PanelNode)this.panelNodes.get((int)i)).id);
            if (!(f >= (float)(max + 1))) continue;
            max = (int)Math.floor(f);
        }
        this.fileCount = max;
        System.gc();
        if (Logger.debugging) {
            Logger.checkMemory();
        }
        this.si.siSourceClosed(source);
    }

    public void setFrameAndTreeNode(int i) {
        if (this.panelNodes == null || i < 0 || i >= this.panelNodes.size()) {
            return;
        }
        this.setNode((PanelNode)this.panelNodes.get(i));
    }

    public PanelNode selectFrameNode(JSVPanel jsvp) {
        PanelNode node = PanelNode.findNode(jsvp, this.panelNodes);
        if (node == null) {
            return null;
        }
        this.spectraTree.setPath(this.spectraTree.newTreePath(node.treeNode.getPath()));
        return node;
    }

    private boolean setSpectrum(String value) {
        if (value.indexOf(46) >= 0) {
            PanelNode node = PanelNode.findNodeById(value, this.panelNodes);
            if (node == null) {
                return false;
            }
            this.setNode(node);
        } else {
            int n = PT.parseInt(value);
            if (n <= 0) {
                this.checkOverlay();
                return false;
            }
            this.setFrameAndTreeNode(n - 1);
        }
        return true;
    }

    public void splitSpectra() {
        JDXSource source = this.currentSource;
        Lst<Spectrum> specs = source.getSpectra();
        JSVPanel[] panels = new JSVPanel[specs.size()];
        JSVPanel jsvp = null;
        for (int i = 0; i < specs.size(); ++i) {
            Spectrum spec = (Spectrum)specs.get(i);
            jsvp = this.si.siGetNewJSVPanel(spec);
            this.si.siSetPropertiesFromPreferences(jsvp, true);
            panels[i] = jsvp;
        }
        this.spectraTree.createTree(++this.fileCount, source, panels);
        this.si.siGetNewJSVPanel(null);
        PanelNode node = PanelNode.findNode(this.selectedPanel, this.panelNodes);
        this.si.siSetMenuEnables(node, true);
    }

    public void selectedTreeNode(JSVTreeNode node) {
        if (node == null) {
            return;
        }
        if (node.isLeaf()) {
            this.setNode(node.getPanelNode());
        } else {
            System.out.println("not a leaf");
        }
        this.si.siSetCurrentSource(node.getPanelNode().source);
    }

    public void dispose() {
        this.fileHelper = null;
        if (this.viewDialog != null) {
            this.viewDialog.dispose();
        }
        this.viewDialog = null;
        if (this.overlayLegendDialog != null) {
            this.overlayLegendDialog.dispose();
        }
        this.overlayLegendDialog = null;
        if (this.jsvpPopupMenu != null) {
            this.jsvpPopupMenu.jpiDispose();
            this.jsvpPopupMenu = null;
        }
        if (this.panelNodes != null) {
            int i = this.panelNodes.size();
            while (--i >= 0) {
                ((PanelNode)this.panelNodes.get(i)).dispose();
                this.panelNodes.removeItemAt(i);
            }
        }
    }

    public void runScript(String script) {
        if (this.scriptQueue == null) {
            this.si.siProcessCommand(script);
        } else {
            this.scriptQueue.addLast(script);
        }
    }

    public void requestRepaint() {
        if (this.selectedPanel != null) {
            this.repaintManager.refresh();
        }
    }

    public void repaintDone() {
        this.repaintManager.repaintDone();
    }

    public void checkOverlay() {
        if (this.mainPanel != null) {
            this.markSelectedPanels(this.panelNodes, this.mainPanel.getCurrentPanelIndex());
        }
        this.viewDialog = this.getDialog(Annotation.AType.Views, null);
    }

    private void markSelectedPanels(Lst<PanelNode> panelNodes, int ip) {
        int i = panelNodes.size();
        while (--i >= 0) {
            ((PanelNode)panelNodes.get((int)i)).isSelected = ip == i;
        }
    }

    private void execOverlayOffsetY(int offset) {
        if (offset == Integer.MIN_VALUE) {
            if (this.selectedPanel == null) {
                return;
            }
            String soffset = this.selectedPanel.getInput("Enter a vertical offset in percent for stacked plots", "Overlay", "" + this.recentStackPercent);
            float f = PT.parseFloat(soffset);
            if (Float.isNaN(f)) {
                return;
            }
            offset = (int)f;
        }
        this.recentStackPercent = offset;
        this.parameters.viewOffset = offset;
        if (this.isClosed()) {
            this.pd().setYStackOffsetPercent(offset);
        }
    }

    private void execScriptInline(String script) {
        if (script.length() > 0) {
            script = script.substring(6).trim();
        }
        if (script.length() == 0) {
            script = this.selectedPanel.getInput("Enter a JSpecView script", "Script", this.recentScript);
        }
        if (script == null) {
            return;
        }
        this.recentScript = script;
        this.runScriptNow(script);
    }

    public void setDisplay(Object canvas) {
        this.display = canvas;
        this.apiPlatform.setViewer(this, this.display);
        int[] wh = new int[2];
        this.apiPlatform.getFullScreenDimensions(canvas, wh);
        this.setScreenDimension(wh[0], wh[1]);
    }

    public void setScreenDimension(int width, int height) {
        height = Math.min(height, this.maximumSize);
        if (this.screenWidth == (width = Math.min(width, this.maximumSize)) && this.screenHeight == height) {
            return;
        }
        this.resizeImage(width, height);
    }

    void resizeImage(int width, int height) {
        if (width > 0) {
            this.screenWidth = width;
            this.screenHeight = height;
        } else {
            width = this.screenWidth == 0 ? (this.screenWidth = 500) : this.screenWidth;
            height = this.screenHeight == 0 ? (this.screenHeight = 500) : this.screenHeight;
        }
        this.g2d.setWindowParameters(width, height);
    }

    public void updateJS() {
        if (this.selectedPanel != null) {
            this.selectedPanel.paintComponent(this.apiPlatform.getGraphics(null));
        }
    }

    public boolean processMouseEvent(int id, int x, int y, int modifiers, long time) {
        return this.selectedPanel != null && this.selectedPanel.processMouseEvent(id, x, y, modifiers, time);
    }

    public void processTwoPointGesture(float[][][] touches) {
        if (!this.isClosed()) {
            this.selectedPanel.processTwoPointGesture(touches);
        }
    }

    public void processKeyEvent(Object event) {
        if (!this.isClosed()) {
            this.selectedPanel.processKeyEvent(event);
        }
    }

    public JSVAppletObject getApplet() {
        return this.html5Applet;
    }

    public void openFileAsyncSpecial(String fileName, int flags) {
        String ans;
        String string = ans = this.currentSource == null ? "NO" : this.getDialogManager().getDialogInput(this, "Do you want to append this file? (Answer NO to replace.)", "Drag/Drop Action", 3, null, null, "YES");
        if (ans == null) {
            return;
        }
        String pre = ans.toLowerCase().startsWith("y") ? "append" : "";
        String post = pre == "" ? "" : "; view *";
        this.runScript("load " + pre + " \"" + fileName + "\"" + post);
    }

    public int getHeight() {
        return this.screenHeight;
    }

    public int getWidth() {
        return this.screenWidth;
    }

    public Object getPlatformInterface(String type) {
        return JSViewer.getInterface("jspecview." + (isJS ? "js2d.Js" : "java.Awt") + type);
    }

    public DialogManager getDialogManager() {
        if (this.dialogManager != null) {
            return this.dialogManager;
        }
        this.dialogManager = (DialogManager)this.getPlatformInterface("DialogManager");
        return this.dialogManager.set(this);
    }

    public JSVDialog getDialog(Annotation.AType type, Spectrum spec) {
        String root = "jspecview.dialog.";
        switch (type) {
            case Integration: {
                return ((JSVDialog)JSViewer.getInterface(root + "IntegrationDialog")).setParams("Integration for " + spec, this, spec);
            }
            case Measurements: {
                return ((JSVDialog)JSViewer.getInterface(root + "MeasurementsDialog")).setParams("Measurements for " + spec, this, spec);
            }
            case PeakList: {
                return ((JSVDialog)JSViewer.getInterface(root + "PeakListDialog")).setParams("Peak List for " + spec, this, spec);
            }
            case OverlayLegend: {
                this.overlayLegendDialog = ((JSVDialog)JSViewer.getInterface(root + "OverlayLegendDialog")).setParams(this.pd().getViewTitle(), this, null);
                return this.overlayLegendDialog;
            }
            case Views: {
                this.viewDialog = ((JSVDialog)JSViewer.getInterface(root + "ViewsDialog")).setParams("View/Combine/Close Spectra", this, null);
                return this.viewDialog;
            }
        }
        return null;
    }

    private void show(String what) {
        this.getDialogManager();
        if (what.equals("properties")) {
            this.dialogManager.showProperties(null, this.pd().getSpectrum());
        } else if (what.equals("errors")) {
            this.dialogManager.showSourceErrors(null, this.currentSource);
        } else if (what.equals("source")) {
            if (this.currentSource == null) {
                if (this.panelNodes.size() > 0) {
                    this.dialogManager.showMessageDialog(null, "Please Select a Spectrum", "Select Spectrum", 0);
                }
                return;
            }
            this.dialogManager.showSource(this, this.pd().getSpectrum());
        } else if (what.startsWith("solutioncolorfill")) {
            if (what.indexOf("all") >= 0) {
                int i = this.panelNodes.size();
                while (--i >= 0) {
                    ((PanelNode)this.panelNodes.get(i)).pd().setSolutionColor(what);
                }
            } else {
                this.pd().setSolutionColor(what);
            }
        } else if (what.startsWith("solutioncolor")) {
            String msg = this.getSolutionColorStr(what.indexOf("false") < 0);
            msg = "background-color:rgb(" + msg + ")'><br />Predicted Solution Colour- RGB(" + msg + ")<br /><br />";
            if (isJS) {
                this.dialogManager.showMessage(this, "<div style='width:100%;height:100%;" + msg + "</div>", "Predicted Colour");
            } else {
                this.selectedPanel.showMessage("<html><body style='" + msg + "</body></html>", "Predicted Colour");
            }
        }
    }

    public PrintLayout getPrintLayout(boolean isJob) {
        if (!isJS && this.hasDisplay) {
            try {
                PrintLayout pl = ((JSVPrintDialog)this.getPlatformInterface("PrintDialog")).set(this.parentFrame, this.lastPrintLayout, isJob).getPrintLayout();
                if (pl != null) {
                    this.lastPrintLayout = pl;
                }
                return pl;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PrintLayout(this.pd());
    }

    public void setIRmode(String mode) {
        this.irMode = mode.equals("AtoT") ? Spectrum.IRMode.TO_TRANS : (mode.equals("TtoA") ? Spectrum.IRMode.TO_ABS : Spectrum.IRMode.getMode(mode));
    }

    public int getOptionFromDialog(String[] items, String title, String label) {
        return this.getDialogManager().getOptionFromDialog(null, items, this.selectedPanel, title, label);
    }

    public String print(String fileName) {
        return this.execWrite("PDF \"" + fileName + "\"");
    }

    private String execWrite(String value) {
        if (isJS && value == null) {
            value = "PDF";
        }
        String msg = ((ExportInterface)JSViewer.getInterface("jspecview.export.Exporter")).write(this, value == null ? null : ScriptToken.getTokens(value), false);
        this.si.writeStatus(msg);
        return msg;
    }

    public String export(String type, int n) {
        if (type == null) {
            type = "XY";
        }
        PanelData pd = this.pd();
        int nMax = pd.getNumberOfSpectraInCurrentSet();
        if (n < -1 || n >= nMax) {
            return "Maximum spectrum index (0-based) is " + (nMax - 1) + ".";
        }
        Spectrum spec = n < 0 ? pd.getSpectrum() : pd.getSpectrumAt(n);
        try {
            return ((ExportInterface)JSViewer.getInterface("jspecview.export.Exporter")).exportTheSpectrum(this, ExportType.getType(type), null, spec, 0, spec.getXYCoords().length - 1, null, type.equalsIgnoreCase("PDF"));
        }
        catch (Exception e) {
            Logger.error(e.toString());
            return null;
        }
    }

    @Override
    public String postByteArray(String fileName, byte[] bytes) {
        return JSVFileManager.postByteArray(fileName, bytes);
    }

    public OC getOutputChannel(String fileName, boolean isBinary) throws Exception {
        FileOutputStream os = null;
        os = fileName == null || fileName.equals(";base64,") ? null : new FileOutputStream(fileName);
        return new OC().setParams(this, fileName, !isBinary, os);
    }

    public static Object getInterface(String name) {
        try {
            Class<?> x = Class.forName(name);
            return x == null ? null : x.newInstance();
        }
        catch (Exception e) {
            Logger.error("Interface.java Error creating instance for " + name + ": \n" + e);
            return null;
        }
    }

    public void showMessage(String msg) {
        if (this.selectedPanel != null && msg != null) {
            this.selectedPanel.showMessage(msg, null);
        }
    }

    public boolean openFileFromDialog(boolean isAppend, boolean isURL, String simulationType, String script) {
        String url = null;
        if (simulationType != null) {
            url = this.fileHelper.getUrlFromDialog("Enter the name or identifier of a compound", this.recentSimulation);
            if (url == null) {
                return false;
            }
            this.recentSimulation = url;
            if (url.equals(THIS_STRUCTURE)) {
                if (this.isEmbedded) {
                    this.syncToJmol("sync . \"" + simulationType + "Simulate:\";");
                    return true;
                }
                return false;
            }
            url = "$" + simulationType + "/" + url;
        } else if (isURL) {
            url = this.fileHelper.getUrlFromDialog("Enter the URL of a JCAMP-DX File", this.recentURL == null ? this.recentOpenURL : this.recentURL);
            if (url == null) {
                return false;
            }
            this.recentOpenURL = url;
        } else {
            Object[] userData = new Object[]{isAppend, script};
            GenericFileInterface file = this.fileHelper.showFileOpenDialog(this.mainPanel, userData);
            if (file != null) {
                url = file.getFullPath();
            }
        }
        if (url != null) {
            this.runScriptNow("load " + (isAppend ? "APPEND " : "") + "\"" + url + "\"" + (script == null ? "" : ";" + script));
            return true;
        }
        return false;
    }

    public void openFile(String fileName, boolean closeFirst) {
        JDXSource source;
        if (closeFirst && this.panelNodes != null && (source = PanelNode.findSourceByNameOrId(new File(fileName).getAbsolutePath(), this.panelNodes)) != null) {
            this.closeSource(source);
        }
        this.si.siOpenDataOrFile(null, null, null, fileName, -1, -1, true, this.defaultLoadScript, null);
    }

    public int selectPanel(JSVPanel jsvp, Lst<PanelNode> panelNodes) {
        int iPanel = -1;
        if (panelNodes != null) {
            int i = panelNodes.size();
            while (--i >= 0) {
                JSVPanel j = ((PanelNode)panelNodes.get((int)i)).jsvp;
                if (j == jsvp) {
                    iPanel = i;
                    continue;
                }
                j.setEnabled(false);
                j.setFocusable(false);
                j.getPanelData().closeAllDialogsExcept(Annotation.AType.NONE);
            }
            this.markSelectedPanels(panelNodes, iPanel);
            this.selectedPanel = jsvp;
            if (jsvp != null) {
                jsvp.getPanelData().clearMouseSet(null);
            }
        }
        return iPanel;
    }

    public void checkAutoIntegrate() {
        if (this.autoIntegrate) {
            this.pd().integrateAll(this.parameters);
        }
    }

    public void parseInitScript(String params) {
        if (params == null) {
            params = "";
        }
        ScriptTokenizer allParamTokens = new ScriptTokenizer(params, true);
        if (Logger.debugging) {
            Logger.info("Running in DEBUG mode");
        }
        block16: while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            ScriptTokenizer eachParam = new ScriptTokenizer(token, false);
            String key = eachParam.nextToken();
            if (key.equalsIgnoreCase("SET")) {
                key = eachParam.nextToken();
            }
            key = key.toUpperCase();
            ScriptToken st = ScriptToken.getScriptToken(key);
            String value = ScriptToken.getValue(st, eachParam, token);
            Logger.info("KEY-> " + key + " VALUE-> " + value + " : " + (Object)((Object)st));
            try {
                switch (st) {
                    default: {
                        this.parameters.set(null, st, value);
                        break;
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case APPLETID: {
                        this.appletName = value;
                        this.fullName = this.appletName + "__" + this.appletName + "__";
                        Object applet = null;
                        this.html5Applet = applet;
                        break;
                    }
                    case AUTOINTEGRATE: {
                        this.autoIntegrate = Parameters.isTrue(value);
                        break;
                    }
                    case COMPOUNDMENUON: {
                        break;
                    }
                    case PEAKCALLBACKFUNCTIONNAME: 
                    case SYNCCALLBACKFUNCTIONNAME: 
                    case COORDCALLBACKFUNCTIONNAME: 
                    case LOADFILECALLBACKFUNCTIONNAME: 
                    case APPLETREADYCALLBACKFUNCTIONNAME: {
                        this.si.siExecSetCallback(st, value);
                        break;
                    }
                    case ENDINDEX: {
                        this.initialEndIndex = Integer.parseInt(value);
                        break;
                    }
                    case INTERFACE: {
                        this.checkOvelayInterface(value);
                        break;
                    }
                    case IRMODE: {
                        this.setIRmode(value);
                        break;
                    }
                    case MENUON: {
                        this.allowMenu = Boolean.parseBoolean(value);
                        break;
                    }
                    case OBSCURE: {
                        if (this.obscureTitleFromUser != null) continue block16;
                        this.obscureTitleFromUser = Boolean.valueOf(value);
                        break;
                    }
                    case STARTINDEX: {
                        this.initialStartIndex = Integer.parseInt(value);
                        break;
                    }
                    case SYNCID: {
                        this.syncID = value;
                        this.fullName = this.appletName + "__" + this.syncID + "__";
                        break;
                    }
                }
            }
            catch (Exception exception) {}
        }
    }

    public String getSolutionColorStr(boolean asFit) {
        P3 pt = CU.colorPtFromInt(this.getSolutionColor(asFit), null);
        return (int)pt.x + "," + (int)pt.y + "," + (int)pt.z;
    }

    public String checkCommandLineForTip(char c, String cmd, boolean oneLineOnly) {
        String tip;
        boolean isHelp;
        boolean bl = isHelp = c == '\u0001';
        if (!isHelp && c != '\u0000') {
            if (c != '\t' && (c == '\n' || c < ' ' || c > '~')) {
                return null;
            }
            cmd = cmd + (Character.isISOControl(c) ? "" : "" + c);
        }
        if (cmd.indexOf(";") >= 0) {
            cmd = cmd.substring(cmd.lastIndexOf(";") + 1);
        }
        String ret = null;
        while (cmd.startsWith(" ")) {
            cmd = cmd.substring(1);
        }
        if (cmd.length() == 0 && !isHelp) {
            tip = "";
        } else {
            Lst<String> tokens = ScriptToken.getTokens(cmd);
            if (tokens.size() == 0 && !isHelp) {
                return "";
            }
            boolean isExact = cmd.endsWith(" ") || tokens.size() > 1 && oneLineOnly;
            Lst<ScriptToken> list = ScriptToken.getScriptTokenList(tokens.size() == 0 ? null : (String)tokens.get(0), isExact);
            switch (list.size()) {
                case 0: {
                    tip = "?";
                    break;
                }
                case 1: {
                    ScriptToken st = (ScriptToken)((Object)list.get(0));
                    tip = st.getTip();
                    try {
                        tip = tip.indexOf("TRUE") >= 0 ? " (" + this.parameters.getBoolean(st) + ")" : (st.name().indexOf("COLOR") >= 0 ? " (" + CU.toRGBHexString(this.parameters.getElementColor(st)) + ")" : "");
                    }
                    catch (Exception e) {
                        return null;
                    }
                    if (c == '\t' || isExact || !oneLineOnly) {
                        tip = st.name() + " " + st.getTip() + tip + " " + st.getDescription();
                        if (c != '\t') break;
                        ret = st.name() + " ";
                        break;
                    }
                    tip = st.name() + " " + tip;
                    break;
                }
                default: {
                    tip = ScriptToken.getNameList(list);
                }
            }
        }
        if (oneLineOnly) {
            this.si.writeStatus(tip);
        } else {
            ret = tip;
        }
        return ret;
    }

    public String checkScript(String script) {
        return this.checkCommandLineForTip('\u0000', script, false);
    }

    private void execHelp(String value) {
        String s = this.checkCommandLineForTip('\u0001', value, false);
        if (s.indexOf(" ") < 0 && s.indexOf(",") > 0) {
            Object[] tokens = PT.split(s, ",");
            Arrays.sort(tokens);
            s = "";
            for (int i = 0; i < tokens.length; ++i) {
                ScriptToken st = ScriptToken.getScriptToken((String)tokens[i]);
                s = s + (String)tokens[i] + " " + st.getTip() + "\n  " + st.getDescription() + "\n\n";
            }
            this.getDialogManager().showMessage(null, s, "HELP " + value);
        } else {
            this.selectedPanel.showMessage(s, "Help " + value);
        }
        System.out.println(s);
    }

    public void setRecentSimulation(String name) {
        if (name == null) {
            name = THIS_STRUCTURE;
        }
        this.recentSimulation = name;
    }

    public void setCreatingImage(boolean isSaving) {
        this.pd().creatingImage = isSaving;
    }

    boolean checkFileAlreadyLoaded(String fileName) {
        if (this.isClosed()) {
            return false;
        }
        if (this.pd().hasFileLoaded(fileName)) {
            return true;
        }
        int i = this.panelNodes.size();
        while (--i >= 0) {
            if (!((PanelNode)this.panelNodes.get(i)).pd().hasFileLoaded(fileName)) continue;
            this.si.siSetSelectedPanel(((PanelNode)this.panelNodes.get((int)i)).jsvp);
            return true;
        }
        return false;
    }

    public void processPeakPickEvent(Object eventObj, boolean isApp) {
        PeakInfo pi;
        if (eventObj instanceof PeakInfo) {
            pi = (PeakInfo)eventObj;
            PeakInfo pi2 = this.pd().findMatchingPeakInfo(pi);
            if (pi2 == null) {
                if (!"ALL".equals(pi.getTitle())) {
                    return;
                }
                PanelNode node = null;
                for (int i = 0; i < this.panelNodes.size(); ++i) {
                    pi2 = ((PanelNode)this.panelNodes.get(i)).pd().findMatchingPeakInfo(pi);
                    if (pi2 == null) continue;
                    node = (PanelNode)this.panelNodes.get(i);
                    break;
                }
                if (node == null) {
                    return;
                }
                this.setNode(node);
            }
            pi = pi2;
        } else {
            PeakPickEvent e = (PeakPickEvent)eventObj;
            this.si.siSetSelectedPanel((JSVPanel)e.getSource());
            pi = e.getPeakInfo();
        }
        this.pd().addPeakHighlight(pi);
        this.notifyJmol(pi);
        if (pi.isClearAll()) {
            this.repaint(false);
        } else {
            this.pd().selectSpectrum(pi.getFilePath(), pi.getType(), pi.getModel(), true);
        }
        this.si.siCheckCallbacks(pi.getTitle());
    }

    public void syncScript(String peakScript) {
        SyncManager.syncFromJmol(this, peakScript);
    }

    private void syncToJmol(String msg) {
        this.si.syncToJmol(msg);
    }

    private void notifyJmol(PeakInfo pi) {
        this.repaint(true);
        SyncManager.syncToJmol(this, pi);
    }

    static {
        isSwingJS = false;
    }
}

