import { jsxs, jsx } from 'react/jsx-runtime';
import { css, cx } from '@emotion/css';
import { useState } from 'react';
import '@grafana/data';
import { useStyles2, Select, SelectContainer as SelectContainer$1 } from '@grafana/ui';

function InlineSelect({ label: labelProp, ...props }) {
  const [id] = useState(() => Math.random().toString(16).slice(2));
  const styles = useStyles2(getSelectStyles);
  const components = {
    SelectContainer,
    ValueContainer,
    SingleValue: ValueContainer
  };
  return /* @__PURE__ */ jsxs("div", { className: styles.root, children: [
    labelProp && /* @__PURE__ */ jsxs("label", { className: styles.label, htmlFor: id, children: [
      labelProp,
      ":",
      "\xA0"
    ] }),
    /* @__PURE__ */ jsx(Select, { openMenuOnFocus: true, inputId: id, ...props, components })
  ] });
}
const SelectContainer = (props) => {
  const { children } = props;
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsx(SelectContainer$1, { ...props, className: cx(props.className, styles.container), children });
};
const ValueContainer = (props) => {
  const { className, children } = props;
  const styles = useStyles2(getSelectStyles);
  return /* @__PURE__ */ jsx("div", { className: cx(className, styles.valueContainer), children });
};
const getSelectStyles = (theme) => ({
  root: css({
    display: "flex",
    fontSize: 12,
    alignItems: "center"
  }),
  label: css({
    color: theme.colors.text.secondary,
    whiteSpace: "nowrap"
  }),
  container: css({
    background: "none",
    borderColor: "transparent"
  }),
  valueContainer: css({
    display: "flex",
    alignItems: "center",
    flex: "initial",
    color: theme.colors.text.secondary,
    fontSize: 12
  })
});

export { InlineSelect };
//# sourceMappingURL=InlineSelect.js.map
