import { jsxs, jsx } from 'react/jsx-runtime';
import { useState } from 'react';
import { css } from '@emotion/css';
import { useTheme2, IconButton } from '@grafana/ui';

const GenericConfigSection = ({
  children,
  title,
  description,
  isCollapsible = false,
  isInitiallyOpen = true,
  kind = "section",
  className
}) => {
  const { colors, typography, spacing } = useTheme2();
  const [isOpen, setIsOpen] = useState(isCollapsible ? isInitiallyOpen : true);
  const iconName = isOpen ? "angle-up" : "angle-down";
  const isSubSection = kind === "sub-section";
  const collapsibleButtonAriaLabel = `${isOpen ? "Collapse" : "Expand"} section ${title}`;
  const styles = {
    header: css({
      display: "flex",
      justifyContent: "space-between",
      alignItems: "center"
    }),
    title: css({
      margin: 0
    }),
    subtitle: css({
      margin: 0,
      fontWeight: typography.fontWeightRegular
    }),
    descriptionText: css({
      marginTop: spacing(isSubSection ? 0.25 : 0.5),
      marginBottom: 0,
      ...typography.bodySmall,
      color: colors.text.secondary
    }),
    content: css({
      marginTop: spacing(2)
    })
  };
  return /* @__PURE__ */ jsxs("div", { className, children: [
    /* @__PURE__ */ jsxs("div", { className: styles.header, children: [
      kind === "section" ? /* @__PURE__ */ jsx("h3", { className: styles.title, children: title }) : /* @__PURE__ */ jsx("h6", { className: styles.subtitle, children: title }),
      isCollapsible && /* @__PURE__ */ jsx(
        IconButton,
        {
          name: iconName,
          onClick: () => setIsOpen(!isOpen),
          type: "button",
          size: "xl",
          "aria-label": collapsibleButtonAriaLabel
        }
      )
    ] }),
    description && /* @__PURE__ */ jsx("p", { className: styles.descriptionText, children: description }),
    isOpen && /* @__PURE__ */ jsx("div", { className: styles.content, children })
  ] });
};

export { GenericConfigSection };
//# sourceMappingURL=GenericConfigSection.js.map
