import React from 'react';
import { useTheme2, Divider as Divider$1 } from '@grafana/ui';
import { config } from '@grafana/runtime';
import { isVersionGtOrEq } from './utils/version.js';

function Divider() {
  const theme = useTheme2();
  if (isVersionGtOrEq(config.buildInfo.version, "10.1.0")) {
    return /* @__PURE__ */ React.createElement(Divider$1, null);
  }
  return /* @__PURE__ */ React.createElement(
    "div",
    {
      style: { borderTop: `1px solid ${theme.colors.border.weak}`, margin: theme.spacing(2, 0), width: "100%" }
    }
  );
}

export { Divider };
//# sourceMappingURL=Divider.js.map
