/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import java.io.File;
import tim.prune.function.filesleuth.SearchResult;
import tim.prune.function.filesleuth.data.DateRange;
import tim.prune.function.filesleuth.data.LocationFilter;
import tim.prune.function.filesleuth.data.TrackContents;
import tim.prune.function.filesleuth.data.TrackFileStatus;

public class TrackFile {
    private final File _file;
    private final String _pathString;
    private TrackFileStatus _status;
    private TrackContents _contents = null;
    private int _index = 0;

    public TrackFile(File file) {
        this._file = file;
        this._pathString = file.getAbsolutePath().toLowerCase().trim();
        this._status = TrackFileStatus.FOUND;
    }

    public File getFile() {
        return this._file;
    }

    public TrackFileStatus getStatus() {
        return this._status;
    }

    public void setStatus(TrackFileStatus trackFileStatus) {
        this._status = trackFileStatus;
    }

    public void setContents(TrackContents trackContents) {
        this._contents = trackContents;
    }

    public boolean hasContents() {
        return this._contents != null;
    }

    public String getNameOrDescription() {
        return this.hasContents() ? this._contents.getNameOrDescription() : "";
    }

    public boolean matchesFilename(String string) {
        if (string == null || string.equals("")) {
            return true;
        }
        return this._pathString.contains(string);
    }

    public boolean matchesStringFilter(String string, SearchResult searchResult) {
        searchResult.setContents(this._contents == null ? "" : this._contents.getNameOrDescription());
        if (string == null || string.equals("")) {
            return true;
        }
        if (this._contents != null && this._contents.getNumStrings() > 0) {
            for (String string2 : this._contents.getStrings()) {
                if (!string2.contains(string)) continue;
                searchResult.setIsMatch(true);
                searchResult.setContents(string2);
                return true;
            }
        }
        return false;
    }

    public boolean matchesDateFilter(DateRange dateRange) {
        return this._contents == null || this._contents.matchesDateFilter(dateRange);
    }

    public void setIndex(int n) {
        this._index = n;
    }

    public int getIndex() {
        return this._index;
    }

    public boolean matchesLocationFilter(LocationFilter locationFilter) {
        return this._contents == null || this._contents.matchesLocationFilter(locationFilter);
    }
}

