---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: DASTプロファイル
---

{{< details >}}

- プラン: Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

DASTサイトプロファイルとスキャナープロファイルは、アプリケーションと、アプリケーションの評価に使用するスキャナーに関する情報を保存します。プロファイルを定義すると、パイプラインおよびオンデマンドのDASTジョブに使用できます。

DASTプロファイル、DASTスキャナープロファイル、DASTサイトプロファイルの作成、更新、削除は、[監査ログ](../../../administration/compliance/audit_event_reports.md)に含まれています。

## サイトプロファイル {#site-profile}

{{< history >}}

- サイトプロファイルの機能、スキャン方法、およびファイルURLは、GitLab 15.6で[GitLab.comおよびGitLab Self-Managedで有効になりました](https://gitlab.com/gitlab-org/gitlab/-/issues/345837)。
- GraphQLエンドポイントパス機能は、GitLab 15.7で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/issues/378692)。
- 追加変数は、GitLab 17.9で[導入されました](https://gitlab.com/gitlab-org/gitlab/-/merge_requests/177703)。

{{< /history >}}

サイトプロファイルは、DASTでスキャンされるデプロイされたアプリケーション、ウェブサイト、またはAPIの属性と設定の詳細を定義します。

サイトプロファイルの内容:

- **プロファイル名**: スキャン対象のサイトに割り当てる名前。サイトプロファイルは`.gitlab-ci.yml`またはオンデマンドスキャンのいずれかで参照されますが、名前を変更することは**不可能**。
- **サイトタイプ**: スキャン対象のターゲットのタイプ（ウェブサイトまたはAPIスキャン）。
- **ターゲットURL**: DASTが実行されるURL。
- **除外URL**: スキャンから除外するURLのカンマ区切りリスト。[RE2形式の正規表現](https://github.com/google/re2/wiki/Syntax)を使用できます。これは有効なURL文字であるため、正規表現に疑問符（`?`）を含めることはできません。
- **リクエストヘッダー**: 名前と値を含む、HTTPリクエストヘッダーのカンマ区切りリスト。これらのヘッダーは、DASTによって行われたすべてのリクエストに追加されます。
- **認証**:
  - **Authenticated URL**（認証済みURL）: ターゲットウェブサイト上のサインインHTMLフォームを含むページのURL。認証されたスキャンを作成するために、ユーザー名とパスワードがログインフォームとともに送信されます。
  - **ユーザー名**: ウェブサイトへの認証に使用されるユーザー名。
  - **パスワード**: ウェブサイトへの認証に使用されるパスワード。
  - **ユーザー名フォームフィールド**: サインインHTMLフォームのユーザー名フィールドの名前。
  - **パスワードフォームフィールド**: サインインHTMLフォームのパスワードフィールドの名前。
  - **Submit form field**（フォームフィールドを送信）: サインインHTMLフォームを送信するときに選択される要素の`id`または`name`。

- **スキャンモード**: APIテストを実行する方法のタイプ。サポートされているメソッドは、OpenAPI、Postmanコレクション、HTTPアーカイブ（HAR）、またはGraphQLです。
  - **GraphQLエンドポイントパス**: GraphQLエンドポイントへのパス。このパスは、テストするスキャンのURIを提供するために、ターゲットURLと連結されます。GraphQLエンドポイントは、イントロスペクションクエリをサポートする必要があります。
  - **File URL**（ファイルURL）: OpenAPI、Postmanコレクション、またはHTTPアーカイブファイルのURL。
- **追加変数**: 特定のスキャン動作を設定するための環境変数のリスト。これらの変数は、タイムアウトの設定、認証成功URLの追加、高度なスキャン機能の有効化など、パイプラインベースのDASTスキャンと同じ設定オプションを提供します。

APIサイトタイプが選択されている場合、ホストのオーバーライドを使用して、スキャンされるAPIがターゲットと同じホスト上にあることを確認します。これは、間違ったAPIに対してアクティブなスキャンを実行するリスクを軽減するために行われます。

設定すると、リクエストヘッダーとパスワードフィールドは、データベースに保存される前に[`aes-256-gcm`](https://en.wikipedia.org/wiki/Advanced_Encryption_Standard)を使用して暗号化された状態になります。このデータは、有効なシークレットファイルでのみ、読み取りおよび復号化できます。

`.gitlab-ci.yml`およびオンデマンドスキャンでサイトプロファイルを参照できます。

```yaml
stages:
  - dast

include:
  - template: DAST.gitlab-ci.yml

dast:
  stage: dast
  dast_configuration:
    site_profile: "<profile name>"
```

### サイトプロファイルの検証 {#site-profile-validation}

サイトプロファイルの検証は、間違ったウェブサイトに対してアクティブなスキャンを実行するリスクを軽減します。オンデマンドスキャンを実行するには、サイトを検証する必要があります。

サイトプロファイルの検証はセキュリティ機能ではありません。必要に応じて、[パイプラインスキャン](browser/configuration/enabling_the_analyzer.md)を使用して、検証されていないサイトに対してDASTを実行できます。

サイトのすべての検証方法の機能は同等であるため、最適な方法を使用してください:

- **テキストファイルの検証**: テキストファイルをターゲットサイトにアップロードする必要があります。テキストファイルには、プロジェクトに固有の名前とコンテンツが割り当てられています。検証プロセスでは、ファイルの内容がチェックされます。
- **ヘッダーの検証**: プロジェクトに固有の値を持つヘッダー`Gitlab-On-Demand-DAST`をターゲットサイトに追加する必要があります。検証プロセスでは、ヘッダーが存在することと、その値がチェックされます。
- **メタタグの検証**: プロジェクトに固有の値を持つ、`gitlab-dast-validation`という名前のメタタグをターゲットサイトに追加する必要があります。ページの`<head>`セクションに追加されていることを確認してください。検証プロセスでは、メタタグが存在することと、その値がチェックされます。

### サイトプロファイルの作成 {#create-a-site-profile}

サイトプロファイルを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **新しい**>**サイトプロファイル**を選択します。
1. フィールドに入力し、**プロファイルの保存**を選択します。

サイトプロファイルが保存され、オンデマンドスキャンで使用できるようになります。

### サイトプロファイルの編集 {#edit-a-site-profile}

スキャンの前にサイトプロファイルを編集して、設定を変更します。

サイトプロファイルがセキュリティポリシーにリンクされている場合、このページからプロファイルを編集することはできません。詳細については、[スキャン実行ポリシー](../policies/scan_execution_policies.md)を参照してください。

サイトの検証パイプラインをアクティブ化するには、`dast-validation-runner`というタグを持つRunnerを定義するか、タグなしのジョブを実行できるRunnerを定義する必要があります。

前提要件: 

- DASTスキャンでプロファイルを使用している場合は、スキャンに関連付けられているブランチにプッシュできる必要があります。

サイトプロファイルを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **Site Profiles**（サイトプロファイル）タブを選択します。
1. プロファイルの行で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）メニューを選択し、**編集**を選択します。
1. フィールドを編集し、**プロファイルの保存**を選択します。

サイトプロファイルのターゲットまたは認証されたURLが更新された場合、そのプロファイルに関連付けられているリクエストヘッダーとパスワードフィールドはクリアされます。

### サイトプロファイルの削除 {#delete-a-site-profile}

前提要件: 

- DASTスキャンでプロファイルを使用している場合は、スキャンに関連付けられているブランチにプッシュできる必要があります。

{{< alert type="note" >}}

サイトプロファイルがセキュリティポリシーにリンクされている場合、ユーザーはこのページからプロファイルを削除できません。詳細については、[スキャン実行ポリシー](../policies/scan_execution_policies.md)を参照してください。

{{< /alert >}}

サイトプロファイルを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **Site Profiles**（サイトプロファイル）タブを選択します。
1. プロファイルの行で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）メニューを選択し、**削除**を選択します。
1. **削除**を選択して、削除を確定します。

### サイトプロファイルの検証 {#validate-a-site-profile}

アクティブなスキャンを実行するには、サイトの検証が必要です。

前提要件: 

- 検証ジョブを実行するには、Runnerがプロジェクトで使用可能である必要があります。

サイトプロファイルを検証するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **Site Profiles**（サイトプロファイル）タブを選択します。
1. プロファイルの行で、**検証**を選択します。
1. 検証方法を選択します。
   1. **テキストファイルの検証**の場合:
      1. **ステップ2**にリストされている検証ファイルをダウンロードします。
      1. **Step 3**（ステップ3）または任意の場所に、検証ファイルをホストにアップロードします。
      1. 必要に応じて、**Step 3**（ステップ3）でファイルの場所を編集します。
      1. **検証**を選択します。
   1. **ヘッダーの検証**の場合:
      1. **ステップ2**のクリップボードアイコンを選択します。
      1. 検証するサイトのヘッダーを編集し、クリップボードの内容を貼り付けます。
      1. **Step 3**（ステップ3）の入力フィールドを選択し、ヘッダーの場所を入力します。
      1. **検証**を選択します。
   1. **メタタグの検証**の場合:
      1. **ステップ2**のクリップボードアイコンを選択します。
      1. 検証するサイトのコンテンツを編集し、クリップボードの内容を貼り付けます。
      1. **Step 3**（ステップ3）の入力フィールドを選択し、メタタグの場所を入力します。
      1. **検証**を選択します。

サイトが検証され、アクティブなスキャンを実行できます。サイトプロファイルの検証ステータスは、手動で失効された場合、またはファイル、ヘッダー、メタタグが編集された場合にのみ失効されます。

### 検証の失敗の再試行 {#retry-a-failed-validation}

サイトの検証の失敗の試みは、**サイトプロファイル**タブの**プロファイルの管理**ページにリストされます。

サイトプロファイルの失敗した検証を再試行するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **Site Profiles**（サイトプロファイル）タブを選択します。
1. プロファイルの行で、**検証を再試行**を選択します。

### サイトプロファイルの検証ステータスの失効 {#revoke-a-site-profiles-validation-status}

{{< alert type="warning" >}}

サイトプロファイルの検証ステータスが失効されると、同じURLを共有するすべてのサイトプロファイルも、その検証ステータスが失効されます。

{{< /alert >}}

サイトプロファイルの検証ステータスを失効するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. 検証済みのプロファイルの横にある**検証を削除**を選択します。

サイトプロファイルの検証ステータスは失効されます。

### 検証されたサイトプロファイルのヘッダー {#validated-site-profile-headers}

次に、アプリケーションに必要なサイトプロファイルのヘッダーを提供する方法のコードサンプルを示します。

#### オンデマンドスキャン用のRuby on Railsの例 {#ruby-on-rails-example-for-on-demand-scan}

Ruby on Railsアプリケーションでカスタムヘッダーを追加する方法を次に示します:

```ruby
class DastWebsiteTargetController < ActionController::Base
  def dast_website_target
    response.headers['Gitlab-On-Demand-DAST'] = '0dd79c9a-7b29-4e26-a815-eaaf53fcab1c'
    head :ok
  end
end
```

#### オンデマンドスキャン用のDjangoの例 {#django-example-for-on-demand-scan}

Djangoで[カスタムヘッダーを追加](https://docs.djangoproject.com/en/2.2/ref/request-response/#setting-header-fields)する方法を次に示します:

```python
class DastWebsiteTargetView(View):
    def head(self, *args, **kwargs):
      response = HttpResponse()
      response['Gitlab-On-Demand-DAST'] = '0dd79c9a-7b29-4e26-a815-eaaf53fcab1c'

      return response
```

#### オンデマンドスキャン用のNode（Expressを使用）の例 {#node-with-express-example-for-on-demand-scan}

Node（Expressを使用）で[カスタムヘッダーを追加](https://expressjs.com/en/5x/api.html#res.append)する方法を次に示します:

```javascript
app.get('/dast-website-target', function(req, res) {
  res.append('Gitlab-On-Demand-DAST', '0dd79c9a-7b29-4e26-a815-eaaf53fcab1c')
  res.send('Respond to DAST ping')
})
```

## スキャナープロファイル {#scanner-profile}

{{< history >}}

- GitLab 17.0のブラウザーベースのオンデマンドDASTスキャンの導入により、非推奨のAJAX Spiderオプション。
- GitLab 17.0のブラウザーベースのオンデマンドDASTスキャンの導入により、スパイダータイムアウトの名称をクロールのタイムアウトに変更。

{{< /history >}}

スキャナープロファイルは、セキュリティスキャナーの設定の詳細を定義します。

スキャナープロファイルの内容:

- **プロファイル名**: スキャナープロファイルに付ける名前。例: 「Spider_15」。スキャナープロファイルは`.gitlab-ci.yml`またはオンデマンドスキャンのいずれかで参照されますが、名前を割り当てることは**不可能**。
- **スキャンモード**: パッシブスキャンモードは、ターゲットに送信されるすべてのHTTPメッセージ（リクエストとレスポンス）を監視します。アクティブスキャンモードは、潜在的な脆弱性を見つけるためにターゲットを攻撃します。
- **クロールのタイムアウト**: クローラーがサイトを巡回するために許可される最大時間（分）。
- **ターゲットタイムアウト**: スキャンを開始する前に、DASTがサイトが利用可能になるまで待機する最大秒数。
- **デバッグメッセージ**: DASTコンソール出力にデバッグメッセージを含めます。

`.gitlab-ci.yml`およびオンデマンドスキャンでスキャナープロファイルを参照できます。

```yaml
stages:
  - dast

include:
  - template: DAST.gitlab-ci.yml

dast:
  stage: dast
  dast_configuration:
    scanner_profile: "<profile name>"
```

### スキャナープロファイルの作成 {#create-a-scanner-profile}

スキャナープロファイルを作成するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **新しい**>**スキャナープロファイル**を選択します。
1. フォームに記入します。各フィールドの詳細については、[スキャナープロファイル](#scanner-profile)を参照してください。
1. **プロファイルの保存**を選択します。

### スキャナープロファイルの編集 {#edit-a-scanner-profile}

前提要件: 

- DASTスキャンでプロファイルを使用している場合は、スキャンに関連付けられているブランチにプッシュできる必要があります。

{{< alert type="note" >}}

スキャナープロファイルがセキュリティポリシーにリンクされている場合、このページからプロファイルを編集することはできません。詳細については、[スキャン実行ポリシー](../policies/scan_execution_policies.md)を参照してください。

{{< /alert >}}

スキャナープロファイルを編集するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **スキャナープロファイル**タブを選択します。
1. スキャナーの行で、**追加のアクション**（{{< icon name="ellipsis_v" >}}）メニューを選択し、**編集**を選択します。
1. フォームを編集します。
1. **プロファイルの保存**を選択します。

### スキャナープロファイルの削除 {#delete-a-scanner-profile}

前提要件: 

- DASTスキャンでプロファイルを使用している場合は、スキャンに関連付けられているブランチにプッシュできる必要があります。

{{< alert type="note" >}}

スキャナープロファイルがセキュリティポリシーにリンクされている場合、ユーザーはこのページからプロファイルを削除できません。詳細については、[スキャン実行ポリシー](../policies/scan_execution_policies.md)を参照してください。

{{< /alert >}}

スキャナープロファイルを削除するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、プロジェクトを見つけます。
1. **セキュリティ** > **セキュリティ設定**を選択します。
1. **動的アプリケーションセキュリティテスト (DAST)**セクションで、**プロファイルの管理**を選択します。
1. **スキャナープロファイル**タブを選択します。
1. スキャナーの行で、**追加のアクション** ({{< icon name="ellipsis_v" >}}) メニューを選択し、次に**削除**を選択します。
1. **削除**を選択します。
