---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: GitLab.comのグループおよび個人のネームスペースで、月次ロールオーバーとトラブルシューティングを含む、追加のコンピューティング時間を購入します。
title: 追加のコンピューティング時間を購入
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供形態: GitLab.com

{{< /details >}}

[コンピューティング時間](../../ci/pipelines/compute_minutes.md)は、GitLab.comインスタンスRunnerで[CI/CDパイプライン](../../ci/_index.md)を実行する際に消費されるリソースです。追加のコンピューティング時間の料金は、[GitLabの価格ページ](https://about.gitlab.com/pricing/#compute-minutes)で確認できます。

追加のコンピューティング時間:

- サブスクリプションに含まれる月間クォータを使い切った後にのみ使用されます。
- 月の終わりに残っている場合、[翌月にロールオーバーされます](#monthly-rollover-of-purchased-compute-minutes)。
- 以前に消費されなかった場合、購入日から12か月間有効です。
- コンピューティング時間の有効期限はまだ適用されておらず、有効期限後も使用できます。ただし、GitLabは、有効期限後もコンピューティング時間が有効であることを保証しません。
- トライアルサブスクリプションで購入した場合、トライアル終了後、または有料プランにアップグレードした後に使用できます。
- 有料ティア間またはFreeティアへの変更を含め、サブスクリプションティアを変更しても利用可能なままです。

## グループのコンピューティング時間を購入 {#purchase-compute-minutes-for-a-group}

グループの追加のコンピューティング時間を購入できます。購入したコンピューティング時間をグループ間で譲渡することはできないため、正しいグループを選択してください。

前提要件: 

- グループのオーナーロールを持っているか、課金アカウントマネージャーである必要があります。
- 課金アカウントは、グループのネームスペースのサブスクリプションにリンクされている必要があります。

グループのコンピューティング時間を購入するには:

{{< tabs >}}

{{< tab title="グループオーナー" >}}

1. GitLab.comにサインインします。
1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **使用量クォータ**を選択します。
1. **パイプライン**を選択します。
1. **追加のコンピューティング時間を購入**を選択します。カスタマーポータルに移動します。
1. **サブスクリプションの詳細**セクションの**Quantity**（数量）フィールドに、必要なコンピューティング時間のパック数を入力します。
1. **Customer information**（顧客情報）セクションで、住所を確認します。
1. **Billing information**（料金情報）セクションで、ドロップダウンリストから支払い方法を選択します。
1. **プライバシー声明**チェックボックスと**Terms of Service**（利用規約）チェックボックスをオンにします。
1. **コンピューティング時間(分)を購入する**を選択します。

{{< /tab >}}

{{< tab title="課金アカウントマネージャー" >}}

1. [カスタマーポータル](https://customers.gitlab.com/customers/sign_in)に移動します。
1. サブスクリプションカードで、縦方向の省略記号（{{< icon name="ellipsis_v" >}}）を選択し、**追加のコンピューティング時間(分)を購入する**を選択します。
1. **サブスクリプションの詳細**セクションの**Quantity**（数量）フィールドに、必要なコンピューティング時間のパック数を入力します。
1. **Customer information**（顧客情報）セクションで、住所を確認します。
1. **Billing information**（料金情報）セクションで、ドロップダウンリストから支払い方法を選択します。
1. **プライバシー声明**チェックボックスと**Terms of Service**（利用規約）チェックボックスをオンにします。
1. **コンピューティング時間(分)を購入する**を選択します。

{{< /tab >}}

{{< /tabs >}}

支払いが処理されると、追加のコンピューティング時間がグループネームスペースに追加されます。

## 個人のネームスペースのコンピューティング時間を購入 {#purchase-compute-minutes-for-a-personal-namespace}

個人のネームスペースの追加のコンピューティング時間を購入するには:

1. GitLab.comにサインインします。
1. 左側のサイドバーで、自分のアバターを選択します。
1. **プロファイルの編集**を選択します。
1. 左側のサイドバーで、**使用量クォータ**を選択します。
1. **追加のコンピューティング時間を購入**を選択します。カスタマーポータルに移動します。
1. **サブスクリプションの詳細**セクションで、ドロップダウンリストからユーザーの名前を選択します。
1. 必要なコンピューティング時間パックの数量を入力します。
1. **Customer information**（顧客情報）セクションで、住所を確認します。
1. **Billing information**（料金情報）セクションで、ドロップダウンリストから支払い方法を選択します。
1. **プライバシー声明**チェックボックスと**Terms of Service**（利用規約）チェックボックスをオンにします。
1. **コンピューティング時間(分)を購入する**を選択します。

支払いが処理されると、追加のコンピューティング時間が個人のネームスペースに追加されます。

## 購入したコンピューティング時間の月次ロールオーバー {#monthly-rollover-of-purchased-compute-minutes}

追加のコンピューティング時間を購入し、全額を使用しない場合、残りの金額は翌月にロールオーバーされます。追加のコンピューティング時間は1回限りの購入であり、毎月更新または更新されません。

たとえば、月次割り当てが10,000コンピューティング時間の場合:

- 4月1日に5,000分の追加のコンピューティング時間を購入すると、4月には15,000分利用できるようになります。
- 4月中に13,000分使用した場合、5,000分の追加のコンピューティング時間のうち3,000分を使用したことになります。
- 5月1日に、[月間クォータがリセットされ](../../ci/pipelines/instance_runner_compute_minutes.md#monthly-reset)、未使用のコンピューティング時間がロールオーバーされます。そのため、2,000分の追加のコンピューティング時間が残り、5月には合計12,000分利用できます。

## トラブルシューティング {#troubleshooting}

### エラー: `Last name can't be blank` {#error-last-name-cant-be-blank}

コンピューティング時間の購入時に「姓を入力してください」というエラーが表示される場合があります。この問題は、プロフィールの**フルネーム**フィールドに姓が入力されていない場合に発生します。

この問題を解決するには:

- ユーザープロファイルに姓が入力されていることを確認してください:

  1. 左側のサイドバーで、自分のアバターを選択します。
  1. **プロファイルの編集**を選択します。
  1. **フルネーム**フィールドを更新して、名と姓の両方を入力し、変更を保存します。

- ブラウザのキャッシュとCookieをクリアしてから、購入プロセスをもう一度試してください。
- エラーが解決しない場合は、別のWebブラウザーまたはシークレット/プライベートブラウジングウィンドウを使用してみてください。

### エラー: `Attempt_Exceed_Limitation - Attempt exceed the limitation, refresh page to try again` {#error-attempt_exceed_limitation---attempt-exceed-the-limitation-refresh-page-to-try-again}

コンピューティング時間の購入時に`Attempt_Exceed_Limitation - Attempt exceed the limitation, refresh page to try again.`というエラーが表示される場合があります。

この問題は、クレジットカードフォームが再送信されるのが速すぎる場合（1分間に3回または1時間に6回）に発生します。

この問題を解決するには、数分待ってから購入プロセスをもう一度試してください。
