# frozen_string_literal: true

class FinalizeBackfillSlackIntegrationsScopesShardingKey < Gitlab::Database::Migration[2.3]
  MIGRATION = 'BackfillSlackIntegrationsScopesShardingKey'

  disable_ddl_transaction!
  restrict_gitlab_migration gitlab_schema: :gitlab_main
  milestone '18.9'

  def up
    ensure_batched_background_migration_is_finished(
      job_class_name: MIGRATION,
      table_name: :slack_integrations_scopes,
      column_name: :id,
      job_arguments: [],
      finalize: true
    )
  end

  def down
    # no-op
  end
end
