/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.InvalidDataTypeException;
import ghidra.program.model.data.PngResource;
import ghidra.program.model.data.Resource;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.Msg;
import javax.swing.ImageIcon;

public class PngDataType
extends BuiltIn
implements Dynamic,
Resource {
    public static byte[] MAGIC = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static byte[] MASK = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};

    public PngDataType() {
        this(null);
    }

    public PngDataType(DataTypeManager dtm) {
        super(null, "PNG-Image", dtm);
    }

    @Override
    public int getLength() {
        return -1;
    }

    @Override
    public int getLength(MemBuffer buf, int maxLength) {
        try {
            PngResource png = new PngResource(buf);
            return png.getLength();
        }
        catch (MemoryAccessException e) {
            Msg.error((Object)this, (Object)("PNG error: " + e.getMessage()));
        }
        catch (InvalidDataTypeException e) {
            Msg.error((Object)this, (Object)("Invalid PNG data at " + String.valueOf(buf.getAddress())));
        }
        return -1;
    }

    @Override
    public boolean canSpecifyLength() {
        return false;
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new PngDataType(dtm);
    }

    @Override
    public String getDescription() {
        return "PNG Image stored within program";
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "PNG";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<PNG-Image>";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        byte[] data = new byte[length];
        if (buf.getBytes(data, 0) != length) {
            return null;
        }
        return new PngDataImage(data);
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return PngDataImage.class;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return "PNG";
    }

    @Override
    public DataType getReplacementBaseType() {
        return ByteDataType.dataType;
    }

    private static class PngDataImage
    extends DataImage {
        private final byte[] data;

        PngDataImage(byte[] data) {
            this.data = data;
        }

        @Override
        public ImageIcon getImageIcon() {
            return new ImageIcon(this.data, "<PNG-Image>");
        }

        @Override
        public String getImageFileType() {
            return "png";
        }
    }
}

