/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.dex.format;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.StructConverterUtil;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.dex.format.StringDataItem;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class StringIDItem
implements StructConverter {
    private int stringDataOffset;
    private StringDataItem _stringDataItem;

    public StringIDItem(BinaryReader reader, DexHeader dexHeader) throws IOException {
        this.stringDataOffset = reader.readNextInt();
        try {
            this._stringDataItem = new StringDataItem(this, reader, dexHeader);
        }
        catch (Exception e) {
            this._stringDataItem = new StringDataItem("Invalid_String_0x" + Integer.toHexString(this.stringDataOffset));
        }
    }

    public int getStringDataOffset() {
        return this.stringDataOffset;
    }

    public StringDataItem getStringDataItem() {
        return this._stringDataItem;
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        DataType dataType = StructConverterUtil.toDataType(StringIDItem.class);
        dataType.setCategoryPath(new CategoryPath("/dex"));
        return dataType;
    }
}

