/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.FileBytesProvider;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pe.COMDescriptorDataDirectory;
import ghidra.app.util.bin.format.pe.DataDirectory;
import ghidra.app.util.bin.format.pe.ImageCor20Header;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.OptionalHeader;
import ghidra.app.util.bin.format.pe.PortableExecutable;
import ghidra.app.util.bin.format.pe.cli.streams.CliStreamMetadata;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTable;
import ghidra.app.util.bin.format.pe.cli.tables.CliAbstractTableRow;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.program.database.mem.FileBytes;
import ghidra.program.model.listing.Program;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class PdbPeHeaderInfoManager {
    private DefaultPdbApplicator applicator;
    private boolean initComplete = false;
    private CliStreamMetadata metadataStream;
    private boolean isDll = false;
    private boolean isAslr = false;
    private long originalImageBase = 0L;

    PdbPeHeaderInfoManager(DefaultPdbApplicator applicator) {
        Objects.requireNonNull(applicator, "applicator may not be null");
        this.applicator = applicator;
    }

    private synchronized void initialize() {
        if (this.initComplete) {
            return;
        }
        this.retrievePEHeaderInformation();
        this.initComplete = true;
    }

    boolean isDll() {
        this.initialize();
        return this.isDll;
    }

    boolean isAslr() {
        this.initialize();
        return this.isAslr;
    }

    long getOriginalImageBase() {
        this.initialize();
        return this.originalImageBase;
    }

    CliAbstractTableRow getCliTableRow(int tableNum, int rowNum) throws PdbException, IndexOutOfBoundsException {
        this.initialize();
        if (this.metadataStream == null) {
            throw new PdbException("CliStreamMetadata is null");
        }
        CliAbstractTable table = this.metadataStream.getTable(tableNum);
        if (table == null) {
            return null;
        }
        return table.getRow(rowNum);
    }

    private void retrievePEHeaderInformation() {
        Program program = this.applicator.getProgram();
        if (program == null) {
            this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve Program header: program null", null);
            return;
        }
        List allFileBytes = program.getMemory().getAllFileBytes();
        if (allFileBytes.isEmpty()) {
            this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve Program header: no FileBytes", null);
            return;
        }
        FileBytes fileBytes = (FileBytes)allFileBytes.get(0);
        FileBytesProvider provider = new FileBytesProvider(fileBytes);
        try {
            PortableExecutable pe = new PortableExecutable((ByteProvider)provider, PortableExecutable.SectionLayout.FILE, true, true);
            NTHeader ntHeader = pe.getNTHeader();
            if (ntHeader == null) {
                this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve NTHeader from PE", null);
                return;
            }
            OptionalHeader optionalHeader = ntHeader.getOptionalHeader();
            this.originalImageBase = optionalHeader.getImageBase();
            int characteristics = ntHeader.getFileHeader().getCharacteristics();
            this.isDll = (characteristics & 0x2000) == 8192;
            DataDirectory[] dataDirectory = optionalHeader.getDataDirectories();
            short optionalHeaderCharaceristics = optionalHeader.getDllCharacteristics();
            boolean bl = this.isAslr = (optionalHeaderCharaceristics & 0x20) == 32;
            if (14 >= dataDirectory.length) {
                this.applicator.pdbLogAndErrorMessage(this, "Bad index (14) for COMDescriptorDataDirectory in DataDirectory array of size " + dataDirectory.length, null);
                return;
            }
            COMDescriptorDataDirectory comDir = (COMDescriptorDataDirectory)dataDirectory[14];
            ImageCor20Header header = comDir.getHeader();
            if (header == null) {
                this.applicator.pdbLogAndErrorMessage(this, "COMDir header not available", null);
                return;
            }
            this.metadataStream = header.getMetadata().getMetadataRoot().getMetadataStream();
        }
        catch (IOException | RuntimeException e) {
            this.applicator.pdbLogAndErrorMessage(this, "Unable to retrieve program header information: " + e.getMessage(), e);
            return;
        }
    }
}

