/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public enum GoSymbolNameType {
    UNKNOWN,
    FUNC,
    METHOD_WRAPPER,
    ANON_FUNC,
    DEFER_WRAPPER,
    GO_WRAPPER,
    DATA_TYPE;

    private static final Pattern P;

    public boolean isClosure() {
        return switch (this.ordinal()) {
            case 3, 4, 5 -> true;
            default -> false;
        };
    }

    public static GoSymbolNameType fromNameWithDashSuffix(String name) {
        if (name.endsWith("-fm")) {
            return METHOD_WRAPPER;
        }
        return FUNC;
    }

    public static GoSymbolNameType fromNameSuffix(String suffix) {
        if (suffix == null) {
            return FUNC;
        }
        Matcher m = P.matcher(suffix);
        if (m.matches()) {
            return switch (m.group(1)) {
                case "func" -> ANON_FUNC;
                case "deferwrap" -> DEFER_WRAPPER;
                case "gowrap" -> GO_WRAPPER;
                default -> UNKNOWN;
            };
        }
        return UNKNOWN;
    }

    static {
        P = Pattern.compile(".*?([a-z]+)[0-9]+(\\.[0-9]+)?$");
    }
}

