/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.compositeeditor;

import docking.ActionContext;
import docking.action.KeyBindingData;
import generic.theme.GIcon;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorProvider;
import ghidra.app.plugin.core.compositeeditor.CompositeEditorTableAction;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeInstance;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.Undefined1DataType;
import ghidra.util.exception.UsrException;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class InsertUndefinedAction
extends CompositeEditorTableAction {
    private static final Icon ICON = new GIcon("icon.plugin.composite.editor.insert.undefined");
    public static final String ACTION_NAME = "Insert Undefined Byte";
    private static final String GROUP_NAME = "4_COMPONENT_EDITOR_ACTION";
    private static final String DESCRIPTION = "Insert an undefined byte before the selection";
    private static String[] POPUP_PATH = new String[]{"Insert Undefined Byte"};
    private static final KeyStroke KEY_STROKE = KeyStroke.getKeyStroke(85, 512);

    public InsertUndefinedAction(CompositeEditorProvider<?, ?> provider) {
        super(provider, ACTION_NAME, GROUP_NAME, POPUP_PATH, null, ICON);
        this.setDescription(DESCRIPTION);
        this.setKeyBindingData(new KeyBindingData(KEY_STROKE));
    }

    public void actionPerformed(ActionContext context) {
        if (!this.isEnabledForContext(context)) {
            return;
        }
        try {
            int index;
            boolean isContiguousSelection;
            boolean bl = isContiguousSelection = this.model.getSelection().getNumRanges() == 1;
            if (isContiguousSelection && (index = this.model.getMinIndexSelected()) >= 0) {
                Undefined1DataType undefinedDt = this.model.viewComposite.isPackingEnabled() ? Undefined1DataType.dataType : DataType.DEFAULT;
                DataTypeInstance dti = DataTypeInstance.getDataTypeInstance((DataType)undefinedDt, (int)-1, (boolean)false);
                this.model.insert(index, dti.getDataType(), dti.getLength());
            }
        }
        catch (UsrException e1) {
            this.model.setStatus(e1.getMessage());
        }
        this.requestTableFocus();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (this.hasIncompleteFieldEntry()) {
            return false;
        }
        boolean enabled = false;
        if (this.model.viewComposite instanceof Structure) {
            boolean isContiguousSelection = this.model.getSelection().getNumRanges() == 1;
            Undefined1DataType undefinedDt = this.model.viewComposite.isPackingEnabled() ? Undefined1DataType.dataType : DataType.DEFAULT;
            enabled = isContiguousSelection && this.model.isInsertAllowed(this.model.getMinIndexSelected(), (DataType)undefinedDt);
        }
        return enabled;
    }
}

