/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.echosvg.css.engine.value.AbstractCounterValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import org.w3c.dom.DOMException;

class CountersValue
extends AbstractCounterValue {
    private static final long serialVersionUID = 1L;
    private String separator = "";

    public CountersValue() {
    }

    CountersValue(String identifier, Value listStyle, String separator) {
        super(identifier, listStyle);
        this.separator = separator;
    }

    @Override
    public CountersValue clone() {
        return new CountersValue(this.getName(), this.getCounterStyle(), this.getSeparator());
    }

    public CSSValue.Type getPrimitiveType() {
        return CSSValue.Type.COUNTERS;
    }

    @Override
    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public String getCssText() {
        String listStyle;
        StringBuilder buf = new StringBuilder();
        buf.append("counter(").append(this.getName());
        Value style = this.getCounterStyle();
        if (style != null && !"decimal".equalsIgnoreCase(listStyle = style.getCssText())) {
            buf.append(',').append(' ').append(listStyle);
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public CountersValue getCounterValue() throws DOMException {
        return this;
    }
}

