# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Any, Optional

from ... import _serialization


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2022_12_01_preview.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.security.v2022_12_01_preview.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class DefenderForStorageSetting(Resource):  # pylint: disable=too-many-instance-attributes
    """The Defender for Storage resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar is_enabled_properties_is_enabled: Indicates whether Defender for Storage is enabled on
     this storage account.
    :vartype is_enabled_properties_is_enabled: bool
    :ivar override_subscription_level_settings: Indicates whether the settings defined for this
     storage account should override the settings defined for the subscription.
    :vartype override_subscription_level_settings: bool
    :ivar is_enabled_properties_sensitive_data_discovery_is_enabled: Indicates whether Sensitive
     Data Discovery should be enabled.
    :vartype is_enabled_properties_sensitive_data_discovery_is_enabled: bool
    :ivar operation_status_properties_sensitive_data_discovery_operation_status: Upon failure or
     partial success. Additional data describing Sensitive Data Discovery enable/disable operation.
    :vartype operation_status_properties_sensitive_data_discovery_operation_status:
     ~azure.mgmt.security.v2022_12_01_preview.models.OperationStatus
    :ivar scan_results_event_grid_topic_resource_id: Optional. Resource id of an Event Grid Topic
     to send scan results to.
    :vartype scan_results_event_grid_topic_resource_id: str
    :ivar operation_status_properties_malware_scanning_operation_status: Upon failure or partial
     success. Additional data describing Malware Scanning enable/disable operation.
    :vartype operation_status_properties_malware_scanning_operation_status:
     ~azure.mgmt.security.v2022_12_01_preview.models.OperationStatus
    :ivar is_enabled_properties_malware_scanning_on_upload_is_enabled: Indicates whether On Upload
     malware scanning should be enabled.
    :vartype is_enabled_properties_malware_scanning_on_upload_is_enabled: bool
    :ivar cap_gb_per_month: Defines the max GB to be scanned per Month. Set to -1 if no capping is
     needed.
    :vartype cap_gb_per_month: int
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "operation_status_properties_sensitive_data_discovery_operation_status": {"readonly": True},
        "operation_status_properties_malware_scanning_operation_status": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "is_enabled_properties_is_enabled": {"key": "properties.isEnabled", "type": "bool"},
        "override_subscription_level_settings": {"key": "properties.overrideSubscriptionLevelSettings", "type": "bool"},
        "is_enabled_properties_sensitive_data_discovery_is_enabled": {
            "key": "properties.sensitiveDataDiscovery.isEnabled",
            "type": "bool",
        },
        "operation_status_properties_sensitive_data_discovery_operation_status": {
            "key": "properties.sensitiveDataDiscovery.operationStatus",
            "type": "OperationStatus",
        },
        "scan_results_event_grid_topic_resource_id": {
            "key": "properties.malwareScanning.scanResultsEventGridTopicResourceId",
            "type": "str",
        },
        "operation_status_properties_malware_scanning_operation_status": {
            "key": "properties.malwareScanning.operationStatus",
            "type": "OperationStatus",
        },
        "is_enabled_properties_malware_scanning_on_upload_is_enabled": {
            "key": "properties.malwareScanning.onUpload.isEnabled",
            "type": "bool",
        },
        "cap_gb_per_month": {"key": "properties.malwareScanning.onUpload.capGBPerMonth", "type": "int"},
    }

    def __init__(
        self,
        *,
        is_enabled_properties_is_enabled: Optional[bool] = None,
        override_subscription_level_settings: Optional[bool] = None,
        is_enabled_properties_sensitive_data_discovery_is_enabled: Optional[bool] = None,
        scan_results_event_grid_topic_resource_id: Optional[str] = None,
        is_enabled_properties_malware_scanning_on_upload_is_enabled: Optional[bool] = None,
        cap_gb_per_month: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword is_enabled_properties_is_enabled: Indicates whether Defender for Storage is enabled on
         this storage account.
        :paramtype is_enabled_properties_is_enabled: bool
        :keyword override_subscription_level_settings: Indicates whether the settings defined for this
         storage account should override the settings defined for the subscription.
        :paramtype override_subscription_level_settings: bool
        :keyword is_enabled_properties_sensitive_data_discovery_is_enabled: Indicates whether Sensitive
         Data Discovery should be enabled.
        :paramtype is_enabled_properties_sensitive_data_discovery_is_enabled: bool
        :keyword scan_results_event_grid_topic_resource_id: Optional. Resource id of an Event Grid
         Topic to send scan results to.
        :paramtype scan_results_event_grid_topic_resource_id: str
        :keyword is_enabled_properties_malware_scanning_on_upload_is_enabled: Indicates whether On
         Upload malware scanning should be enabled.
        :paramtype is_enabled_properties_malware_scanning_on_upload_is_enabled: bool
        :keyword cap_gb_per_month: Defines the max GB to be scanned per Month. Set to -1 if no capping
         is needed.
        :paramtype cap_gb_per_month: int
        """
        super().__init__(**kwargs)
        self.is_enabled_properties_is_enabled = is_enabled_properties_is_enabled
        self.override_subscription_level_settings = override_subscription_level_settings
        self.is_enabled_properties_sensitive_data_discovery_is_enabled = (
            is_enabled_properties_sensitive_data_discovery_is_enabled
        )
        self.operation_status_properties_sensitive_data_discovery_operation_status = None
        self.scan_results_event_grid_topic_resource_id = scan_results_event_grid_topic_resource_id
        self.operation_status_properties_malware_scanning_operation_status = None
        self.is_enabled_properties_malware_scanning_on_upload_is_enabled = (
            is_enabled_properties_malware_scanning_on_upload_is_enabled
        )
        self.cap_gb_per_month = cap_gb_per_month


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class OperationStatus(_serialization.Model):
    """A status describing the success/failure of the enablement/disablement operation.

    :ivar code: The operation status code.
    :vartype code: str
    :ivar message: Additional information regarding the success/failure of the operation.
    :vartype message: str
    """

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
    }

    def __init__(self, *, code: Optional[str] = None, message: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword code: The operation status code.
        :paramtype code: str
        :keyword message: Additional information regarding the success/failure of the operation.
        :paramtype message: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.message = message
