﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace MediaConnect {
namespace Model {
class RemoveBridgeOutputResult {
 public:
  AWS_MEDIACONNECT_API RemoveBridgeOutputResult() = default;
  AWS_MEDIACONNECT_API RemoveBridgeOutputResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_MEDIACONNECT_API RemoveBridgeOutputResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p> The ARN of the bridge from which the output was removed. </p>
   */
  inline const Aws::String& GetBridgeArn() const { return m_bridgeArn; }
  template <typename BridgeArnT = Aws::String>
  void SetBridgeArn(BridgeArnT&& value) {
    m_bridgeArnHasBeenSet = true;
    m_bridgeArn = std::forward<BridgeArnT>(value);
  }
  template <typename BridgeArnT = Aws::String>
  RemoveBridgeOutputResult& WithBridgeArn(BridgeArnT&& value) {
    SetBridgeArn(std::forward<BridgeArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The name of the bridge output that was removed. </p>
   */
  inline const Aws::String& GetOutputName() const { return m_outputName; }
  template <typename OutputNameT = Aws::String>
  void SetOutputName(OutputNameT&& value) {
    m_outputNameHasBeenSet = true;
    m_outputName = std::forward<OutputNameT>(value);
  }
  template <typename OutputNameT = Aws::String>
  RemoveBridgeOutputResult& WithOutputName(OutputNameT&& value) {
    SetOutputName(std::forward<OutputNameT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  RemoveBridgeOutputResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_bridgeArn;

  Aws::String m_outputName;

  Aws::String m_requestId;
  bool m_bridgeArnHasBeenSet = false;
  bool m_outputNameHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaConnect
}  // namespace Aws
