/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.workload;

import java.time.Duration;
import java.util.HashSet;
import java.util.Properties;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.trogdor.common.WorkerUtils;
import org.apache.kafka.trogdor.workload.RoundTripWorkerBase;
import org.apache.kafka.trogdor.workload.RoundTripWorkloadSpec;

public class RoundTripWorker
extends RoundTripWorkerBase {
    KafkaConsumer<byte[], byte[]> consumer;

    RoundTripWorker(String id, RoundTripWorkloadSpec spec) {
        this.id = id;
        this.spec = spec;
    }

    @Override
    public void initializeConsumer(HashSet<TopicPartition> partitions) {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.spec.bootstrapServers());
        props.put("client.id", "consumer." + this.id);
        props.put("auto.offset.reset", "earliest");
        props.put("request.timeout.ms", (Object)105000);
        props.put("max.poll.interval.ms", (Object)100000);
        WorkerUtils.addConfigsToProperties(props, this.spec.commonClientConf(), this.spec.consumerConf());
        props.put("group.id", "round-trip-consumer-group-" + this.id);
        this.consumer = new KafkaConsumer(props, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());
        this.consumer.assign(partitions);
    }

    @Override
    protected ConsumerRecords<byte[], byte[]> fetchRecords(Duration duration) {
        return this.consumer.poll(duration);
    }

    @Override
    protected void shutdownConsumer() {
        Utils.closeQuietly(this.consumer, (String)"consumer");
        this.consumer = null;
    }
}

