/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.admin;

import java.util.Set;
import org.apache.kafka.clients.admin.AbstractOptions;
import org.apache.kafka.common.GroupState;
import org.apache.kafka.common.GroupType;

public class ListGroupsOptions
extends AbstractOptions<ListGroupsOptions> {
    private Set<GroupState> groupStates = Set.of();
    private Set<GroupType> types = Set.of();
    private Set<String> protocolTypes = Set.of();

    public static ListGroupsOptions forConsumerGroups() {
        return new ListGroupsOptions().withTypes(Set.of(GroupType.CLASSIC, GroupType.CONSUMER)).withProtocolTypes(Set.of("", "consumer"));
    }

    public static ListGroupsOptions forShareGroups() {
        return new ListGroupsOptions().withTypes(Set.of(GroupType.SHARE));
    }

    public static ListGroupsOptions forStreamsGroups() {
        return new ListGroupsOptions().withTypes(Set.of(GroupType.STREAMS));
    }

    public ListGroupsOptions inGroupStates(Set<GroupState> groupStates) {
        this.groupStates = groupStates == null || groupStates.isEmpty() ? Set.of() : Set.copyOf(groupStates);
        return this;
    }

    public ListGroupsOptions withProtocolTypes(Set<String> protocolTypes) {
        this.protocolTypes = protocolTypes == null || protocolTypes.isEmpty() ? Set.of() : Set.copyOf(protocolTypes);
        return this;
    }

    public ListGroupsOptions withTypes(Set<GroupType> types) {
        this.types = types == null || types.isEmpty() ? Set.of() : Set.copyOf(types);
        return this;
    }

    public Set<GroupState> groupStates() {
        return this.groupStates;
    }

    public Set<String> protocolTypes() {
        return this.protocolTypes;
    }

    public Set<GroupType> types() {
        return this.types;
    }
}

