#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (c) 2021, Cisco Systems
# GNU General Public License v3.0+ (see LICENSE or https://www.gnu.org/licenses/gpl-3.0.txt)

DOCUMENTATION = r"""
---
module: projects_info
short_description: Information module for Projects
description:
  - Get all Projects.
  - Get Projects by id.
  - Get a template project by the project's ID.
  - Get all matching template projects based on the filters selected.
version_added: '6.17.0'
extends_documentation_fragment:
  - cisco.dnac.module_info
author: Rafael Campos (@racampos)
options:
  headers:
    description: Additional headers.
    type: dict
  name:
    description:
      - Name query parameter. Name of project to be searched.
    type: str
  limit:
    description:
      - Limit query parameter. The number of records to show for this page;The minimum is 1, and the maximum is 500.
    type: int
  offset:
    description:
      - Offset query parameter. The first record to show for this page; the first record is numbered 1.
    type: int
  projectId:
    description:
      - ProjectId path parameter. The id of the project to get, retrieveable from `GET /dna/intent/api/v1/projects`.
    type: str
requirements:
  - dnacentersdk >= 2.11.0
  - python >= 3.12
seealso:
  - name: Cisco DNA Center documentation for Configuration Templates GetTemplateProject
    description: Complete reference of the GetTemplateProject API.
    link: https://developer.cisco.com/docs/dna-center/#!get-template-project
  - name: Cisco DNA Center documentation for Configuration Templates GetTemplateProjects
    description: Complete reference of the GetTemplateProjects API.
    link: https://developer.cisco.com/docs/dna-center/#!get-template-projects
notes:
  - SDK Method used are
    configuration_templates.ConfigurationTemplates.get_template_project,
    configuration_templates.ConfigurationTemplates.get_template_projects,
  - Paths used are
    get /dna/intent/api/v1/projects,
    get /dna/intent/api/v1/projects/{projectId},
"""

EXAMPLES = r"""
---
- name: Get all Projects
  cisco.dnac.projects_info:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    headers: "{{my_headers | from_json}}"
    name: string
    limit: 0
    offset: 0
  register: result
- name: Get Projects by id
  cisco.dnac.projects_info:
    dnac_host: "{{dnac_host}}"
    dnac_username: "{{dnac_username}}"
    dnac_password: "{{dnac_password}}"
    dnac_verify: "{{dnac_verify}}"
    dnac_port: "{{dnac_port}}"
    dnac_version: "{{dnac_version}}"
    dnac_debug: "{{dnac_debug}}"
    headers: "{{my_headers | from_json}}"
    projectId: string
  register: result
"""
RETURN = r"""
dnac_response:
  description: A dictionary or list with the response returned by the Cisco DNAC Python SDK
  returned: always
  type: dict
  sample: >
    {
      "version": "string",
      "response": {
        "projectId": "string",
        "name": "string",
        "description": "string",
        "lastUpdateTime": 0
      }
    }
"""
