# This Makefile.PL for Perl-Types was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

#our $VERSION = 0.042_000;  # DEV NOTE: comment to avoid potential conflict w/ Dist::Zilla & friends

# DEV NOTE, CORRELATION #pt000: minimum Perl version to support "my array @foo;" & "my hash %bar;" Perl::Types syntax
use 5.012;

BEGIN { 
    use Config;
    use English qw(-no_match_vars);  # for $OSNAME
}

# choose correct C++11 compiler for each OS and/or Perl configuration;
# if unsupported compiler, `exit 0` to avoid creating any CPAN Testers failure or report at all
my $min_cxx_versions = {
    'g++' => 4.7,
    'clang++' => 3.3
};
my $cxx = 'g++';
if ($OSNAME eq 'freebsd') {
    $cxx = 'c++';
}
if ($Config{cc} =~ /clang/) {
    $cxx = 'clang++';
}

=begin COMPILER_VERSION_OUTPUT_EXAMPLES

$ g++ --version
g++ (Ubuntu 5.4.0-6ubuntu1~16.04.4) 5.4.0 20160609
...

$ g++ --version
g++ (i686-posix-sjlj, built by strawberryperl.com project) 4.9.2
Copyright (C) 2014 Free Software Foundation, Inc.
This is free software; see the source for copying conditions.  There is NO
warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

$ clang++ --version
Ubuntu clang version 3.4-1ubuntu3 ...
...

=end COMPILER_VERSION_OUTPUT_EXAMPLES

=cut

# run external compiler command to get version info
my $version_retval = `$cxx --version`;
#print {*STDERR} '<<< DEBUG >>>: have $version_retval = ', "\n", $version_retval, "\n";
if ((not defined $version_retval) or ($version_retval eq q{})) {
    print {*STDERR} 'C++ compiler ', $cxx, ' not found, bailing out!', "\n";
    exit 0;
}

# FreeBSD c++ is sometimes g++, sometimes clang++
my $cxx_real = $cxx;
if ($cxx eq 'c++') {
    if ($version_retval =~ m/clang/xms) {
        $cxx_real = 'clang++';
    }
    elsif ($version_retval =~ m/Free\ Software\ Foundation/xms) {
        $cxx_real = 'g++';
    }
    else {
        print {*STDERR} 'C++ compiler ', $cxx, ' does not seem to provide the known g++ or clang++ compilers, bailing out!', "\n";
        exit 0;
    }
}
#print {*STDERR} '<<< DEBUG >>>: have $cxx_real = ', $cxx_real, "\n";

# must meet minimum compiler version requirements
$version_retval =~ m/(\d+\.\d+)/xms;
my $version = $1 + 0;
#print {*STDERR} '<<< DEBUG >>>: have $version = ', $version, "\n";
if ($version < $min_cxx_versions->{$cxx_real}) {
    print {*STDERR} 'C++ compiler ', $cxx_real, ' version ', $version, ' found, does not meet minimum version requirement ', $min_cxx_versions->{$cxx_real} , ', bailing out!', "\n";
    exit 0;
}

# fix read-only blib/lib in MS Windows
BEGIN {
    require ExtUtils::MakeMaker;  # ensure EUMM is actually loaded before modifying "@ExtUtils::MakeMaker::Overridable"
    if ( $OSNAME eq 'MSWin32' ) {
        push( @ExtUtils::MakeMaker::Overridable, qw(pm_to_blib) );
    }
}

my %WriteMakefileArgs = (
  "ABSTRACT" => "the Perl data type system",
  "AUTHOR" => "William N. Braswell, Jr. <wbraswell\@cpan.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME" => "Perl-Types",
  "EXE_FILES" => [
    "bin/dev/GMP/gmp_manual.pl",
    "bin/dev/GMP/gmp_manual_orig.pl",
    "bin/dev/GMP/gmp_symtab_dump.pl",
    "bin/dev/GSL/gsl_cpp_manual.pl",
    "bin/dev/find_replace_recurse_scalars.sh",
    "bin/dev/namespaces_regenerate.pl",
    "bin/dev/perl_types_refactor_cpp_namespaces.pl",
    "bin/dev/perl_types_refactor_cpp_namespaces.txt",
    "bin/dev/perl_types_refactor_headers.pl",
    "bin/dev/perl_types_refactor_names.pl",
    "bin/dev/perl_types_refactor_names.txt",
    "bin/dev/perl_types_refactor_names_accept_mapped.sh",
    "bin/dev/perl_types_refactor_names_delete_mapped.sh",
    "bin/dev/perl_types_refactor_names_map.pm",
    "bin/dev/perl_types_refactor_names_parser.out",
    "bin/dev/perl_types_refactor_names_parser.pl",
    "bin/dev/perlapinames_regenerate.pl",
    "bin/dev/refactor_names_map_create_groups.pl",
    "bin/dev/t09_interpret_execute__mv_failures.sh",
    "bin/dev/unused/data_structure_array_test.pl",
    "bin/dev/unused/data_structure_hash_test.pl",
    "bin/dev/unused/data_structure_tree_test.pl",
    "bin/dev/unused/data_type_integer_part.cpp",
    "bin/dev/unused/data_type_integer_precision.cpp",
    "bin/dev/unused/data_type_integer_precision.pl",
    "bin/dev/unused/data_type_number_floating_point_error.pl",
    "bin/dev/unused/data_type_number_precision.cpp",
    "bin/dev/unused/data_type_scalar_test.pl",
    "bin/dev/unused/data_type_string_backslashes.cpp",
    "bin/dev/unused/data_type_string_backslashes.pl"
  ],
  "LICENSE" => "gpl",
  "NAME" => "Perl::Types",
  "PREREQ_PM" => {
    "Alien::GMP" => 0,
    "Alien::GSL" => 0,
    "Carp" => 0,
    "Data::Dumper" => 0,
    "Exporter" => 0,
    "File::Spec" => 0,
    "IPC::Cmd" => 0,
    "IPC::Run3" => 0,
    "Inline" => 0,
    "Inline::C" => 0,
    "Inline::CPP" => 0,
    "Inline::Filters" => 0,
    "Math::BigInt" => 0,
    "Math::GSL::BLAS" => 0,
    "Math::GSL::CBLAS" => 0,
    "Math::GSL::Matrix" => 0,
    "PadWalker" => 0,
    "Scalar::Util" => 0,
    "Term::ReadLine" => 0,
    "parent" => 0
  },
  "TEST_REQUIRES" => {
    "Cwd" => 0,
    "ExtUtils::MakeMaker" => 0,
    "File::Spec" => 0,
    "Test2::V0" => 0,
    "Test::Exception" => 0,
    "Test::More" => 0,
    "Test::Number::Delta" => 0
  },
  "VERSION" => "0.300",
  "test" => {
    "TESTS" => "t/*.t t/author/*.t"
  }
);

my %FallbackPrereqs = (
  "Alien::GMP" => 0,
  "Alien::GSL" => 0,
  "Carp" => 0,
  "Cwd" => 0,
  "Data::Dumper" => 0,
  "Exporter" => 0,
  "ExtUtils::MakeMaker" => 0,
  "File::Spec" => 0,
  "IPC::Cmd" => 0,
  "IPC::Run3" => 0,
  "Inline" => 0,
  "Inline::C" => 0,
  "Inline::CPP" => 0,
  "Inline::Filters" => 0,
  "Math::BigInt" => 0,
  "Math::GSL::BLAS" => 0,
  "Math::GSL::CBLAS" => 0,
  "Math::GSL::Matrix" => 0,
  "PadWalker" => 0,
  "Scalar::Util" => 0,
  "Term::ReadLine" => 0,
  "Test2::V0" => 0,
  "Test::Exception" => 0,
  "Test::More" => 0,
  "Test::Number::Delta" => 0,
  "parent" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

#our $VERSION = 0.042_000;  # DEV NOTE: comment to avoid potential conflict w/ Dist::Zilla & friends

package MY;
BEGIN { use English; }

sub pm_to_blib {
    my $self = shift;
    my $blib = $self->SUPER::pm_to_blib(@_);

    # un-read-only blib/lib for tests to pass, files are modified at runtime there
    if ( $OSNAME eq 'MSWin32' ) {
        my ( $lastline, $start ) = qq{\t\$(NOECHO) \$(TOUCH) pm_to_blib\n};
        ( $start = index( $blib, $lastline ) ) == -1
            && die "Can't find replacement string for pm_to_blib target";
        substr( $blib, $start, 0, "\t" . 'attrib -R /S  blib/lib/*' . "\n" );
    }
    return $blib;
}

# disable PERL_DL_NONLAZY=1 to avoid C++ compile errors for GMP library (and possibly others)
sub test_via_harness {
    my $self = shift;
    my $command = $self->MM::test_via_harness(@_);
    $command =~ s/\bPERL_DL_NONLAZY=1\s+//gxms;
    return $command;
}

sub test_via_script {
    my $self = shift;
    my $command = $self->MM::test_via_script(@_);
    $command =~ s/\bPERL_DL_NONLAZY=1\s+//gxms;
    return $command;
}
