package SPVM::HTTP::Tiny;

our $VERSION = "0.016";

1;

=head1 Name

SPVM::HTTP::Tiny - HTTP Client

=head1 Description

HTTP::Tiny class in L<SPVM> is a HTTP client.

B<This class is highly experimental. Many dramatic incompatibilities are expected.>.

=head1 Usage

  use HTTP::Tiny;
  use Go::Context;
  
  my $ctx = Go::Context->background;
  my $response = HTTP::Tiny->new->get($ctx, 'http://example.com/');
  
  unless ($response->success) {
    die "Failed!";
  }
  
  say $response->status;
  
  say $response->reason;
  
  for my $header_name (@{$response->headers->names}) {
    my $header_value = $response->headers->header($header_name);
    
    say $header_value;
  }
  
  if (length $response->content) {
    print $response->content;
  }

=head1 Details

=head2 Note

This class is a wrapper of L<Mojo::User::Agent|SPVM::Mojo::User::Agent>. So this class has a lot of dependencies instead of Perl's one.

=head1 Fields

=head2 agent

C<has agent : ro string;>

The user agent.

=head2 inactivity_timeout

C<has inactivity_timeout : ro double;>

The request inactivity_timeout seconds.

=head1 Class Methods

=head2 new

C<static method new : HTTP::Tiny ($options : object[] = undef);>

Creates a new L<HTTP::Tiny|SPVM::HTTP::Tiny> object.

Options:

=over 2

=item C<agent> : string

Sets the L</"agent"> field.

=item C<inactivity_timeout> : Double

Sets the L</"inactivity_timeout"> field.

=back

=head1 Instance Methods

=head2 get

C<method get : HTTP::Tiny::Response ($ctx : L<Go::Context|SPVM::Go::Context>, $url : string, $options : object[] = undef);>

Gets the HTTP response by sending an HTTP GET request to the URL $url.

The HTTP response is a L<HTTP::Tiny::Response|SPVM::HTTP::Tiny::Response> object.

Options:

=over 2

=item C<headers> : L<HTTP::Tiny::Headers|SPVM::HTTP::Tiny::Headers>

Headers for an HTTP request.

=item C<inactivity_timeout> : Double

Timeout seconds.

=back

=head2 head

C<method head : HTTP::Tiny::Response ($ctx : L<Go::Context|SPVM::Go::Context>, $url : string, $options : object[] = undef);>

=head2 put

C<method put : HTTP::Tiny::Response ($ctx : L<Go::Context|SPVM::Go::Context>, $url : string, $options : object[] = undef);>

=head2 post

C<method post : HTTP::Tiny::Response ($ctx : L<Go::Context|SPVM::Go::Context>, $url : string, $options : object[] = undef);>

=head2 patch

C<method patch : HTTP::Tiny::Response ($ctx : L<Go::Context|SPVM::Go::Context>, $url : string, $options : object[] = undef);>

=head2 delete

C<method delete : HTTP::Tiny::Response ($ctx : L<Go::Context|SPVM::Go::Context>, $url : string, $options : object[] = undef);>

=head1 Repository

L<SPVM::HTTP::Tiny - Github|https://github.com/yuki-kimoto/SPVM-HTTP-Tiny>

=head1 Author

Yuki Kimoto C<kimoto.yuki@gmail.com>

=head1 Copyright & License

Copyright (c) 2023 Yuki Kimoto

MIT License
