=encoding utf8

=head1 NAME

Locale::CLDR::Locales::Am - Package for language Amharic

=cut

package Locale::CLDR::Locales::Am;
# This file auto generated from Data\common\main\am.xml
#	on Thu 29 Feb  5:43:51 pm GMT

use strict;
use warnings;
use version;

our $VERSION = version->declare('v0.44.1');

use v5.10.1;
use mro 'c3';
use utf8;
use if $^V ge v5.12.0, feature => 'unicode_strings';
use Types::Standard qw( Str Int HashRef ArrayRef CodeRef RegexpRef );
use Moo;

extends('Locale::CLDR::Locales::Root');
has 'valid_algorithmic_formats' => (
    is => 'ro',
    isa => ArrayRef,
    init_arg => undef,
    default => sub {[ 'spellout-numbering-year','spellout-numbering','spellout-cardinal','spellout-ordinal','digits-ordinal' ]},
);

has 'algorithmic_number_format_data' => (
    is => 'ro',
    isa => HashRef,
    init_arg => undef,
    default => sub {
        use bigfloat;
        return {
		'digits-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(−→→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0=ኛ),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=#,##0=ኛ),
				},
			},
		},
		'spellout-cardinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ቅንስናሽ →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(ባዶ),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(←← ነጥብ →→),
				},
				'1' => {
					base_value => q(1),
					divisor => q(1),
					rule => q(አንድ),
				},
				'2' => {
					base_value => q(2),
					divisor => q(1),
					rule => q(ሁለት),
				},
				'3' => {
					base_value => q(3),
					divisor => q(1),
					rule => q(ሦስት),
				},
				'4' => {
					base_value => q(4),
					divisor => q(1),
					rule => q(አራት),
				},
				'5' => {
					base_value => q(5),
					divisor => q(1),
					rule => q(አምስት),
				},
				'6' => {
					base_value => q(6),
					divisor => q(1),
					rule => q(ስድስት),
				},
				'7' => {
					base_value => q(7),
					divisor => q(1),
					rule => q(ሰባት),
				},
				'8' => {
					base_value => q(8),
					divisor => q(1),
					rule => q(ስምንት),
				},
				'9' => {
					base_value => q(9),
					divisor => q(1),
					rule => q(ዘጠኝ),
				},
				'10' => {
					base_value => q(10),
					divisor => q(10),
					rule => q(አስር[ →→]),
				},
				'20' => {
					base_value => q(20),
					divisor => q(10),
					rule => q(←← አስር[ →→]),
				},
				'100' => {
					base_value => q(100),
					divisor => q(100),
					rule => q(መቶ[ →→]),
				},
				'200' => {
					base_value => q(200),
					divisor => q(100),
					rule => q(←← መቶ[ →→]),
				},
				'1000' => {
					base_value => q(1000),
					divisor => q(1000),
					rule => q(ሺ[ →→]),
				},
				'2000' => {
					base_value => q(2000),
					divisor => q(1000),
					rule => q(←← ሺ[ →→]),
				},
				'1000000' => {
					base_value => q(1000000),
					divisor => q(1000000),
					rule => q(ሚሊዮን[ →→]),
				},
				'2000000' => {
					base_value => q(2000000),
					divisor => q(1000000),
					rule => q(←← ሚሊዮን[ →→]),
				},
				'1000000000' => {
					base_value => q(1000000000),
					divisor => q(1000000000),
					rule => q(←← ቢሊዮን[ →→]),
				},
				'1000000000000' => {
					base_value => q(1000000000000),
					divisor => q(1000000000000),
					rule => q(←← ቲሪሊዮን[ →→]),
				},
				'1000000000000000' => {
					base_value => q(1000000000000000),
					divisor => q(1000000000000000),
					rule => q(←← ቈዲሪሊዮን[ →→]),
				},
				'1000000000000000000' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
				'max' => {
					base_value => q(1000000000000000000),
					divisor => q(1000000000000000000),
					rule => q(=#,##0=),
				},
			},
		},
		'spellout-numbering' => {
			'public' => {
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
				'max' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-cardinal=),
				},
			},
		},
		'spellout-numbering-year' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ቅንስናሽ →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=0.0=),
				},
				'1100' => {
					base_value => q(1100),
					divisor => q(100),
					rule => q(←← መቶ[ →→]),
				},
				'10000' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(=%spellout-numbering=),
				},
				'max' => {
					base_value => q(10000),
					divisor => q(10000),
					rule => q(=%spellout-numbering=),
				},
			},
		},
		'spellout-ordinal' => {
			'public' => {
				'-x' => {
					divisor => q(1),
					rule => q(ቅንስናሽ →→),
				},
				'0' => {
					base_value => q(0),
					divisor => q(1),
					rule => q(=%spellout-numbering=ኛ),
				},
				'x.x' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
				'max' => {
					divisor => q(1),
					rule => q(=#,##0.#=),
				},
			},
		},
    } },
);

has 'display_name_language' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		 sub {
			 my %languages = (
				'aa' => 'አፋርኛ',
 				'ab' => 'አብሐዚኛ',
 				'ace' => 'አቻይንኛ',
 				'ach' => 'አኮሊኛ',
 				'ada' => 'አዳንግሜ',
 				'ady' => 'አድይግሄ',
 				'ae' => 'አቬስታን',
 				'af' => 'አፍሪካንኛ',
 				'afh' => 'አፍሪሂሊ',
 				'agq' => 'አገም',
 				'ain' => 'አይኑ',
 				'ak' => 'አካንኛ',
 				'akk' => 'አካዲያን',
 				'akz' => 'አላባማ',
 				'ale' => 'አልዩት',
 				'alt' => 'ደቡባዊ አልታይ',
 				'am' => 'አማርኛ',
 				'an' => 'አራጎንስ',
 				'ann' => 'ኦቦሎ',
 				'anp' => 'አንጊካ',
 				'ar' => 'ዓረብኛ',
 				'ar_001' => 'ዘመናዊ መደበኛ ዓረብኛ',
 				'arc' => 'አራማይክ',
 				'arn' => 'ማፑቼ',
 				'aro' => 'አራኦና',
 				'arp' => 'አራፓሆ',
 				'arq' => 'የአልጄሪያ ዓረብኛ',
 				'ars' => 'ናጅዲ አረብኛ',
 				'arw' => 'አራዋክ',
 				'as' => 'አሳሜዛዊ',
 				'asa' => 'አሱ',
 				'ase' => 'የአሜሪካ የምልክት ቋንቋ',
 				'ast' => 'አስቱሪያን',
 				'atj' => 'አቲካምከው',
 				'av' => 'አቫሪክ',
 				'awa' => 'አዋድሂ',
 				'ay' => 'አያማርኛ',
 				'az' => 'አዘርባጃንኛ',
 				'az@alt=short' => 'አዜሪ',
 				'ba' => 'ባስኪርኛ',
 				'bal' => 'ባሉቺ',
 				'ban' => 'ባሊኔስ',
 				'bar' => 'ባቫሪያን',
 				'bas' => 'ባሳ',
 				'bax' => 'ባሙን',
 				'bbc' => 'ባታካ ቶባ',
 				'be' => 'ቤላራሻኛ',
 				'bej' => 'ቤጃ',
 				'bem' => 'ቤምባ',
 				'bew' => 'ቤታዊ',
 				'bez' => 'ቤና',
 				'bfd' => 'ባፉት',
 				'bfq' => 'ባዳጋ',
 				'bg' => 'ቡልጋሪኛ',
 				'bgc' => 'ሃርያንቪ',
 				'bgn' => 'የምዕራብ ባሎቺ',
 				'bho' => 'ቦጁሪ',
 				'bi' => 'ቢስላምኛ',
 				'bik' => 'ቢኮል',
 				'bin' => 'ቢኒ',
 				'bjn' => 'ባንጃር',
 				'bla' => 'ሲክሲካ',
 				'bm' => 'ባምባርኛ',
 				'bn' => 'ቤንጋሊኛ',
 				'bo' => 'ቲቤታንኛ',
 				'bpy' => 'ቢሹንፑሪያ',
 				'bqi' => 'ባክህቲያሪ',
 				'br' => 'ብሬቶንኛ',
 				'bra' => 'ብራጅ',
 				'brh' => 'ብራሁዪ',
 				'brx' => 'ቦዶ',
 				'bs' => 'ቦስኒያንኛ',
 				'bss' => 'አኮስ',
 				'bua' => 'ቡሪያት',
 				'bug' => 'ቡጊኔዝ',
 				'bum' => 'ቡሉ',
 				'byn' => 'ብሊን',
 				'ca' => 'ካታላንኛ',
 				'cad' => 'ካዶ',
 				'car' => 'ካሪብ',
 				'cay' => 'ካዩጋ',
 				'cch' => 'አትሳም',
 				'ccp' => 'ቻክማ',
 				'ce' => 'ችችን',
 				'ceb' => 'ካቡዋኖ',
 				'cgg' => 'ቺጋኛ',
 				'ch' => 'ቻሞሮ',
 				'chb' => 'ቺብቻ',
 				'chg' => 'ቻጋታይ',
 				'chk' => 'ቹክስ',
 				'chm' => 'ማሪ',
 				'chn' => 'ቺኑክ ጃርጎን',
 				'cho' => 'ቾክታዋ',
 				'chp' => 'ቺፔውያን',
 				'chr' => 'ቼሮኬኛ',
 				'chy' => 'ችዬኔ',
 				'ckb' => 'የሶራኒ ኩርድኛ',
 				'clc' => 'ቺልኮቲን',
 				'co' => 'ኮርሲካኛ',
 				'cop' => 'ኮፕቲክ',
 				'cps' => 'ካፒዝኖን',
 				'cr' => 'ክሪ',
 				'crg' => 'ሚቺፍ',
 				'crh' => 'ክሪሚያን ተርኪሽ',
 				'crj' => 'ደቡብ ምዕራባዊ ክሪ',
 				'crk' => 'ፕላይንስ ክሪ',
 				'crl' => 'ሰሜን ምስራቃዊ ክሪ',
 				'crm' => 'ሙዝ ክሪ',
 				'crr' => 'ካሮሊና አልጎንክዊያን',
 				'crs' => 'ሰሰላዊ ክሬኦሊ ፈረንሳይኛ',
 				'cs' => 'ቼክኛ',
 				'csw' => 'ስዋምፒ ክሪ',
 				'cu' => 'ቸርች ስላቪክ',
 				'cv' => 'ቹቫሽ',
 				'cy' => 'ወልሽ',
 				'da' => 'ዴኒሽ',
 				'dak' => 'ዳኮታ',
 				'dar' => 'ዳርግዋ',
 				'dav' => 'ታይታ',
 				'de' => 'ጀርመንኛ',
 				'de_AT' => 'የኦስትሪያ ጀርመንኛ',
 				'de_CH' => 'የስዊዝ ከፍተኛ ጀርመንኛ',
 				'del' => 'ዳላዌር',
 				'dgr' => 'ዶግሪብ',
 				'din' => 'ዲንካ',
 				'dje' => 'ዛርማኛ',
 				'doi' => 'ዶግሪ',
 				'dsb' => 'የታችኛው ሰርቢያኛ',
 				'dtp' => 'ሴንተራል ዱሰን',
 				'dua' => 'ዱዋላኛ',
 				'dv' => 'ዲቬሂ',
 				'dyo' => 'ጆላ-ፎንዪ',
 				'dyu' => 'ድዩላ',
 				'dz' => 'ድዞንግኻኛ',
 				'dzg' => 'ዳዛጋ',
 				'ebu' => 'ኢምቡ',
 				'ee' => 'ኢዊ',
 				'efi' => 'ኤፊክ',
 				'egy' => 'የጥንታዊ ግብጽኛ',
 				'eka' => 'ኤካጁክ',
 				'el' => 'ግሪክኛ',
 				'en' => 'እንግሊዝኛ',
 				'en_AU' => 'የአውስትራሊያ እንግሊዝኛ',
 				'en_CA' => 'የካናዳ እንግሊዝኛ',
 				'en_GB' => 'የብሪቲሽ እንግሊዝኛ',
 				'en_GB@alt=short' => 'የዩናይትድ ኪንግደም እንግሊዝኛ',
 				'en_US' => 'የአሜሪካ እንግሊዝኛ',
 				'en_US@alt=short' => 'የዩ ኤስ እንግሊዝኛ',
 				'eo' => 'ኤስፐራንቶ',
 				'es' => 'ስፓኒሽ',
 				'es_419' => 'የላቲን አሜሪካ ስፓኒሽ',
 				'es_ES' => 'የአውሮፓ ስፓኒሽ',
 				'es_MX' => 'የሜክሲኮ ስፓኒሽ',
 				'esu' => 'ሴንተራል ዩፒክ',
 				'et' => 'ኢስቶኒያንኛ',
 				'eu' => 'ባስክኛ',
 				'ewo' => 'ኤዎንዶ',
 				'fa' => 'ፐርሺያኛ',
 				'fa_AF' => 'ዳሪ',
 				'ff' => 'ፉላ',
 				'fi' => 'ፊኒሽ',
 				'fil' => 'ፊሊፒንኛ',
 				'fj' => 'ፊጂኛ',
 				'fo' => 'ፋሮኛ',
 				'fon' => 'ፎን',
 				'fr' => 'ፈረንሳይኛ',
 				'fr_CA' => 'የካናዳ ፈረንሳይኛ',
 				'fr_CH' => 'የስዊዝ ፈረንሳይኛ',
 				'frc' => 'ካጁን ፍሬንች',
 				'frp' => 'አርፒታን',
 				'frr' => 'ሰሜናዊ ፍሪስያን',
 				'fur' => 'ፍሩሊያን',
 				'fy' => 'ምዕራባዊ ፍሪሲኛ',
 				'ga' => 'አይሪሽ',
 				'gaa' => 'ጋ',
 				'gag' => 'ጋጉዝኛ',
 				'gan' => 'ጋን ቻይንኛ',
 				'gd' => 'ስኮቲሽ ጋይሊክ',
 				'gez' => 'ግዕዝኛ',
 				'gil' => 'ጅልበርትስ',
 				'gl' => 'ጋሊሽያዊ',
 				'gn' => 'ጓራኒኛ',
 				'gor' => 'ጎሮንታሎ',
 				'grc' => 'የጥንታዊ ግሪክ',
 				'gsw' => 'ስዊዝ ጀርመንኛ',
 				'gu' => 'ጉጃርቲኛ',
 				'guz' => 'ጉስሊኛ',
 				'gv' => 'ማንክስ',
 				'gwi' => 'ግዊቺን',
 				'ha' => 'ሃውሳኛ',
 				'hai' => 'ሃይዳ',
 				'hak' => 'ሃካ ቻይንኛ',
 				'haw' => 'ሃዊያኛ',
 				'hax' => 'ደቡባዊ ሃይዳ',
 				'he' => 'ዕብራይስጥ',
 				'hi' => 'ሒንዱኛ',
 				'hi_Latn@alt=variant' => 'ሂንግሊሽ',
 				'hil' => 'ሂሊጋይኖን',
 				'hmn' => 'ህሞንግ',
 				'hr' => 'ክሮሽያንኛ',
 				'hsb' => 'የላይኛው ሶርቢያንኛ',
 				'hsn' => 'ዢያንግ ቻይንኛ',
 				'ht' => 'ሃይትኛ ክሮሌ',
 				'hu' => 'ሀንጋሪኛ',
 				'hup' => 'ሁፓ',
 				'hur' => 'ሃልኮመልም',
 				'hy' => 'አርመናዊ',
 				'hz' => 'ሄሬሮ',
 				'ia' => 'ኢንቴርሊንጓ',
 				'iba' => 'ኢባን',
 				'ibb' => 'ኢቢብዮ',
 				'id' => 'ኢንዶኔዥያኛ',
 				'ie' => 'እንተርሊንግወ',
 				'ig' => 'ኢግቦኛ',
 				'ii' => 'ሲቹዋን ዪ',
 				'ik' => 'እኑፒያቅኛ',
 				'ikt' => 'የምዕራባዊ ካናዳ ኢኑክቲቱት',
 				'ilo' => 'ኢሎኮ',
 				'inh' => 'ኢንጉሽ',
 				'io' => 'ኢዶ',
 				'is' => 'አይስላንድኛ',
 				'it' => 'ጣሊያንኛ',
 				'iu' => 'እኑክቲቱትኛ',
 				'ja' => 'ጃፓንኛ',
 				'jbo' => 'ሎጅባን',
 				'jgo' => 'ንጎምባ',
 				'jmc' => 'ማቻሜኛ',
 				'jv' => 'ጃቫኒዝ',
 				'ka' => 'ጆርጂያዊ',
 				'kab' => 'ካብይል',
 				'kac' => 'ካቺን',
 				'kaj' => 'ጅጁ',
 				'kam' => 'ካምባ',
 				'kbd' => 'ካባርዲያን',
 				'kcg' => 'ታያፕ',
 				'kde' => 'ማኮንዴ',
 				'kea' => 'ካቡቨርዲያኑ',
 				'kfo' => 'ኮሮ',
 				'kg' => 'ኮንጎኛ',
 				'kgp' => 'ካይንጋንግ',
 				'kha' => 'ካሲ',
 				'khq' => 'ኮይራ ቺኒ',
 				'ki' => 'ኪኩዩ',
 				'kj' => 'ኩዋንያማ',
 				'kk' => 'ካዛክኛ',
 				'kkj' => 'ካኮ',
 				'kl' => 'ካላሊሱት',
 				'kln' => 'ካለንጂን',
 				'km' => 'ክመር',
 				'kmb' => 'ኪምቡንዱ',
 				'kn' => 'ካናዳ',
 				'ko' => 'ኮሪያኛ',
 				'koi' => 'ኮሚ ፔርምያክ',
 				'kok' => 'ኮንካኒ',
 				'kpe' => 'ክፔሌ',
 				'kr' => 'ካኑሪ',
 				'krc' => 'ካራቻይ-ባልካር',
 				'krl' => 'ካረሊያን',
 				'kru' => 'ኩሩክ',
 				'ks' => 'ካሽሚርኛ',
 				'ksb' => 'ሻምባላ',
 				'ksf' => 'ባፊያ',
 				'ksh' => 'ኮሎኝኛ',
 				'ku' => 'ኩርድሽ',
 				'kum' => 'ኩማይክ',
 				'kv' => 'ኮሚ',
 				'kw' => 'ኮርኒሽ',
 				'kwk' => 'ክዋክዋላ',
 				'ky' => 'ክይርግይዝ',
 				'la' => 'ላቲንኛ',
 				'lad' => 'ላዲኖ',
 				'lag' => 'ላንጊ',
 				'lb' => 'ሉክሰምበርግኛ',
 				'lez' => 'ሌዝጊያን',
 				'lg' => 'ጋንዳኛ',
 				'li' => 'ሊምቡርጊሽ',
 				'lil' => 'ሊሎኤት',
 				'lkt' => 'ላኮታ',
 				'ln' => 'ሊንጋላ',
 				'lo' => 'ላኦኛ',
 				'lou' => 'ሉዊዚያና ክሬኦል',
 				'loz' => 'ሎዚ',
 				'lrc' => 'ሰሜናዊ ሉሪ',
 				'lsm' => 'ሳሚያ',
 				'lt' => 'ሉቴንያንኛ',
 				'lu' => 'ሉባ-ካታንጋ',
 				'lua' => 'ሉባ-ሉሏ',
 				'lun' => 'ሉንዳ',
 				'luo' => 'ሉኦ',
 				'lus' => 'ሚዞ',
 				'luy' => 'ሉያ',
 				'lv' => 'ላትቪያን',
 				'mad' => 'ማዱረስ',
 				'mag' => 'ማጋሂ',
 				'mai' => 'ማይቲሊ',
 				'mak' => 'ማካሳር',
 				'mas' => 'ማሳይ',
 				'mdf' => 'ሞክሻ',
 				'men' => 'ሜንዴ',
 				'mer' => 'ሜሩ',
 				'mfe' => 'ሞሪስየን',
 				'mg' => 'ማላጋስይ',
 				'mgh' => 'ማኩዋ-ሜቶ',
 				'mgo' => 'ሜታ',
 				'mh' => 'ማርሻሊዝ',
 				'mi' => 'ማኦሪ',
 				'mic' => 'ሚክማው',
 				'min' => 'ሚናንግካባኡ',
 				'mk' => 'ሜቄዶንኛ',
 				'ml' => 'ማላያላም',
 				'mn' => 'ሞንጎሊያኛ',
 				'mni' => 'ማኒፑሪ',
 				'moe' => 'ኢኑ-አይመን',
 				'moh' => 'ሞሃውክ',
 				'mos' => 'ሞሲ',
 				'mr' => 'ማራቲ',
 				'ms' => 'ማላይ',
 				'mt' => 'ማልቲስ',
 				'mua' => 'ሙንዳንግ',
 				'mul' => 'ባለብዙ ቋንቋዎች',
 				'mus' => 'ሙስኮኪ',
 				'mwl' => 'ሚራንዴዝ',
 				'my' => 'ቡርማኛ',
 				'myv' => 'ኤርዝያ',
 				'mzn' => 'ማዛንደራኒ',
 				'na' => 'ናኡሩ',
 				'nan' => 'ሚን ኛን ቻይንኛ',
 				'nap' => 'ኒአፖሊታን',
 				'naq' => 'ናማ',
 				'nb' => 'የኖርዌይ ቦክማል',
 				'nd' => 'ሰሜን ንዴብሌ',
 				'nds' => 'የታችኛው ጀርመንኛ',
 				'nds_NL' => 'የታችኛው ሳክሰን',
 				'ne' => 'ኔፓሊኛ',
 				'new' => 'ኒዋሪ(ኔፓል)',
 				'ng' => 'ንዶንጋ',
 				'nia' => 'ኒአስ',
 				'niu' => 'ኒዩአንኛ',
 				'njo' => 'ኦ ናጋ',
 				'nl' => 'ደች',
 				'nl_BE' => 'ፍሌሚሽ',
 				'nmg' => 'ክዋሲዮ',
 				'nn' => 'የኖርዌይ ናይኖርስክ',
 				'nnh' => 'ኒጊምቡን',
 				'no' => 'ኖርዌጂያን',
 				'nog' => 'ኖጋይ',
 				'nqo' => 'ንኮ',
 				'nr' => 'ደቡብ ንደቤሌ',
 				'nso' => 'ሰሜናዊ ሶቶ',
 				'nus' => 'ኑዌር',
 				'nv' => 'ናቫጆ',
 				'nwc' => 'ክላሲክ ኔዋሪ',
 				'ny' => 'ንያንጃ',
 				'nyn' => 'ኒያንኮል',
 				'oc' => 'ኦሲታን',
 				'ojb' => 'ሰሜን ምዕራባዊ ኦጂብዋ',
 				'ojc' => 'ማዕከላዊ ኦጂብዋ',
 				'ojs' => 'ኦጂ-ክሪ',
 				'ojw' => 'ምዕራባዊ ኦጂቡዋ',
 				'oka' => 'ኦካናጋን',
 				'om' => 'ኦሮሚኛ',
 				'or' => 'ኦዲያ',
 				'os' => 'ኦሴቲክ',
 				'pa' => 'ፑንጃብኛ',
 				'pag' => 'ፓንጋሲናን',
 				'pam' => 'ፓምፓንጋ',
 				'pap' => 'ፓፒያሜንቶ',
 				'pau' => 'ፓሉዋን',
 				'pcm' => 'የናይጄሪያ ፒጂን',
 				'pis' => 'ፒጂን',
 				'pl' => 'ፖሊሽ',
 				'pqm' => 'ማሊሴት-ፓሳማኩዎድይ',
 				'prg' => 'ፐሩሳንኛ',
 				'ps' => 'ፓሽቶ',
 				'ps@alt=variant' => 'ፑሽቶ',
 				'pt' => 'ፖርቹጋልኛ',
 				'pt_BR' => 'የብራዚል ፖርቹጋልኛ',
 				'pt_PT' => 'የአውሮፓ ፖርቹጋልኛ',
 				'qu' => 'ኩዌቹዋ',
 				'quc' => 'ኪቼ',
 				'qug' => 'ቺምቦራዞ ሃይላንድ ኩቹዋ',
 				'raj' => 'ራጃስታኒ',
 				'rap' => 'ራፓኑኢ',
 				'rar' => 'ራሮቶንጋን',
 				'rhg' => 'ሮሂንግያ',
 				'rm' => 'ሮማንሽ',
 				'rn' => 'ሩንዲ',
 				'ro' => 'ሮማኒያኛ',
 				'ro_MD' => 'ሞልዳቪያንኛ',
 				'rof' => 'ሮምቦ',
 				'ru' => 'ራሽያኛ',
 				'rup' => 'አሮማንያን',
 				'rw' => 'ኪንያርዋንዳ',
 				'rwk' => 'ርዋ',
 				'sa' => 'ሳንስክሪት',
 				'sad' => 'ሳንዳዌ',
 				'sah' => 'ሳክሃ',
 				'saq' => 'ሳምቡሩ',
 				'sat' => 'ሳንታሊ',
 				'sba' => 'ንጋምባይ',
 				'sbp' => 'ሳንጉ',
 				'sc' => 'ሳርዲንያን',
 				'scn' => 'ሲሲሊያንኛ',
 				'sco' => 'ስኮትስ',
 				'sd' => 'ሲንዲ',
 				'sdh' => 'ደቡባዊ ኩርዲሽ',
 				'se' => 'ሰሜናዊ ሳሚ',
 				'seh' => 'ሴና',
 				'ses' => 'ኮይራቦሮ ሴኒ',
 				'sg' => 'ሳንጎ',
 				'sh' => 'ሰርቦ-ክሮኤሽያኛ',
 				'shi' => 'ታቼልሂት',
 				'shn' => 'ሻን',
 				'shu' => 'ቻዲያን ዓረብኛ',
 				'si' => 'ሲንሃላ',
 				'sid' => 'ሲዳምኛ',
 				'sk' => 'ስሎቫክኛ',
 				'sl' => 'ስሎቬንኛ',
 				'slh' => 'ደቡባዊ ሉሹትሲድ',
 				'sm' => 'ሳሞኣን',
 				'sma' => 'ደቡባዊ ሳሚ',
 				'smj' => 'ሉሌ ሳሚ',
 				'smn' => 'ኢናሪ ሳሚ',
 				'sms' => 'ስኮልት ሳሚ',
 				'sn' => 'ሾና',
 				'snk' => 'ሶኒንኬ',
 				'so' => 'ሱማልኛ',
 				'sq' => 'አልባንያንኛ',
 				'sr' => 'ሰርብያኛ',
 				'srn' => 'ስራናን ቶንጎ',
 				'ss' => 'ስዋቲ',
 				'ssy' => 'ሳሆኛ',
 				'st' => 'ደቡባዊ ሶቶ',
 				'str' => 'ስትሬይትስ ስታሊሽ',
 				'su' => 'ሱዳንኛ',
 				'suk' => 'ሱኩማ',
 				'sv' => 'ስዊድንኛ',
 				'sw' => 'ስዋሂሊኛ',
 				'sw_CD' => 'ኮንጎ ስዋሂሊ',
 				'swb' => 'ኮሞሪያን',
 				'syc' => 'ክላሲክ ኔይራ',
 				'syr' => 'ሲሪያክ',
 				'ta' => 'ታሚል',
 				'tce' => 'ደቡባዊ ቱትቾን',
 				'te' => 'ተሉጉ',
 				'tem' => 'ቲምኔ',
 				'teo' => 'ቴሶ',
 				'tet' => 'ቴተም',
 				'tg' => 'ታጂክ',
 				'tgx' => 'ታጊሽ',
 				'th' => 'ታይ',
 				'tht' => 'ታህልታን',
 				'ti' => 'ትግርኛ',
 				'tig' => 'ትግረ',
 				'tk' => 'ቱርክሜን',
 				'tl' => 'ታጋሎገኛ',
 				'tlh' => 'ክሊንጎን',
 				'tli' => 'ትሊንጊት',
 				'tn' => 'ጽዋና',
 				'to' => 'ቶንጋን',
 				'tok' => 'ቶኪ ፖና',
 				'tpi' => 'ቶክ ፒሲን',
 				'tr' => 'ቱርክኛ',
 				'trv' => 'ታሮኮ',
 				'ts' => 'ጾንጋ',
 				'tt' => 'ታታር',
 				'ttm' => 'ሰሜናዊ ቱትቾን',
 				'tum' => 'ቱምቡካ',
 				'tvl' => 'ቱቫሉ',
 				'tw' => 'ትዊኛ',
 				'twq' => 'ታሳዋክ',
 				'ty' => 'ታሂታንኛ',
 				'tyv' => 'ቱቪንያንኛ',
 				'tzm' => 'መካከለኛው አትላስ ታማዚኛ',
 				'udm' => 'ኡድሙርት',
 				'ug' => 'ኡይግሁር',
 				'ug@alt=variant' => 'ኡይገር',
 				'uk' => 'ዩክሬንኛ',
 				'umb' => 'ኡምቡንዱ',
 				'und' => 'ያልታወቀ ቋንቋ',
 				'ur' => 'ኡርዱኛ',
 				'uz' => 'ኡዝቤክኛ',
 				'vai' => 'ቫይ',
 				've' => 'ቬንዳ',
 				'vi' => 'ቪየትናምኛ',
 				'vo' => 'ቮላፑክኛ',
 				'vun' => 'ቩንጆ',
 				'wa' => 'ዋሎን',
 				'wae' => 'ዋልሰር',
 				'wal' => 'ወላይትኛ',
 				'war' => 'ዋራይ',
 				'wbp' => 'ዋርልፒሪ',
 				'wo' => 'ዎሎፍኛ',
 				'wuu' => 'ዉ ቻይንኛ',
 				'xal' => 'ካልማይክ',
 				'xh' => 'ዞሳኛ',
 				'xog' => 'ሶጋ',
 				'yav' => 'ያንግቤንኛ',
 				'ybb' => 'የምባ',
 				'yi' => 'ይዲሽኛ',
 				'yo' => 'ዮሩባዊኛ',
 				'yrl' => 'ንሄንጋቱ',
 				'yue' => 'ካንቶኒዝ',
 				'yue@alt=menu' => 'ቻይና፤ ካንቶንኛ',
 				'za' => 'ዡዋንግኛ',
 				'zbl' => 'ብሊስይምቦልስ',
 				'zgh' => 'መደበኛ የሞሮኮ ታማዚግት',
 				'zh' => 'ቻይንኛ',
 				'zh@alt=menu' => 'ማንድሪን ቻይንኛ',
 				'zh_Hans' => 'ቀለል ያለ ቻይንኛ',
 				'zh_Hans@alt=long' => 'ቀለል ያለ ማንድሪን ቻይንኛ',
 				'zh_Hant' => 'ባህላዊ ቻይንኛ',
 				'zh_Hant@alt=long' => 'ባህላዊ ማንድሪን ቻይንኛ',
 				'zu' => 'ዙሉኛ',
 				'zun' => 'ዙኒ',
 				'zxx' => 'ቋንቋዊ ይዘት የለውም',
 				'zza' => 'ዛዛ',

			);
			if (@_) {
				return $languages{$_[0]};
			}
			return \%languages;
		}
	},
);

has 'display_name_script' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub {
		sub {
			my %scripts = (
			'Adlm' => 'አድላም',
 			'Arab' => 'ዓረብኛ',
 			'Arab@alt=variant' => 'ፔርሶ-አረብኛ',
 			'Aran' => 'ናስታሊክ',
 			'Armn' => 'አርሜንያዊ',
 			'Beng' => 'ቤንጋሊ',
 			'Bopo' => 'ቦፖሞፎ',
 			'Brai' => 'ብሬይል',
 			'Buhd' => 'ቡሂድ',
 			'Cakm' => 'ቻክማ',
 			'Cans' => 'የተዋሐዱ የካናዳ ጥንታዊ ምልክቶች',
 			'Cher' => 'ቼሮኪ',
 			'Copt' => 'ኮፕቲክ',
 			'Cprt' => 'ሲፕሪኦት',
 			'Cyrl' => 'ሲይሪልክ',
 			'Deva' => 'ደቫንጋሪ',
 			'Dsrt' => 'ዴዘረት',
 			'Ethi' => 'ኢትዮፒክ',
 			'Geor' => 'ጆርጂያኛ',
 			'Goth' => 'ጐቲክ',
 			'Grek' => 'ግሪክ',
 			'Gujr' => 'ጉጃራቲ',
 			'Guru' => 'ጉርሙኪ',
 			'Hanb' => 'ሃንብ',
 			'Hang' => 'ሐንጉል',
 			'Hani' => 'ሃን',
 			'Hano' => 'ሀኑኦ',
 			'Hans' => 'ቀለል ያለ',
 			'Hans@alt=stand-alone' => 'ቀለል ያለ ሃን',
 			'Hant' => 'ባህላዊ',
 			'Hant@alt=stand-alone' => 'ባህላዊ ሃን',
 			'Hebr' => 'እብራይስጥ',
 			'Hira' => 'ሂራጋና',
 			'Hrkt' => 'ጃፓንኛ ስይላቤሪስ',
 			'Jamo' => 'ጃሞ',
 			'Jpan' => 'ጃፓንኛ',
 			'Kana' => 'ካታካና',
 			'Khmr' => 'ክህመር',
 			'Knda' => 'ካንአዳ',
 			'Kore' => 'ኮሪያኛ',
 			'Laoo' => 'ላኦ',
 			'Latn' => 'ላቲን',
 			'Limb' => 'ሊምቡ',
 			'Lina' => 'ሊኒያር ኤ',
 			'Linb' => 'ሊኒያር ቢ',
 			'Mlym' => 'ማላይላም',
 			'Mong' => 'ሞንጎሊያኛ',
 			'Mtei' => 'ሜቴ ማይክ',
 			'Mymr' => 'ምያንማር',
 			'Nkoo' => 'ንኮ',
 			'Ogam' => 'ኦግሀም',
 			'Olck' => 'ኦይ ቺኪ',
 			'Orya' => 'ኦሪያ',
 			'Osma' => 'ኦስማኒያ',
 			'Rohg' => 'ሃኒፊ',
 			'Runr' => 'ሩኒክ',
 			'Shaw' => 'የሻቪያ ፊደል',
 			'Sinh' => 'ሲንሃላ',
 			'Sund' => 'ሱዳናዊ',
 			'Syrc' => 'ሲሪክ',
 			'Tagb' => 'ትአግባንዋ',
 			'Tale' => 'ታኢ ለ',
 			'Talu' => 'አዲስ ታኢ ሉ',
 			'Taml' => 'ታሚል',
 			'Telu' => 'ተሉጉ',
 			'Tfng' => 'ቲፊናግህ',
 			'Tglg' => 'ታጋሎግ',
 			'Thaa' => 'ታና',
 			'Thai' => 'ታይ',
 			'Tibt' => 'ቲቤታን',
 			'Ugar' => 'ኡጋሪቲክ',
 			'Vaii' => 'ቫይ',
 			'Yiii' => 'ዪ',
 			'Zinh' => 'የተወረሰ',
 			'Zmth' => 'የሂሳብ መግለጫ',
 			'Zsye' => 'ኢሞጂ',
 			'Zsym' => 'ምልክቶች',
 			'Zxxx' => 'ያልተጻፈ',
 			'Zyyy' => 'የጋራ',
 			'Zzzz' => 'ያልታወቀ ስክሪፕት',

			);
			if ( @_ ) {
				return $scripts{$_[0]};
			}
			return \%scripts;
		}
	}
);

has 'display_name_region' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'001' => 'ዓለም',
 			'002' => 'አፍሪካ',
 			'003' => 'ሰሜን አሜሪካ',
 			'005' => 'ደቡብ አሜሪካ',
 			'009' => 'ኦሺንያ',
 			'011' => 'ምስራቃዊ አፍሪካ',
 			'013' => 'መካከለኛው አሜሪካ',
 			'014' => 'ምስራቅ አፍሪካ',
 			'015' => 'ሰሜናዊ አፍሪካ',
 			'017' => 'መካከለኛው አፍሪካ',
 			'018' => 'ደቡባዊ አፍሪካ',
 			'019' => 'አሜሪካ',
 			'021' => 'ሰሜናዊ አሜሪካ',
 			'029' => 'ካሪቢያን',
 			'030' => 'ምስራቃዊ እስያ',
 			'034' => 'ደቡባዊ እሲያ',
 			'035' => 'ደቡብ ምስራቅ እሲያ',
 			'039' => 'ደቡባዊ አውሮፓ',
 			'053' => 'አውስትራሌዥያ',
 			'054' => 'ሜላኔዥያ',
 			'057' => 'የማይክሮኔዥያን ክልል',
 			'061' => 'ፖሊኔዥያ',
 			'142' => 'እሲያ',
 			'143' => 'መካከለኛው እሲያ',
 			'145' => 'ምዕራባዊ እስያ',
 			'150' => 'አውሮፓ',
 			'151' => 'ምስራቅ አውሮፓ',
 			'154' => 'ሰሜናዊ አውሮፓ',
 			'155' => 'ምዕራብ አውሮፓ',
 			'202' => 'ከሰሃራ በታች አፍሪካ',
 			'419' => 'ላቲን አሜሪካ',
 			'AC' => 'አሴንሽን ደሴት',
 			'AD' => 'አንዶራ',
 			'AE' => 'የተባበሩት ዓረብ ኤምሬትስ',
 			'AF' => 'አፍጋኒስታን',
 			'AG' => 'አንቲጓ እና ባሩዳ',
 			'AI' => 'አንጉይላ',
 			'AL' => 'አልባኒያ',
 			'AM' => 'አርሜኒያ',
 			'AO' => 'አንጐላ',
 			'AQ' => 'አንታርክቲካ',
 			'AR' => 'አርጀንቲና',
 			'AS' => 'የአሜሪካ ሳሞአ',
 			'AT' => 'ኦስትሪያ',
 			'AU' => 'አውስትራልያ',
 			'AW' => 'አሩባ',
 			'AX' => 'የአላንድ ደሴቶች',
 			'AZ' => 'አዘርባጃን',
 			'BA' => 'ቦስኒያ እና ሄርዞጎቪኒያ',
 			'BB' => 'ባርቤዶስ',
 			'BD' => 'ባንግላዲሽ',
 			'BE' => 'ቤልጄም',
 			'BF' => 'ቡርኪና ፋሶ',
 			'BG' => 'ቡልጌሪያ',
 			'BH' => 'ባህሬን',
 			'BI' => 'ብሩንዲ',
 			'BJ' => 'ቤኒን',
 			'BL' => 'ቅዱስ በርቴሎሜ',
 			'BM' => 'ቤርሙዳ',
 			'BN' => 'ብሩኒ',
 			'BO' => 'ቦሊቪያ',
 			'BQ' => 'የካሪቢያን ኔዘርላንድስ',
 			'BR' => 'ብራዚል',
 			'BS' => 'ባሃማስ',
 			'BT' => 'ቡህታን',
 			'BV' => 'ቡቬት ደሴት',
 			'BW' => 'ቦትስዋና',
 			'BY' => 'ቤላሩስ',
 			'BZ' => 'በሊዝ',
 			'CA' => 'ካናዳ',
 			'CC' => 'ኮኮስ(ኬሊንግ) ደሴቶች',
 			'CD' => 'ኮንጎ-ኪንሻሳ',
 			'CD@alt=variant' => 'ኮንጎ (የዲሞክራቲክ ሪፐብሊክ ኮንጎ)',
 			'CF' => 'ማዕከላዊ አፍሪካ ሪፑብሊክ',
 			'CG' => 'ኮንጎ ብራዛቪል',
 			'CG@alt=variant' => 'ኮንጎ (ሪፑብሊክ)',
 			'CH' => 'ስዊዘርላንድ',
 			'CI' => 'ኮትዲቯር',
 			'CI@alt=variant' => 'አይቮሪኮስት',
 			'CK' => 'ኩክ ደሴቶች',
 			'CL' => 'ቺሊ',
 			'CM' => 'ካሜሩን',
 			'CN' => 'ቻይና',
 			'CO' => 'ኮሎምቢያ',
 			'CP' => 'ክሊፐርቶን ደሴት',
 			'CR' => 'ኮስታሪካ',
 			'CU' => 'ኩባ',
 			'CV' => 'ኬፕቨርዴ',
 			'CW' => 'ኩራሳዎ',
 			'CX' => 'ክሪስማስ ደሴት',
 			'CY' => 'ሳይፕረስ',
 			'CZ' => 'ቼቺያ',
 			'CZ@alt=variant' => 'ቼክ ሪፑብሊክ',
 			'DE' => 'ጀርመን',
 			'DG' => 'ዲዬጎ ጋርሺያ',
 			'DJ' => 'ጂቡቲ',
 			'DK' => 'ዴንማርክ',
 			'DM' => 'ዶሚኒካ',
 			'DO' => 'ዶመኒካን ሪፑብሊክ',
 			'DZ' => 'አልጄሪያ',
 			'EA' => 'ሴኡታና ሜሊላ',
 			'EC' => 'ኢኳዶር',
 			'EE' => 'ኤስቶኒያ',
 			'EG' => 'ግብጽ',
 			'EH' => 'ምዕራባዊ ሳህራ',
 			'ER' => 'ኤርትራ',
 			'ES' => 'ስፔን',
 			'ET' => 'ኢትዮጵያ',
 			'EU' => 'የአውሮፓ ህብረት',
 			'EZ' => 'የአውሮፓ ዞን',
 			'FI' => 'ፊንላንድ',
 			'FJ' => 'ፊጂ',
 			'FK' => 'የፎክላንድ ደሴቶች',
 			'FK@alt=variant' => 'ፎክላንድ ደሴቶች (ኢስላስ ማልቪናስ)',
 			'FM' => 'ሚክሮኔዢያ',
 			'FO' => 'የፋሮ ደሴቶች',
 			'FR' => 'ፈረንሳይ',
 			'GA' => 'ጋቦን',
 			'GB' => 'ዩናይትድ ኪንግደም',
 			'GD' => 'ግሬናዳ',
 			'GE' => 'ጆርጂያ',
 			'GF' => 'የፈረንሳይ ጉዊአና',
 			'GG' => 'ጉርነሲ',
 			'GH' => 'ጋና',
 			'GI' => 'ጂብራልተር',
 			'GL' => 'ግሪንላንድ',
 			'GM' => 'ጋምቢያ',
 			'GN' => 'ጊኒ',
 			'GP' => 'ጉዋደሉፕ',
 			'GQ' => 'ኢኳቶሪያል ጊኒ',
 			'GR' => 'ግሪክ',
 			'GS' => 'ደቡብ ጆርጂያ እና የደቡብ ሳንድዊች ደሴቶች',
 			'GT' => 'ጉዋቲማላ',
 			'GU' => 'ጉዋም',
 			'GW' => 'ጊኒ-ቢሳው',
 			'GY' => 'ጉያና',
 			'HK' => 'ሆንግ ኮንግ ልዩ የአስተዳደር ክልል ቻይና',
 			'HK@alt=short' => 'ሆንግ ኮንግ',
 			'HM' => 'ኽርድ ደሴቶችና ማክዶናልድ ደሴቶች',
 			'HN' => 'ሆንዱራስ',
 			'HR' => 'ክሮኤሽያ',
 			'HT' => 'ሀይቲ',
 			'HU' => 'ሀንጋሪ',
 			'IC' => 'የካናሪ ደሴቶች',
 			'ID' => 'ኢንዶኔዢያ',
 			'IE' => 'አየርላንድ',
 			'IL' => 'እስራኤል',
 			'IM' => 'አይል ኦፍ ማን',
 			'IN' => 'ህንድ',
 			'IO' => 'የብሪታኒያ ህንድ ውቂያኖስ ግዛት',
 			'IO@alt=chagos' => 'ቻጎስ አርኪፔላጎ',
 			'IQ' => 'ኢራቅ',
 			'IR' => 'ኢራን',
 			'IS' => 'አይስላንድ',
 			'IT' => 'ጣሊያን',
 			'JE' => 'ጀርሲ',
 			'JM' => 'ጃማይካ',
 			'JO' => 'ጆርዳን',
 			'JP' => 'ጃፓን',
 			'KE' => 'ኬንያ',
 			'KG' => 'ኪርጊስታን',
 			'KH' => 'ካምቦዲያ',
 			'KI' => 'ኪሪባቲ',
 			'KM' => 'ኮሞሮስ',
 			'KN' => 'ቅዱስ ኪትስ እና ኔቪስ',
 			'KP' => 'ሰሜን ኮሪያ',
 			'KR' => 'ደቡብ ኮሪያ',
 			'KW' => 'ክዌት',
 			'KY' => 'ካይማን ደሴቶች',
 			'KZ' => 'ካዛኪስታን',
 			'LA' => 'ላኦስ',
 			'LB' => 'ሊባኖስ',
 			'LC' => 'ሴንት ሉቺያ',
 			'LI' => 'ሊችተንስታይን',
 			'LK' => 'ሲሪላንካ',
 			'LR' => 'ላይቤሪያ',
 			'LS' => 'ሌሶቶ',
 			'LT' => 'ሊቱዌኒያ',
 			'LU' => 'ሉክሰምበርግ',
 			'LV' => 'ላትቪያ',
 			'LY' => 'ሊቢያ',
 			'MA' => 'ሞሮኮ',
 			'MC' => 'ሞናኮ',
 			'MD' => 'ሞልዶቫ',
 			'ME' => 'ሞንተኔግሮ',
 			'MF' => 'ሴንት ማርቲን',
 			'MG' => 'ማዳጋስካር',
 			'MH' => 'ማርሻል አይላንድ',
 			'MK' => 'ሰሜን መቄዶንያ',
 			'ML' => 'ማሊ',
 			'MM' => 'ማይናማር(በርማ)',
 			'MN' => 'ሞንጎሊያ',
 			'MO' => 'ማካኦ ልዩ የአስተዳደር ክልል ቻይና',
 			'MO@alt=short' => 'ማካኦ',
 			'MP' => 'የሰሜናዊ ማሪያና ደሴቶች',
 			'MQ' => 'ማርቲኒክ',
 			'MR' => 'ሞሪቴኒያ',
 			'MS' => 'ሞንትሴራት',
 			'MT' => 'ማልታ',
 			'MU' => 'ሞሪሸስ',
 			'MV' => 'ማልዲቭስ',
 			'MW' => 'ማላዊ',
 			'MX' => 'ሜክሲኮ',
 			'MY' => 'ማሌዢያ',
 			'MZ' => 'ሞዛምቢክ',
 			'NA' => 'ናሚቢያ',
 			'NC' => 'ኒው ካሌዶኒያ',
 			'NE' => 'ኒጀር',
 			'NF' => 'ኖርፎልክ ደሴት',
 			'NG' => 'ናይጄሪያ',
 			'NI' => 'ኒካራጓ',
 			'NL' => 'ኔዘርላንድ',
 			'NO' => 'ኖርዌይ',
 			'NP' => 'ኔፓል',
 			'NR' => 'ናኡሩ',
 			'NU' => 'ኒኡይ',
 			'NZ' => 'ኒው ዚላንድ',
 			'OM' => 'ኦማን',
 			'PA' => 'ፓናማ',
 			'PE' => 'ፔሩ',
 			'PF' => 'የፈረንሳይ ፖሊኔዢያ',
 			'PG' => 'ፓፑዋ ኒው ጊኒ',
 			'PH' => 'ፊሊፒንስ',
 			'PK' => 'ፓኪስታን',
 			'PL' => 'ፖላንድ',
 			'PM' => 'ቅዱስ ፒዬር እና ሚኩኤሎን',
 			'PN' => 'ፒትካኢርን ደሴቶች',
 			'PR' => 'ፖርታ ሪኮ',
 			'PS' => 'የፍልስጤም ግዛት',
 			'PS@alt=short' => 'ፍልስጥኤም',
 			'PT' => 'ፖርቱጋል',
 			'PW' => 'ፓላው',
 			'PY' => 'ፓራጓይ',
 			'QA' => 'ኳታር',
 			'QO' => 'አውትላይንግ ኦሽንያ',
 			'RE' => 'ሪዩኒየን',
 			'RO' => 'ሮሜኒያ',
 			'RS' => 'ሰርብያ',
 			'RU' => 'ሩስያ',
 			'RW' => 'ሩዋንዳ',
 			'SA' => 'ሳውድአረቢያ',
 			'SB' => 'ሰሎሞን ደሴት',
 			'SC' => 'ሲሼልስ',
 			'SD' => 'ሱዳን',
 			'SE' => 'ስዊድን',
 			'SG' => 'ሲንጋፖር',
 			'SH' => 'ሴንት ሄለና',
 			'SI' => 'ስሎቬኒያ',
 			'SJ' => 'ስቫልባርድ እና ጃን ማየን',
 			'SK' => 'ስሎቫኪያ',
 			'SL' => 'ሴራሊዮን',
 			'SM' => 'ሳን ማሪኖ',
 			'SN' => 'ሴኔጋል',
 			'SO' => 'ሱማሌ',
 			'SR' => 'ሱሪናም',
 			'SS' => 'ደቡብ ሱዳን',
 			'ST' => 'ሳኦ ቶሜ እና ፕሪንሲፔ',
 			'SV' => 'ኤል ሳልቫዶር',
 			'SX' => 'ሲንት ማርተን',
 			'SY' => 'ሶሪያ',
 			'SZ' => 'ሱዋዚላንድ',
 			'SZ@alt=variant' => 'ስዋዚላንድ',
 			'TA' => 'ትሪስታን ዲ ኩንሃ',
 			'TC' => 'የቱርኮችና የካኢኮስ ደሴቶች',
 			'TD' => 'ቻድ',
 			'TF' => 'የፈረንሳይ ደቡባዊ ግዛቶች',
 			'TG' => 'ቶጐ',
 			'TH' => 'ታይላንድ',
 			'TJ' => 'ታጃኪስታን',
 			'TK' => 'ቶክላው',
 			'TL' => 'ቲሞር ሌስቴ',
 			'TL@alt=variant' => 'ምስራቅ ቲሞር',
 			'TM' => 'ቱርክሜኒስታን',
 			'TN' => 'ቱኒዚያ',
 			'TO' => 'ቶንጋ',
 			'TR' => 'ቱርክ',
 			'TT' => 'ትሪናዳድ እና ቶቤጎ',
 			'TV' => 'ቱቫሉ',
 			'TW' => 'ታይዋን',
 			'TZ' => 'ታንዛኒያ',
 			'UA' => 'ዩክሬን',
 			'UG' => 'ዩጋንዳ',
 			'UM' => 'የዩ ኤስ ጠረፍ ላይ ያሉ ደሴቶች',
 			'UN' => 'የተባበሩት መንግስታት',
 			'UN@alt=short' => 'የተመ',
 			'US' => 'ዩናይትድ ስቴትስ',
 			'UY' => 'ኡራጓይ',
 			'UZ' => 'ኡዝቤኪስታን',
 			'VA' => 'ቫቲካን ከተማ',
 			'VC' => 'ቅዱስ ቪንሴንት እና ግሬናዲንስ',
 			'VE' => 'ቬንዙዌላ',
 			'VG' => 'የእንግሊዝ ቨርጂን ደሴቶች',
 			'VI' => 'የአሜሪካ ቨርጂን ደሴቶች',
 			'VN' => 'ቬትናም',
 			'VU' => 'ቫኑአቱ',
 			'WF' => 'ዋሊስ እና ፉቱና ደሴቶች',
 			'WS' => 'ሳሞአ',
 			'XA' => 'የሀሰት ትእምርት',
 			'XB' => 'የሀሰት ባለሁለት አቅጣጫ',
 			'XK' => 'ኮሶቮ',
 			'YE' => 'የመን',
 			'YT' => 'ሜይኦቴ',
 			'ZA' => 'ደቡብ አፍሪካ',
 			'ZM' => 'ዛምቢያ',
 			'ZW' => 'ዚምቧቤ',
 			'ZZ' => 'ያልታወቀ ክልል',

		}
	},
);

has 'display_name_key' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => 'የቀን አቆጣጠር',
 			'cf' => 'የምንዛሪ ቅርጸት',
 			'colalternate' => 'የምልክቶች ድርደራ ችላ በለው',
 			'colbackwards' => 'የኋሊዮሽ የፊደል ጭረት ድርደራ',
 			'colcasefirst' => 'የአቢይ/ንዑስ ሆሄ ቅደም ተከተል',
 			'colcaselevel' => 'የመልከፊደል ትብ ድርደራ',
 			'collation' => 'አቀማመጥ ደርድር',
 			'colnormalization' => 'መደበኛ ድርደራ',
 			'colnumeric' => 'የቁጥር ድርደራ',
 			'colstrength' => 'የድርደራ አቅም',
 			'currency' => 'ምንዛሪ',
 			'hc' => 'የሰዓት ዑደት (12 ወይም 24)',
 			'lb' => 'መስመር መስበሪያ ቅጥ',
 			'ms' => 'የመለኪያ ስርዓት',
 			'numbers' => 'ቁጥሮች',
 			'timezone' => 'የሰዓት ሰቅ',
 			'va' => 'የአካባቢ አይነት',
 			'x' => 'ለግል ጥቅም',

		}
	},
);

has 'display_name_type' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[Str]],
	init_arg	=> undef,
	default		=> sub {
		{
			'calendar' => {
 				'buddhist' => q{የቡዲስት ቀን አቆጣጠር},
 				'chinese' => q{የቻይና የቀን አቆጣጠር},
 				'coptic' => q{የኮፕቲክ የቀን አቆጣጠር},
 				'dangi' => q{የዳንጊ የቀን አቆጣጠር},
 				'ethiopic' => q{የኢትዮጵያ የቀን አቆጣጠር},
 				'ethiopic-amete-alem' => q{የኢትዮፒክ አመተ አለም የቀን አቆጣጠር},
 				'gregorian' => q{የግሪጎሪያን የቀን አቆጣጠር},
 				'hebrew' => q{የእብራዊያን የቀን አቆጣጠር},
 				'indian' => q{የህንድ ብሔራዊ የቀን አቆጣጠር},
 				'islamic' => q{የሂጅራ የቀን አቆጣጠር},
 				'islamic-civil' => q{የሂጅራ የቀን አቆጣጠር (ታቡላር፣ ሲቪል አፖች)},
 				'islamic-umalqura' => q{የሂጅራ የቀን አቆጣጠር (ኡም አል-ቁራ)},
 				'iso8601' => q{ISO-8601 የቀን አቆጣጠር},
 				'japanese' => q{የጃፓን የቀን አቆጣጠር},
 				'persian' => q{የፐርሽያ የቀን አቆጣጠር},
 				'roc' => q{የሚንጉ የቀን አቆጣጠር},
 			},
 			'cf' => {
 				'account' => q{የሂሳብ ምንዛሪ ቅርጸት},
 				'standard' => q{መደበኛ የምንዛሪ ቅርጸት},
 			},
 			'colalternate' => {
 				'non-ignorable' => q{ምልክቶችን ደርድር},
 				'shifted' => q{ችላ ባይ ምልክቶችን ደርድር},
 			},
 			'colbackwards' => {
 				'no' => q{የፊደል ጭረቶችን እንደመደበኛ ደርድር},
 				'yes' => q{የፊደል ጭረቶች በኋሊዮሽ ደርድር},
 			},
 			'colcasefirst' => {
 				'lower' => q{ንዑስ ሆሄ መጀመሪያ ደርድር},
 				'no' => q{መደበኛ የመልከፊደል አቀማመጥ ደርድር},
 				'upper' => q{አቢይ ሆሄ መጀመሪያ ደርድር},
 			},
 			'colcaselevel' => {
 				'no' => q{ያለመልከፊደል ትብ ደርድር},
 				'yes' => q{በመልከፊደል ትብ ደርድር},
 			},
 			'collation' => {
 				'big5han' => q{የባህላዊ ቻይንኛ የድርድር ቅደም ተከተል - ትልቅ5},
 				'dictionary' => q{የመዝገበ ቃላት የድርድር ቅደም ተከተል},
 				'ducet' => q{የነባሪ ዩኒኮድ የድርድር ቅደም ተከተል},
 				'gb2312han' => q{የቀለለ የቻይንኛ የድርደራ ቅደም ተከተል - GB2312},
 				'phonebook' => q{የስልክ ደብተር ድርድር ቅደም ተከተል},
 				'phonetic' => q{የፎነቲክ ድርደራ ቅደም ተከተል},
 				'pinyin' => q{ፒንይን የድርድር ቅደም ተከተል},
 				'reformed' => q{ዳግም የተፈጠረ የድርድር ቅደም ተከተል},
 				'search' => q{ለጠቅላላ ጉዳይ ፍለጋ},
 				'searchjl' => q{በሃንጉል የመጀመሪያ ተነባቢ ፈልግ},
 				'standard' => q{መደበኛ},
 				'stroke' => q{የበትር ድርድር ቅደም ተከተል},
 				'traditional' => q{ባህላዊ የድርድር ቅደም ተከተል},
 				'unihan' => q{የመሰረታዊ በትር ድርድር ቅደም ተከተል},
 			},
 			'colnormalization' => {
 				'no' => q{ያለመደበኛ ሁኔታ ደርድር},
 				'yes' => q{ዩኒኮድ በመደበኛ ሁኔታ ደርድር},
 			},
 			'colnumeric' => {
 				'no' => q{አሃዞችን በየግል ደርድር},
 				'yes' => q{አሃዞች በቁጥር ደርድር},
 			},
 			'colstrength' => {
 				'identical' => q{ሁሉንም ደርድር},
 				'primary' => q{የመሠረት ፊደላት ብቻ ደርድር},
 				'quaternary' => q{የፊደል ጭረቶች/መልከፊደል/ስፋት/ካና ደርድር},
 				'secondary' => q{የፊደል ጭረቶችን ደርድር},
 				'tertiary' => q{የፊደል ጭረቶች/መልከፊደል/ስፋት ደርድር},
 			},
 			'd0' => {
 				'fwidth' => q{ሙሉ ወርድ},
 				'hwidth' => q{ግማሽ ወርድ},
 				'npinyin' => q{አሃዛዊ},
 			},
 			'hc' => {
 				'h11' => q{የ12 ሰዓት ስርዓት (0–11)},
 				'h12' => q{የ12 ሰዓት ስርዓት (1–12)},
 				'h23' => q{የ24 ሰዓት ስርዓት (0–23)},
 				'h24' => q{የ24 ሰዓት ስርዓት (1–24)},
 			},
 			'lb' => {
 				'loose' => q{ላላ ያለ መስመር መስበሪያ ቅጥ},
 				'normal' => q{መደበኛ መስመር መስበሪያ ቅጥ},
 				'strict' => q{ጠበቅ ያለ መስመር መስበሪያ ቅጥ},
 			},
 			'm0' => {
 				'bgn' => q{ቢ ጂ ኤን},
 				'ungegn' => q{ዩኤን ጂኢጂኤን ትራንስሊትሬሽን},
 			},
 			'ms' => {
 				'metric' => q{የልኬት ስርዓት},
 				'uksystem' => q{ኢምፔሪያል የመለኪያ ስርዓት},
 				'ussystem' => q{የአሜሪካ መለኪያ ስርዓት},
 			},
 			'numbers' => {
 				'arab' => q{የአረቢክ-ኢንዲክ አሃዞች},
 				'arabext' => q{የተራዘሙ የአረቢክ-ኢንዲክ አሃዞች},
 				'armn' => q{የአርመንኛ ቁጥሮች},
 				'armnlow' => q{የአሜሪካን ንዑስ ሆሄ አሃዞች},
 				'beng' => q{የቤንጋሊ አሃዞች},
 				'cakm' => q{ቻክማ አሃዝ},
 				'deva' => q{የዴቫንጋሪ አሃዞች},
 				'ethi' => q{የኢትዮጵያ ቁጥሮች},
 				'finance' => q{የፋይናንስ ቁጥሮች},
 				'fullwide' => q{የሙሉ ወርድ አሃዞች},
 				'geor' => q{የጆርጂያን ቁጥሮች},
 				'grek' => q{የግሪክ ቁጥሮች},
 				'greklow' => q{የግሪክ ንዑስ ሆሄ ቁጥሮች},
 				'gujr' => q{የጉጃራቲ አሃዞች},
 				'guru' => q{የጉርሙኪ አሃዞች},
 				'hanidec' => q{የቻይንኛ አስርዮሽ ቁጥሮች},
 				'hans' => q{ቀለል ያሉ የቻይንኛ ቁጥሮች},
 				'hansfin' => q{ቀለል ያሉ የቻይንኛ ገንዘብ ነክ ቁጥሮች},
 				'hant' => q{የባህላዊ ቻይንኛ ቁጥሮች},
 				'hantfin' => q{የባህላዊ ቻይንኛ የገንዘብ ነክ ቁጥሮች},
 				'hebr' => q{የእብራይስጥ ቁጥሮች},
 				'java' => q{ጃቫኒዝ አሃዞች},
 				'jpan' => q{የጃፓንኛ ቁጥሮች},
 				'jpanfin' => q{የጃፓንኛ የገንዘብ ነክ ቁጥሮች},
 				'khmr' => q{የክህመር አሃዞች},
 				'knda' => q{የካንአዳ አሃዞች},
 				'laoo' => q{የላኦ አሃዞች},
 				'latn' => q{የምስራቃዊ አሃዞች},
 				'mlym' => q{የማላያላምኛ አሃዞች},
 				'mong' => q{የሞንጎልኛ አሃዞች},
 				'mtei' => q{ሜቲ ማየክ አሃዞች},
 				'mymr' => q{የማያንማር አሃዞች},
 				'native' => q{ትውልድ አሃዞች},
 				'olck' => q{ኦይ ቺኪ አሃዞች},
 				'orya' => q{የኦሪያኛ አሃዞች},
 				'roman' => q{የሮማን ቁጥሮች},
 				'romanlow' => q{የሮማን ንዑስ ሆሄ ቁጥሮች},
 				'taml' => q{ባህላዊ የታሚል ቁጥሮች},
 				'tamldec' => q{የታሚል አሃዞች},
 				'telu' => q{የተልጉ አሃዞች},
 				'thai' => q{የታይ አሃዞች},
 				'tibt' => q{የቲቤታን አሃዞች},
 				'traditional' => q{ተለምዷዊ ቁጥሮች},
 				'vaii' => q{የቫይ አሃዞች},
 			},

		}
	},
);

has 'display_name_measurement_system' => (
	is			=> 'ro',
	isa			=> HashRef[Str],
	init_arg	=> undef,
	default		=> sub {
		{
			'metric' => q{ሜትሪክ},
 			'UK' => q{ዩኬ},
 			'US' => q{ዩ ኤስ},

		}
	},
);

has 'characters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> $^V ge v5.18.0
	? eval <<'EOT'
	sub {
		no warnings 'experimental::regex_sets';
		return {
			index => ['ሀ', 'ለ', 'ሐ', 'መ', 'ሠ', 'ረ', 'ሰ', 'ሸ', 'ቀ', 'ቈ', 'በ', 'ቨ', 'ተ', 'ቸ', 'ኀ', 'ኈ', 'ነ', 'ኘ', 'አ', 'ከ', 'ኰ', 'ኸ', 'ወ', 'ዐ', 'ዘ', 'ዠ', 'የ', 'ደ', 'ጀ', 'ገ', 'ጐ', 'ጠ', 'ጨ', 'ጰ', 'ጸ', 'ፀ', 'ፈ', 'ፐ'],
			main => qr{[ሀ ሁ ሂ ሃ ሄ ህ ሆ ለ ሉ ሊ ላ ሌ ል ሎ ሏ ሐ ሑ ሒ ሓ ሔ ሕ ሖ ሗ መ ሙ ሚ ማ ሜ ም ሞ ሟ ሠ ሡ ሢ ሣ ሤ ሥ ሦ ሧ ረ ሩ ሪ ራ ሬ ር ሮ ሯ ሰ ሱ ሲ ሳ ሴ ስ ሶ ሷ ሸ ሹ ሺ ሻ ሼ ሽ ሾ ሿ ቀ ቁ ቂ ቃ ቄ ቅ ቆ ቈ ቊ ቋ ቌ ቍ በ ቡ ቢ ባ ቤ ብ ቦ ቧ ቨ ቩ ቪ ቫ ቬ ቭ ቮ ቯ ተ ቱ ቲ ታ ቴ ት ቶ ቷ ቸ ቹ ቺ ቻ ቼ ች ቾ ቿ ኀ ኁ ኂ ኃ ኄ ኅ ኆ ኈ ኊ ኋ ኌ ኍ ነ ኑ ኒ ና ኔ ን ኖ ኗ ኘ ኙ ኚ ኛ ኜ ኝ ኞ ኟ አ ኡ ኢ ኣ ኤ እ ኦ ኧ ከ ኩ ኪ ካ ኬ ክ ኮ ኰ ኲ ኳ ኴ ኵ ኸ ኹ ኺ ኻ ኼ ኽ ኾ ወ ዉ ዊ ዋ ዌ ው ዎ ዐ ዑ ዒ ዓ ዔ ዕ ዖ ዘ ዙ ዚ ዛ ዜ ዝ ዞ ዟ ዠ ዡ ዢ ዣ ዤ ዥ ዦ ዧ የ ዩ ዪ ያ ዬ ይ ዮ ደ ዱ ዲ ዳ ዴ ድ ዶ ዷ ጀ ጁ ጂ ጃ ጄ ጅ ጆ ጇ ገ ጉ ጊ ጋ ጌ ግ ጎ ጐ ጒ ጓ ጔ ጕ ጠ ጡ ጢ ጣ ጤ ጥ ጦ ጧ ጨ ጩ ጪ ጫ ጬ ጭ ጮ ጯ ጰ ጱ ጲ ጳ ጴ ጵ ጶ ጷ ጸ ጹ ጺ ጻ ጼ ጽ ጾ ጿ ፀ ፁ ፂ ፃ ፄ ፅ ፆ ፈ ፉ ፊ ፋ ፌ ፍ ፎ ፏ ፐ ፑ ፒ ፓ ፔ ፕ ፖ ፗ]},
			punctuation => qr{[‐ – , ፡ ፣ ፤ ፥ ፦ ! ? . ። ‹ › « » ( ) \[ \]]},
		};
	},
EOT
: sub {
		return { index => ['ሀ', 'ለ', 'ሐ', 'መ', 'ሠ', 'ረ', 'ሰ', 'ሸ', 'ቀ', 'ቈ', 'በ', 'ቨ', 'ተ', 'ቸ', 'ኀ', 'ኈ', 'ነ', 'ኘ', 'አ', 'ከ', 'ኰ', 'ኸ', 'ወ', 'ዐ', 'ዘ', 'ዠ', 'የ', 'ደ', 'ጀ', 'ገ', 'ጐ', 'ጠ', 'ጨ', 'ጰ', 'ጸ', 'ፀ', 'ፈ', 'ፐ'], };
},
);


has 'quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{«},
);

has 'quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{»},
);

has 'alternate_quote_start' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{‹},
);

has 'alternate_quote_end' => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> qq{›},
);

has 'units' => (
	is			=> 'ro',
	isa			=> HashRef[HashRef[HashRef[Str]]],
	init_arg	=> undef,
	default		=> sub { {
				'long' => {
					# Long Unit Identifier
					'' => {
						'name' => q(ዓቢይ አቅጣጫ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(ዓቢይ አቅጣጫ),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ደሲ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ደሲ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(ፒኮ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(ፒኮ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ፌምቶ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ፌምቶ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(አቶ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(አቶ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ሴንቲ{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ሴንቲ{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ዜብቶ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ዜብቶ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ዮክቶ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ዮክቶ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ሚሊ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ሚሊ{0}),
					},
					# Long Unit Identifier
					'10p-6' => {
						'1' => q(ማይክሮ{0}),
					},
					# Core Unit Identifier
					'6' => {
						'1' => q(ማይክሮ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ናኖ{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ናኖ{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ዴካ{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ዴካ{0}),
					},
					# Long Unit Identifier
					'10p18' => {
						'1' => q(ኤክሳ {0}),
					},
					# Core Unit Identifier
					'10p18' => {
						'1' => q(ኤክሳ {0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ሄክቶ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ሄክቶ{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(ኪሎ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(ኪሎ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(ሜጋ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(ሜጋ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ጊጋ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ጊጋ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'one' => q({0} ጂ-ኃይል),
						'other' => q({0} ጂ-ኃይል),
					},
					# Core Unit Identifier
					'g-force' => {
						'one' => q({0} ጂ-ኃይል),
						'other' => q({0} ጂ-ኃይል),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0} ዲግሪ),
						'other' => q({0} ዲግሪ),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0} ዲግሪ),
						'other' => q({0} ዲግሪ),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Core Unit Identifier
					'radian' => {
						'one' => q({0} rad),
						'other' => q({0} rad),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					# Core Unit Identifier
					'revolution' => {
						'one' => q({0} rev),
						'other' => q({0} rev),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ጋሻ),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ጋሻ),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'one' => q({0} ካሬ ኪሎሜትር),
						'other' => q({0} ካሬ ኪሎሜትር),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'one' => q({0} ካሬ ኪሎሜትር),
						'other' => q({0} ካሬ ኪሎሜትር),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'one' => q({0} ካሬ ሜትር),
						'other' => q({0} ካሬ ሜትር),
					},
					# Core Unit Identifier
					'square-meter' => {
						'one' => q({0} ካሬ ሜትር),
						'other' => q({0} ካሬ ሜትር),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ንጥሎች),
						'one' => q({0} ንጥል),
						'other' => q({0} ንጥሎች),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ንጥሎች),
						'one' => q({0} ንጥል),
						'other' => q({0} ንጥሎች),
					},
					# Long Unit Identifier
					'concentr-milligram-ofglucose-per-deciliter' => {
						'name' => q(ሚሊ ግራም በ ዴሲ ሊትር),
					},
					# Core Unit Identifier
					'milligram-ofglucose-per-deciliter' => {
						'name' => q(ሚሊ ግራም በ ዴሲ ሊትር),
					},
					# Long Unit Identifier
					'concentr-mole' => {
						'one' => q({0} mol),
						'other' => q({0} mol),
					},
					# Core Unit Identifier
					'mole' => {
						'one' => q({0} mol),
						'other' => q({0} mol),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'one' => q({0} ፐርሰንት),
						'other' => q({0} ፐርሰንት),
					},
					# Core Unit Identifier
					'percent' => {
						'one' => q({0} ፐርሰንት),
						'other' => q({0} ፐርሰንት),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'one' => q({0} በማይል),
						'other' => q({0}‰),
					},
					# Core Unit Identifier
					'permille' => {
						'one' => q({0} በማይል),
						'other' => q({0}‰),
					},
					# Long Unit Identifier
					'concentr-permillion' => {
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Core Unit Identifier
					'permillion' => {
						'one' => q({0} ppm),
						'other' => q({0} ppm),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ሊትሮች በ100 ኪሎሜትሮች),
						'one' => q({0} ሊትር በ100 ኪሎሜትሮች),
						'other' => q({0} ሊትሮች በ100 ኪሎሜትሮች),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ሊትሮች በ100 ኪሎሜትሮች),
						'one' => q({0} ሊትር በ100 ኪሎሜትሮች),
						'other' => q({0} ሊትሮች በ100 ኪሎሜትሮች),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ፔታ ባይት),
						'one' => q({0} ፔታ ባይት),
						'other' => q({0} ፔታ ባይቶች),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ፔታ ባይት),
						'one' => q({0} ፔታ ባይት),
						'other' => q({0} ፔታ ባይቶች),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ቴራባይትስ),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ቴራባይትስ),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'one' => q({0} ዓሠርተ-ዓመት),
						'other' => q({0} ዓሠርተ-ዓመታት),
					},
					# Core Unit Identifier
					'decade' => {
						'one' => q({0} ዓሠርተ-ዓመት),
						'other' => q({0} ዓሠርተ-ዓመታት),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} ሰዓት),
						'other' => q({0} ሰዓቶች),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} ሰዓት),
						'other' => q({0} ሰዓቶች),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'one' => q({0} ማይክሮሰከንድ),
						'other' => q({0} ማይክሮሰከንድ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'one' => q({0} ማይክሮሰከንድ),
						'other' => q({0} ማይክሮሰከንድ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'one' => q({0} ሚሊሰከንድ),
						'other' => q({0} ሚሊሰከንድ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'one' => q({0} ሚሊሰከንድ),
						'other' => q({0} ሚሊሰከንድ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0} ደቂቃ),
						'other' => q({0} ደቂቃዎች),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0} ደቂቃ),
						'other' => q({0} ደቂቃዎች),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} ወር),
						'other' => q({0} ወራት),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} ወር),
						'other' => q({0} ወራት),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(ሩቦች),
						'one' => q({0} ሩ),
						'other' => q({0} ሩ),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(ሩቦች),
						'one' => q({0} ሩ),
						'other' => q({0} ሩ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'one' => q({0} ሰከንድ),
						'other' => q({0} ሰከንዶች),
					},
					# Core Unit Identifier
					'second' => {
						'one' => q({0} ሰከንድ),
						'other' => q({0} ሰከንዶች),
					},
					# Long Unit Identifier
					'electric-ampere' => {
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Core Unit Identifier
					'ampere' => {
						'one' => q({0} A),
						'other' => q({0} A),
					},
					# Long Unit Identifier
					'electric-ohm' => {
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Core Unit Identifier
					'ohm' => {
						'one' => q({0} Ω),
						'other' => q({0} Ω),
					},
					# Long Unit Identifier
					'electric-volt' => {
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Core Unit Identifier
					'volt' => {
						'one' => q({0} V),
						'other' => q({0} V),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(cal),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(cal),
					},
					# Long Unit Identifier
					'force-kilowatt-hour-per-100-kilometer' => {
						'name' => q(ኪሎዋት-ሰዓት በየ 100 ኪሎሜትሮች),
						'one' => q({0} ኪሎዋት-ሰዓት በየ 100 ኪሎሜትሮች),
						'other' => q({0} ኪሎዋት-ሰዓታት በየ 100 ኪሎሜትሮች),
					},
					# Core Unit Identifier
					'kilowatt-hour-per-100-kilometer' => {
						'name' => q(ኪሎዋት-ሰዓት በየ 100 ኪሎሜትሮች),
						'one' => q({0} ኪሎዋት-ሰዓት በየ 100 ኪሎሜትሮች),
						'other' => q({0} ኪሎዋት-ሰዓታት በየ 100 ኪሎሜትሮች),
					},
					# Long Unit Identifier
					'force-newton' => {
						'one' => q({0} ኒ),
						'other' => q({0} ኒ),
					},
					# Core Unit Identifier
					'newton' => {
						'one' => q({0} ኒ),
						'other' => q({0} ኒ),
					},
					# Long Unit Identifier
					'frequency-hertz' => {
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Core Unit Identifier
					'hertz' => {
						'one' => q({0} Hz),
						'other' => q({0} Hz),
					},
					# Long Unit Identifier
					'graphics-em' => {
						'name' => q(ታይፖግራፊክ em),
					},
					# Core Unit Identifier
					'em' => {
						'name' => q(ታይፖግራፊክ em),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'one' => q({0} ሴንቲሜትር),
						'other' => q({0} ሴንቲሜትር),
					},
					# Core Unit Identifier
					'centimeter' => {
						'one' => q({0} ሴንቲሜትር),
						'other' => q({0} ሴንቲሜትር),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ዴሲ ሜትር),
						'one' => q({0} ዴሲ ሜትር),
						'other' => q({0} ዴሲ ሜትር),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ዴሲ ሜትር),
						'one' => q({0} ዴሲ ሜትር),
						'other' => q({0} ዴሲ ሜትር),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'one' => q({0} ተዳክሞ),
						'other' => q({0} ተዳክሞዎች),
					},
					# Core Unit Identifier
					'fathom' => {
						'one' => q({0} ተዳክሞ),
						'other' => q({0} ተዳክሞዎች),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'one' => q({0} ኪሎሜትር),
						'other' => q({0} ኪሎሜትር),
					},
					# Core Unit Identifier
					'kilometer' => {
						'one' => q({0} ኪሎሜትር),
						'other' => q({0} ኪሎሜትር),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'one' => q({0} የብርሃን ዓመት),
						'other' => q({0} የብርሃን ዓመት),
					},
					# Core Unit Identifier
					'light-year' => {
						'one' => q({0} የብርሃን ዓመት),
						'other' => q({0} የብርሃን ዓመት),
					},
					# Long Unit Identifier
					'length-meter' => {
						'one' => q({0} ሜትር),
						'other' => q({0} ሜትር),
					},
					# Core Unit Identifier
					'meter' => {
						'one' => q({0} ሜትር),
						'other' => q({0} ሜትር),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(ማይክሮ ሜትር),
						'one' => q({0} ማይክሮ ሜትር),
						'other' => q({0} ማይክሮ ሜትር),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(ማይክሮ ሜትር),
						'one' => q({0} ማይክሮ ሜትር),
						'other' => q({0} ማይክሮ ሜትር),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'one' => q({0} ሚሊሜትር),
						'other' => q({0} ሚሊሜትር),
					},
					# Core Unit Identifier
					'millimeter' => {
						'one' => q({0} ሚሊሜትር),
						'other' => q({0} ሚሊሜትር),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ናኖ ሜትር),
						'one' => q({0} ናኖ ሜትር),
						'other' => q({0} ናኖ ሜትር),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ናኖ ሜትር),
						'one' => q({0} ናኖ ሜትር),
						'other' => q({0} ናኖ ሜትር),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'one' => q({0} ፒኮሜትር),
						'other' => q({0} ፒኮሜትር),
					},
					# Core Unit Identifier
					'picometer' => {
						'one' => q({0} ፒኮሜትር),
						'other' => q({0} ፒኮሜትር),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'one' => q({0} ሶላር ዳዲየስ),
						'other' => q({0} ሶላር ራዲ),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'one' => q({0} ሶላር ዳዲየስ),
						'other' => q({0} ሶላር ራዲ),
					},
					# Long Unit Identifier
					'light-lux' => {
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Core Unit Identifier
					'lux' => {
						'one' => q({0} lx),
						'other' => q({0} lx),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ካራቶች),
						'one' => q({0} ካራት),
						'other' => q({0} CD),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ካራቶች),
						'one' => q({0} ካራት),
						'other' => q({0} CD),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'one' => q({0} ዳተንስ),
						'other' => q({0} ዳተንስ),
					},
					# Core Unit Identifier
					'dalton' => {
						'one' => q({0} ዳተንስ),
						'other' => q({0} ዳተንስ),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'one' => q({0} ኤርዝማስስ),
						'other' => q({0} ኤርዝማስስ),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'one' => q({0} ኤርዝማስስ),
						'other' => q({0} ኤርዝማስስ),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'one' => q({0} ግራም),
						'other' => q({0} ግራም),
					},
					# Core Unit Identifier
					'gram' => {
						'one' => q({0} ግራም),
						'other' => q({0} ግራም),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'one' => q({0} ኪሎግራም),
						'other' => q({0} ኪሎግራም),
					},
					# Core Unit Identifier
					'kilogram' => {
						'one' => q({0} ኪሎግራም),
						'other' => q({0} ኪሎግራም),
					},
					# Long Unit Identifier
					'mass-microgram' => {
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Core Unit Identifier
					'microgram' => {
						'one' => q({0} μg),
						'other' => q({0} μg),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'one' => q({0} ሶላር ማስስ),
						'other' => q({0} ሶላር ማስስ),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'one' => q({0} ሶላር ማስስ),
						'other' => q({0} ሶላር ማስስ),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'one' => q({0} ሜትሪክ ቶን),
						'other' => q({0} ሜትሪክ ቶኖች),
					},
					# Core Unit Identifier
					'tonne' => {
						'one' => q({0} ሜትሪክ ቶን),
						'other' => q({0} ሜትሪክ ቶኖች),
					},
					# Long Unit Identifier
					'per' => {
						'1' => q({0} በ{1}),
					},
					# Core Unit Identifier
					'per' => {
						'1' => q({0} በ{1}),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0} የፈረስ ጉልበት),
						'other' => q({0} የፈረስ ጉልበት),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0} የፈረስ ጉልበት),
						'other' => q({0} የፈረስ ጉልበት),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'one' => q({0} ኪሎዋት),
						'other' => q({0} ኪሎዋት),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'one' => q({0} ኪሎዋት),
						'other' => q({0} ኪሎዋት),
					},
					# Long Unit Identifier
					'power-watt' => {
						'one' => q({0} ዋት),
						'other' => q({0} ዋት),
					},
					# Core Unit Identifier
					'watt' => {
						'one' => q({0} ዋት),
						'other' => q({0} ዋት),
					},
					# Long Unit Identifier
					'power2' => {
						'one' => q(ስኩየር {0}),
						'other' => q(ስኩየር {0}),
					},
					# Core Unit Identifier
					'power2' => {
						'one' => q(ስኩየር {0}),
						'other' => q(ስኩየር {0}),
					},
					# Long Unit Identifier
					'power3' => {
						'one' => q(ኪዩቢክ {0}),
						'other' => q(ኪዩቢክ {0}),
					},
					# Core Unit Identifier
					'power3' => {
						'one' => q(ኪዩቢክ {0}),
						'other' => q(ኪዩቢክ {0}),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} ኢንች ሜርኩሪ),
						'other' => q({0} ኢንች ሜርኩሪ),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} ኢንች ሜርኩሪ),
						'other' => q({0} ኢንች ሜርኩሪ),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'one' => q({0} ሜጋፓስካል),
						'other' => q({0} ሜጋፓስካሎች),
					},
					# Core Unit Identifier
					'megapascal' => {
						'one' => q({0} ሜጋፓስካል),
						'other' => q({0} ሜጋፓስካሎች),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'one' => q({0} ሚሊባር),
						'other' => q({0} ሚሊባር),
					},
					# Core Unit Identifier
					'millibar' => {
						'one' => q({0} ሚሊባር),
						'other' => q({0} ሚሊባር),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'one' => q({0} ኪሎሜትር በሰዓት),
						'other' => q({0} ኪሎሜትር በሰዓት),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'one' => q({0} ኪሎሜትር በሰዓት),
						'other' => q({0} ኪሎሜትር በሰዓት),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'one' => q({0} ሜትር በሰከንድ),
						'other' => q({0} ሜትር በሰከንድ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'one' => q({0} ሜትር በሰከንድ),
						'other' => q({0} ሜትር በሰከንድ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'one' => q({0} ማይል በሰዓት),
						'other' => q({0} ማይል በሰዓት),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'one' => q({0} ማይል በሰዓት),
						'other' => q({0} ማይል በሰዓት),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0} ዲግሪ ሴልሺየስ),
						'other' => q({0} ዲግሪ ሴልሺየስ),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0} ዲግሪ ሴልሺየስ),
						'other' => q({0} ዲግሪ ሴልሺየስ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'one' => q({0} ዲግሪ ፋራንሃይት),
						'other' => q({0} ዲግሪ ፋራንሃይት),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'one' => q({0} ዲግሪ ፋራንሃይት),
						'other' => q({0} ዲግሪ ፋራንሃይት),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Core Unit Identifier
					'kelvin' => {
						'one' => q({0} K),
						'other' => q({0} K),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'one' => q({0} በርሜል),
						'other' => q({0} በርሜሎች),
					},
					# Core Unit Identifier
					'barrel' => {
						'one' => q({0} በርሜል),
						'other' => q({0} በርሜሎች),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(ሴንቲ ሊትር),
						'one' => q({0} ሴንቲ ሊትር),
						'other' => q({0} ሴንቲ ሊትር),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(ሴንቲ ሊትር),
						'one' => q({0} ሴንቲ ሊትር),
						'other' => q({0} ሴንቲ ሊትር),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'one' => q({0} ኩቢክ ኪሎሜትር),
						'other' => q({0} ኩቢክ ኪሎሜትር),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'one' => q({0} ኩቢክ ኪሎሜትር),
						'other' => q({0} ኩቢክ ኪሎሜትር),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'one' => q({0} ኩቢክ ማይል),
						'other' => q({0} ኩቢክ ማይል),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'one' => q({0} ኩቢክ ማይል),
						'other' => q({0} ኩቢክ ማይል),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ዴሲ ሊትር),
						'one' => q({0} ዴሲ ሊትር),
						'other' => q({0} ዴሲ ሊትር),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ዴሲ ሊትር),
						'one' => q({0} ዴሲ ሊትር),
						'other' => q({0} ዴሲ ሊትር),
					},
					# Long Unit Identifier
					'volume-fluid-ounce-imperial' => {
						'name' => q(Imp. fluid ኦንስስ),
						'one' => q({0} Imp. fluid ኦንስስ),
						'other' => q({0} Imp. fluid ኦንስስ),
					},
					# Core Unit Identifier
					'fluid-ounce-imperial' => {
						'name' => q(Imp. fluid ኦንስስ),
						'one' => q({0} Imp. fluid ኦንስስ),
						'other' => q({0} Imp. fluid ኦንስስ),
					},
					# Long Unit Identifier
					'volume-hectoliter' => {
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Core Unit Identifier
					'hectoliter' => {
						'one' => q({0} hL),
						'other' => q({0} hL),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'one' => q({0} ሊትር),
						'other' => q({0} ሊትር),
					},
					# Core Unit Identifier
					'liter' => {
						'one' => q({0} ሊትር),
						'other' => q({0} ሊትር),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Core Unit Identifier
					'megaliter' => {
						'one' => q({0} ML),
						'other' => q({0} ML),
					},
					# Long Unit Identifier
					'volume-pint-metric' => {
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
					# Core Unit Identifier
					'pint-metric' => {
						'one' => q({0} mpt),
						'other' => q({0} mpt),
					},
				},
				'narrow' => {
					# Long Unit Identifier
					'angle-arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'one' => q({0}′),
						'other' => q({0}′),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Core Unit Identifier
					'arc-second' => {
						'one' => q({0}″),
						'other' => q({0}″),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'degree' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'angle-radian' => {
						'name' => q(ራዲ),
						'one' => q({0}ራዲ),
						'other' => q({0}ራዲ),
					},
					# Core Unit Identifier
					'radian' => {
						'name' => q(ራዲ),
						'one' => q({0}ራዲ),
						'other' => q({0}ራዲ),
					},
					# Long Unit Identifier
					'angle-revolution' => {
						'name' => q(ኡደ),
						'one' => q({0} ኡደ),
						'other' => q({0}ኡደ),
					},
					# Core Unit Identifier
					'revolution' => {
						'name' => q(ኡደ),
						'one' => q({0} ኡደ),
						'other' => q({0}ኡደ),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'one' => q({0} ጫማ²),
						'other' => q({0} ጫማ²),
					},
					# Core Unit Identifier
					'square-foot' => {
						'one' => q({0} ጫማ²),
						'other' => q({0} ጫማ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'one' => q({0} ማይል²),
						'other' => q({0} ማይል²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'one' => q({0} ማይል²),
						'other' => q({0} ማይል²),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(%),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(%),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'one' => q({0}ሊበ100ኪሜ),
						'other' => q({0}ሊበ100ኪሜ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'one' => q({0}ሊበ100ኪሜ),
						'other' => q({0}ሊበ100ኪሜ),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ፔባ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ፔባ),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ቴባይት),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ቴባይት),
					},
					# Long Unit Identifier
					'duration-century' => {
						'one' => q({0}ም.ዓ),
						'other' => q({0}ም.ዓ),
					},
					# Core Unit Identifier
					'century' => {
						'one' => q({0}ም.ዓ),
						'other' => q({0}ም.ዓ),
					},
					# Long Unit Identifier
					'duration-day' => {
						'one' => q({0} ቀ),
						'other' => q({0} ቀ),
					},
					# Core Unit Identifier
					'day' => {
						'one' => q({0} ቀ),
						'other' => q({0} ቀ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'one' => q({0} ሰ),
						'other' => q({0} ሰ),
					},
					# Core Unit Identifier
					'hour' => {
						'one' => q({0} ሰ),
						'other' => q({0} ሰ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'one' => q({0} ደ),
						'other' => q({0} ደ),
					},
					# Core Unit Identifier
					'minute' => {
						'one' => q({0} ደ),
						'other' => q({0} ደ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'one' => q({0} ወር),
						'other' => q({0} ወር),
					},
					# Core Unit Identifier
					'month' => {
						'one' => q({0} ወር),
						'other' => q({0} ወር),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'one' => q({0} ሩብ),
						'other' => q({0} ሩ),
					},
					# Core Unit Identifier
					'quarter' => {
						'one' => q({0} ሩብ),
						'other' => q({0} ሩ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ሰከንድ),
						'one' => q({0} ሰ),
						'other' => q({0} ሰ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ሰከንድ),
						'one' => q({0} ሰ),
						'other' => q({0} ሰ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'one' => q({0} ሳምንት),
						'other' => q({0} ሳምንት),
					},
					# Core Unit Identifier
					'week' => {
						'one' => q({0} ሳምንት),
						'other' => q({0} ሳምንት),
					},
					# Long Unit Identifier
					'duration-year' => {
						'one' => q({0} ዓመት),
						'other' => q({0} ዓ),
					},
					# Core Unit Identifier
					'year' => {
						'one' => q({0} ዓመት),
						'other' => q({0} ዓ),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'one' => q({0} ሜፒ),
						'other' => q({0} ሜፒ),
					},
					# Core Unit Identifier
					'megapixel' => {
						'one' => q({0} ሜፒ),
						'other' => q({0} ሜፒ),
					},
					# Long Unit Identifier
					'length-nautical-mile' => {
						'name' => q(ማይለባህር),
						'one' => q({0} ማይለባህር),
						'other' => q({0} ማይለባህር),
					},
					# Core Unit Identifier
					'nautical-mile' => {
						'name' => q(ማይለባህር),
						'one' => q({0} ማይለባህር),
						'other' => q({0} ማይለባህር),
					},
					# Long Unit Identifier
					'light-lux' => {
						'name' => q(lux),
					},
					# Core Unit Identifier
					'lux' => {
						'name' => q(lux),
					},
					# Long Unit Identifier
					'mass-carat' => {
						'name' => q(ካራት),
					},
					# Core Unit Identifier
					'carat' => {
						'name' => q(ካራት),
					},
					# Long Unit Identifier
					'mass-milligram' => {
						'name' => q(ሚሊግራም),
						'one' => q({0} ሚሊግራም),
						'other' => q({0} ሚሊግራም),
					},
					# Core Unit Identifier
					'milligram' => {
						'name' => q(ሚሊግራም),
						'one' => q({0} ሚሊግራም),
						'other' => q({0} ሚሊግራም),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'one' => q({0} የፈረስ ኃይል),
						'other' => q({0} የፈረስ ኃይል),
					},
					# Core Unit Identifier
					'horsepower' => {
						'one' => q({0} የፈረስ ኃይል),
						'other' => q({0} የፈረስ ኃይል),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'one' => q({0} ከአ),
						'other' => q({0} ከአ),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'one' => q({0} ከአ),
						'other' => q({0} ከአ),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'one' => q({0} hPa),
						'other' => q({0} hPa),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'one' => q({0} inHg),
						'other' => q({0} inHg),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'one' => q({0} ኪፓ),
						'other' => q({0} ኪፓ),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'one' => q({0} ኪፓ),
						'other' => q({0} ኪፓ),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'one' => q({0} ሜፓ),
						'other' => q({0} ሜፓ),
					},
					# Core Unit Identifier
					'megapascal' => {
						'one' => q({0} ሜፓ),
						'other' => q({0} ሜፓ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Core Unit Identifier
					'celsius' => {
						'one' => q({0}°),
						'other' => q({0}°),
					},
					# Long Unit Identifier
					'temperature-kelvin' => {
						'name' => q(ኬ),
						'one' => q({0} ኬ),
						'other' => q({0} ኬ),
					},
					# Core Unit Identifier
					'kelvin' => {
						'name' => q(ኬ),
						'one' => q({0} ኬ),
						'other' => q({0} ኬ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'one' => q({0} ኤጫ),
						'other' => q({0} ኤጫ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'one' => q({0} ኤጫ),
						'other' => q({0} ኤጫ),
					},
					# Long Unit Identifier
					'volume-cup' => {
						'name' => q(ኩባያ),
						'one' => q({0} ኩባያ),
						'other' => q({0} ኩባያ),
					},
					# Core Unit Identifier
					'cup' => {
						'name' => q(ኩባያ),
						'one' => q({0} ኩባያ),
						'other' => q({0} ኩባያ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'one' => q({0} ክመ),
						'other' => q({0} ክመ),
					},
					# Core Unit Identifier
					'dram' => {
						'one' => q({0} ክመ),
						'other' => q({0} ክመ),
					},
					# Long Unit Identifier
					'volume-megaliter' => {
						'name' => q(ሜጋሊትር),
						'one' => q({0} ሜጋሊትር),
						'other' => q({0} ሜጋሊትር),
					},
					# Core Unit Identifier
					'megaliter' => {
						'name' => q(ሜጋሊትር),
						'one' => q({0} ሜጋሊትር),
						'other' => q({0} ሜጋሊትር),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'one' => q({0} ሚሊ),
						'other' => q({0} ሚሊ),
					},
					# Core Unit Identifier
					'milliliter' => {
						'one' => q({0} ሚሊ),
						'other' => q({0} ሚሊ),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'one' => q({0} ፈመ),
						'other' => q({0} ፈመ),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'one' => q({0} ፈመ),
						'other' => q({0} ፈመ),
					},
				},
				'short' => {
					# Long Unit Identifier
					'' => {
						'name' => q(አቅጣጫ),
					},
					# Core Unit Identifier
					'' => {
						'name' => q(አቅጣጫ),
					},
					# Long Unit Identifier
					'1024p1' => {
						'1' => q({0} ኪቢ),
					},
					# Core Unit Identifier
					'1024p1' => {
						'1' => q({0} ኪቢ),
					},
					# Long Unit Identifier
					'1024p2' => {
						'1' => q({0} ሜቢ),
					},
					# Core Unit Identifier
					'1024p2' => {
						'1' => q({0} ሜቢ),
					},
					# Long Unit Identifier
					'1024p3' => {
						'1' => q({0} ጊቢ),
					},
					# Core Unit Identifier
					'1024p3' => {
						'1' => q({0} ጊቢ),
					},
					# Long Unit Identifier
					'1024p4' => {
						'1' => q({0} ቴቢ),
					},
					# Core Unit Identifier
					'1024p4' => {
						'1' => q({0} ቴቢ),
					},
					# Long Unit Identifier
					'1024p5' => {
						'1' => q({0} ፔቢ),
					},
					# Core Unit Identifier
					'1024p5' => {
						'1' => q({0} ፔቢ),
					},
					# Long Unit Identifier
					'1024p7' => {
						'1' => q({0} ዜቢ),
					},
					# Core Unit Identifier
					'1024p7' => {
						'1' => q({0} ዜቢ),
					},
					# Long Unit Identifier
					'10p-1' => {
						'1' => q(ደ{0}),
					},
					# Core Unit Identifier
					'1' => {
						'1' => q(ደ{0}),
					},
					# Long Unit Identifier
					'10p-12' => {
						'1' => q(ፒ{0}),
					},
					# Core Unit Identifier
					'12' => {
						'1' => q(ፒ{0}),
					},
					# Long Unit Identifier
					'10p-15' => {
						'1' => q(ፌ{0}),
					},
					# Core Unit Identifier
					'15' => {
						'1' => q(ፌ{0}),
					},
					# Long Unit Identifier
					'10p-18' => {
						'1' => q(አ{0}),
					},
					# Core Unit Identifier
					'18' => {
						'1' => q(አ{0}),
					},
					# Long Unit Identifier
					'10p-2' => {
						'1' => q(ሴ{0}),
					},
					# Core Unit Identifier
					'2' => {
						'1' => q(ሴ{0}),
					},
					# Long Unit Identifier
					'10p-21' => {
						'1' => q(ዜ{0}),
					},
					# Core Unit Identifier
					'21' => {
						'1' => q(ዜ{0}),
					},
					# Long Unit Identifier
					'10p-24' => {
						'1' => q(ዮ{0}),
					},
					# Core Unit Identifier
					'24' => {
						'1' => q(ዮ{0}),
					},
					# Long Unit Identifier
					'10p-3' => {
						'1' => q(ሚ{0}),
					},
					# Core Unit Identifier
					'3' => {
						'1' => q(ሚ{0}),
					},
					# Long Unit Identifier
					'10p-9' => {
						'1' => q(ና{0}),
					},
					# Core Unit Identifier
					'9' => {
						'1' => q(ና{0}),
					},
					# Long Unit Identifier
					'10p1' => {
						'1' => q(ዴ{0}),
					},
					# Core Unit Identifier
					'10p1' => {
						'1' => q(ዴ{0}),
					},
					# Long Unit Identifier
					'10p12' => {
						'1' => q(ቴራ {0}),
					},
					# Core Unit Identifier
					'10p12' => {
						'1' => q(ቴራ {0}),
					},
					# Long Unit Identifier
					'10p15' => {
						'1' => q(ፔታ {0}),
					},
					# Core Unit Identifier
					'10p15' => {
						'1' => q(ፔታ {0}),
					},
					# Long Unit Identifier
					'10p2' => {
						'1' => q(ሄ{0}),
					},
					# Core Unit Identifier
					'10p2' => {
						'1' => q(ሄ{0}),
					},
					# Long Unit Identifier
					'10p3' => {
						'1' => q(ኪ{0}),
					},
					# Core Unit Identifier
					'10p3' => {
						'1' => q(ኪ{0}),
					},
					# Long Unit Identifier
					'10p6' => {
						'1' => q(ሜ{0}),
					},
					# Core Unit Identifier
					'10p6' => {
						'1' => q(ሜ{0}),
					},
					# Long Unit Identifier
					'10p9' => {
						'1' => q(ጊ{0}),
					},
					# Core Unit Identifier
					'10p9' => {
						'1' => q(ጊ{0}),
					},
					# Long Unit Identifier
					'acceleration-g-force' => {
						'name' => q(ጂ-ኃይል),
						'one' => q({0} ጂ),
						'other' => q({0} ጂ),
					},
					# Core Unit Identifier
					'g-force' => {
						'name' => q(ጂ-ኃይል),
						'one' => q({0} ጂ),
						'other' => q({0} ጂ),
					},
					# Long Unit Identifier
					'acceleration-meter-per-square-second' => {
						'name' => q(ሜ/ሰ²),
						'one' => q({0} ሜ/ሰ²),
						'other' => q({0} ሜ/ሰ²),
					},
					# Core Unit Identifier
					'meter-per-square-second' => {
						'name' => q(ሜ/ሰ²),
						'one' => q({0} ሜ/ሰ²),
						'other' => q({0} ሜ/ሰ²),
					},
					# Long Unit Identifier
					'angle-arc-minute' => {
						'name' => q(ደቂቃ),
						'one' => q({0} ደቂቃ),
						'other' => q({0} ደቂቃ),
					},
					# Core Unit Identifier
					'arc-minute' => {
						'name' => q(ደቂቃ),
						'one' => q({0} ደቂቃ),
						'other' => q({0} ደቂቃ),
					},
					# Long Unit Identifier
					'angle-arc-second' => {
						'name' => q(ሰከንድ),
						'one' => q({0} ሰከንድ),
						'other' => q({0} ሰከንድ),
					},
					# Core Unit Identifier
					'arc-second' => {
						'name' => q(ሰከንድ),
						'one' => q({0} ሰከንድ),
						'other' => q({0} ሰከንድ),
					},
					# Long Unit Identifier
					'angle-degree' => {
						'name' => q(ዲግሪ),
						'one' => q({0}°ዲግሪ),
						'other' => q({0}°ዲግሪ),
					},
					# Core Unit Identifier
					'degree' => {
						'name' => q(ዲግሪ),
						'one' => q({0}°ዲግሪ),
						'other' => q({0}°ዲግሪ),
					},
					# Long Unit Identifier
					'area-acre' => {
						'name' => q(ኤክር),
						'one' => q({0} ኤክር),
						'other' => q({0} ኤክር),
					},
					# Core Unit Identifier
					'acre' => {
						'name' => q(ኤክር),
						'one' => q({0} ኤክር),
						'other' => q({0} ኤክር),
					},
					# Long Unit Identifier
					'area-dunam' => {
						'name' => q(ጋሻዎች),
						'one' => q({0} ጋሻ),
						'other' => q({0} ጋሻ),
					},
					# Core Unit Identifier
					'dunam' => {
						'name' => q(ጋሻዎች),
						'one' => q({0} ጋሻ),
						'other' => q({0} ጋሻ),
					},
					# Long Unit Identifier
					'area-hectare' => {
						'name' => q(ሄክታር),
						'one' => q({0} ሄክታር),
						'other' => q({0} ሄክታር),
					},
					# Core Unit Identifier
					'hectare' => {
						'name' => q(ሄክታር),
						'one' => q({0} ሄክታር),
						'other' => q({0} ሄክታር),
					},
					# Long Unit Identifier
					'area-square-centimeter' => {
						'name' => q(ሴሜ²),
						'one' => q({0} ሴሜ²),
						'other' => q({0} ሴሜ²),
						'per' => q({0}/ሴሜ²),
					},
					# Core Unit Identifier
					'square-centimeter' => {
						'name' => q(ሴሜ²),
						'one' => q({0} ሴሜ²),
						'other' => q({0} ሴሜ²),
						'per' => q({0}/ሴሜ²),
					},
					# Long Unit Identifier
					'area-square-foot' => {
						'name' => q(ካሬ ጫማ),
						'one' => q({0} ካሬ ጫማ),
						'other' => q({0} ካሬ ጫማ),
					},
					# Core Unit Identifier
					'square-foot' => {
						'name' => q(ካሬ ጫማ),
						'one' => q({0} ካሬ ጫማ),
						'other' => q({0} ካሬ ጫማ),
					},
					# Long Unit Identifier
					'area-square-inch' => {
						'name' => q(ኢንች²),
						'one' => q({0} ኢንች²),
						'other' => q({0} ኢንች²),
						'per' => q({0}/ኢንች²),
					},
					# Core Unit Identifier
					'square-inch' => {
						'name' => q(ኢንች²),
						'one' => q({0} ኢንች²),
						'other' => q({0} ኢንች²),
						'per' => q({0}/ኢንች²),
					},
					# Long Unit Identifier
					'area-square-kilometer' => {
						'name' => q(ካሬ ኪሎሜትር),
						'one' => q({0} ኪሜ²),
						'other' => q({0} ኪሜ²),
						'per' => q({0}/ኪሜ²),
					},
					# Core Unit Identifier
					'square-kilometer' => {
						'name' => q(ካሬ ኪሎሜትር),
						'one' => q({0} ኪሜ²),
						'other' => q({0} ኪሜ²),
						'per' => q({0}/ኪሜ²),
					},
					# Long Unit Identifier
					'area-square-meter' => {
						'name' => q(ካሬ ሜትር),
						'one' => q({0} ሜ²),
						'other' => q({0} ሜ²),
						'per' => q({0}/ሜ²),
					},
					# Core Unit Identifier
					'square-meter' => {
						'name' => q(ካሬ ሜትር),
						'one' => q({0} ሜ²),
						'other' => q({0} ሜ²),
						'per' => q({0}/ሜ²),
					},
					# Long Unit Identifier
					'area-square-mile' => {
						'name' => q(ካሬ ማይል),
						'one' => q({0} ካሬ ማይል),
						'other' => q({0} ካሬ ማይል),
						'per' => q({0}/ማይል²),
					},
					# Core Unit Identifier
					'square-mile' => {
						'name' => q(ካሬ ማይል),
						'one' => q({0} ካሬ ማይል),
						'other' => q({0} ካሬ ማይል),
						'per' => q({0}/ማይል²),
					},
					# Long Unit Identifier
					'concentr-item' => {
						'name' => q(ንጥል),
						'one' => q({0} ንጥል),
						'other' => q({0} ንጥል),
					},
					# Core Unit Identifier
					'item' => {
						'name' => q(ንጥል),
						'one' => q({0} ንጥል),
						'other' => q({0} ንጥል),
					},
					# Long Unit Identifier
					'concentr-karat' => {
						'name' => q(ካራት),
						'one' => q({0} ካራት),
						'other' => q({0} ካራት),
					},
					# Core Unit Identifier
					'karat' => {
						'name' => q(ካራት),
						'one' => q({0} ካራት),
						'other' => q({0} ካራት),
					},
					# Long Unit Identifier
					'concentr-percent' => {
						'name' => q(ፐርሰንት),
					},
					# Core Unit Identifier
					'percent' => {
						'name' => q(ፐርሰንት),
					},
					# Long Unit Identifier
					'concentr-permille' => {
						'name' => q(በማይል),
					},
					# Core Unit Identifier
					'permille' => {
						'name' => q(በማይል),
					},
					# Long Unit Identifier
					'consumption-liter-per-100-kilometer' => {
						'name' => q(ሊትር በ100 ኪሎሜትሮች),
						'one' => q({0} ሊ/100ኪሜ),
						'other' => q({0} ሊ/100ኪሜ),
					},
					# Core Unit Identifier
					'liter-per-100-kilometer' => {
						'name' => q(ሊትር በ100 ኪሎሜትሮች),
						'one' => q({0} ሊ/100ኪሜ),
						'other' => q({0} ሊ/100ኪሜ),
					},
					# Long Unit Identifier
					'consumption-liter-per-kilometer' => {
						'name' => q(ሊ/ኪሜ),
						'one' => q({0} ሊ/ኪሜ),
						'other' => q({0} ሊ/ኪሜ),
					},
					# Core Unit Identifier
					'liter-per-kilometer' => {
						'name' => q(ሊ/ኪሜ),
						'one' => q({0} ሊ/ኪሜ),
						'other' => q({0} ሊ/ኪሜ),
					},
					# Long Unit Identifier
					'consumption-mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Core Unit Identifier
					'mile-per-gallon' => {
						'name' => q(mpg),
						'one' => q({0} mpg),
						'other' => q({0} mpg),
					},
					# Long Unit Identifier
					'coordinate' => {
						'east' => q({0}ምስ),
						'north' => q({0}ሰ),
						'south' => q({0}ደ),
						'west' => q({0}ምዕ),
					},
					# Core Unit Identifier
					'coordinate' => {
						'east' => q({0}ምስ),
						'north' => q({0}ሰ),
						'south' => q({0}ደ),
						'west' => q({0}ምዕ),
					},
					# Long Unit Identifier
					'digital-bit' => {
						'name' => q(ቢት),
						'one' => q({0} ቢት),
						'other' => q({0} ቢት),
					},
					# Core Unit Identifier
					'bit' => {
						'name' => q(ቢት),
						'one' => q({0} ቢት),
						'other' => q({0} ቢት),
					},
					# Long Unit Identifier
					'digital-byte' => {
						'name' => q(ባይት),
						'one' => q({0} ባይት),
						'other' => q({0} ባይት),
					},
					# Core Unit Identifier
					'byte' => {
						'name' => q(ባይት),
						'one' => q({0} ባይት),
						'other' => q({0} ባይት),
					},
					# Long Unit Identifier
					'digital-gigabit' => {
						'name' => q(ጊጋባይት),
						'one' => q({0} ጊጋባይት),
						'other' => q({0} ጊጋባይት),
					},
					# Core Unit Identifier
					'gigabit' => {
						'name' => q(ጊጋባይት),
						'one' => q({0} ጊጋባይት),
						'other' => q({0} ጊጋባይት),
					},
					# Long Unit Identifier
					'digital-gigabyte' => {
						'name' => q(ጊባ),
						'one' => q({0} ጊባ),
						'other' => q({0} ጊባ),
					},
					# Core Unit Identifier
					'gigabyte' => {
						'name' => q(ጊባ),
						'one' => q({0} ጊባ),
						'other' => q({0} ጊባ),
					},
					# Long Unit Identifier
					'digital-kilobit' => {
						'name' => q(ኪሎባይት),
						'one' => q({0} ኪሎባይት),
						'other' => q({0} ኪሎባይት),
					},
					# Core Unit Identifier
					'kilobit' => {
						'name' => q(ኪሎባይት),
						'one' => q({0} ኪሎባይት),
						'other' => q({0} ኪሎባይት),
					},
					# Long Unit Identifier
					'digital-kilobyte' => {
						'name' => q(ኪባ),
						'one' => q({0} ኪባ),
						'other' => q({0} ኪባ),
					},
					# Core Unit Identifier
					'kilobyte' => {
						'name' => q(ኪባ),
						'one' => q({0} ኪባ),
						'other' => q({0} ኪባ),
					},
					# Long Unit Identifier
					'digital-megabit' => {
						'name' => q(ሜባ),
						'one' => q({0} ሜባ),
						'other' => q({0} ሜባ),
					},
					# Core Unit Identifier
					'megabit' => {
						'name' => q(ሜባ),
						'one' => q({0} ሜባ),
						'other' => q({0} ሜባ),
					},
					# Long Unit Identifier
					'digital-megabyte' => {
						'name' => q(ሜጋባይት),
						'one' => q({0} ሜጋባይት),
						'other' => q({0} ሜጋባይት),
					},
					# Core Unit Identifier
					'megabyte' => {
						'name' => q(ሜጋባይት),
						'one' => q({0} ሜጋባይት),
						'other' => q({0} ሜጋባይት),
					},
					# Long Unit Identifier
					'digital-petabyte' => {
						'name' => q(ፔ ባይት),
						'one' => q({0} ፔባ),
						'other' => q({0} ፔባ),
					},
					# Core Unit Identifier
					'petabyte' => {
						'name' => q(ፔ ባይት),
						'one' => q({0} ፔባ),
						'other' => q({0} ፔባ),
					},
					# Long Unit Identifier
					'digital-terabit' => {
						'name' => q(ቴባ),
						'one' => q({0} ቴባ),
						'other' => q({0} ቴባ),
					},
					# Core Unit Identifier
					'terabit' => {
						'name' => q(ቴባ),
						'one' => q({0} ቴባ),
						'other' => q({0} ቴባ),
					},
					# Long Unit Identifier
					'digital-terabyte' => {
						'name' => q(ቴራባይት),
						'one' => q({0} ቴራባይት),
						'other' => q({0} ቴራባይት),
					},
					# Core Unit Identifier
					'terabyte' => {
						'name' => q(ቴራባይት),
						'one' => q({0} ቴራባይት),
						'other' => q({0} ቴራባይት),
					},
					# Long Unit Identifier
					'duration-century' => {
						'name' => q(ምዕተ ዓመት),
						'one' => q({0} ምዕተ ዓመት),
						'other' => q({0} ምዕተ ዓመት),
					},
					# Core Unit Identifier
					'century' => {
						'name' => q(ምዕተ ዓመት),
						'one' => q({0} ምዕተ ዓመት),
						'other' => q({0} ምዕተ ዓመት),
					},
					# Long Unit Identifier
					'duration-day' => {
						'name' => q(ቀናት),
						'one' => q({0} ቀናት),
						'other' => q({0} ቀናት),
						'per' => q({0}/ቀ),
					},
					# Core Unit Identifier
					'day' => {
						'name' => q(ቀናት),
						'one' => q({0} ቀናት),
						'other' => q({0} ቀናት),
						'per' => q({0}/ቀ),
					},
					# Long Unit Identifier
					'duration-decade' => {
						'name' => q(ዓሠርተ-ዓመት),
						'one' => q({0} ዓሠ.ዓ),
						'other' => q({0} ዓሠ.ዓ),
					},
					# Core Unit Identifier
					'decade' => {
						'name' => q(ዓሠርተ-ዓመት),
						'one' => q({0} ዓሠ.ዓ),
						'other' => q({0} ዓሠ.ዓ),
					},
					# Long Unit Identifier
					'duration-hour' => {
						'name' => q(ሰዓቶች),
						'one' => q({0} ሰዓ),
						'other' => q({0} ሰዓ),
						'per' => q({0}/ሰ),
					},
					# Core Unit Identifier
					'hour' => {
						'name' => q(ሰዓቶች),
						'one' => q({0} ሰዓ),
						'other' => q({0} ሰዓ),
						'per' => q({0}/ሰ),
					},
					# Long Unit Identifier
					'duration-microsecond' => {
						'name' => q(ማይክሮሰከንድ),
						'one' => q({0} ማሰ),
						'other' => q({0} ማሰ),
					},
					# Core Unit Identifier
					'microsecond' => {
						'name' => q(ማይክሮሰከንድ),
						'one' => q({0} ማሰ),
						'other' => q({0} ማሰ),
					},
					# Long Unit Identifier
					'duration-millisecond' => {
						'name' => q(ሚሊሰከንድ),
						'one' => q({0} ሚሴ),
						'other' => q({0} ሚሴ),
					},
					# Core Unit Identifier
					'millisecond' => {
						'name' => q(ሚሊሰከንድ),
						'one' => q({0} ሚሴ),
						'other' => q({0} ሚሴ),
					},
					# Long Unit Identifier
					'duration-minute' => {
						'name' => q(ደቂቃዎች),
						'one' => q({0} ደቂ),
						'other' => q({0} ደቂቃ),
						'per' => q({0}/ደ),
					},
					# Core Unit Identifier
					'minute' => {
						'name' => q(ደቂቃዎች),
						'one' => q({0} ደቂ),
						'other' => q({0} ደቂቃ),
						'per' => q({0}/ደ),
					},
					# Long Unit Identifier
					'duration-month' => {
						'name' => q(ወራት),
						'one' => q({0} ወራት),
						'other' => q({0} ወራት),
						'per' => q({0}/ወ),
					},
					# Core Unit Identifier
					'month' => {
						'name' => q(ወራት),
						'one' => q({0} ወራት),
						'other' => q({0} ወራት),
						'per' => q({0}/ወ),
					},
					# Long Unit Identifier
					'duration-nanosecond' => {
						'name' => q(ናኖሰከንድ),
						'one' => q({0} ናኖሰከንድ),
						'other' => q({0} ናኖሰከንድ),
					},
					# Core Unit Identifier
					'nanosecond' => {
						'name' => q(ናኖሰከንድ),
						'one' => q({0} ናኖሰከንድ),
						'other' => q({0} ናኖሰከንድ),
					},
					# Long Unit Identifier
					'duration-quarter' => {
						'name' => q(ሩብ),
						'one' => q({0} ሩብ),
						'other' => q({0} ሩብ),
						'per' => q({0}/ሩ),
					},
					# Core Unit Identifier
					'quarter' => {
						'name' => q(ሩብ),
						'one' => q({0} ሩብ),
						'other' => q({0} ሩብ),
						'per' => q({0}/ሩ),
					},
					# Long Unit Identifier
					'duration-second' => {
						'name' => q(ሰከንዶች),
						'one' => q({0} ሰከ),
						'other' => q({0} ሰከ),
						'per' => q({0}/ሰከ),
					},
					# Core Unit Identifier
					'second' => {
						'name' => q(ሰከንዶች),
						'one' => q({0} ሰከ),
						'other' => q({0} ሰከ),
						'per' => q({0}/ሰከ),
					},
					# Long Unit Identifier
					'duration-week' => {
						'name' => q(ሳምንታት),
						'one' => q({0} ሳምንት),
						'other' => q({0} ሳምንታት),
						'per' => q({0}/ሳ),
					},
					# Core Unit Identifier
					'week' => {
						'name' => q(ሳምንታት),
						'one' => q({0} ሳምንት),
						'other' => q({0} ሳምንታት),
						'per' => q({0}/ሳ),
					},
					# Long Unit Identifier
					'duration-year' => {
						'name' => q(ዓመታት),
						'one' => q({0} ዓመት),
						'other' => q({0} ዓመታት),
						'per' => q({0}/ዓ),
					},
					# Core Unit Identifier
					'year' => {
						'name' => q(ዓመታት),
						'one' => q({0} ዓመት),
						'other' => q({0} ዓመታት),
						'per' => q({0}/ዓ),
					},
					# Long Unit Identifier
					'energy-calorie' => {
						'name' => q(ካሎሪ),
						'one' => q({0} ካሎሪ),
						'other' => q({0} ካሎሪ),
					},
					# Core Unit Identifier
					'calorie' => {
						'name' => q(ካሎሪ),
						'one' => q({0} ካሎሪ),
						'other' => q({0} ካሎሪ),
					},
					# Long Unit Identifier
					'energy-electronvolt' => {
						'name' => q(ኤቮ),
						'one' => q({0} ኤቮ),
						'other' => q({0} ኤቮ),
					},
					# Core Unit Identifier
					'electronvolt' => {
						'name' => q(ኤቮ),
						'one' => q({0} ኤቮ),
						'other' => q({0} ኤቮ),
					},
					# Long Unit Identifier
					'energy-foodcalorie' => {
						'name' => q(ካሎሪ),
						'one' => q({0} ካሎሪ),
						'other' => q({0} ካሎሪ),
					},
					# Core Unit Identifier
					'foodcalorie' => {
						'name' => q(ካሎሪ),
						'one' => q({0} ካሎሪ),
						'other' => q({0} ካሎሪ),
					},
					# Long Unit Identifier
					'force-newton' => {
						'name' => q(ኒ),
						'one' => q({0} ኒ),
						'other' => q({0} ኒ),
					},
					# Core Unit Identifier
					'newton' => {
						'name' => q(ኒ),
						'one' => q({0} ኒ),
						'other' => q({0} ኒ),
					},
					# Long Unit Identifier
					'graphics-dot' => {
						'name' => q(ነቁጥ),
						'one' => q({0} ነቁጥ),
						'other' => q({0} ነቁጥ),
					},
					# Core Unit Identifier
					'dot' => {
						'name' => q(ነቁጥ),
						'one' => q({0} ነቁጥ),
						'other' => q({0} ነቁጥ),
					},
					# Long Unit Identifier
					'graphics-dot-per-centimeter' => {
						'name' => q(ነበሴሜ),
						'one' => q({0} ነበሴሜ),
						'other' => q({0} ነበሴሜ),
					},
					# Core Unit Identifier
					'dot-per-centimeter' => {
						'name' => q(ነበሴሜ),
						'one' => q({0} ነበሴሜ),
						'other' => q({0} ነበሴሜ),
					},
					# Long Unit Identifier
					'graphics-dot-per-inch' => {
						'name' => q(ነበኢ),
						'one' => q({0} ነበኢ),
						'other' => q({0} ነበኢ),
					},
					# Core Unit Identifier
					'dot-per-inch' => {
						'name' => q(ነበኢ),
						'one' => q({0} ነበኢ),
						'other' => q({0} ነበኢ),
					},
					# Long Unit Identifier
					'graphics-megapixel' => {
						'name' => q(ሜጋ ፒክስል),
						'one' => q({0} ሜጋ ፒክስል),
						'other' => q({0} ሜጋ ፒክስል),
					},
					# Core Unit Identifier
					'megapixel' => {
						'name' => q(ሜጋ ፒክስል),
						'one' => q({0} ሜጋ ፒክስል),
						'other' => q({0} ሜጋ ፒክስል),
					},
					# Long Unit Identifier
					'graphics-pixel' => {
						'name' => q(ፒክስል),
						'one' => q({0} ፒክስል),
						'other' => q({0} ፒክስል),
					},
					# Core Unit Identifier
					'pixel' => {
						'name' => q(ፒክስል),
						'one' => q({0} ፒክስል),
						'other' => q({0} ፒክስል),
					},
					# Long Unit Identifier
					'graphics-pixel-per-centimeter' => {
						'name' => q(ፒበሴሜ),
						'one' => q({0} ፒበሴሜ),
						'other' => q({0} ፒበሴሜ),
					},
					# Core Unit Identifier
					'pixel-per-centimeter' => {
						'name' => q(ፒበሴሜ),
						'one' => q({0} ፒበሴሜ),
						'other' => q({0} ፒበሴሜ),
					},
					# Long Unit Identifier
					'graphics-pixel-per-inch' => {
						'name' => q(ፒበኢ),
						'one' => q({0} ፒበኢ),
						'other' => q({0} ፒበኢ),
					},
					# Core Unit Identifier
					'pixel-per-inch' => {
						'name' => q(ፒበኢ),
						'one' => q({0} ፒበኢ),
						'other' => q({0} ፒበኢ),
					},
					# Long Unit Identifier
					'length-centimeter' => {
						'name' => q(ሴንቲሜትር),
						'one' => q({0} ሴሜ),
						'other' => q({0} ሴሜ),
						'per' => q({0}/ሴሜ),
					},
					# Core Unit Identifier
					'centimeter' => {
						'name' => q(ሴንቲሜትር),
						'one' => q({0} ሴሜ),
						'other' => q({0} ሴሜ),
						'per' => q({0}/ሴሜ),
					},
					# Long Unit Identifier
					'length-decimeter' => {
						'name' => q(ዴሜ),
						'one' => q({0} ዴሜ),
						'other' => q({0} ዴሜ),
					},
					# Core Unit Identifier
					'decimeter' => {
						'name' => q(ዴሜ),
						'one' => q({0} ዴሜ),
						'other' => q({0} ዴሜ),
					},
					# Long Unit Identifier
					'length-fathom' => {
						'name' => q(ተዳክሞዎች),
						'one' => q({0} ተዳክሞ),
						'other' => q({0} ተዳክሞ),
					},
					# Core Unit Identifier
					'fathom' => {
						'name' => q(ተዳክሞዎች),
						'one' => q({0} ተዳክሞ),
						'other' => q({0} ተዳክሞ),
					},
					# Long Unit Identifier
					'length-foot' => {
						'name' => q(ጫማ),
						'one' => q({0} ጫማ),
						'other' => q({0} ጫማ),
						'per' => q({0}/ጫማ),
					},
					# Core Unit Identifier
					'foot' => {
						'name' => q(ጫማ),
						'one' => q({0} ጫማ),
						'other' => q({0} ጫማ),
						'per' => q({0}/ጫማ),
					},
					# Long Unit Identifier
					'length-furlong' => {
						'name' => q(ፈሎን),
						'one' => q({0} ፈሎን),
						'other' => q({0} ፈሎን),
					},
					# Core Unit Identifier
					'furlong' => {
						'name' => q(ፈሎን),
						'one' => q({0} ፈሎን),
						'other' => q({0} ፈሎን),
					},
					# Long Unit Identifier
					'length-inch' => {
						'name' => q(ኢንች),
						'one' => q({0} ኢንች),
						'other' => q({0} ኢንች),
						'per' => q({0}/ኢንች),
					},
					# Core Unit Identifier
					'inch' => {
						'name' => q(ኢንች),
						'one' => q({0} ኢንች),
						'other' => q({0} ኢንች),
						'per' => q({0}/ኢንች),
					},
					# Long Unit Identifier
					'length-kilometer' => {
						'name' => q(ኪሎሜትር),
						'one' => q({0} ኪሜ),
						'other' => q({0} ኪሜ),
						'per' => q({0}/ኪሜ),
					},
					# Core Unit Identifier
					'kilometer' => {
						'name' => q(ኪሎሜትር),
						'one' => q({0} ኪሜ),
						'other' => q({0} ኪሜ),
						'per' => q({0}/ኪሜ),
					},
					# Long Unit Identifier
					'length-light-year' => {
						'name' => q(የብርሃን ዓመት),
						'one' => q({0} ብዓ),
						'other' => q({0} ብዓ),
					},
					# Core Unit Identifier
					'light-year' => {
						'name' => q(የብርሃን ዓመት),
						'one' => q({0} ብዓ),
						'other' => q({0} ብዓ),
					},
					# Long Unit Identifier
					'length-meter' => {
						'name' => q(ሜትር),
						'one' => q({0} ሜ),
						'other' => q({0} ሜ),
						'per' => q({0}/ሜ),
					},
					# Core Unit Identifier
					'meter' => {
						'name' => q(ሜትር),
						'one' => q({0} ሜ),
						'other' => q({0} ሜ),
						'per' => q({0}/ሜ),
					},
					# Long Unit Identifier
					'length-micrometer' => {
						'name' => q(ማሜ),
						'one' => q({0} ማሜ),
						'other' => q({0} ማሜ),
					},
					# Core Unit Identifier
					'micrometer' => {
						'name' => q(ማሜ),
						'one' => q({0} ማሜ),
						'other' => q({0} ማሜ),
					},
					# Long Unit Identifier
					'length-mile' => {
						'name' => q(ማይል),
						'one' => q({0} ማይል),
						'other' => q({0} ማይል),
					},
					# Core Unit Identifier
					'mile' => {
						'name' => q(ማይል),
						'one' => q({0} ማይል),
						'other' => q({0} ማይል),
					},
					# Long Unit Identifier
					'length-mile-scandinavian' => {
						'name' => q(ስማይል),
						'one' => q({0} ስማይል),
						'other' => q({0} ስማይል),
					},
					# Core Unit Identifier
					'mile-scandinavian' => {
						'name' => q(ስማይል),
						'one' => q({0} ስማይል),
						'other' => q({0} ስማይል),
					},
					# Long Unit Identifier
					'length-millimeter' => {
						'name' => q(ሚሊሜትር),
						'one' => q({0} ሚሜ),
						'other' => q({0} ሚሜ),
					},
					# Core Unit Identifier
					'millimeter' => {
						'name' => q(ሚሊሜትር),
						'one' => q({0} ሚሜ),
						'other' => q({0} ሚሜ),
					},
					# Long Unit Identifier
					'length-nanometer' => {
						'name' => q(ናሜ),
						'one' => q({0} ናሜ),
						'other' => q({0} ናሜ),
					},
					# Core Unit Identifier
					'nanometer' => {
						'name' => q(ናሜ),
						'one' => q({0} ናሜ),
						'other' => q({0} ናሜ),
					},
					# Long Unit Identifier
					'length-picometer' => {
						'name' => q(ፒኮሜትር),
						'one' => q({0} ፒሜ),
						'other' => q({0} ፒሜ),
					},
					# Core Unit Identifier
					'picometer' => {
						'name' => q(ፒኮሜትር),
						'one' => q({0} ፒሜ),
						'other' => q({0} ፒሜ),
					},
					# Long Unit Identifier
					'length-point' => {
						'name' => q(ነጥብ),
						'one' => q({0} ነጥብ),
						'other' => q({0} ነጥብ),
					},
					# Core Unit Identifier
					'point' => {
						'name' => q(ነጥብ),
						'one' => q({0} ነጥብ),
						'other' => q({0} ነጥብ),
					},
					# Long Unit Identifier
					'length-solar-radius' => {
						'name' => q(ሶላር ራዲ),
					},
					# Core Unit Identifier
					'solar-radius' => {
						'name' => q(ሶላር ራዲ),
					},
					# Long Unit Identifier
					'length-yard' => {
						'name' => q(ያርድ),
						'one' => q({0} ያርድ),
						'other' => q({0} ያርድ),
					},
					# Core Unit Identifier
					'yard' => {
						'name' => q(ያርድ),
						'one' => q({0} ያርድ),
						'other' => q({0} ያርድ),
					},
					# Long Unit Identifier
					'light-candela' => {
						'name' => q(ካንዴላ),
						'one' => q({0} ካንዴላ),
						'other' => q({0} ካንዴላ),
					},
					# Core Unit Identifier
					'candela' => {
						'name' => q(ካንዴላ),
						'one' => q({0} ካንዴላ),
						'other' => q({0} ካንዴላ),
					},
					# Long Unit Identifier
					'light-lumen' => {
						'name' => q(ቱቦ ቀዳዳ),
						'one' => q({0} ቱቦ ቀዳዳ),
						'other' => q({0} ቱቦ ቀዳዳ),
					},
					# Core Unit Identifier
					'lumen' => {
						'name' => q(ቱቦ ቀዳዳ),
						'one' => q({0} ቱቦ ቀዳዳ),
						'other' => q({0} ቱቦ ቀዳዳ),
					},
					# Long Unit Identifier
					'mass-dalton' => {
						'name' => q(ዳተንስ),
					},
					# Core Unit Identifier
					'dalton' => {
						'name' => q(ዳተንስ),
					},
					# Long Unit Identifier
					'mass-earth-mass' => {
						'name' => q(ኤርዝማስስ),
					},
					# Core Unit Identifier
					'earth-mass' => {
						'name' => q(ኤርዝማስስ),
					},
					# Long Unit Identifier
					'mass-grain' => {
						'name' => q(ጥራ ጥሬ),
						'one' => q({0} ጥራ ጥሬ),
						'other' => q({0} ጥራ ጥሬ),
					},
					# Core Unit Identifier
					'grain' => {
						'name' => q(ጥራ ጥሬ),
						'one' => q({0} ጥራ ጥሬ),
						'other' => q({0} ጥራ ጥሬ),
					},
					# Long Unit Identifier
					'mass-gram' => {
						'name' => q(ግራም),
						'one' => q({0} ግ),
						'other' => q({0} ግ),
						'per' => q({0}/ግራም),
					},
					# Core Unit Identifier
					'gram' => {
						'name' => q(ግራም),
						'one' => q({0} ግ),
						'other' => q({0} ግ),
						'per' => q({0}/ግራም),
					},
					# Long Unit Identifier
					'mass-kilogram' => {
						'name' => q(ኪሎግራም),
						'one' => q({0} ኪግ),
						'other' => q({0} ኪግ),
						'per' => q({0}/ኪሎግራም),
					},
					# Core Unit Identifier
					'kilogram' => {
						'name' => q(ኪሎግራም),
						'one' => q({0} ኪግ),
						'other' => q({0} ኪግ),
						'per' => q({0}/ኪሎግራም),
					},
					# Long Unit Identifier
					'mass-ounce' => {
						'name' => q(አውንስ),
						'one' => q({0} አውንስ),
						'other' => q({0} አውንስ),
						'per' => q({0}/አውንስ),
					},
					# Core Unit Identifier
					'ounce' => {
						'name' => q(አውንስ),
						'one' => q({0} አውንስ),
						'other' => q({0} አውንስ),
						'per' => q({0}/አውንስ),
					},
					# Long Unit Identifier
					'mass-pound' => {
						'name' => q(ፓውንድ),
						'one' => q({0} ፓውንድ),
						'other' => q({0} ፓውንድ),
						'per' => q({0}/ፓውንድ),
					},
					# Core Unit Identifier
					'pound' => {
						'name' => q(ፓውንድ),
						'one' => q({0} ፓውንድ),
						'other' => q({0} ፓውንድ),
						'per' => q({0}/ፓውንድ),
					},
					# Long Unit Identifier
					'mass-solar-mass' => {
						'name' => q(ሶላር ማስስ),
					},
					# Core Unit Identifier
					'solar-mass' => {
						'name' => q(ሶላር ማስስ),
					},
					# Long Unit Identifier
					'mass-stone' => {
						'name' => q(ድንጋይ),
						'one' => q({0} ድንጋይ),
						'other' => q({0} ድንጋይ),
					},
					# Core Unit Identifier
					'stone' => {
						'name' => q(ድንጋይ),
						'one' => q({0} ድንጋይ),
						'other' => q({0} ድንጋይ),
					},
					# Long Unit Identifier
					'mass-ton' => {
						'name' => q(ቶን),
						'one' => q({0} ቶን),
						'other' => q({0} ቶን),
					},
					# Core Unit Identifier
					'ton' => {
						'name' => q(ቶን),
						'one' => q({0} ቶን),
						'other' => q({0} ቶን),
					},
					# Long Unit Identifier
					'mass-tonne' => {
						'name' => q(ቶ),
						'one' => q({0} ቶ),
						'other' => q({0} ቶ),
					},
					# Core Unit Identifier
					'tonne' => {
						'name' => q(ቶ),
						'one' => q({0} ቶ),
						'other' => q({0} ቶ),
					},
					# Long Unit Identifier
					'power-horsepower' => {
						'name' => q(የፈረስ ጉልበት),
						'one' => q({0} የፈጉ),
						'other' => q({0} የፈጉ),
					},
					# Core Unit Identifier
					'horsepower' => {
						'name' => q(የፈረስ ጉልበት),
						'one' => q({0} የፈጉ),
						'other' => q({0} የፈጉ),
					},
					# Long Unit Identifier
					'power-kilowatt' => {
						'name' => q(ኪሎዋት),
						'one' => q({0} ኪዋ),
						'other' => q({0} ኪዋ),
					},
					# Core Unit Identifier
					'kilowatt' => {
						'name' => q(ኪሎዋት),
						'one' => q({0} ኪዋ),
						'other' => q({0} ኪዋ),
					},
					# Long Unit Identifier
					'power-watt' => {
						'name' => q(ዋት),
						'one' => q({0} ዋ),
						'other' => q({0} ዋ),
					},
					# Core Unit Identifier
					'watt' => {
						'name' => q(ዋት),
						'one' => q({0} ዋ),
						'other' => q({0} ዋ),
					},
					# Long Unit Identifier
					'pressure-atmosphere' => {
						'name' => q(ከባቢ አየር),
						'one' => q({0} ከባቢ አየር),
						'other' => q({0} ከባቢ አየር),
					},
					# Core Unit Identifier
					'atmosphere' => {
						'name' => q(ከባቢ አየር),
						'one' => q({0} ከባቢ አየር),
						'other' => q({0} ከባቢ አየር),
					},
					# Long Unit Identifier
					'pressure-bar' => {
						'name' => q(አሞሌ),
						'one' => q({0} አሞሌ),
						'other' => q({0} አሞሌዎች),
					},
					# Core Unit Identifier
					'bar' => {
						'name' => q(አሞሌ),
						'one' => q({0} አሞሌ),
						'other' => q({0} አሞሌዎች),
					},
					# Long Unit Identifier
					'pressure-hectopascal' => {
						'name' => q(ሄክቶፓስካል),
						'one' => q({0} ሄክቶፓስካል),
						'other' => q({0} ሄክቶፓስካል),
					},
					# Core Unit Identifier
					'hectopascal' => {
						'name' => q(ሄክቶፓስካል),
						'one' => q({0} ሄክቶፓስካል),
						'other' => q({0} ሄክቶፓስካል),
					},
					# Long Unit Identifier
					'pressure-inch-ofhg' => {
						'name' => q(ኢንች ሜርኩሪ),
						'one' => q({0} ኢሜ),
						'other' => q({0} ኢንሜር),
					},
					# Core Unit Identifier
					'inch-ofhg' => {
						'name' => q(ኢንች ሜርኩሪ),
						'one' => q({0} ኢሜ),
						'other' => q({0} ኢንሜር),
					},
					# Long Unit Identifier
					'pressure-kilopascal' => {
						'name' => q(ኪሎፓስካል),
						'one' => q({0} ኪሎፓስካል),
						'other' => q({0} ኪሎፓስካል),
					},
					# Core Unit Identifier
					'kilopascal' => {
						'name' => q(ኪሎፓስካል),
						'one' => q({0} ኪሎፓስካል),
						'other' => q({0} ኪሎፓስካል),
					},
					# Long Unit Identifier
					'pressure-megapascal' => {
						'name' => q(ሜጋፓስካል),
						'one' => q({0} ሜጋፓስካል),
						'other' => q({0} ሜጋፓስካል),
					},
					# Core Unit Identifier
					'megapascal' => {
						'name' => q(ሜጋፓስካል),
						'one' => q({0} ሜጋፓስካል),
						'other' => q({0} ሜጋፓስካል),
					},
					# Long Unit Identifier
					'pressure-millibar' => {
						'name' => q(ሚሊባር),
						'one' => q({0} ሚባ),
						'other' => q({0} ሚባ),
					},
					# Core Unit Identifier
					'millibar' => {
						'name' => q(ሚሊባር),
						'one' => q({0} ሚባ),
						'other' => q({0} ሚባ),
					},
					# Long Unit Identifier
					'pressure-pascal' => {
						'name' => q(ፓስካል),
						'one' => q({0} ፓስካል),
						'other' => q({0} ፓስካል),
					},
					# Core Unit Identifier
					'pascal' => {
						'name' => q(ፓስካል),
						'one' => q({0} ፓስካል),
						'other' => q({0} ፓስካል),
					},
					# Long Unit Identifier
					'speed-kilometer-per-hour' => {
						'name' => q(ኪሎሜትር በሰዓት),
						'one' => q({0} ኪሜ/ሰ),
						'other' => q({0} ኪሜ/ሰ),
					},
					# Core Unit Identifier
					'kilometer-per-hour' => {
						'name' => q(ኪሎሜትር በሰዓት),
						'one' => q({0} ኪሜ/ሰ),
						'other' => q({0} ኪሜ/ሰ),
					},
					# Long Unit Identifier
					'speed-meter-per-second' => {
						'name' => q(ሜትር በሰከንድ),
						'one' => q({0} ሜ/ሴ),
						'other' => q({0} ሜ/ሴ),
					},
					# Core Unit Identifier
					'meter-per-second' => {
						'name' => q(ሜትር በሰከንድ),
						'one' => q({0} ሜ/ሴ),
						'other' => q({0} ሜ/ሴ),
					},
					# Long Unit Identifier
					'speed-mile-per-hour' => {
						'name' => q(ማይል በሰዓት),
						'one' => q({0} ማይል/ሰ),
						'other' => q({0} ማይል/ሰ),
					},
					# Core Unit Identifier
					'mile-per-hour' => {
						'name' => q(ማይል በሰዓት),
						'one' => q({0} ማይል/ሰ),
						'other' => q({0} ማይል/ሰ),
					},
					# Long Unit Identifier
					'temperature-celsius' => {
						'name' => q(ዲግሪ ሴልሺየስ),
						'one' => q({0}°ሴ),
						'other' => q({0}°ሴ),
					},
					# Core Unit Identifier
					'celsius' => {
						'name' => q(ዲግሪ ሴልሺየስ),
						'one' => q({0}°ሴ),
						'other' => q({0}°ሴ),
					},
					# Long Unit Identifier
					'temperature-fahrenheit' => {
						'name' => q(ዲግሪ ፋራንሃይት),
						'one' => q({0}°ፋ),
						'other' => q({0}°ፋ),
					},
					# Core Unit Identifier
					'fahrenheit' => {
						'name' => q(ዲግሪ ፋራንሃይት),
						'one' => q({0}°ፋ),
						'other' => q({0}°ፋ),
					},
					# Long Unit Identifier
					'torque-newton-meter' => {
						'name' => q(ኒ.ሜ),
						'one' => q({0} ኒ.ሜ),
						'other' => q({0} ኒ.ሜ),
					},
					# Core Unit Identifier
					'newton-meter' => {
						'name' => q(ኒ.ሜ),
						'one' => q({0} ኒ.ሜ),
						'other' => q({0} ኒ.ሜ),
					},
					# Long Unit Identifier
					'volume-acre-foot' => {
						'name' => q(ኤከር ጫማ),
						'one' => q({0} ኤከር ጫማ),
						'other' => q({0} ኤከር ጫማ),
					},
					# Core Unit Identifier
					'acre-foot' => {
						'name' => q(ኤከር ጫማ),
						'one' => q({0} ኤከር ጫማ),
						'other' => q({0} ኤከር ጫማ),
					},
					# Long Unit Identifier
					'volume-barrel' => {
						'name' => q(በርሜል),
						'one' => q({0} በርሜል),
						'other' => q({0} በርሜል),
					},
					# Core Unit Identifier
					'barrel' => {
						'name' => q(በርሜል),
						'one' => q({0} በርሜል),
						'other' => q({0} በርሜል),
					},
					# Long Unit Identifier
					'volume-bushel' => {
						'name' => q(ዳውላ),
						'one' => q({0} ዳውላ),
						'other' => q({0} ዳውላ),
					},
					# Core Unit Identifier
					'bushel' => {
						'name' => q(ዳውላ),
						'one' => q({0} ዳውላ),
						'other' => q({0} ዳውላ),
					},
					# Long Unit Identifier
					'volume-centiliter' => {
						'name' => q(ሴሊ),
						'one' => q({0} ሴሊ),
						'other' => q({0} ሴሊ),
					},
					# Core Unit Identifier
					'centiliter' => {
						'name' => q(ሴሊ),
						'one' => q({0} ሴሊ),
						'other' => q({0} ሴሊ),
					},
					# Long Unit Identifier
					'volume-cubic-centimeter' => {
						'name' => q(ሴሜ³),
						'one' => q({0} ሴሜ³),
						'other' => q({0} ሴሜ³),
						'per' => q({0}/ሴሜ³),
					},
					# Core Unit Identifier
					'cubic-centimeter' => {
						'name' => q(ሴሜ³),
						'one' => q({0} ሴሜ³),
						'other' => q({0} ሴሜ³),
						'per' => q({0}/ሴሜ³),
					},
					# Long Unit Identifier
					'volume-cubic-foot' => {
						'name' => q(ጫማ³),
						'one' => q({0} ጫማ³),
						'other' => q({0} ጫማ³),
					},
					# Core Unit Identifier
					'cubic-foot' => {
						'name' => q(ጫማ³),
						'one' => q({0} ጫማ³),
						'other' => q({0} ጫማ³),
					},
					# Long Unit Identifier
					'volume-cubic-inch' => {
						'name' => q(ኢንች³),
						'one' => q({0} ኢንች³),
						'other' => q({0} ኢንች³),
					},
					# Core Unit Identifier
					'cubic-inch' => {
						'name' => q(ኢንች³),
						'one' => q({0} ኢንች³),
						'other' => q({0} ኢንች³),
					},
					# Long Unit Identifier
					'volume-cubic-kilometer' => {
						'name' => q(ኩቢክ ኪሎሜትር),
						'one' => q({0} ኪሜ³),
						'other' => q({0} ኪሜ³),
					},
					# Core Unit Identifier
					'cubic-kilometer' => {
						'name' => q(ኩቢክ ኪሎሜትር),
						'one' => q({0} ኪሜ³),
						'other' => q({0} ኪሜ³),
					},
					# Long Unit Identifier
					'volume-cubic-meter' => {
						'name' => q(ሜ³),
						'one' => q({0} ሜ³),
						'other' => q({0} ሜ³),
						'per' => q({0}/ሜ³),
					},
					# Core Unit Identifier
					'cubic-meter' => {
						'name' => q(ሜ³),
						'one' => q({0} ሜ³),
						'other' => q({0} ሜ³),
						'per' => q({0}/ሜ³),
					},
					# Long Unit Identifier
					'volume-cubic-mile' => {
						'name' => q(ኩቢክ ማይል),
						'one' => q({0} ማይል³),
						'other' => q({0} ማይል³),
					},
					# Core Unit Identifier
					'cubic-mile' => {
						'name' => q(ኩቢክ ማይል),
						'one' => q({0} ማይል³),
						'other' => q({0} ማይል³),
					},
					# Long Unit Identifier
					'volume-deciliter' => {
						'name' => q(ዴሊ),
						'one' => q({0} ዴሊ),
						'other' => q({0} ዴሊ),
					},
					# Core Unit Identifier
					'deciliter' => {
						'name' => q(ዴሊ),
						'one' => q({0} ዴሊ),
						'other' => q({0} ዴሊ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon' => {
						'name' => q(የመምድረ በዳ ማንኪያ),
						'one' => q({0} የመምድረ በዳ ማንኪያ),
						'other' => q({0} የመምድረ በዳ ማንኪያ),
					},
					# Core Unit Identifier
					'dessert-spoon' => {
						'name' => q(የመምድረ በዳ ማንኪያ),
						'one' => q({0} የመምድረ በዳ ማንኪያ),
						'other' => q({0} የመምድረ በዳ ማንኪያ),
					},
					# Long Unit Identifier
					'volume-dessert-spoon-imperial' => {
						'name' => q(የምድረ በዳ ማንኪያ),
						'one' => q({0} የምድረ በዳ ማንኪያ),
						'other' => q({0} የምድረ በዳ ማንኪያ),
					},
					# Core Unit Identifier
					'dessert-spoon-imperial' => {
						'name' => q(የምድረ በዳ ማንኪያ),
						'one' => q({0} የምድረ በዳ ማንኪያ),
						'other' => q({0} የምድረ በዳ ማንኪያ),
					},
					# Long Unit Identifier
					'volume-dram' => {
						'name' => q(የክብደት መለኪያ),
						'one' => q({0} የክብደት መለኪያ),
						'other' => q({0} የክብደት መለኪያ),
					},
					# Core Unit Identifier
					'dram' => {
						'name' => q(የክብደት መለኪያ),
						'one' => q({0} የክብደት መለኪያ),
						'other' => q({0} የክብደት መለኪያ),
					},
					# Long Unit Identifier
					'volume-drop' => {
						'name' => q(ጠብታ),
						'one' => q({0} ጠብታ),
						'other' => q({0} ጠብታ),
					},
					# Core Unit Identifier
					'drop' => {
						'name' => q(ጠብታ),
						'one' => q({0} ጠብታ),
						'other' => q({0} ጠብታ),
					},
					# Long Unit Identifier
					'volume-fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Core Unit Identifier
					'fluid-ounce' => {
						'name' => q(fl oz),
						'one' => q({0} fl oz),
						'other' => q({0} fl oz),
					},
					# Long Unit Identifier
					'volume-gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Core Unit Identifier
					'gallon' => {
						'name' => q(gal),
						'one' => q({0} gal),
						'other' => q({0} gal),
						'per' => q({0}/gal),
					},
					# Long Unit Identifier
					'volume-jigger' => {
						'name' => q(ሙጃሌ),
						'one' => q({0} ሙጃሌ),
						'other' => q({0} ሙጃሌ),
					},
					# Core Unit Identifier
					'jigger' => {
						'name' => q(ሙጃሌ),
						'one' => q({0} ሙጃሌ),
						'other' => q({0} ሙጃሌ),
					},
					# Long Unit Identifier
					'volume-liter' => {
						'name' => q(ሊትር),
						'one' => q({0} ሊ),
						'other' => q({0} ሊ),
						'per' => q({0}/ሊትር),
					},
					# Core Unit Identifier
					'liter' => {
						'name' => q(ሊትር),
						'one' => q({0} ሊ),
						'other' => q({0} ሊ),
						'per' => q({0}/ሊትር),
					},
					# Long Unit Identifier
					'volume-milliliter' => {
						'name' => q(ሚሊ ሊትር),
						'one' => q({0} ሚሊ ሊትር),
						'other' => q({0} ሚሊ ሊትር),
					},
					# Core Unit Identifier
					'milliliter' => {
						'name' => q(ሚሊ ሊትር),
						'one' => q({0} ሚሊ ሊትር),
						'other' => q({0} ሚሊ ሊትር),
					},
					# Long Unit Identifier
					'volume-pinch' => {
						'name' => q(ቁንጥ),
						'one' => q({0} ቁንጥ),
						'other' => q({0} ቁንጥ),
					},
					# Core Unit Identifier
					'pinch' => {
						'name' => q(ቁንጥ),
						'one' => q({0} ቁንጥ),
						'other' => q({0} ቁንጥ),
					},
					# Long Unit Identifier
					'volume-quart-imperial' => {
						'name' => q(የፈሳሽ መለኪያ),
						'one' => q({0} የፈሳሽ መለኪያ),
						'other' => q({0} የፈሳሽ መለኪያ),
					},
					# Core Unit Identifier
					'quart-imperial' => {
						'name' => q(የፈሳሽ መለኪያ),
						'one' => q({0} የፈሳሽ መለኪያ),
						'other' => q({0} የፈሳሽ መለኪያ),
					},
				},
			} }
);

has 'yesstr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:አዎን|ዎ|yes|y)$' }
);

has 'nostr' => (
	is			=> 'ro',
	isa			=> RegexpRef,
	init_arg	=> undef,
	default		=> sub { qr'^(?i:አይ|ይ|no|n)$' }
);

has 'listPatterns' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
				start => q({0}፣ {1}),
				middle => q({0}፣ {1}),
				end => q({0}፣ እና {1}),
				2 => q({0} እና {1}),
		} }
);

has traditional_numbering_system => (
	is			=> 'ro',
	isa			=> Str,
	init_arg	=> undef,
	default		=> 'ethi',
);

has 'number_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		decimalFormat => {
			'long' => {
				'1000' => {
					'one' => '0 ሺ',
					'other' => '0 ሺ',
				},
				'10000' => {
					'one' => '00 ሺ',
					'other' => '00 ሺ',
				},
				'100000' => {
					'one' => '000 ሺ',
					'other' => '000 ሺ',
				},
				'1000000' => {
					'one' => '0 ሚሊዮን',
					'other' => '0 ሚሊዮን',
				},
				'10000000' => {
					'one' => '00 ሚሊዮን',
					'other' => '00 ሚሊዮን',
				},
				'100000000' => {
					'one' => '000 ሚሊዮን',
					'other' => '000 ሚሊዮን',
				},
				'1000000000' => {
					'one' => '0 ቢሊዮን',
					'other' => '0 ቢሊዮን',
				},
				'10000000000' => {
					'one' => '00 ቢሊዮን',
					'other' => '00 ቢሊዮን',
				},
				'100000000000' => {
					'one' => '000 ቢሊዮን',
					'other' => '000 ቢሊዮን',
				},
				'1000000000000' => {
					'one' => '0 ትሪሊዮን',
					'other' => '0 ትሪሊዮን',
				},
				'10000000000000' => {
					'one' => '00 ትሪሊዮን',
					'other' => '00 ትሪሊዮን',
				},
				'100000000000000' => {
					'one' => '000 ትሪሊዮን',
					'other' => '000 ትሪሊዮን',
				},
			},
			'short' => {
				'1000' => {
					'one' => '0 ሺ',
					'other' => '0 ሺ',
				},
				'10000' => {
					'one' => '00 ሺ',
					'other' => '00 ሺ',
				},
				'100000' => {
					'one' => '000 ሺ',
					'other' => '000 ሺ',
				},
				'1000000' => {
					'one' => '0 ሚ',
					'other' => '0 ሚ',
				},
				'10000000' => {
					'one' => '00 ሚ',
					'other' => '00 ሚ',
				},
				'100000000' => {
					'one' => '000 ሚ',
					'other' => '000 ሚ',
				},
				'1000000000' => {
					'one' => '0 ቢ',
					'other' => '0 ቢ',
				},
				'10000000000' => {
					'one' => '00 ቢ',
					'other' => '00 ቢ',
				},
				'100000000000' => {
					'one' => '000 ቢ',
					'other' => '000 ቢ',
				},
				'1000000000000' => {
					'one' => '0 ት',
					'other' => '0 ት',
				},
				'10000000000000' => {
					'one' => '00 ት',
					'other' => '00 ት',
				},
				'100000000000000' => {
					'one' => '000 ት',
					'other' => '000 ት',
				},
			},
		},
} },
);

has 'number_currency_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'latn' => {
			'pattern' => {
				'default' => {
					'accounting' => {
						'negative' => '(¤#,##0.00)',
						'positive' => '¤#,##0.00',
					},
					'standard' => {
						'positive' => '¤#,##0.00',
					},
				},
			},
		},
} },
);

has 'currencies' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'AED' => {
			display_name => {
				'currency' => q(የተባበሩት የአረብ ኤምሬትስ ድርሀም),
			},
		},
		'AFN' => {
			display_name => {
				'currency' => q(የአፍጋን አፍጋኒ),
			},
		},
		'ALL' => {
			display_name => {
				'currency' => q(የአልባንያ ሌክ),
			},
		},
		'AMD' => {
			display_name => {
				'currency' => q(የአርመን ድራም),
			},
		},
		'ANG' => {
			display_name => {
				'currency' => q(ኔዘርላንድስ አንቲሊአን ጊልደር),
			},
		},
		'AOA' => {
			display_name => {
				'currency' => q(የአንጎላ ኩዋንዛ),
			},
		},
		'ARS' => {
			display_name => {
				'currency' => q(የአርጀንቲና ፔሶ),
			},
		},
		'AUD' => {
			symbol => 'AU$',
			display_name => {
				'currency' => q(የአውስትራሊያ ዶላር),
			},
		},
		'AWG' => {
			display_name => {
				'currency' => q(አሩባን ፍሎሪን),
			},
		},
		'AZN' => {
			display_name => {
				'currency' => q(የአዛርባጃን ማናት),
			},
		},
		'BAM' => {
			display_name => {
				'currency' => q(የቦስኒያ ሄርዞጎቪና የሚመነዘር ማርክ),
			},
		},
		'BBD' => {
			display_name => {
				'currency' => q(የባርቤዶስ ዶላር),
			},
		},
		'BDT' => {
			display_name => {
				'currency' => q(የባንግላዲሽ ታካ),
			},
		},
		'BGN' => {
			display_name => {
				'currency' => q(የቡልጋሪያ ሌቭ),
			},
		},
		'BHD' => {
			display_name => {
				'currency' => q(የባኽሬን ዲናር),
			},
		},
		'BIF' => {
			display_name => {
				'currency' => q(የብሩንዲ ፍራንክ),
			},
		},
		'BMD' => {
			display_name => {
				'currency' => q(የቤርሙዳ ዶላር),
			},
		},
		'BND' => {
			display_name => {
				'currency' => q(የብሩኔ ዶላር),
			},
		},
		'BOB' => {
			display_name => {
				'currency' => q(የቦሊቪያ ቦሊቪያኖ),
			},
		},
		'BRL' => {
			display_name => {
				'currency' => q(የብራዚል ሪል),
			},
		},
		'BSD' => {
			display_name => {
				'currency' => q(የባሃማስ ዶላር),
			},
		},
		'BTN' => {
			display_name => {
				'currency' => q(ብሁታኒዝ ንጉልትረም),
			},
		},
		'BWP' => {
			display_name => {
				'currency' => q(የቦትስዋና ፑላ),
			},
		},
		'BYN' => {
			symbol => 'р.',
			display_name => {
				'currency' => q(የቤላሩስያ ሩብል),
			},
		},
		'BYR' => {
			display_name => {
				'currency' => q(የቤላሩስያ ሩብል \(2000–2016\)),
			},
		},
		'BZD' => {
			display_name => {
				'currency' => q(የቤሊዝ ዶላር),
			},
		},
		'CAD' => {
			display_name => {
				'currency' => q(የካናዳ ዶላር),
			},
		},
		'CDF' => {
			display_name => {
				'currency' => q(የኮንጐ ፍራንክ ኮንጐሌዝ),
			},
		},
		'CHF' => {
			display_name => {
				'currency' => q(የስዊስ ፍራንክ),
			},
		},
		'CLP' => {
			display_name => {
				'currency' => q(የቺሊ ፔሶ),
			},
		},
		'CNH' => {
			symbol => 'የቻይና ዩዋን',
			display_name => {
				'currency' => q(የቻይና ዩዋን \(የውጭ ምንዛሪ\)),
			},
		},
		'CNY' => {
			display_name => {
				'currency' => q(የቻይና የን),
			},
		},
		'COP' => {
			display_name => {
				'currency' => q(የኮሎምቢያ ፔሶ),
			},
		},
		'CRC' => {
			display_name => {
				'currency' => q(የኮስታሪካ ኮሎን),
			},
		},
		'CUC' => {
			display_name => {
				'currency' => q(የኩባ የሚመነዘር ፔሶ),
			},
		},
		'CUP' => {
			display_name => {
				'currency' => q(የኩባ ፔሶ),
			},
		},
		'CVE' => {
			display_name => {
				'currency' => q(የኬፕ ቫርዲ ኤስኩዶ),
			},
		},
		'CZK' => {
			display_name => {
				'currency' => q(ቼክ ሪፐብሊክ ኮሩና),
				'one' => q(ቼክ ሪፐብሊክ ኮሩና),
				'other' => q(ቼክ ሪፐብሊክ ኮሮና),
			},
		},
		'DJF' => {
			display_name => {
				'currency' => q(የጅቡቲ ፍራንክ),
			},
		},
		'DKK' => {
			display_name => {
				'currency' => q(የዴንማርክ ክሮን),
			},
		},
		'DOP' => {
			display_name => {
				'currency' => q(የዶሚኒክ ፔሶ),
			},
		},
		'DZD' => {
			display_name => {
				'currency' => q(የአልጄሪያ ዲናር),
			},
		},
		'EGP' => {
			display_name => {
				'currency' => q(የግብጽ ፓውንድ),
			},
		},
		'ERN' => {
			display_name => {
				'currency' => q(የኤርትራ ናቅፋ),
			},
		},
		'ETB' => {
			symbol => 'ብር',
			display_name => {
				'currency' => q(የኢትዮጵያ ብር),
			},
		},
		'EUR' => {
			display_name => {
				'currency' => q(ዩሮ),
			},
		},
		'FJD' => {
			display_name => {
				'currency' => q(የፊጂ ዶላር),
			},
		},
		'FKP' => {
			display_name => {
				'currency' => q(የፎክላንድ ደሴቶች ፓውንድ),
			},
		},
		'GBP' => {
			display_name => {
				'currency' => q(የእንግሊዝ ፓውንድ ስተርሊንግ),
			},
		},
		'GEL' => {
			display_name => {
				'currency' => q(የጆርጅያ ላሪ),
			},
		},
		'GHC' => {
			display_name => {
				'currency' => q(የጋና ሴዲ),
			},
		},
		'GHS' => {
			display_name => {
				'currency' => q(የጋና ሲዲ),
			},
		},
		'GIP' => {
			display_name => {
				'currency' => q(ጂብራልተር ፓውንድ),
			},
		},
		'GMD' => {
			display_name => {
				'currency' => q(የጋምቢያ ዳላሲ),
			},
		},
		'GNF' => {
			display_name => {
				'currency' => q(የጊኒ ፍራንክ),
			},
		},
		'GTQ' => {
			display_name => {
				'currency' => q(ጓቲማላን ኩቲዛል),
			},
		},
		'GYD' => {
			display_name => {
				'currency' => q(የጉየና ዶላር),
			},
		},
		'HKD' => {
			display_name => {
				'currency' => q(የሆንግኮንግ ዶላር),
			},
		},
		'HNL' => {
			display_name => {
				'currency' => q(የሃንዱራ ሌምፓአይራ),
			},
		},
		'HRK' => {
			display_name => {
				'currency' => q(የክሮሽያ ኩና),
			},
		},
		'HTG' => {
			display_name => {
				'currency' => q(የሃያቲ ጓርዴ),
			},
		},
		'HUF' => {
			display_name => {
				'currency' => q(የሃንጋሪያን ፎሪንት),
			},
		},
		'IDR' => {
			display_name => {
				'currency' => q(የኢንዶኔዥያ ሩፒሃ),
			},
		},
		'ILS' => {
			display_name => {
				'currency' => q(የእስራኤል አዲስ ሽቅል),
			},
		},
		'INR' => {
			display_name => {
				'currency' => q(የሕንድ ሩፒ),
			},
		},
		'IQD' => {
			display_name => {
				'currency' => q(የኢራቅ ዲናር),
			},
		},
		'IRR' => {
			display_name => {
				'currency' => q(የኢራን ሪአል),
			},
		},
		'ISK' => {
			display_name => {
				'currency' => q(የአይስላንድ ክሮና),
			},
		},
		'JMD' => {
			display_name => {
				'currency' => q(የጃማይካ ዶላር),
			},
		},
		'JOD' => {
			display_name => {
				'currency' => q(የጆርዳን ዲናር),
			},
		},
		'JPY' => {
			display_name => {
				'currency' => q(የጃፓን የን),
			},
		},
		'KES' => {
			display_name => {
				'currency' => q(የኬኒያ ሺሊንግ),
			},
		},
		'KGS' => {
			display_name => {
				'currency' => q(የኪርጊስታን ሶም),
			},
		},
		'KHR' => {
			display_name => {
				'currency' => q(የካምቦዲያ ሬል),
			},
		},
		'KMF' => {
			display_name => {
				'currency' => q(የኮሞሮ ፍራንክ),
			},
		},
		'KPW' => {
			display_name => {
				'currency' => q(የሰሜን ኮሪያ ዎን),
			},
		},
		'KRW' => {
			display_name => {
				'currency' => q(የደቡብ ኮሪያ ዎን),
			},
		},
		'KWD' => {
			display_name => {
				'currency' => q(የኩዌት ዲናር),
			},
		},
		'KYD' => {
			display_name => {
				'currency' => q(የካይማን ደሴቶች ዶላር),
			},
		},
		'KZT' => {
			display_name => {
				'currency' => q(የካዛኪስታን ተንጌ),
			},
		},
		'LAK' => {
			display_name => {
				'currency' => q(የላኦቲ ኪፕ),
			},
		},
		'LBP' => {
			display_name => {
				'currency' => q(የሊባኖስ ፓውንድ),
			},
		},
		'LKR' => {
			display_name => {
				'currency' => q(የሲሪላንካ ሩፒ),
			},
		},
		'LRD' => {
			display_name => {
				'currency' => q(የላይቤሪያ ዶላር),
			},
		},
		'LSL' => {
			display_name => {
				'currency' => q(የሌሶቶ ሎቲ),
			},
		},
		'LTL' => {
			display_name => {
				'currency' => q(ሊቱዌንያን ሊታስ),
			},
		},
		'LVL' => {
			display_name => {
				'currency' => q(የላቲቫ ላትስ),
			},
		},
		'LYD' => {
			display_name => {
				'currency' => q(የሊቢያ ዲናር),
			},
		},
		'MAD' => {
			display_name => {
				'currency' => q(የሞሮኮ ዲርሀም),
			},
		},
		'MDL' => {
			display_name => {
				'currency' => q(ሞልዶቫን ሊኡ),
			},
		},
		'MGA' => {
			display_name => {
				'currency' => q(የማደጋስካር ማላጋስይ አሪያርይ),
			},
		},
		'MKD' => {
			display_name => {
				'currency' => q(የሜቆድንያ ዲናር),
			},
		},
		'MMK' => {
			display_name => {
				'currency' => q(የማያናማር ክያት),
			},
		},
		'MNT' => {
			display_name => {
				'currency' => q(የሞንጎሊያን ቱግሪክ),
			},
		},
		'MOP' => {
			display_name => {
				'currency' => q(የማካኔዝ ፓታካ),
			},
		},
		'MRO' => {
			display_name => {
				'currency' => q(የሞሪቴኒያ ኦውጉያ \(1973–2017\)),
			},
		},
		'MRU' => {
			display_name => {
				'currency' => q(የሞሪቴኒያ ኦውጉያ),
			},
		},
		'MUR' => {
			display_name => {
				'currency' => q(የሞሪሸስ ሩፒ),
			},
		},
		'MVR' => {
			display_name => {
				'currency' => q(የማልዲቫ ሩፊያ),
			},
		},
		'MWK' => {
			display_name => {
				'currency' => q(የማላዊ ኩዋቻ),
			},
		},
		'MXN' => {
			display_name => {
				'currency' => q(የሜክሲኮ ፔሶ),
			},
		},
		'MYR' => {
			display_name => {
				'currency' => q(የማሌዥያ ሪንጊት),
			},
		},
		'MZN' => {
			display_name => {
				'currency' => q(የሞዛምቢክ ሜቲካል),
			},
		},
		'NAD' => {
			display_name => {
				'currency' => q(የናሚቢያ ዶላር),
			},
		},
		'NGN' => {
			display_name => {
				'currency' => q(የናይጄሪያ ናይራ),
			},
		},
		'NIO' => {
			display_name => {
				'currency' => q(የኒካራጓ ኮርዶባ),
			},
		},
		'NOK' => {
			display_name => {
				'currency' => q(የኖርዌይ ክሮን),
			},
		},
		'NPR' => {
			display_name => {
				'currency' => q(የኔፓል ሩፒ),
			},
		},
		'NZD' => {
			display_name => {
				'currency' => q(የኒውዚላንድ ዶላር),
			},
		},
		'OMR' => {
			display_name => {
				'currency' => q(የኦማን ሪአል),
			},
		},
		'PAB' => {
			display_name => {
				'currency' => q(ፓናማኒአን ባልቦአ),
			},
		},
		'PEN' => {
			display_name => {
				'currency' => q(የፔሩቪያ ሶል),
			},
		},
		'PGK' => {
			display_name => {
				'currency' => q(የፓፕዋ ኒው ጊኒ ኪና),
			},
		},
		'PHP' => {
			symbol => 'PHP',
			display_name => {
				'currency' => q(የፊሊፒንስ ፔሶ),
			},
		},
		'PKR' => {
			display_name => {
				'currency' => q(የፓኪስታን ሩፒ),
			},
		},
		'PLN' => {
			display_name => {
				'currency' => q(የፖላንድ ዝሎቲ),
			},
		},
		'PYG' => {
			display_name => {
				'currency' => q(የፓራጓይ ጉአራኒ),
			},
		},
		'QAR' => {
			display_name => {
				'currency' => q(የኳታር ሪአል),
			},
		},
		'RON' => {
			display_name => {
				'currency' => q(የሮማኒያ ለው),
			},
		},
		'RSD' => {
			display_name => {
				'currency' => q(የሰርቢያ ዲናር),
			},
		},
		'RUB' => {
			display_name => {
				'currency' => q(የሩስያ ሩብል),
			},
		},
		'RWF' => {
			display_name => {
				'currency' => q(የሩዋንዳ ፍራንክ),
			},
		},
		'SAR' => {
			display_name => {
				'currency' => q(የሳውዲ ሪያል),
			},
		},
		'SBD' => {
			display_name => {
				'currency' => q(የሰለሞን ደሴቶች ዶላር),
			},
		},
		'SCR' => {
			display_name => {
				'currency' => q(የሲሼል ሩፒ),
			},
		},
		'SDG' => {
			display_name => {
				'currency' => q(የሱዳን ፓውንድ),
			},
		},
		'SDP' => {
			display_name => {
				'currency' => q(የሱዳን ፓውንድ \(1957–1998\)),
			},
		},
		'SEK' => {
			display_name => {
				'currency' => q(የስዊድን ክሮና),
			},
		},
		'SGD' => {
			display_name => {
				'currency' => q(የሲንጋፖር ዶላር),
			},
		},
		'SHP' => {
			display_name => {
				'currency' => q(የሴይንት ሔሌና ፓውንድ),
			},
		},
		'SLE' => {
			display_name => {
				'currency' => q(የሴራሊዎን ሊዎን),
			},
		},
		'SLL' => {
			display_name => {
				'currency' => q(የሴራሊዎን ሊዎን \(1964—2022\)),
			},
		},
		'SOS' => {
			display_name => {
				'currency' => q(የሶማሌ ሺሊንግ),
			},
		},
		'SRD' => {
			display_name => {
				'currency' => q(የሰርናሜዝ ዶላር),
			},
		},
		'SSP' => {
			display_name => {
				'currency' => q(የደቡብ ሱዳን ፓውንድ),
			},
		},
		'STD' => {
			display_name => {
				'currency' => q(የሳኦ ቶሜ እና ፕሪንሲፔ ዶብራ \(1977–2017\)),
			},
		},
		'STN' => {
			display_name => {
				'currency' => q(የሳኦ ቶሜ እና ፕሪንሲፔ ዶብራ),
			},
		},
		'SYP' => {
			display_name => {
				'currency' => q(የሲሪያ ፓውንድ),
			},
		},
		'SZL' => {
			display_name => {
				'currency' => q(የስዋዚላንድ ሊላንገኒ),
			},
		},
		'THB' => {
			symbol => '฿',
			display_name => {
				'currency' => q(የታይላንድ ባህት),
			},
		},
		'TJS' => {
			display_name => {
				'currency' => q(የታጂክስታን ሶሞኒ),
			},
		},
		'TMT' => {
			display_name => {
				'currency' => q(ቱርክሜኒስታኒ ማናት),
			},
		},
		'TND' => {
			display_name => {
				'currency' => q(የቱኒዚያ ዲናር),
			},
		},
		'TOP' => {
			display_name => {
				'currency' => q(ቶንጋን ፓ’አንጋ),
			},
		},
		'TRY' => {
			display_name => {
				'currency' => q(የቱርክ ሊራ),
			},
		},
		'TTD' => {
			display_name => {
				'currency' => q(የትሪንዳድ እና ቶቤጎዶላር),
			},
		},
		'TWD' => {
			symbol => 'NT$',
			display_name => {
				'currency' => q(የአዲሷ ታይዋን ዶላር),
			},
		},
		'TZS' => {
			display_name => {
				'currency' => q(የታንዛኒያ ሺሊንግ),
			},
		},
		'UAH' => {
			display_name => {
				'currency' => q(የዩክሬን ሀሪይቭኒአ),
			},
		},
		'UGX' => {
			display_name => {
				'currency' => q(የዩጋንዳ ሺሊንግ),
			},
		},
		'USD' => {
			display_name => {
				'currency' => q(የአሜሪካን ዶላር),
			},
		},
		'UYU' => {
			display_name => {
				'currency' => q(የኡራጓይ ፔሶ),
			},
		},
		'UZS' => {
			display_name => {
				'currency' => q(የኡዝፔኪስታን ሶም),
			},
		},
		'VEF' => {
			display_name => {
				'currency' => q(የቬንዝዌላ ቦሊቫር \(2008–2018\)),
			},
		},
		'VES' => {
			display_name => {
				'currency' => q(የቬንዝዌላ-ቦሊቫር),
			},
		},
		'VND' => {
			display_name => {
				'currency' => q(የቭየትናም ዶንግ),
			},
		},
		'VUV' => {
			display_name => {
				'currency' => q(የቫንዋንቱ ቫቱ),
			},
		},
		'WST' => {
			display_name => {
				'currency' => q(ሳሞአን ታላ),
			},
		},
		'XAF' => {
			display_name => {
				'currency' => q(የመካከለኛው አፍሪካ ሴፋ ፍራንክ),
			},
		},
		'XCD' => {
			display_name => {
				'currency' => q(የምዕራብ ካሪብያን ዶላር),
			},
		},
		'XOF' => {
			display_name => {
				'currency' => q(የምዕራብ አፍሪካ ሴፋ ፍራንክ),
			},
		},
		'XPF' => {
			display_name => {
				'currency' => q(ሲ ኤፍ ፒ ፍራንክ),
			},
		},
		'XXX' => {
			display_name => {
				'currency' => q(ያልታወቀ ገንዘብ),
			},
		},
		'YER' => {
			display_name => {
				'currency' => q(የየመን ሪአል),
			},
		},
		'ZAR' => {
			display_name => {
				'currency' => q(የደቡብ አፍሪካ ራንድ),
			},
		},
		'ZMK' => {
			display_name => {
				'currency' => q(የዛምቢያ ክዋቻ \(1968–2012\)),
			},
		},
		'ZMW' => {
			display_name => {
				'currency' => q(የዛምቢያ ክዋቻ),
			},
		},
		'ZWD' => {
			display_name => {
				'currency' => q(የዚምቧቡዌ ዶላር),
			},
		},
	} },
);


has 'calendar_months' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'ethiopic' => {
				'format' => {
					wide => {
						nonleap => [
							'መስከረም',
							'ጥቅምት',
							'ኅዳር',
							'ታኅሣሥ',
							'ጥር',
							'የካቲት',
							'መጋቢት',
							'ሚያዝያ',
							'ግንቦት',
							'ሰኔ',
							'ሐምሌ',
							'ነሐሴ',
							'ጳጉሜን'
						],
						leap => [
							
						],
					},
				},
			},
			'gregorian' => {
				'format' => {
					abbreviated => {
						nonleap => [
							'ጃን',
							'ፌብ',
							'ማርች',
							'ኤፕሪ',
							'ሜይ',
							'ጁን',
							'ጁላይ',
							'ኦገስ',
							'ሴፕቴ',
							'ኦክቶ',
							'ኖቬም',
							'ዲሴም'
						],
						leap => [
							
						],
					},
					wide => {
						nonleap => [
							'ጃንዋሪ',
							'ፌብሩዋሪ',
							'ማርች',
							'ኤፕሪል',
							'ሜይ',
							'ጁን',
							'ጁላይ',
							'ኦገስት',
							'ሴፕቴምበር',
							'ኦክቶበር',
							'ኖቬምበር',
							'ዲሴምበር'
						],
						leap => [
							
						],
					},
				},
				'stand-alone' => {
					narrow => {
						nonleap => [
							'ጃ',
							'ፌ',
							'ማ',
							'ኤ',
							'ሜ',
							'ጁ',
							'ጁ',
							'ኦ',
							'ሴ',
							'ኦ',
							'ኖ',
							'ዲ'
						],
						leap => [
							
						],
					},
				},
			},
			'islamic' => {
				'format' => {
					wide => {
						nonleap => [
							'ሙሀረም',
							'ሳፈር',
							'ረቢዑል አወል',
							'ረቢዑል አኺር',
							'ጀማደል አወል',
							'ጀማደል አኺር',
							'ረጀብ',
							'ሻእባን',
							'ረመዳን',
							'ሸዋል',
							'ዙልቂዳህ',
							'ዙልሂጃህ'
						],
						leap => [
							
						],
					},
				},
			},
	} },
);

has 'calendar_days' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {
						mon => 'ሰኞ',
						tue => 'ማክሰ',
						wed => 'ረቡዕ',
						thu => 'ሐሙስ',
						fri => 'ዓርብ',
						sat => 'ቅዳሜ',
						sun => 'እሑድ'
					},
					short => {
						mon => 'ሰ',
						tue => 'ማ',
						wed => 'ረ',
						thu => 'ሐ',
						fri => 'ዓ',
						sat => 'ቅ',
						sun => 'እ'
					},
					wide => {
						mon => 'ሰኞ',
						tue => 'ማክሰኞ',
						wed => 'ረቡዕ',
						thu => 'ሐሙስ',
						fri => 'ዓርብ',
						sat => 'ቅዳሜ',
						sun => 'እሑድ'
					},
				},
				'stand-alone' => {
					narrow => {
						mon => 'ሰ',
						tue => 'ማ',
						wed => 'ረ',
						thu => 'ሐ',
						fri => 'ዓ',
						sat => 'ቅ',
						sun => 'እ'
					},
				},
			},
	} },
);

has 'calendar_quarters' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
			'gregorian' => {
				'format' => {
					abbreviated => {0 => 'ሩብ1',
						1 => 'ሩብ2',
						2 => 'ሩብ3',
						3 => 'ሩብ4'
					},
					wide => {0 => '1ኛው ሩብ',
						1 => '2ኛው ሩብ',
						2 => '3ኛው ሩብ',
						3 => '4ኛው ሩብ'
					},
				},
			},
	} },
);

has 'day_period_data' => (
	is			=> 'ro',
	isa			=> CodeRef,
	init_arg	=> undef,
	default		=> sub { sub {
		# Time in hhmm format
		my ($self, $type, $time, $day_period_type) = @_;
		$day_period_type //= 'default';
		SWITCH:
		for ($type) {
			if ($_ eq 'buddhist') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'coptic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'ethiopic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'generic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'gregorian') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				last SWITCH;
				}
			if ($_ eq 'islamic') {
				if($day_period_type eq 'default') {
					return 'midnight' if $time == 0;
					return 'noon' if $time == 1200;
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				if($day_period_type eq 'selection') {
					return 'afternoon1' if $time >= 1200
						&& $time < 1800;
					return 'evening1' if $time >= 1800
						&& $time < 2400;
					return 'morning1' if $time >= 600
						&& $time < 1200;
					return 'night1' if $time >= 0
						&& $time < 600;
				}
				last SWITCH;
				}
		}
	} },
);

around day_period_data => sub {
    my ($orig, $self) = @_;
    return $self->$orig;
};

has 'day_periods' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'gregorian' => {
			'format' => {
				'abbreviated' => {
					'afternoon1' => q{ከሰዓት},
					'am' => q{ጥዋት},
					'evening1' => q{በምሽት},
					'midnight' => q{እኩለ ሌሊት},
					'morning1' => q{ጥዋት},
					'night1' => q{በሌሊት},
					'noon' => q{ቀትር},
					'pm' => q{ከሰዓት},
				},
				'narrow' => {
					'afternoon1' => q{ከሰዓት},
					'am' => q{ጠ},
					'evening1' => q{በምሽት},
					'midnight' => q{እኩለ ሌሊት},
					'morning1' => q{ጥዋት},
					'night1' => q{በሌሊት},
					'noon' => q{ቀ},
					'pm' => q{ከ},
				},
			},
			'stand-alone' => {
				'abbreviated' => {
					'afternoon1' => q{ከሰዓት በኋላ},
					'evening1' => q{ምሽት},
					'morning1' => q{ጥዋት},
					'night1' => q{ሌሊት},
				},
				'narrow' => {
					'afternoon1' => q{ከሰዓት በኋላ},
					'am' => q{ጠ},
					'evening1' => q{ማታ},
					'morning1' => q{ጥዋት},
					'night1' => q{ሌሊት},
					'pm' => q{ከ},
				},
			},
		},
	} },
);

has 'eras' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
			abbreviated => {
				'0' => 'ዓ/ዓ',
				'1' => 'ዓ/ም'
			},
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			abbreviated => {
				'0' => 'ዓ/ዓ',
				'1' => 'ዓ/ም'
			},
			wide => {
				'0' => 'ዓመተ ዓለም',
				'1' => 'ዓመተ ምሕረት'
			},
		},
		'islamic' => {
		},
	} },
);

has 'date_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{EEEE፣ d MMMM y G},
			'long' => q{d MMMM y G},
			'medium' => q{d MMM y G},
			'short' => q{dd/MM/y GGGGG},
		},
		'gregorian' => {
			'full' => q{y MMMM d, EEEE},
			'long' => q{d MMMM y},
			'medium' => q{d MMM y},
			'short' => q{dd/MM/y},
		},
		'islamic' => {
		},
	} },
);

has 'time_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
		},
		'gregorian' => {
			'full' => q{h:mm:ss a zzzz},
			'long' => q{h:mm:ss a z},
			'medium' => q{h:mm:ss a},
			'short' => q{h:mm a},
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
		},
		'coptic' => {
		},
		'ethiopic' => {
		},
		'generic' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'gregorian' => {
			'full' => q{{1} {0}},
			'long' => q{{1} {0}},
			'medium' => q{{1} {0}},
			'short' => q{{1} {0}},
		},
		'islamic' => {
		},
	} },
);

has 'datetime_formats_available_formats' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'buddhist' => {
			GyMMM => q{MMM፣ y G},
		},
		'ethiopic' => {
			GyMMM => q{MMM፣ y G},
			MMMMEd => q{E, MMMM d},
		},
		'generic' => {
			Ed => q{E d},
			Gy => q{y G},
			GyMMMEd => q{E MMM d፣ y G},
			GyMMMd => q{MMM d፣ y G},
			GyMd => q{M/d/y GGGGG},
			H => q{H},
			MEd => q{E፣ M/d},
			MMMEd => q{E፣ MMM d},
			MMMMEd => q{E፣ MMMM d},
			Md => q{M/d},
			y => q{y},
			yM => q{M/y},
			yMEd => q{E፣ d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E፣ MMM d y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
			yyyyMMMM => q{MMMM y G},
		},
		'gregorian' => {
			Ed => q{E d},
			Gy => q{y G},
			GyMMM => q{MMM y G},
			GyMd => q{M/d/y GGGGG},
			H => q{H},
			MEd => q{E፣ M/d},
			MMMEd => q{E፣ MMM d},
			MMMMEd => q{E፣ MMMM d},
			MMMMW => q{ሳምንት W የ MMMM},
			Md => q{M/d},
			yM => q{M/y},
			yMEd => q{E፣ d/M/y},
			yMMM => q{MMM y},
			yMMMEd => q{E፣ MMM d y},
			yMMMM => q{MMMM y},
			yMMMd => q{d MMM y},
			yMd => q{d/M/y},
			yQQQ => q{QQQ y},
			yQQQQ => q{QQQQ y},
		},
	} },
);

has 'datetime_formats_append_item' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
	} },
);

has 'datetime_formats_interval' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default		=> sub { {
		'generic' => {
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E፣ d/M – E፣ d/M},
				d => q{E d/M – E d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				M => q{E፣ MMM d – E፣ MMM d},
				d => q{E d – E d፣ MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d–d/M},
			},
			fallback => '{0} – {1}',
			h => {
				h => q{h – h a},
			},
			hm => {
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				h => q{h – h a v},
			},
			y => {
				y => q{y–y},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E d/M/ – E d/M፣ y},
				d => q{E፣ d/M/y – E፣ d/M/y},
				y => q{E፣ d/M/y – E፣ d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM፣ y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E MMM d – E MMM d፣ y},
				d => q{E MMM d – E MMM d፣ y},
				y => q{E፣ MMM d፣ y – E፣ MMM d፣ y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{MMM d – MMM d፣ y},
				d => q{MMM d–d፣ y},
				y => q{MMM d፣ y – MMM d፣ y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
		'gregorian' => {
			GyM => {
				G => q{GGGGG M/y – GGGGG M/y},
				M => q{GGGGG M/y – M/y},
				y => q{GGGGG M/y – M/y},
			},
			GyMMM => {
				G => q{G MMM y – G MMM y},
				M => q{G MMM–MMM፣ y},
				y => q{G MMM y – MMM y},
			},
			GyMMMEd => {
				G => q{G E፣ MMM d፣ y – G E፣ MMM d፣ y},
				M => q{G E MMM d፣ y – E MMM d},
				d => q{G E MMM d – E MMM d፣ y},
				y => q{G E፣ MMM d፣ y – E፣ MMM d፣ y},
			},
			GyMMMd => {
				G => q{G MMM d፣ y – G MMM d፣ y},
				M => q{G MMM d – MMM d፣ y},
				d => q{G MMM d–d፣ y},
				y => q{G MMM d፣ y – MMM d፣ y},
			},
			GyMd => {
				G => q{GGGGG d/M/y – GGGGG d/M/y},
				M => q{GGGGG d/M/y – d/M/y},
				d => q{GGGGG d/M/y – d/M/y},
				y => q{GGGGG d/M/y – d/M/y},
			},
			M => {
				M => q{M–M},
			},
			MEd => {
				M => q{E፣ d/M – E፣ d/M},
				d => q{E d/M – E d/M},
			},
			MMM => {
				M => q{MMM–MMM},
			},
			MMMEd => {
				d => q{E d – E d፣ MMM},
			},
			Md => {
				M => q{d/M – d/M},
				d => q{d–d/M},
			},
			fallback => '{0} – {1}',
			h => {
				h => q{h – h a},
			},
			hm => {
				h => q{h:mm – h:mm a},
				m => q{h:mm – h:mm a},
			},
			hmv => {
				h => q{h:mm – h:mm a v},
				m => q{h:mm – h:mm a v},
			},
			hv => {
				h => q{h – h a v},
			},
			yM => {
				M => q{M/y – M/y},
				y => q{M/y – M/y},
			},
			yMEd => {
				M => q{E d/M/ – E d/M፣ y},
				y => q{E፣ d/M/y – E፣ d/M/y},
			},
			yMMM => {
				M => q{MMM–MMM፣ y},
				y => q{MMM y – MMM y},
			},
			yMMMEd => {
				M => q{E MMM d – E MMM d፣ y},
				d => q{E MMM d – E MMM d፣ y},
				y => q{E፣ MMM d፣ y – E፣ MMM d፣ y},
			},
			yMMMM => {
				M => q{MMMM–MMMM y},
				y => q{MMMM y – MMMM y},
			},
			yMMMd => {
				M => q{MMM d – MMM d፣ y},
				d => q{MMM d–d፣ y},
				y => q{MMM d፣ y – MMM d፣ y},
			},
			yMd => {
				M => q{d/M/y – d/M/y},
				d => q{d/M/y – d/M/y},
				y => q{d/M/y – d/M/y},
			},
		},
	} },
);

has 'time_zone_names' => (
	is			=> 'ro',
	isa			=> HashRef,
	init_arg	=> undef,
	default	=> sub { {
		hourFormat => q(+HHmm;-HHmm),
		gmtFormat => q(ጂ ኤም ቲ{0}),
		gmtZeroFormat => q(ጂ ኤም ቲ),
		regionFormat => q({0} ጊዜ),
		regionFormat => q({0} የቀን ብርሃን ሰዓት),
		regionFormat => q({0} መደበኛ ሰዓት),
		'Afghanistan' => {
			long => {
				'standard' => q#የአፍጋኒስታን ሰዓት#,
			},
		},
		'Africa/Abidjan' => {
			exemplarCity => q#አቢጃን#,
		},
		'Africa/Accra' => {
			exemplarCity => q#አክራ#,
		},
		'Africa/Addis_Ababa' => {
			exemplarCity => q#አዲስ አበባ#,
		},
		'Africa/Algiers' => {
			exemplarCity => q#አልጀርስ#,
		},
		'Africa/Asmera' => {
			exemplarCity => q#አስመራ#,
		},
		'Africa/Bamako' => {
			exemplarCity => q#ባማኮ#,
		},
		'Africa/Bangui' => {
			exemplarCity => q#ባንጉኢ#,
		},
		'Africa/Banjul' => {
			exemplarCity => q#ባንጁል#,
		},
		'Africa/Bissau' => {
			exemplarCity => q#ቢሳኦ#,
		},
		'Africa/Blantyre' => {
			exemplarCity => q#ብላንታየር#,
		},
		'Africa/Brazzaville' => {
			exemplarCity => q#ብራዛቪል#,
		},
		'Africa/Bujumbura' => {
			exemplarCity => q#ቡጁምብራ#,
		},
		'Africa/Cairo' => {
			exemplarCity => q#ካይሮ#,
		},
		'Africa/Casablanca' => {
			exemplarCity => q#ካዛብላንካ#,
		},
		'Africa/Ceuta' => {
			exemplarCity => q#ሲኡታ#,
		},
		'Africa/Conakry' => {
			exemplarCity => q#ኮናክሬ#,
		},
		'Africa/Dakar' => {
			exemplarCity => q#ዳካር#,
		},
		'Africa/Dar_es_Salaam' => {
			exemplarCity => q#ዳሬ ሰላም#,
		},
		'Africa/Djibouti' => {
			exemplarCity => q#ጅቡቲ#,
		},
		'Africa/Douala' => {
			exemplarCity => q#ዱአላ#,
		},
		'Africa/El_Aaiun' => {
			exemplarCity => q#ኤል አዩአን#,
		},
		'Africa/Freetown' => {
			exemplarCity => q#ፍሪታውን#,
		},
		'Africa/Gaborone' => {
			exemplarCity => q#ጋቦሮን#,
		},
		'Africa/Harare' => {
			exemplarCity => q#ሃራሬ#,
		},
		'Africa/Johannesburg' => {
			exemplarCity => q#ጆሃንስበርግ#,
		},
		'Africa/Juba' => {
			exemplarCity => q#ጁባ#,
		},
		'Africa/Kampala' => {
			exemplarCity => q#ካምፓላ#,
		},
		'Africa/Khartoum' => {
			exemplarCity => q#ካርቱም#,
		},
		'Africa/Kigali' => {
			exemplarCity => q#ኪጋሊ#,
		},
		'Africa/Kinshasa' => {
			exemplarCity => q#ኪንሻሳ#,
		},
		'Africa/Lagos' => {
			exemplarCity => q#ሌጎስ#,
		},
		'Africa/Libreville' => {
			exemplarCity => q#ሊበርቪል#,
		},
		'Africa/Lome' => {
			exemplarCity => q#ሎሜ#,
		},
		'Africa/Luanda' => {
			exemplarCity => q#ሉአንዳ#,
		},
		'Africa/Lubumbashi' => {
			exemplarCity => q#ሉቡምባሺ#,
		},
		'Africa/Lusaka' => {
			exemplarCity => q#ሉሳካ#,
		},
		'Africa/Malabo' => {
			exemplarCity => q#ማላቡ#,
		},
		'Africa/Maputo' => {
			exemplarCity => q#ማፑቱ#,
		},
		'Africa/Maseru' => {
			exemplarCity => q#ማሴሩ#,
		},
		'Africa/Mbabane' => {
			exemplarCity => q#ምባባኔ#,
		},
		'Africa/Mogadishu' => {
			exemplarCity => q#ሞቃዲሹ#,
		},
		'Africa/Monrovia' => {
			exemplarCity => q#ሞንሮቪያ#,
		},
		'Africa/Nairobi' => {
			exemplarCity => q#ናይሮቢ#,
		},
		'Africa/Ndjamena' => {
			exemplarCity => q#ንጃሜና#,
		},
		'Africa/Niamey' => {
			exemplarCity => q#ኒያሜይ#,
		},
		'Africa/Nouakchott' => {
			exemplarCity => q#ኑአክቾት#,
		},
		'Africa/Ouagadougou' => {
			exemplarCity => q#ኡጋዱጉ#,
		},
		'Africa/Porto-Novo' => {
			exemplarCity => q#ፖርቶ - ኖቮ#,
		},
		'Africa/Sao_Tome' => {
			exemplarCity => q#ሳኦ ቶሜ#,
		},
		'Africa/Tripoli' => {
			exemplarCity => q#ትሪፖሊ#,
		},
		'Africa/Tunis' => {
			exemplarCity => q#ቱኒዝ#,
		},
		'Africa/Windhoek' => {
			exemplarCity => q#ዊንድሆክ#,
		},
		'Africa_Central' => {
			long => {
				'standard' => q#የመካከለኛው አፍሪካ ሰዓት#,
			},
		},
		'Africa_Eastern' => {
			long => {
				'standard' => q#የምስራቅ አፍሪካ ሰዓት#,
			},
		},
		'Africa_Southern' => {
			long => {
				'standard' => q#የደቡብ አፍሪካ መደበኛ ሰዓት#,
			},
		},
		'Africa_Western' => {
			long => {
				'daylight' => q#የምዕራብ አፍሪካ ክረምት ሰዓት#,
				'generic' => q#የምዕራብ አፍሪካ ሰዓት#,
				'standard' => q#የምዕራብ አፍሪካ መደበኛ ሰዓት#,
			},
		},
		'Alaska' => {
			long => {
				'daylight' => q#የአላስካ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የአላስካ ሰዓት አቆጣጠር#,
				'standard' => q#የአላስካ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Amazon' => {
			long => {
				'daylight' => q#የአማዞን የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የአማዞን ሰዓት አቆጣጠር#,
				'standard' => q#የአማዞን መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'America/Adak' => {
			exemplarCity => q#አዳክ#,
		},
		'America/Anchorage' => {
			exemplarCity => q#አንኮራጅ#,
		},
		'America/Anguilla' => {
			exemplarCity => q#አንጉይላ#,
		},
		'America/Antigua' => {
			exemplarCity => q#አንቲጓ#,
		},
		'America/Araguaina' => {
			exemplarCity => q#አራጉየና#,
		},
		'America/Argentina/La_Rioja' => {
			exemplarCity => q#ላ ሪኦጃ#,
		},
		'America/Argentina/Rio_Gallegos' => {
			exemplarCity => q#ሪዮ ጋሌጎስ#,
		},
		'America/Argentina/Salta' => {
			exemplarCity => q#ሳልታ#,
		},
		'America/Argentina/San_Juan' => {
			exemplarCity => q#ሳን ጁአን#,
		},
		'America/Argentina/San_Luis' => {
			exemplarCity => q#ሳን ሊውስ#,
		},
		'America/Argentina/Tucuman' => {
			exemplarCity => q#ቱኩማን#,
		},
		'America/Argentina/Ushuaia' => {
			exemplarCity => q#ኡሹአኢ#,
		},
		'America/Aruba' => {
			exemplarCity => q#አሩባ#,
		},
		'America/Asuncion' => {
			exemplarCity => q#አሱንሲዮን#,
		},
		'America/Bahia' => {
			exemplarCity => q#ባሂአ#,
		},
		'America/Bahia_Banderas' => {
			exemplarCity => q#ባሂያ ባንደራስ#,
		},
		'America/Barbados' => {
			exemplarCity => q#ባርቤዶስ#,
		},
		'America/Belem' => {
			exemplarCity => q#ቤለም#,
		},
		'America/Belize' => {
			exemplarCity => q#ቤሊዝ#,
		},
		'America/Blanc-Sablon' => {
			exemplarCity => q#ብላንክ- ሳብሎን#,
		},
		'America/Boa_Vista' => {
			exemplarCity => q#ቦአ ቪስታ#,
		},
		'America/Bogota' => {
			exemplarCity => q#ቦጎታ#,
		},
		'America/Boise' => {
			exemplarCity => q#ቦይዝ#,
		},
		'America/Buenos_Aires' => {
			exemplarCity => q#ቦነስ አይረስ#,
		},
		'America/Cambridge_Bay' => {
			exemplarCity => q#ካምብሪጅ ቤይ#,
		},
		'America/Campo_Grande' => {
			exemplarCity => q#ካምፖ ግራንዴ#,
		},
		'America/Cancun' => {
			exemplarCity => q#ካንኩን#,
		},
		'America/Caracas' => {
			exemplarCity => q#ካራካስ#,
		},
		'America/Catamarca' => {
			exemplarCity => q#ካታማርካ#,
		},
		'America/Cayenne' => {
			exemplarCity => q#ካይንኤ#,
		},
		'America/Cayman' => {
			exemplarCity => q#ካይማን#,
		},
		'America/Chicago' => {
			exemplarCity => q#ቺካጎ#,
		},
		'America/Chihuahua' => {
			exemplarCity => q#ቺሁዋውአ#,
		},
		'America/Ciudad_Juarez' => {
			exemplarCity => q#ሳዮዳድ ሁዋሬዝ#,
		},
		'America/Coral_Harbour' => {
			exemplarCity => q#አቲኮካን#,
		},
		'America/Cordoba' => {
			exemplarCity => q#ኮርዶባ#,
		},
		'America/Costa_Rica' => {
			exemplarCity => q#ኮስታሪካ#,
		},
		'America/Creston' => {
			exemplarCity => q#ክረስተን#,
		},
		'America/Cuiaba' => {
			exemplarCity => q#ኩየአባ#,
		},
		'America/Curacao' => {
			exemplarCity => q#ኩራሳዎ#,
		},
		'America/Danmarkshavn' => {
			exemplarCity => q#ዳንማርክሻቭን#,
		},
		'America/Dawson' => {
			exemplarCity => q#ዳውሰን#,
		},
		'America/Dawson_Creek' => {
			exemplarCity => q#ዳውሰን ክሬክ#,
		},
		'America/Denver' => {
			exemplarCity => q#ዴንቨር#,
		},
		'America/Detroit' => {
			exemplarCity => q#ዲትሮይት#,
		},
		'America/Dominica' => {
			exemplarCity => q#ዶሜኒካ#,
		},
		'America/Edmonton' => {
			exemplarCity => q#ኤድመንተን#,
		},
		'America/Eirunepe' => {
			exemplarCity => q#ኢሩኔፕ#,
		},
		'America/El_Salvador' => {
			exemplarCity => q#ኤልሳልቫዶር#,
		},
		'America/Fort_Nelson' => {
			exemplarCity => q#ፎርት ኔልሰን#,
		},
		'America/Fortaleza' => {
			exemplarCity => q#ፎርታሌዛ#,
		},
		'America/Glace_Bay' => {
			exemplarCity => q#ግሌስ ቤይ#,
		},
		'America/Godthab' => {
			exemplarCity => q#ጋድታብ#,
		},
		'America/Goose_Bay' => {
			exemplarCity => q#ጉዝ ቤይ#,
		},
		'America/Grand_Turk' => {
			exemplarCity => q#ግራንድ ተርክ#,
		},
		'America/Grenada' => {
			exemplarCity => q#ግሬናዳ#,
		},
		'America/Guadeloupe' => {
			exemplarCity => q#ጕዳሉፕ#,
		},
		'America/Guatemala' => {
			exemplarCity => q#ጓቲማላ#,
		},
		'America/Guayaquil' => {
			exemplarCity => q#ጉያኩይል#,
		},
		'America/Guyana' => {
			exemplarCity => q#ጉያና#,
		},
		'America/Halifax' => {
			exemplarCity => q#ሃሊፋክስ#,
		},
		'America/Havana' => {
			exemplarCity => q#ሃቫና#,
		},
		'America/Hermosillo' => {
			exemplarCity => q#ኸርሞዚሎ#,
		},
		'America/Indiana/Knox' => {
			exemplarCity => q#ኖክስ, ኢንዲያና#,
		},
		'America/Indiana/Marengo' => {
			exemplarCity => q#ማሬንጎ, ኢንዲያና#,
		},
		'America/Indiana/Petersburg' => {
			exemplarCity => q#ፒተርስበርግ, ኢንዲያና#,
		},
		'America/Indiana/Tell_City' => {
			exemplarCity => q#ቴል ከተማ, ኢንዲያና#,
		},
		'America/Indiana/Vevay' => {
			exemplarCity => q#ቪቫይ, ኢንዲያና#,
		},
		'America/Indiana/Vincennes' => {
			exemplarCity => q#ቪንቼንስ, ኢንዲያና#,
		},
		'America/Indiana/Winamac' => {
			exemplarCity => q#ዊናማክ, ኢንዲያና#,
		},
		'America/Indianapolis' => {
			exemplarCity => q#ኢንዲያናፖሊስ#,
		},
		'America/Inuvik' => {
			exemplarCity => q#ኢኑቪክ#,
		},
		'America/Iqaluit' => {
			exemplarCity => q#ኢኳሊውት#,
		},
		'America/Jamaica' => {
			exemplarCity => q#ጃማይካ#,
		},
		'America/Jujuy' => {
			exemplarCity => q#ጁጁይ#,
		},
		'America/Juneau' => {
			exemplarCity => q#ጁኒዩ#,
		},
		'America/Kentucky/Monticello' => {
			exemplarCity => q#ሞንቲሴሎ, ኪንታኪ#,
		},
		'America/Kralendijk' => {
			exemplarCity => q#ክራለንዲይክ#,
		},
		'America/La_Paz' => {
			exemplarCity => q#ላ ፓዝ#,
		},
		'America/Lima' => {
			exemplarCity => q#ሊማ#,
		},
		'America/Los_Angeles' => {
			exemplarCity => q#ሎስ አንጀለስ#,
		},
		'America/Louisville' => {
			exemplarCity => q#ሊውስቪል#,
		},
		'America/Lower_Princes' => {
			exemplarCity => q#የታችኛው ልዑል ሩብ#,
		},
		'America/Maceio' => {
			exemplarCity => q#ሜሲኦ#,
		},
		'America/Managua' => {
			exemplarCity => q#ማናጉአ#,
		},
		'America/Manaus' => {
			exemplarCity => q#ማናኡስ#,
		},
		'America/Marigot' => {
			exemplarCity => q#ማርጎት#,
		},
		'America/Martinique' => {
			exemplarCity => q#ማርቲኒክ#,
		},
		'America/Matamoros' => {
			exemplarCity => q#ማታሞሮስ#,
		},
		'America/Mazatlan' => {
			exemplarCity => q#ማዛትላን#,
		},
		'America/Mendoza' => {
			exemplarCity => q#ሜንዶዛ#,
		},
		'America/Menominee' => {
			exemplarCity => q#ሜኖሚኒ#,
		},
		'America/Merida' => {
			exemplarCity => q#ሜሪዳ#,
		},
		'America/Metlakatla' => {
			exemplarCity => q#መትላካትላ#,
		},
		'America/Mexico_City' => {
			exemplarCity => q#ሜክሲኮ ከተማ#,
		},
		'America/Miquelon' => {
			exemplarCity => q#ሚኮውሎን#,
		},
		'America/Moncton' => {
			exemplarCity => q#ሞንክቶን#,
		},
		'America/Monterrey' => {
			exemplarCity => q#ሞንተርሬይ#,
		},
		'America/Montevideo' => {
			exemplarCity => q#ሞንቴቪድዮ#,
		},
		'America/Montserrat' => {
			exemplarCity => q#ሞንትሴራት#,
		},
		'America/Nassau' => {
			exemplarCity => q#ናሳው#,
		},
		'America/New_York' => {
			exemplarCity => q#ኒውዮርክ#,
		},
		'America/Nipigon' => {
			exemplarCity => q#ኒፒጎን#,
		},
		'America/Nome' => {
			exemplarCity => q#ኖሜ#,
		},
		'America/Noronha' => {
			exemplarCity => q#ኖሮኛ#,
		},
		'America/North_Dakota/Beulah' => {
			exemplarCity => q#ቤኡላህ, ሰሜን ዳኮታ#,
		},
		'America/North_Dakota/Center' => {
			exemplarCity => q#መካከለኛ, ሰሜን ዳኮታ#,
		},
		'America/North_Dakota/New_Salem' => {
			exemplarCity => q#አዲስ ሳሌም, ሰሜን ዳኮታ#,
		},
		'America/Ojinaga' => {
			exemplarCity => q#ኦዪናጋ#,
		},
		'America/Panama' => {
			exemplarCity => q#ፓናማ#,
		},
		'America/Pangnirtung' => {
			exemplarCity => q#ፓንግኒርተንግ#,
		},
		'America/Paramaribo' => {
			exemplarCity => q#ፓራማሪቦ#,
		},
		'America/Phoenix' => {
			exemplarCity => q#ፊኒክስ#,
		},
		'America/Port-au-Prince' => {
			exemplarCity => q#ፖርት ኦ ፕሪንስ#,
		},
		'America/Port_of_Spain' => {
			exemplarCity => q#የእስፔን ወደብ#,
		},
		'America/Porto_Velho' => {
			exemplarCity => q#ፔትሮ ቬልሆ#,
		},
		'America/Puerto_Rico' => {
			exemplarCity => q#ፖርቶሪኮ#,
		},
		'America/Punta_Arenas' => {
			exemplarCity => q#ፑንታ አሬናስ#,
		},
		'America/Rainy_River' => {
			exemplarCity => q#ሬኒ ሪቨር#,
		},
		'America/Rankin_Inlet' => {
			exemplarCity => q#ራንኪን ኢንሌት#,
		},
		'America/Recife' => {
			exemplarCity => q#ረሲፍ#,
		},
		'America/Regina' => {
			exemplarCity => q#ረጂና#,
		},
		'America/Resolute' => {
			exemplarCity => q#ሪዞሊዩት#,
		},
		'America/Rio_Branco' => {
			exemplarCity => q#ሪዮ ብራንኮ#,
		},
		'America/Santa_Isabel' => {
			exemplarCity => q#ሳንታ ኢዛቤል#,
		},
		'America/Santarem' => {
			exemplarCity => q#ሳንታሬም#,
		},
		'America/Santiago' => {
			exemplarCity => q#ሳንቲያጎ#,
		},
		'America/Santo_Domingo' => {
			exemplarCity => q#ሳንቶ ዶሚንጎ#,
		},
		'America/Sao_Paulo' => {
			exemplarCity => q#ሳኦ ፖሎ#,
		},
		'America/Scoresbysund' => {
			exemplarCity => q#ስኮርስባይሰንድ#,
		},
		'America/Sitka' => {
			exemplarCity => q#ሲትካ#,
		},
		'America/St_Barthelemy' => {
			exemplarCity => q#ቅድስት ቤርተሎሜ#,
		},
		'America/St_Johns' => {
			exemplarCity => q#ቅዱስ ዮሐንስ#,
		},
		'America/St_Kitts' => {
			exemplarCity => q#ቅዱስ ኪትስ#,
		},
		'America/St_Lucia' => {
			exemplarCity => q#ቅድስት ሉሲያ#,
		},
		'America/St_Thomas' => {
			exemplarCity => q#ቅዱስ ቶማስ#,
		},
		'America/St_Vincent' => {
			exemplarCity => q#ቅዱስ ቪንሰንት#,
		},
		'America/Swift_Current' => {
			exemplarCity => q#የሐዋላ ገንዘብ#,
		},
		'America/Tegucigalpa' => {
			exemplarCity => q#ቴጉሲጋልፓ#,
		},
		'America/Thule' => {
			exemplarCity => q#ቱሌ#,
		},
		'America/Thunder_Bay' => {
			exemplarCity => q#ተንደር ቤይ#,
		},
		'America/Tijuana' => {
			exemplarCity => q#ቲጁአና#,
		},
		'America/Toronto' => {
			exemplarCity => q#ቶሮንቶ#,
		},
		'America/Tortola' => {
			exemplarCity => q#ቶርቶላ#,
		},
		'America/Vancouver' => {
			exemplarCity => q#ቫንኮቨር#,
		},
		'America/Whitehorse' => {
			exemplarCity => q#ኋይትሆርስ#,
		},
		'America/Winnipeg' => {
			exemplarCity => q#ዊኒፔግ#,
		},
		'America/Yakutat' => {
			exemplarCity => q#ያኩታት#,
		},
		'America/Yellowknife' => {
			exemplarCity => q#የሎውናይፍ#,
		},
		'America_Central' => {
			long => {
				'daylight' => q#የመካከለኛ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የሰሜን አሜሪካ የመካከለኛ ሰዓት አቆጣጠር#,
				'standard' => q#የሰሜን አሜሪካ የመካከለኛ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'America_Eastern' => {
			long => {
				'daylight' => q#ምስራቃዊ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#ምስራቃዊ ሰዓት አቆጣጠር#,
				'standard' => q#ምስራቃዊ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'America_Mountain' => {
			long => {
				'daylight' => q#የተራራ የቀንሰዓት አቆጣጠር#,
				'generic' => q#የተራራ የሰዓት አቆጣጠር#,
				'standard' => q#የተራራ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'America_Pacific' => {
			long => {
				'daylight' => q#የፓስፊክ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የፓስፊክ ሰዓት አቆጣጠር#,
				'standard' => q#የፓስፊክ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Anadyr' => {
			long => {
				'daylight' => q#የአናድይር የበጋ የሰዓት አቆጣጠር#,
				'generic' => q#የአናድይር ሰዓት አቆጣጠር#,
				'standard' => q#የአናዲይር ሰዓት አቆጣጠር#,
			},
		},
		'Antarctica/Casey' => {
			exemplarCity => q#ካዚይ#,
		},
		'Antarctica/Davis' => {
			exemplarCity => q#ዳቪስ#,
		},
		'Antarctica/DumontDUrville' => {
			exemplarCity => q#ደሞንት ዲኡርቪል#,
		},
		'Antarctica/Macquarie' => {
			exemplarCity => q#ማከሪ#,
		},
		'Antarctica/Mawson' => {
			exemplarCity => q#ናውሰን#,
		},
		'Antarctica/McMurdo' => {
			exemplarCity => q#ማክመርዶ#,
		},
		'Antarctica/Palmer' => {
			exemplarCity => q#ፓልመር#,
		},
		'Antarctica/Rothera' => {
			exemplarCity => q#ሮቴራ#,
		},
		'Antarctica/Syowa' => {
			exemplarCity => q#ስዮዋ#,
		},
		'Antarctica/Troll' => {
			exemplarCity => q#ትሮል#,
		},
		'Antarctica/Vostok' => {
			exemplarCity => q#ቭስቶክ#,
		},
		'Apia' => {
			long => {
				'daylight' => q#የአፒያ የቀን ጊዜ ሰዓት#,
				'generic' => q#የአፒያ ሰዓት#,
				'standard' => q#የአፒያ መደበኛ ሰዓት#,
			},
		},
		'Arabian' => {
			long => {
				'daylight' => q#የዓረቢያ የቀን ብርሃን ሰዓት#,
				'generic' => q#የዓረቢያ ሰዓት#,
				'standard' => q#የዓረቢያ መደበኛ ሰዓት#,
			},
		},
		'Arctic/Longyearbyen' => {
			exemplarCity => q#ሎንግይርባየን#,
		},
		'Argentina' => {
			long => {
				'daylight' => q#የአርጀንቲና የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የአርጀንቲና የሰዓት አቆጣጠር#,
				'standard' => q#የአርጀንቲና መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Argentina_Western' => {
			long => {
				'daylight' => q#የምዕራባዊ አርጀንቲና የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የአርጀንቲና ምስራቃዊ ሰዓት አቆጣጠር#,
				'standard' => q#የምዕራባዊ አርጀንቲና መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Armenia' => {
			long => {
				'daylight' => q#የአርመኒያ ክረምት ሰዓት#,
				'generic' => q#የአርመኒያ ሰዓት#,
				'standard' => q#የአርመኒያ መደበኛ ሰዓት#,
			},
		},
		'Asia/Aden' => {
			exemplarCity => q#ኤደን#,
		},
		'Asia/Almaty' => {
			exemplarCity => q#አልማትይ#,
		},
		'Asia/Amman' => {
			exemplarCity => q#አማን#,
		},
		'Asia/Anadyr' => {
			exemplarCity => q#አናድይር#,
		},
		'Asia/Aqtau' => {
			exemplarCity => q#አኩታኡ#,
		},
		'Asia/Aqtobe' => {
			exemplarCity => q#አኩቶቤ#,
		},
		'Asia/Ashgabat' => {
			exemplarCity => q#አሽጋባት#,
		},
		'Asia/Atyrau' => {
			exemplarCity => q#አትይራኡ#,
		},
		'Asia/Baghdad' => {
			exemplarCity => q#ባግዳድ#,
		},
		'Asia/Bahrain' => {
			exemplarCity => q#ባህሬን#,
		},
		'Asia/Baku' => {
			exemplarCity => q#ባኩ#,
		},
		'Asia/Bangkok' => {
			exemplarCity => q#ባንኮክ#,
		},
		'Asia/Barnaul' => {
			exemplarCity => q#ባርናኡል#,
		},
		'Asia/Beirut' => {
			exemplarCity => q#ቤሩት#,
		},
		'Asia/Bishkek' => {
			exemplarCity => q#ቢሽኬክ#,
		},
		'Asia/Brunei' => {
			exemplarCity => q#ብሩናይ#,
		},
		'Asia/Calcutta' => {
			exemplarCity => q#ኮልካታ#,
		},
		'Asia/Chita' => {
			exemplarCity => q#ቺታ#,
		},
		'Asia/Choibalsan' => {
			exemplarCity => q#ቾይባልሳን#,
		},
		'Asia/Colombo' => {
			exemplarCity => q#ኮሎምቦ#,
		},
		'Asia/Damascus' => {
			exemplarCity => q#ደማስቆ#,
		},
		'Asia/Dhaka' => {
			exemplarCity => q#ዳካ#,
		},
		'Asia/Dili' => {
			exemplarCity => q#ዲሊ#,
		},
		'Asia/Dubai' => {
			exemplarCity => q#ዱባይ#,
		},
		'Asia/Dushanbe' => {
			exemplarCity => q#ደሻንቤ#,
		},
		'Asia/Famagusta' => {
			exemplarCity => q#ፋማጉስታ#,
		},
		'Asia/Gaza' => {
			exemplarCity => q#ጋዛ#,
		},
		'Asia/Hebron' => {
			exemplarCity => q#ኬብሮን#,
		},
		'Asia/Hong_Kong' => {
			exemplarCity => q#ሆንግ ኮንግ#,
		},
		'Asia/Hovd' => {
			exemplarCity => q#ሆቭድ#,
		},
		'Asia/Irkutsk' => {
			exemplarCity => q#ኢርኩትስክ#,
		},
		'Asia/Jakarta' => {
			exemplarCity => q#ጃካርታ#,
		},
		'Asia/Jayapura' => {
			exemplarCity => q#ጃያፑራ#,
		},
		'Asia/Jerusalem' => {
			exemplarCity => q#እየሩሳሌም#,
		},
		'Asia/Kabul' => {
			exemplarCity => q#ካቡል#,
		},
		'Asia/Kamchatka' => {
			exemplarCity => q#ካምቻትካ#,
		},
		'Asia/Karachi' => {
			exemplarCity => q#ካራቺ#,
		},
		'Asia/Katmandu' => {
			exemplarCity => q#ካትማንዱ#,
		},
		'Asia/Khandyga' => {
			exemplarCity => q#ካንዲጋ#,
		},
		'Asia/Krasnoyarsk' => {
			exemplarCity => q#ክራስኖያርስክ#,
		},
		'Asia/Kuala_Lumpur' => {
			exemplarCity => q#ኩዋላ ላምፑር#,
		},
		'Asia/Kuching' => {
			exemplarCity => q#ኩቺንግ#,
		},
		'Asia/Kuwait' => {
			exemplarCity => q#ኩዌት#,
		},
		'Asia/Macau' => {
			exemplarCity => q#ማካኡ#,
		},
		'Asia/Magadan' => {
			exemplarCity => q#ማጋዳን#,
		},
		'Asia/Makassar' => {
			exemplarCity => q#ማካሳር#,
		},
		'Asia/Manila' => {
			exemplarCity => q#ማኒላ#,
		},
		'Asia/Muscat' => {
			exemplarCity => q#ሙስካት#,
		},
		'Asia/Nicosia' => {
			exemplarCity => q#ኒኮሲአ#,
		},
		'Asia/Novokuznetsk' => {
			exemplarCity => q#ኖቮኩትዝኔክ#,
		},
		'Asia/Novosibirsk' => {
			exemplarCity => q#ኖቮሲቢሪስክ#,
		},
		'Asia/Omsk' => {
			exemplarCity => q#ኦምስክ#,
		},
		'Asia/Oral' => {
			exemplarCity => q#ኦራል#,
		},
		'Asia/Phnom_Penh' => {
			exemplarCity => q#ፍኖም ፔንህ#,
		},
		'Asia/Pontianak' => {
			exemplarCity => q#ፖንቲአናክ#,
		},
		'Asia/Pyongyang' => {
			exemplarCity => q#ፕዮንግያንግ#,
		},
		'Asia/Qatar' => {
			exemplarCity => q#ኳታር#,
		},
		'Asia/Qostanay' => {
			exemplarCity => q#ኮስታናይ#,
		},
		'Asia/Qyzylorda' => {
			exemplarCity => q#ኩይዚሎርዳ#,
		},
		'Asia/Rangoon' => {
			exemplarCity => q#ያንጎን#,
		},
		'Asia/Riyadh' => {
			exemplarCity => q#ሪያድ#,
		},
		'Asia/Saigon' => {
			exemplarCity => q#ሆ ቺ ሚንህ ከተማ#,
		},
		'Asia/Sakhalin' => {
			exemplarCity => q#ሳክሃሊን#,
		},
		'Asia/Samarkand' => {
			exemplarCity => q#ሳማርካንድ#,
		},
		'Asia/Seoul' => {
			exemplarCity => q#ሴኦል#,
		},
		'Asia/Shanghai' => {
			exemplarCity => q#ሻንጋይ#,
		},
		'Asia/Singapore' => {
			exemplarCity => q#ሲንጋፖር#,
		},
		'Asia/Srednekolymsk' => {
			exemplarCity => q#ስሬድኔስኮልምስክ#,
		},
		'Asia/Taipei' => {
			exemplarCity => q#ታይፓይ#,
		},
		'Asia/Tashkent' => {
			exemplarCity => q#ታሽኬንት#,
		},
		'Asia/Tbilisi' => {
			exemplarCity => q#ትብሊሲ#,
		},
		'Asia/Tehran' => {
			exemplarCity => q#ቴህራን#,
		},
		'Asia/Thimphu' => {
			exemplarCity => q#ቲምፉ#,
		},
		'Asia/Tokyo' => {
			exemplarCity => q#ቶኪዮ#,
		},
		'Asia/Tomsk' => {
			exemplarCity => q#ቶምስክ#,
		},
		'Asia/Ulaanbaatar' => {
			exemplarCity => q#ኡላአንባአታር#,
		},
		'Asia/Urumqi' => {
			exemplarCity => q#ኡሩምኪ#,
		},
		'Asia/Ust-Nera' => {
			exemplarCity => q#ኡስት-ኔራ#,
		},
		'Asia/Vientiane' => {
			exemplarCity => q#ቬንቲአን#,
		},
		'Asia/Vladivostok' => {
			exemplarCity => q#ቭላዲቮስቶክ#,
		},
		'Asia/Yakutsk' => {
			exemplarCity => q#ያኩትስክ#,
		},
		'Asia/Yekaterinburg' => {
			exemplarCity => q#የካተሪንበርግ#,
		},
		'Asia/Yerevan' => {
			exemplarCity => q#ይሬቫን#,
		},
		'Atlantic' => {
			long => {
				'daylight' => q#የአትላንቲክ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የአትላንቲክ የሰዓት አቆጣጠር#,
				'standard' => q#የአትላንቲክ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Atlantic/Azores' => {
			exemplarCity => q#አዞረስ#,
		},
		'Atlantic/Bermuda' => {
			exemplarCity => q#ቤርሙዳ#,
		},
		'Atlantic/Canary' => {
			exemplarCity => q#ካናሪ#,
		},
		'Atlantic/Cape_Verde' => {
			exemplarCity => q#ኬፕ ቬርደ#,
		},
		'Atlantic/Faeroe' => {
			exemplarCity => q#ፋሮእ#,
		},
		'Atlantic/Madeira' => {
			exemplarCity => q#ማዴራ#,
		},
		'Atlantic/Reykjavik' => {
			exemplarCity => q#ሬይክጃቪክ#,
		},
		'Atlantic/South_Georgia' => {
			exemplarCity => q#ደቡብ ጆርጂያ#,
		},
		'Atlantic/St_Helena' => {
			exemplarCity => q#ቅድስት ሄለና#,
		},
		'Atlantic/Stanley' => {
			exemplarCity => q#ስታንሌይ#,
		},
		'Australia/Adelaide' => {
			exemplarCity => q#አዴሌእድ#,
		},
		'Australia/Brisbane' => {
			exemplarCity => q#ብሪስቤን#,
		},
		'Australia/Broken_Hill' => {
			exemplarCity => q#ብሮክን ሂል#,
		},
		'Australia/Currie' => {
			exemplarCity => q#ከሪ#,
		},
		'Australia/Darwin' => {
			exemplarCity => q#ዳርዊን#,
		},
		'Australia/Eucla' => {
			exemplarCity => q#ኡክላ#,
		},
		'Australia/Hobart' => {
			exemplarCity => q#ሆባርት#,
		},
		'Australia/Lindeman' => {
			exemplarCity => q#ሊንድማን#,
		},
		'Australia/Lord_Howe' => {
			exemplarCity => q#ሎርድ ሆዊ#,
		},
		'Australia/Melbourne' => {
			exemplarCity => q#ሜልቦርን#,
		},
		'Australia/Perth' => {
			exemplarCity => q#ፐርዝ#,
		},
		'Australia/Sydney' => {
			exemplarCity => q#ሲድኒ#,
		},
		'Australia_Central' => {
			long => {
				'daylight' => q#የአውስትራሊያ መካከለኛ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የመካከለኛው አውስትራሊያ ሰዓት አቆጣጠር#,
				'standard' => q#የአውስትራሊያ መካከለኛ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Australia_CentralWestern' => {
			long => {
				'daylight' => q#የአውስትራሊያ መካከለኛው ምስራቅ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የአውስትራሊያ መካከለኛ ምስራቃዊ ሰዓት አቆጣጠር#,
				'standard' => q#የአውስትራሊያ መካከለኛ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Australia_Eastern' => {
			long => {
				'daylight' => q#የአውስትራሊያ ምዕራባዊ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የምዕራባዊ አውስትራሊያ የሰዓት አቆጣጠር#,
				'standard' => q#የአውስትራሊያ ምዕራባዊ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Australia_Western' => {
			long => {
				'daylight' => q#የአውስትራሊያ ምስራቃዊ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የምስራቃዊ አውስትራሊያ ሰዓት አቆጣጠር#,
				'standard' => q#የአውስትራሊያ ምስራቃዊ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Azerbaijan' => {
			long => {
				'daylight' => q#የአዘርባጃን ክረምት ሰዓት#,
				'generic' => q#የአዘርባጃን ሰዓት#,
				'standard' => q#የአዘርባጃን መደበኛ ሰዓት#,
			},
		},
		'Azores' => {
			long => {
				'daylight' => q#የአዞረስ ክረምት ሰዓት#,
				'generic' => q#የአዞረስ ሰዓት#,
				'standard' => q#የአዞረስ መደበኛ ሰዓት#,
			},
		},
		'Bangladesh' => {
			long => {
				'daylight' => q#የባንግላዴሽ ክረምት ሰዓት#,
				'generic' => q#የባንግላዴሽ ሰዓት#,
				'standard' => q#የባንግላዴሽ መደበኛ ሰዓት#,
			},
		},
		'Bhutan' => {
			long => {
				'standard' => q#የቡታን ሰዓት#,
			},
		},
		'Bolivia' => {
			long => {
				'standard' => q#የቦሊቪያ ሰዓት#,
			},
		},
		'Brasilia' => {
			long => {
				'daylight' => q#የብራዚላ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የብራዚላዊ ሰዓት አቆጣጠር#,
				'standard' => q#የብራሲሊያ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Brunei' => {
			long => {
				'standard' => q#የብሩኔይ ዳሩሳላም ሰዓት#,
			},
		},
		'Cape_Verde' => {
			long => {
				'daylight' => q#የኬፕ ቨርዴ ክረምት ሰዓት#,
				'generic' => q#የኬፕ ቨርዴ ሰዓት#,
				'standard' => q#የኬፕ ቨርዴ መደበኛ ሰዓት#,
			},
		},
		'Chamorro' => {
			long => {
				'standard' => q#የቻሞሮ መደበኛ ሰዓት#,
			},
		},
		'Chatham' => {
			long => {
				'daylight' => q#የቻታም የቀን ብርሃን ሰዓት#,
				'generic' => q#የቻታም ሰዓት#,
				'standard' => q#የቻታም መደበኛ ሰዓት#,
			},
		},
		'Chile' => {
			long => {
				'daylight' => q#የቺሊ ክረምት ሰዓት#,
				'generic' => q#የቺሊ ሰዓት#,
				'standard' => q#የቺሊ መደበኛ ሰዓት#,
			},
		},
		'China' => {
			long => {
				'daylight' => q#የቻይና የቀን ብርሃን ሰዓት#,
				'generic' => q#የቻይና ሰዓት#,
				'standard' => q#የቻይና መደበኛ ሰዓት#,
			},
		},
		'Choibalsan' => {
			long => {
				'daylight' => q#የቾይባልሳን የበጋ የሰዓት አቆጣጠር#,
				'generic' => q#የቾይባልሳ ሰዓት አቆጣጠር#,
				'standard' => q#የቾይባልሳን መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Christmas' => {
			long => {
				'standard' => q#የገና ደሴት ሰዓት#,
			},
		},
		'Cocos' => {
			long => {
				'standard' => q#የኮኮስ ደሴቶች ሰዓት#,
			},
		},
		'Colombia' => {
			long => {
				'daylight' => q#የኮሎምቢያ ክረምት ሰዓት#,
				'generic' => q#የኮሎምቢያ ሰዓት#,
				'standard' => q#የኮሎምቢያ መደበኛ ሰዓት#,
			},
		},
		'Cook' => {
			long => {
				'daylight' => q#የኩክ ደሴቶች ግማሽ ክረምት ሰዓት#,
				'generic' => q#የኩክ ደሴቶች ሰዓት#,
				'standard' => q#የኩክ ደሴቶች መደበኛ ሰዓት#,
			},
		},
		'Cuba' => {
			long => {
				'daylight' => q#የኩባ የቀን ብርሃን ሰዓት#,
				'generic' => q#ኩባ ሰዓት#,
				'standard' => q#የኩባ መደበኛ ሰዓት#,
			},
		},
		'Davis' => {
			long => {
				'standard' => q#የዴቪስ ሰዓት#,
			},
		},
		'DumontDUrville' => {
			long => {
				'standard' => q#የዱሞንት-ዱርቪል ሰዓት#,
			},
		},
		'East_Timor' => {
			long => {
				'standard' => q#የምስራቅ ቲሞር ሰዓት#,
			},
		},
		'Easter' => {
			long => {
				'daylight' => q#የኢስተር ደሴት ክረምት ሰዓት#,
				'generic' => q#የኢስተር ደሴት ሰዓት#,
				'standard' => q#የኢስተር ደሴት መደበኛ ሰዓት#,
			},
		},
		'Ecuador' => {
			long => {
				'standard' => q#የኢኳዶር ሰዓት#,
			},
		},
		'Etc/UTC' => {
			long => {
				'standard' => q#የተቀነባበረ ሁለገብ ሰዓት#,
			},
		},
		'Etc/Unknown' => {
			exemplarCity => q#ያልታወቀ ከተማ#,
		},
		'Europe/Amsterdam' => {
			exemplarCity => q#አምስተርዳም#,
		},
		'Europe/Andorra' => {
			exemplarCity => q#አንዶራ#,
		},
		'Europe/Astrakhan' => {
			exemplarCity => q#አስትራክሃን#,
		},
		'Europe/Athens' => {
			exemplarCity => q#አቴንስ#,
		},
		'Europe/Belgrade' => {
			exemplarCity => q#ቤልግሬድ#,
		},
		'Europe/Berlin' => {
			exemplarCity => q#በርሊን#,
		},
		'Europe/Bratislava' => {
			exemplarCity => q#ብራቲስላቫ#,
		},
		'Europe/Brussels' => {
			exemplarCity => q#ብራሰልስ#,
		},
		'Europe/Bucharest' => {
			exemplarCity => q#ቡካሬስት#,
		},
		'Europe/Budapest' => {
			exemplarCity => q#ቡዳፔስት#,
		},
		'Europe/Busingen' => {
			exemplarCity => q#ቡሲንገን#,
		},
		'Europe/Chisinau' => {
			exemplarCity => q#ቺስናኡ#,
		},
		'Europe/Copenhagen' => {
			exemplarCity => q#ኮፐንሃገን#,
		},
		'Europe/Dublin' => {
			exemplarCity => q#ደብሊን#,
			long => {
				'daylight' => q#የአይሪሽ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Europe/Gibraltar' => {
			exemplarCity => q#ጂብራልታር#,
		},
		'Europe/Guernsey' => {
			exemplarCity => q#ጉርነሲ#,
		},
		'Europe/Helsinki' => {
			exemplarCity => q#ሄልሲንኪ#,
		},
		'Europe/Isle_of_Man' => {
			exemplarCity => q#አይስል ኦፍ ማን#,
		},
		'Europe/Istanbul' => {
			exemplarCity => q#ኢስታንቡል#,
		},
		'Europe/Jersey' => {
			exemplarCity => q#ጀርሲ#,
		},
		'Europe/Kaliningrad' => {
			exemplarCity => q#ካሊኒንግራድ#,
		},
		'Europe/Kiev' => {
			exemplarCity => q#ኪየቭ#,
		},
		'Europe/Kirov' => {
			exemplarCity => q#ኪሮቭ#,
		},
		'Europe/Lisbon' => {
			exemplarCity => q#ሊዝበን#,
		},
		'Europe/Ljubljana' => {
			exemplarCity => q#ልጁብልጃና#,
		},
		'Europe/London' => {
			exemplarCity => q#ለንደን#,
			long => {
				'daylight' => q#የብሪትሽ የበጋ ሰዓት አቆጣጠር#,
			},
		},
		'Europe/Luxembourg' => {
			exemplarCity => q#ሉክሰምበርግ#,
		},
		'Europe/Madrid' => {
			exemplarCity => q#ማድሪድ#,
		},
		'Europe/Malta' => {
			exemplarCity => q#ማልታ#,
		},
		'Europe/Mariehamn' => {
			exemplarCity => q#ሜሪሃምን#,
		},
		'Europe/Minsk' => {
			exemplarCity => q#ሚንስክ#,
		},
		'Europe/Monaco' => {
			exemplarCity => q#ሞናኮ#,
		},
		'Europe/Moscow' => {
			exemplarCity => q#ሞስኮ#,
		},
		'Europe/Oslo' => {
			exemplarCity => q#ኦስሎ#,
		},
		'Europe/Paris' => {
			exemplarCity => q#ፓሪስ#,
		},
		'Europe/Podgorica' => {
			exemplarCity => q#ፖድጎሪካ#,
		},
		'Europe/Prague' => {
			exemplarCity => q#ፕራግ#,
		},
		'Europe/Riga' => {
			exemplarCity => q#ሪጋ#,
		},
		'Europe/Rome' => {
			exemplarCity => q#ሮም#,
		},
		'Europe/Samara' => {
			exemplarCity => q#ሳማራ#,
		},
		'Europe/San_Marino' => {
			exemplarCity => q#ሳን ማሪኖ#,
		},
		'Europe/Sarajevo' => {
			exemplarCity => q#ሳሪየቮ#,
		},
		'Europe/Saratov' => {
			exemplarCity => q#ሳራቶቭ#,
		},
		'Europe/Simferopol' => {
			exemplarCity => q#ሲምፈሮፖል#,
		},
		'Europe/Skopje' => {
			exemplarCity => q#ስኮፕየ#,
		},
		'Europe/Sofia' => {
			exemplarCity => q#ሶፊያ#,
		},
		'Europe/Stockholm' => {
			exemplarCity => q#ስቶክሆልም#,
		},
		'Europe/Tallinn' => {
			exemplarCity => q#ታሊን#,
		},
		'Europe/Tirane' => {
			exemplarCity => q#ቴራን#,
		},
		'Europe/Ulyanovsk' => {
			exemplarCity => q#ኡልያኖቭስክ#,
		},
		'Europe/Uzhgorod' => {
			exemplarCity => q#ኡዝጎሮድ#,
		},
		'Europe/Vaduz' => {
			exemplarCity => q#ቫዱዝ#,
		},
		'Europe/Vatican' => {
			exemplarCity => q#ቫቲካን#,
		},
		'Europe/Vienna' => {
			exemplarCity => q#ቪየና#,
		},
		'Europe/Vilnius' => {
			exemplarCity => q#ቪሊነስ#,
		},
		'Europe/Volgograd' => {
			exemplarCity => q#ቮልጎራድ#,
		},
		'Europe/Warsaw' => {
			exemplarCity => q#ዋርሶው#,
		},
		'Europe/Zagreb' => {
			exemplarCity => q#ዛግሬብ#,
		},
		'Europe/Zaporozhye' => {
			exemplarCity => q#ዛፖሮዚይ#,
		},
		'Europe/Zurich' => {
			exemplarCity => q#ዙሪክ#,
		},
		'Europe_Central' => {
			long => {
				'daylight' => q#የመካከለኛው አውሮፓ ክረምት ሰዓት#,
				'generic' => q#የመካከለኛው አውሮፓ ሰዓት#,
				'standard' => q#የመካከለኛው አውሮፓ መደበኛ ሰዓት#,
			},
		},
		'Europe_Eastern' => {
			long => {
				'daylight' => q#የምስራቃዊ አውሮፓ ክረምት ሰዓት#,
				'generic' => q#የምስራቃዊ አውሮፓ ሰዓት#,
				'standard' => q#የምስራቃዊ አውሮፓ መደበኛ ሰዓት#,
			},
		},
		'Europe_Further_Eastern' => {
			long => {
				'standard' => q#የሩቅ ምስራቅ የአውሮፓ ሰዓት#,
			},
		},
		'Europe_Western' => {
			long => {
				'daylight' => q#የምዕራባዊ አውሮፓ ክረምት ሰዓት#,
				'generic' => q#የምዕራባዊ አውሮፓ ሰዓት#,
				'standard' => q#የምዕራባዊ አውሮፓ መደበኛ ሰዓት#,
			},
		},
		'Falkland' => {
			long => {
				'daylight' => q#የፋልክላንድ ደሴቶች ክረምት ሰዓት#,
				'generic' => q#የፋልክላንድ ደሴቶች ሰዓት#,
				'standard' => q#የፋልክላንድ ደሴቶች መደበኛ ሰዓት#,
			},
		},
		'Fiji' => {
			long => {
				'daylight' => q#የፊጂ ክረምት ሰዓት#,
				'generic' => q#የፊጂ ሰዓት#,
				'standard' => q#የፊጂ መደበኛ ሰዓት#,
			},
		},
		'French_Guiana' => {
			long => {
				'standard' => q#የፈረንሳይ ጉያና ሰዓት#,
			},
		},
		'French_Southern' => {
			long => {
				'standard' => q#የፈረንሳይ ደቡባዊ እና አንታርክቲክ ሰዓት#,
			},
		},
		'GMT' => {
			long => {
				'standard' => q#ግሪንዊች ማዕከላዊ ሰዓት#,
			},
		},
		'Galapagos' => {
			long => {
				'standard' => q#የጋላፓጎስ ሰዓት#,
			},
		},
		'Gambier' => {
			long => {
				'standard' => q#የጋምቢየር ሰዓት#,
			},
		},
		'Georgia' => {
			long => {
				'daylight' => q#የጂዮርጂያ ክረምት ሰዓት#,
				'generic' => q#የጂዮርጂያ ሰዓት#,
				'standard' => q#የጂዮርጂያ መደበኛ ሰዓት#,
			},
		},
		'Gilbert_Islands' => {
			long => {
				'standard' => q#የጂልበርት ደሴቶች ሰዓት#,
			},
		},
		'Greenland_Eastern' => {
			long => {
				'daylight' => q#የምስራቅ ግሪንላንድ ክረምት ሰዓት#,
				'generic' => q#የምስራቅ ግሪንላንድ ሰዓት#,
				'standard' => q#የምስራቅ ግሪንላንድ መደበኛ ሰዓት#,
			},
		},
		'Greenland_Western' => {
			long => {
				'daylight' => q#የምዕራብ ግሪንላንድ ክረምት ሰዓት#,
				'generic' => q#የምዕራብ ግሪንላንድ ሰዓት#,
				'standard' => q#የምዕራብ ግሪንላንድ መደበኛ ሰዓት#,
			},
		},
		'Gulf' => {
			long => {
				'standard' => q#የባህረሰላጤ መደበኛ ሰዓት#,
			},
		},
		'Guyana' => {
			long => {
				'standard' => q#የጉያና ሰዓት#,
			},
		},
		'Hawaii_Aleutian' => {
			long => {
				'daylight' => q#የሃዋይ አሌኡት የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የሃዋይ አሌኡት ሰዓት አቆጣጠር#,
				'standard' => q#የሃዋይ አሌኡት መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Hong_Kong' => {
			long => {
				'daylight' => q#የሆንግ ኮንግ ክረምት ሰዓት#,
				'generic' => q#የሆንግ ኮንግ ሰዓት#,
				'standard' => q#የሆንግ ኮንግ መደበኛ ሰዓት#,
			},
		},
		'Hovd' => {
			long => {
				'daylight' => q#የሆቭድ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የሆቭድ ሰዓት አቆጣጠር#,
				'standard' => q#የሆቭድ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'India' => {
			long => {
				'standard' => q#የህንድ መደበኛ ሰዓት#,
			},
		},
		'Indian/Antananarivo' => {
			exemplarCity => q#አንታናናሪቮ#,
		},
		'Indian/Chagos' => {
			exemplarCity => q#ቻጎስ#,
		},
		'Indian/Christmas' => {
			exemplarCity => q#ገና#,
		},
		'Indian/Cocos' => {
			exemplarCity => q#ኮኮስ#,
		},
		'Indian/Comoro' => {
			exemplarCity => q#ኮሞሮ#,
		},
		'Indian/Kerguelen' => {
			exemplarCity => q#ኬርጉለን#,
		},
		'Indian/Mahe' => {
			exemplarCity => q#ማሄ#,
		},
		'Indian/Maldives' => {
			exemplarCity => q#ማልዲቨ#,
		},
		'Indian/Mauritius' => {
			exemplarCity => q#ሞሪሽየስ#,
		},
		'Indian/Mayotte' => {
			exemplarCity => q#ማዮቴ#,
		},
		'Indian/Reunion' => {
			exemplarCity => q#ሬዩኒየን#,
		},
		'Indian_Ocean' => {
			long => {
				'standard' => q#የህንድ ውቅያኖስ ሰዓት#,
			},
		},
		'Indochina' => {
			long => {
				'standard' => q#የኢንዶቻይና ሰዓት#,
			},
		},
		'Indonesia_Central' => {
			long => {
				'standard' => q#የመካከለኛው ኢንዶኔዢያ ሰዓት#,
			},
		},
		'Indonesia_Eastern' => {
			long => {
				'standard' => q#የምስራቃዊ ኢንዶኔዢያ ሰዓት#,
			},
		},
		'Indonesia_Western' => {
			long => {
				'standard' => q#የምዕራባዊ ኢንዶኔዢያ ሰዓት#,
			},
		},
		'Iran' => {
			long => {
				'daylight' => q#የኢራን የቀን ብርሃን ሰዓት#,
				'generic' => q#የኢራን ሰዓት#,
				'standard' => q#የኢራን መደበኛ ሰዓት#,
			},
		},
		'Irkutsk' => {
			long => {
				'daylight' => q#ኢርኩትስክ የበጋ የሰዓት አቆጣጠር#,
				'generic' => q#የኢርኩትስክ ሰዓት አቆጣጠር#,
				'standard' => q#የኢርኩትስክ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Israel' => {
			long => {
				'daylight' => q#የእስራኤል የቀን ብርሃን ሰዓት#,
				'generic' => q#የእስራኤል ሰዓት#,
				'standard' => q#የእስራኤል መደበኛ ሰዓት#,
			},
		},
		'Japan' => {
			long => {
				'daylight' => q#የጃፓን የቀን ብርሃን ሰዓት#,
				'generic' => q#የጃፓን ሰዓት#,
				'standard' => q#የጃፓን መደበኛ ሰዓት#,
			},
		},
		'Kamchatka' => {
			long => {
				'daylight' => q#የፔትሮፓቭሎስኪ - ካምቻትስኪ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የካምቻትካ ሰዓት አቆጣጠር#,
				'standard' => q#የፔትሮፓቭሎስኪ - ካምቻትስኪ ሰዓት አቆጣጠር#,
			},
		},
		'Kazakhstan_Eastern' => {
			long => {
				'standard' => q#የምስራቅ ካዛኪስታን ሰዓት#,
			},
		},
		'Kazakhstan_Western' => {
			long => {
				'standard' => q#የምዕራብ ካዛኪስታን ሰዓት#,
			},
		},
		'Korea' => {
			long => {
				'daylight' => q#የኮሪያ የቀን ብርሃን ሰዓት#,
				'generic' => q#የኮሪያ ሰዓት#,
				'standard' => q#የኮሪያ መደበኛ ሰዓት#,
			},
		},
		'Kosrae' => {
			long => {
				'standard' => q#የኮስራኤ ሰዓት#,
			},
		},
		'Krasnoyarsk' => {
			long => {
				'daylight' => q#የክራስኖያርስክ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የክራስኖያርስክ ሰዓት አቆጣጠር#,
				'standard' => q#የክራስኖይአርስክ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Kyrgystan' => {
			long => {
				'standard' => q#የኪርጊስታን ሰዓት#,
			},
		},
		'Line_Islands' => {
			long => {
				'standard' => q#የላይን ደሴቶች ሰዓት#,
			},
		},
		'Lord_Howe' => {
			long => {
				'daylight' => q#የሎርድ ሆዌ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የሎርድ ሆዌ የሰዓት አቆጣጠር#,
				'standard' => q#የሎርድ ሆዌ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Macquarie' => {
			long => {
				'standard' => q#የማከሪ ደሴት ሰዓት#,
			},
		},
		'Magadan' => {
			long => {
				'daylight' => q#የማጋዳን በጋ ሰዓት አቆጣጠር#,
				'generic' => q#የማጋዳን የሰዓት አቆጣጠር#,
				'standard' => q#የማጋዳን መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Malaysia' => {
			long => {
				'standard' => q#የማሌይዢያ ሰዓት#,
			},
		},
		'Maldives' => {
			long => {
				'standard' => q#የማልዲቭስ ሰዓት#,
			},
		},
		'Marquesas' => {
			long => {
				'standard' => q#የማርኴሳስ ሰዓት#,
			},
		},
		'Marshall_Islands' => {
			long => {
				'standard' => q#የማርሻል ደሴቶች ሰዓት#,
			},
		},
		'Mauritius' => {
			long => {
				'daylight' => q#የማውሪሺየስ ክረምት ሰዓት#,
				'generic' => q#የማውሪሺየስ ሰዓት#,
				'standard' => q#የማውሪሺየስ መደበኛ ሰዓት#,
			},
		},
		'Mawson' => {
			long => {
				'standard' => q#የማውሰን ሰዓት#,
			},
		},
		'Mexico_Northwest' => {
			long => {
				'daylight' => q#ሰሜናዊ ምእራብ የሜክሲኮ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#ሰሜናዊ ምእራብ የሜክሲኮ ሰዓት አቆጣጠር#,
				'standard' => q#ሰሜናዊ ምእራብ የሜክሲኮ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Mexico_Pacific' => {
			long => {
				'daylight' => q#የሜክሲኮ ፓሲፊክ የቀን ሰዓት አቆጣጠር#,
				'generic' => q#የሜክሲኮ ፓሲፊክ ሰዓት አቆጣጠር#,
				'standard' => q#የሜክሲኮ ፓሲፊክ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Mongolia' => {
			long => {
				'daylight' => q#የኡላን ባቶር የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የኡላን ባቶር ጊዜ#,
				'standard' => q#የኡላን ባቶር መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Moscow' => {
			long => {
				'daylight' => q#የሞስኮ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የሞስኮ ሰዓት አቆጣጠር#,
				'standard' => q#የሞስኮ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Myanmar' => {
			long => {
				'standard' => q#የሚያንማር ሰዓት#,
			},
		},
		'Nauru' => {
			long => {
				'standard' => q#የናውሩ ሰዓት#,
			},
		},
		'Nepal' => {
			long => {
				'standard' => q#የኔፓል ሰዓት#,
			},
		},
		'New_Caledonia' => {
			long => {
				'daylight' => q#የኒው ካሌዶኒያ ክረምት ሰዓት#,
				'generic' => q#የኒው ካሌዶኒያ ሰዓት#,
				'standard' => q#የኒው ካሌዶኒያ መደበኛ ሰዓት#,
			},
		},
		'New_Zealand' => {
			long => {
				'daylight' => q#የኒው ዚላንድ የቀን ብርሃን ሰዓት#,
				'generic' => q#የኒው ዚላንድ ሰዓት#,
				'standard' => q#የኒው ዚላንድ መደበኛ ሰዓት#,
			},
		},
		'Newfoundland' => {
			long => {
				'daylight' => q#የኒውፋውንድላንድ የቀን የሰዓት አቆጣጠር#,
				'generic' => q#የኒውፋውንድላንድ የሰዓት አቆጣጠር#,
				'standard' => q#የኒውፋውንድላንድ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Niue' => {
			long => {
				'standard' => q#የኒዩዌ ሰዓት#,
			},
		},
		'Norfolk' => {
			long => {
				'daylight' => q#የኖርፎልክ ደሴቶች የቀን የሰዓት አቆጣጠር#,
				'generic' => q#የኖርፎልክ ደሴቶች ሰዓት#,
				'standard' => q#የኖርፎልክ ደሴቶች መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Noronha' => {
			long => {
				'daylight' => q#የፈርናንዶ ዲ ኖሮንሃ የበጋ የሰዓት አቆጣጠር#,
				'generic' => q#የኖሮንሃ ሰዓት አቆጣጠር#,
				'standard' => q#የፈርናንዶ ዲ ኖሮንቻ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Novosibirsk' => {
			long => {
				'daylight' => q#የኖቮሲብሪስክ የበጋ ሰአት አቆጣጠር#,
				'generic' => q#የኖቮሲብሪስክ የሰዓት አቆጣጠር#,
				'standard' => q#የኖቮሲቢርስክ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Omsk' => {
			long => {
				'daylight' => q#የኦምስክ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የኦምስክ የሰዓት አቆጣጠር#,
				'standard' => q#የኦምስክ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Pacific/Apia' => {
			exemplarCity => q#አፒአ#,
		},
		'Pacific/Auckland' => {
			exemplarCity => q#ኦክላንድ#,
		},
		'Pacific/Bougainville' => {
			exemplarCity => q#ቦጌይንቪል#,
		},
		'Pacific/Chatham' => {
			exemplarCity => q#ቻታም#,
		},
		'Pacific/Easter' => {
			exemplarCity => q#ፋሲካ#,
		},
		'Pacific/Efate' => {
			exemplarCity => q#ኢፋቴ#,
		},
		'Pacific/Enderbury' => {
			exemplarCity => q#ኢንደርበሪ#,
		},
		'Pacific/Fakaofo' => {
			exemplarCity => q#ፋካኦፎ#,
		},
		'Pacific/Fiji' => {
			exemplarCity => q#ፊጂ#,
		},
		'Pacific/Funafuti' => {
			exemplarCity => q#ፈናፉቲ#,
		},
		'Pacific/Galapagos' => {
			exemplarCity => q#ጋላፓጎስ#,
		},
		'Pacific/Gambier' => {
			exemplarCity => q#ጋምቢየር#,
		},
		'Pacific/Guadalcanal' => {
			exemplarCity => q#ጉዋዳልካናል#,
		},
		'Pacific/Guam' => {
			exemplarCity => q#ጉአም#,
		},
		'Pacific/Honolulu' => {
			exemplarCity => q#ሆኖሉሉ#,
		},
		'Pacific/Johnston' => {
			exemplarCity => q#ጆንስተን#,
		},
		'Pacific/Kanton' => {
			exemplarCity => q#ካንቶን#,
		},
		'Pacific/Kiritimati' => {
			exemplarCity => q#ኪሪቲማቲ#,
		},
		'Pacific/Kosrae' => {
			exemplarCity => q#ኮስሬ#,
		},
		'Pacific/Kwajalein' => {
			exemplarCity => q#ክዋጃሊን#,
		},
		'Pacific/Majuro' => {
			exemplarCity => q#ማጁሩ#,
		},
		'Pacific/Marquesas' => {
			exemplarCity => q#ማርክዌሳስ#,
		},
		'Pacific/Midway' => {
			exemplarCity => q#ሚድወይ#,
		},
		'Pacific/Nauru' => {
			exemplarCity => q#ናውሩ#,
		},
		'Pacific/Niue' => {
			exemplarCity => q#ኒዌ#,
		},
		'Pacific/Norfolk' => {
			exemplarCity => q#ኖርፎልክ#,
		},
		'Pacific/Noumea' => {
			exemplarCity => q#ናኦሚአ#,
		},
		'Pacific/Pago_Pago' => {
			exemplarCity => q#ፓጎ ፓጎ#,
		},
		'Pacific/Palau' => {
			exemplarCity => q#ፓላው#,
		},
		'Pacific/Pitcairn' => {
			exemplarCity => q#ፒትከይርን#,
		},
		'Pacific/Ponape' => {
			exemplarCity => q#ፖህንፔ#,
		},
		'Pacific/Port_Moresby' => {
			exemplarCity => q#ፖርት ሞሬስባይ#,
		},
		'Pacific/Rarotonga' => {
			exemplarCity => q#ራሮቶንጋ#,
		},
		'Pacific/Saipan' => {
			exemplarCity => q#ሴይፓን#,
		},
		'Pacific/Tahiti' => {
			exemplarCity => q#ታሂቲ#,
		},
		'Pacific/Tarawa' => {
			exemplarCity => q#ታራዋ#,
		},
		'Pacific/Tongatapu' => {
			exemplarCity => q#ቶንጋታፑ#,
		},
		'Pacific/Truk' => {
			exemplarCity => q#ቹክ#,
		},
		'Pacific/Wake' => {
			exemplarCity => q#ዋኬ#,
		},
		'Pacific/Wallis' => {
			exemplarCity => q#ዋሊስ#,
		},
		'Pakistan' => {
			long => {
				'daylight' => q#የፓኪስታን ክረምት ሰዓት#,
				'generic' => q#የፓኪስታን ሰዓት#,
				'standard' => q#የፓኪስታን መደበኛ ሰዓት#,
			},
		},
		'Palau' => {
			long => {
				'standard' => q#የፓላው ሰዓት#,
			},
		},
		'Papua_New_Guinea' => {
			long => {
				'standard' => q#የፓፗ ኒው ጊኒ ሰዓት#,
			},
		},
		'Paraguay' => {
			long => {
				'daylight' => q#የፓራጓይ ክረምት ሰዓት#,
				'generic' => q#የፓራጓይ ሰዓት#,
				'standard' => q#የፓራጓይ መደበኛ ሰዓት#,
			},
		},
		'Peru' => {
			long => {
				'daylight' => q#የፔሩ ክረምት ሰዓት#,
				'generic' => q#የፔሩ ሰዓት#,
				'standard' => q#የፔሩ መደበኛ ሰዓት#,
			},
		},
		'Philippines' => {
			long => {
				'daylight' => q#የፊሊፒን ክረምት ሰዓት#,
				'generic' => q#የፊሊፒን ሰዓት#,
				'standard' => q#የፊሊፒን መደበኛ ሰዓት#,
			},
		},
		'Phoenix_Islands' => {
			long => {
				'standard' => q#የፊኒክስ ደሴቶች ሰዓት#,
			},
		},
		'Pierre_Miquelon' => {
			long => {
				'daylight' => q#ቅዱስ የፒዬር እና ሚኴሎን የቀን ብርሃን ሰዓት#,
				'generic' => q#ቅዱስ የፒዬር እና ሚኴሎን ሰዓት#,
				'standard' => q#ቅዱስ የፒዬር እና ሚኴሎን መደበኛ ሰዓት#,
			},
		},
		'Pitcairn' => {
			long => {
				'standard' => q#የፒትካይርን ሰዓት#,
			},
		},
		'Ponape' => {
			long => {
				'standard' => q#የፖናፔ ሰዓት#,
			},
		},
		'Pyongyang' => {
			long => {
				'standard' => q#የፕዮንግያንግ ሰዓት#,
			},
		},
		'Reunion' => {
			long => {
				'standard' => q#የሬዩኒየን ሰዓት#,
			},
		},
		'Rothera' => {
			long => {
				'standard' => q#የሮቴራ ሰዓት#,
			},
		},
		'Sakhalin' => {
			long => {
				'daylight' => q#የሳክሃሊን የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የሳክሃሊን ሰዓት አቆጣጠር#,
				'standard' => q#የሳክሃሊን መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Samara' => {
			long => {
				'daylight' => q#የሳማራ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የሳማራ ሰዓት አቆጣጠር#,
				'standard' => q#የሳማራ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Samoa' => {
			long => {
				'daylight' => q#የሳሞዋ የበጋ ሰዓት#,
				'generic' => q#የሳሞዋ ሰዓት#,
				'standard' => q#የሳሞዋ መደበኛ ሰዓት#,
			},
		},
		'Seychelles' => {
			long => {
				'standard' => q#የሴሸልስ ሰዓት#,
			},
		},
		'Singapore' => {
			long => {
				'standard' => q#የሲንጋፒር መደበኛ ሰዓት#,
			},
		},
		'Solomon' => {
			long => {
				'standard' => q#የሰለሞን ደሴቶች ሰዓት#,
			},
		},
		'South_Georgia' => {
			long => {
				'standard' => q#የደቡብ ጂዮርጂያ ሰዓት#,
			},
		},
		'Suriname' => {
			long => {
				'standard' => q#የሱሪናም ሰዓት#,
			},
		},
		'Syowa' => {
			long => {
				'standard' => q#የሲዮዋ ሰዓት#,
			},
		},
		'Tahiti' => {
			long => {
				'standard' => q#የታሂቲ ሰዓት#,
			},
		},
		'Taipei' => {
			long => {
				'daylight' => q#የታይፔይ የቀን ብርሃን ሰዓት#,
				'generic' => q#የታይፔይ ሰዓት#,
				'standard' => q#የታይፔይ መደበኛ ሰዓት#,
			},
		},
		'Tajikistan' => {
			long => {
				'standard' => q#የታጂኪስታን ሰዓት#,
			},
		},
		'Tokelau' => {
			long => {
				'standard' => q#የቶኬላው ሰዓት#,
			},
		},
		'Tonga' => {
			long => {
				'daylight' => q#የቶንጋ ክረምት ሰዓት#,
				'generic' => q#የቶንጋ ሰዓት#,
				'standard' => q#የቶንጋ መደበኛ ሰዓት#,
			},
		},
		'Truk' => {
			long => {
				'standard' => q#የቹክ ሰዓት#,
			},
		},
		'Turkmenistan' => {
			long => {
				'daylight' => q#የቱርክመኒስታን ክረምት ሰዓት#,
				'generic' => q#የቱርክመኒስታን ሰዓት#,
				'standard' => q#የቱርክመኒስታን መደበኛ ሰዓት#,
			},
		},
		'Tuvalu' => {
			long => {
				'standard' => q#የቱቫሉ ሰዓት#,
			},
		},
		'Uruguay' => {
			long => {
				'daylight' => q#የኡራጓይ ክረምት ሰዓት#,
				'generic' => q#የኡራጓይ ሰዓት#,
				'standard' => q#የኡራጓይ መደበኛ ሰዓት#,
			},
		},
		'Uzbekistan' => {
			long => {
				'daylight' => q#የኡዝቤኪስታን ክረምት ሰዓት#,
				'generic' => q#የኡዝቤኪስታን ሰዓት#,
				'standard' => q#የኡዝቤኪስታን መደበኛ ሰዓት#,
			},
		},
		'Vanuatu' => {
			long => {
				'daylight' => q#የቫኗቱ ክረምት ሰዓት#,
				'generic' => q#የቫኗቱ ሰዓት#,
				'standard' => q#የቫኗቱ መደበኛ ሰዓት#,
			},
		},
		'Venezuela' => {
			long => {
				'standard' => q#የቬኔዝዌላ ሰዓት#,
			},
		},
		'Vladivostok' => {
			long => {
				'daylight' => q#የቭላዲቮስቶክ የበጋ የሰዓት አቆጣጠር#,
				'generic' => q#የቭላዲቮስቶክ የሰዓት አቆጣጠር#,
				'standard' => q#የቪላዲቮስቶክ መደበኛ የሰዓት አቆጣጠር#,
			},
		},
		'Volgograd' => {
			long => {
				'daylight' => q#የቫልጎራድ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የቮልጎራድ የሰዓት አቆጣጠር#,
				'standard' => q#የቮልጎራድ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Vostok' => {
			long => {
				'standard' => q#የቮስቶክ ሰዓት#,
			},
		},
		'Wake' => {
			long => {
				'standard' => q#የዌክ ደሴት ሰዓት#,
			},
		},
		'Wallis' => {
			long => {
				'standard' => q#የዋሊስ እና ፉቱና ሰዓት#,
			},
		},
		'Yakutsk' => {
			long => {
				'daylight' => q#የያኩትስክ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#ያኩትስክ የሰዓት አቆጣጠር#,
				'standard' => q#ያኩትስክ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Yekaterinburg' => {
			long => {
				'daylight' => q#የየካተሪንበርግ የበጋ ሰዓት አቆጣጠር#,
				'generic' => q#የየካተሪንበርግ ሰዓት አቆጣጠር#,
				'standard' => q#የየካተሪንበርግ መደበኛ ሰዓት አቆጣጠር#,
			},
		},
		'Yukon' => {
			long => {
				'standard' => q#የዩኮን ጊዜ#,
			},
		},
	 } }
);
no Moo;

1;

# vim: tabstop=4
