SELECT me.fruit, me.sum_units_broker, me.sum_units_e_commerce, me.sum_units_own_retail,
       me.sum_units_wholesale, me.round_all_avg_units_broker, me.round_all_avg_units_e_commerce,
       me.round_all_avg_units_own_retail, me.round_all_avg_units_wholesale FROM (
SELECT me.fruit,
       sum (CASE WHEN channel='broker' then units ELSE NULL END) as sum_units_broker,
       sum (CASE WHEN channel='e-commerce' then units ELSE NULL END) as sum_units_e_commerce,
       sum (CASE WHEN channel='own retail' then units ELSE NULL END) as sum_units_own_retail,
       sum (CASE WHEN channel='wholesale' then units ELSE NULL END) as sum_units_wholesale,

       round ( all (CASE WHEN channel='broker' then avg(units) ELSE NULL END) ) as round_all_avg_units_broker,
       round ( all (CASE WHEN channel='e-commerce' then avg(units) ELSE NULL END) ) as round_all_avg_units_e_commerce,
       round ( all (CASE WHEN channel='own retail' then avg(units) ELSE NULL END) ) as round_all_avg_units_own_retail,
       round ( all (CASE WHEN channel='wholesale' then avg(units) ELSE NULL END) ) as round_all_avg_units_wholesale

FROM sales me WHERE ( fruit LIKE ? ) GROUP BY fruit) me
