/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ascii2image.graphics;

import java.awt.BasicStroke;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import javax.imageio.ImageIO;
import org.stathissideris.ascii2image.core.RenderingOptions;
import org.stathissideris.ascii2image.core.Shape3DOrderingComparator;
import org.stathissideris.ascii2image.graphics.CustomShapeDefinition;
import org.stathissideris.ascii2image.graphics.Diagram;
import org.stathissideris.ascii2image.graphics.DiagramShape;
import org.stathissideris.ascii2image.graphics.DiagramText;
import org.stathissideris.ascii2image.graphics.ImageHandler;

public class BitmapRenderer {
    private static final boolean DEBUG = false;
    private static final String IDREGEX = "^.+_vfill$";
    Stroke normalStroke;
    Stroke dashStroke;

    private boolean renderToPNG(Diagram diagram, String string, RenderingOptions renderingOptions) {
        RenderedImage renderedImage = this.renderToImage(diagram, renderingOptions);
        try {
            File file = new File(string);
            ImageIO.write(renderedImage, "png", file);
        }
        catch (IOException iOException) {
            System.err.println("Error: Cannot write to file " + string);
            return false;
        }
        return true;
    }

    public RenderedImage renderToImage(Diagram diagram, RenderingOptions renderingOptions) {
        BufferedImage bufferedImage = new BufferedImage(diagram.getWidth(), diagram.getHeight(), 1);
        return this.render(diagram, bufferedImage, renderingOptions);
    }

    public RenderedImage render(Diagram diagram, BufferedImage bufferedImage, RenderingOptions renderingOptions) {
        Object object;
        Object object22;
        BufferedImage bufferedImage2 = bufferedImage;
        Graphics2D graphics2D = bufferedImage.createGraphics();
        Object object3 = RenderingHints.VALUE_ANTIALIAS_OFF;
        if (renderingOptions.performAntialias()) {
            object3 = RenderingHints.VALUE_ANTIALIAS_ON;
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object3);
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth() + 10, bufferedImage.getHeight() + 10);
        graphics2D.setStroke(new BasicStroke(1.0f, 2, 1));
        ArrayList arrayList = diagram.getAllDiagramShapes();
        if (renderingOptions.dropShadows()) {
            float f;
            for (DiagramShape diagramShape : arrayList) {
                if (diagramShape.getPoints().isEmpty()) continue;
                GeneralPath generalPath = diagramShape.makeIntoRenderPath(diagram);
                f = diagram.getMinimumOfCellDimension() / 3.333f;
                if (generalPath == null || !diagramShape.dropsShadow() || diagramShape.getType() == 9999) continue;
                GeneralPath generalPath2 = new GeneralPath(generalPath);
                object22 = new AffineTransform();
                ((AffineTransform)object22).setToTranslation(f, f);
                generalPath2.transform((AffineTransform)object22);
                graphics2D.setColor(new Color(150, 150, 150));
                graphics2D.fill(generalPath2);
            }
            int n = 6;
            int n2 = n * n;
            f = n2;
            float f2 = 1.0f / f;
            object22 = new float[n2];
            for (int i = 0; i < n2; ++i) {
                object22[i] = f2;
            }
            Kernel kernel = new Kernel(n, n, (float[])object22);
            object = new ConvolveOp(kernel, 1, null);
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
            ((ConvolveOp)object).filter(bufferedImage, bufferedImage3);
            graphics2D = (Graphics2D)bufferedImage3.getGraphics();
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object3);
            bufferedImage2 = bufferedImage3;
        }
        float f = Math.min(diagram.getCellWidth(), diagram.getCellHeight()) / 2;
        float f3 = diagram.getMinimumOfCellDimension() / 10.0f;
        this.normalStroke = new BasicStroke(f3, 1, 1);
        this.dashStroke = new BasicStroke(f3, 0, 1, 0.0f, new float[]{f}, 0.0f);
        ArrayList<DiagramShape> arrayList2 = new ArrayList<DiagramShape>();
        for (DiagramShape diagramShape : arrayList) {
            if (diagramShape.getType() != 4) continue;
            arrayList2.add(diagramShape);
        }
        Collections.sort(arrayList2, new Shape3DOrderingComparator());
        graphics2D.setStroke(this.normalStroke);
        for (DiagramShape diagramShape : arrayList2) {
            object22 = diagramShape.makeIntoRenderPath(diagram);
            if (!diagramShape.isStrokeDashed()) {
                if (diagramShape.getFillColor() != null) {
                    graphics2D.setColor(diagramShape.getFillColor());
                } else {
                    graphics2D.setColor(Color.white);
                }
                graphics2D.fill((Shape)object22);
            }
            if (diagramShape.isStrokeDashed()) {
                graphics2D.setStroke(this.dashStroke);
            } else {
                graphics2D.setStroke(this.normalStroke);
            }
            graphics2D.setColor(diagramShape.getStrokeColor());
            graphics2D.draw((Shape)object22);
        }
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (Object object22 : arrayList) {
            if (((DiagramShape)object22).getType() == 2) {
                arrayList3.add(object22);
                continue;
            }
            if (((DiagramShape)object22).getType() == 4) continue;
            if (((DiagramShape)object22).getType() == 9999) {
                this.renderCustomShape((DiagramShape)object22, graphics2D);
                continue;
            }
            if (((DiagramShape)object22).getPoints().isEmpty()) continue;
            int n = ((DiagramShape)object22).getPoints().size();
            object = ((DiagramShape)object22).makeIntoRenderPath(diagram);
            if (object != null && ((DiagramShape)object22).isClosed() && !((DiagramShape)object22).isStrokeDashed()) {
                if (((DiagramShape)object22).getFillColor() != null) {
                    graphics2D.setColor(((DiagramShape)object22).getFillColor());
                } else {
                    graphics2D.setColor(Color.white);
                }
                graphics2D.fill((Shape)object);
            }
            if (((DiagramShape)object22).getType() == 1) continue;
            graphics2D.setColor(((DiagramShape)object22).getStrokeColor());
            if (((DiagramShape)object22).isStrokeDashed()) {
                graphics2D.setStroke(this.dashStroke);
            } else {
                graphics2D.setStroke(this.normalStroke);
            }
            graphics2D.draw((Shape)object);
        }
        graphics2D.setStroke(this.normalStroke);
        for (Object object22 : arrayList3) {
            GeneralPath generalPath = ((DiagramShape)object22).makeIntoRenderPath(diagram);
            graphics2D.setColor(Color.white);
            graphics2D.fill(generalPath);
            graphics2D.setColor(((DiagramShape)object22).getStrokeColor());
            graphics2D.draw(generalPath);
        }
        for (DiagramText diagramText : diagram.getTextObjects()) {
            graphics2D.setFont(diagramText.getFont());
            if (diagramText.hasOutline()) {
                graphics2D.setColor(diagramText.getOutlineColor());
                graphics2D.drawString(diagramText.getText(), diagramText.getXPos() + 1, diagramText.getYPos());
                graphics2D.drawString(diagramText.getText(), diagramText.getXPos() - 1, diagramText.getYPos());
                graphics2D.drawString(diagramText.getText(), diagramText.getXPos(), diagramText.getYPos() + 1);
                graphics2D.drawString(diagramText.getText(), diagramText.getXPos(), diagramText.getYPos() - 1);
            }
            graphics2D.setColor(diagramText.getColor());
            graphics2D.drawString(diagramText.getText(), diagramText.getXPos(), diagramText.getYPos());
        }
        if (renderingOptions.renderDebugLines()) {
            int n;
            BasicStroke basicStroke = new BasicStroke(1.0f, 1, 1);
            graphics2D.setStroke(basicStroke);
            graphics2D.setColor(new Color(170, 170, 170));
            graphics2D.setXORMode(Color.white);
            for (n = 0; n < diagram.getWidth(); n += diagram.getCellWidth()) {
                graphics2D.drawLine(n, 0, n, diagram.getHeight());
            }
            for (n = 0; n < diagram.getHeight(); n += diagram.getCellHeight()) {
                graphics2D.drawLine(0, n, diagram.getWidth(), n);
            }
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    private RenderedImage renderTextLayer(ArrayList arrayList, int n, int n2) {
        TextCanvas textCanvas = new TextCanvas(arrayList);
        Image image = textCanvas.createImage(n, n2);
        Graphics graphics = image.getGraphics();
        textCanvas.paint(graphics);
        return (RenderedImage)((Object)image);
    }

    private void renderCustomShape(DiagramShape diagramShape, Graphics2D graphics2D) {
        CustomShapeDefinition customShapeDefinition = diagramShape.getDefinition();
        Rectangle rectangle = diagramShape.getBounds();
        if (customShapeDefinition.hasBorder()) {
            graphics2D.setColor(diagramShape.getStrokeColor());
            if (diagramShape.isStrokeDashed()) {
                graphics2D.setStroke(this.dashStroke);
            } else {
                graphics2D.setStroke(this.normalStroke);
            }
            graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x + rectangle.width, rectangle.y);
            graphics2D.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            graphics2D.drawLine(rectangle.x, rectangle.y + rectangle.height, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            graphics2D.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        }
        if (customShapeDefinition.getFilename().endsWith(".png")) {
            this.renderCustomPNGShape(diagramShape, graphics2D);
        } else if (customShapeDefinition.getFilename().endsWith(".svg")) {
            throw new UnsupportedOperationException();
        }
    }

    private void renderCustomPNGShape(DiagramShape diagramShape, Graphics2D graphics2D) {
        int n;
        int n2;
        int n3;
        int n4;
        CustomShapeDefinition customShapeDefinition = diagramShape.getDefinition();
        Rectangle rectangle = diagramShape.getBounds();
        Image image = ImageHandler.instance().loadImage(customShapeDefinition.getFilename());
        if (customShapeDefinition.stretches()) {
            n4 = rectangle.x;
            n3 = rectangle.y;
            n2 = rectangle.width;
            n = rectangle.height;
        } else {
            int n5 = rectangle.width * image.getHeight(null) / image.getWidth(null);
            if (n5 < rectangle.height) {
                n = n5;
                n2 = rectangle.width;
                n4 = rectangle.x;
                n3 = rectangle.y + rectangle.height / 2 - image.getHeight(null) / 2;
            } else {
                n2 = image.getWidth(null) * rectangle.height / image.getHeight(null);
                n = rectangle.height;
                n4 = rectangle.x + rectangle.width / 2 - image.getWidth(null) / 2;
                n3 = rectangle.y;
            }
        }
        graphics2D.drawImage(image, n4, n3, n2, n, null);
    }

    public static boolean isColorDark(Color color) {
        int n = Math.max(color.getRed(), color.getGreen());
        n = Math.max(color.getBlue(), n);
        return n < 200;
    }

    private class TextCanvas
    extends Canvas {
        ArrayList textObjects;

        public TextCanvas(ArrayList arrayList) {
            this.textObjects = arrayList;
        }

        public void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            for (DiagramText diagramText : this.textObjects) {
                graphics2D.setFont(diagramText.getFont());
                if (diagramText.hasOutline()) {
                    graphics2D.setColor(diagramText.getOutlineColor());
                    ((Graphics)graphics2D).drawString(diagramText.getText(), diagramText.getXPos() + 1, diagramText.getYPos());
                    ((Graphics)graphics2D).drawString(diagramText.getText(), diagramText.getXPos() - 1, diagramText.getYPos());
                    ((Graphics)graphics2D).drawString(diagramText.getText(), diagramText.getXPos(), diagramText.getYPos() + 1);
                    ((Graphics)graphics2D).drawString(diagramText.getText(), diagramText.getXPos(), diagramText.getYPos() - 1);
                }
                graphics2D.setColor(diagramText.getColor());
                ((Graphics)graphics2D).drawString(diagramText.getText(), diagramText.getXPos(), diagramText.getYPos());
            }
        }
    }
}

