######################################################################
#
# 1030_cp00930_by_sjis2004.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x00"],
        ["\x01",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x01"],
        ["\x02",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x02"],
        ["\x03",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x03"],
        ["\x04",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x37"],
        ["\x05",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x2D"],
        ["\x06",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x2E"],
        ["\x07",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x2F"],
        ["\x08",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x16"],
        ["\x09",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x05"],
        ["\x0A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x15"],
        ["\x0B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x0B"],
        ["\x0C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x0C"],
        ["\x0D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x0D"],
        ["\x0E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x0E"],
        ["\x0F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x0F"],
        ["\x10",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x10"],
        ["\x11",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x11"],
        ["\x12",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x12"],
        ["\x13",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x13"],
        ["\x14",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x3C"],
        ["\x15",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x3D"],
        ["\x16",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x32"],
        ["\x17",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x26"],
        ["\x18",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x18"],
        ["\x19",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x19"],
        ["\x1A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x3F"],
        ["\x1B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x27"],
        ["\x1C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x1C"],
        ["\x1D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x1D"],
        ["\x1E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x1E"],
        ["\x1F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x1F"],
        ["\x20",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x40"],
        ["\x21",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x5A"],
        ["\x22",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x7F"],
        ["\x23",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x7B"],
        ["\x24",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE0"],
        ["\x25",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x6C"],
        ["\x26",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x50"],
        ["\x27",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x7D"],
        ["\x28",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x4D"],
        ["\x29",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x5D"],
        ["\x2A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x5C"],
        ["\x2B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x4E"],
        ["\x2C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x6B"],
        ["\x2D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x60"],
        ["\x2E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x4B"],
        ["\x2F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x61"],
        ["\x30",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF0"],
        ["\x31",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF1"],
        ["\x32",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF2"],
        ["\x33",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF3"],
        ["\x34",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF4"],
        ["\x35",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF5"],
        ["\x36",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF6"],
        ["\x37",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF7"],
        ["\x38",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF8"],
        ["\x39",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xF9"],
        ["\x3A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x7A"],
        ["\x3B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x5E"],
        ["\x3C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x4C"],
        ["\x3D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x7E"],
        ["\x3E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x6E"],
        ["\x3F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x6F"],
        ["\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x7C"],
        ["\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC1"],
        ["\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC2"],
        ["\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC3"],
        ["\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC4"],
        ["\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC5"],
        ["\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC6"],
        ["\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC7"],
        ["\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC8"],
        ["\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC9"],
        ["\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD1"],
        ["\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD2"],
        ["\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD3"],
        ["\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD4"],
        ["\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD5"],
        ["\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD6"],
        ["\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD7"],
        ["\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD8"],
        ["\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD9"],
        ["\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE2"],
        ["\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE3"],
        ["\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE4"],
        ["\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE5"],
        ["\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE6"],
        ["\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE7"],
        ["\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE8"],
        ["\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE9"],
        ["\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x70"],
        ["\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x5B"],
        ["\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x80"],
        ["\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB0"],
        ["\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x6D"],
        ["\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x79"],
        ["\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x62"],
        ["\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x63"],
        ["\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x64"],
        ["\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x65"],
        ["\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x66"],
        ["\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x67"],
        ["\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x68"],
        ["\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x69"],
        ["\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x71"],
        ["\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x72"],
        ["\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x73"],
        ["\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x74"],
        ["\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x75"],
        ["\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x76"],
        ["\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x77"],
        ["\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x78"],
        ["\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x8B"],
        ["\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x9B"],
        ["\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xAB"],
        ["\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB3"],
        ["\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB4"],
        ["\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB5"],
        ["\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB6"],
        ["\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB7"],
        ["\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB8"],
        ["\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB9"],
        ["\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xC0"],
        ["\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x4F"],
        ["\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xD0"],
        ["\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA0"],
        ["\x7F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x07"],
        ["\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x20"],
        ["\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x21"],
        ["\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x22"],
        ["\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x23"],
        ["\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x24"],
        ["\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x25"],
        ["\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x06"],
        ["\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x17"],
        ["\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x28"],
        ["\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x29"],
        ["\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x2A"],
        ["\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x2B"],
        ["\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x2C"],
        ["\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x09"],
        ["\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x0A"],
        ["\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x1B"],
        ["\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x30"],
        ["\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x31"],
        ["\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x1A"],
        ["\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x33"],
        ["\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x34"],
        ["\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x35"],
        ["\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x36"],
        ["\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x08"],
        ["\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x38"],
        ["\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x39"],
        ["\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x3A"],
        ["\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x3B"],
        ["\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x04"],
        ["\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x14"],
        ["\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x3E"],
        ["\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x4A"],
        ["\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x6A"],
        ["\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x41"],
        ["\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x42"],
        ["\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x43"],
        ["\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x44"],
        ["\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x45"],
        ["\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x46"],
        ["\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x47"],
        ["\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x48"],
        ["\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x49"],
        ["\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x51"],
        ["\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x52"],
        ["\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x53"],
        ["\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x54"],
        ["\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x55"],
        ["\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x56"],
        ["\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x58"],
        ["\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x81"],
        ["\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x82"],
        ["\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x83"],
        ["\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x84"],
        ["\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x85"],
        ["\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x86"],
        ["\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x87"],
        ["\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x88"],
        ["\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x89"],
        ["\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x8A"],
        ["\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x8C"],
        ["\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x8D"],
        ["\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x8E"],
        ["\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x8F"],
        ["\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x90"],
        ["\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x91"],
        ["\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x92"],
        ["\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x93"],
        ["\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x94"],
        ["\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x95"],
        ["\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x96"],
        ["\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x97"],
        ["\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x98"],
        ["\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x99"],
        ["\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x9A"],
        ["\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x9D"],
        ["\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x9E"],
        ["\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x9F"],
        ["\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA2"],
        ["\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA3"],
        ["\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA4"],
        ["\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA5"],
        ["\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA6"],
        ["\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA7"],
        ["\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA8"],
        ["\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA9"],
        ["\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xAA"],
        ["\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xAC"],
        ["\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xAD"],
        ["\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xAE"],
        ["\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xAF"],
        ["\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xBA"],
        ["\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xBB"],
        ["\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xBC"],
        ["\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xBD"],
        ["\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xBE"],
        ["\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xBF"],
        ["\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x57"],
        ["\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x59"],
        ["\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x5F"],
        ["\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\x9C"],
        ["\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xA1"],
        ["\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB1"],
        ["\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xB2"],
        ["\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xE1"],
        ["\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xCA"],
        ["\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xCB"],
        ["\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xCC"],
        ["\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xCD"],
        ["\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xCE"],
        ["\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xCF"],
        ["\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xDA"],
        ["\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xDB"],
        ["\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xDC"],
        ["\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xDD"],
        ["\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xDE"],
        ["\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xDF"],
        ["\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xEA"],
        ["\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xEB"],
        ["\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xEC"],
        ["\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xED"],
        ["\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xEE"],
        ["\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xEF"],
        ["\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xFA"],
        ["\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xFB"],
        ["\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xFC"],
        ["\xFD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xFD"],
        ["\xFE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xFE"],
        ["\xFF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'S'},"\xFF"],
        ["\x81\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x40\x40"],
        ["\x81\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x44"],
        ["\x81\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x41"],
        ["\x81\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x6B"],
        ["\x81\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x4B"],
        ["\x81\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x45"],
        ["\x81\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x7A"],
        ["\x81\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x5E"],
        ["\x81\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x6F"],
        ["\x81\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x5A"],
        ["\x81\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xBE"],
        ["\x81\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xBF"],
        ["\x81\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x50"],
        ["\x81\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x79"],
        ["\x81\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x60"],
        ["\x81\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x70"],
        ["\x81\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA1"],
        ["\x81\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x6D"],
        ["\x81\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xDC"],
        ["\x81\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xDD"],
        ["\x81\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xDC"],
        ["\x81\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xDD"],
        ["\x81\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x5B"],
        ["\x81\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x5C"],
        ["\x81\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x5D"],
        ["\x81\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x5E"],
        ["\x81\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x5F"],
        ["\x81\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x58"],
        ["\x81\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x5A"],
        ["\x81\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x61"],
        ["\x81\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA1"],
        ["\x81\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xE5"],
        ["\x81\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x4F"],
        ["\x81\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7F"],
        ["\x81\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7E"],
        ["\x81\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x61"],
        ["\x81\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x71"],
        ["\x81\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x62"],
        ["\x81\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x72"],
        ["\x81\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x4D"],
        ["\x81\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x5D"],
        ["\x81\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x63"],
        ["\x81\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x73"],
        ["\x81\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x44"],
        ["\x81\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x45"],
        ["\x81\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC0"],
        ["\x81\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD0"],
        ["\x81\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x64"],
        ["\x81\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x74"],
        ["\x81\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x65"],
        ["\x81\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x75"],
        ["\x81\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x42"],
        ["\x81\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x43"],
        ["\x81\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x42"],
        ["\x81\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x43"],
        ["\x81\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x66"],
        ["\x81\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x76"],
        ["\x81\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x4E"],
        ["\x81\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE9\xF3"],
        ["\x81\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x4B"],
        ["\x81\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7A"],
        ["\x81\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7B"],
        ["\x81\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x7E"],
        ["\x81\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x4C"],
        ["\x81\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x4C"],
        ["\x81\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x6E"],
        ["\x81\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x67"],
        ["\x81\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x77"],
        ["\x81\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x4D"],
        ["\x81\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x68"],
        ["\x81\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x69"],
        ["\x81\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x79"],
        ["\x81\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xED"],
        ["\x81\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xEE"],
        ["\x81\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xEF"],
        ["\x81\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x4E"],
        ["\x81\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x5B"],
        ["\x81\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE0"],
        ["\x81\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x6C"],
        ["\x81\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x7B"],
        ["\x81\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x50"],
        ["\x81\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x5C"],
        ["\x81\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x7C"],
        ["\x81\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x6A"],
        ["\x81\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE5"],
        ["\x81\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE6"],
        ["\x81\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE0"],
        ["\x81\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE1"],
        ["\x81\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE4"],
        ["\x81\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE7"],
        ["\x81\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE8"],
        ["\x81\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE9"],
        ["\x81\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xEA"],
        ["\x81\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE2"],
        ["\x81\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xE3"],
        ["\x81\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xEB"],
        ["\x81\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xEC"],
        ["\x81\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x6B"],
        ["\x81\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x6C"],
        ["\x81\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xF0"],
        ["\x81\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xF1"],
        ["\x81\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xF2"],
        ["\x81\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xF3"],
        ["\x81\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x81\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x64"],
        ["\x81\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x65"],
        ["\x81\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x66"],
        ["\x81\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x67"],
        ["\x81\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x68"],
        ["\x81\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x69"],
        ["\x81\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x6A"],
        ["\x81\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x6B"],
        ["\x81\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x6C"],
        ["\x81\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x6D"],
        ["\x81\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x6E"],
        ["\x81\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x6F"],
        ["\x81\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x70"],
        ["\x81\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x71"],
        ["\x81\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x4B"],
        ["\x81\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x4C"],
        ["\x81\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x4D"],
        ["\x81\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x4E"],
        ["\x81\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x4F"],
        ["\x81\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x5B"],
        ["\x81\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x5C"],
        ["\x81\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x5D"],
        ["\x81\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x5E"],
        ["\x81\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x5F"],
        ["\x81\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x60"],
        ["\x81\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x61"],
        ["\x81\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x78"],
        ["\x81\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x62"],
        ["\x81\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x63"],
        ["\x81\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x72"],
        ["\x81\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x73"],
        ["\x81\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x74"],
        ["\x81\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x75"],
        ["\x81\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x76"],
        ["\x81\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x77"],
        ["\x81\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x78"],
        ["\x81\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x79"],
        ["\x81\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x7A"],
        ["\x82\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF0"],
        ["\x82\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF1"],
        ["\x82\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF2"],
        ["\x82\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF3"],
        ["\x82\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF4"],
        ["\x82\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF5"],
        ["\x82\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF6"],
        ["\x82\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF7"],
        ["\x82\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF8"],
        ["\x82\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xF9"],
        ["\x82\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC1"],
        ["\x82\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC2"],
        ["\x82\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC3"],
        ["\x82\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC4"],
        ["\x82\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC5"],
        ["\x82\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC6"],
        ["\x82\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC7"],
        ["\x82\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC8"],
        ["\x82\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xC9"],
        ["\x82\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD1"],
        ["\x82\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD2"],
        ["\x82\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD3"],
        ["\x82\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD4"],
        ["\x82\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD5"],
        ["\x82\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD6"],
        ["\x82\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD7"],
        ["\x82\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD8"],
        ["\x82\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xD9"],
        ["\x82\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE2"],
        ["\x82\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE3"],
        ["\x82\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE4"],
        ["\x82\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE5"],
        ["\x82\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE6"],
        ["\x82\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE7"],
        ["\x82\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE8"],
        ["\x82\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE9"],
        ["\x82\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x81"],
        ["\x82\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x82"],
        ["\x82\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x83"],
        ["\x82\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x84"],
        ["\x82\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x85"],
        ["\x82\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x86"],
        ["\x82\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x87"],
        ["\x82\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x88"],
        ["\x82\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x89"],
        ["\x82\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x91"],
        ["\x82\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x92"],
        ["\x82\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x93"],
        ["\x82\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x94"],
        ["\x82\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x95"],
        ["\x82\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x96"],
        ["\x82\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x97"],
        ["\x82\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x98"],
        ["\x82\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x99"],
        ["\x82\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA2"],
        ["\x82\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA3"],
        ["\x82\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA4"],
        ["\x82\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA5"],
        ["\x82\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA6"],
        ["\x82\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA7"],
        ["\x82\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA8"],
        ["\x82\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xA9"],
        ["\x82\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x47"],
        ["\x82\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x81"],
        ["\x82\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x48"],
        ["\x82\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x82"],
        ["\x82\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x49"],
        ["\x82\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x83"],
        ["\x82\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x51"],
        ["\x82\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x84"],
        ["\x82\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x52"],
        ["\x82\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x85"],
        ["\x82\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x86"],
        ["\x82\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC0"],
        ["\x82\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x87"],
        ["\x82\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC1"],
        ["\x82\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x88"],
        ["\x82\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC2"],
        ["\x82\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x89"],
        ["\x82\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC3"],
        ["\x82\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x8A"],
        ["\x82\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC4"],
        ["\x82\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x8C"],
        ["\x82\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC5"],
        ["\x82\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x8D"],
        ["\x82\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC6"],
        ["\x82\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x8E"],
        ["\x82\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC7"],
        ["\x82\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x8F"],
        ["\x82\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC8"],
        ["\x82\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x90"],
        ["\x82\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xC9"],
        ["\x82\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x91"],
        ["\x82\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xCA"],
        ["\x82\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x92"],
        ["\x82\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xCB"],
        ["\x82\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x56"],
        ["\x82\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x93"],
        ["\x82\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xCC"],
        ["\x82\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x94"],
        ["\x82\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xCD"],
        ["\x82\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x95"],
        ["\x82\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xCE"],
        ["\x82\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x96"],
        ["\x82\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x97"],
        ["\x82\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x98"],
        ["\x82\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x99"],
        ["\x82\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x9A"],
        ["\x82\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x9D"],
        ["\x82\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xCF"],
        ["\x82\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD5"],
        ["\x82\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x9E"],
        ["\x82\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD0"],
        ["\x82\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD6"],
        ["\x82\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x9F"],
        ["\x82\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD1"],
        ["\x82\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD7"],
        ["\x82\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA2"],
        ["\x82\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD2"],
        ["\x82\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD8"],
        ["\x82\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA3"],
        ["\x82\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD3"],
        ["\x82\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xD9"],
        ["\x82\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA4"],
        ["\x82\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA5"],
        ["\x82\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA6"],
        ["\x82\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA7"],
        ["\x82\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA8"],
        ["\x82\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x53"],
        ["\x82\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xA9"],
        ["\x82\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x54"],
        ["\x82\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xAA"],
        ["\x82\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x55"],
        ["\x82\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xAC"],
        ["\x82\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xAD"],
        ["\x82\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xAE"],
        ["\x82\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xAF"],
        ["\x82\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xBA"],
        ["\x82\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xBB"],
        ["\x82\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x57"],
        ["\x82\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xBC"],
        ["\x82\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xDA"],
        ["\x82\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xDB"],
        ["\x82\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x46"],
        ["\x82\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\xBD"],
        ["\x83\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x47"],
        ["\x83\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x81"],
        ["\x83\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x48"],
        ["\x83\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x82"],
        ["\x83\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x49"],
        ["\x83\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x83"],
        ["\x83\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x51"],
        ["\x83\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x84"],
        ["\x83\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x52"],
        ["\x83\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x85"],
        ["\x83\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x86"],
        ["\x83\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC0"],
        ["\x83\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x87"],
        ["\x83\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC1"],
        ["\x83\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x88"],
        ["\x83\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC2"],
        ["\x83\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x89"],
        ["\x83\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC3"],
        ["\x83\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x8A"],
        ["\x83\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC4"],
        ["\x83\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x8C"],
        ["\x83\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC5"],
        ["\x83\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x8D"],
        ["\x83\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC6"],
        ["\x83\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x8E"],
        ["\x83\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC7"],
        ["\x83\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x8F"],
        ["\x83\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC8"],
        ["\x83\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x90"],
        ["\x83\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xC9"],
        ["\x83\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x91"],
        ["\x83\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xCA"],
        ["\x83\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x92"],
        ["\x83\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xCB"],
        ["\x83\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x56"],
        ["\x83\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x93"],
        ["\x83\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xCC"],
        ["\x83\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x94"],
        ["\x83\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xCD"],
        ["\x83\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x95"],
        ["\x83\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xCE"],
        ["\x83\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x96"],
        ["\x83\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x97"],
        ["\x83\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x98"],
        ["\x83\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x99"],
        ["\x83\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x9A"],
        ["\x83\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x9D"],
        ["\x83\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xCF"],
        ["\x83\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD5"],
        ["\x83\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x9E"],
        ["\x83\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD0"],
        ["\x83\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD6"],
        ["\x83\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x9F"],
        ["\x83\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD1"],
        ["\x83\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD7"],
        ["\x83\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA2"],
        ["\x83\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD2"],
        ["\x83\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD8"],
        ["\x83\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA3"],
        ["\x83\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD3"],
        ["\x83\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD9"],
        ["\x83\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA4"],
        ["\x83\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA5"],
        ["\x83\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA6"],
        ["\x83\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA7"],
        ["\x83\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA8"],
        ["\x83\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x53"],
        ["\x83\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xA9"],
        ["\x83\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x54"],
        ["\x83\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xAA"],
        ["\x83\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x55"],
        ["\x83\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xAC"],
        ["\x83\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xAD"],
        ["\x83\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xAE"],
        ["\x83\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xAF"],
        ["\x83\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xBA"],
        ["\x83\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xBB"],
        ["\x83\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x57"],
        ["\x83\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xBC"],
        ["\x83\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xDA"],
        ["\x83\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xDB"],
        ["\x83\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x46"],
        ["\x83\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xBD"],
        ["\x83\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xD4"],
        ["\x83\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x59"],
        ["\x83\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x5A"],
        ["\x83\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x61"],
        ["\x83\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x62"],
        ["\x83\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x63"],
        ["\x83\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x64"],
        ["\x83\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x65"],
        ["\x83\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x66"],
        ["\x83\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x67"],
        ["\x83\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x68"],
        ["\x83\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x69"],
        ["\x83\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x6A"],
        ["\x83\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x6B"],
        ["\x83\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x6C"],
        ["\x83\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x6D"],
        ["\x83\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x6E"],
        ["\x83\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x6F"],
        ["\x83\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x70"],
        ["\x83\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x71"],
        ["\x83\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x72"],
        ["\x83\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x73"],
        ["\x83\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x74"],
        ["\x83\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x75"],
        ["\x83\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x76"],
        ["\x83\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x77"],
        ["\x83\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x78"],
        ["\x83\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x41"],
        ["\x83\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x42"],
        ["\x83\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x43"],
        ["\x83\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x44"],
        ["\x83\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x45"],
        ["\x83\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x46"],
        ["\x83\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x47"],
        ["\x83\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x48"],
        ["\x83\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x49"],
        ["\x83\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x4A"],
        ["\x83\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x4B"],
        ["\x83\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x4C"],
        ["\x83\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x4D"],
        ["\x83\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x4E"],
        ["\x83\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x4F"],
        ["\x83\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x50"],
        ["\x83\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x51"],
        ["\x83\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x52"],
        ["\x83\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x53"],
        ["\x83\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x54"],
        ["\x83\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x55"],
        ["\x83\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x56"],
        ["\x83\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x57"],
        ["\x83\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x58"],
        ["\x84\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC0"],
        ["\x84\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC1"],
        ["\x84\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC2"],
        ["\x84\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC3"],
        ["\x84\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC4"],
        ["\x84\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC5"],
        ["\x84\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC6"],
        ["\x84\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC7"],
        ["\x84\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC8"],
        ["\x84\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xC9"],
        ["\x84\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xCA"],
        ["\x84\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xCB"],
        ["\x84\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xCC"],
        ["\x84\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xCD"],
        ["\x84\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xCE"],
        ["\x84\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xCF"],
        ["\x84\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD0"],
        ["\x84\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD1"],
        ["\x84\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD2"],
        ["\x84\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD3"],
        ["\x84\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD4"],
        ["\x84\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD5"],
        ["\x84\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD6"],
        ["\x84\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD7"],
        ["\x84\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD8"],
        ["\x84\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xD9"],
        ["\x84\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xDA"],
        ["\x84\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xDB"],
        ["\x84\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xDC"],
        ["\x84\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xDD"],
        ["\x84\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xDE"],
        ["\x84\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xDF"],
        ["\x84\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xE0"],
        ["\x84\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x80"],
        ["\x84\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x81"],
        ["\x84\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x82"],
        ["\x84\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x83"],
        ["\x84\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x84"],
        ["\x84\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x85"],
        ["\x84\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x86"],
        ["\x84\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x87"],
        ["\x84\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x88"],
        ["\x84\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x89"],
        ["\x84\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x8A"],
        ["\x84\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x8B"],
        ["\x84\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x8C"],
        ["\x84\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x8D"],
        ["\x84\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x8E"],
        ["\x84\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x8F"],
        ["\x84\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x90"],
        ["\x84\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x91"],
        ["\x84\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x92"],
        ["\x84\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x93"],
        ["\x84\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x94"],
        ["\x84\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x95"],
        ["\x84\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x96"],
        ["\x84\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x97"],
        ["\x84\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x98"],
        ["\x84\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x99"],
        ["\x84\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x9A"],
        ["\x84\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x9B"],
        ["\x84\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x9C"],
        ["\x84\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x9D"],
        ["\x84\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x9E"],
        ["\x84\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\x9F"],
        ["\x84\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xA0"],
        ["\x84\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x7C"],
        ["\x84\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x7D"],
        ["\x84\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x7E"],
        ["\x84\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\x7F"],
        ["\x84\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB0"],
        ["\x84\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB1"],
        ["\x84\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB2"],
        ["\x84\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB3"],
        ["\x84\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB4"],
        ["\x84\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB5"],
        ["\x84\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB6"],
        ["\x84\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB7"],
        ["\x84\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB8"],
        ["\x84\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xB9"],
        ["\x84\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE1"],
        ["\x84\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE2"],
        ["\x84\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE3"],
        ["\x84\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE4"],
        ["\x84\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE5"],
        ["\x84\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE6"],
        ["\x84\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE7"],
        ["\x84\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE8"],
        ["\x84\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xE9"],
        ["\x84\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xEA"],
        ["\x84\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xEB"],
        ["\x84\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xEC"],
        ["\x84\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xED"],
        ["\x84\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xEE"],
        ["\x84\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xEF"],
        ["\x84\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xF0"],
        ["\x84\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xF1"],
        ["\x84\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x43\xF2"],
        ["\x87\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x70"],
        ["\x87\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x71"],
        ["\x87\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x72"],
        ["\x87\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x73"],
        ["\x87\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x74"],
        ["\x87\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x75"],
        ["\x87\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x76"],
        ["\x87\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x77"],
        ["\x87\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x78"],
        ["\x87\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x79"],
        ["\x87\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x7A"],
        ["\x87\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x7B"],
        ["\x87\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x7C"],
        ["\x87\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x7D"],
        ["\x87\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x7E"],
        ["\x87\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x7F"],
        ["\x87\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x80"],
        ["\x87\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x81"],
        ["\x87\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x82"],
        ["\x87\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\x83"],
        ["\x87\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF1"],
        ["\x87\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF2"],
        ["\x87\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF3"],
        ["\x87\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF4"],
        ["\x87\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF5"],
        ["\x87\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF6"],
        ["\x87\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF7"],
        ["\x87\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF8"],
        ["\x87\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xF9"],
        ["\x87\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xFA"],
        ["\x87\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xAA"],
        ["\x87\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x75"],
        ["\x87\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x83"],
        ["\x87\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xAE"],
        ["\x87\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x79"],
        ["\x87\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x88"],
        ["\x87\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x64"],
        ["\x87\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x97"],
        ["\x87\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xB2"],
        ["\x87\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xB8"],
        ["\x87\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x6E"],
        ["\x87\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x87"],
        ["\x87\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x84"],
        ["\x87\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x8C"],
        ["\x87\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xAB"],
        ["\x87\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\x9C"],
        ["\x87\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xF9"],
        ["\x87\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xFA"],
        ["\x87\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xFB"],
        ["\x87\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xEB"],
        ["\x87\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xEC"],
        ["\x87\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE9\x63"],
        ["\x87\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xFE"],
        ["\x87\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xD8"],
        ["\x87\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xAC"],
        ["\x87\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xAE"],
        ["\x87\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x6E"],
        ["\x87\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE9\x6C"],
        ["\x87\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x6F"],
        ["\x87\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x67"],
        ["\x87\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x68"],
        ["\x87\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x69"],
        ["\x87\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x6A"],
        ["\x87\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x6B"],
        ["\x87\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x6D"],
        ["\x87\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xEF"],
        ["\x87\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xF6"],
        ["\x87\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xDB"],
        ["\x87\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xDA"],
        ["\x87\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE8\xD9"],
        ["\x87\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xE8"],
        ["\x87\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xE0"],
        ["\x87\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xAC"],
        ["\x88\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x67"],
        ["\x88\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD4"],
        ["\x88\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x7A"],
        ["\x88\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xAE"],
        ["\x88\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF9"],
        ["\x88\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC6"],
        ["\x88\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x81"],
        ["\x88\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x79"],
        ["\x88\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xCE"],
        ["\x88\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD9"],
        ["\x88\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE2"],
        ["\x88\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x9B"],
        ["\x88\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x65"],
        ["\x88\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x60"],
        ["\x88\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x43"],
        ["\x88\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xEC"],
        ["\x88\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x72"],
        ["\x88\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xDD"],
        ["\x88\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xAA"],
        ["\x88\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xDA"],
        ["\x88\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x82"],
        ["\x88\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x81"],
        ["\x88\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x69"],
        ["\x88\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xAB"],
        ["\x88\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x9C"],
        ["\x88\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x44"],
        ["\x88\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x45"],
        ["\x88\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF7"],
        ["\x88\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xDC"],
        ["\x88\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x8E"],
        ["\x88\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x7F"],
        ["\x88\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xFB"],
        ["\x88\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x48"],
        ["\x88\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA8"],
        ["\x88\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xEB"],
        ["\x88\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x89"],
        ["\x88\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE2"],
        ["\x88\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF1"],
        ["\x88\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x64"],
        ["\x88\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x4C"],
        ["\x88\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD0"],
        ["\x88\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF6"],
        ["\x88\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB2"],
        ["\x88\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC8"],
        ["\x88\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x9E"],
        ["\x88\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xFB"],
        ["\x88\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xFA"],
        ["\x88\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x47"],
        ["\x88\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x4F"],
        ["\x88\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x65"],
        ["\x88\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x89"],
        ["\x88\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE0"],
        ["\x88\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x63"],
        ["\x88\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xAD"],
        ["\x88\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE9"],
        ["\x88\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF7"],
        ["\x88\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD7"],
        ["\x88\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x8F"],
        ["\x88\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA9"],
        ["\x88\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x75"],
        ["\x88\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x80"],
        ["\x88\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x9A"],
        ["\x88\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF6"],
        ["\x88\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x82"],
        ["\x88\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xEA"],
        ["\x88\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x73"],
        ["\x88\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xBC"],
        ["\x88\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xDA"],
        ["\x88\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x87"],
        ["\x88\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x6D"],
        ["\x88\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x7F"],
        ["\x88\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE9"],
        ["\x88\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xAC"],
        ["\x88\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB3"],
        ["\x88\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xAA"],
        ["\x88\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x41"],
        ["\x88\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB0"],
        ["\x88\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x71"],
        ["\x88\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD6"],
        ["\x88\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x6A"],
        ["\x88\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x4C"],
        ["\x88\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x9A"],
        ["\x88\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC8"],
        ["\x88\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x91"],
        ["\x88\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x99"],
        ["\x88\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB1"],
        ["\x88\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xCB"],
        ["\x88\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x49"],
        ["\x88\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB9"],
        ["\x88\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xDA"],
        ["\x88\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA3"],
        ["\x88\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x4E"],
        ["\x88\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE9"],
        ["\x88\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x8B"],
        ["\x89\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD8"],
        ["\x89\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD2"],
        ["\x89\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xAE"],
        ["\x89\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x77"],
        ["\x89\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xBC"],
        ["\x89\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x5A"],
        ["\x89\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD5"],
        ["\x89\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x99"],
        ["\x89\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x8F"],
        ["\x89\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xDF"],
        ["\x89\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xDD"],
        ["\x89\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x82"],
        ["\x89\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE7"],
        ["\x89\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x9E"],
        ["\x89\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xEC"],
        ["\x89\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB1"],
        ["\x89\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x89"],
        ["\x89\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA0"],
        ["\x89\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF3"],
        ["\x89\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xDB"],
        ["\x89\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF7"],
        ["\x89\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x9A"],
        ["\x89\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xAB"],
        ["\x89\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x55"],
        ["\x89\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x67"],
        ["\x89\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x6B"],
        ["\x89\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x64"],
        ["\x89\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x5F"],
        ["\x89\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x9B"],
        ["\x89\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x9D"],
        ["\x89\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xAB"],
        ["\x89\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xBC"],
        ["\x89\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x5F"],
        ["\x89\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA7"],
        ["\x89\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x94"],
        ["\x89\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD3"],
        ["\x89\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE8"],
        ["\x89\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x5E"],
        ["\x89\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xAC"],
        ["\x89\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xBC"],
        ["\x89\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xFA"],
        ["\x89\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xFB"],
        ["\x89\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x57"],
        ["\x89\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB7"],
        ["\x89\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x52"],
        ["\x89\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB5"],
        ["\x89\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x54"],
        ["\x89\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x76"],
        ["\x89\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xEE"],
        ["\x89\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x80"],
        ["\x89\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC1"],
        ["\x89\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x6F"],
        ["\x89\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x45"],
        ["\x89\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xCE"],
        ["\x89\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x74"],
        ["\x89\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xAC"],
        ["\x89\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x73"],
        ["\x89\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE5"],
        ["\x89\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xDF"],
        ["\x89\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x77"],
        ["\x89\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xEB"],
        ["\x89\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB7"],
        ["\x89\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x45"],
        ["\x89\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE1"],
        ["\x89\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA4"],
        ["\x89\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF2"],
        ["\x89\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x78"],
        ["\x89\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD0"],
        ["\x89\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xDE"],
        ["\x89\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD0"],
        ["\x89\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD5"],
        ["\x89\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x6F"],
        ["\x89\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xED"],
        ["\x89\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xAD"],
        ["\x89\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xEE"],
        ["\x89\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xDD"],
        ["\x89\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x47"],
        ["\x89\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x5A"],
        ["\x89\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xAA"],
        ["\x89\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x54"],
        ["\x89\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x4B"],
        ["\x89\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xEC"],
        ["\x89\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE3"],
        ["\x89\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD4"],
        ["\x89\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC3"],
        ["\x89\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x43"],
        ["\x89\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA4"],
        ["\x89\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x82"],
        ["\x89\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD7"],
        ["\x89\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE6"],
        ["\x89\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x92"],
        ["\x89\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE5"],
        ["\x89\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xEA"],
        ["\x89\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x95"],
        ["\x89\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE1"],
        ["\x89\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA3"],
        ["\x89\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF2"],
        ["\x89\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA0"],
        ["\x89\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x59"],
        ["\x89\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB1"],
        ["\x89\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xFB"],
        ["\x89\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x6C"],
        ["\x89\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD0"],
        ["\x89\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x64"],
        ["\x89\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC6"],
        ["\x89\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x72"],
        ["\x89\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xFD"],
        ["\x89\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE0"],
        ["\x89\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x4E"],
        ["\x89\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE9"],
        ["\x89\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x6C"],
        ["\x89\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x74"],
        ["\x89\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x77"],
        ["\x89\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x9A"],
        ["\x89\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xBD"],
        ["\x89\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x67"],
        ["\x89\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x79"],
        ["\x89\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x81"],
        ["\x89\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x50"],
        ["\x89\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB8"],
        ["\x89\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x4D"],
        ["\x89\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x5F"],
        ["\x89\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x90"],
        ["\x89\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x71"],
        ["\x89\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x70"],
        ["\x89\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x61"],
        ["\x89\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x5A"],
        ["\x89\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x76"],
        ["\x89\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x9F"],
        ["\x89\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC6"],
        ["\x89\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x7E"],
        ["\x89\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x7E"],
        ["\x89\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x89"],
        ["\x89\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x86"],
        ["\x89\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB8"],
        ["\x89\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xED"],
        ["\x89\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x46"],
        ["\x89\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB9"],
        ["\x89\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE8"],
        ["\x89\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF7"],
        ["\x89\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x5A"],
        ["\x89\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x85"],
        ["\x89\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x9A"],
        ["\x89\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x86"],
        ["\x89\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x63"],
        ["\x89\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xBE"],
        ["\x89\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x51"],
        ["\x89\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD9"],
        ["\x89\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x77"],
        ["\x89\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x7A"],
        ["\x89\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA1"],
        ["\x89\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x6C"],
        ["\x89\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x51"],
        ["\x89\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC3"],
        ["\x89\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD6"],
        ["\x89\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xCA"],
        ["\x89\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xEB"],
        ["\x89\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x5D"],
        ["\x89\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x8D"],
        ["\x89\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE4"],
        ["\x89\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xAA"],
        ["\x89\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC7"],
        ["\x89\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x9D"],
        ["\x89\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xDE"],
        ["\x89\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xFC"],
        ["\x89\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x77"],
        ["\x89\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x8A"],
        ["\x89\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xBA"],
        ["\x89\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x99"],
        ["\x89\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x41"],
        ["\x89\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x45"],
        ["\x89\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x4B"],
        ["\x89\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xBE"],
        ["\x89\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x4B"],
        ["\x89\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xBD"],
        ["\x89\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB7"],
        ["\x89\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA9"],
        ["\x89\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x53"],
        ["\x89\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC8"],
        ["\x89\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xAF"],
        ["\x89\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x60"],
        ["\x89\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x71"],
        ["\x89\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x91"],
        ["\x89\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x94"],
        ["\x89\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF2"],
        ["\x89\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA0"],
        ["\x89\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA2"],
        ["\x89\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x8F"],
        ["\x8A\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xCB"],
        ["\x8A\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x6D"],
        ["\x8A\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x82"],
        ["\x8A\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA7"],
        ["\x8A\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF5"],
        ["\x8A\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xAE"],
        ["\x8A\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB0"],
        ["\x8A\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE4"],
        ["\x8A\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x7B"],
        ["\x8A\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x90"],
        ["\x8A\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xCD"],
        ["\x8A\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA9"],
        ["\x8A\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xEA"],
        ["\x8A\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xAC"],
        ["\x8A\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x6A"],
        ["\x8A\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x94"],
        ["\x8A\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE9"],
        ["\x8A\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x68"],
        ["\x8A\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x74"],
        ["\x8A\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x8A"],
        ["\x8A\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x42"],
        ["\x8A\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x91"],
        ["\x8A\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x56"],
        ["\x8A\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x6D"],
        ["\x8A\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA5"],
        ["\x8A\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x8D"],
        ["\x8A\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x6D"],
        ["\x8A\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x9C"],
        ["\x8A\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xCC"],
        ["\x8A\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x85"],
        ["\x8A\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xBB"],
        ["\x8A\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xCE"],
        ["\x8A\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC1"],
        ["\x8A\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE1"],
        ["\x8A\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x8F"],
        ["\x8A\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD6"],
        ["\x8A\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD8"],
        ["\x8A\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xBA"],
        ["\x8A\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xAD"],
        ["\x8A\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE5"],
        ["\x8A\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x52"],
        ["\x8A\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xDE"],
        ["\x8A\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x9E"],
        ["\x8A\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC0"],
        ["\x8A\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x61"],
        ["\x8A\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x7A"],
        ["\x8A\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x5C"],
        ["\x8A\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x4C"],
        ["\x8A\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x7D"],
        ["\x8A\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xCC"],
        ["\x8A\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x5A"],
        ["\x8A\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x62"],
        ["\x8A\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE9"],
        ["\x8A\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x5A"],
        ["\x8A\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA3"],
        ["\x8A\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xBE"],
        ["\x8A\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x46"],
        ["\x8A\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x61"],
        ["\x8A\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF1"],
        ["\x8A\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x8E"],
        ["\x8A\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE3"],
        ["\x8A\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE0"],
        ["\x8A\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x6F"],
        ["\x8A\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB2"],
        ["\x8A\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xAD"],
        ["\x8A\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x71"],
        ["\x8A\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC2"],
        ["\x8A\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD6"],
        ["\x8A\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x75"],
        ["\x8A\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x84"],
        ["\x8A\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC5"],
        ["\x8A\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB4"],
        ["\x8A\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x41"],
        ["\x8A\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA2"],
        ["\x8A\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xDF"],
        ["\x8A\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x5E"],
        ["\x8A\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xFE"],
        ["\x8A\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x97"],
        ["\x8A\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD5"],
        ["\x8A\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x59"],
        ["\x8A\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x63"],
        ["\x8A\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x69"],
        ["\x8A\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x45"],
        ["\x8A\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x56"],
        ["\x8A\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xBE"],
        ["\x8A\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x46"],
        ["\x8A\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB2"],
        ["\x8A\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xCC"],
        ["\x8A\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x62"],
        ["\x8A\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x7D"],
        ["\x8A\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x54"],
        ["\x8A\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x42"],
        ["\x8A\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD3"],
        ["\x8A\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x7C"],
        ["\x8A\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xAB"],
        ["\x8A\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x9B"],
        ["\x8A\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x5D"],
        ["\x8A\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC2"],
        ["\x8A\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x70"],
        ["\x8A\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x98"],
        ["\x8A\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x7B"],
        ["\x8A\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x81"],
        ["\x8A\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD7"],
        ["\x8A\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x9A"],
        ["\x8A\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x7E"],
        ["\x8A\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x93"],
        ["\x8A\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB5"],
        ["\x8A\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xAC"],
        ["\x8A\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xDE"],
        ["\x8A\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC5"],
        ["\x8A\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA2"],
        ["\x8A\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF8"],
        ["\x8A\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x6F"],
        ["\x8A\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xDA"],
        ["\x8A\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xEB"],
        ["\x8A\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF7"],
        ["\x8A\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD3"],
        ["\x8A\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA5"],
        ["\x8A\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xAA"],
        ["\x8A\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xCF"],
        ["\x8A\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC1"],
        ["\x8A\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x6D"],
        ["\x8A\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB6"],
        ["\x8A\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xFB"],
        ["\x8A\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x4E"],
        ["\x8A\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC4"],
        ["\x8A\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x58"],
        ["\x8A\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xBA"],
        ["\x8A\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xAA"],
        ["\x8A\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB9"],
        ["\x8A\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x55"],
        ["\x8A\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE3"],
        ["\x8A\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA2"],
        ["\x8A\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x87"],
        ["\x8A\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF2"],
        ["\x8A\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xEC"],
        ["\x8A\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xFC"],
        ["\x8A\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x84"],
        ["\x8A\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB6"],
        ["\x8A\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x8C"],
        ["\x8A\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x4A"],
        ["\x8A\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xEE"],
        ["\x8A\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x7E"],
        ["\x8A\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE0"],
        ["\x8A\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA1"],
        ["\x8A\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA9"],
        ["\x8A\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x4E"],
        ["\x8A\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC1"],
        ["\x8A\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD9"],
        ["\x8A\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC5"],
        ["\x8A\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xFE"],
        ["\x8A\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x75"],
        ["\x8A\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x62"],
        ["\x8A\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xAA"],
        ["\x8A\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x7A"],
        ["\x8A\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xCB"],
        ["\x8A\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x48"],
        ["\x8A\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xCF"],
        ["\x8A\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x4C"],
        ["\x8A\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x47"],
        ["\x8A\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA5"],
        ["\x8A\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xBF"],
        ["\x8A\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x8B"],
        ["\x8A\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x84"],
        ["\x8A\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA4"],
        ["\x8A\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x9D"],
        ["\x8A\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB8"],
        ["\x8A\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x57"],
        ["\x8A\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD2"],
        ["\x8A\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x9F"],
        ["\x8A\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x91"],
        ["\x8A\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD1"],
        ["\x8A\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xFC"],
        ["\x8A\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF1"],
        ["\x8A\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x69"],
        ["\x8A\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x8B"],
        ["\x8A\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xDF"],
        ["\x8A\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x4A"],
        ["\x8A\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB5"],
        ["\x8A\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x57"],
        ["\x8A\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x97"],
        ["\x8A\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF2"],
        ["\x8A\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x96"],
        ["\x8A\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xAB"],
        ["\x8A\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x77"],
        ["\x8A\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x8B"],
        ["\x8A\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF1"],
        ["\x8A\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB1"],
        ["\x8B\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x79"],
        ["\x8B\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x82"],
        ["\x8B\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x5B"],
        ["\x8B\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB9"],
        ["\x8B\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x4C"],
        ["\x8B\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD4"],
        ["\x8B\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD8"],
        ["\x8B\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xEC"],
        ["\x8B\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x64"],
        ["\x8B\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xDB"],
        ["\x8B\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE0"],
        ["\x8B\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xFB"],
        ["\x8B\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x94"],
        ["\x8B\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x7F"],
        ["\x8B\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD0"],
        ["\x8B\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xAA"],
        ["\x8B\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x87"],
        ["\x8B\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xCE"],
        ["\x8B\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x58"],
        ["\x8B\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC8"],
        ["\x8B\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC0"],
        ["\x8B\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x59"],
        ["\x8B\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xCA"],
        ["\x8B\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x95"],
        ["\x8B\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x8B"],
        ["\x8B\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x92"],
        ["\x8B\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF7"],
        ["\x8B\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xCD"],
        ["\x8B\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x7D"],
        ["\x8B\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xDC"],
        ["\x8B\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB4"],
        ["\x8B\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x92"],
        ["\x8B\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x98"],
        ["\x8B\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC6"],
        ["\x8B\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x65"],
        ["\x8B\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x81"],
        ["\x8B\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x41"],
        ["\x8B\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD7"],
        ["\x8B\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xED"],
        ["\x8B\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x7E"],
        ["\x8B\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xEA"],
        ["\x8B\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x6D"],
        ["\x8B\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x4B"],
        ["\x8B\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC2"],
        ["\x8B\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x5F"],
        ["\x8B\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x48"],
        ["\x8B\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA6"],
        ["\x8B\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xAE"],
        ["\x8B\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA4"],
        ["\x8B\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xDE"],
        ["\x8B\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x5C"],
        ["\x8B\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x60"],
        ["\x8B\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xFC"],
        ["\x8B\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x56"],
        ["\x8B\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x8A"],
        ["\x8B\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x85"],
        ["\x8B\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x81"],
        ["\x8B\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x5C"],
        ["\x8B\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x98"],
        ["\x8B\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x92"],
        ["\x8B\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x63"],
        ["\x8B\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xCC"],
        ["\x8B\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x5C"],
        ["\x8B\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF0"],
        ["\x8B\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA0"],
        ["\x8B\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC8"],
        ["\x8B\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x4B"],
        ["\x8B\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x73"],
        ["\x8B\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xDB"],
        ["\x8B\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x86"],
        ["\x8B\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xAA"],
        ["\x8B\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xCF"],
        ["\x8B\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF3"],
        ["\x8B\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xFE"],
        ["\x8B\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x57"],
        ["\x8B\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x7B"],
        ["\x8B\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x73"],
        ["\x8B\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xCA"],
        ["\x8B\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x5E"],
        ["\x8B\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x52"],
        ["\x8B\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x61"],
        ["\x8B\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x77"],
        ["\x8B\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x82"],
        ["\x8B\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x7A"],
        ["\x8B\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x72"],
        ["\x8B\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x9A"],
        ["\x8B\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC2"],
        ["\x8B\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE7"],
        ["\x8B\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x78"],
        ["\x8B\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xAA"],
        ["\x8B\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xEE"],
        ["\x8B\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xAC"],
        ["\x8B\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x73"],
        ["\x8B\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x75"],
        ["\x8B\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xBC"],
        ["\x8B\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xEC"],
        ["\x8B\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xAD"],
        ["\x8B\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x5A"],
        ["\x8B\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x71"],
        ["\x8B\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB3"],
        ["\x8B\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xEC"],
        ["\x8B\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD7"],
        ["\x8B\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x4D"],
        ["\x8B\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE2"],
        ["\x8B\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD5"],
        ["\x8B\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x5F"],
        ["\x8B\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x95"],
        ["\x8B\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB3"],
        ["\x8B\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD2"],
        ["\x8B\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x85"],
        ["\x8B\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x42"],
        ["\x8B\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD5"],
        ["\x8B\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x4E"],
        ["\x8B\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB1"],
        ["\x8B\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA5"],
        ["\x8B\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x89"],
        ["\x8B\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x58"],
        ["\x8B\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x5A"],
        ["\x8B\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x9E"],
        ["\x8B\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xBB"],
        ["\x8B\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE3"],
        ["\x8B\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x51"],
        ["\x8B\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x6A"],
        ["\x8B\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x65"],
        ["\x8B\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x95"],
        ["\x8B\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x8D"],
        ["\x8B\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x5C"],
        ["\x8B\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD5"],
        ["\x8B\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD5"],
        ["\x8B\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xED"],
        ["\x8B\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD9"],
        ["\x8B\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x80"],
        ["\x8B\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x83"],
        ["\x8B\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x6B"],
        ["\x8B\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x8B"],
        ["\x8B\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB6"],
        ["\x8B\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB7"],
        ["\x8B\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xFD"],
        ["\x8B\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC0"],
        ["\x8B\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE7"],
        ["\x8B\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC9"],
        ["\x8B\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x9F"],
        ["\x8B\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xAE"],
        ["\x8B\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x7D"],
        ["\x8B\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x8E"],
        ["\x8B\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xCF"],
        ["\x8B\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x9D"],
        ["\x8B\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF8"],
        ["\x8B\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD8"],
        ["\x8B\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x75"],
        ["\x8B\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x5D"],
        ["\x8B\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x8F"],
        ["\x8B\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x97"],
        ["\x8B\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD0"],
        ["\x8B\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x73"],
        ["\x8B\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA7"],
        ["\x8B\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xAF"],
        ["\x8B\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x87"],
        ["\x8B\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x73"],
        ["\x8B\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x86"],
        ["\x8B\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x7A"],
        ["\x8B\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x8C"],
        ["\x8B\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x49"],
        ["\x8B\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x63"],
        ["\x8B\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x8B"],
        ["\x8B\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x54"],
        ["\x8B\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x74"],
        ["\x8B\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE9"],
        ["\x8B\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x4D"],
        ["\x8B\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x5F"],
        ["\x8B\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x53"],
        ["\x8B\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xFE"],
        ["\x8B\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x85"],
        ["\x8B\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xFC"],
        ["\x8B\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xAF"],
        ["\x8B\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB2"],
        ["\x8B\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x88"],
        ["\x8B\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB9"],
        ["\x8B\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x8D"],
        ["\x8B\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC3"],
        ["\x8B\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF4"],
        ["\x8B\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xEC"],
        ["\x8B\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB9"],
        ["\x8B\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB8"],
        ["\x8B\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA6"],
        ["\x8B\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF0"],
        ["\x8B\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB2"],
        ["\x8B\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x94"],
        ["\x8C\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x44"],
        ["\x8C\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA6"],
        ["\x8C\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF8"],
        ["\x8C\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF1"],
        ["\x8C\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE1"],
        ["\x8C\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x65"],
        ["\x8C\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x7F"],
        ["\x8C\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE5"],
        ["\x8C\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x85"],
        ["\x8C\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x9B"],
        ["\x8C\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x69"],
        ["\x8C\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x79"],
        ["\x8C\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x70"],
        ["\x8C\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x7A"],
        ["\x8C\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xCF"],
        ["\x8C\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x98"],
        ["\x8C\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC8"],
        ["\x8C\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB1"],
        ["\x8C\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x97"],
        ["\x8C\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x9E"],
        ["\x8C\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xDB"],
        ["\x8C\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x6A"],
        ["\x8C\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD2"],
        ["\x8C\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x51"],
        ["\x8C\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x43"],
        ["\x8C\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x52"],
        ["\x8C\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE8"],
        ["\x8C\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE4"],
        ["\x8C\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE6"],
        ["\x8C\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB9"],
        ["\x8C\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE6"],
        ["\x8C\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x64"],
        ["\x8C\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x90"],
        ["\x8C\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x60"],
        ["\x8C\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x43"],
        ["\x8C\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA8"],
        ["\x8C\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB6"],
        ["\x8C\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x75"],
        ["\x8C\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC1"],
        ["\x8C\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x49"],
        ["\x8C\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB0"],
        ["\x8C\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x93"],
        ["\x8C\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xAB"],
        ["\x8C\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x98"],
        ["\x8C\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB4"],
        ["\x8C\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC7"],
        ["\x8C\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xFA"],
        ["\x8C\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x88"],
        ["\x8C\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x4A"],
        ["\x8C\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x73"],
        ["\x8C\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xEF"],
        ["\x8C\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC9"],
        ["\x8C\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB3"],
        ["\x8C\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF9"],
        ["\x8C\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC9"],
        ["\x8C\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xFB"],
        ["\x8C\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD7"],
        ["\x8C\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA6"],
        ["\x8C\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC4"],
        ["\x8C\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x8E"],
        ["\x8C\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x53"],
        ["\x8C\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA9"],
        ["\x8C\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x78"],
        ["\x8C\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF0"],
        ["\x8C\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD9"],
        ["\x8C\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x74"],
        ["\x8C\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD0"],
        ["\x8C\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC3"],
        ["\x8C\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD6"],
        ["\x8C\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC3"],
        ["\x8C\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB5"],
        ["\x8C\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA4"],
        ["\x8C\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC2"],
        ["\x8C\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x86"],
        ["\x8C\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xBF"],
        ["\x8C\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x43"],
        ["\x8C\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xCC"],
        ["\x8C\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x61"],
        ["\x8C\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB2"],
        ["\x8C\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xFA"],
        ["\x8C\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF1"],
        ["\x8C\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x81"],
        ["\x8C\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF4"],
        ["\x8C\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x6B"],
        ["\x8C\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD3"],
        ["\x8C\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD3"],
        ["\x8C\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x49"],
        ["\x8C\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE7"],
        ["\x8C\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC3"],
        ["\x8C\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x66"],
        ["\x8C\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xBE"],
        ["\x8C\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC6"],
        ["\x8C\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x8D"],
        ["\x8C\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x93"],
        ["\x8C\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x6D"],
        ["\x8C\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xDC"],
        ["\x8C\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x8A"],
        ["\x8C\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC5"],
        ["\x8C\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x45"],
        ["\x8C\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD3"],
        ["\x8C\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x69"],
        ["\x8C\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF6"],
        ["\x8C\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x52"],
        ["\x8C\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x79"],
        ["\x8C\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xBB"],
        ["\x8C\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x7C"],
        ["\x8C\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE5"],
        ["\x8C\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x55"],
        ["\x8C\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC2"],
        ["\x8C\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x45"],
        ["\x8C\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x6C"],
        ["\x8C\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE5"],
        ["\x8C\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB4"],
        ["\x8C\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x7D"],
        ["\x8C\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x95"],
        ["\x8C\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x74"],
        ["\x8C\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x8E"],
        ["\x8C\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA2"],
        ["\x8C\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x42"],
        ["\x8C\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x8A"],
        ["\x8C\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xFC"],
        ["\x8C\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x6E"],
        ["\x8C\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB7"],
        ["\x8C\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x63"],
        ["\x8C\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xAC"],
        ["\x8C\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x9A"],
        ["\x8C\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xAB"],
        ["\x8C\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xAD"],
        ["\x8C\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA5"],
        ["\x8C\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xFA"],
        ["\x8C\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD4"],
        ["\x8C\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF6"],
        ["\x8C\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x94"],
        ["\x8C\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF2"],
        ["\x8C\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xAF"],
        ["\x8C\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xAD"],
        ["\x8C\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF8"],
        ["\x8C\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x6B"],
        ["\x8C\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xCF"],
        ["\x8C\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF7"],
        ["\x8C\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x61"],
        ["\x8C\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x52"],
        ["\x8C\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xDB"],
        ["\x8C\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x71"],
        ["\x8C\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x5A"],
        ["\x8C\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC5"],
        ["\x8C\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x63"],
        ["\x8C\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x6D"],
        ["\x8C\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xAB"],
        ["\x8C\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB4"],
        ["\x8C\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xCB"],
        ["\x8C\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xBF"],
        ["\x8C\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x4D"],
        ["\x8C\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xEE"],
        ["\x8C\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xAF"],
        ["\x8C\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x45"],
        ["\x8C\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x74"],
        ["\x8C\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x99"],
        ["\x8C\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xDF"],
        ["\x8C\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xEE"],
        ["\x8C\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF6"],
        ["\x8C\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB5"],
        ["\x8C\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE5"],
        ["\x8C\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x98"],
        ["\x8C\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB1"],
        ["\x8C\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD3"],
        ["\x8C\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xEE"],
        ["\x8C\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF1"],
        ["\x8C\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x4E"],
        ["\x8C\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE7"],
        ["\x8C\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x91"],
        ["\x8C\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xDB"],
        ["\x8C\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x70"],
        ["\x8C\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB5"],
        ["\x8C\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC6"],
        ["\x8C\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x8E"],
        ["\x8C\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x62"],
        ["\x8C\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE3"],
        ["\x8C\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xAE"],
        ["\x8C\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x43"],
        ["\x8C\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x9E"],
        ["\x8C\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xBB"],
        ["\x8C\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x70"],
        ["\x8C\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x78"],
        ["\x8C\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE9"],
        ["\x8C\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x42"],
        ["\x8C\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x88"],
        ["\x8C\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA5"],
        ["\x8D\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xAF"],
        ["\x8D\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x53"],
        ["\x8D\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF3"],
        ["\x8D\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x66"],
        ["\x8D\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x9E"],
        ["\x8D\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD9"],
        ["\x8D\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF4"],
        ["\x8D\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC8"],
        ["\x8D\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x6A"],
        ["\x8D\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA3"],
        ["\x8D\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xCB"],
        ["\x8D\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA9"],
        ["\x8D\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB7"],
        ["\x8D\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x5A"],
        ["\x8D\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x9A"],
        ["\x8D\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD3"],
        ["\x8D\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC7"],
        ["\x8D\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x8E"],
        ["\x8D\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x67"],
        ["\x8D\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x45"],
        ["\x8D\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xAC"],
        ["\x8D\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC5"],
        ["\x8D\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x99"],
        ["\x8D\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB0"],
        ["\x8D\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x6D"],
        ["\x8D\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x8B"],
        ["\x8D\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xBF"],
        ["\x8D\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xCC"],
        ["\x8D\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x96"],
        ["\x8D\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xAD"],
        ["\x8D\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD4"],
        ["\x8D\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xEB"],
        ["\x8D\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC6"],
        ["\x8D\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x4D"],
        ["\x8D\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA0"],
        ["\x8D\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xBB"],
        ["\x8D\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xEF"],
        ["\x8D\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD5"],
        ["\x8D\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x4B"],
        ["\x8D\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x67"],
        ["\x8D\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x78"],
        ["\x8D\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x6D"],
        ["\x8D\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xCB"],
        ["\x8D\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x9A"],
        ["\x8D\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x60"],
        ["\x8D\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xEB"],
        ["\x8D\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD5"],
        ["\x8D\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x47"],
        ["\x8D\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD8"],
        ["\x8D\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x9F"],
        ["\x8D\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xDC"],
        ["\x8D\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA4"],
        ["\x8D\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xED"],
        ["\x8D\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x6E"],
        ["\x8D\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF1"],
        ["\x8D\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x8F"],
        ["\x8D\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x52"],
        ["\x8D\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x86"],
        ["\x8D\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x63"],
        ["\x8D\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xAF"],
        ["\x8D\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA1"],
        ["\x8D\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x9B"],
        ["\x8D\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE5"],
        ["\x8D\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x97"],
        ["\x8D\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xBD"],
        ["\x8D\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x71"],
        ["\x8D\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD6"],
        ["\x8D\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC7"],
        ["\x8D\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC6"],
        ["\x8D\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE2"],
        ["\x8D\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA0"],
        ["\x8D\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB9"],
        ["\x8D\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB5"],
        ["\x8D\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x80"],
        ["\x8D\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x68"],
        ["\x8D\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA9"],
        ["\x8D\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x61"],
        ["\x8D\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x9E"],
        ["\x8D\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF5"],
        ["\x8D\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x54"],
        ["\x8D\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x8F"],
        ["\x8D\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x94"],
        ["\x8D\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xEB"],
        ["\x8D\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xFD"],
        ["\x8D\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x79"],
        ["\x8D\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x95"],
        ["\x8D\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD0"],
        ["\x8D\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA4"],
        ["\x8D\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x95"],
        ["\x8D\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x56"],
        ["\x8D\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x9D"],
        ["\x8D\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA5"],
        ["\x8D\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xDC"],
        ["\x8D\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x41"],
        ["\x8D\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x4C"],
        ["\x8D\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x46"],
        ["\x8D\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE0"],
        ["\x8D\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x44"],
        ["\x8D\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA6"],
        ["\x8D\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x88"],
        ["\x8D\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x77"],
        ["\x8D\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB8"],
        ["\x8D\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA4"],
        ["\x8D\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE8"],
        ["\x8D\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE7"],
        ["\x8D\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x67"],
        ["\x8D\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x59"],
        ["\x8D\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x46"],
        ["\x8D\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xFD"],
        ["\x8D\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xBD"],
        ["\x8D\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB4"],
        ["\x8D\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA8"],
        ["\x8D\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xDC"],
        ["\x8D\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x76"],
        ["\x8D\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA5"],
        ["\x8D\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB8"],
        ["\x8D\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD3"],
        ["\x8D\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x5B"],
        ["\x8D\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x8B"],
        ["\x8D\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x73"],
        ["\x8D\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xAD"],
        ["\x8D\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x88"],
        ["\x8D\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x5B"],
        ["\x8D\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x76"],
        ["\x8D\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x70"],
        ["\x8D\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x8A"],
        ["\x8D\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x8D"],
        ["\x8D\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB1"],
        ["\x8D\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x8F"],
        ["\x8D\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x58"],
        ["\x8D\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x43"],
        ["\x8D\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xEB"],
        ["\x8D\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF5"],
        ["\x8D\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x6B"],
        ["\x8D\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC1"],
        ["\x8D\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA3"],
        ["\x8D\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD4"],
        ["\x8D\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xCD"],
        ["\x8D\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF1"],
        ["\x8D\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x4F"],
        ["\x8D\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE0"],
        ["\x8D\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE4"],
        ["\x8D\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x69"],
        ["\x8D\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xBC"],
        ["\x8D\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xBF"],
        ["\x8D\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x54"],
        ["\x8D\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC3"],
        ["\x8D\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB4"],
        ["\x8D\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x71"],
        ["\x8D\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xDB"],
        ["\x8D\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x68"],
        ["\x8D\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA8"],
        ["\x8D\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xBD"],
        ["\x8D\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x6E"],
        ["\x8D\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x97"],
        ["\x8D\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x66"],
        ["\x8D\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xCD"],
        ["\x8D\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xBC"],
        ["\x8D\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x4E"],
        ["\x8D\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xAF"],
        ["\x8D\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC9"],
        ["\x8D\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xEC"],
        ["\x8D\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x91"],
        ["\x8D\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x7C"],
        ["\x8D\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x52"],
        ["\x8D\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x51"],
        ["\x8D\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xDE"],
        ["\x8D\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x7F"],
        ["\x8D\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA3"],
        ["\x8D\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD2"],
        ["\x8D\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xAF"],
        ["\x8D\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x94"],
        ["\x8D\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x90"],
        ["\x8D\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x50"],
        ["\x8D\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA3"],
        ["\x8D\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE8"],
        ["\x8D\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA4"],
        ["\x8D\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF1"],
        ["\x8D\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x99"],
        ["\x8D\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC9"],
        ["\x8D\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF4"],
        ["\x8D\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB1"],
        ["\x8D\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x71"],
        ["\x8D\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x91"],
        ["\x8D\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x6E"],
        ["\x8D\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x57"],
        ["\x8D\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA1"],
        ["\x8D\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xCF"],
        ["\x8E\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x93"],
        ["\x8E\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x9E"],
        ["\x8E\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x77"],
        ["\x8E\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD6"],
        ["\x8E\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF9"],
        ["\x8E\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE9"],
        ["\x8E\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF1"],
        ["\x8E\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x8A"],
        ["\x8E\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA4"],
        ["\x8E\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE4"],
        ["\x8E\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x7D"],
        ["\x8E\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD2"],
        ["\x8E\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB7"],
        ["\x8E\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC7"],
        ["\x8E\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC3"],
        ["\x8E\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x43"],
        ["\x8E\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x9C"],
        ["\x8E\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD2"],
        ["\x8E\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x65"],
        ["\x8E\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x6E"],
        ["\x8E\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xDE"],
        ["\x8E\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC9"],
        ["\x8E\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF3"],
        ["\x8E\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xCE"],
        ["\x8E\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x99"],
        ["\x8E\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC0"],
        ["\x8E\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x43"],
        ["\x8E\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xEB"],
        ["\x8E\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x5D"],
        ["\x8E\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x6B"],
        ["\x8E\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xEE"],
        ["\x8E\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x99"],
        ["\x8E\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB3"],
        ["\x8E\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xFC"],
        ["\x8E\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x93"],
        ["\x8E\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x92"],
        ["\x8E\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB5"],
        ["\x8E\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x65"],
        ["\x8E\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x8A"],
        ["\x8E\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB6"],
        ["\x8E\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC0"],
        ["\x8E\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF0"],
        ["\x8E\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD9"],
        ["\x8E\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x5E"],
        ["\x8E\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x44"],
        ["\x8E\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x7D"],
        ["\x8E\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x90"],
        ["\x8E\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC1"],
        ["\x8E\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x42"],
        ["\x8E\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x64"],
        ["\x8E\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xBA"],
        ["\x8E\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x53"],
        ["\x8E\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x44"],
        ["\x8E\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x61"],
        ["\x8E\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xAD"],
        ["\x8E\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB6"],
        ["\x8E\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x7B"],
        ["\x8E\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF2"],
        ["\x8E\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA5"],
        ["\x8E\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x88"],
        ["\x8E\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x6A"],
        ["\x8E\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x72"],
        ["\x8E\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD8"],
        ["\x8E\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x99"],
        ["\x8E\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x8E"],
        ["\x8E\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x9F"],
        ["\x8E\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xEB"],
        ["\x8E\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC3"],
        ["\x8E\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC7"],
        ["\x8E\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x80"],
        ["\x8E\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF0"],
        ["\x8E\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x82"],
        ["\x8E\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x74"],
        ["\x8E\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x48"],
        ["\x8E\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x50"],
        ["\x8E\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x90"],
        ["\x8E\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB0"],
        ["\x8E\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x48"],
        ["\x8E\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x76"],
        ["\x8E\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x9C"],
        ["\x8E\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x50"],
        ["\x8E\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x94"],
        ["\x8E\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB7"],
        ["\x8E\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x8F"],
        ["\x8E\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x9F"],
        ["\x8E\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xCE"],
        ["\x8E\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xBC"],
        ["\x8E\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC2"],
        ["\x8E\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x9F"],
        ["\x8E\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF2"],
        ["\x8E\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA0"],
        ["\x8E\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xBE"],
        ["\x8E\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD8"],
        ["\x8E\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x51"],
        ["\x8E\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x97"],
        ["\x8E\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x57"],
        ["\x8E\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x84"],
        ["\x8E\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x79"],
        ["\x8E\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x49"],
        ["\x8E\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x82"],
        ["\x8E\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x62"],
        ["\x8E\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x53"],
        ["\x8E\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE6"],
        ["\x8E\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xAB"],
        ["\x8E\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC3"],
        ["\x8E\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE3"],
        ["\x8E\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x74"],
        ["\x8E\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x6A"],
        ["\x8E\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x97"],
        ["\x8E\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x8F"],
        ["\x8E\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x75"],
        ["\x8E\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xBA"],
        ["\x8E\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x5C"],
        ["\x8E\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA6"],
        ["\x8E\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x75"],
        ["\x8E\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA5"],
        ["\x8E\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x47"],
        ["\x8E\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x42"],
        ["\x8E\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x57"],
        ["\x8E\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x41"],
        ["\x8E\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE0"],
        ["\x8E\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB8"],
        ["\x8E\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x69"],
        ["\x8E\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x90"],
        ["\x8E\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xAE"],
        ["\x8E\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x42"],
        ["\x8E\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xEC"],
        ["\x8E\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xED"],
        ["\x8E\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xBD"],
        ["\x8E\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x75"],
        ["\x8E\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD2"],
        ["\x8E\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA7"],
        ["\x8E\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x72"],
        ["\x8E\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC0"],
        ["\x8E\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA6"],
        ["\x8E\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x6B"],
        ["\x8E\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x58"],
        ["\x8E\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC4"],
        ["\x8E\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x8A"],
        ["\x8E\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB3"],
        ["\x8E\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x51"],
        ["\x8E\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD1"],
        ["\x8E\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x4C"],
        ["\x8E\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x63"],
        ["\x8E\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x47"],
        ["\x8E\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x70"],
        ["\x8E\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xBB"],
        ["\x8E\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x53"],
        ["\x8E\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x58"],
        ["\x8E\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xEA"],
        ["\x8E\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB8"],
        ["\x8E\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD0"],
        ["\x8E\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x70"],
        ["\x8E\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x6B"],
        ["\x8E\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC1"],
        ["\x8E\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x6A"],
        ["\x8E\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA9"],
        ["\x8E\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xBB"],
        ["\x8E\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x79"],
        ["\x8E\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x57"],
        ["\x8E\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD6"],
        ["\x8E\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE9"],
        ["\x8E\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x6E"],
        ["\x8E\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x72"],
        ["\x8E\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x62"],
        ["\x8E\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA6"],
        ["\x8E\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF0"],
        ["\x8E\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xCB"],
        ["\x8E\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x42"],
        ["\x8E\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x65"],
        ["\x8E\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x7B"],
        ["\x8E\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x99"],
        ["\x8E\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x92"],
        ["\x8E\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xCE"],
        ["\x8E\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xED"],
        ["\x8E\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x58"],
        ["\x8E\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xBE"],
        ["\x8E\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x6F"],
        ["\x8E\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x4C"],
        ["\x8E\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x8D"],
        ["\x8E\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB2"],
        ["\x8E\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x61"],
        ["\x8E\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xCF"],
        ["\x8E\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA3"],
        ["\x8E\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xFB"],
        ["\x8E\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x65"],
        ["\x8E\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x91"],
        ["\x8E\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA1"],
        ["\x8F\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xDD"],
        ["\x8F\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xEE"],
        ["\x8F\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x41"],
        ["\x8F\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xDE"],
        ["\x8F\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x82"],
        ["\x8F\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD7"],
        ["\x8F\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x72"],
        ["\x8F\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF1"],
        ["\x8F\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x58"],
        ["\x8F\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF4"],
        ["\x8F\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xDA"],
        ["\x8F\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x69"],
        ["\x8F\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB3"],
        ["\x8F\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB8"],
        ["\x8F\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x93"],
        ["\x8F\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x88"],
        ["\x8F\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xDF"],
        ["\x8F\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xFE"],
        ["\x8F\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF6"],
        ["\x8F\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA6"],
        ["\x8F\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD3"],
        ["\x8F\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x48"],
        ["\x8F\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x49"],
        ["\x8F\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA0"],
        ["\x8F\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x6F"],
        ["\x8F\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD9"],
        ["\x8F\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE0"],
        ["\x8F\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC9"],
        ["\x8F\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x4A"],
        ["\x8F\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xFB"],
        ["\x8F\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x7F"],
        ["\x8F\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xEA"],
        ["\x8F\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x84"],
        ["\x8F\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x92"],
        ["\x8F\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x65"],
        ["\x8F\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x93"],
        ["\x8F\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA3"],
        ["\x8F\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE2"],
        ["\x8F\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA5"],
        ["\x8F\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xDD"],
        ["\x8F\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x82"],
        ["\x8F\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xBF"],
        ["\x8F\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xEB"],
        ["\x8F\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF7"],
        ["\x8F\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC8"],
        ["\x8F\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x79"],
        ["\x8F\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xBF"],
        ["\x8F\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x9B"],
        ["\x8F\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x6C"],
        ["\x8F\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x9C"],
        ["\x8F\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x60"],
        ["\x8F\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x72"],
        ["\x8F\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x62"],
        ["\x8F\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB0"],
        ["\x8F\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x6B"],
        ["\x8F\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB8"],
        ["\x8F\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC0"],
        ["\x8F\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x80"],
        ["\x8F\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF5"],
        ["\x8F\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x67"],
        ["\x8F\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xAE"],
        ["\x8F\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA4"],
        ["\x8F\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x94"],
        ["\x8F\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xCE"],
        ["\x8F\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD2"],
        ["\x8F\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x82"],
        ["\x8F\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA6"],
        ["\x8F\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x47"],
        ["\x8F\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x6E"],
        ["\x8F\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA9"],
        ["\x8F\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB2"],
        ["\x8F\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE6"],
        ["\x8F\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x4B"],
        ["\x8F\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x8C"],
        ["\x8F\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xBE"],
        ["\x8F\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x52"],
        ["\x8F\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE4"],
        ["\x8F\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC1"],
        ["\x8F\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x9B"],
        ["\x8F\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x99"],
        ["\x8F\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x9D"],
        ["\x8F\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF9"],
        ["\x8F\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE2"],
        ["\x8F\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE2"],
        ["\x8F\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x71"],
        ["\x8F\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF5"],
        ["\x8F\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x99"],
        ["\x8F\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x4F"],
        ["\x8F\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB3"],
        ["\x8F\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x98"],
        ["\x8F\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC0"],
        ["\x8F\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x6D"],
        ["\x8F\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x5B"],
        ["\x8F\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA2"],
        ["\x8F\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB5"],
        ["\x8F\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x6B"],
        ["\x8F\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x47"],
        ["\x8F\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x86"],
        ["\x8F\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x68"],
        ["\x8F\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xBE"],
        ["\x8F\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x43"],
        ["\x8F\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xEC"],
        ["\x8F\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xCA"],
        ["\x8F\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xAF"],
        ["\x8F\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x98"],
        ["\x8F\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xEF"],
        ["\x8F\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x59"],
        ["\x8F\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x5D"],
        ["\x8F\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x4A"],
        ["\x8F\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x71"],
        ["\x8F\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x50"],
        ["\x8F\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xED"],
        ["\x8F\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x62"],
        ["\x8F\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x64"],
        ["\x8F\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x48"],
        ["\x8F\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC0"],
        ["\x8F\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xFD"],
        ["\x8F\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xEC"],
        ["\x8F\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x8F"],
        ["\x8F\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xFE"],
        ["\x8F\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD1"],
        ["\x8F\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB3"],
        ["\x8F\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF8"],
        ["\x8F\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x78"],
        ["\x8F\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xAC"],
        ["\x8F\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x9B"],
        ["\x8F\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x85"],
        ["\x8F\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC6"],
        ["\x8F\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x6B"],
        ["\x8F\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC0"],
        ["\x8F\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x55"],
        ["\x8F\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x83"],
        ["\x8F\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE6"],
        ["\x8F\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x42"],
        ["\x8F\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x4A"],
        ["\x8F\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x47"],
        ["\x8F\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x76"],
        ["\x8F\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB0"],
        ["\x8F\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF9"],
        ["\x8F\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xDF"],
        ["\x8F\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x6E"],
        ["\x8F\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB5"],
        ["\x8F\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD4"],
        ["\x8F\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE4"],
        ["\x8F\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x67"],
        ["\x8F\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x80"],
        ["\x8F\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF8"],
        ["\x8F\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA8"],
        ["\x8F\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA5"],
        ["\x8F\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA8"],
        ["\x8F\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xEF"],
        ["\x8F\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xBA"],
        ["\x8F\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x88"],
        ["\x8F\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE7"],
        ["\x8F\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x94"],
        ["\x8F\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xAD"],
        ["\x8F\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x7F"],
        ["\x8F\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB4"],
        ["\x8F\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xBD"],
        ["\x8F\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC8"],
        ["\x8F\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF9"],
        ["\x8F\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE7"],
        ["\x8F\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x5E"],
        ["\x8F\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD3"],
        ["\x8F\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x62"],
        ["\x8F\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x47"],
        ["\x8F\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x7E"],
        ["\x8F\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x85"],
        ["\x8F\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xDB"],
        ["\x8F\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD9"],
        ["\x8F\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x96"],
        ["\x8F\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE4"],
        ["\x8F\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xEF"],
        ["\x8F\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x5F"],
        ["\x8F\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF6"],
        ["\x8F\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x5E"],
        ["\x8F\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF4"],
        ["\x8F\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC9"],
        ["\x8F\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x52"],
        ["\x8F\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x54"],
        ["\x8F\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x98"],
        ["\x8F\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xBA"],
        ["\x8F\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x7B"],
        ["\x8F\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC2"],
        ["\x8F\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x57"],
        ["\x8F\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xCA"],
        ["\x8F\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x48"],
        ["\x8F\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x57"],
        ["\x90\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE5"],
        ["\x90\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC5"],
        ["\x90\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x73"],
        ["\x90\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE6"],
        ["\x90\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x9A"],
        ["\x90\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD7"],
        ["\x90\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC3"],
        ["\x90\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD1"],
        ["\x90\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB8"],
        ["\x90\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x47"],
        ["\x90\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE5"],
        ["\x90\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xCE"],
        ["\x90\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF4"],
        ["\x90\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA5"],
        ["\x90\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x8C"],
        ["\x90\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x76"],
        ["\x90\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x4C"],
        ["\x90\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x59"],
        ["\x90\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x87"],
        ["\x90\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE7"],
        ["\x90\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x76"],
        ["\x90\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF6"],
        ["\x90\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x87"],
        ["\x90\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB2"],
        ["\x90\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x9D"],
        ["\x90\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x7E"],
        ["\x90\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x41"],
        ["\x90\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x77"],
        ["\x90\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x67"],
        ["\x90\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE1"],
        ["\x90\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x42"],
        ["\x90\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA1"],
        ["\x90\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x8A"],
        ["\x90\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x59"],
        ["\x90\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x47"],
        ["\x90\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE5"],
        ["\x90\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x5A"],
        ["\x90\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x85"],
        ["\x90\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x68"],
        ["\x90\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x9C"],
        ["\x90\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x5E"],
        ["\x90\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x69"],
        ["\x90\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x88"],
        ["\x90\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xDE"],
        ["\x90\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x93"],
        ["\x90\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x76"],
        ["\x90\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x44"],
        ["\x90\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x89"],
        ["\x90\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x4F"],
        ["\x90\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x5F"],
        ["\x90\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x66"],
        ["\x90\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB9"],
        ["\x90\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC4"],
        ["\x90\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF2"],
        ["\x90\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x68"],
        ["\x90\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x84"],
        ["\x90\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xAB"],
        ["\x90\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF4"],
        ["\x90\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC1"],
        ["\x90\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB0"],
        ["\x90\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xAE"],
        ["\x90\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC1"],
        ["\x90\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x78"],
        ["\x90\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB3"],
        ["\x90\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC4"],
        ["\x90\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC9"],
        ["\x90\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xAF"],
        ["\x90\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD5"],
        ["\x90\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x9C"],
        ["\x90\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xCB"],
        ["\x90\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x6C"],
        ["\x90\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xCC"],
        ["\x90\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x69"],
        ["\x90\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x54"],
        ["\x90\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF7"],
        ["\x90\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x7C"],
        ["\x90\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x90"],
        ["\x90\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xEF"],
        ["\x90\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x76"],
        ["\x90\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x5B"],
        ["\x90\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC5"],
        ["\x90\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x7F"],
        ["\x90\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x9E"],
        ["\x90\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xCC"],
        ["\x90\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD0"],
        ["\x90\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x61"],
        ["\x90\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xFB"],
        ["\x90\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD6"],
        ["\x90\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x68"],
        ["\x90\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xED"],
        ["\x90\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x53"],
        ["\x90\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE4"],
        ["\x90\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x64"],
        ["\x90\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x8D"],
        ["\x90\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x87"],
        ["\x90\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xEF"],
        ["\x90\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x60"],
        ["\x90\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x9B"],
        ["\x90\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x5B"],
        ["\x90\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x86"],
        ["\x90\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xBB"],
        ["\x90\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xDC"],
        ["\x90\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC4"],
        ["\x90\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xEE"],
        ["\x90\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF1"],
        ["\x90\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x61"],
        ["\x90\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x6E"],
        ["\x90\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xBA"],
        ["\x90\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC7"],
        ["\x90\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x7C"],
        ["\x90\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA9"],
        ["\x90\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x95"],
        ["\x90\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x75"],
        ["\x90\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xCC"],
        ["\x90\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x77"],
        ["\x90\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x96"],
        ["\x90\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x58"],
        ["\x90\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x99"],
        ["\x90\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x44"],
        ["\x90\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x6C"],
        ["\x90\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB5"],
        ["\x90\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x6C"],
        ["\x90\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x7B"],
        ["\x90\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x58"],
        ["\x90\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xFD"],
        ["\x90\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA0"],
        ["\x90\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE8"],
        ["\x90\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB1"],
        ["\x90\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x78"],
        ["\x90\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x4C"],
        ["\x90\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x44"],
        ["\x90\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x8E"],
        ["\x90\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC4"],
        ["\x90\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xEC"],
        ["\x90\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xDA"],
        ["\x90\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x53"],
        ["\x90\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD7"],
        ["\x90\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x95"],
        ["\x90\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x41"],
        ["\x90\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x59"],
        ["\x90\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE2"],
        ["\x90\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x80"],
        ["\x90\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x91"],
        ["\x90\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xFE"],
        ["\x90\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x66"],
        ["\x90\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x5E"],
        ["\x90\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD2"],
        ["\x90\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF9"],
        ["\x90\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xCD"],
        ["\x90\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x68"],
        ["\x90\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x7D"],
        ["\x90\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x65"],
        ["\x90\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x5C"],
        ["\x90\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA8"],
        ["\x90\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x8C"],
        ["\x90\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x8D"],
        ["\x90\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE2"],
        ["\x90\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x69"],
        ["\x90\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA1"],
        ["\x90\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x52"],
        ["\x90\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xBB"],
        ["\x90\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF3"],
        ["\x90\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x94"],
        ["\x90\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE8"],
        ["\x90\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA2"],
        ["\x90\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA2"],
        ["\x90\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x4C"],
        ["\x90\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xEE"],
        ["\x90\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x8F"],
        ["\x90\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xFB"],
        ["\x90\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC0"],
        ["\x90\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x67"],
        ["\x90\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x64"],
        ["\x90\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xCA"],
        ["\x90\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x72"],
        ["\x90\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE3"],
        ["\x90\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xDA"],
        ["\x90\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xEE"],
        ["\x90\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x8D"],
        ["\x90\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x4E"],
        ["\x90\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x9B"],
        ["\x90\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC0"],
        ["\x90\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x90"],
        ["\x90\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x90"],
        ["\x90\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x7B"],
        ["\x90\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x91"],
        ["\x90\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x8D"],
        ["\x90\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x87"],
        ["\x91\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x68"],
        ["\x91\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x96"],
        ["\x91\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x6F"],
        ["\x91\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC1"],
        ["\x91\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x7B"],
        ["\x91\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xBF"],
        ["\x91\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x8E"],
        ["\x91\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x78"],
        ["\x91\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD1"],
        ["\x91\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x5D"],
        ["\x91\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x5B"],
        ["\x91\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x48"],
        ["\x91\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xAD"],
        ["\x91\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x9C"],
        ["\x91\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE9"],
        ["\x91\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xAF"],
        ["\x91\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB3"],
        ["\x91\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x73"],
        ["\x91\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xEF"],
        ["\x91\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB1"],
        ["\x91\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x87"],
        ["\x91\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD4"],
        ["\x91\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x76"],
        ["\x91\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x60"],
        ["\x91\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x62"],
        ["\x91\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC6"],
        ["\x91\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB9"],
        ["\x91\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x60"],
        ["\x91\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x66"],
        ["\x91\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x5F"],
        ["\x91\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x4C"],
        ["\x91\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xCF"],
        ["\x91\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB0"],
        ["\x91\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x71"],
        ["\x91\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x9C"],
        ["\x91\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xDC"],
        ["\x91\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x83"],
        ["\x91\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x59"],
        ["\x91\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x9F"],
        ["\x91\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB9"],
        ["\x91\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xBF"],
        ["\x91\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xDF"],
        ["\x91\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xEF"],
        ["\x91\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x4C"],
        ["\x91\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xCB"],
        ["\x91\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x84"],
        ["\x91\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE1"],
        ["\x91\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x71"],
        ["\x91\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF5"],
        ["\x91\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD6"],
        ["\x91\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x68"],
        ["\x91\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x9F"],
        ["\x91\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x53"],
        ["\x91\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xDD"],
        ["\x91\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x4D"],
        ["\x91\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x8E"],
        ["\x91\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB7"],
        ["\x91\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x68"],
        ["\x91\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB3"],
        ["\x91\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xDD"],
        ["\x91\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC3"],
        ["\x91\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x55"],
        ["\x91\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA3"],
        ["\x91\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x9B"],
        ["\x91\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE9"],
        ["\x91\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD2"],
        ["\x91\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x67"],
        ["\x91\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xDB"],
        ["\x91\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB7"],
        ["\x91\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA1"],
        ["\x91\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x66"],
        ["\x91\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x96"],
        ["\x91\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA4"],
        ["\x91\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x78"],
        ["\x91\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE9"],
        ["\x91\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x8C"],
        ["\x91\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x93"],
        ["\x91\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x70"],
        ["\x91\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x89"],
        ["\x91\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x42"],
        ["\x91\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x62"],
        ["\x91\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x79"],
        ["\x91\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB9"],
        ["\x91\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x5F"],
        ["\x91\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x98"],
        ["\x91\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xAA"],
        ["\x91\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x44"],
        ["\x91\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x43"],
        ["\x91\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x97"],
        ["\x91\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE8"],
        ["\x91\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD2"],
        ["\x91\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xBA"],
        ["\x91\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x4D"],
        ["\x91\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x4A"],
        ["\x91\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xBD"],
        ["\x91\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x5E"],
        ["\x91\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x7C"],
        ["\x91\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB8"],
        ["\x91\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x6A"],
        ["\x91\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x43"],
        ["\x91\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x4D"],
        ["\x91\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x6D"],
        ["\x91\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB0"],
        ["\x91\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA0"],
        ["\x91\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x4B"],
        ["\x91\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x45"],
        ["\x91\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xFA"],
        ["\x91\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xCD"],
        ["\x91\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x97"],
        ["\x91\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x6D"],
        ["\x91\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xFD"],
        ["\x91\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xDC"],
        ["\x91\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xCB"],
        ["\x91\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF2"],
        ["\x91\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x57"],
        ["\x91\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x67"],
        ["\x91\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xFD"],
        ["\x91\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x41"],
        ["\x91\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x5E"],
        ["\x91\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xEF"],
        ["\x91\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD8"],
        ["\x91\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x56"],
        ["\x91\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x55"],
        ["\x91\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x55"],
        ["\x91\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xFE"],
        ["\x91\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xAB"],
        ["\x91\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD2"],
        ["\x91\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE3"],
        ["\x91\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x78"],
        ["\x91\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB0"],
        ["\x91\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x9E"],
        ["\x91\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB8"],
        ["\x91\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xEA"],
        ["\x91\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xCD"],
        ["\x91\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xDB"],
        ["\x91\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC5"],
        ["\x91\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE8"],
        ["\x91\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE5"],
        ["\x91\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xDA"],
        ["\x91\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x96"],
        ["\x91\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x71"],
        ["\x91\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x56"],
        ["\x91\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x8E"],
        ["\x91\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x62"],
        ["\x91\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x60"],
        ["\x91\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA3"],
        ["\x91\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x81"],
        ["\x91\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xFD"],
        ["\x91\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x92"],
        ["\x91\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC3"],
        ["\x91\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF3"],
        ["\x91\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA1"],
        ["\x91\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x63"],
        ["\x91\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x9A"],
        ["\x91\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD7"],
        ["\x91\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x54"],
        ["\x91\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF4"],
        ["\x91\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x49"],
        ["\x91\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x77"],
        ["\x91\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x93"],
        ["\x91\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xDD"],
        ["\x91\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD8"],
        ["\x91\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x9A"],
        ["\x91\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x78"],
        ["\x91\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x5B"],
        ["\x91\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x7E"],
        ["\x91\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x6F"],
        ["\x91\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xFE"],
        ["\x91\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x7A"],
        ["\x91\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xA3"],
        ["\x91\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xAE"],
        ["\x91\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x96"],
        ["\x91\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x83"],
        ["\x91\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x6F"],
        ["\x91\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD5"],
        ["\x91\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x7E"],
        ["\x91\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xDB"],
        ["\x91\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x85"],
        ["\x91\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD4"],
        ["\x91\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x5C"],
        ["\x91\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB6"],
        ["\x91\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x88"],
        ["\x91\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xBE"],
        ["\x91\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE1"],
        ["\x91\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF7"],
        ["\x91\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x8A"],
        ["\x91\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x4E"],
        ["\x91\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x41"],
        ["\x92\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x71"],
        ["\x92\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xFE"],
        ["\x92\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA4"],
        ["\x92\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xDF"],
        ["\x92\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xBB"],
        ["\x92\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB4"],
        ["\x92\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x46"],
        ["\x92\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC8"],
        ["\x92\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x7E"],
        ["\x92\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xEF"],
        ["\x92\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x81"],
        ["\x92\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xFE"],
        ["\x92\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x60"],
        ["\x92\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xBE"],
        ["\x92\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x83"],
        ["\x92\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xAB"],
        ["\x92\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE3"],
        ["\x92\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x63"],
        ["\x92\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC4"],
        ["\x92\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA1"],
        ["\x92\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x7F"],
        ["\x92\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x9D"],
        ["\x92\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x87"],
        ["\x92\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA5"],
        ["\x92\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF3"],
        ["\x92\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x61"],
        ["\x92\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x82"],
        ["\x92\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xEF"],
        ["\x92\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xCA"],
        ["\x92\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA6"],
        ["\x92\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB8"],
        ["\x92\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x9B"],
        ["\x92\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD8"],
        ["\x92\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA2"],
        ["\x92\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC7"],
        ["\x92\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF0"],
        ["\x92\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x8E"],
        ["\x92\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD4"],
        ["\x92\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x89"],
        ["\x92\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x6C"],
        ["\x92\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF5"],
        ["\x92\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xED"],
        ["\x92\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x7C"],
        ["\x92\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x63"],
        ["\x92\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x7D"],
        ["\x92\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB0"],
        ["\x92\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC2"],
        ["\x92\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x97"],
        ["\x92\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xCE"],
        ["\x92\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA8"],
        ["\x92\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE8"],
        ["\x92\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x89"],
        ["\x92\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xCF"],
        ["\x92\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x8C"],
        ["\x92\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x6A"],
        ["\x92\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xDC"],
        ["\x92\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x6D"],
        ["\x92\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xDF"],
        ["\x92\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA8"],
        ["\x92\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x72"],
        ["\x92\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF5"],
        ["\x92\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x45"],
        ["\x92\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x94"],
        ["\x92\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xBB"],
        ["\x92\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x9F"],
        ["\x92\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB0"],
        ["\x92\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x77"],
        ["\x92\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x67"],
        ["\x92\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xAA"],
        ["\x92\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x5C"],
        ["\x92\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x69"],
        ["\x92\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x64"],
        ["\x92\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x4F"],
        ["\x92\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x53"],
        ["\x92\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x98"],
        ["\x92\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xEA"],
        ["\x92\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x44"],
        ["\x92\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xCB"],
        ["\x92\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE9"],
        ["\x92\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x66"],
        ["\x92\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x91"],
        ["\x92\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC1"],
        ["\x92\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF5"],
        ["\x92\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x8B"],
        ["\x92\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xDE"],
        ["\x92\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC5"],
        ["\x92\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB0"],
        ["\x92\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x59"],
        ["\x92\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x62"],
        ["\x92\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xCE"],
        ["\x92\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF3"],
        ["\x92\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF9"],
        ["\x92\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x58"],
        ["\x92\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x56"],
        ["\x92\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC7"],
        ["\x92\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC5"],
        ["\x92\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x92"],
        ["\x92\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE5"],
        ["\x92\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xBA"],
        ["\x92\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x86"],
        ["\x92\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x74"],
        ["\x92\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x53"],
        ["\x92\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xDB"],
        ["\x92\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC7"],
        ["\x92\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x5C"],
        ["\x92\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x93"],
        ["\x92\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xDD"],
        ["\x92\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x55"],
        ["\x92\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x5F"],
        ["\x92\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA8"],
        ["\x92\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE9"],
        ["\x92\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB6"],
        ["\x92\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x6E"],
        ["\x92\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x89"],
        ["\x92\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x70"],
        ["\x92\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x78"],
        ["\x92\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB4"],
        ["\x92\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x80"],
        ["\x92\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x83"],
        ["\x92\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x5B"],
        ["\x92\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x79"],
        ["\x92\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xEF"],
        ["\x92\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x46"],
        ["\x92\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x74"],
        ["\x92\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF3"],
        ["\x92\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x8F"],
        ["\x92\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x5D"],
        ["\x92\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x4D"],
        ["\x92\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x89"],
        ["\x92\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x61"],
        ["\x92\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xDC"],
        ["\x92\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x50"],
        ["\x92\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA0"],
        ["\x92\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xFA"],
        ["\x92\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD1"],
        ["\x92\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xFE"],
        ["\x92\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x47"],
        ["\x92\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE3"],
        ["\x92\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x57"],
        ["\x92\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD1"],
        ["\x92\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xCD"],
        ["\x92\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x5C"],
        ["\x92\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xDF"],
        ["\x92\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x8A"],
        ["\x92\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD8"],
        ["\x92\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF5"],
        ["\x92\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA1"],
        ["\x92\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC9"],
        ["\x92\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xAA"],
        ["\x92\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xBA"],
        ["\x92\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x46"],
        ["\x92\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x49"],
        ["\x92\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x9B"],
        ["\x92\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xEA"],
        ["\x92\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x92"],
        ["\x92\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x87"],
        ["\x92\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD3"],
        ["\x92\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE3"],
        ["\x92\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x7A"],
        ["\x92\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x52"],
        ["\x92\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA4"],
        ["\x92\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x70"],
        ["\x92\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x95"],
        ["\x92\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x79"],
        ["\x92\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB6"],
        ["\x92\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x56"],
        ["\x92\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x61"],
        ["\x92\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE7"],
        ["\x92\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x9C"],
        ["\x92\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x64"],
        ["\x92\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE0"],
        ["\x92\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x5B"],
        ["\x92\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x9B"],
        ["\x92\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE3"],
        ["\x92\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x90"],
        ["\x92\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x87"],
        ["\x92\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB9"],
        ["\x92\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE4"],
        ["\x92\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x4D"],
        ["\x92\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x95"],
        ["\x92\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xA7"],
        ["\x92\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF4"],
        ["\x92\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x80"],
        ["\x92\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xFC"],
        ["\x92\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC4"],
        ["\x92\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x46"],
        ["\x92\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA7"],
        ["\x92\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x5E"],
        ["\x93\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x81"],
        ["\x93\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x54"],
        ["\x93\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF4"],
        ["\x93\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xAA"],
        ["\x93\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x56"],
        ["\x93\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xCB"],
        ["\x93\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x43"],
        ["\x93\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF3"],
        ["\x93\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB7"],
        ["\x93\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xEF"],
        ["\x93\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x41"],
        ["\x93\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xCC"],
        ["\x93\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x41"],
        ["\x93\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x97"],
        ["\x93\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x47"],
        ["\x93\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF8"],
        ["\x93\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x7A"],
        ["\x93\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xEE"],
        ["\x93\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xDF"],
        ["\x93\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD7"],
        ["\x93\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC9"],
        ["\x93\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x5E"],
        ["\x93\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x8A"],
        ["\x93\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xDD"],
        ["\x93\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x54"],
        ["\x93\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x91"],
        ["\x93\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xFA"],
        ["\x93\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA7"],
        ["\x93\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x7B"],
        ["\x93\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x52"],
        ["\x93\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC1"],
        ["\x93\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x88"],
        ["\x93\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD9"],
        ["\x93\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x49"],
        ["\x93\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x89"],
        ["\x93\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x63"],
        ["\x93\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x82"],
        ["\x93\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x50"],
        ["\x93\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB2"],
        ["\x93\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF6"],
        ["\x93\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x6A"],
        ["\x93\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x7F"],
        ["\x93\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xFB"],
        ["\x93\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x6C"],
        ["\x93\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x83"],
        ["\x93\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x5D"],
        ["\x93\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD2"],
        ["\x93\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE8"],
        ["\x93\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD4"],
        ["\x93\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC1"],
        ["\x93\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF0"],
        ["\x93\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x4F"],
        ["\x93\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD3"],
        ["\x93\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x45"],
        ["\x93\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xDF"],
        ["\x93\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x64"],
        ["\x93\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xDE"],
        ["\x93\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x84"],
        ["\x93\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x90"],
        ["\x93\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD6"],
        ["\x93\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x6A"],
        ["\x93\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x4B"],
        ["\x93\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xDE"],
        ["\x93\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE6"],
        ["\x93\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x50"],
        ["\x93\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xAB"],
        ["\x93\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xCB"],
        ["\x93\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF8"],
        ["\x93\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x83"],
        ["\x93\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x5C"],
        ["\x93\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x6F"],
        ["\x93\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD1"],
        ["\x93\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x45"],
        ["\x93\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x51"],
        ["\x93\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x8F"],
        ["\x93\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x57"],
        ["\x93\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xDA"],
        ["\x93\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x49"],
        ["\x93\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA9"],
        ["\x93\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x65"],
        ["\x93\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE1"],
        ["\x93\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xBD"],
        ["\x93\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x69"],
        ["\x93\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x65"],
        ["\x93\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF8"],
        ["\x93\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x5F"],
        ["\x93\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x49"],
        ["\x93\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x53"],
        ["\x93\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA7"],
        ["\x93\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD0"],
        ["\x93\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x7C"],
        ["\x93\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x84"],
        ["\x93\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x81"],
        ["\x93\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xDD"],
        ["\x93\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x71"],
        ["\x93\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF0"],
        ["\x93\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x68"],
        ["\x93\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD2"],
        ["\x93\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE2"],
        ["\x93\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x99"],
        ["\x93\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x7C"],
        ["\x93\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x72"],
        ["\x93\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xDA"],
        ["\x93\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xCF"],
        ["\x93\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB7"],
        ["\x93\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xEB"],
        ["\x93\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x5E"],
        ["\x93\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xCC"],
        ["\x93\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xEC"],
        ["\x93\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE4"],
        ["\x93\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x6D"],
        ["\x93\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x7F"],
        ["\x93\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xAE"],
        ["\x93\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC2"],
        ["\x93\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xDB"],
        ["\x93\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x98"],
        ["\x93\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x9B"],
        ["\x93\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x50"],
        ["\x93\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xAB"],
        ["\x93\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF7"],
        ["\x93\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x50"],
        ["\x93\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC0"],
        ["\x93\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x96"],
        ["\x93\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA1"],
        ["\x93\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF1"],
        ["\x93\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE8"],
        ["\x93\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x54"],
        ["\x93\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x50"],
        ["\x93\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xA2"],
        ["\x93\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x73"],
        ["\x93\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD0"],
        ["\x93\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD8"],
        ["\x93\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x97"],
        ["\x93\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xDB"],
        ["\x93\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x4F"],
        ["\x93\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD3"],
        ["\x93\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD4"],
        ["\x93\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xCF"],
        ["\x93\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xFD"],
        ["\x93\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA7"],
        ["\x93\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA7"],
        ["\x93\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC4"],
        ["\x93\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x5A"],
        ["\x93\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x84"],
        ["\x93\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x73"],
        ["\x93\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x5C"],
        ["\x93\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF1"],
        ["\x93\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xDD"],
        ["\x93\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x65"],
        ["\x93\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF2"],
        ["\x93\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x98"],
        ["\x93\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xCF"],
        ["\x93\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF8"],
        ["\x93\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x7A"],
        ["\x93\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB0"],
        ["\x93\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x56"],
        ["\x93\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x63"],
        ["\x93\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE6"],
        ["\x93\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x46"],
        ["\x93\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x8E"],
        ["\x93\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA9"],
        ["\x93\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x9E"],
        ["\x93\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xAD"],
        ["\x93\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF9"],
        ["\x93\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x96"],
        ["\x93\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xC0"],
        ["\x93\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x48"],
        ["\x93\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x93"],
        ["\x93\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA1"],
        ["\x93\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x59"],
        ["\x93\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xDD"],
        ["\x93\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x59"],
        ["\x93\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xDF"],
        ["\x93\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB1"],
        ["\x93\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x5A"],
        ["\x93\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x5E"],
        ["\x93\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x42"],
        ["\x93\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x86"],
        ["\x93\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE1"],
        ["\x93\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF6"],
        ["\x93\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xCB"],
        ["\x93\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x9E"],
        ["\x93\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x42"],
        ["\x93\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB6"],
        ["\x93\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD9"],
        ["\x93\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x62"],
        ["\x93\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x98"],
        ["\x93\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x65"],
        ["\x94\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF8"],
        ["\x94\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC6"],
        ["\x94\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xDF"],
        ["\x94\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x55"],
        ["\x94\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x43"],
        ["\x94\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD7"],
        ["\x94\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x7E"],
        ["\x94\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x7E"],
        ["\x94\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xFA"],
        ["\x94\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x89"],
        ["\x94\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA9"],
        ["\x94\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x4E"],
        ["\x94\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD0"],
        ["\x94\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD5"],
        ["\x94\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x60"],
        ["\x94\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xAE"],
        ["\x94\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC0"],
        ["\x94\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x48"],
        ["\x94\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD5"],
        ["\x94\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF7"],
        ["\x94\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x9F"],
        ["\x94\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x64"],
        ["\x94\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD8"],
        ["\x94\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF4"],
        ["\x94\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x90"],
        ["\x94\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xCD"],
        ["\x94\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xCE"],
        ["\x94\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE2"],
        ["\x94\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x4F"],
        ["\x94\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB3"],
        ["\x94\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x5F"],
        ["\x94\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x45"],
        ["\x94\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xEB"],
        ["\x94\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA2"],
        ["\x94\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x7D"],
        ["\x94\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE3"],
        ["\x94\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x62"],
        ["\x94\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xFA"],
        ["\x94\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x80"],
        ["\x94\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xCA"],
        ["\x94\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x72"],
        ["\x94\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x9F"],
        ["\x94\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xBE"],
        ["\x94\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xCC"],
        ["\x94\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x79"],
        ["\x94\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x42"],
        ["\x94\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x64"],
        ["\x94\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE1"],
        ["\x94\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC7"],
        ["\x94\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE2"],
        ["\x94\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xFA"],
        ["\x94\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x8A"],
        ["\x94\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x63"],
        ["\x94\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xBA"],
        ["\x94\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x6F"],
        ["\x94\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB2"],
        ["\x94\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x4E"],
        ["\x94\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF4"],
        ["\x94\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF3"],
        ["\x94\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC4"],
        ["\x94\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xAC"],
        ["\x94\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x80"],
        ["\x94\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x98"],
        ["\x94\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB3"],
        ["\x94\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xEA"],
        ["\x94\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD6"],
        ["\x94\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x74"],
        ["\x94\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x75"],
        ["\x94\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x4F"],
        ["\x94\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC3"],
        ["\x94\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xCA"],
        ["\x94\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x4B"],
        ["\x94\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x8F"],
        ["\x94\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC9"],
        ["\x94\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x4A"],
        ["\x94\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA6"],
        ["\x94\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x81"],
        ["\x94\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF6"],
        ["\x94\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xBA"],
        ["\x94\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x80"],
        ["\x94\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB8"],
        ["\x94\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x59"],
        ["\x94\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE0"],
        ["\x94\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x4B"],
        ["\x94\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x87"],
        ["\x94\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x92"],
        ["\x94\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xEF"],
        ["\x94\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA6"],
        ["\x94\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x8E"],
        ["\x94\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD9"],
        ["\x94\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE6"],
        ["\x94\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB3"],
        ["\x94\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE5"],
        ["\x94\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE0"],
        ["\x94\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB6"],
        ["\x94\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xFB"],
        ["\x94\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xBF"],
        ["\x94\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x5C"],
        ["\x94\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x41"],
        ["\x94\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x9B"],
        ["\x94\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC5"],
        ["\x94\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xDE"],
        ["\x94\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x50"],
        ["\x94\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x8B"],
        ["\x94\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xFE"],
        ["\x94\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x48"],
        ["\x94\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA8"],
        ["\x94\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xFA"],
        ["\x94\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x4B"],
        ["\x94\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xFA"],
        ["\x94\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF6"],
        ["\x94\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF6"],
        ["\x94\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x82"],
        ["\x94\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x85"],
        ["\x94\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF5"],
        ["\x94\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x72"],
        ["\x94\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x95"],
        ["\x94\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x82"],
        ["\x94\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x6F"],
        ["\x94\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC2"],
        ["\x94\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD5"],
        ["\x94\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC9"],
        ["\x94\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x5C"],
        ["\x94\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x90"],
        ["\x94\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF9"],
        ["\x94\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB2"],
        ["\x94\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x75"],
        ["\x94\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC8"],
        ["\x94\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE4"],
        ["\x94\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB4"],
        ["\x94\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x6E"],
        ["\x94\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x5E"],
        ["\x94\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xBD"],
        ["\x94\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA7"],
        ["\x94\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x66"],
        ["\x94\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xDC"],
        ["\x94\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x59"],
        ["\x94\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x56"],
        ["\x94\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF6"],
        ["\x94\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x5D"],
        ["\x94\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE8"],
        ["\x94\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x46"],
        ["\x94\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA0"],
        ["\x94\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x57"],
        ["\x94\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xB5"],
        ["\x94\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA8"],
        ["\x94\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB6"],
        ["\x94\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB9"],
        ["\x94\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x90"],
        ["\x94\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x9C"],
        ["\x94\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF7"],
        ["\x94\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA5"],
        ["\x94\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xED"],
        ["\x94\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xAD"],
        ["\x94\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x4F"],
        ["\x94\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA2"],
        ["\x94\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x8D"],
        ["\x94\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x72"],
        ["\x94\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x9D"],
        ["\x94\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xAD"],
        ["\x94\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x76"],
        ["\x94\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA6"],
        ["\x94\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x80"],
        ["\x94\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x4E"],
        ["\x94\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xFD"],
        ["\x94\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x97"],
        ["\x94\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xDA"],
        ["\x94\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x7B"],
        ["\x94\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x70"],
        ["\x94\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x7D"],
        ["\x94\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA5"],
        ["\x94\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x7B"],
        ["\x94\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x8D"],
        ["\x94\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF2"],
        ["\x94\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD0"],
        ["\x94\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC4"],
        ["\x94\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xE1"],
        ["\x94\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x8A"],
        ["\x94\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x4F"],
        ["\x94\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xAB"],
        ["\x94\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xAC"],
        ["\x94\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC8"],
        ["\x94\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x5D"],
        ["\x94\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x5E"],
        ["\x94\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD7"],
        ["\x94\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA3"],
        ["\x94\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xBC"],
        ["\x94\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x7D"],
        ["\x95\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xFD"],
        ["\x95\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD9"],
        ["\x95\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x87"],
        ["\x95\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD1"],
        ["\x95\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA0"],
        ["\x95\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x9D"],
        ["\x95\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xE1"],
        ["\x95\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x60"],
        ["\x95\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xCC"],
        ["\x95\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x6A"],
        ["\x95\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE0"],
        ["\x95\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xCA"],
        ["\x95\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x9A"],
        ["\x95\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC7"],
        ["\x95\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xAC"],
        ["\x95\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x46"],
        ["\x95\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB3"],
        ["\x95\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x55"],
        ["\x95\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB5"],
        ["\x95\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x4B"],
        ["\x95\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA1"],
        ["\x95\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB1"],
        ["\x95\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x59"],
        ["\x95\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x66"],
        ["\x95\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA4"],
        ["\x95\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xBC"],
        ["\x95\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x52"],
        ["\x95\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xBF"],
        ["\x95\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC0"],
        ["\x95\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xFD"],
        ["\x95\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x93"],
        ["\x95\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xAF"],
        ["\x95\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xCF"],
        ["\x95\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xBF"],
        ["\x95\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xBA"],
        ["\x95\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xB8"],
        ["\x95\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF0"],
        ["\x95\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xBE"],
        ["\x95\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x59"],
        ["\x95\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x66"],
        ["\x95\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x6E"],
        ["\x95\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD0"],
        ["\x95\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x88"],
        ["\x95\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x9D"],
        ["\x95\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xEA"],
        ["\x95\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD1"],
        ["\x95\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xA3"],
        ["\x95\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD7"],
        ["\x95\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xAB"],
        ["\x95\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x47"],
        ["\x95\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD4"],
        ["\x95\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xAF"],
        ["\x95\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x5D"],
        ["\x95\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x7E"],
        ["\x95\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x73"],
        ["\x95\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x6F"],
        ["\x95\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xAC"],
        ["\x95\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x78"],
        ["\x95\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x6B"],
        ["\x95\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x51"],
        ["\x95\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF0"],
        ["\x95\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x7A"],
        ["\x95\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x51"],
        ["\x95\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC2"],
        ["\x95\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF8"],
        ["\x95\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x8C"],
        ["\x95\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xCC"],
        ["\x95\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD9"],
        ["\x95\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x62"],
        ["\x95\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x91"],
        ["\x95\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xBD"],
        ["\x95\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x4F"],
        ["\x95\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC8"],
        ["\x95\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xA7"],
        ["\x95\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xEE"],
        ["\x95\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x86"],
        ["\x95\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x8C"],
        ["\x95\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB9"],
        ["\x95\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE1"],
        ["\x95\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB1"],
        ["\x95\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x63"],
        ["\x95\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x47"],
        ["\x95\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD3"],
        ["\x95\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x95"],
        ["\x95\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x76"],
        ["\x95\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x95"],
        ["\x95\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE7"],
        ["\x95\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE0"],
        ["\x95\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x91"],
        ["\x95\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x83"],
        ["\x95\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x4E"],
        ["\x95\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x70"],
        ["\x95\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x5E"],
        ["\x95\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD4"],
        ["\x95\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x8B"],
        ["\x95\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA0"],
        ["\x95\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x51"],
        ["\x95\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF2"],
        ["\x95\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xEA"],
        ["\x95\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xAC"],
        ["\x95\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x81"],
        ["\x95\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xAA"],
        ["\x95\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE5"],
        ["\x95\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x52"],
        ["\x95\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x8D"],
        ["\x95\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB4"],
        ["\x95\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE5"],
        ["\x95\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x6D"],
        ["\x95\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x89"],
        ["\x95\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xFC"],
        ["\x95\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB7"],
        ["\x95\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x4F"],
        ["\x95\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xDD"],
        ["\x95\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x9E"],
        ["\x95\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x92"],
        ["\x95\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF3"],
        ["\x95\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x90"],
        ["\x95\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xCA"],
        ["\x95\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xBB"],
        ["\x95\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC5"],
        ["\x95\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x94"],
        ["\x95\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x49"],
        ["\x95\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x9F"],
        ["\x95\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x7F"],
        ["\x95\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x8D"],
        ["\x95\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xCD"],
        ["\x95\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x7F"],
        ["\x95\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x7C"],
        ["\x95\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD1"],
        ["\x95\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x7D"],
        ["\x95\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x57"],
        ["\x95\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x6F"],
        ["\x95\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD9"],
        ["\x95\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x78"],
        ["\x95\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x95"],
        ["\x95\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x7E"],
        ["\x95\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF8"],
        ["\x95\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xDD"],
        ["\x95\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x72"],
        ["\x95\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x6C"],
        ["\x95\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x9B"],
        ["\x95\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x49"],
        ["\x95\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x6F"],
        ["\x95\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x67"],
        ["\x95\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xB6"],
        ["\x95\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x4E"],
        ["\x95\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xD5"],
        ["\x95\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD6"],
        ["\x95\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x5D"],
        ["\x95\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x4C"],
        ["\x95\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xCE"],
        ["\x95\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x9F"],
        ["\x95\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x47"],
        ["\x95\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x8B"],
        ["\x95\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xAA"],
        ["\x95\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x5B"],
        ["\x95\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x63"],
        ["\x95\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xCF"],
        ["\x95\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x41"],
        ["\x95\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xD8"],
        ["\x95\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x58"],
        ["\x95\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x6A"],
        ["\x95\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x68"],
        ["\x95\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD4"],
        ["\x95\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE1"],
        ["\x95\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xBE"],
        ["\x95\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE3"],
        ["\x95\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x61"],
        ["\x95\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xFE"],
        ["\x95\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x69"],
        ["\x95\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x4C"],
        ["\x95\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x6A"],
        ["\x95\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x69"],
        ["\x95\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF9"],
        ["\x95\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xA8"],
        ["\x95\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x73"],
        ["\x95\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB8"],
        ["\x95\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB2"],
        ["\x95\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x4D"],
        ["\x95\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xFE"],
        ["\x95\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xAC"],
        ["\x95\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x5F"],
        ["\x95\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x4F"],
        ["\x95\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x86"],
        ["\x95\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x85"],
        ["\x95\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xAF"],
        ["\x95\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xCD"],
        ["\x95\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC4"],
        ["\x96\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x4A"],
        ["\x96\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x87"],
        ["\x96\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x87"],
        ["\x96\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xC2"],
        ["\x96\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE4"],
        ["\x96\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB6"],
        ["\x96\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x83"],
        ["\x96\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xDB"],
        ["\x96\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x88"],
        ["\x96\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xCD"],
        ["\x96\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xBA"],
        ["\x96\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x71"],
        ["\x96\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x48"],
        ["\x96\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC5"],
        ["\x96\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x49"],
        ["\x96\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x49"],
        ["\x96\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA6"],
        ["\x96\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x8A"],
        ["\x96\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x6C"],
        ["\x96\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xCE"],
        ["\x96\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE7"],
        ["\x96\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x99"],
        ["\x96\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x55"],
        ["\x96\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xEC"],
        ["\x96\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x85"],
        ["\x96\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x45"],
        ["\x96\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA3"],
        ["\x96\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xDC"],
        ["\x96\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB2"],
        ["\x96\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xBB"],
        ["\x96\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x4A"],
        ["\x96\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x5A"],
        ["\x96\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x8F"],
        ["\x96\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x77"],
        ["\x96\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xFB"],
        ["\x96\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xF6"],
        ["\x96\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x4D"],
        ["\x96\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x64"],
        ["\x96\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x72"],
        ["\x96\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x83"],
        ["\x96\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xBC"],
        ["\x96\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE1"],
        ["\x96\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xB3"],
        ["\x96\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x5A"],
        ["\x96\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xBB"],
        ["\x96\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC0"],
        ["\x96\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xFC"],
        ["\x96\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC7"],
        ["\x96\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA2"],
        ["\x96\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x7B"],
        ["\x96\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x96"],
        ["\x96\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xBE"],
        ["\x96\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x4A"],
        ["\x96\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB1"],
        ["\x96\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x75"],
        ["\x96\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x42"],
        ["\x96\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x9D"],
        ["\x96\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x6B"],
        ["\x96\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x84"],
        ["\x96\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x66"],
        ["\x96\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF6"],
        ["\x96\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE1"],
        ["\x96\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x57"],
        ["\x96\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xD1"],
        ["\x96\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB4"],
        ["\x96\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xE2"],
        ["\x96\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA7"],
        ["\x96\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xAC"],
        ["\x96\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xDC"],
        ["\x96\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x9D"],
        ["\x96\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xD9"],
        ["\x96\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xF5"],
        ["\x96\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF0"],
        ["\x96\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x81"],
        ["\x96\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xCA"],
        ["\x96\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x8A"],
        ["\x96\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x78"],
        ["\x96\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xCE"],
        ["\x96\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x54"],
        ["\x96\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC6"],
        ["\x96\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x88"],
        ["\x96\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xFA"],
        ["\x96\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x4A"],
        ["\x96\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF5"],
        ["\x96\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE0"],
        ["\x96\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x46"],
        ["\x96\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xEC"],
        ["\x96\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xCD"],
        ["\x96\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x75"],
        ["\x96\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x9A"],
        ["\x96\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xEA"],
        ["\x96\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x4D"],
        ["\x96\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xDB"],
        ["\x96\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x5B"],
        ["\x96\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x6E"],
        ["\x96\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x7B"],
        ["\x96\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x7F"],
        ["\x96\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC6"],
        ["\x96\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB4"],
        ["\x96\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xE6"],
        ["\x96\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xCC"],
        ["\x96\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD5"],
        ["\x96\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x56"],
        ["\x96\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA1"],
        ["\x96\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x88"],
        ["\x96\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x9A"],
        ["\x96\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xFA"],
        ["\x96\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x79"],
        ["\x96\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x66"],
        ["\x96\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC9"],
        ["\x96\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x56"],
        ["\x96\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x6A"],
        ["\x96\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xED"],
        ["\x96\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x8B"],
        ["\x96\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x5F"],
        ["\x96\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xAF"],
        ["\x96\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xED"],
        ["\x96\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x48"],
        ["\x96\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x7E"],
        ["\x96\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xFD"],
        ["\x96\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x54"],
        ["\x96\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x54"],
        ["\x96\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x67"],
        ["\x96\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF3"],
        ["\x96\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xB0"],
        ["\x96\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA6"],
        ["\x96\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x84"],
        ["\x96\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x58"],
        ["\x96\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xDC"],
        ["\x96\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x70"],
        ["\x96\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x8C"],
        ["\x96\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xB7"],
        ["\x96\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE6"],
        ["\x96\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x56"],
        ["\x96\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xCA"],
        ["\x96\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x9D"],
        ["\x96\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x6B"],
        ["\x96\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x91"],
        ["\x96\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x5F"],
        ["\x96\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF5"],
        ["\x96\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x64"],
        ["\x96\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x46"],
        ["\x96\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x4D"],
        ["\x96\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x83"],
        ["\x96\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE2"],
        ["\x96\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x51"],
        ["\x96\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x80"],
        ["\x96\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x53"],
        ["\x96\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xEC"],
        ["\x96\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x95"],
        ["\x96\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xBD"],
        ["\x96\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x6C"],
        ["\x96\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xBC"],
        ["\x96\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x75"],
        ["\x96\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA6"],
        ["\x96\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x97"],
        ["\x96\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xBF"],
        ["\x96\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xAE"],
        ["\x96\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x44"],
        ["\x96\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF0"],
        ["\x96\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xEF"],
        ["\x96\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE4"],
        ["\x96\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x54"],
        ["\x96\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF9"],
        ["\x96\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xAA"],
        ["\x96\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x5B"],
        ["\x96\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x49"],
        ["\x96\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x46"],
        ["\x96\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC8"],
        ["\x96\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x96"],
        ["\x96\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x99"],
        ["\x96\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x69"],
        ["\x96\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE6"],
        ["\x96\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xC1"],
        ["\x96\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x52"],
        ["\x96\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x5D"],
        ["\x96\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xBD"],
        ["\x96\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xE1"],
        ["\x96\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xAD"],
        ["\x96\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA1"],
        ["\x96\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC3"],
        ["\x96\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xEA"],
        ["\x96\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB3"],
        ["\x96\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x41"],
        ["\x96\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x98"],
        ["\x96\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC8"],
        ["\x96\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x5C"],
        ["\x96\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xAA"],
        ["\x97\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x9C"],
        ["\x97\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x93"],
        ["\x97\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE0"],
        ["\x97\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE6"],
        ["\x97\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xDA"],
        ["\x97\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x9C"],
        ["\x97\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xD4"],
        ["\x97\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x7A"],
        ["\x97\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x5F"],
        ["\x97\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD8"],
        ["\x97\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x7C"],
        ["\x97\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF2"],
        ["\x97\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x85"],
        ["\x97\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xE1"],
        ["\x97\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xBD"],
        ["\x97\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x7D"],
        ["\x97\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x4F"],
        ["\x97\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xDD"],
        ["\x97\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x7C"],
        ["\x97\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x8C"],
        ["\x97\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xF8"],
        ["\x97\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xCB"],
        ["\x97\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x8B"],
        ["\x97\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x92"],
        ["\x97\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xB7"],
        ["\x97\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x70"],
        ["\x97\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xC2"],
        ["\x97\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xC3"],
        ["\x97\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xC2"],
        ["\x97\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC1"],
        ["\x97\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x89"],
        ["\x97\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x8C"],
        ["\x97\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x6C"],
        ["\x97\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x4A"],
        ["\x97\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xDA"],
        ["\x97\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xAF"],
        ["\x97\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD1"],
        ["\x97\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x89"],
        ["\x97\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x5D"],
        ["\x97\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x46"],
        ["\x97\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x7E"],
        ["\x97\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x4E"],
        ["\x97\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xFE"],
        ["\x97\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD7"],
        ["\x97\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x48"],
        ["\x97\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xDA"],
        ["\x97\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xBE"],
        ["\x97\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x9D"],
        ["\x97\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xB6"],
        ["\x97\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA7"],
        ["\x97\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xD1"],
        ["\x97\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA0"],
        ["\x97\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF9"],
        ["\x97\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x83"],
        ["\x97\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x55"],
        ["\x97\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x7D"],
        ["\x97\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA8"],
        ["\x97\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x82"],
        ["\x97\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xBF"],
        ["\x97\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x79"],
        ["\x97\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF4"],
        ["\x97\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x66"],
        ["\x97\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF6"],
        ["\x97\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xD9"],
        ["\x97\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x7E"],
        ["\x97\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x9C"],
        ["\x97\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB5"],
        ["\x97\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x88"],
        ["\x97\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xFA"],
        ["\x97\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD6"],
        ["\x97\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x43"],
        ["\x97\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x76"],
        ["\x97\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC9"],
        ["\x97\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x7A"],
        ["\x97\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xD6"],
        ["\x97\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x50"],
        ["\x97\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE7"],
        ["\x97\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xF2"],
        ["\x97\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xBD"],
        ["\x97\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xBF"],
        ["\x97\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF5"],
        ["\x97\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x8C"],
        ["\x97\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xDE"],
        ["\x97\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA3"],
        ["\x97\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xED"],
        ["\x97\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA6"],
        ["\x97\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD0"],
        ["\x97\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xBC"],
        ["\x97\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC6"],
        ["\x97\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA2"],
        ["\x97\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x51"],
        ["\x97\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x58"],
        ["\x97\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xEB"],
        ["\x97\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x8C"],
        ["\x97\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x74"],
        ["\x97\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xA4"],
        ["\x97\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x4D"],
        ["\x97\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x6C"],
        ["\x97\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x97"],
        ["\x97\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x61"],
        ["\x97\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x91"],
        ["\x97\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x83"],
        ["\x97\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xDD"],
        ["\x97\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x9F"],
        ["\x97\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xE6"],
        ["\x97\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF0"],
        ["\x97\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x85"],
        ["\x97\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xFC"],
        ["\x97\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xC4"],
        ["\x97\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF7"],
        ["\x97\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xAB"],
        ["\x97\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x84"],
        ["\x97\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xA9"],
        ["\x97\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x5D"],
        ["\x97\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xE7"],
        ["\x97\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xCA"],
        ["\x97\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x7C"],
        ["\x97\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x49"],
        ["\x97\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xCF"],
        ["\x97\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x50"],
        ["\x97\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB1"],
        ["\x97\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x9C"],
        ["\x97\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x82"],
        ["\x97\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x83"],
        ["\x97\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x44"],
        ["\x97\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x7A"],
        ["\x97\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\x4E"],
        ["\x97\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x44"],
        ["\x97\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x74"],
        ["\x97\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x9D"],
        ["\x97\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB7"],
        ["\x97\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x7D"],
        ["\x97\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x96"],
        ["\x97\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xC5"],
        ["\x97\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xC4"],
        ["\x97\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x81"],
        ["\x97\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x6B"],
        ["\x97\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xB5"],
        ["\x97\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC7"],
        ["\x97\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xCD"],
        ["\x97\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xF7"],
        ["\x97\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA5"],
        ["\x97\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x51"],
        ["\x97\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x55"],
        ["\x97\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xA2"],
        ["\x97\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC7"],
        ["\x97\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x79"],
        ["\x97\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x53"],
        ["\x97\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xD0"],
        ["\x97\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xB7"],
        ["\x97\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE0"],
        ["\x97\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x4C"],
        ["\x97\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x9B"],
        ["\x97\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x8C"],
        ["\x97\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xEB"],
        ["\x97\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xDA"],
        ["\x97\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x48"],
        ["\x97\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x46\xBA"],
        ["\x97\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\xC3"],
        ["\x97\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x4A"],
        ["\x97\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x46"],
        ["\x97\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xFC"],
        ["\x97\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x92"],
        ["\x97\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xE8"],
        ["\x97\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x9F"],
        ["\x97\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\xF9"],
        ["\x97\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x58"],
        ["\x97\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x59"],
        ["\x97\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\xAE"],
        ["\x97\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x45"],
        ["\x97\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x69"],
        ["\x97\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x4B"],
        ["\x97\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xF3"],
        ["\x97\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x80"],
        ["\x97\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xCC"],
        ["\x97\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x55"],
        ["\x97\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xB4"],
        ["\x97\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x68"],
        ["\x97\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xD1"],
        ["\x97\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x60"],
        ["\x97\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xDB"],
        ["\x97\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xCA"],
        ["\x97\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x5B"],
        ["\x97\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE0"],
        ["\x97\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x6F"],
        ["\x97\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x70"],
        ["\x97\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x60"],
        ["\x97\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xCA"],
        ["\x98\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF4"],
        ["\x98\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x54"],
        ["\x98\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xE6"],
        ["\x98\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x50"],
        ["\x98\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF4"],
        ["\x98\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x86"],
        ["\x98\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x7D"],
        ["\x98\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xF8"],
        ["\x98\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x84"],
        ["\x98\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xC6"],
        ["\x98\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xA9"],
        ["\x98\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xF8"],
        ["\x98\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xA7"],
        ["\x98\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xBF"],
        ["\x98\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x6E"],
        ["\x98\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xBA"],
        ["\x98\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC7"],
        ["\x98\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x9D"],
        ["\x98\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xC4"],
        ["\x98\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC4"],
        ["\x98\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x6F"],
        ["\x98\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x44"],
        ["\x98\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x49\x85"],
        ["\x98\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE4"],
        ["\x98\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA1"],
        ["\x98\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x6E"],
        ["\x98\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x46"],
        ["\x98\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x9E"],
        ["\x98\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xAE"],
        ["\x98\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x7F"],
        ["\x98\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\x86"],
        ["\x98\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x48\xF3"],
        ["\x98\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xF9"],
        ["\x98\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x45\x7A"],
        ["\x98\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\x50"],
        ["\x98\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x8E"],
        ["\x98\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x67"],
        ["\x98\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x47\xE3"],
        ["\x98\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x78"],
        ["\x98\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD2"],
        ["\x98\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xF1"],
        ["\x98\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE8"],
        ["\x98\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\xE4"],
        ["\x98\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x93"],
        ["\x98\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xD3"],
        ["\x98\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xBB"],
        ["\x98\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xDE"],
        ["\x98\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x68"],
        ["\x98\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x6B"],
        ["\x98\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x5B"],
        ["\x98\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xAF"],
        ["\x98\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x41"],
        ["\x98\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x42"],
        ["\x98\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x43"],
        ["\x98\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x45"],
        ["\x98\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x46"],
        ["\x98\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x47"],
        ["\x98\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC8"],
        ["\x98\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x48"],
        ["\x98\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x49"],
        ["\x98\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x4A"],
        ["\x98\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x4B"],
        ["\x98\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x4D"],
        ["\x98\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x4E"],
        ["\x98\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x55"],
        ["\x98\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x4F"],
        ["\x98\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xDB"],
        ["\x98\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x51"],
        ["\x98\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x50"],
        ["\x98\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x52"],
        ["\x98\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x67"],
        ["\x98\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x53"],
        ["\x98\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x54"],
        ["\x98\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x55"],
        ["\x98\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x56"],
        ["\x98\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x57"],
        ["\x98\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x58"],
        ["\x98\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x59"],
        ["\x98\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x5A"],
        ["\x98\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x5B"],
        ["\x98\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x5C"],
        ["\x98\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x5E"],
        ["\x98\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x5F"],
        ["\x98\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x60"],
        ["\x98\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x61"],
        ["\x98\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x41"],
        ["\x98\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x63"],
        ["\x98\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x67"],
        ["\x98\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x68"],
        ["\x98\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x6F"],
        ["\x98\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x69"],
        ["\x98\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x6B"],
        ["\x98\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x6C"],
        ["\x98\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE2"],
        ["\x98\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x72"],
        ["\x98\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x73"],
        ["\x98\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x76"],
        ["\x98\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x77"],
        ["\x98\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x79"],
        ["\x98\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x7A"],
        ["\x98\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x8D"],
        ["\x98\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x7C"],
        ["\x98\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x7D"],
        ["\x98\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x7E"],
        ["\x98\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x90"],
        ["\x98\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x7F"],
        ["\x98\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC4"],
        ["\x98\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x80"],
        ["\x98\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x81"],
        ["\x98\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x82"],
        ["\x98\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x83"],
        ["\x98\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x84"],
        ["\x98\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x85"],
        ["\x98\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x87"],
        ["\x98\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x88"],
        ["\x98\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x89"],
        ["\x98\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x8B"],
        ["\x98\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x8C"],
        ["\x98\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x8D"],
        ["\x98\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x8E"],
        ["\x98\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x8F"],
        ["\x98\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x64"],
        ["\x98\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF8"],
        ["\x98\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x90"],
        ["\x98\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x92"],
        ["\x98\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x93"],
        ["\x98\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x95"],
        ["\x98\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x96"],
        ["\x98\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x97"],
        ["\x98\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x99"],
        ["\x98\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x9A"],
        ["\x98\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x9B"],
        ["\x98\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xAC"],
        ["\x98\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x9C"],
        ["\x98\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x9D"],
        ["\x98\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x9E"],
        ["\x98\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x9F"],
        ["\x98\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA0"],
        ["\x98\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA5"],
        ["\x98\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA6"],
        ["\x98\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA7"],
        ["\x98\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA9"],
        ["\x98\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xAA"],
        ["\x98\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xAB"],
        ["\x98\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xAD"],
        ["\x99\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xAE"],
        ["\x99\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xAF"],
        ["\x99\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB0"],
        ["\x99\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB1"],
        ["\x99\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD4"],
        ["\x99\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB3"],
        ["\x99\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB4"],
        ["\x99\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB6"],
        ["\x99\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB7"],
        ["\x99\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB8"],
        ["\x99\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xB9"],
        ["\x99\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xBA"],
        ["\x99\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xBB"],
        ["\x99\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xBC"],
        ["\x99\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xBD"],
        ["\x99\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC1"],
        ["\x99\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xBF"],
        ["\x99\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC0"],
        ["\x99\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xBE"],
        ["\x99\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC2"],
        ["\x99\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC3"],
        ["\x99\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC4"],
        ["\x99\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC5"],
        ["\x99\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC6"],
        ["\x99\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC7"],
        ["\x99\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC8"],
        ["\x99\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xCB"],
        ["\x99\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xCA"],
        ["\x99\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xCC"],
        ["\x99\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xCD"],
        ["\x99\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x5D"],
        ["\x99\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xCF"],
        ["\x99\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD0"],
        ["\x99\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD1"],
        ["\x99\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD2"],
        ["\x99\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD3"],
        ["\x99\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD4"],
        ["\x99\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD5"],
        ["\x99\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD6"],
        ["\x99\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD7"],
        ["\x99\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD8"],
        ["\x99\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xD9"],
        ["\x99\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xDA"],
        ["\x99\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xDB"],
        ["\x99\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xDD"],
        ["\x99\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xDE"],
        ["\x99\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xDF"],
        ["\x99\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE0"],
        ["\x99\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE1"],
        ["\x99\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE2"],
        ["\x99\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE3"],
        ["\x99\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE4"],
        ["\x99\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE5"],
        ["\x99\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE6"],
        ["\x99\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE7"],
        ["\x99\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xE9"],
        ["\x99\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xEA"],
        ["\x99\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xEB"],
        ["\x99\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xEC"],
        ["\x99\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xED"],
        ["\x99\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD1"],
        ["\x99\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xEE"],
        ["\x99\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF0"],
        ["\x99\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF1"],
        ["\x99\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF2"],
        ["\x99\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF3"],
        ["\x99\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF4"],
        ["\x99\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF5"],
        ["\x99\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF6"],
        ["\x99\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE3"],
        ["\x99\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF8"],
        ["\x99\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF9"],
        ["\x99\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xFA"],
        ["\x99\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xFB"],
        ["\x99\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xFC"],
        ["\x99\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x41"],
        ["\x99\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xFD"],
        ["\x99\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xFE"],
        ["\x99\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xAE"],
        ["\x99\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x42"],
        ["\x99\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x43"],
        ["\x99\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x45"],
        ["\x99\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x47"],
        ["\x99\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x48"],
        ["\x99\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x46"],
        ["\x99\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x49"],
        ["\x99\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x4A"],
        ["\x99\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x4B"],
        ["\x99\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x80"],
        ["\x99\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x4D"],
        ["\x99\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x44"],
        ["\x99\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x4C"],
        ["\x99\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x4E"],
        ["\x99\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xEC"],
        ["\x99\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xED"],
        ["\x99\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x51"],
        ["\x99\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x52"],
        ["\x99\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x53"],
        ["\x99\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x54"],
        ["\x99\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x55"],
        ["\x99\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x57"],
        ["\x99\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x92"],
        ["\x99\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x59"],
        ["\x99\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x5A"],
        ["\x99\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x5B"],
        ["\x99\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xDB"],
        ["\x99\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x5C"],
        ["\x99\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x5D"],
        ["\x99\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x5E"],
        ["\x99\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x5F"],
        ["\x99\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x60"],
        ["\x99\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x62"],
        ["\x99\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x64"],
        ["\x99\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x65"],
        ["\x99\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x66"],
        ["\x99\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x67"],
        ["\x99\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x68"],
        ["\x99\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x69"],
        ["\x99\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x6A"],
        ["\x99\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x6C"],
        ["\x99\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x6D"],
        ["\x99\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x6E"],
        ["\x99\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x6F"],
        ["\x99\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x70"],
        ["\x99\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x71"],
        ["\x99\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x73"],
        ["\x99\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x72"],
        ["\x99\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x75"],
        ["\x99\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x74"],
        ["\x99\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x76"],
        ["\x99\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x77"],
        ["\x99\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x79"],
        ["\x99\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x7A"],
        ["\x99\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x7B"],
        ["\x99\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC8"],
        ["\x99\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x7E"],
        ["\x99\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x7D"],
        ["\x99\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x7F"],
        ["\x99\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x81"],
        ["\x99\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x82"],
        ["\x99\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x83"],
        ["\x99\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x84"],
        ["\x99\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x85"],
        ["\x99\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x86"],
        ["\x99\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x88"],
        ["\x99\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x89"],
        ["\x99\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x8A"],
        ["\x99\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x88"],
        ["\x99\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x8C"],
        ["\x99\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x8D"],
        ["\x99\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x8F"],
        ["\x99\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x90"],
        ["\x99\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x91"],
        ["\x99\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x92"],
        ["\x99\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x93"],
        ["\x99\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x94"],
        ["\x99\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x95"],
        ["\x99\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x96"],
        ["\x99\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x97"],
        ["\x99\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x98"],
        ["\x99\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x99"],
        ["\x99\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x9A"],
        ["\x99\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x9B"],
        ["\x99\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x9C"],
        ["\x99\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x9D"],
        ["\x99\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x9E"],
        ["\x99\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x9F"],
        ["\x99\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA0"],
        ["\x99\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA1"],
        ["\x99\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA2"],
        ["\x99\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA3"],
        ["\x99\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA4"],
        ["\x99\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA5"],
        ["\x99\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA6"],
        ["\x99\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA7"],
        ["\x99\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA8"],
        ["\x99\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xAA"],
        ["\x99\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xAB"],
        ["\x99\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xAC"],
        ["\x99\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xAD"],
        ["\x99\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xAF"],
        ["\x99\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB2"],
        ["\x99\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB3"],
        ["\x99\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB4"],
        ["\x99\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB5"],
        ["\x99\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB6"],
        ["\x99\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB8"],
        ["\x99\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB9"],
        ["\x9A\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xBA"],
        ["\x9A\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xBB"],
        ["\x9A\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xBC"],
        ["\x9A\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xBE"],
        ["\x9A\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB0"],
        ["\x9A\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB7"],
        ["\x9A\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xBF"],
        ["\x9A\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC1"],
        ["\x9A\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC2"],
        ["\x9A\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC3"],
        ["\x9A\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC4"],
        ["\x9A\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC5"],
        ["\x9A\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC6"],
        ["\x9A\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x7C"],
        ["\x9A\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC7"],
        ["\x9A\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC8"],
        ["\x9A\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC9"],
        ["\x9A\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xCA"],
        ["\x9A\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xCB"],
        ["\x9A\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xCC"],
        ["\x9A\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xCD"],
        ["\x9A\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xCE"],
        ["\x9A\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xCF"],
        ["\x9A\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD0"],
        ["\x9A\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD1"],
        ["\x9A\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD2"],
        ["\x9A\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD3"],
        ["\x9A\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD4"],
        ["\x9A\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD5"],
        ["\x9A\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xB1"],
        ["\x9A\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD6"],
        ["\x9A\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD7"],
        ["\x9A\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD8"],
        ["\x9A\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xD9"],
        ["\x9A\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xDA"],
        ["\x9A\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xDB"],
        ["\x9A\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xDC"],
        ["\x9A\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xDD"],
        ["\x9A\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xDF"],
        ["\x9A\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE0"],
        ["\x9A\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE1"],
        ["\x9A\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE2"],
        ["\x9A\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA2"],
        ["\x9A\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE3"],
        ["\x9A\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE4"],
        ["\x9A\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE5"],
        ["\x9A\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE6"],
        ["\x9A\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE7"],
        ["\x9A\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE8"],
        ["\x9A\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xEA"],
        ["\x9A\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xEB"],
        ["\x9A\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xEC"],
        ["\x9A\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xED"],
        ["\x9A\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xEE"],
        ["\x9A\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xEF"],
        ["\x9A\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xE9"],
        ["\x9A\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF0"],
        ["\x9A\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF1"],
        ["\x9A\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xFB"],
        ["\x9A\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x7F"],
        ["\x9A\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF2"],
        ["\x9A\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF3"],
        ["\x9A\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF4"],
        ["\x9A\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF5"],
        ["\x9A\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF6"],
        ["\x9A\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF8"],
        ["\x9A\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF9"],
        ["\x9A\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xFA"],
        ["\x9A\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xF7"],
        ["\x9A\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xFE"],
        ["\x9A\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x41"],
        ["\x9A\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x42"],
        ["\x9A\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xFC"],
        ["\x9A\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xFD"],
        ["\x9A\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x43"],
        ["\x9A\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x44"],
        ["\x9A\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x45"],
        ["\x9A\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x46"],
        ["\x9A\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x48"],
        ["\x9A\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x49"],
        ["\x9A\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x4A"],
        ["\x9A\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x4B"],
        ["\x9A\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x4C"],
        ["\x9A\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x47"],
        ["\x9A\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x4D"],
        ["\x9A\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x4F"],
        ["\x9A\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x4E"],
        ["\x9A\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x50"],
        ["\x9A\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x51"],
        ["\x9A\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x52"],
        ["\x9A\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x66"],
        ["\x9A\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x53"],
        ["\x9A\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x54"],
        ["\x9A\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x55"],
        ["\x9A\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x56"],
        ["\x9A\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xBD"],
        ["\x9A\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x57"],
        ["\x9A\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE7"],
        ["\x9A\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x59"],
        ["\x9A\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x5A"],
        ["\x9A\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x58"],
        ["\x9A\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x5B"],
        ["\x9A\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x5C"],
        ["\x9A\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD1"],
        ["\x9A\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x5D"],
        ["\x9A\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x5E"],
        ["\x9A\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x5F"],
        ["\x9A\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x61"],
        ["\x9A\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x62"],
        ["\x9A\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x98"],
        ["\x9A\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x71"],
        ["\x9A\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x64"],
        ["\x9A\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x65"],
        ["\x9A\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x66"],
        ["\x9A\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x67"],
        ["\x9A\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x68"],
        ["\x9A\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x69"],
        ["\x9A\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x6B"],
        ["\x9A\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x6A"],
        ["\x9A\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x6D"],
        ["\x9A\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xCD"],
        ["\x9A\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x6E"],
        ["\x9A\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x6F"],
        ["\x9A\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x72"],
        ["\x9A\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x74"],
        ["\x9A\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x75"],
        ["\x9A\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x78"],
        ["\x9A\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x76"],
        ["\x9A\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x79"],
        ["\x9A\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x7A"],
        ["\x9A\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x7B"],
        ["\x9A\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA7"],
        ["\x9A\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x86"],
        ["\x9A\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x7C"],
        ["\x9A\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x7E"],
        ["\x9A\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x7D"],
        ["\x9A\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x83"],
        ["\x9A\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x7F"],
        ["\x9A\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x81"],
        ["\x9A\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x80"],
        ["\x9A\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x84"],
        ["\x9A\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x85"],
        ["\x9A\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x8D"],
        ["\x9A\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x87"],
        ["\x9A\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x88"],
        ["\x9A\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x8E"],
        ["\x9A\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x95"],
        ["\x9A\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x52"],
        ["\x9A\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x89"],
        ["\x9A\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x8B"],
        ["\x9A\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x8F"],
        ["\x9A\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x90"],
        ["\x9A\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x91"],
        ["\x9A\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x92"],
        ["\x9A\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x93"],
        ["\x9A\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x94"],
        ["\x9A\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x99"],
        ["\x9A\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x96"],
        ["\x9A\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x98"],
        ["\x9A\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x97"],
        ["\x9A\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x9A"],
        ["\x9A\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x77"],
        ["\x9A\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x9C"],
        ["\x9A\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x9D"],
        ["\x9A\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x9E"],
        ["\x9A\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x75"],
        ["\x9A\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x9F"],
        ["\x9A\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA0"],
        ["\x9A\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA2"],
        ["\x9A\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA3"],
        ["\x9A\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA4"],
        ["\x9A\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA5"],
        ["\x9A\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA6"],
        ["\x9A\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA7"],
        ["\x9A\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA8"],
        ["\x9A\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA9"],
        ["\x9A\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xAA"],
        ["\x9A\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x4E"],
        ["\x9A\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xAB"],
        ["\x9A\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xAC"],
        ["\x9A\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x8F"],
        ["\x9A\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xAE"],
        ["\x9A\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xAF"],
        ["\x9A\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB3"],
        ["\x9A\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB4"],
        ["\x9A\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB5"],
        ["\x9A\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB6"],
        ["\x9A\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB7"],
        ["\x9B\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB8"],
        ["\x9B\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB9"],
        ["\x9B\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xBC"],
        ["\x9B\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x6D"],
        ["\x9B\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x78"],
        ["\x9B\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xBD"],
        ["\x9B\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xBF"],
        ["\x9B\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC1"],
        ["\x9B\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC2"],
        ["\x9B\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x84"],
        ["\x9B\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xBA"],
        ["\x9B\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC3"],
        ["\x9B\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC4"],
        ["\x9B\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC5"],
        ["\x9B\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC6"],
        ["\x9B\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC7"],
        ["\x9B\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC8"],
        ["\x9B\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xCA"],
        ["\x9B\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xC9"],
        ["\x9B\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xCB"],
        ["\x9B\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xCC"],
        ["\x9B\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xCD"],
        ["\x9B\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xCE"],
        ["\x9B\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xCF"],
        ["\x9B\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD0"],
        ["\x9B\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD1"],
        ["\x9B\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD2"],
        ["\x9B\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD3"],
        ["\x9B\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD4"],
        ["\x9B\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD6"],
        ["\x9B\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD7"],
        ["\x9B\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD8"],
        ["\x9B\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD9"],
        ["\x9B\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xDA"],
        ["\x9B\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xDB"],
        ["\x9B\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xDC"],
        ["\x9B\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xDD"],
        ["\x9B\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xDE"],
        ["\x9B\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xDF"],
        ["\x9B\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE0"],
        ["\x9B\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE1"],
        ["\x9B\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE2"],
        ["\x9B\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE3"],
        ["\x9B\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xD5"],
        ["\x9B\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE4"],
        ["\x9B\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE5"],
        ["\x9B\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE6"],
        ["\x9B\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE7"],
        ["\x9B\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE8"],
        ["\x9B\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xE9"],
        ["\x9B\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xEA"],
        ["\x9B\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xEB"],
        ["\x9B\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x58"],
        ["\x9B\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xEE"],
        ["\x9B\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xEF"],
        ["\x9B\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF0"],
        ["\x9B\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF1"],
        ["\x9B\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF2"],
        ["\x9B\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF3"],
        ["\x9B\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF4"],
        ["\x9B\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xED"],
        ["\x9B\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF5"],
        ["\x9B\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF6"],
        ["\x9B\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF7"],
        ["\x9B\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF8"],
        ["\x9B\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xF9"],
        ["\x9B\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xFA"],
        ["\x9B\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xFB"],
        ["\x9B\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xFD"],
        ["\x9B\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x44"],
        ["\x9B\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x41"],
        ["\x9B\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x45"],
        ["\x9B\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xFC"],
        ["\x9B\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x46"],
        ["\x9B\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x43"],
        ["\x9B\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x47"],
        ["\x9B\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x48"],
        ["\x9B\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x49"],
        ["\x9B\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x4B"],
        ["\x9B\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x4A"],
        ["\x9B\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x4C"],
        ["\x9B\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x4D"],
        ["\x9B\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x4E"],
        ["\x9B\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x4F"],
        ["\x9B\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x50"],
        ["\x9B\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x52"],
        ["\x9B\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x53"],
        ["\x9B\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x54"],
        ["\x9B\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x55"],
        ["\x9B\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x5D"],
        ["\x9B\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x56"],
        ["\x9B\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x57"],
        ["\x9B\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x58"],
        ["\x9B\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x59"],
        ["\x9B\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x5A"],
        ["\x9B\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x43"],
        ["\x9B\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x5B"],
        ["\x9B\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x5C"],
        ["\x9B\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x5D"],
        ["\x9B\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x4C"],
        ["\x9B\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x5E"],
        ["\x9B\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x5F"],
        ["\x9B\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x60"],
        ["\x9B\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x5A"],
        ["\x9B\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x61"],
        ["\x9B\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xBB"],
        ["\x9B\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x63"],
        ["\x9B\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x64"],
        ["\x9B\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x65"],
        ["\x9B\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x6A"],
        ["\x9B\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x66"],
        ["\x9B\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x69"],
        ["\x9B\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x62"],
        ["\x9B\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x6B"],
        ["\x9B\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x6C"],
        ["\x9B\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x6D"],
        ["\x9B\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x6E"],
        ["\x9B\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x6F"],
        ["\x9B\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x71"],
        ["\x9B\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x8C"],
        ["\x9B\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x72"],
        ["\x9B\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x73"],
        ["\x9B\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x74"],
        ["\x9B\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF1"],
        ["\x9B\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x81"],
        ["\x9B\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x75"],
        ["\x9B\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x76"],
        ["\x9B\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x77"],
        ["\x9B\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x4D"],
        ["\x9B\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x79"],
        ["\x9B\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x7A"],
        ["\x9B\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x7B"],
        ["\x9B\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x7C"],
        ["\x9B\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x7D"],
        ["\x9B\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x7E"],
        ["\x9B\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x82"],
        ["\x9B\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x83"],
        ["\x9B\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x85"],
        ["\x9B\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x86"],
        ["\x9B\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x88"],
        ["\x9B\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x89"],
        ["\x9B\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x8A"],
        ["\x9B\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x8B"],
        ["\x9B\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x8D"],
        ["\x9B\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x8E"],
        ["\x9B\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x90"],
        ["\x9B\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x91"],
        ["\x9B\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x84"],
        ["\x9B\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x8F"],
        ["\x9B\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x92"],
        ["\x9B\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x94"],
        ["\x9B\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x96"],
        ["\x9B\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x81"],
        ["\x9B\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x98"],
        ["\x9B\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x99"],
        ["\x9B\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xDF"],
        ["\x9B\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x9A"],
        ["\x9B\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x9B"],
        ["\x9B\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4A\x4B"],
        ["\x9B\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x9C"],
        ["\x9B\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x9D"],
        ["\x9B\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x9E"],
        ["\x9B\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x9F"],
        ["\x9B\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA0"],
        ["\x9B\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA1"],
        ["\x9B\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA2"],
        ["\x9B\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xBE"],
        ["\x9B\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA3"],
        ["\x9B\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA4"],
        ["\x9B\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA5"],
        ["\x9B\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA7"],
        ["\x9B\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA8"],
        ["\x9B\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA9"],
        ["\x9B\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x83"],
        ["\x9B\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xAA"],
        ["\x9B\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xAB"],
        ["\x9B\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xA6"],
        ["\x9B\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xAC"],
        ["\x9B\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xAD"],
        ["\x9B\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xAE"],
        ["\x9B\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x50"],
        ["\x9B\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xAF"],
        ["\x9B\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB0"],
        ["\x9B\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB1"],
        ["\x9B\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB2"],
        ["\x9B\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB3"],
        ["\x9B\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB4"],
        ["\x9B\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB5"],
        ["\x9C\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x6C"],
        ["\x9C\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE9"],
        ["\x9C\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB6"],
        ["\x9C\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB7"],
        ["\x9C\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB8"],
        ["\x9C\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xB9"],
        ["\x9C\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xBA"],
        ["\x9C\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xBB"],
        ["\x9C\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xBC"],
        ["\x9C\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xBD"],
        ["\x9C\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xBF"],
        ["\x9C\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC0"],
        ["\x9C\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xBE"],
        ["\x9C\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC1"],
        ["\x9C\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD6"],
        ["\x9C\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x4B"],
        ["\x9C\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC2"],
        ["\x9C\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC3"],
        ["\x9C\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD6"],
        ["\x9C\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD5"],
        ["\x9C\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC4"],
        ["\x9C\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC5"],
        ["\x9C\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC6"],
        ["\x9C\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC8"],
        ["\x9C\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xC9"],
        ["\x9C\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xCC"],
        ["\x9C\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xCE"],
        ["\x9C\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xCF"],
        ["\x9C\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD0"],
        ["\x9C\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xCA"],
        ["\x9C\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD1"],
        ["\x9C\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD2"],
        ["\x9C\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD3"],
        ["\x9C\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD4"],
        ["\x9C\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD7"],
        ["\x9C\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x9C"],
        ["\x9C\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD9"],
        ["\x9C\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xDA"],
        ["\x9C\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xDB"],
        ["\x9C\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xDC"],
        ["\x9C\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xDD"],
        ["\x9C\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xDE"],
        ["\x9C\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xDF"],
        ["\x9C\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE1"],
        ["\x9C\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE0"],
        ["\x9C\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE3"],
        ["\x9C\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE2"],
        ["\x9C\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE4"],
        ["\x9C\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE5"],
        ["\x9C\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE6"],
        ["\x9C\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE7"],
        ["\x9C\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE9"],
        ["\x9C\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xEA"],
        ["\x9C\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xEB"],
        ["\x9C\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xEC"],
        ["\x9C\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xED"],
        ["\x9C\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xEE"],
        ["\x9C\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF0"],
        ["\x9C\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x76"],
        ["\x9C\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF2"],
        ["\x9C\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF3"],
        ["\x9C\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x43"],
        ["\x9C\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF4"],
        ["\x9C\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF5"],
        ["\x9C\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF6"],
        ["\x9C\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF7"],
        ["\x9C\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF8"],
        ["\x9C\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF9"],
        ["\x9C\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xFA"],
        ["\x9C\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xFB"],
        ["\x9C\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xFC"],
        ["\x9C\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xFD"],
        ["\x9C\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xFE"],
        ["\x9C\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x41"],
        ["\x9C\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x42"],
        ["\x9C\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x45"],
        ["\x9C\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x46"],
        ["\x9C\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x47"],
        ["\x9C\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x48"],
        ["\x9C\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x49"],
        ["\x9C\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x4A"],
        ["\x9C\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x4B"],
        ["\x9C\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x4C"],
        ["\x9C\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x4D"],
        ["\x9C\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x56"],
        ["\x9C\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x4E"],
        ["\x9C\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x4F"],
        ["\x9C\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x50"],
        ["\x9C\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x52"],
        ["\x9C\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x44"],
        ["\x9C\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x4A"],
        ["\x9C\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x53"],
        ["\x9C\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x54"],
        ["\x9C\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x55"],
        ["\x9C\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x56"],
        ["\x9C\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x58"],
        ["\x9C\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x59"],
        ["\x9C\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x5A"],
        ["\x9C\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x5B"],
        ["\x9C\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x5C"],
        ["\x9C\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x5D"],
        ["\x9C\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x5E"],
        ["\x9C\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x60"],
        ["\x9C\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x61"],
        ["\x9C\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xA3"],
        ["\x9C\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xEF"],
        ["\x9C\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x62"],
        ["\x9C\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x63"],
        ["\x9C\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x64"],
        ["\x9C\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x66"],
        ["\x9C\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x78"],
        ["\x9C\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x69"],
        ["\x9C\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x6A"],
        ["\x9C\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x6B"],
        ["\x9C\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x6C"],
        ["\x9C\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x6D"],
        ["\x9C\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x6E"],
        ["\x9C\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x6F"],
        ["\x9C\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x70"],
        ["\x9C\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x71"],
        ["\x9C\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x72"],
        ["\x9C\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x73"],
        ["\x9C\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x74"],
        ["\x9C\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x75"],
        ["\x9C\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x77"],
        ["\x9C\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x7C"],
        ["\x9C\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x7A"],
        ["\x9C\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x7B"],
        ["\x9C\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x7D"],
        ["\x9C\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE3"],
        ["\x9C\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x7F"],
        ["\x9C\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x80"],
        ["\x9C\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x81"],
        ["\x9C\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x84"],
        ["\x9C\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x85"],
        ["\x9C\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x86"],
        ["\x9C\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x87"],
        ["\x9C\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x89"],
        ["\x9C\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x8A"],
        ["\x9C\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x8B"],
        ["\x9C\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x8C"],
        ["\x9C\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x8D"],
        ["\x9C\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x8E"],
        ["\x9C\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x8F"],
        ["\x9C\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x82"],
        ["\x9C\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x90"],
        ["\x9C\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x91"],
        ["\x9C\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x83"],
        ["\x9C\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x92"],
        ["\x9C\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x93"],
        ["\x9C\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x95"],
        ["\x9C\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x96"],
        ["\x9C\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x88"],
        ["\x9C\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x97"],
        ["\x9C\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x98"],
        ["\x9C\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xCF"],
        ["\x9C\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x99"],
        ["\x9C\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x9A"],
        ["\x9C\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x9B"],
        ["\x9C\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x9C"],
        ["\x9C\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x9D"],
        ["\x9C\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x9E"],
        ["\x9C\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x9F"],
        ["\x9C\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xAA"],
        ["\x9C\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA0"],
        ["\x9C\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA1"],
        ["\x9C\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA2"],
        ["\x9C\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA3"],
        ["\x9C\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA4"],
        ["\x9C\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA5"],
        ["\x9C\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA6"],
        ["\x9C\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA7"],
        ["\x9C\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA8"],
        ["\x9C\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xAB"],
        ["\x9C\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xAD"],
        ["\x9C\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xA9"],
        ["\x9C\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xAE"],
        ["\x9C\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xAC"],
        ["\x9C\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xAF"],
        ["\x9C\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB0"],
        ["\x9C\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB1"],
        ["\x9C\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB2"],
        ["\x9C\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB3"],
        ["\x9C\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB4"],
        ["\x9C\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x60"],
        ["\x9C\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB6"],
        ["\x9C\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB7"],
        ["\x9D\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB8"],
        ["\x9D\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xB9"],
        ["\x9D\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xBA"],
        ["\x9D\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xBB"],
        ["\x9D\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xBC"],
        ["\x9D\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xBD"],
        ["\x9D\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xBE"],
        ["\x9D\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xBF"],
        ["\x9D\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC0"],
        ["\x9D\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC1"],
        ["\x9D\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC2"],
        ["\x9D\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC3"],
        ["\x9D\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC4"],
        ["\x9D\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC5"],
        ["\x9D\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC6"],
        ["\x9D\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC7"],
        ["\x9D\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC8"],
        ["\x9D\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xCA"],
        ["\x9D\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xC9"],
        ["\x9D\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xCB"],
        ["\x9D\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xCC"],
        ["\x9D\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD7"],
        ["\x9D\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xCD"],
        ["\x9D\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xCE"],
        ["\x9D\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xCF"],
        ["\x9D\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD0"],
        ["\x9D\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD1"],
        ["\x9D\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD2"],
        ["\x9D\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE6"],
        ["\x9D\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD4"],
        ["\x9D\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x60"],
        ["\x9D\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD5"],
        ["\x9D\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD6"],
        ["\x9D\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x45"],
        ["\x9D\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD8"],
        ["\x9D\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD9"],
        ["\x9D\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xDB"],
        ["\x9D\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xDC"],
        ["\x9D\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xDD"],
        ["\x9D\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xDE"],
        ["\x9D\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xDF"],
        ["\x9D\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE0"],
        ["\x9D\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE1"],
        ["\x9D\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE2"],
        ["\x9D\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE3"],
        ["\x9D\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE4"],
        ["\x9D\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE5"],
        ["\x9D\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE7"],
        ["\x9D\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE9"],
        ["\x9D\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xE8"],
        ["\x9D\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x48"],
        ["\x9D\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xEA"],
        ["\x9D\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xEB"],
        ["\x9D\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xEC"],
        ["\x9D\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xED"],
        ["\x9D\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xEE"],
        ["\x9D\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xEF"],
        ["\x9D\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF0"],
        ["\x9D\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF1"],
        ["\x9D\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF2"],
        ["\x9D\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF3"],
        ["\x9D\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF6"],
        ["\x9D\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF4"],
        ["\x9D\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF5"],
        ["\x9D\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF7"],
        ["\x9D\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF8"],
        ["\x9D\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xF9"],
        ["\x9D\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xFA"],
        ["\x9D\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xFC"],
        ["\x9D\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xFD"],
        ["\x9D\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xFE"],
        ["\x9D\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x41"],
        ["\x9D\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x42"],
        ["\x9D\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x4C"],
        ["\x9D\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x43"],
        ["\x9D\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x44"],
        ["\x9D\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x45"],
        ["\x9D\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x46"],
        ["\x9D\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x47"],
        ["\x9D\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x71"],
        ["\x9D\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x49"],
        ["\x9D\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x4A"],
        ["\x9D\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x4B"],
        ["\x9D\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x4E"],
        ["\x9D\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x4F"],
        ["\x9D\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x51"],
        ["\x9D\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x4D"],
        ["\x9D\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x7F"],
        ["\x9D\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x55"],
        ["\x9D\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x57"],
        ["\x9D\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x58"],
        ["\x9D\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x59"],
        ["\x9D\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x5A"],
        ["\x9D\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x5B"],
        ["\x9D\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x5C"],
        ["\x9D\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x5D"],
        ["\x9D\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x5E"],
        ["\x9D\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x5F"],
        ["\x9D\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x56"],
        ["\x9D\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x61"],
        ["\x9D\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x62"],
        ["\x9D\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x63"],
        ["\x9D\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x64"],
        ["\x9D\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x78"],
        ["\x9D\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x65"],
        ["\x9D\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x66"],
        ["\x9D\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xD3"],
        ["\x9D\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x67"],
        ["\x9D\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x68"],
        ["\x9D\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x76"],
        ["\x9D\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x6A"],
        ["\x9D\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x69"],
        ["\x9D\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x6B"],
        ["\x9D\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x6C"],
        ["\x9D\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x6D"],
        ["\x9D\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x6E"],
        ["\x9D\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x6F"],
        ["\x9D\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x70"],
        ["\x9D\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x72"],
        ["\x9D\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x73"],
        ["\x9D\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x74"],
        ["\x9D\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x75"],
        ["\x9D\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x77"],
        ["\x9D\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x78"],
        ["\x9D\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x79"],
        ["\x9D\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x7A"],
        ["\x9D\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x7B"],
        ["\x9D\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x7C"],
        ["\x9D\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x7D"],
        ["\x9D\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x7F"],
        ["\x9D\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x82"],
        ["\x9D\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x80"],
        ["\x9D\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x81"],
        ["\x9D\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB1"],
        ["\x9D\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x83"],
        ["\x9D\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x84"],
        ["\x9D\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x85"],
        ["\x9D\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x86"],
        ["\x9D\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x87"],
        ["\x9D\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x88"],
        ["\x9D\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x89"],
        ["\x9D\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x8A"],
        ["\x9D\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x8B"],
        ["\x9D\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x8C"],
        ["\x9D\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x8D"],
        ["\x9D\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x8E"],
        ["\x9D\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x8F"],
        ["\x9D\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x90"],
        ["\x9D\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x91"],
        ["\x9D\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x92"],
        ["\x9D\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x65"],
        ["\x9D\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x93"],
        ["\x9D\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x95"],
        ["\x9D\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x94"],
        ["\x9D\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x96"],
        ["\x9D\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x9A"],
        ["\x9D\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x8E"],
        ["\x9D\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x9B"],
        ["\x9D\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x9C"],
        ["\x9D\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE0"],
        ["\x9D\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x9F"],
        ["\x9D\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x93"],
        ["\x9D\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA2"],
        ["\x9D\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA3"],
        ["\x9D\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xEA"],
        ["\x9D\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA5"],
        ["\x9D\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA6"],
        ["\x9D\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x51"],
        ["\x9D\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA9"],
        ["\x9D\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xAD"],
        ["\x9D\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xAA"],
        ["\x9D\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xA0"],
        ["\x9D\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB2"],
        ["\x9D\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xCE"],
        ["\x9D\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xAC"],
        ["\x9D\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB0"],
        ["\x9D\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB1"],
        ["\x9D\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB2"],
        ["\x9D\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xAB"],
        ["\x9D\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xD1"],
        ["\x9D\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB3"],
        ["\x9D\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB5"],
        ["\x9D\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB7"],
        ["\x9D\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xBA"],
        ["\x9D\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x43"],
        ["\x9D\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xBC"],
        ["\x9D\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xBD"],
        ["\x9D\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xBE"],
        ["\x9E\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB9"],
        ["\x9E\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xBF"],
        ["\x9E\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC0"],
        ["\x9E\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC1"],
        ["\x9E\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xCC"],
        ["\x9E\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x9E"],
        ["\x9E\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC2"],
        ["\x9E\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC3"],
        ["\x9E\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC4"],
        ["\x9E\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC5"],
        ["\x9E\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC6"],
        ["\x9E\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xFD"],
        ["\x9E\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xCA"],
        ["\x9E\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xCB"],
        ["\x9E\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xCD"],
        ["\x9E\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xCE"],
        ["\x9E\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xCF"],
        ["\x9E\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD0"],
        ["\x9E\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD1"],
        ["\x9E\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD2"],
        ["\x9E\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x4F"],
        ["\x9E\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD4"],
        ["\x9E\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD3"],
        ["\x9E\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD5"],
        ["\x9E\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD6"],
        ["\x9E\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x80"],
        ["\x9E\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD7"],
        ["\x9E\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x91"],
        ["\x9E\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD9"],
        ["\x9E\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xDA"],
        ["\x9E\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xDC"],
        ["\x9E\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xDD"],
        ["\x9E\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xDF"],
        ["\x9E\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xDE"],
        ["\x9E\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF2"],
        ["\x9E\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xDF"],
        ["\x9E\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE1"],
        ["\x9E\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE2"],
        ["\x9E\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xDB"],
        ["\x9E\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE4"],
        ["\x9E\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE5"],
        ["\x9E\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE6"],
        ["\x9E\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE7"],
        ["\x9E\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC9"],
        ["\x9E\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE8"],
        ["\x9E\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE9"],
        ["\x9E\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xEB"],
        ["\x9E\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF3"],
        ["\x9E\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xED"],
        ["\x9E\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xEE"],
        ["\x9E\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xEF"],
        ["\x9E\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF2"],
        ["\x9E\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF1"],
        ["\x9E\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF4"],
        ["\x9E\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xEA"],
        ["\x9E\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\x55"],
        ["\x9E\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF5"],
        ["\x9E\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF6"],
        ["\x9E\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xDE"],
        ["\x9E\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF8"],
        ["\x9E\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF7"],
        ["\x9E\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xFA"],
        ["\x9E\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xFB"],
        ["\x9E\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x61"],
        ["\x9E\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE2"],
        ["\x9E\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xFD"],
        ["\x9E\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xFC"],
        ["\x9E\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x41"],
        ["\x9E\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x42"],
        ["\x9E\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x43"],
        ["\x9E\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x45"],
        ["\x9E\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x46"],
        ["\x9E\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x47"],
        ["\x9E\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x92"],
        ["\x9E\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xBC"],
        ["\x9E\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x48"],
        ["\x9E\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x5D"],
        ["\x9E\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x4A"],
        ["\x9E\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x4B"],
        ["\x9E\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x4C"],
        ["\x9E\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC6"],
        ["\x9E\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x4D"],
        ["\x9E\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x4E"],
        ["\x9E\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xFE"],
        ["\x9E\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x44"],
        ["\x9E\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x4F"],
        ["\x9E\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x50"],
        ["\x9E\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x51"],
        ["\x9E\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x52"],
        ["\x9E\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x61"],
        ["\x9E\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x53"],
        ["\x9E\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x54"],
        ["\x9E\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x55"],
        ["\x9E\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x56"],
        ["\x9E\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x57"],
        ["\x9E\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x58"],
        ["\x9E\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x59"],
        ["\x9E\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x69"],
        ["\x9E\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x5A"],
        ["\x9E\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x5C"],
        ["\x9E\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC2"],
        ["\x9E\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x5D"],
        ["\x9E\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xFA"],
        ["\x9E\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x94"],
        ["\x9E\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x5E"],
        ["\x9E\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x5B"],
        ["\x9E\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x65"],
        ["\x9E\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x62"],
        ["\x9E\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x70"],
        ["\x9E\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x64"],
        ["\x9E\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x63"],
        ["\x9E\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x60"],
        ["\x9E\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x67"],
        ["\x9E\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x68"],
        ["\x9E\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE2"],
        ["\x9E\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x6A"],
        ["\x9E\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA2"],
        ["\x9E\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x6B"],
        ["\x9E\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x74"],
        ["\x9E\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xEF"],
        ["\x9E\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xED"],
        ["\x9E\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x6D"],
        ["\x9E\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x6F"],
        ["\x9E\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x70"],
        ["\x9E\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x71"],
        ["\x9E\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x7C"],
        ["\x9E\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x72"],
        ["\x9E\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x73"],
        ["\x9E\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x75"],
        ["\x9E\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x6C"],
        ["\x9E\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x76"],
        ["\x9E\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x4A"],
        ["\x9E\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x8C"],
        ["\x9E\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x77"],
        ["\x9E\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x7A"],
        ["\x9E\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x7B"],
        ["\x9E\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x7C"],
        ["\x9E\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x7D"],
        ["\x9E\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x7E"],
        ["\x9E\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x7F"],
        ["\x9E\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x81"],
        ["\x9E\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x82"],
        ["\x9E\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x83"],
        ["\x9E\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x8D"],
        ["\x9E\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x88"],
        ["\x9E\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x76"],
        ["\x9E\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x84"],
        ["\x9E\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x85"],
        ["\x9E\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x86"],
        ["\x9E\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB2"],
        ["\x9E\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x87"],
        ["\x9E\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x89"],
        ["\x9E\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x8A"],
        ["\x9E\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x8B"],
        ["\x9E\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x8C"],
        ["\x9E\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC1"],
        ["\x9E\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x8D"],
        ["\x9E\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x8E"],
        ["\x9E\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x8F"],
        ["\x9E\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xBB"],
        ["\x9E\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x80"],
        ["\x9E\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x91"],
        ["\x9E\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x92"],
        ["\x9E\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x93"],
        ["\x9E\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x94"],
        ["\x9E\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x95"],
        ["\x9E\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x97"],
        ["\x9E\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB7"],
        ["\x9E\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x98"],
        ["\x9E\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x99"],
        ["\x9E\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x9C"],
        ["\x9E\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x9D"],
        ["\x9E\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA8"],
        ["\x9E\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x9F"],
        ["\x9E\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA0"],
        ["\x9E\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA1"],
        ["\x9E\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA2"],
        ["\x9E\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA3"],
        ["\x9E\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA4"],
        ["\x9E\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA5"],
        ["\x9E\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA7"],
        ["\x9E\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x96"],
        ["\x9E\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xAA"],
        ["\x9E\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xAB"],
        ["\x9E\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x9E"],
        ["\x9E\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xAC"],
        ["\x9E\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xAD"],
        ["\x9E\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xAE"],
        ["\x9F\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB0"],
        ["\x9F\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xBE"],
        ["\x9F\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB3"],
        ["\x9F\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x8B"],
        ["\x9F\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB4"],
        ["\x9F\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB5"],
        ["\x9F\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB6"],
        ["\x9F\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB1"],
        ["\x9F\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB8"],
        ["\x9F\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xBA"],
        ["\x9F\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x62"],
        ["\x9F\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xB2"],
        ["\x9F\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xBB"],
        ["\x9F\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xBF"],
        ["\x9F\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xEE"],
        ["\x9F\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC0"],
        ["\x9F\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xBD"],
        ["\x9F\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC2"],
        ["\x9F\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC3"],
        ["\x9F\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC4"],
        ["\x9F\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x86"],
        ["\x9F\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC5"],
        ["\x9F\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC6"],
        ["\x9F\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC7"],
        ["\x9F\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC9"],
        ["\x9F\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xC8"],
        ["\x9F\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xCA"],
        ["\x9F\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xCB"],
        ["\x9F\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xCC"],
        ["\x9F\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xCD"],
        ["\x9F\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xCE"],
        ["\x9F\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xCF"],
        ["\x9F\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD0"],
        ["\x9F\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD1"],
        ["\x9F\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD2"],
        ["\x9F\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD3"],
        ["\x9F\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD4"],
        ["\x9F\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD5"],
        ["\x9F\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD6"],
        ["\x9F\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD7"],
        ["\x9F\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD8"],
        ["\x9F\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xD9"],
        ["\x9F\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xDA"],
        ["\x9F\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xDB"],
        ["\x9F\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xDC"],
        ["\x9F\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xDD"],
        ["\x9F\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xDE"],
        ["\x9F\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xDF"],
        ["\x9F\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE0"],
        ["\x9F\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE1"],
        ["\x9F\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE3"],
        ["\x9F\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE2"],
        ["\x9F\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE4"],
        ["\x9F\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE5"],
        ["\x9F\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE6"],
        ["\x9F\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE7"],
        ["\x9F\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE8"],
        ["\x9F\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xE9"],
        ["\x9F\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xEB"],
        ["\x9F\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xEC"],
        ["\x9F\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xED"],
        ["\x9F\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xEE"],
        ["\x9F\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xEF"],
        ["\x9F\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x51"],
        ["\x9F\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF0"],
        ["\x9F\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF1"],
        ["\x9F\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF2"],
        ["\x9F\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF3"],
        ["\x9F\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF4"],
        ["\x9F\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF5"],
        ["\x9F\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF7"],
        ["\x9F\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF8"],
        ["\x9F\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xFA"],
        ["\x9F\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB4"],
        ["\x9F\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xFB"],
        ["\x9F\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xFC"],
        ["\x9F\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x41"],
        ["\x9F\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x42"],
        ["\x9F\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x43"],
        ["\x9F\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x44"],
        ["\x9F\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x45"],
        ["\x9F\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x46"],
        ["\x9F\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x47"],
        ["\x9F\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x48"],
        ["\x9F\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x49"],
        ["\x9F\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x4A"],
        ["\x9F\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD7"],
        ["\x9F\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x4B"],
        ["\x9F\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xC6"],
        ["\x9F\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x4C"],
        ["\x9F\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x4F"],
        ["\x9F\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x4D"],
        ["\x9F\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x50"],
        ["\x9F\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x51"],
        ["\x9F\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x52"],
        ["\x9F\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x53"],
        ["\x9F\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x54"],
        ["\x9F\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x55"],
        ["\x9F\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x56"],
        ["\x9F\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x57"],
        ["\x9F\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x70"],
        ["\x9F\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x59"],
        ["\x9F\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x5A"],
        ["\x9F\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x5B"],
        ["\x9F\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xBC"],
        ["\x9F\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB6"],
        ["\x9F\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xAC"],
        ["\x9F\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x5C"],
        ["\x9F\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x5D"],
        ["\x9F\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x5E"],
        ["\x9F\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x5F"],
        ["\x9F\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x61"],
        ["\x9F\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x63"],
        ["\x9F\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x64"],
        ["\x9F\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x65"],
        ["\x9F\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x66"],
        ["\x9F\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x67"],
        ["\x9F\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x68"],
        ["\x9F\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD2"],
        ["\x9F\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x6A"],
        ["\x9F\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x6C"],
        ["\x9F\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x64"],
        ["\x9F\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x6D"],
        ["\x9F\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x6F"],
        ["\x9F\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x71"],
        ["\x9F\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x70"],
        ["\x9F\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x73"],
        ["\x9F\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x75"],
        ["\x9F\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x76"],
        ["\x9F\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x77"],
        ["\x9F\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x78"],
        ["\x9F\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x79"],
        ["\x9F\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x7B"],
        ["\x9F\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x7C"],
        ["\x9F\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x7D"],
        ["\x9F\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x7E"],
        ["\x9F\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x81"],
        ["\x9F\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x82"],
        ["\x9F\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x83"],
        ["\x9F\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x84"],
        ["\x9F\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x85"],
        ["\x9F\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x86"],
        ["\x9F\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x6E"],
        ["\x9F\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x87"],
        ["\x9F\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x88"],
        ["\x9F\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x89"],
        ["\x9F\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x8B"],
        ["\x9F\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x8C"],
        ["\x9F\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x8D"],
        ["\x9F\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x8F"],
        ["\x9F\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x90"],
        ["\x9F\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x91"],
        ["\x9F\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x92"],
        ["\x9F\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x94"],
        ["\x9F\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x96"],
        ["\x9F\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x97"],
        ["\x9F\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x98"],
        ["\x9F\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB4"],
        ["\x9F\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x99"],
        ["\x9F\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x9A"],
        ["\x9F\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x9B"],
        ["\x9F\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x9C"],
        ["\x9F\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x9D"],
        ["\x9F\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xA9"],
        ["\x9F\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x9E"],
        ["\x9F\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x4A"],
        ["\x9F\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x9F"],
        ["\x9F\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA0"],
        ["\x9F\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA1"],
        ["\x9F\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA2"],
        ["\x9F\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA3"],
        ["\x9F\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA4"],
        ["\x9F\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA5"],
        ["\x9F\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x76"],
        ["\x9F\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA7"],
        ["\x9F\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA8"],
        ["\x9F\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA9"],
        ["\x9F\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x75"],
        ["\x9F\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xEA"],
        ["\x9F\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xAB"],
        ["\x9F\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xAC"],
        ["\x9F\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xAD"],
        ["\x9F\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xAE"],
        ["\x9F\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xAF"],
        ["\x9F\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB0"],
        ["\x9F\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB1"],
        ["\x9F\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB2"],
        ["\x9F\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB3"],
        ["\xE0\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB5"],
        ["\xE0\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB6"],
        ["\xE0\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB7"],
        ["\xE0\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB8"],
        ["\xE0\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xB9"],
        ["\xE0\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xBA"],
        ["\xE0\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA0"],
        ["\xE0\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xBB"],
        ["\xE0\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xBC"],
        ["\xE0\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xBD"],
        ["\xE0\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE2"],
        ["\xE0\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xBE"],
        ["\xE0\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC0"],
        ["\xE0\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC2"],
        ["\xE0\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC3"],
        ["\xE0\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC5"],
        ["\xE0\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC6"],
        ["\xE0\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xCF"],
        ["\xE0\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC7"],
        ["\xE0\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC8"],
        ["\xE0\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC9"],
        ["\xE0\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xCB"],
        ["\xE0\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x4B"],
        ["\xE0\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xCC"],
        ["\xE0\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC4"],
        ["\xE0\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xCE"],
        ["\xE0\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD0"],
        ["\xE0\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD1"],
        ["\xE0\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD2"],
        ["\xE0\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD4"],
        ["\xE0\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD3"],
        ["\xE0\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x55"],
        ["\xE0\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD6"],
        ["\xE0\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xCD"],
        ["\xE0\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD9"],
        ["\xE0\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xDA"],
        ["\xE0\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xDB"],
        ["\xE0\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xDC"],
        ["\xE0\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xDD"],
        ["\xE0\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xDE"],
        ["\xE0\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x87"],
        ["\xE0\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xDF"],
        ["\xE0\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE0"],
        ["\xE0\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xBF"],
        ["\xE0\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xB0"],
        ["\xE0\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE4"],
        ["\xE0\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE1"],
        ["\xE0\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE5"],
        ["\xE0\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE6"],
        ["\xE0\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE7"],
        ["\xE0\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE8"],
        ["\xE0\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE9"],
        ["\xE0\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xEB"],
        ["\xE0\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xEE"],
        ["\xE0\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xEC"],
        ["\xE0\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF7"],
        ["\xE0\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xEE"],
        ["\xE0\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xEF"],
        ["\xE0\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xCD"],
        ["\xE0\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF0"],
        ["\xE0\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF1"],
        ["\xE0\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF2"],
        ["\xE0\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x8C"],
        ["\xE0\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF3"],
        ["\xE0\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF4"],
        ["\xE0\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF8"],
        ["\xE0\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF9"],
        ["\xE0\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xFA"],
        ["\xE0\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x57"],
        ["\xE0\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x85"],
        ["\xE0\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x45"],
        ["\xE0\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xFE"],
        ["\xE0\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x41"],
        ["\xE0\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x42"],
        ["\xE0\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x43"],
        ["\xE0\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x44"],
        ["\xE0\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x46"],
        ["\xE0\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x57"],
        ["\xE0\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x47"],
        ["\xE0\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x48"],
        ["\xE0\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xBB"],
        ["\xE0\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x4A"],
        ["\xE0\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x52"],
        ["\xE0\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x4C"],
        ["\xE0\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x4D"],
        ["\xE0\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x4E"],
        ["\xE0\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x50"],
        ["\xE0\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x51"],
        ["\xE0\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x53"],
        ["\xE0\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x55"],
        ["\xE0\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x56"],
        ["\xE0\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x4F"],
        ["\xE0\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x54"],
        ["\xE0\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x58"],
        ["\xE0\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x59"],
        ["\xE0\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x5B"],
        ["\xE0\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x5C"],
        ["\xE0\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x5D"],
        ["\xE0\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x7C"],
        ["\xE0\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x5E"],
        ["\xE0\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x5F"],
        ["\xE0\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x60"],
        ["\xE0\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x61"],
        ["\xE0\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x62"],
        ["\xE0\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x63"],
        ["\xE0\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x64"],
        ["\xE0\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x65"],
        ["\xE0\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x66"],
        ["\xE0\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x67"],
        ["\xE0\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x68"],
        ["\xE0\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x69"],
        ["\xE0\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x6A"],
        ["\xE0\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x6B"],
        ["\xE0\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x6E"],
        ["\xE0\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x6C"],
        ["\xE0\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x6D"],
        ["\xE0\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x6F"],
        ["\xE0\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x70"],
        ["\xE0\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x71"],
        ["\xE0\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x72"],
        ["\xE0\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x79"],
        ["\xE0\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x74"],
        ["\xE0\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x76"],
        ["\xE0\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x77"],
        ["\xE0\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x78"],
        ["\xE0\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x7A"],
        ["\xE0\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x7B"],
        ["\xE0\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x7C"],
        ["\xE0\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x7D"],
        ["\xE0\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x7E"],
        ["\xE0\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x7F"],
        ["\xE0\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x80"],
        ["\xE0\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA1"],
        ["\xE0\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x81"],
        ["\xE0\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x82"],
        ["\xE0\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x83"],
        ["\xE0\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x84"],
        ["\xE0\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x85"],
        ["\xE0\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x87"],
        ["\xE0\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x89"],
        ["\xE0\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x88"],
        ["\xE0\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x8B"],
        ["\xE0\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x8C"],
        ["\xE0\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x8E"],
        ["\xE0\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x8D"],
        ["\xE0\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x90"],
        ["\xE0\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x8F"],
        ["\xE0\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x91"],
        ["\xE0\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x92"],
        ["\xE0\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x93"],
        ["\xE0\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x95"],
        ["\xE0\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x96"],
        ["\xE0\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x97"],
        ["\xE0\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xCB"],
        ["\xE0\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x98"],
        ["\xE0\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x9A"],
        ["\xE0\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x9B"],
        ["\xE0\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x9C"],
        ["\xE0\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x9D"],
        ["\xE0\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA0"],
        ["\xE0\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA3"],
        ["\xE0\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA5"],
        ["\xE0\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC2"],
        ["\xE0\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA9"],
        ["\xE0\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xBE"],
        ["\xE0\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xAC"],
        ["\xE0\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA6"],
        ["\xE0\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xAF"],
        ["\xE0\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB0"],
        ["\xE0\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB1"],
        ["\xE0\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB2"],
        ["\xE0\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB3"],
        ["\xE0\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB4"],
        ["\xE0\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB5"],
        ["\xE0\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB6"],
        ["\xE0\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB7"],
        ["\xE0\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB8"],
        ["\xE0\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xB9"],
        ["\xE0\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xBA"],
        ["\xE0\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x83"],
        ["\xE0\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xBF"],
        ["\xE0\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x4D"],
        ["\xE0\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC1"],
        ["\xE0\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC3"],
        ["\xE0\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC4"],
        ["\xE0\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC5"],
        ["\xE0\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC6"],
        ["\xE0\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA4"],
        ["\xE1\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC7"],
        ["\xE1\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC8"],
        ["\xE1\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC9"],
        ["\xE1\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xCA"],
        ["\xE1\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xCB"],
        ["\xE1\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xCD"],
        ["\xE1\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xCC"],
        ["\xE1\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xCE"],
        ["\xE1\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD0"],
        ["\xE1\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xCF"],
        ["\xE1\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD2"],
        ["\xE1\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD3"],
        ["\xE1\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD4"],
        ["\xE1\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD6"],
        ["\xE1\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD7"],
        ["\xE1\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD5"],
        ["\xE1\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE6"],
        ["\xE1\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD8"],
        ["\xE1\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD9"],
        ["\xE1\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xDA"],
        ["\xE1\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xDB"],
        ["\xE1\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xDC"],
        ["\xE1\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xDD"],
        ["\xE1\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xDE"],
        ["\xE1\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xDF"],
        ["\xE1\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE0"],
        ["\xE1\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE2"],
        ["\xE1\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE1"],
        ["\xE1\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE3"],
        ["\xE1\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xFD"],
        ["\xE1\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE4"],
        ["\xE1\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE5"],
        ["\xE1\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE6"],
        ["\xE1\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE9"],
        ["\xE1\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xEA"],
        ["\xE1\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xEB"],
        ["\xE1\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xED"],
        ["\xE1\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xEE"],
        ["\xE1\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE8"],
        ["\xE1\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xEF"],
        ["\xE1\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF0"],
        ["\xE1\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xEC"],
        ["\xE1\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF1"],
        ["\xE1\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF2"],
        ["\xE1\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF3"],
        ["\xE1\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF4"],
        ["\xE1\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF5"],
        ["\xE1\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF6"],
        ["\xE1\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF7"],
        ["\xE1\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF8"],
        ["\xE1\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xF9"],
        ["\xE1\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xFA"],
        ["\xE1\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xFB"],
        ["\xE1\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xFC"],
        ["\xE1\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xFD"],
        ["\xE1\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xFE"],
        ["\xE1\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x41"],
        ["\xE1\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x42"],
        ["\xE1\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x43"],
        ["\xE1\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x44"],
        ["\xE1\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x45"],
        ["\xE1\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x46"],
        ["\xE1\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x47"],
        ["\xE1\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x48"],
        ["\xE1\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x49"],
        ["\xE1\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x4A"],
        ["\xE1\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x4B"],
        ["\xE1\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x4C"],
        ["\xE1\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x4D"],
        ["\xE1\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x4E"],
        ["\xE1\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x4F"],
        ["\xE1\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x4F"],
        ["\xE1\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x50"],
        ["\xE1\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x51"],
        ["\xE1\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x52"],
        ["\xE1\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x53"],
        ["\xE1\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x54"],
        ["\xE1\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x55"],
        ["\xE1\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x56"],
        ["\xE1\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x57"],
        ["\xE1\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x58"],
        ["\xE1\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x59"],
        ["\xE1\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x5A"],
        ["\xE1\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x5C"],
        ["\xE1\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x5D"],
        ["\xE1\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x5B"],
        ["\xE1\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x5E"],
        ["\xE1\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x5F"],
        ["\xE1\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x60"],
        ["\xE1\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x61"],
        ["\xE1\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x63"],
        ["\xE1\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x62"],
        ["\xE1\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x64"],
        ["\xE1\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x65"],
        ["\xE1\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x66"],
        ["\xE1\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x67"],
        ["\xE1\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x9A"],
        ["\xE1\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x68"],
        ["\xE1\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x6A"],
        ["\xE1\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x6B"],
        ["\xE1\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x6C"],
        ["\xE1\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x6D"],
        ["\xE1\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x99"],
        ["\xE1\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x96"],
        ["\xE1\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x81"],
        ["\xE1\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x6E"],
        ["\xE1\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x6F"],
        ["\xE1\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x74"],
        ["\xE1\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x75"],
        ["\xE1\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x76"],
        ["\xE1\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x77"],
        ["\xE1\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x78"],
        ["\xE1\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x79"],
        ["\xE1\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x7B"],
        ["\xE1\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x7C"],
        ["\xE1\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x7D"],
        ["\xE1\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x7E"],
        ["\xE1\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x7F"],
        ["\xE1\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x80"],
        ["\xE1\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF7"],
        ["\xE1\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x81"],
        ["\xE1\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x82"],
        ["\xE1\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x83"],
        ["\xE1\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x84"],
        ["\xE1\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x85"],
        ["\xE1\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x86"],
        ["\xE1\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x88"],
        ["\xE1\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x87"],
        ["\xE1\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xCA"],
        ["\xE1\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x89"],
        ["\xE1\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x8A"],
        ["\xE1\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x8B"],
        ["\xE1\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x8C"],
        ["\xE1\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x8D"],
        ["\xE1\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x8F"],
        ["\xE1\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x90"],
        ["\xE1\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x91"],
        ["\xE1\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x92"],
        ["\xE1\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x93"],
        ["\xE1\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x94"],
        ["\xE1\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x95"],
        ["\xE1\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x96"],
        ["\xE1\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x97"],
        ["\xE1\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x98"],
        ["\xE1\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x99"],
        ["\xE1\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x9A"],
        ["\xE1\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x9B"],
        ["\xE1\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x9C"],
        ["\xE1\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x9D"],
        ["\xE1\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x9E"],
        ["\xE1\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x9F"],
        ["\xE1\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA0"],
        ["\xE1\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA1"],
        ["\xE1\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA2"],
        ["\xE1\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA3"],
        ["\xE1\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA4"],
        ["\xE1\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA5"],
        ["\xE1\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x50"],
        ["\xE1\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA6"],
        ["\xE1\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA7"],
        ["\xE1\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA8"],
        ["\xE1\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xA9"],
        ["\xE1\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xAB"],
        ["\xE1\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xAC"],
        ["\xE1\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xAD"],
        ["\xE1\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xB9"],
        ["\xE1\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB0"],
        ["\xE1\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x4C"],
        ["\xE1\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB1"],
        ["\xE1\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB5"],
        ["\xE1\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB4"],
        ["\xE1\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB7"],
        ["\xE1\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB9"],
        ["\xE1\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB8"],
        ["\xE1\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xBA"],
        ["\xE1\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xBB"],
        ["\xE1\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xBC"],
        ["\xE1\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xBD"],
        ["\xE1\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xBE"],
        ["\xE1\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xBF"],
        ["\xE1\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC0"],
        ["\xE1\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC1"],
        ["\xE1\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC2"],
        ["\xE1\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC3"],
        ["\xE1\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC4"],
        ["\xE1\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC5"],
        ["\xE1\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC6"],
        ["\xE1\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC7"],
        ["\xE2\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC8"],
        ["\xE2\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xC9"],
        ["\xE2\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xCA"],
        ["\xE2\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xCB"],
        ["\xE2\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xCC"],
        ["\xE2\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xF0"],
        ["\xE2\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xCD"],
        ["\xE2\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xCE"],
        ["\xE2\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xCF"],
        ["\xE2\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD0"],
        ["\xE2\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD3"],
        ["\xE2\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD4"],
        ["\xE2\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x65"],
        ["\xE2\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD6"],
        ["\xE2\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD7"],
        ["\xE2\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD8"],
        ["\xE2\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x5C"],
        ["\xE2\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xD8"],
        ["\xE2\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xDA"],
        ["\xE2\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xDB"],
        ["\xE2\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xDE"],
        ["\xE2\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\xD7"],
        ["\xE2\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF5"],
        ["\xE2\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE0"],
        ["\xE2\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF5"],
        ["\xE2\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE1"],
        ["\xE2\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x6A"],
        ["\xE2\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE2"],
        ["\xE2\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE3"],
        ["\xE2\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE4"],
        ["\xE2\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE5"],
        ["\xE2\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE6"],
        ["\xE2\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xB5"],
        ["\xE2\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE7"],
        ["\xE2\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE8"],
        ["\xE2\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xE9"],
        ["\xE2\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xEA"],
        ["\xE2\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xEB"],
        ["\xE2\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x66"],
        ["\xE2\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xEC"],
        ["\xE2\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE7"],
        ["\xE2\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xED"],
        ["\xE2\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF0"],
        ["\xE2\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xEE"],
        ["\xE2\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xEF"],
        ["\xE2\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF1"],
        ["\xE2\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF2"],
        ["\xE2\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF3"],
        ["\xE2\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF5"],
        ["\xE2\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF4"],
        ["\xE2\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF6"],
        ["\xE2\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF7"],
        ["\xE2\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF8"],
        ["\xE2\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xF9"],
        ["\xE2\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xFA"],
        ["\xE2\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xFB"],
        ["\xE2\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x41"],
        ["\xE2\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xFC"],
        ["\xE2\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xFD"],
        ["\xE2\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xFE"],
        ["\xE2\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x42"],
        ["\xE2\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF0"],
        ["\xE2\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x43"],
        ["\xE2\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x44"],
        ["\xE2\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x48"],
        ["\xE2\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x49"],
        ["\xE2\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x47"],
        ["\xE2\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x45"],
        ["\xE2\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x4A"],
        ["\xE2\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x4B"],
        ["\xE2\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x4C"],
        ["\xE2\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x4D"],
        ["\xE2\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x50"],
        ["\xE2\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x51"],
        ["\xE2\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x52"],
        ["\xE2\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x53"],
        ["\xE2\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x54"],
        ["\xE2\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x55"],
        ["\xE2\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x56"],
        ["\xE2\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x57"],
        ["\xE2\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x5B"],
        ["\xE2\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x5C"],
        ["\xE2\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x5E"],
        ["\xE2\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x5F"],
        ["\xE2\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x61"],
        ["\xE2\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x62"],
        ["\xE2\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x63"],
        ["\xE2\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xE7"],
        ["\xE2\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x65"],
        ["\xE2\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x66"],
        ["\xE2\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x67"],
        ["\xE2\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x68"],
        ["\xE2\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x64"],
        ["\xE2\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x69"],
        ["\xE2\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x6F"],
        ["\xE2\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD5"],
        ["\xE2\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x6A"],
        ["\xE2\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x60"],
        ["\xE2\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x6B"],
        ["\xE2\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x6C"],
        ["\xE2\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x6E"],
        ["\xE2\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x84"],
        ["\xE2\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x70"],
        ["\xE2\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x48"],
        ["\xE2\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x71"],
        ["\xE2\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x72"],
        ["\xE2\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x4E"],
        ["\xE2\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x73"],
        ["\xE2\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x74"],
        ["\xE2\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x75"],
        ["\xE2\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x76"],
        ["\xE2\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x77"],
        ["\xE2\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x78"],
        ["\xE2\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x79"],
        ["\xE2\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA4"],
        ["\xE2\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x7A"],
        ["\xE2\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x7B"],
        ["\xE2\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x6D"],
        ["\xE2\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x7C"],
        ["\xE2\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x7E"],
        ["\xE2\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xE8"],
        ["\xE2\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x7F"],
        ["\xE2\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x7D"],
        ["\xE2\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x80"],
        ["\xE2\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x81"],
        ["\xE2\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x83"],
        ["\xE2\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x84"],
        ["\xE2\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x53"],
        ["\xE2\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x88"],
        ["\xE2\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x85"],
        ["\xE2\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x87"],
        ["\xE2\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\xEE"],
        ["\xE2\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x89"],
        ["\xE2\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x8B"],
        ["\xE2\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x8A"],
        ["\xE2\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x8C"],
        ["\xE2\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x86"],
        ["\xE2\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x7C"],
        ["\xE2\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x8D"],
        ["\xE2\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x8E"],
        ["\xE2\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x8F"],
        ["\xE2\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x90"],
        ["\xE2\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x91"],
        ["\xE2\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x92"],
        ["\xE2\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x93"],
        ["\xE2\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x94"],
        ["\xE2\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x95"],
        ["\xE2\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x97"],
        ["\xE2\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x98"],
        ["\xE2\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x99"],
        ["\xE2\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF2"],
        ["\xE2\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x96"],
        ["\xE2\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x9A"],
        ["\xE2\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x9B"],
        ["\xE2\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x9C"],
        ["\xE2\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xAA"],
        ["\xE2\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x99"],
        ["\xE2\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x9D"],
        ["\xE2\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x9E"],
        ["\xE2\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x9F"],
        ["\xE2\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA0"],
        ["\xE2\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA1"],
        ["\xE2\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA2"],
        ["\xE2\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA6"],
        ["\xE2\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA3"],
        ["\xE2\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA4"],
        ["\xE2\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA5"],
        ["\xE2\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA7"],
        ["\xE2\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA8"],
        ["\xE2\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xA9"],
        ["\xE2\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xAA"],
        ["\xE2\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xAB"],
        ["\xE2\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xAC"],
        ["\xE2\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xAE"],
        ["\xE2\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xBC"],
        ["\xE2\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xAF"],
        ["\xE2\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB0"],
        ["\xE2\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB3"],
        ["\xE2\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB1"],
        ["\xE2\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB4"],
        ["\xE2\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB2"],
        ["\xE2\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x88"],
        ["\xE2\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB5"],
        ["\xE2\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB6"],
        ["\xE2\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB7"],
        ["\xE2\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB8"],
        ["\xE2\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xC2"],
        ["\xE2\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xB9"],
        ["\xE3\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xBA"],
        ["\xE3\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xBB"],
        ["\xE3\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xBC"],
        ["\xE3\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xBD"],
        ["\xE3\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xBE"],
        ["\xE3\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xBF"],
        ["\xE3\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC0"],
        ["\xE3\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC1"],
        ["\xE3\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC2"],
        ["\xE3\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC3"],
        ["\xE3\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC5"],
        ["\xE3\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC7"],
        ["\xE3\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC8"],
        ["\xE3\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC9"],
        ["\xE3\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x68"],
        ["\xE3\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xCA"],
        ["\xE3\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xCB"],
        ["\xE3\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xCC"],
        ["\xE3\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xCD"],
        ["\xE3\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xCE"],
        ["\xE3\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xCF"],
        ["\xE3\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD0"],
        ["\xE3\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x74"],
        ["\xE3\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xED"],
        ["\xE3\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xEB"],
        ["\xE3\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD3"],
        ["\xE3\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD1"],
        ["\xE3\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD2"],
        ["\xE3\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD3"],
        ["\xE3\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD5"],
        ["\xE3\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD6"],
        ["\xE3\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD7"],
        ["\xE3\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF3"],
        ["\xE3\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD8"],
        ["\xE3\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD9"],
        ["\xE3\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE8"],
        ["\xE3\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xDB"],
        ["\xE3\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xDC"],
        ["\xE3\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xDD"],
        ["\xE3\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xDF"],
        ["\xE3\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE0"],
        ["\xE3\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE2"],
        ["\xE3\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE3"],
        ["\xE3\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE4"],
        ["\xE3\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE6"],
        ["\xE3\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE7"],
        ["\xE3\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE9"],
        ["\xE3\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xEA"],
        ["\xE3\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xA8"],
        ["\xE3\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xEB"],
        ["\xE3\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xEC"],
        ["\xE3\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF2"],
        ["\xE3\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xED"],
        ["\xE3\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xEE"],
        ["\xE3\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE5"],
        ["\xE3\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xCC"],
        ["\xE3\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF0"],
        ["\xE3\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF1"],
        ["\xE3\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF5"],
        ["\xE3\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF4"],
        ["\xE3\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF6"],
        ["\xE3\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF7"],
        ["\xE3\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF8"],
        ["\xE3\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xF9"],
        ["\xE3\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xEF"],
        ["\xE3\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x42"],
        ["\xE3\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xFA"],
        ["\xE3\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xFB"],
        ["\xE3\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xFC"],
        ["\xE3\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xFE"],
        ["\xE3\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x41"],
        ["\xE3\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x43"],
        ["\xE3\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x44"],
        ["\xE3\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x45"],
        ["\xE3\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x46"],
        ["\xE3\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x47"],
        ["\xE3\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x4B"],
        ["\xE3\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xDE"],
        ["\xE3\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x48"],
        ["\xE3\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x49"],
        ["\xE3\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x4A"],
        ["\xE3\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x78"],
        ["\xE3\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x4C"],
        ["\xE3\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x4E"],
        ["\xE3\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x4F"],
        ["\xE3\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x73"],
        ["\xE3\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x50"],
        ["\xE3\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x51"],
        ["\xE3\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x52"],
        ["\xE3\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x4D"],
        ["\xE3\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x53"],
        ["\xE3\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x9C"],
        ["\xE3\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x54"],
        ["\xE3\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x55"],
        ["\xE3\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x56"],
        ["\xE3\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x58"],
        ["\xE3\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xCB"],
        ["\xE3\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x59"],
        ["\xE3\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x6E"],
        ["\xE3\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x5A"],
        ["\xE3\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x5B"],
        ["\xE3\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x5C"],
        ["\xE3\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x5D"],
        ["\xE3\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x5E"],
        ["\xE3\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x5F"],
        ["\xE3\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x60"],
        ["\xE3\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x62"],
        ["\xE3\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x61"],
        ["\xE3\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x63"],
        ["\xE3\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x64"],
        ["\xE3\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x65"],
        ["\xE3\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x66"],
        ["\xE3\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x68"],
        ["\xE3\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x67"],
        ["\xE3\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x69"],
        ["\xE3\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x6A"],
        ["\xE3\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x6B"],
        ["\xE3\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x6C"],
        ["\xE3\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x6D"],
        ["\xE3\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x6F"],
        ["\xE3\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x70"],
        ["\xE3\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x72"],
        ["\xE3\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x73"],
        ["\xE3\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x71"],
        ["\xE3\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x74"],
        ["\xE3\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x75"],
        ["\xE3\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x76"],
        ["\xE3\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x78"],
        ["\xE3\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x79"],
        ["\xE3\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x7A"],
        ["\xE3\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x7B"],
        ["\xE3\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF9"],
        ["\xE3\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x7C"],
        ["\xE3\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x7D"],
        ["\xE3\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x7E"],
        ["\xE3\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x7F"],
        ["\xE3\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x80"],
        ["\xE3\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xDA"],
        ["\xE3\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xDC"],
        ["\xE3\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x81"],
        ["\xE3\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x82"],
        ["\xE3\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x83"],
        ["\xE3\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE4"],
        ["\xE3\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x84"],
        ["\xE3\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x85"],
        ["\xE3\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x86"],
        ["\xE3\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x87"],
        ["\xE3\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x88"],
        ["\xE3\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x89"],
        ["\xE3\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x8A"],
        ["\xE3\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x8B"],
        ["\xE3\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x8C"],
        ["\xE3\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x8D"],
        ["\xE3\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x79"],
        ["\xE3\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x8E"],
        ["\xE3\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x8F"],
        ["\xE3\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x90"],
        ["\xE3\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x91"],
        ["\xE3\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x92"],
        ["\xE3\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x93"],
        ["\xE3\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x94"],
        ["\xE3\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x95"],
        ["\xE3\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x96"],
        ["\xE3\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x97"],
        ["\xE3\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x98"],
        ["\xE3\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB6"],
        ["\xE3\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x99"],
        ["\xE3\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x92"],
        ["\xE3\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x9A"],
        ["\xE3\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x9B"],
        ["\xE3\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x9C"],
        ["\xE3\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x9D"],
        ["\xE3\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x9E"],
        ["\xE3\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x9F"],
        ["\xE3\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA0"],
        ["\xE3\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA1"],
        ["\xE3\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA2"],
        ["\xE3\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA3"],
        ["\xE3\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA4"],
        ["\xE3\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x88"],
        ["\xE3\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA5"],
        ["\xE3\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA6"],
        ["\xE3\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA7"],
        ["\xE3\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA8"],
        ["\xE3\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x96"],
        ["\xE3\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xA9"],
        ["\xE3\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xAA"],
        ["\xE3\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xAB"],
        ["\xE4\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x73"],
        ["\xE4\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xAC"],
        ["\xE4\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xAD"],
        ["\xE4\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xAE"],
        ["\xE4\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xAF"],
        ["\xE4\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB0"],
        ["\xE4\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB1"],
        ["\xE4\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB2"],
        ["\xE4\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB3"],
        ["\xE4\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB5"],
        ["\xE4\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB6"],
        ["\xE4\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB7"],
        ["\xE4\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB8"],
        ["\xE4\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB9"],
        ["\xE4\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xBA"],
        ["\xE4\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xBB"],
        ["\xE4\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xBC"],
        ["\xE4\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xBD"],
        ["\xE4\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC1"],
        ["\xE4\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xBE"],
        ["\xE4\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xB4"],
        ["\xE4\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xBF"],
        ["\xE4\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC2"],
        ["\xE4\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC4"],
        ["\xE4\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC0"],
        ["\xE4\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC6"],
        ["\xE4\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC3"],
        ["\xE4\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC7"],
        ["\xE4\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC8"],
        ["\xE4\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC9"],
        ["\xE4\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xCA"],
        ["\xE4\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xCB"],
        ["\xE4\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xCC"],
        ["\xE4\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xCD"],
        ["\xE4\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xCF"],
        ["\xE4\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xCE"],
        ["\xE4\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xC5"],
        ["\xE4\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD0"],
        ["\xE4\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD1"],
        ["\xE4\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD2"],
        ["\xE4\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x73"],
        ["\xE4\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD3"],
        ["\xE4\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD4"],
        ["\xE4\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD5"],
        ["\xE4\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD6"],
        ["\xE4\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD7"],
        ["\xE4\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD8"],
        ["\xE4\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x58"],
        ["\xE4\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xBA"],
        ["\xE4\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xD9"],
        ["\xE4\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xDA"],
        ["\xE4\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xDC"],
        ["\xE4\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xDD"],
        ["\xE4\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xDE"],
        ["\xE4\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE0"],
        ["\xE4\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE1"],
        ["\xE4\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE2"],
        ["\xE4\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE3"],
        ["\xE4\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xAE"],
        ["\xE4\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE5"],
        ["\xE4\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE4"],
        ["\xE4\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE6"],
        ["\xE4\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE7"],
        ["\xE4\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE8"],
        ["\xE4\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xE9"],
        ["\xE4\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xEA"],
        ["\xE4\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xEB"],
        ["\xE4\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xDF"],
        ["\xE4\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xEC"],
        ["\xE4\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xED"],
        ["\xE4\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC5"],
        ["\xE4\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xEE"],
        ["\xE4\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xEF"],
        ["\xE4\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF0"],
        ["\xE4\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF1"],
        ["\xE4\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF2"],
        ["\xE4\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF3"],
        ["\xE4\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF4"],
        ["\xE4\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF5"],
        ["\xE4\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF6"],
        ["\xE4\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF7"],
        ["\xE4\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF9"],
        ["\xE4\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xFA"],
        ["\xE4\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xFB"],
        ["\xE4\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x44"],
        ["\xE4\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x60"],
        ["\xE4\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xFC"],
        ["\xE4\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xFD"],
        ["\xE4\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xFE"],
        ["\xE4\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x41"],
        ["\xE4\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x42"],
        ["\xE4\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x43"],
        ["\xE4\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x45"],
        ["\xE4\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x46"],
        ["\xE4\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x47"],
        ["\xE4\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x49"],
        ["\xE4\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x4A"],
        ["\xE4\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x7B"],
        ["\xE4\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x4B"],
        ["\xE4\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x4C"],
        ["\xE4\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x4D"],
        ["\xE4\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x4E"],
        ["\xE4\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x4F"],
        ["\xE4\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x50"],
        ["\xE4\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x51"],
        ["\xE4\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xF6"],
        ["\xE4\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x52"],
        ["\xE4\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x62"],
        ["\xE4\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x53"],
        ["\xE4\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x54"],
        ["\xE4\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x55"],
        ["\xE4\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x56"],
        ["\xE4\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x57"],
        ["\xE4\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x58"],
        ["\xE4\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x59"],
        ["\xE4\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x86"],
        ["\xE4\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x5C"],
        ["\xE4\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x5D"],
        ["\xE4\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x5E"],
        ["\xE4\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x5F"],
        ["\xE4\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x5A"],
        ["\xE4\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x61"],
        ["\xE4\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x63"],
        ["\xE4\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x64"],
        ["\xE4\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x65"],
        ["\xE4\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x66"],
        ["\xE4\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xE9"],
        ["\xE4\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x68"],
        ["\xE4\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x6A"],
        ["\xE4\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x6B"],
        ["\xE4\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x6C"],
        ["\xE4\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x6D"],
        ["\xE4\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x6E"],
        ["\xE4\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x69"],
        ["\xE4\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x6F"],
        ["\xE4\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x70"],
        ["\xE4\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x71"],
        ["\xE4\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x72"],
        ["\xE4\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xD8"],
        ["\xE4\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x73"],
        ["\xE4\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x75"],
        ["\xE4\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x84"],
        ["\xE4\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x9D"],
        ["\xE4\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x76"],
        ["\xE4\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x6C"],
        ["\xE4\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x77"],
        ["\xE4\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x79"],
        ["\xE4\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x9F"],
        ["\xE4\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x7A"],
        ["\xE4\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x7B"],
        ["\xE4\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x7C"],
        ["\xE4\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x90"],
        ["\xE4\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x7F"],
        ["\xE4\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x80"],
        ["\xE4\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x81"],
        ["\xE4\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x82"],
        ["\xE4\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4B\x75"],
        ["\xE4\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x83"],
        ["\xE4\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x7D"],
        ["\xE4\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x85"],
        ["\xE4\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x86"],
        ["\xE4\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x78"],
        ["\xE4\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x87"],
        ["\xE4\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x88"],
        ["\xE4\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x89"],
        ["\xE4\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x94"],
        ["\xE4\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x8B"],
        ["\xE4\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x8C"],
        ["\xE4\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x8D"],
        ["\xE4\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x8E"],
        ["\xE4\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x8F"],
        ["\xE4\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x91"],
        ["\xE4\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x92"],
        ["\xE4\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x93"],
        ["\xE4\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA8"],
        ["\xE4\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x95"],
        ["\xE4\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x96"],
        ["\xE4\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x97"],
        ["\xE4\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x98"],
        ["\xE4\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x99"],
        ["\xE4\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x9A"],
        ["\xE4\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x9B"],
        ["\xE4\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x9C"],
        ["\xE4\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x8B"],
        ["\xE4\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA0"],
        ["\xE4\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA2"],
        ["\xE4\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA3"],
        ["\xE4\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA4"],
        ["\xE5\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA5"],
        ["\xE5\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x96"],
        ["\xE5\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA7"],
        ["\xE5\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA9"],
        ["\xE5\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xAA"],
        ["\xE5\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xAB"],
        ["\xE5\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xAC"],
        ["\xE5\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xAD"],
        ["\xE5\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xAE"],
        ["\xE5\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xAF"],
        ["\xE5\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB0"],
        ["\xE5\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB1"],
        ["\xE5\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB2"],
        ["\xE5\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4C\x95"],
        ["\xE5\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB4"],
        ["\xE5\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB5"],
        ["\xE5\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB6"],
        ["\xE5\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB7"],
        ["\xE5\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB8"],
        ["\xE5\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xBC"],
        ["\xE5\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xBD"],
        ["\xE5\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xBE"],
        ["\xE5\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xBF"],
        ["\xE5\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC0"],
        ["\xE5\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC1"],
        ["\xE5\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC2"],
        ["\xE5\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC3"],
        ["\xE5\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC4"],
        ["\xE5\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC5"],
        ["\xE5\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC6"],
        ["\xE5\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC7"],
        ["\xE5\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC8"],
        ["\xE5\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xC9"],
        ["\xE5\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xED"],
        ["\xE5\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\xDA"],
        ["\xE5\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xCA"],
        ["\xE5\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xCB"],
        ["\xE5\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xCC"],
        ["\xE5\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xCD"],
        ["\xE5\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xCF"],
        ["\xE5\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD0"],
        ["\xE5\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xFB"],
        ["\xE5\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD2"],
        ["\xE5\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD3"],
        ["\xE5\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD4"],
        ["\xE5\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD5"],
        ["\xE5\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD6"],
        ["\xE5\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD7"],
        ["\xE5\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD9"],
        ["\xE5\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xD8"],
        ["\xE5\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xDA"],
        ["\xE5\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xDB"],
        ["\xE5\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xDC"],
        ["\xE5\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xDD"],
        ["\xE5\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xDE"],
        ["\xE5\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xDF"],
        ["\xE5\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE0"],
        ["\xE5\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x51"],
        ["\xE5\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE3"],
        ["\xE5\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE4"],
        ["\xE5\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE5"],
        ["\xE5\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE6"],
        ["\xE5\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE7"],
        ["\xE5\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE8"],
        ["\xE5\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE9"],
        ["\xE5\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x74"],
        ["\xE5\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xEA"],
        ["\xE5\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xEB"],
        ["\xE5\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xEC"],
        ["\xE5\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xED"],
        ["\xE5\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xEE"],
        ["\xE5\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xEF"],
        ["\xE5\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF0"],
        ["\xE5\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF1"],
        ["\xE5\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF2"],
        ["\xE5\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF3"],
        ["\xE5\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF4"],
        ["\xE5\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF5"],
        ["\xE5\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF6"],
        ["\xE5\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x6D"],
        ["\xE5\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF7"],
        ["\xE5\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF8"],
        ["\xE5\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xF9"],
        ["\xE5\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xFA"],
        ["\xE5\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x46"],
        ["\xE5\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xFB"],
        ["\xE5\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xFC"],
        ["\xE5\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xFD"],
        ["\xE5\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xFE"],
        ["\xE5\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x41"],
        ["\xE5\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x42"],
        ["\xE5\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x43"],
        ["\xE5\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x47"],
        ["\xE5\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x48"],
        ["\xE5\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x49"],
        ["\xE5\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x4A"],
        ["\xE5\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x45"],
        ["\xE5\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\xBD"],
        ["\xE5\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x4C"],
        ["\xE5\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x4E"],
        ["\xE5\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x44"],
        ["\xE5\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x4F"],
        ["\xE5\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x50"],
        ["\xE5\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x51"],
        ["\xE5\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x52"],
        ["\xE5\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x53"],
        ["\xE5\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x54"],
        ["\xE5\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x55"],
        ["\xE5\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x56"],
        ["\xE5\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x57"],
        ["\xE5\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xF4"],
        ["\xE5\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x4D"],
        ["\xE5\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x59"],
        ["\xE5\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x5A"],
        ["\xE5\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x5B"],
        ["\xE5\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x5C"],
        ["\xE5\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x5F"],
        ["\xE5\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x61"],
        ["\xE5\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x62"],
        ["\xE5\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x63"],
        ["\xE5\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x64"],
        ["\xE5\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x5D"],
        ["\xE5\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x58"],
        ["\xE5\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x65"],
        ["\xE5\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x60"],
        ["\xE5\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x66"],
        ["\xE5\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x67"],
        ["\xE5\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x68"],
        ["\xE5\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x6A"],
        ["\xE5\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x6B"],
        ["\xE5\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x6C"],
        ["\xE5\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x69"],
        ["\xE5\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x6D"],
        ["\xE5\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x6F"],
        ["\xE5\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x6E"],
        ["\xE5\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x71"],
        ["\xE5\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x72"],
        ["\xE5\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x73"],
        ["\xE5\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x74"],
        ["\xE5\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x75"],
        ["\xE5\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x76"],
        ["\xE5\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x77"],
        ["\xE5\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x7C"],
        ["\xE5\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x78"],
        ["\xE5\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x79"],
        ["\xE5\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x85"],
        ["\xE5\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x7A"],
        ["\xE5\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x7B"],
        ["\xE5\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x7D"],
        ["\xE5\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x7E"],
        ["\xE5\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x7F"],
        ["\xE5\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x80"],
        ["\xE5\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x81"],
        ["\xE5\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x82"],
        ["\xE5\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x83"],
        ["\xE5\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xC5"],
        ["\xE5\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x84"],
        ["\xE5\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x86"],
        ["\xE5\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x87"],
        ["\xE5\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x88"],
        ["\xE5\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x89"],
        ["\xE5\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x8A"],
        ["\xE5\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x8B"],
        ["\xE5\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x8C"],
        ["\xE5\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x8D"],
        ["\xE5\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x8E"],
        ["\xE5\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x8F"],
        ["\xE5\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x49"],
        ["\xE5\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x91"],
        ["\xE5\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x92"],
        ["\xE5\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x93"],
        ["\xE5\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x94"],
        ["\xE5\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x97"],
        ["\xE5\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x98"],
        ["\xE5\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x9F"],
        ["\xE5\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x99"],
        ["\xE5\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x9A"],
        ["\xE5\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x95"],
        ["\xE5\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x9B"],
        ["\xE5\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x9C"],
        ["\xE5\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x6B"],
        ["\xE5\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x9D"],
        ["\xE5\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x9E"],
        ["\xE5\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA0"],
        ["\xE5\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA2"],
        ["\xE5\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x96"],
        ["\xE5\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA3"],
        ["\xE5\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA4"],
        ["\xE6\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA5"],
        ["\xE6\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA7"],
        ["\xE6\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA8"],
        ["\xE6\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA6"],
        ["\xE6\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA9"],
        ["\xE6\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xAA"],
        ["\xE6\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xAB"],
        ["\xE6\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xAC"],
        ["\xE6\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xAD"],
        ["\xE6\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xAE"],
        ["\xE6\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xAF"],
        ["\xE6\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB0"],
        ["\xE6\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB1"],
        ["\xE6\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB2"],
        ["\xE6\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB3"],
        ["\xE6\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB4"],
        ["\xE6\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB5"],
        ["\xE6\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB6"],
        ["\xE6\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB7"],
        ["\xE6\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB8"],
        ["\xE6\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xBA"],
        ["\xE6\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xB9"],
        ["\xE6\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xBB"],
        ["\xE6\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xBC"],
        ["\xE6\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x60"],
        ["\xE6\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xBD"],
        ["\xE6\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xBE"],
        ["\xE6\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xBF"],
        ["\xE6\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC0"],
        ["\xE6\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC1"],
        ["\xE6\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC2"],
        ["\xE6\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC3"],
        ["\xE6\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC4"],
        ["\xE6\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC6"],
        ["\xE6\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC7"],
        ["\xE6\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC8"],
        ["\xE6\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC9"],
        ["\xE6\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xCA"],
        ["\xE6\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xCC"],
        ["\xE6\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xCD"],
        ["\xE6\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xCE"],
        ["\xE6\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xCF"],
        ["\xE6\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD0"],
        ["\xE6\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD1"],
        ["\xE6\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD2"],
        ["\xE6\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD3"],
        ["\xE6\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD5"],
        ["\xE6\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD6"],
        ["\xE6\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD7"],
        ["\xE6\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD8"],
        ["\xE6\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD9"],
        ["\xE6\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xDA"],
        ["\xE6\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xDB"],
        ["\xE6\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xDC"],
        ["\xE6\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xDD"],
        ["\xE6\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xDE"],
        ["\xE6\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xB2"],
        ["\xE6\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE2"],
        ["\xE6\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE3"],
        ["\xE6\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE4"],
        ["\xE6\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x96"],
        ["\xE6\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE5"],
        ["\xE6\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE6"],
        ["\xE6\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE7"],
        ["\xE6\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE8"],
        ["\xE6\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE9"],
        ["\xE6\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xEA"],
        ["\xE6\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xEB"],
        ["\xE6\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF0"],
        ["\xE6\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF1"],
        ["\xE6\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF2"],
        ["\xE6\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF3"],
        ["\xE6\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF4"],
        ["\xE6\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF5"],
        ["\xE6\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xEC"],
        ["\xE6\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF6"],
        ["\xE6\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF7"],
        ["\xE6\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF8"],
        ["\xE6\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xF9"],
        ["\xE6\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xFA"],
        ["\xE6\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xFC"],
        ["\xE6\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xFD"],
        ["\xE6\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xFE"],
        ["\xE6\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x41"],
        ["\xE6\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x81"],
        ["\xE6\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xFB"],
        ["\xE6\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x42"],
        ["\xE6\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x43"],
        ["\xE6\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x44"],
        ["\xE6\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x46"],
        ["\xE6\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x47"],
        ["\xE6\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x48"],
        ["\xE6\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x49"],
        ["\xE6\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x4B"],
        ["\xE6\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x4C"],
        ["\xE6\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x4D"],
        ["\xE6\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x4E"],
        ["\xE6\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x4A"],
        ["\xE6\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x4F"],
        ["\xE6\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x51"],
        ["\xE6\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x52"],
        ["\xE6\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x53"],
        ["\xE6\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x55"],
        ["\xE6\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x56"],
        ["\xE6\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x57"],
        ["\xE6\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x54"],
        ["\xE6\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x58"],
        ["\xE6\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x59"],
        ["\xE6\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x5A"],
        ["\xE6\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x5B"],
        ["\xE6\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x5C"],
        ["\xE6\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x5D"],
        ["\xE6\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x5E"],
        ["\xE6\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x5F"],
        ["\xE6\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x60"],
        ["\xE6\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x61"],
        ["\xE6\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x62"],
        ["\xE6\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x63"],
        ["\xE6\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x64"],
        ["\xE6\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x66"],
        ["\xE6\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x67"],
        ["\xE6\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x68"],
        ["\xE6\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x69"],
        ["\xE6\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x6A"],
        ["\xE6\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x6B"],
        ["\xE6\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x6D"],
        ["\xE6\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x65"],
        ["\xE6\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x6C"],
        ["\xE6\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x6E"],
        ["\xE6\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x6F"],
        ["\xE6\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x70"],
        ["\xE6\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x72"],
        ["\xE6\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x73"],
        ["\xE6\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x74"],
        ["\xE6\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x71"],
        ["\xE6\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x76"],
        ["\xE6\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x77"],
        ["\xE6\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x75"],
        ["\xE6\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x66"],
        ["\xE6\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x7A"],
        ["\xE6\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x7B"],
        ["\xE6\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x7E"],
        ["\xE6\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x7F"],
        ["\xE6\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x80"],
        ["\xE6\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x5A"],
        ["\xE6\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x74"],
        ["\xE6\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x82"],
        ["\xE6\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x81"],
        ["\xE6\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x83"],
        ["\xE6\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x84"],
        ["\xE6\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x86"],
        ["\xE6\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x6E"],
        ["\xE6\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x87"],
        ["\xE6\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x79"],
        ["\xE6\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x88"],
        ["\xE6\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x89"],
        ["\xE6\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x8A"],
        ["\xE6\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x8B"],
        ["\xE6\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x8C"],
        ["\xE6\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xC9"],
        ["\xE6\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x8F"],
        ["\xE6\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xDE"],
        ["\xE6\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x90"],
        ["\xE6\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x91"],
        ["\xE6\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x92"],
        ["\xE6\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x93"],
        ["\xE6\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x94"],
        ["\xE6\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x95"],
        ["\xE6\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x96"],
        ["\xE6\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x97"],
        ["\xE6\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x98"],
        ["\xE6\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x99"],
        ["\xE6\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x9A"],
        ["\xE6\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x9B"],
        ["\xE6\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x9C"],
        ["\xE6\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x9D"],
        ["\xE6\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x9E"],
        ["\xE6\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA0"],
        ["\xE6\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x9F"],
        ["\xE6\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA1"],
        ["\xE6\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA2"],
        ["\xE6\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA3"],
        ["\xE6\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA4"],
        ["\xE6\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA5"],
        ["\xE6\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA6"],
        ["\xE6\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA7"],
        ["\xE6\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA8"],
        ["\xE6\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xA9"],
        ["\xE7\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xAA"],
        ["\xE7\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xAB"],
        ["\xE7\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xAC"],
        ["\xE7\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xAD"],
        ["\xE7\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xAE"],
        ["\xE7\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xAF"],
        ["\xE7\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB0"],
        ["\xE7\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB1"],
        ["\xE7\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xFC"],
        ["\xE7\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB3"],
        ["\xE7\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB2"],
        ["\xE7\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB4"],
        ["\xE7\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB5"],
        ["\xE7\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB7"],
        ["\xE7\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB8"],
        ["\xE7\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB6"],
        ["\xE7\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xB9"],
        ["\xE7\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xBA"],
        ["\xE7\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xBB"],
        ["\xE7\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xBC"],
        ["\xE7\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xBD"],
        ["\xE7\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xBE"],
        ["\xE7\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xBF"],
        ["\xE7\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC0"],
        ["\xE7\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC2"],
        ["\xE7\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC1"],
        ["\xE7\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\x44"],
        ["\xE7\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x7A"],
        ["\xE7\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC5"],
        ["\xE7\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC3"],
        ["\xE7\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC4"],
        ["\xE7\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC6"],
        ["\xE7\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC7"],
        ["\xE7\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xC8"],
        ["\xE7\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xCA"],
        ["\xE7\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xCB"],
        ["\xE7\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xCC"],
        ["\xE7\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xCD"],
        ["\xE7\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xCE"],
        ["\xE7\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xCF"],
        ["\xE7\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD0"],
        ["\xE7\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD2"],
        ["\xE7\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD3"],
        ["\xE7\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD4"],
        ["\xE7\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD7"],
        ["\xE7\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD5"],
        ["\xE7\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD6"],
        ["\xE7\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD8"],
        ["\xE7\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x5B"],
        ["\xE7\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD1"],
        ["\xE7\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xD9"],
        ["\xE7\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xDA"],
        ["\xE7\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xDB"],
        ["\xE7\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xDC"],
        ["\xE7\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xDD"],
        ["\xE7\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xDE"],
        ["\xE7\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xDF"],
        ["\xE7\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE2"],
        ["\xE7\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE0"],
        ["\xE7\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE1"],
        ["\xE7\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE3"],
        ["\xE7\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE4"],
        ["\xE7\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE5"],
        ["\xE7\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE6"],
        ["\xE7\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE7"],
        ["\xE7\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE8"],
        ["\xE7\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xE9"],
        ["\xE7\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xEA"],
        ["\xE7\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xEB"],
        ["\xE7\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xEE"],
        ["\xE7\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xEF"],
        ["\xE7\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF0"],
        ["\xE7\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF2"],
        ["\xE7\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF3"],
        ["\xE7\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF4"],
        ["\xE7\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x9E"],
        ["\xE7\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF5"],
        ["\xE7\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x86"],
        ["\xE7\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF7"],
        ["\xE7\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF8"],
        ["\xE7\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF9"],
        ["\xE7\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xA9"],
        ["\xE7\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xFB"],
        ["\xE7\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xFC"],
        ["\xE7\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xFE"],
        ["\xE7\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x41"],
        ["\xE7\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x42"],
        ["\xE7\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x43"],
        ["\xE7\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x44"],
        ["\xE7\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x45"],
        ["\xE7\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x46"],
        ["\xE7\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x85"],
        ["\xE7\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x47"],
        ["\xE7\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xFA"],
        ["\xE7\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x48"],
        ["\xE7\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x4A"],
        ["\xE7\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x4B"],
        ["\xE7\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x4C"],
        ["\xE7\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xFD"],
        ["\xE7\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x4D"],
        ["\xE7\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x4E"],
        ["\xE7\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x4F"],
        ["\xE7\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x50"],
        ["\xE7\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x51"],
        ["\xE7\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x52"],
        ["\xE7\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x54"],
        ["\xE7\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x55"],
        ["\xE7\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x56"],
        ["\xE7\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x57"],
        ["\xE7\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x58"],
        ["\xE7\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x59"],
        ["\xE7\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x7B"],
        ["\xE7\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x5B"],
        ["\xE7\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xEA"],
        ["\xE7\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x5A"],
        ["\xE7\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x5C"],
        ["\xE7\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA8"],
        ["\xE7\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x5E"],
        ["\xE7\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x5F"],
        ["\xE7\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x60"],
        ["\xE7\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x61"],
        ["\xE7\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x62"],
        ["\xE7\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x5D"],
        ["\xE7\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x63"],
        ["\xE7\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x65"],
        ["\xE7\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x68"],
        ["\xE7\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x69"],
        ["\xE7\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x6A"],
        ["\xE7\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x6C"],
        ["\xE7\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x6D"],
        ["\xE7\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x6E"],
        ["\xE7\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x6F"],
        ["\xE7\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x70"],
        ["\xE7\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x71"],
        ["\xE7\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x72"],
        ["\xE7\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x73"],
        ["\xE7\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x74"],
        ["\xE7\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x75"],
        ["\xE7\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x76"],
        ["\xE7\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x77"],
        ["\xE7\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x78"],
        ["\xE7\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x79"],
        ["\xE7\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x7A"],
        ["\xE7\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x7B"],
        ["\xE7\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x7C"],
        ["\xE7\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x7D"],
        ["\xE7\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x7E"],
        ["\xE7\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x7F"],
        ["\xE7\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x80"],
        ["\xE7\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x52"],
        ["\xE7\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x81"],
        ["\xE7\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x82"],
        ["\xE7\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x87"],
        ["\xE7\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x88"],
        ["\xE7\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x89"],
        ["\xE7\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x84"],
        ["\xE7\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xD0"],
        ["\xE7\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x8B"],
        ["\xE7\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x8E"],
        ["\xE7\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x91"],
        ["\xE7\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x92"],
        ["\xE7\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x94"],
        ["\xE7\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x96"],
        ["\xE7\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x97"],
        ["\xE7\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x69"],
        ["\xE7\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x93"],
        ["\xE7\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x99"],
        ["\xE7\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x9A"],
        ["\xE7\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x9C"],
        ["\xE7\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x9D"],
        ["\xE7\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA0"],
        ["\xE7\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB1"],
        ["\xE7\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA4"],
        ["\xE7\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA7"],
        ["\xE7\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA2"],
        ["\xE7\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xAA"],
        ["\xE7\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xAE"],
        ["\xE7\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xAF"],
        ["\xE7\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB0"],
        ["\xE7\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA9"],
        ["\xE7\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB3"],
        ["\xE7\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xBA"],
        ["\xE7\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xBB"],
        ["\xE7\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB2"],
        ["\xE7\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC0"],
        ["\xE7\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC2"],
        ["\xE7\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC4"],
        ["\xE7\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x83"],
        ["\xE8\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC7"],
        ["\xE8\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xCA"],
        ["\xE8\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xCB"],
        ["\xE8\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xCD"],
        ["\xE8\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xBE"],
        ["\xE8\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xBF"],
        ["\xE8\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xCF"],
        ["\xE8\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xAD"],
        ["\xE8\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD1"],
        ["\xE8\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD2"],
        ["\xE8\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD3"],
        ["\xE8\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD4"],
        ["\xE8\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD7"],
        ["\xE8\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x6E"],
        ["\xE8\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD9"],
        ["\xE8\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xDA"],
        ["\xE8\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD6"],
        ["\xE8\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xDC"],
        ["\xE8\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xDE"],
        ["\xE8\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xDF"],
        ["\xE8\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE0"],
        ["\xE8\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE1"],
        ["\xE8\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE2"],
        ["\xE8\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE3"],
        ["\xE8\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE5"],
        ["\xE8\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xDB"],
        ["\xE8\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE6"],
        ["\xE8\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE7"],
        ["\xE8\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE9"],
        ["\xE8\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xEA"],
        ["\xE8\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xEC"],
        ["\xE8\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xED"],
        ["\xE8\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xCD"],
        ["\xE8\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xEE"],
        ["\xE8\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xEF"],
        ["\xE8\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\x56"],
        ["\xE8\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xEB"],
        ["\xE8\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF1"],
        ["\xE8\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF2"],
        ["\xE8\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF3"],
        ["\xE8\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF5"],
        ["\xE8\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF7"],
        ["\xE8\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF9"],
        ["\xE8\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xFA"],
        ["\xE8\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xFB"],
        ["\xE8\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xFC"],
        ["\xE8\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x98"],
        ["\xE8\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xFE"],
        ["\xE8\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xFD"],
        ["\xE8\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x41"],
        ["\xE8\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x43"],
        ["\xE8\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF8"],
        ["\xE8\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x44"],
        ["\xE8\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x45"],
        ["\xE8\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x46"],
        ["\xE8\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x42"],
        ["\xE8\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x47"],
        ["\xE8\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x48"],
        ["\xE8\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x49"],
        ["\xE8\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x4B"],
        ["\xE8\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x4C"],
        ["\xE8\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x4D"],
        ["\xE8\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x4E"],
        ["\xE8\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x4F"],
        ["\xE8\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x50"],
        ["\xE8\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x51"],
        ["\xE8\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x52"],
        ["\xE8\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x53"],
        ["\xE8\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x54"],
        ["\xE8\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x55"],
        ["\xE8\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x56"],
        ["\xE8\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x57"],
        ["\xE8\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x58"],
        ["\xE8\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x59"],
        ["\xE8\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x5A"],
        ["\xE8\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x5B"],
        ["\xE8\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x5C"],
        ["\xE8\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x5D"],
        ["\xE8\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x5E"],
        ["\xE8\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x5F"],
        ["\xE8\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x60"],
        ["\xE8\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x61"],
        ["\xE8\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x62"],
        ["\xE8\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x63"],
        ["\xE8\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x64"],
        ["\xE8\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x65"],
        ["\xE8\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x66"],
        ["\xE8\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x67"],
        ["\xE8\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x69"],
        ["\xE8\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x68"],
        ["\xE8\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x6A"],
        ["\xE8\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x6F"],
        ["\xE8\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x6B"],
        ["\xE8\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x72"],
        ["\xE8\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x6C"],
        ["\xE8\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x6D"],
        ["\xE8\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x6E"],
        ["\xE8\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x70"],
        ["\xE8\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x71"],
        ["\xE8\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x72"],
        ["\xE8\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x75"],
        ["\xE8\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x76"],
        ["\xE8\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x77"],
        ["\xE8\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x7B"],
        ["\xE8\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x7A"],
        ["\xE8\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x7C"],
        ["\xE8\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x7D"],
        ["\xE8\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x7E"],
        ["\xE8\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x80"],
        ["\xE8\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x81"],
        ["\xE8\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x82"],
        ["\xE8\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x83"],
        ["\xE8\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x84"],
        ["\xE8\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x85"],
        ["\xE8\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x77"],
        ["\xE8\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x5B"],
        ["\xE8\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xA1"],
        ["\xE8\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x87"],
        ["\xE8\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x8E"],
        ["\xE8\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x86"],
        ["\xE8\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x89"],
        ["\xE8\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x8A"],
        ["\xE8\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x8B"],
        ["\xE8\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x8C"],
        ["\xE8\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x8F"],
        ["\xE8\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x90"],
        ["\xE8\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x91"],
        ["\xE8\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x92"],
        ["\xE8\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x93"],
        ["\xE8\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x8D"],
        ["\xE8\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x94"],
        ["\xE8\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x95"],
        ["\xE8\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x96"],
        ["\xE8\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x98"],
        ["\xE8\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x9A"],
        ["\xE8\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x9B"],
        ["\xE8\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x9D"],
        ["\xE8\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x9C"],
        ["\xE8\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x9F"],
        ["\xE8\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA0"],
        ["\xE8\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA1"],
        ["\xE8\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA6"],
        ["\xE8\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA7"],
        ["\xE8\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA8"],
        ["\xE8\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA9"],
        ["\xE8\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xAA"],
        ["\xE8\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xD6"],
        ["\xE8\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB5"],
        ["\xE8\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xCE"],
        ["\xE8\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xAC"],
        ["\xE8\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xAD"],
        ["\xE8\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xAE"],
        ["\xE8\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xAF"],
        ["\xE8\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB0"],
        ["\xE8\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x77"],
        ["\xE8\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB1"],
        ["\xE8\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB2"],
        ["\xE8\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB3"],
        ["\xE8\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB4"],
        ["\xE8\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB5"],
        ["\xE8\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB6"],
        ["\xE8\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB7"],
        ["\xE8\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB8"],
        ["\xE8\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xB9"],
        ["\xE8\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xBA"],
        ["\xE8\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xBB"],
        ["\xE8\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xBC"],
        ["\xE8\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xBD"],
        ["\xE8\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xBE"],
        ["\xE8\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xBF"],
        ["\xE8\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x6F"],
        ["\xE8\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC0"],
        ["\xE8\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC1"],
        ["\xE8\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xFC"],
        ["\xE8\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC2"],
        ["\xE8\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC3"],
        ["\xE8\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\x56"],
        ["\xE8\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xFB"],
        ["\xE8\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC5"],
        ["\xE8\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC6"],
        ["\xE8\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC7"],
        ["\xE8\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC8"],
        ["\xE8\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xDC"],
        ["\xE8\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xC9"],
        ["\xE8\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xCA"],
        ["\xE8\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xCD"],
        ["\xE8\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xCE"],
        ["\xE8\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xCF"],
        ["\xE9\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD0"],
        ["\xE9\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD1"],
        ["\xE9\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD2"],
        ["\xE9\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD3"],
        ["\xE9\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD4"],
        ["\xE9\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD5"],
        ["\xE9\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD6"],
        ["\xE9\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD7"],
        ["\xE9\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD8"],
        ["\xE9\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xD9"],
        ["\xE9\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xDC"],
        ["\xE9\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xDE"],
        ["\xE9\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE0"],
        ["\xE9\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xBC"],
        ["\xE9\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE2"],
        ["\xE9\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE3"],
        ["\xE9\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE4"],
        ["\xE9\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE7"],
        ["\xE9\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE1"],
        ["\xE9\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE8"],
        ["\xE9\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xE9"],
        ["\xE9\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xEA"],
        ["\xE9\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xEB"],
        ["\xE9\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xEC"],
        ["\xE9\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xED"],
        ["\xE9\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xEE"],
        ["\xE9\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xEF"],
        ["\xE9\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF0"],
        ["\xE9\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF1"],
        ["\xE9\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF2"],
        ["\xE9\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF3"],
        ["\xE9\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF4"],
        ["\xE9\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xE8"],
        ["\xE9\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF5"],
        ["\xE9\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF6"],
        ["\xE9\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF7"],
        ["\xE9\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF8"],
        ["\xE9\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xFA"],
        ["\xE9\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xFB"],
        ["\xE9\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xFC"],
        ["\xE9\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xFD"],
        ["\xE9\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xFE"],
        ["\xE9\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x41"],
        ["\xE9\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x42"],
        ["\xE9\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x43"],
        ["\xE9\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x44"],
        ["\xE9\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x45"],
        ["\xE9\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x46"],
        ["\xE9\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x48"],
        ["\xE9\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x49"],
        ["\xE9\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x4A"],
        ["\xE9\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x4B"],
        ["\xE9\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x4C"],
        ["\xE9\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x4D"],
        ["\xE9\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x4E"],
        ["\xE9\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x47"],
        ["\xE9\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x4F"],
        ["\xE9\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x50"],
        ["\xE9\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x51"],
        ["\xE9\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x53"],
        ["\xE9\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x54"],
        ["\xE9\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x52"],
        ["\xE9\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x55"],
        ["\xE9\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x56"],
        ["\xE9\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x57"],
        ["\xE9\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x58"],
        ["\xE9\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x5A"],
        ["\xE9\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x5B"],
        ["\xE9\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x5C"],
        ["\xE9\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x5D"],
        ["\xE9\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x5F"],
        ["\xE9\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x60"],
        ["\xE9\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x5E"],
        ["\xE9\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x62"],
        ["\xE9\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x61"],
        ["\xE9\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x63"],
        ["\xE9\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x64"],
        ["\xE9\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x65"],
        ["\xE9\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x66"],
        ["\xE9\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x67"],
        ["\xE9\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x6A"],
        ["\xE9\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x68"],
        ["\xE9\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x69"],
        ["\xE9\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x6D"],
        ["\xE9\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x6E"],
        ["\xE9\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x6F"],
        ["\xE9\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x70"],
        ["\xE9\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x71"],
        ["\xE9\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x72"],
        ["\xE9\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x73"],
        ["\xE9\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x74"],
        ["\xE9\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x75"],
        ["\xE9\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x76"],
        ["\xE9\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x77"],
        ["\xE9\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x78"],
        ["\xE9\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x79"],
        ["\xE9\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x7A"],
        ["\xE9\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x7B"],
        ["\xE9\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x7C"],
        ["\xE9\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x7D"],
        ["\xE9\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x7E"],
        ["\xE9\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x7F"],
        ["\xE9\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x80"],
        ["\xE9\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x81"],
        ["\xE9\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x82"],
        ["\xE9\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x83"],
        ["\xE9\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x84"],
        ["\xE9\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x85"],
        ["\xE9\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x87"],
        ["\xE9\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x89"],
        ["\xE9\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x8A"],
        ["\xE9\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x89"],
        ["\xE9\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x8B"],
        ["\xE9\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x8C"],
        ["\xE9\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x8D"],
        ["\xE9\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x8E"],
        ["\xE9\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x90"],
        ["\xE9\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x92"],
        ["\xE9\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x94"],
        ["\xE9\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x95"],
        ["\xE9\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x96"],
        ["\xE9\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x97"],
        ["\xE9\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x98"],
        ["\xE9\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x99"],
        ["\xE9\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x9A"],
        ["\xE9\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x9C"],
        ["\xE9\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x9D"],
        ["\xE9\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x9E"],
        ["\xE9\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA0"],
        ["\xE9\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA1"],
        ["\xE9\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA2"],
        ["\xE9\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA3"],
        ["\xE9\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA4"],
        ["\xE9\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA5"],
        ["\xE9\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA6"],
        ["\xE9\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA7"],
        ["\xE9\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA8"],
        ["\xE9\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xA9"],
        ["\xE9\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF0"],
        ["\xE9\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xAC"],
        ["\xE9\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xAB"],
        ["\xE9\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x55\x51"],
        ["\xE9\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xAF"],
        ["\xE9\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB0"],
        ["\xE9\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB2"],
        ["\xE9\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB3"],
        ["\xE9\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB4"],
        ["\xE9\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB5"],
        ["\xE9\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB6"],
        ["\xE9\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB7"],
        ["\xE9\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB8"],
        ["\xE9\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xAD"],
        ["\xE9\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB9"],
        ["\xE9\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xAE"],
        ["\xE9\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xBA"],
        ["\xE9\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xBB"],
        ["\xE9\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xBC"],
        ["\xE9\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xBD"],
        ["\xE9\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xBE"],
        ["\xE9\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xBF"],
        ["\xE9\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC0"],
        ["\xE9\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC1"],
        ["\xE9\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC2"],
        ["\xE9\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC3"],
        ["\xE9\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC4"],
        ["\xE9\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC5"],
        ["\xE9\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC6"],
        ["\xE9\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC8"],
        ["\xE9\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC9"],
        ["\xE9\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xCA"],
        ["\xE9\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xCB"],
        ["\xE9\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x54\xFC"],
        ["\xE9\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xC7"],
        ["\xE9\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xCC"],
        ["\xE9\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xCD"],
        ["\xE9\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xCE"],
        ["\xE9\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xCF"],
        ["\xE9\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x50\xE5"],
        ["\xE9\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD1"],
        ["\xE9\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD2"],
        ["\xE9\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD7"],
        ["\xE9\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD3"],
        ["\xE9\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD4"],
        ["\xE9\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD5"],
        ["\xE9\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD6"],
        ["\xE9\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD8"],
        ["\xE9\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xD9"],
        ["\xE9\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xDA"],
        ["\xEA\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xDB"],
        ["\xEA\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xDC"],
        ["\xEA\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE0"],
        ["\xEA\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xDE"],
        ["\xEA\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xDF"],
        ["\xEA\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xDD"],
        ["\xEA\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE1"],
        ["\xEA\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x42"],
        ["\xEA\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE3"],
        ["\xEA\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xEA"],
        ["\xEA\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE5"],
        ["\xEA\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE6"],
        ["\xEA\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE7"],
        ["\xEA\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE8"],
        ["\xEA\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE9"],
        ["\xEA\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xEB"],
        ["\xEA\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xEC"],
        ["\xEA\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xED"],
        ["\xEA\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xEE"],
        ["\xEA\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xEF"],
        ["\xEA\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF0"],
        ["\xEA\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF1"],
        ["\xEA\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF2"],
        ["\xEA\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF3"],
        ["\xEA\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF5"],
        ["\xEA\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF6"],
        ["\xEA\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF7"],
        ["\xEA\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF8"],
        ["\xEA\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xF9"],
        ["\xEA\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xFA"],
        ["\xEA\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xFB"],
        ["\xEA\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xFC"],
        ["\xEA\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xFD"],
        ["\xEA\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x41"],
        ["\xEA\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x42"],
        ["\xEA\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x43"],
        ["\xEA\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x44"],
        ["\xEA\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x45"],
        ["\xEA\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x46"],
        ["\xEA\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x47"],
        ["\xEA\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x48"],
        ["\xEA\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF9"],
        ["\xEA\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x49"],
        ["\xEA\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x4A"],
        ["\xEA\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x4B"],
        ["\xEA\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x4C"],
        ["\xEA\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xB4"],
        ["\xEA\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x4D"],
        ["\xEA\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x4E"],
        ["\xEA\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x4F"],
        ["\xEA\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x52"],
        ["\xEA\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x53"],
        ["\xEA\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xA7"],
        ["\xEA\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x54"],
        ["\xEA\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x55"],
        ["\xEA\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x57"],
        ["\xEA\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x58"],
        ["\xEA\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x59"],
        ["\xEA\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x5A"],
        ["\xEA\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x5B"],
        ["\xEA\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x5C"],
        ["\xEA\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x5D"],
        ["\xEA\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x5E"],
        ["\xEA\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x5F"],
        ["\xEA\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x60"],
        ["\xEA\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x61"],
        ["\xEA\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x62"],
        ["\xEA\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x63"],
        ["\xEA\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x64"],
        ["\xEA\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x65"],
        ["\xEA\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x66"],
        ["\xEA\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x67"],
        ["\xEA\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x68"],
        ["\xEA\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x69"],
        ["\xEA\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x6A"],
        ["\xEA\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x6B"],
        ["\xEA\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x6C"],
        ["\xEA\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x6D"],
        ["\xEA\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x70"],
        ["\xEA\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x71"],
        ["\xEA\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x72"],
        ["\xEA\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x73"],
        ["\xEA\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x74"],
        ["\xEA\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x75"],
        ["\xEA\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x76"],
        ["\xEA\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x77"],
        ["\xEA\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x78"],
        ["\xEA\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x79"],
        ["\xEA\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x7A"],
        ["\xEA\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x7B"],
        ["\xEA\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x7C"],
        ["\xEA\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x7D"],
        ["\xEA\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x7E"],
        ["\xEA\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x7F"],
        ["\xEA\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4E\x53"],
        ["\xEA\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4D\xB9"],
        ["\xEA\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xF3"],
        ["\xEA\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xBB"],
        ["\xEA\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x84"],
        ["\xEA\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x4F\x68"],
        ["\x86\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB1"],
        ["\x86\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB2"],
        ["\x86\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB3"],
        ["\x86\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB4"],
        ["\x86\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB5"],
        ["\x86\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB6"],
        ["\x86\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB7"],
        ["\x86\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB8"],
        ["\x86\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xB9"],
        ["\x86\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x41\xBA"],
        ["\x81\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x7D"],
        ["\x81\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x7F"],
        ["\xED\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xBF"],
        ["\xEE\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xDA"],
        ["\xEF\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x51\xF7"],
        ["\xEF\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x4B"],
        ["\xF8\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x7B"],
        ["\x87\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x94"],
        ["\xF5\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\x9E"],
        ["\xEB\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x52\xEB"],
        ["\xEB\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x86"],
        ["\xFB\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x94"],
        ["\xEB\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\x97"],
        ["\xEA\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x53\xC7"],
        ["\x87\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x44"],
        ["\x87\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x5D"],
        ["\xF0\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x65"],
        ["\x87\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x66"],
        ["\x87\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x6E"],
        ["\xF0\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x70"],
        ["\x87\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x71"],
        ["\xF0\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x74"],
        ["\x87\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x7B"],
        ["\x87\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x8A"],
        ["\xF0\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x91"],
        ["\xF0\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\x98"],
        ["\xF0\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA2"],
        ["\xF0\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA3"],
        ["\xF0\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA4"],
        ["\x87\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xA8"],
        ["\x87\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xC9"],
        ["\x87\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xDC"],
        ["\x87\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x56\xF7"],
        ["\xF1\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x50"],
        ["\x87\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x58"],
        ["\x87\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x61"],
        ["\x87\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x63"],
        ["\xF1\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x6B"],
        ["\x87\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x80"],
        ["\x87\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\x87"],
        ["\x87\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xA9"],
        ["\xF1\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xAE"],
        ["\x88\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xBD"],
        ["\x88\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xC0"],
        ["\x88\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x57\xDE"],
        ["\xF1\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x6C"],
        ["\x88\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x70"],
        ["\x88\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x73"],
        ["\x88\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x77"],
        ["\x88\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x82"],
        ["\x88\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\x8A"],
        ["\xF2\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xA1"],
        ["\xF2\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB0"],
        ["\x88\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xB1"],
        ["\x88\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xBE"],
        ["\x98\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xEC"],
        ["\xF0\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xFC"],
        ["\xEC\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x58\xFE"],
        ["\x98\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x42"],
        ["\x98\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x44"],
        ["\x98\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x51"],
        ["\xF0\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x67"],
        ["\x98\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x68"],
        ["\x98\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x78"],
        ["\x98\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x7F"],
        ["\x98\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x80"],
        ["\xF0\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x84"],
        ["\x98\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x87"],
        ["\x98\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x93"],
        ["\xF0\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\x95"],
        ["\xEA\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xCB"],
        ["\xEA\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xD8"],
        ["\xEA\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xE8"],
        ["\xEA\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xF1"],
        ["\xF2\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x57"],
        ["\xEA\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x65"],
        ["\xF2\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x68"],
        ["\xEA\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x79"],
        ["\xEA\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x7E"],
        ["\xF2\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\x94"],
        ["\xF3\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xDA"],
        ["\xEA\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5A\xFB"],
        ["\xEA\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x50"],
        ["\xF3\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x53"],
        ["\xEA\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x54"],
        ["\xEB\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x97"],
        ["\xEB\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x98"],
        ["\xEB\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\x9D"],
        ["\xEB\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA1"],
        ["\xEB\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA4"],
        ["\xEB\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA7"],
        ["\xF3\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xA8"],
        ["\xEB\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xAB"],
        ["\xEB\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xAF"],
        ["\xF3\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB4"],
        ["\xEB\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB6"],
        ["\xEB\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xB8"],
        ["\xF3\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xBB"],
        ["\xEB\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC7"],
        ["\xEB\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xC9"],
        ["\xEB\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xD8"],
        ["\xEB\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xE3"],
        ["\xEB\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xEC"],
        ["\xEB\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF0"],
        ["\xEB\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF3"],
        ["\xF3\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5B\xF9"],
        ["\xF3\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x5F"],
        ["\xF3\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x66"],
        ["\xEB\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x6E"],
        ["\xEB\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x78"],
        ["\xF4\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x79"],
        ["\xEB\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x90"],
        ["\xF4\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x9A"],
        ["\xEB\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\x9B"],
        ["\xF4\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA6"],
        ["\xEB\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xA9"],
        ["\xF4\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xAF"],
        ["\xEB\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xBC"],
        ["\xEB\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xEA"],
        ["\xF4\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF6"],
        ["\xEB\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xF9"],
        ["\xEB\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5C\xFD"],
        ["\xF4\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x4E"],
        ["\xEB\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x58"],
        ["\xEB\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x60"],
        ["\xEB\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x72"],
        ["\xF4\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x74"],
        ["\xEB\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x80"],
        ["\xEB\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x8E"],
        ["\xF4\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x93"],
        ["\xF4\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\x95"],
        ["\xF5\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xA6"],
        ["\xEC\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xC1"],
        ["\xF5\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xCA"],
        ["\xEC\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD5"],
        ["\xEC\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD7"],
        ["\xF5\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xD8"],
        ["\xEC\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xE3"],
        ["\xEC\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xEA"],
        ["\xEC\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xED"],
        ["\xEC\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF5"],
        ["\xF5\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xF6"],
        ["\xEC\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xFB"],
        ["\xEC\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xFC"],
        ["\xEC\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5D\xFD"],
        ["\xEC\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x49"],
        ["\xEC\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x4B"],
        ["\xEC\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x5A"],
        ["\xF5\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x73"],
        ["\xEC\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x75"],
        ["\xEC\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x8A"],
        ["\xF5\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x94"],
        ["\xEC\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x9E"],
        ["\xEC\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\x9F"],
        ["\xEC\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA1"],
        ["\xEC\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xA7"],
        ["\xEC\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xAA"],
        ["\xEC\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xAB"],
        ["\xEC\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xAE"],
        ["\xEC\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xBC"],
        ["\xEC\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xBD"],
        ["\xEC\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xC0"],
        ["\xEC\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xD1"],
        ["\xEC\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5E\xE7"],
        ["\xF6\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x70"],
        ["\xEC\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x71"],
        ["\xEC\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x72"],
        ["\xEC\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x73"],
        ["\xEC\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\x8E"],
        ["\xF1\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xAA"],
        ["\xF6\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xAE"],
        ["\xED\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB2"],
        ["\xF6\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xB3"],
        ["\xF6\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD1"],
        ["\xED\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD5"],
        ["\xED\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xD9"],
        ["\xF6\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xDC"],
        ["\xED\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xDD"],
        ["\xF6\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x5F\xDF"],
        ["\xF7\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x4F"],
        ["\xF7\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x58"],
        ["\xED\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x5A"],
        ["\xED\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\x82"],
        ["\xED\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC4"],
        ["\xED\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xC6"],
        ["\xF7\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xD4"],
        ["\xED\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xDA"],
        ["\xED\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xE1"],
        ["\xED\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x60\xFD"],
        ["\xED\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\x57"],
        ["\xED\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x61\xF8"],
        ["\xED\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x48"],
        ["\xF8\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x5B"],
        ["\xED\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x67"],
        ["\xEE\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x7E"],
        ["\xEE\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x8A"],
        ["\xF8\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\x9E"],
        ["\xEE\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xA1"],
        ["\xEE\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xB9"],
        ["\xEE\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xBB"],
        ["\xF9\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xCE"],
        ["\xF9\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x62\xE2"],
        ["\xEE\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\x90"],
        ["\xEE\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xC5"],
        ["\xEE\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xCB"],
        ["\xEE\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xD4"],
        ["\xEE\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xDF"],
        ["\xF9\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xE1"],
        ["\xEE\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xED"],
        ["\xEE\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xEE"],
        ["\xEE\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x63\xEF"],
        ["\xF9\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x50"],
        ["\xFA\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x7C"],
        ["\xEE\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x7D"],
        ["\xEE\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\x85"],
        ["\xFA\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x64\xF1"],
        ["\xEE\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x64"],
        ["\xEE\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x66"],
        ["\xEE\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x67"],
        ["\xEE\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x6B"],
        ["\xFA\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x83"],
        ["\xEE\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x85"],
        ["\xEF\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x8A"],
        ["\xFA\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x8C"],
        ["\xEE\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x8D"],
        ["\xEF\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x8F"],
        ["\xEF\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x93"],
        ["\xFA\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x95"],
        ["\xEF\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x9B"],
        ["\xEF\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x9E"],
        ["\xEF\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\x9F"],
        ["\xFA\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA1"],
        ["\xFA\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA3"],
        ["\xFA\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA5"],
        ["\xEF\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA6"],
        ["\xFA\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xA8"],
        ["\xFA\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xAB"],
        ["\xEF\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xAD"],
        ["\xFA\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB4"],
        ["\xFA\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB5"],
        ["\xFA\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB6"],
        ["\xFA\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xB7"],
        ["\xEF\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xBC"],
        ["\xEF\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xBD"],
        ["\xEF\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC1"],
        ["\xEF\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC3"],
        ["\xFB\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC5"],
        ["\xFB\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC8"],
        ["\xEF\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xC9"],
        ["\xFB\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xCC"],
        ["\xFB\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xCE"],
        ["\xEF\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD0"],
        ["\xFB\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xD5"],
        ["\xEF\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xDD"],
        ["\xEF\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xE4"],
        ["\xFB\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x65\xF4"],
        ["\xEF\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x74"],
        ["\xEF\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x79"],
        ["\xFB\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x7F"],
        ["\xEF\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x97"],
        ["\xEF\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\x99"],
        ["\xEF\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA2"],
        ["\xEF\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA3"],
        ["\xFB\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xA5"],
        ["\xEF\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xCB"],
        ["\xEF\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xCC"],
        ["\xEF\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x66\xF9"],
        ["\xEF\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x59"],
        ["\xFC\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x6C"],
        ["\xEF\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x8F"],
        ["\xEF\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x91"],
        ["\xEF\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x93"],
        ["\xFC\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\x9B"],
        ["\xEF\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xB1"],
        ["\xEF\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE2"],
        ["\xFC\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xE4"],
        ["\xFC\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x67\xFE"],
        ["\xEF\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x68\x56"],
        ["\x81\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x4A"],
        ["\x81\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7C"],
        ["\x81\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x60"],
        ["\x81\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x81\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x81\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xB3"],
        ["\x81\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xB4"],
        ["\x81\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xB5"],
        ["\x81\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xB8"],
        ["\x81\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xB9"],
        ["\x81\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xDD"],
        ["\x81\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xD2"],
        ["\x81\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x74"],
        ["\x81\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x75"],
        ["\x81\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x78"],
        ["\x81\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x79"],
        ["\x81\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xCF"],
        ["\x81\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xCD"],
        ["\x81\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xEE"],
        ["\x81\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xEF"],
        ["\x81\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x81\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x83"],
        ["\x81\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x84"],
        ["\x81\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x85"],
        ["\x81\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xE6"],
        ["\x81\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE9\xF7"],
        ["\x81\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE9\xF8"],
        ["\x81\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xA8"],
        ["\x81\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xA9"],
        ["\x81\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xA6"],
        ["\x81\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xA7"],
        ["\x81\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x58"],
        ["\x81\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xFA"],
        ["\x81\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xFC"],
        ["\x81\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x41"],
        ["\x81\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x68"],
        ["\x81\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\x69"],
        ["\x81\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x61"],
        ["\x81\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xCA"],
        ["\x81\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC8"],
        ["\x81\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC9"],
        ["\x81\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC7"],
        ["\x82\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xE5"],
        ["\x82\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xE4"],
        ["\x82\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xED"],
        ["\x82\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xEC"],
        ["\x82\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x64"],
        ["\x82\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x65"],
        ["\x82\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x63"],
        ["\x82\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x66"],
        ["\x82\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x91"],
        ["\x82\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xB3"],
        ["\x82\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xB1"],
        ["\x82\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xB2"],
        ["\x82\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xB4"],
        ["\x82\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEB\x77"],
        ["\x82\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEB\x78"],
        ["\x82\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x44"],
        ["\x82\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xF3"],
        ["\x82\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xBA"],
        ["\x82\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\xAB"],
        ["\x82\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\xAA"],
        ["\x82\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x4F"],
        ["\x82\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xBD"],
        ["\x82\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\xD7"],
        ["\x82\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xD8"],
        ["\x82\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xB5"],
        ["\x82\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE9\x6A"],
        ["\x82\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xB9"],
        ["\x82\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xCB"],
        ["\x82\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xDC"],
        ["\x82\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xB6"],
        ["\x82\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x7F"],
        ["\x82\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x80"],
        ["\x82\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xCF"],
        ["\x82\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xD0"],
        ["\x82\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xD1"],
        ["\x82\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x82\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x82\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x82\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x82\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC2"],
        ["\x83\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xBE"],
        ["\x83\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC0"],
        ["\x83\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC4"],
        ["\x83\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xBF"],
        ["\x83\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC3"],
        ["\x83\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC5"],
        ["\x83\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC1"],
        ["\x83\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x94"],
        ["\x83\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x47"],
        ["\x83\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x48"],
        ["\x83\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x49"],
        ["\x83\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x4A"],
        ["\x83\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x4B"],
        ["\x83\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x4C"],
        ["\x83\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x4D"],
        ["\x83\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x4E"],
        ["\x83\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x4F"],
        ["\x83\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x50"],
        ["\x83\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xCB"],
        ["\x83\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xCC"],
        ["\x83\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xAF"],
        ["\x83\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x74"],
        ["\x83\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x68"],
        ["\x83\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x69"],
        ["\x83\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x6A"],
        ["\x83\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x6B"],
        ["\x83\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\xC6"],
        ["\x83\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xE1"],
        ["\x83\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x85"],
        ["\x83\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x86"],
        ["\x83\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x87"],
        ["\x83\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x88"],
        ["\x83\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x89"],
        ["\x83\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x8A"],
        ["\x83\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x8B"],
        ["\x83\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x8C"],
        ["\x83\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x8D"],
        ["\x83\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x8E"],
        ["\x83\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x83\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x8F"],
        ["\x83\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x90"],
        ["\x83\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x91"],
        ["\x83\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x92"],
        ["\x83\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x93"],
        ["\x83\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEC\x94"],
        ["\x84\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xF5"],
        ["\x84\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xF6"],
        ["\x84\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xF7"],
        ["\x84\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xF8"],
        ["\x84\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xF9"],
        ["\x84\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xFA"],
        ["\x84\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xFB"],
        ["\x84\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xFC"],
        ["\x84\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xFD"],
        ["\x84\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xFE"],
        ["\x84\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE1\x41"],
        ["\x84\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE1\x42"],
        ["\x84\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE1\x43"],
        ["\x84\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE1\x44"],
        ["\x84\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE1\x45"],
        ["\x84\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xD8"],
        ["\x84\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xD9"],
        ["\x84\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xDA"],
        ["\x84\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\xDB"],
        ["\x84\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xC7"],
        ["\x84\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xC8"],
        ["\x84\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xF3"],
        ["\x84\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xF4"],
        ["\x84\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDE\xF5"],
        ["\x84\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE5\xB2"],
        ["\x84\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE0\xF1"],
        ["\x84\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\xE4"],
        ["\x84\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE1\x46"],
        ["\x84\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xAF"],
        ["\x84\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB0"],
        ["\x84\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB1"],
        ["\x84\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB2"],
        ["\x84\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB3"],
        ["\x84\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB4"],
        ["\x84\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB5"],
        ["\x84\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB6"],
        ["\x84\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB7"],
        ["\x84\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB8"],
        ["\x84\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xB9"],
        ["\x84\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xBA"],
        ["\x84\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xBB"],
        ["\x84\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xBC"],
        ["\x84\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xBD"],
        ["\x84\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xBE"],
        ["\x84\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xBF"],
        ["\x84\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC0"],
        ["\x84\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC1"],
        ["\x84\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC2"],
        ["\x84\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC3"],
        ["\x84\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC4"],
        ["\x84\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC5"],
        ["\x84\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC6"],
        ["\x84\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC7"],
        ["\x84\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC8"],
        ["\x84\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xC9"],
        ["\x84\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xCA"],
        ["\x84\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xCB"],
        ["\x84\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xCC"],
        ["\x84\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xF7"],
        ["\x84\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xF8"],
        ["\x84\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xF9"],
        ["\x84\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\xFA"],
        ["\x84\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xD0"],
        ["\x84\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xDA"],
        ["\x84\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xDB"],
        ["\x84\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xDC"],
        ["\x84\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x7C"],
        ["\x84\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x7D"],
        ["\x84\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x7F"],
        ["\x84\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDA\xDE"],
        ["\x84\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDA\xDF"],
        ["\x84\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x94"],
        ["\x84\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x95"],
        ["\x84\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x80"],
        ["\x84\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x81"],
        ["\x84\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x83"],
        ["\x84\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x85"],
        ["\x84\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x87"],
        ["\x84\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x89"],
        ["\x84\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x8B"],
        ["\x85\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\xE1"],
        ["\x85\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x41"],
        ["\x85\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x42"],
        ["\x85\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x43"],
        ["\x85\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x42\x6A"],
        ["\x85\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x44"],
        ["\x85\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x45"],
        ["\x85\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x46"],
        ["\x85\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x47"],
        ["\x85\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x48"],
        ["\x85\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x49"],
        ["\x85\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x4A"],
        ["\x85\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x4B"],
        ["\x85\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x4D"],
        ["\x85\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x4E"],
        ["\x85\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x4F"],
        ["\x85\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x50"],
        ["\x85\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x51"],
        ["\x85\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x52"],
        ["\x85\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x53"],
        ["\x85\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x54"],
        ["\x85\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x55"],
        ["\x85\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x56"],
        ["\x85\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x57"],
        ["\x85\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x58"],
        ["\x85\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x59"],
        ["\x85\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x5A"],
        ["\x85\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x5B"],
        ["\x85\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x5C"],
        ["\x85\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x5D"],
        ["\x85\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x5E"],
        ["\x85\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x5F"],
        ["\x85\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x60"],
        ["\x85\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x61"],
        ["\x85\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x62"],
        ["\x85\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x63"],
        ["\x85\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x64"],
        ["\x85\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x65"],
        ["\x85\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x66"],
        ["\x85\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x67"],
        ["\x85\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x68"],
        ["\x85\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x69"],
        ["\x85\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x6A"],
        ["\x85\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x6B"],
        ["\x85\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x6C"],
        ["\x85\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x6D"],
        ["\x85\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x6E"],
        ["\x85\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x6F"],
        ["\x85\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x70"],
        ["\x85\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x71"],
        ["\x85\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x72"],
        ["\x85\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x73"],
        ["\x85\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x74"],
        ["\x85\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x75"],
        ["\x85\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x76"],
        ["\x85\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x77"],
        ["\x85\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x78"],
        ["\x85\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x79"],
        ["\x85\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x7A"],
        ["\x85\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x7B"],
        ["\x85\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x7C"],
        ["\x85\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x7D"],
        ["\x85\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x7E"],
        ["\x85\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x7F"],
        ["\x85\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x80"],
        ["\x85\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x81"],
        ["\x85\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x82"],
        ["\x85\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x83"],
        ["\x85\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x84"],
        ["\x85\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x85"],
        ["\x85\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x86"],
        ["\x85\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x87"],
        ["\x85\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x88"],
        ["\x85\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x89"],
        ["\x85\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x8A"],
        ["\x85\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x8B"],
        ["\x85\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x8C"],
        ["\x85\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x8D"],
        ["\x85\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x8E"],
        ["\x85\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x8F"],
        ["\x85\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x90"],
        ["\x85\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x91"],
        ["\x85\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x92"],
        ["\x85\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\x93"],
        ["\x85\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xB8"],
        ["\x85\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xE2"],
        ["\x85\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x64"],
        ["\x85\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xCA"],
        ["\x85\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x46"],
        ["\x85\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xB9"],
        ["\x85\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xE3"],
        ["\x85\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x65"],
        ["\x85\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xCB"],
        ["\x85\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x47"],
        ["\x85\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xBC"],
        ["\x85\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xF9"],
        ["\x85\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xF9"],
        ["\x85\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xF5"],
        ["\x85\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x54"],
        ["\x85\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x5A"],
        ["\x85\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x58"],
        ["\x85\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x5E"],
        ["\x85\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x73"],
        ["\x85\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x77"],
        ["\x85\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x75"],
        ["\x85\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xBD"],
        ["\x85\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xFC"],
        ["\x85\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xFA"],
        ["\x85\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xF6"],
        ["\x85\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x55"],
        ["\x85\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xED"],
        ["\x85\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x5B"],
        ["\x85\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x59"],
        ["\x85\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x5F"],
        ["\x85\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x74"],
        ["\x85\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xFE"],
        ["\x85\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x78"],
        ["\x85\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x76"],
        ["\x85\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x4E"],
        ["\x85\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xBA"],
        ["\x85\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xF1"],
        ["\x85\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xBE"],
        ["\x85\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC4"],
        ["\x85\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xD0"],
        ["\x85\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xD2"],
        ["\x85\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC6"],
        ["\x85\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xFB"],
        ["\x85\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x41"],
        ["\x85\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x4A"],
        ["\x85\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x52"],
        ["\x85\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x68"],
        ["\x85\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x6A"],
        ["\x85\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x5C"],
        ["\x85\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x4F"],
        ["\x85\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xBB"],
        ["\x85\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xF2"],
        ["\x85\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xBF"],
        ["\x85\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC5"],
        ["\x85\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xD1"],
        ["\x85\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xD3"],
        ["\x85\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC7"],
        ["\x85\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC9"],
        ["\x85\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xFC"],
        ["\x85\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x42"],
        ["\x85\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x4B"],
        ["\x85\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x53"],
        ["\x85\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x69"],
        ["\x85\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x6B"],
        ["\x85\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x5D"],
        ["\x85\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xFA"],
        ["\x85\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC0"],
        ["\x85\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xD4"],
        ["\x85\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xDC"],
        ["\x85\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xEC"],
        ["\x85\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x56"],
        ["\x85\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x66"],
        ["\x85\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xC1"],
        ["\x85\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xD5"],
        ["\x85\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xDD"],
        ["\x85\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xED"],
        ["\x85\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x57"],
        ["\x85\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x67"],
        ["\x85\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xAD"],
        ["\x85\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC7"],
        ["\x85\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xBA"],
        ["\x85\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xBF"],
        ["\x85\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xCE"],
        ["\x85\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA8"],
        ["\x85\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xAA"],
        ["\x85\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xB5"],
        ["\x85\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC4"],
        ["\x85\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x92"],
        ["\x85\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xAF"],
        ["\x85\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xB9"],
        ["\x85\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xBE"],
        ["\x85\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xCC"],
        ["\x85\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xB7"],
        ["\x85\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA9"],
        ["\x85\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x9B"],
        ["\x85\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xAE"],
        ["\x85\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xD9"],
        ["\x85\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xCA"],
        ["\x85\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x9D"],
        ["\x85\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x45"],
        ["\x85\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xAC"],
        ["\x85\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xBD"],
        ["\x85\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD6\xDF"],
        ["\x85\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xD1"],
        ["\x86\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xD0"],
        ["\x86\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA2"],
        ["\x86\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xD4"],
        ["\x86\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x7B"],
        ["\x86\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x8F"],
        ["\x86\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x93"],
        ["\x86\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC0"],
        ["\x86\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x9C"],
        ["\x86\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x93"],
        ["\x86\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x4D"],
        ["\x86\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x4C"],
        ["\x86\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA4"],
        ["\x86\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC5"],
        ["\x86\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x94"],
        ["\x86\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xB1"],
        ["\x86\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x95"],
        ["\x86\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x98"],
        ["\x86\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x9A"],
        ["\x86\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x8C"],
        ["\x86\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xAB"],
        ["\x86\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC6"],
        ["\x86\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA0"],
        ["\x86\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC8"],
        ["\x86\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x90"],
        ["\x86\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x8D"],
        ["\x86\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x8E"],
        ["\x86\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xC9"],
        ["\x86\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA1"],
        ["\x86\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xDE"],
        ["\x86\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xDD"],
        ["\x86\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x91"],
        ["\x86\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xCD"],
        ["\x86\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xB6"],
        ["\x86\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xA3"],
        ["\x86\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\x96"],
        ["\x86\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD7\x90"],
        ["\x86\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDC\x63"],
        ["\x86\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDC\x64"],
        ["\x86\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDC\x62"],
        ["\x86\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDC\x65"],
        ["\x86\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\xB2"],
        ["\x86\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xEE"],
        ["\x86\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xF0"],
        ["\x86\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xF2"],
        ["\x86\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD8\xF3"],
        ["\x86\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x57"],
        ["\x86\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xD2"],
        ["\x86\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x5C"],
        ["\x86\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x52"],
        ["\x86\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x55"],
        ["\x86\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x51"],
        ["\x86\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x60"],
        ["\x86\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x5D"],
        ["\x86\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x53"],
        ["\x86\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x42"],
        ["\x86\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x43"],
        ["\x86\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x44"],
        ["\x86\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x45"],
        ["\x86\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x46"],
        ["\x86\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x44\x7D"],
        ["\x86\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x76"],
        ["\x86\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x7D"],
        ["\x86\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x8A"],
        ["\x86\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x6D"],
        ["\x86\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x70"],
        ["\x86\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x71"],
        ["\x86\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x59"],
        ["\x86\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x8E"],
        ["\x86\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x7A"],
        ["\x86\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x80"],
        ["\x86\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD9\x41"],
        ["\x86\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x75"],
        ["\x86\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x81"],
        ["\x86\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x8D"],
        ["\x86\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x85"],
        ["\x86\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x6E"],
        ["\x86\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x6F"],
        ["\x86\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x69"],
        ["\x86\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x6A"],
        ["\x86\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x7B"],
        ["\x86\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x8B"],
        ["\x86\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x8C"],
        ["\x86\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x54"],
        ["\x86\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xEA\x6B"],
        ["\x86\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE5\xFE"],
        ["\x86\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x41"],
        ["\x86\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x42"],
        ["\x86\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x43"],
        ["\x86\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x44"],
        ["\x86\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x45"],
        ["\x86\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x46"],
        ["\x86\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x47"],
        ["\x86\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x48"],
        ["\x86\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE6\x49"],
        ["\x86\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xFB"],
        ["\x86\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xFC"],
        ["\x86\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xFD"],
        ["\x86\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xFE"],
        ["\x86\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x41"],
        ["\x86\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x42"],
        ["\x86\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x43"],
        ["\x86\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x44"],
        ["\x86\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x45"],
        ["\x86\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE3\x46"],
        ["\x86\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x48"],
        ["\x86\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x49"],
        ["\x86\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE0"],
        ["\x86\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE1"],
        ["\x86\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE2"],
        ["\x86\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE3"],
        ["\x86\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE4"],
        ["\x86\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE5"],
        ["\x86\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE6"],
        ["\x86\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE7"],
        ["\x86\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE8"],
        ["\x86\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xE9"],
        ["\x86\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xEA"],
        ["\x86\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xEB"],
        ["\x86\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xEC"],
        ["\x86\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xED"],
        ["\x86\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xEE"],
        ["\x86\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xEF"],
        ["\x86\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF0"],
        ["\x86\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF1"],
        ["\x86\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF2"],
        ["\x86\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF3"],
        ["\x86\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF4"],
        ["\x86\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF5"],
        ["\x86\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF6"],
        ["\x86\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF7"],
        ["\x86\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF8"],
        ["\x86\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE2\xF9"],
        ["\x86\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x80"],
        ["\x86\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x81"],
        ["\x86\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x82"],
        ["\x86\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x83"],
        ["\x86\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x84"],
        ["\x86\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x85"],
        ["\x86\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x86"],
        ["\x86\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x87"],
        ["\x86\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x88"],
        ["\x86\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x89"],
        ["\x86\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x8A"],
        ["\x86\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x8B"],
        ["\x86\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x8C"],
        ["\x86\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x8D"],
        ["\x86\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x8E"],
        ["\x86\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x8F"],
        ["\x86\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x90"],
        ["\x86\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x91"],
        ["\x86\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x92"],
        ["\x86\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x93"],
        ["\x86\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\xAA"],
        ["\x86\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x99"],
        ["\x86\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x95"],
        ["\x86\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x9D"],
        ["\x86\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE7\x9C"],
        ["\x86\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xDD"],
        ["\x86\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDD\xD5"],
        ["\x87\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x42"],
        ["\x87\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xDF\x43"],
        ["\x87\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE5\xEF"],
        ["\x87\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xE4\x7E"],
        ["\x87\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x56"],
        ["\x87\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x42"],
        ["\x87\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x43"],
        ["\x87\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x4B"],
        ["\x87\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x4C"],
        ["\x87\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x5C"],
        ["\x87\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x6D"],
        ["\x87\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x6F"],
        ["\x87\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x72"],
        ["\x87\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x8A"],
        ["\x87\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x82"],
        ["\x87\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x83"],
        ["\x87\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x89"],
        ["\x87\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x8C"],
        ["\x87\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x8D"],
        ["\x87\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x95"],
        ["\x87\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x9F"],
        ["\x87\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x54"],
        ["\x87\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xB4"],
        ["\x87\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xBB"],
        ["\x87\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x57"],
        ["\x87\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC0"],
        ["\x87\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC4"],
        ["\x87\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC8"],
        ["\x87\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC9"],
        ["\x87\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xCE"],
        ["\x87\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xCF"],
        ["\x87\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xFE"],
        ["\x87\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x4F"],
        ["\x87\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x42"],
        ["\x87\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x4A"],
        ["\x87\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x63"],
        ["\x87\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x54"],
        ["\x87\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x53"],
        ["\x87\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x57"],
        ["\x87\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x61"],
        ["\x87\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x6B"],
        ["\x87\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x69"],
        ["\x87\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x71"],
        ["\x87\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x72"],
        ["\x87\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x6C"],
        ["\x87\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x71"],
        ["\x87\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x72"],
        ["\x87\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x8B"],
        ["\x87\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x8C"],
        ["\x87\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x8E"],
        ["\x87\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x93"],
        ["\x87\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x74"],
        ["\x87\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x97"],
        ["\x87\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xA1"],
        ["\x87\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xA3"],
        ["\x87\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xA9"],
        ["\x87\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xB4"],
        ["\x87\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xC6"],
        ["\x87\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x7B"],
        ["\x87\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xC7"],
        ["\x87\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x7E"],
        ["\x87\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xCB"],
        ["\x87\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x7F"],
        ["\x87\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xD3"],
        ["\x87\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x81"],
        ["\x87\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xE0"],
        ["\x87\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x83"],
        ["\x87\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xF5"],
        ["\x87\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xF6"],
        ["\x87\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x87"],
        ["\x87\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x44"],
        ["\x87\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x8F"],
        ["\x87\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x60"],
        ["\x87\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x6A"],
        ["\x87\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x72"],
        ["\x87\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x75"],
        ["\x87\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x76"],
        ["\x87\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x7A"],
        ["\x87\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x7F"],
        ["\x87\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x81"],
        ["\x88\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x8D"],
        ["\x88\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x9F"],
        ["\x88\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xA2"],
        ["\x88\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xA4"],
        ["\x88\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xAE"],
        ["\x88\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xB3"],
        ["\x88\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xB9"],
        ["\x88\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xBC"],
        ["\x88\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x9E"],
        ["\x88\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xC5"],
        ["\x88\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xCE"],
        ["\x88\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA5"],
        ["\x88\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xDB"],
        ["\x88\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xDE"],
        ["\x88\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xEA"],
        ["\x88\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xF3"],
        ["\x88\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xAD"],
        ["\x88\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xFD"],
        ["\x88\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xAC"],
        ["\x88\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x42"],
        ["\x88\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x43"],
        ["\x88\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x44"],
        ["\x88\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x4C"],
        ["\x88\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x4F"],
        ["\x88\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x54"],
        ["\x88\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x56"],
        ["\x88\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x59"],
        ["\x88\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x5D"],
        ["\x88\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x5E"],
        ["\x88\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x76"],
        ["\x88\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB1"],
        ["\x88\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB2"],
        ["\x88\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x86"],
        ["\x88\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x87"],
        ["\x88\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x88"],
        ["\x88\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x98"],
        ["\x88\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x9D"],
        ["\x88\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xA1"],
        ["\x88\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xAB"],
        ["\x88\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xBA"],
        ["\x88\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xB3"],
        ["\x88\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xB6"],
        ["\x88\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xBB"],
        ["\x88\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xBF"],
        ["\x88\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC1"],
        ["\x88\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC2"],
        ["\x88\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC6"],
        ["\x88\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xCA"],
        ["\x88\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xDE"],
        ["\x88\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xDF"],
        ["\x88\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xBF"],
        ["\x88\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xE3"],
        ["\x88\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xE9"],
        ["\x88\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC2"],
        ["\x88\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xF6"],
        ["\x88\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC6"],
        ["\x88\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x41"],
        ["\x88\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xFD"],
        ["\x88\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x42"],
        ["\x88\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x44"],
        ["\x88\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC7"],
        ["\x88\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x48"],
        ["\x88\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x4C"],
        ["\x88\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xE3"],
        ["\x88\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x63"],
        ["\x88\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x6B"],
        ["\x88\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x6E"],
        ["\x88\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x7B"],
        ["\x88\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x80"],
        ["\x88\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x81"],
        ["\x88\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x93"],
        ["\x88\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x95"],
        ["\x88\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xA6"],
        ["\x88\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xA7"],
        ["\x88\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xA8"],
        ["\x88\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xAB"],
        ["\x88\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD7"],
        ["\x88\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB2"],
        ["\x88\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB6"],
        ["\x88\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xC0"],
        ["\x88\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD9"],
        ["\x88\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xD1"],
        ["\x88\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xD5"],
        ["\x88\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x75"],
        ["\x98\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x8D"],
        ["\x98\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xD9"],
        ["\x98\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xE2"],
        ["\x98\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xEC"],
        ["\x98\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE2"],
        ["\x98\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x4A"],
        ["\x98\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x4D"],
        ["\x98\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE3"],
        ["\x98\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x57"],
        ["\x98\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE7"],
        ["\x98\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE8"],
        ["\x98\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD1"],
        ["\x98\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x60"],
        ["\x98\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x67"],
        ["\x98\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x6A"],
        ["\x98\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x6D"],
        ["\x98\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x6E"],
        ["\x98\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x73"],
        ["\x98\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF3"],
        ["\x98\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x74"],
        ["\x98\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x7A"],
        ["\x98\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xFA"],
        ["\x98\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xFB"],
        ["\x98\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x7D"],
        ["\x98\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x89"],
        ["\x98\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xFC"],
        ["\x98\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x8B"],
        ["\x98\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x9A"],
        ["\x98\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xA5"],
        ["\x98\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x45"],
        ["\x98\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xA6"],
        ["\x98\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xAD"],
        ["\x98\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x90"],
        ["\x9C\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\x59\xCD"],
        ["\xEA\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xAB"],
        ["\xEA\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x4A"],
        ["\xEA\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xBA"],
        ["\xEA\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xBC"],
        ["\xEA\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xC9"],
        ["\xEA\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xCC"],
        ["\xEA\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xE0"],
        ["\xEA\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x54"],
        ["\xEA\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xE3"],
        ["\xEA\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x57"],
        ["\xEA\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x59"],
        ["\xEA\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xEE"],
        ["\xEA\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xF0"],
        ["\xEA\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xF5"],
        ["\xEA\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xF7"],
        ["\xEA\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xFE"],
        ["\xEA\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x42"],
        ["\xEA\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x44"],
        ["\xEA\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x49"],
        ["\xEA\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x4A"],
        ["\xEA\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x4E"],
        ["\xEA\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x55"],
        ["\xEA\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x57"],
        ["\xEA\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x5B"],
        ["\xEA\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x5F"],
        ["\xEA\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x62"],
        ["\xEA\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x5C"],
        ["\xEA\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x69"],
        ["\xEA\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x70"],
        ["\xEA\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x73"],
        ["\xEA\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x80"],
        ["\xEA\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x82"],
        ["\xEA\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x84"],
        ["\xEA\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x89"],
        ["\xEA\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x8A"],
        ["\xEA\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x8C"],
        ["\xEA\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x61"],
        ["\xEA\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xA1"],
        ["\xEA\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xA2"],
        ["\xEA\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xB1"],
        ["\xEA\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xB4"],
        ["\xEA\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xB7"],
        ["\xEA\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xBB"],
        ["\xEA\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xC9"],
        ["\xEA\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xCD"],
        ["\xEA\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x66"],
        ["\xEA\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xE3"],
        ["\xEA\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x67"],
        ["\xEA\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xF1"],
        ["\xEA\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xF0"],
        ["\xEA\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x6A"],
        ["\xEA\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x4D"],
        ["\xEA\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x6D"],
        ["\xEA\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x55"],
        ["\xEA\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x5D"],
        ["\xEA\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x5E"],
        ["\xEA\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x62"],
        ["\xEA\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x70"],
        ["\xEA\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x71"],
        ["\xEA\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x74"],
        ["\xEA\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x79"],
        ["\xEA\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x7D"],
        ["\xEA\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x83"],
        ["\xEA\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x89"],
        ["\xEA\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x8D"],
        ["\xEA\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x98"],
        ["\xEA\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xA0"],
        ["\xEA\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xBD"],
        ["\xEA\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x7B"],
        ["\xEA\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xC6"],
        ["\xEA\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xC8"],
        ["\xEA\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xCC"],
        ["\xEA\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x7F"],
        ["\xEA\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xD8"],
        ["\xEA\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xE3"],
        ["\xEA\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xF8"],
        ["\xEA\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xF9"],
        ["\xEB\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xFA"],
        ["\xEB\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xFC"],
        ["\xEB\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x41"],
        ["\xEB\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x4C"],
        ["\xEB\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x4D"],
        ["\xEB\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x5C"],
        ["\xEB\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x5E"],
        ["\xEB\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x85"],
        ["\xEB\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x6C"],
        ["\xEB\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x76"],
        ["\xEB\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x89"],
        ["\xEB\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x8D"],
        ["\xEB\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x97"],
        ["\xEB\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x9C"],
        ["\xEB\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x9E"],
        ["\xEB\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x9F"],
        ["\xEB\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x8E"],
        ["\xEB\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xA6"],
        ["\xEB\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x94"],
        ["\xEB\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x90"],
        ["\xEB\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xAD"],
        ["\xEB\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xB2"],
        ["\xEB\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xB3"],
        ["\xEB\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xBC"],
        ["\xEB\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x97"],
        ["\xEB\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xC7"],
        ["\xEB\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x9B"],
        ["\xEB\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xCB"],
        ["\xEB\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x9C"],
        ["\xEB\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xD0"],
        ["\xEB\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xD2"],
        ["\xEB\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xD8"],
        ["\xEB\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xDD"],
        ["\xEB\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE0"],
        ["\xEB\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE1"],
        ["\xEB\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xEA"],
        ["\xEB\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xEB"],
        ["\xEB\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xF0"],
        ["\xEB\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xF2"],
        ["\xEB\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xF4"],
        ["\xEB\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x4C"],
        ["\xEB\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x43"],
        ["\xEB\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xAB"],
        ["\xEB\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x4F"],
        ["\xEB\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x53"],
        ["\xEB\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x57"],
        ["\xEB\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x61"],
        ["\xEB\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x67"],
        ["\xEB\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x68"],
        ["\xEB\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB3"],
        ["\xEB\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x76"],
        ["\xEB\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x77"],
        ["\xEB\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x7B"],
        ["\xEB\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x7F"],
        ["\xEB\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x87"],
        ["\xEB\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x8B"],
        ["\xEB\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x8C"],
        ["\xEB\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x8D"],
        ["\xEB\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x91"],
        ["\xEB\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x95"],
        ["\xEB\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xA2"],
        ["\xEB\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xCB"],
        ["\xEB\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x9D"],
        ["\xEB\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xA0"],
        ["\xEB\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xA4"],
        ["\xEB\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xA6"],
        ["\xEB\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xA7"],
        ["\xEB\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xB2"],
        ["\xEB\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xB7"],
        ["\xEB\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xBB"],
        ["\xEB\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC9"],
        ["\xEB\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xCA"],
        ["\xEB\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD1"],
        ["\xEB\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xCD"],
        ["\xEB\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xCE"],
        ["\xEB\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xCB"],
        ["\xEB\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD0"],
        ["\xEB\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD0"],
        ["\xEB\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD2"],
        ["\xEB\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xDE"],
        ["\xEB\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xDB"],
        ["\xEB\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xDC"],
        ["\xEB\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xDE"],
        ["\xEB\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xE2"],
        ["\xEB\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xE6"],
        ["\xEB\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xE7"],
        ["\xEB\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xDF"],
        ["\xEB\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF0"],
        ["\xEB\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xDA"],
        ["\xEB\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF4"],
        ["\xEB\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF5"],
        ["\xEB\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF7"],
        ["\xEB\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x4C"],
        ["\xEB\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE2"],
        ["\xEB\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE4"],
        ["\xEB\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x5C"],
        ["\xEB\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x5D"],
        ["\xEB\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x61"],
        ["\xEB\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x63"],
        ["\xEB\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x67"],
        ["\xEB\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x6B"],
        ["\xEB\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x6E"],
        ["\xEB\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xEA"],
        ["\xEB\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x6F"],
        ["\xEB\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xEC"],
        ["\xEB\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x76"],
        ["\xEB\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x7F"],
        ["\xEB\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x81"],
        ["\xEB\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xEF"],
        ["\xEB\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF3"],
        ["\xEB\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF4"],
        ["\xEB\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x95"],
        ["\xEB\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x98"],
        ["\xEB\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x9C"],
        ["\xEB\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xA5"],
        ["\xEB\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xB0"],
        ["\xEB\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF9"],
        ["\xEB\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xB5"],
        ["\xEB\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xB6"],
        ["\xEB\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xBA"],
        ["\xEB\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xC0"],
        ["\xEB\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xC1"],
        ["\xEB\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xFD"],
        ["\xEB\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xC7"],
        ["\xEB\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xCD"],
        ["\xEB\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xD0"],
        ["\xEB\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xD3"],
        ["\xEB\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xD5"],
        ["\xEB\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x43"],
        ["\xEB\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xDA"],
        ["\xEB\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE2"],
        ["\xEB\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE4"],
        ["\xEB\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE5"],
        ["\xEB\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE7"],
        ["\xEB\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x46"],
        ["\xEB\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xEC"],
        ["\xEB\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x49"],
        ["\xEB\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xF0"],
        ["\xEB\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x4C"],
        ["\xEB\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xF3"],
        ["\xEB\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xF6"],
        ["\xEB\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xFB"],
        ["\xEB\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xFC"],
        ["\xEB\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x42"],
        ["\xEB\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x54"],
        ["\xEB\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x43"],
        ["\xEB\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x44"],
        ["\xEB\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x59"],
        ["\xEB\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x5B"],
        ["\xEB\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x55"],
        ["\xEB\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x61"],
        ["\xEB\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x5E"],
        ["\xEB\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x6F"],
        ["\xEB\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x73"],
        ["\xEC\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x75"],
        ["\xEC\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x79"],
        ["\xEC\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x61"],
        ["\xEC\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x88"],
        ["\xEC\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x62"],
        ["\xEC\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x8C"],
        ["\xEC\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x8E"],
        ["\xEC\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x90"],
        ["\xEC\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x95"],
        ["\xEC\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x99"],
        ["\xEC\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x9C"],
        ["\xEC\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x9D"],
        ["\xEC\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x9E"],
        ["\xEC\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xA2"],
        ["\xEC\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xA6"],
        ["\xEC\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xA7"],
        ["\xEC\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xAB"],
        ["\xEC\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xAF"],
        ["\xEC\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xB2"],
        ["\xEC\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xB7"],
        ["\xEC\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xB8"],
        ["\xEC\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xBA"],
        ["\xEC\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xBC"],
        ["\xEC\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xC2"],
        ["\xEC\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xC1"],
        ["\xEC\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xC6"],
        ["\xEC\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xD4"],
        ["\xEC\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xD9"],
        ["\xEC\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xDA"],
        ["\xEC\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xD6"],
        ["\xEC\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xDB"],
        ["\xEC\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xDF"],
        ["\xEC\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xEA"],
        ["\xEC\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xEE"],
        ["\xEC\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF2"],
        ["\xEC\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF5"],
        ["\xEC\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF7"],
        ["\xEC\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x43"],
        ["\xEC\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x41"],
        ["\xEC\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x42"],
        ["\xEC\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x78"],
        ["\xEC\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x46"],
        ["\xEC\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x79"],
        ["\xEC\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x7C"],
        ["\xEC\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x4E"],
        ["\xEC\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x52"],
        ["\xEC\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x53"],
        ["\xEC\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x56"],
        ["\xEC\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x57"],
        ["\xEC\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x59"],
        ["\xEC\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x62"],
        ["\xEC\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x65"],
        ["\xEC\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x6E"],
        ["\xEC\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x81"],
        ["\xEC\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x85"],
        ["\xEC\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x86"],
        ["\xEC\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x85"],
        ["\xEC\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x98"],
        ["\xEC\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x9B"],
        ["\xEC\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x88"],
        ["\xEC\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xAC"],
        ["\xEC\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x8E"],
        ["\xEC\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xBA"],
        ["\xEC\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xBB"],
        ["\xEC\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xC5"],
        ["\xEC\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xCD"],
        ["\xEC\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD6"],
        ["\xEC\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xDF"],
        ["\xEC\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE4"],
        ["\xEC\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE5"],
        ["\xEC\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE6"],
        ["\xEC\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE8"],
        ["\xEC\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xEA"],
        ["\xEC\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xF5"],
        ["\xEC\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xF7"],
        ["\xEC\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xFC"],
        ["\xEC\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x49"],
        ["\xEC\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x4B"],
        ["\xEC\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x4C"],
        ["\xEC\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x96"],
        ["\xEC\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x4E"],
        ["\xEC\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x4F"],
        ["\xEC\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x50"],
        ["\xEC\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x52"],
        ["\xEC\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x53"],
        ["\xEC\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x58"],
        ["\xEC\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x59"],
        ["\xEC\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x5A"],
        ["\xEC\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x5B"],
        ["\xEC\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x5F"],
        ["\xEC\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x64"],
        ["\xEC\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x65"],
        ["\xEC\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x6C"],
        ["\xEC\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x6D"],
        ["\xEC\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x72"],
        ["\xEC\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x75"],
        ["\xEC\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x78"],
        ["\xEC\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x6F"],
        ["\xEC\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x79"],
        ["\xEC\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x7A"],
        ["\xEC\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x7B"],
        ["\xEC\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x82"],
        ["\xEC\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x85"],
        ["\xEC\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x86"],
        ["\xEC\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x87"],
        ["\xEC\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x8C"],
        ["\xEC\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x99"],
        ["\xEC\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x9D"],
        ["\xEC\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xB5"],
        ["\xEC\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xBE"],
        ["\xEC\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA6"],
        ["\xEC\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xCD"],
        ["\xEC\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD4"],
        ["\xEC\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xDB"],
        ["\xEC\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xDC"],
        ["\xEC\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE0"],
        ["\xEC\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE6"],
        ["\xEC\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE7"],
        ["\xEC\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE8"],
        ["\xEC\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xEC"],
        ["\xEC\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xF1"],
        ["\xEC\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xF4"],
        ["\xEC\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xFB"],
        ["\xEC\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x42"],
        ["\xEC\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x46"],
        ["\xEC\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x47"],
        ["\xEC\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x48"],
        ["\xEC\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x4A"],
        ["\xEC\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x4B"],
        ["\xEC\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x4D"],
        ["\xEC\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x52"],
        ["\xEC\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x5B"],
        ["\xEC\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB8"],
        ["\xEC\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x5F"],
        ["\xEC\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x62"],
        ["\xEC\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x63"],
        ["\xEC\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x64"],
        ["\xEC\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x67"],
        ["\xEC\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x6B"],
        ["\xEC\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x6E"],
        ["\xEC\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x71"],
        ["\xEC\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x77"],
        ["\xEC\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x7F"],
        ["\xEC\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x81"],
        ["\xEC\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x88"],
        ["\xEC\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x89"],
        ["\xEC\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x8E"],
        ["\xEC\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x90"],
        ["\xEC\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x92"],
        ["\xEC\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x9B"],
        ["\xEC\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x9D"],
        ["\xEC\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xA1"],
        ["\xEC\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xA8"],
        ["\xEC\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xB6"],
        ["\xEC\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xC9"],
        ["\xEC\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xCD"],
        ["\xED\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xCE"],
        ["\xED\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xCB"],
        ["\xED\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xCC"],
        ["\xED\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xD9"],
        ["\xED\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xDB"],
        ["\xED\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xCE"],
        ["\xED\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xE9"],
        ["\xED\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD0"],
        ["\xED\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xE8"],
        ["\xED\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xFD"],
        ["\xED\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x42"],
        ["\xED\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x49"],
        ["\xED\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x45"],
        ["\xED\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x4E"],
        ["\xED\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD5"],
        ["\xED\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x56"],
        ["\xED\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x57"],
        ["\xED\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD6"],
        ["\xED\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD8"],
        ["\xED\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x5D"],
        ["\xED\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x5E"],
        ["\xED\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD7"],
        ["\xED\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD9"],
        ["\xED\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xDA"],
        ["\xED\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x66"],
        ["\xED\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xDB"],
        ["\xED\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x6B"],
        ["\xED\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xDD"],
        ["\xED\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xDE"],
        ["\xED\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x75"],
        ["\xED\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x7C"],
        ["\xED\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x7E"],
        ["\xED\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x83"],
        ["\xED\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x84"],
        ["\xED\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE1"],
        ["\xED\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x86"],
        ["\xED\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x8A"],
        ["\xED\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x8F"],
        ["\xED\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x90"],
        ["\xED\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x95"],
        ["\xED\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE7"],
        ["\xED\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xA7"],
        ["\xED\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB2"],
        ["\xED\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB8"],
        ["\xED\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE8"],
        ["\xED\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xBE"],
        ["\xED\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xC6"],
        ["\xED\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE9"],
        ["\xED\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xC9"],
        ["\xED\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xCC"],
        ["\xED\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xD1"],
        ["\xED\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xD9"],
        ["\xED\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF1"],
        ["\xED\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xE3"],
        ["\xED\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF3"],
        ["\xED\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xED"],
        ["\xED\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xEE"],
        ["\xED\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF0"],
        ["\xED\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF5"],
        ["\xED\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF6"],
        ["\xED\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF7"],
        ["\xED\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xFB"],
        ["\xED\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x55"],
        ["\xED\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x56"],
        ["\xED\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x63"],
        ["\xED\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x74"],
        ["\xED\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x41"],
        ["\xED\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x6F"],
        ["\xED\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x75"],
        ["\xED\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x77"],
        ["\xED\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x42"],
        ["\xED\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x44"],
        ["\xED\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x80"],
        ["\xED\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x8A"],
        ["\xED\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x8E"],
        ["\xED\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x93"],
        ["\xED\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x94"],
        ["\xED\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x96"],
        ["\xED\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x9D"],
        ["\xED\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xA7"],
        ["\xED\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xA9"],
        ["\xED\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xAB"],
        ["\xED\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB1"],
        ["\xED\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB2"],
        ["\xED\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB7"],
        ["\xED\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB9"],
        ["\xED\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xBB"],
        ["\xED\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xBF"],
        ["\xED\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xC4"],
        ["\xED\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xC8"],
        ["\xED\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xD2"],
        ["\xED\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xD7"],
        ["\xED\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xDB"],
        ["\xED\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE3"],
        ["\xED\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE9"],
        ["\xED\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xEE"],
        ["\xED\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x5A"],
        ["\xED\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x5B"],
        ["\xED\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x4A"],
        ["\xED\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x41"],
        ["\xED\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x43"],
        ["\xED\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x44"],
        ["\xED\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x5F"],
        ["\xED\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x53"],
        ["\xED\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x58"],
        ["\xED\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x64"],
        ["\xED\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x65"],
        ["\xED\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x87"],
        ["\xED\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x89"],
        ["\xED\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x91"],
        ["\xED\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x95"],
        ["\xED\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x97"],
        ["\xED\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x98"],
        ["\xED\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x9C"],
        ["\xED\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x9D"],
        ["\xED\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xA0"],
        ["\xED\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x6A"],
        ["\xED\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xAC"],
        ["\xED\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xB3"],
        ["\xED\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xB8"],
        ["\xED\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xB9"],
        ["\xED\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xBC"],
        ["\xED\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x70"],
        ["\xED\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xD6"],
        ["\xED\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xD8"],
        ["\xED\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xDD"],
        ["\xED\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xE6"],
        ["\xED\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xF3"],
        ["\xED\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xF7"],
        ["\xED\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xF9"],
        ["\xED\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xFA"],
        ["\xED\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xFC"],
        ["\xED\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x50"],
        ["\xED\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x53"],
        ["\xED\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x56"],
        ["\xED\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x58"],
        ["\xED\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x83"],
        ["\xED\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x84"],
        ["\xED\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x88"],
        ["\xED\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x81"],
        ["\xED\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x85"],
        ["\xED\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x97"],
        ["\xED\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x90"],
        ["\xED\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x98"],
        ["\xED\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x99"],
        ["\xED\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x9A"],
        ["\xED\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x9D"],
        ["\xED\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x9F"],
        ["\xED\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA3"],
        ["\xED\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA6"],
        ["\xED\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA7"],
        ["\xED\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA8"],
        ["\xED\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xAA"],
        ["\xED\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xB5"],
        ["\xED\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xB6"],
        ["\xED\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xB7"],
        ["\xED\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xC1"],
        ["\xED\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xC3"],
        ["\xED\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xC8"],
        ["\xED\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xCC"],
        ["\xED\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xCE"],
        ["\xED\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xD1"],
        ["\xED\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xD4"],
        ["\xED\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xD9"],
        ["\xED\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xDD"],
        ["\xED\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xDF"],
        ["\xED\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE2"],
        ["\xED\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE8"],
        ["\xED\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE9"],
        ["\xED\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xED"],
        ["\xED\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xEE"],
        ["\xED\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF0"],
        ["\xEE\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF2"],
        ["\xEE\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x9F"],
        ["\xEE\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF6"],
        ["\xEE\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xFA"],
        ["\xEE\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xFB"],
        ["\xEE\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xFC"],
        ["\xEE\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA3"],
        ["\xEE\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA5"],
        ["\xEE\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x56"],
        ["\xEE\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x57"],
        ["\xEE\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x5E"],
        ["\xEE\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x62"],
        ["\xEE\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x67"],
        ["\xEE\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x69"],
        ["\xEE\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x6C"],
        ["\xEE\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x6D"],
        ["\xEE\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xAB"],
        ["\xEE\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x8D"],
        ["\xEE\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x84"],
        ["\xEE\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x86"],
        ["\xEE\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x8C"],
        ["\xEE\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x9F"],
        ["\xEE\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xB5"],
        ["\xEE\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA2"],
        ["\xEE\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xAB"],
        ["\xEE\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xAC"],
        ["\xEE\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xB2"],
        ["\xEE\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC1"],
        ["\xEE\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC2"],
        ["\xEE\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC9"],
        ["\xEE\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xD5"],
        ["\xEE\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xCD"],
        ["\xEE\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xCF"],
        ["\xEE\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xD0"],
        ["\xEE\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xD3"],
        ["\xEE\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB7"],
        ["\xEE\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xD6"],
        ["\xEE\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xDC"],
        ["\xEE\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xDE"],
        ["\xEE\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xE9"],
        ["\xEE\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xBB"],
        ["\xEE\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xBC"],
        ["\xEE\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xEF"],
        ["\xEE\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xBD"],
        ["\xEE\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xF3"],
        ["\xEE\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xF5"],
        ["\xEE\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xFD"],
        ["\xEE\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x4C"],
        ["\xEE\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x5D"],
        ["\xEE\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x5E"],
        ["\xEE\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x5F"],
        ["\xEE\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x63"],
        ["\xEE\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x82"],
        ["\xEE\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x89"],
        ["\xEE\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x8A"],
        ["\xEE\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x98"],
        ["\xEE\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x99"],
        ["\xEE\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x9C"],
        ["\xEE\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xCA"],
        ["\xEE\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xA5"],
        ["\xEE\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xCE"],
        ["\xEE\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xB7"],
        ["\xEE\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xB9"],
        ["\xEE\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xBB"],
        ["\xEE\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xBE"],
        ["\xEE\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xC5"],
        ["\xEE\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xE4"],
        ["\xEE\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xEB"],
        ["\xEE\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xF0"],
        ["\xEE\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xF4"],
        ["\xEE\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD6"],
        ["\xEE\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD9"],
        ["\xEE\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x48"],
        ["\xEE\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x49"],
        ["\xEE\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x4A"],
        ["\xEE\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x4D"],
        ["\xEE\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x4F"],
        ["\xEE\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x51"],
        ["\xEE\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x53"],
        ["\xEE\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x56"],
        ["\xEE\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x70"],
        ["\xEE\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE0"],
        ["\xEE\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x7D"],
        ["\xEE\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x82"],
        ["\xEE\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x88"],
        ["\xEE\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x92"],
        ["\xEE\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x95"],
        ["\xEE\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xA1"],
        ["\xEE\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xA4"],
        ["\xEE\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xAA"],
        ["\xEE\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xAB"],
        ["\xEE\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xAE"],
        ["\xEE\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE5"],
        ["\xEE\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xD4"],
        ["\xEE\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE6"],
        ["\xEE\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE9"],
        ["\xEE\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xE8"],
        ["\xEE\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xEC"],
        ["\xEE\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xED"],
        ["\xEE\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xEC"],
        ["\xEE\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xED"],
        ["\xEE\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x49"],
        ["\xEE\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x57"],
        ["\xEE\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF3"],
        ["\xEE\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x74"],
        ["\xEE\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x7B"],
        ["\xEE\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x7C"],
        ["\xEE\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF6"],
        ["\xEE\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x82"],
        ["\xEE\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x95"],
        ["\xEE\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xA2"],
        ["\xEE\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xA3"],
        ["\xEE\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xA6"],
        ["\xEE\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xB9"],
        ["\xEE\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xBC"],
        ["\xEE\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xC5"],
        ["\xEE\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xD7"],
        ["\xEE\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xDB"],
        ["\xEE\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x43"],
        ["\xEE\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xEF"],
        ["\xEE\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x45"],
        ["\xEE\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xFE"],
        ["\xEE\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x4A"],
        ["\xEE\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x52"],
        ["\xEE\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x56"],
        ["\xEE\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x61"],
        ["\xEE\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x4A"],
        ["\xEE\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x6C"],
        ["\xEE\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x6D"],
        ["\xEE\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x7D"],
        ["\xEE\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x7E"],
        ["\xEE\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x7F"],
        ["\xEE\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x87"],
        ["\xEE\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x8F"],
        ["\xEE\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x4F"],
        ["\xEE\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xA1"],
        ["\xEE\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xA6"],
        ["\xEE\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xA7"],
        ["\xEE\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xA9"],
        ["\xEE\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xAA"],
        ["\xEE\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xAD"],
        ["\xEE\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xB1"],
        ["\xEE\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xB5"],
        ["\xEE\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xB7"],
        ["\xEE\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xB8"],
        ["\xEE\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xB9"],
        ["\xEE\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xBE"],
        ["\xEE\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xC2"],
        ["\xEE\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xC6"],
        ["\xEE\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xC8"],
        ["\xEE\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xD3"],
        ["\xEE\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xD4"],
        ["\xEE\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xDB"],
        ["\xEE\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xDC"],
        ["\xEE\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xE0"],
        ["\xEE\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xE1"],
        ["\xEE\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xE2"],
        ["\xEE\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xE8"],
        ["\xEE\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xEB"],
        ["\xEE\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xF1"],
        ["\xEE\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xFB"],
        ["\xEE\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x47"],
        ["\xEE\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x4B"],
        ["\xEE\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x4F"],
        ["\xEE\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x54"],
        ["\xEE\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x65"],
        ["\xEF\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x62"],
        ["\xEF\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x6B"],
        ["\xEF\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x7F"],
        ["\xEF\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x82"],
        ["\xEF\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x87"],
        ["\xEF\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xB2"],
        ["\xEF\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xB8"],
        ["\xEF\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xB9"],
        ["\xEF\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x63"],
        ["\xEF\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xCE"],
        ["\xEF\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xD8"],
        ["\xEF\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x66"],
        ["\xEF\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xE0"],
        ["\xEF\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xE1"],
        ["\xEF\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xE4"],
        ["\xEF\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xF9"],
        ["\xEF\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xFC"],
        ["\xEF\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x46"],
        ["\xEF\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x53"],
        ["\xEF\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x5E"],
        ["\xEF\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x5B"],
        ["\xEF\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x6B"],
        ["\xEF\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x71"],
        ["\xEF\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x78"],
        ["\xEF\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x7A"],
        ["\xEF\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x7E"],
        ["\xEF\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x7F"],
        ["\xEF\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x89"],
        ["\xEF\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x8C"],
        ["\xEF\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x8E"],
        ["\xEF\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x8F"],
        ["\xEF\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x91"],
        ["\xEF\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x93"],
        ["\xEF\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x95"],
        ["\xEF\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x9A"],
        ["\xEF\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x9B"],
        ["\xEF\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x9E"],
        ["\xEF\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x75"],
        ["\xEF\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xA0"],
        ["\xEF\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xA2"],
        ["\xEF\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xBB"],
        ["\xEF\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xC6"],
        ["\xEF\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xCC"],
        ["\xEF\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xCD"],
        ["\xEF\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xD4"],
        ["\xEF\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xD8"],
        ["\xEF\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x82"],
        ["\xEF\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xDA"],
        ["\xEF\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xDB"],
        ["\xEF\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xEC"],
        ["\xEF\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xEF"],
        ["\xEF\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xF4"],
        ["\xEF\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xF5"],
        ["\xEF\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xFE"],
        ["\xEF\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x49"],
        ["\xEF\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x50"],
        ["\xEF\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x54"],
        ["\xEF\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x58"],
        ["\xEF\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x65"],
        ["\xEF\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x63"],
        ["\xEF\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x6B"],
        ["\xEF\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x89"],
        ["\xEF\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x70"],
        ["\xEF\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x77"],
        ["\xEF\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x7C"],
        ["\xEF\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x7F"],
        ["\xEF\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x8D"],
        ["\xEF\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x88"],
        ["\xEF\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x89"],
        ["\xEF\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x8A"],
        ["\xEF\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x8B"],
        ["\xEF\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x8C"],
        ["\xEF\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x8E"],
        ["\xEF\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x91"],
        ["\xEF\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x99"],
        ["\xEF\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x9E"],
        ["\xEF\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xA4"],
        ["\xEF\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xC7"],
        ["\xEF\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xEC"],
        ["\xEF\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xED"],
        ["\xEF\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xF8"],
        ["\xEF\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xFA"],
        ["\xEF\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xFB"],
        ["\xEF\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x41"],
        ["\xEF\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x45"],
        ["\xEF\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA1"],
        ["\xEF\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x53"],
        ["\xEF\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x58"],
        ["\xEF\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x59"],
        ["\xEF\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x5C"],
        ["\xEF\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x60"],
        ["\xEF\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x6C"],
        ["\xEF\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x72"],
        ["\xEF\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x76"],
        ["\xEF\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x82"],
        ["\xEF\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA9"],
        ["\xEF\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x85"],
        ["\xEF\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x94"],
        ["\xEF\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xA2"],
        ["\xEF\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x98"],
        ["\xEF\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xA5"],
        ["\xEF\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xAA"],
        ["\xEF\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xB1"],
        ["\xEF\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xB3"],
        ["\xEF\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xBD"],
        ["\xEF\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC0"],
        ["\xEF\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC6"],
        ["\xEF\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xCD"],
        ["\xEF\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xD0"],
        ["\xEF\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xDD"],
        ["\xEF\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xE8"],
        ["\xEF\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xEF"],
        ["\xEF\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF0"],
        ["\xEF\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF1"],
        ["\xEF\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xFA"],
        ["\xEF\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB6"],
        ["\xEF\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x45"],
        ["\xEF\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x51"],
        ["\xEF\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x52"],
        ["\xEF\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x5C"],
        ["\xEF\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x5E"],
        ["\xEF\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xBE"],
        ["\xEF\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x64"],
        ["\xEF\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x6B"],
        ["\xEF\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x70"],
        ["\xEF\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x76"],
        ["\xEF\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC4"],
        ["\xEF\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x7B"],
        ["\xEF\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x80"],
        ["\xEF\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x89"],
        ["\xEF\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC6"],
        ["\xEF\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x8F"],
        ["\xEF\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x98"],
        ["\xEF\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x9E"],
        ["\xEF\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xA4"],
        ["\xEF\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB0"],
        ["\xEF\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB1"],
        ["\xEF\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB3"],
        ["\xEF\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB5"],
        ["\xEF\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB8"],
        ["\xEF\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB9"],
        ["\xEF\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xCB"],
        ["\xEF\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xCE"],
        ["\xEF\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xE1"],
        ["\xEF\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xEF"],
        ["\xEF\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD5\x42"],
        ["\xEF\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD5\x45"],
        ["\xEF\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD5\x47"],
        ["\xEF\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD5\x4A"],
        ["\xEF\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD3"],
        ["\xEF\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE5"],
        ["\xEF\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x51"],
        ["\xEF\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xEF"],
        ["\xEF\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x5B"],
        ["\xF0\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x46"],
        ["\xF0\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x41"],
        ["\xF0\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x41"],
        ["\xF0\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x45"],
        ["\xF0\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x44"],
        ["\xF0\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x49"],
        ["\xF0\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x4A"],
        ["\xF0\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x4E"],
        ["\xF0\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x51"],
        ["\xF0\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x47"],
        ["\xF0\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x48"],
        ["\xF0\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x52"],
        ["\xF0\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x4A"],
        ["\xF0\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x49"],
        ["\xF0\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x53"],
        ["\xF0\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x57"],
        ["\xF0\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x5F"],
        ["\xF0\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x4B"],
        ["\xF0\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x4C"],
        ["\xF0\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x61"],
        ["\xF0\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x4D"],
        ["\xF0\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x4E"],
        ["\xF0\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x4F"],
        ["\xF0\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x62"],
        ["\xF0\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x50"],
        ["\xF0\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x63"],
        ["\xF0\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x51"],
        ["\xF0\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x64"],
        ["\xF0\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x6A"],
        ["\xF0\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x6C"],
        ["\xF0\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x76"],
        ["\xF0\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x52"],
        ["\xF0\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x7D"],
        ["\xF0\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x7F"],
        ["\xF0\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x87"],
        ["\xF0\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x88"],
        ["\xF0\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x53"],
        ["\xF0\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x90"],
        ["\xF0\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x91"],
        ["\xF0\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x93"],
        ["\xF0\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x94"],
        ["\xF0\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x97"],
        ["\xF0\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\x99"],
        ["\xF0\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x55"],
        ["\xF0\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xA3"],
        ["\xF0\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xA9"],
        ["\xF0\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xAC"],
        ["\xF0\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xAF"],
        ["\xF0\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xB1"],
        ["\xF0\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xB2"],
        ["\xF0\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x59"],
        ["\xF0\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xB7"],
        ["\xF0\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xBA"],
        ["\xF0\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC1"],
        ["\xF0\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC2"],
        ["\xF0\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xC6"],
        ["\xF0\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x58"],
        ["\xF0\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xD3"],
        ["\xF0\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xD6"],
        ["\xF0\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xD7"],
        ["\xF0\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xDC"],
        ["\xF0\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xDD"],
        ["\xF0\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xDF"],
        ["\xF0\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x5C"],
        ["\xF0\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x5A"],
        ["\xF0\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xEA"],
        ["\xF0\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xEB"],
        ["\xF0\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x5B"],
        ["\xF0\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xEC"],
        ["\xF0\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xEE"],
        ["\xF0\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xF4"],
        ["\xF0\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x5D"],
        ["\xF0\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x5E"],
        ["\xF0\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xF8"],
        ["\xF0\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x5F"],
        ["\xF0\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xFC"],
        ["\xF0\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB8\xFD"],
        ["\xF0\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x65"],
        ["\xF0\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x64"],
        ["\xF0\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x41"],
        ["\xF0\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x60"],
        ["\xF0\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x44"],
        ["\xF0\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x61"],
        ["\xF0\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x62"],
        ["\xF0\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x4C"],
        ["\xF0\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x66"],
        ["\xF0\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xEE"],
        ["\xF0\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xF1"],
        ["\xF0\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xDB"],
        ["\xF0\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xDD"],
        ["\xF0\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xDC"],
        ["\xF0\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xFC"],
        ["\xF0\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xDF"],
        ["\xF0\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xDE"],
        ["\xF0\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x44"],
        ["\xF0\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x46"],
        ["\xF0\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE0"],
        ["\xF0\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE1"],
        ["\xF0\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x4C"],
        ["\xF0\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x50"],
        ["\xF0\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE4"],
        ["\xF0\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE6"],
        ["\xF0\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x58"],
        ["\xF0\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x59"],
        ["\xF0\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x5A"],
        ["\xF0\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x5B"],
        ["\xF0\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x5D"],
        ["\xF0\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xE9"],
        ["\xF0\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xEA"],
        ["\xF0\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x62"],
        ["\xF0\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xEC"],
        ["\xF0\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xEB"],
        ["\xF0\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x65"],
        ["\xF0\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x66"],
        ["\xF0\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF1"],
        ["\xF0\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF2"],
        ["\xF0\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF0"],
        ["\xF0\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x6B"],
        ["\xF0\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x6C"],
        ["\xF0\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xED"],
        ["\xF0\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xEF"],
        ["\xF0\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xEE"],
        ["\xF0\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x71"],
        ["\xF0\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF4"],
        ["\xF0\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x72"],
        ["\xF0\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF5"],
        ["\xF0\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF9"],
        ["\xF0\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x7C"],
        ["\xF0\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF6"],
        ["\xF0\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x82"],
        ["\xF0\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF7"],
        ["\xF0\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xF8"],
        ["\xF0\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x80"],
        ["\xF0\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x81"],
        ["\xF0\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x83"],
        ["\xF0\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x85"],
        ["\xF0\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xFD"],
        ["\xF0\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x91"],
        ["\xF0\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x94"],
        ["\xF0\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xFE"],
        ["\xF0\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x95"],
        ["\xF0\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x44"],
        ["\xF0\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x41"],
        ["\xF0\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x9C"],
        ["\xF0\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x42"],
        ["\xF0\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\x9E"],
        ["\xF0\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xA0"],
        ["\xF0\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x43"],
        ["\xF0\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xA2"],
        ["\xF0\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xA8"],
        ["\xF0\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xA9"],
        ["\xF0\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xAA"],
        ["\xF0\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x46"],
        ["\xF0\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x47"],
        ["\xF0\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x48"],
        ["\xF0\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xAF"],
        ["\xF0\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xB1"],
        ["\xF0\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x49"],
        ["\xF0\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xB2"],
        ["\xF0\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xB3"],
        ["\xF0\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x4B"],
        ["\xF0\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xB6"],
        ["\xF0\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x4C"],
        ["\xF0\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xB9"],
        ["\xF0\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xBB"],
        ["\xF0\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x4D"],
        ["\xF0\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xBD"],
        ["\xF0\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xC0"],
        ["\xF0\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xC3"],
        ["\xF0\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xC4"],
        ["\xF0\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x4E"],
        ["\xF0\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xC8"],
        ["\xF0\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x4F"],
        ["\xF0\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xCF"],
        ["\xF0\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xD0"],
        ["\xF0\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xD1"],
        ["\xF1\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x56"],
        ["\xF1\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x67"],
        ["\xF1\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x5C"],
        ["\xF1\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x5E"],
        ["\xF1\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x68"],
        ["\xF1\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x6A"],
        ["\xF1\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x6B"],
        ["\xF1\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xCC"],
        ["\xF1\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x77"],
        ["\xF1\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x79"],
        ["\xF1\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x6D"],
        ["\xF1\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x7B"],
        ["\xF1\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x7D"],
        ["\xF1\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x7E"],
        ["\xF1\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x6F"],
        ["\xF1\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x81"],
        ["\xF1\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x70"],
        ["\xF1\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x73"],
        ["\xF1\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x90"],
        ["\xF1\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x91"],
        ["\xF1\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x94"],
        ["\xF1\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x96"],
        ["\xF1\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\x98"],
        ["\xF1\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x76"],
        ["\xF1\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xA2"],
        ["\xF1\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xA6"],
        ["\xF1\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x77"],
        ["\xF1\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xAC"],
        ["\xF1\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x78"],
        ["\xF1\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xB0"],
        ["\xF1\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x79"],
        ["\xF1\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xB8"],
        ["\xF1\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x7A"],
        ["\xF1\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xBA"],
        ["\xF1\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xC1"],
        ["\xF1\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xC2"],
        ["\xF1\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x7C"],
        ["\xF1\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x7D"],
        ["\xF1\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xC9"],
        ["\xF1\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x80"],
        ["\xF1\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xD7"],
        ["\xF1\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xD9"],
        ["\xF1\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xDA"],
        ["\xF1\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xEC"],
        ["\xF1\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xEF"],
        ["\xF1\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xF0"],
        ["\xF1\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x82"],
        ["\xF1\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x84"],
        ["\xF1\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x85"],
        ["\xF1\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB9\xF8"],
        ["\xF1\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x86"],
        ["\xF1\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x46"],
        ["\xF1\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x4A"],
        ["\xF1\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x88"],
        ["\xF1\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x4C"],
        ["\xF1\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x50"],
        ["\xF1\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x89"],
        ["\xF1\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x8A"],
        ["\xF1\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x8B"],
        ["\xF1\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x55"],
        ["\xF1\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x56"],
        ["\xF1\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x8C"],
        ["\xF1\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x8E"],
        ["\xF1\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x5B"],
        ["\xF1\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x93"],
        ["\xF1\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x91"],
        ["\xF1\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x61"],
        ["\xF1\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x92"],
        ["\xF1\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x67"],
        ["\xF1\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x6D"],
        ["\xF1\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x6F"],
        ["\xF1\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x94"],
        ["\xF1\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x7C"],
        ["\xF1\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x7E"],
        ["\xF1\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x95"],
        ["\xF1\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x82"],
        ["\xF1\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x85"],
        ["\xF1\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x86"],
        ["\xF1\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x88"],
        ["\xF1\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x8A"],
        ["\xF1\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x8C"],
        ["\xF1\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x96"],
        ["\xF1\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x9B"],
        ["\xF1\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x93"],
        ["\xF1\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x94"],
        ["\xF1\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x97"],
        ["\xF1\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x98"],
        ["\xF1\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x98"],
        ["\xF1\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x99"],
        ["\xF1\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\x9C"],
        ["\xF1\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xA7"],
        ["\xF1\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xA9"],
        ["\xF1\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x99"],
        ["\xF1\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xAA"],
        ["\xF1\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xAC"],
        ["\xF1\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x9A"],
        ["\xF1\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xB4"],
        ["\xF1\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xB5"],
        ["\xF1\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xB6"],
        ["\xF1\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x9F"],
        ["\xF1\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x9C"],
        ["\xF1\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xBA"],
        ["\xF1\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xBB"],
        ["\xF1\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xBE"],
        ["\xF1\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x9D"],
        ["\xF1\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xD0"],
        ["\xF1\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA4"],
        ["\xF1\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA3"],
        ["\xF1\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xC7"],
        ["\xF1\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xCB"],
        ["\xF1\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xCD"],
        ["\xF1\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xCF"],
        ["\xF1\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA0"],
        ["\xF1\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA1"],
        ["\xF1\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xD6"],
        ["\xF1\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA2"],
        ["\xF1\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xD7"],
        ["\xF1\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA7"],
        ["\xF1\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA8"],
        ["\xF1\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA6"],
        ["\xF1\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xE0"],
        ["\xF1\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xE5"],
        ["\xF1\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xE8"],
        ["\xF1\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xA9"],
        ["\xF1\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xEC"],
        ["\xF1\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xED"],
        ["\xF1\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xEE"],
        ["\xF1\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xAA"],
        ["\xF1\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xF8"],
        ["\xF1\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBA\xF9"],
        ["\xF1\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x41"],
        ["\xF1\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xAE"],
        ["\xF1\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x48"],
        ["\xF1\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x4A"],
        ["\xF1\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x4B"],
        ["\xF1\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x4D"],
        ["\xF1\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x4E"],
        ["\xF1\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x53"],
        ["\xF1\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x57"],
        ["\xF1\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xAF"],
        ["\xF1\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x5C"],
        ["\xF1\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x61"],
        ["\xF1\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x67"],
        ["\xF1\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x6D"],
        ["\xF1\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x71"],
        ["\xF1\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x72"],
        ["\xF1\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB0"],
        ["\xF1\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x79"],
        ["\xF1\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x7F"],
        ["\xF1\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB3"],
        ["\xF1\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x82"],
        ["\xF1\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB5"],
        ["\xF1\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x8C"],
        ["\xF1\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x8D"],
        ["\xF1\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x8E"],
        ["\xF1\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x8F"],
        ["\xF1\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB4"],
        ["\xF1\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x93"],
        ["\xF1\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x97"],
        ["\xF1\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x9A"],
        ["\xF1\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x9B"],
        ["\xF1\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\x9C"],
        ["\xF1\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xA0"],
        ["\xF1\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB7"],
        ["\xF1\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB6"],
        ["\xF1\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xAA"],
        ["\xF1\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xAC"],
        ["\xF1\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xAD"],
        ["\xF1\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xB1"],
        ["\xF1\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB9"],
        ["\xF1\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xB8"],
        ["\xF1\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xB5"],
        ["\xF1\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xBD"],
        ["\xF1\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xBE"],
        ["\xF1\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xB9"],
        ["\xF1\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xBC"],
        ["\xF1\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC0"],
        ["\xF1\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xBB"],
        ["\xF1\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC3"],
        ["\xF1\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xBC"],
        ["\xF1\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC4"],
        ["\xF1\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xC8"],
        ["\xF1\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xCE"],
        ["\xF2\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xD0"],
        ["\xF2\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xD2"],
        ["\xF2\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xD4"],
        ["\xF2\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xD5"],
        ["\xF2\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC0"],
        ["\xF2\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xD7"],
        ["\xF2\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xD8"],
        ["\xF2\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xE0"],
        ["\xF2\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xEA"],
        ["\xF2\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC1"],
        ["\xF2\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xEC"],
        ["\xF2\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xED"],
        ["\xF2\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xEE"],
        ["\xF2\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xEF"],
        ["\xF2\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xF1"],
        ["\xF2\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC3"],
        ["\xF2\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xF7"],
        ["\xF2\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC5"],
        ["\xF2\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC4"],
        ["\xF2\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBB\xFC"],
        ["\xF2\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x47"],
        ["\xF2\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x49"],
        ["\xF2\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC8"],
        ["\xF2\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x4A"],
        ["\xF2\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x4B"],
        ["\xF2\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xC9"],
        ["\xF2\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x4F"],
        ["\xF2\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x53"],
        ["\xF2\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xCA"],
        ["\xF2\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xCB"],
        ["\xF2\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xCD"],
        ["\xF2\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xCF"],
        ["\xF2\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x5C"],
        ["\xF2\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xCE"],
        ["\xF2\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x9E"],
        ["\xF2\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x60"],
        ["\xF2\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD0"],
        ["\xF2\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x66"],
        ["\xF2\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x67"],
        ["\xF2\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x6A"],
        ["\xF2\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x71"],
        ["\xF2\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x74"],
        ["\xF2\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x79"],
        ["\xF2\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x7D"],
        ["\xF2\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x7F"],
        ["\xF2\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x82"],
        ["\xF2\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x84"],
        ["\xF2\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x85"],
        ["\xF2\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x86"],
        ["\xF2\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x87"],
        ["\xF2\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD2"],
        ["\xF2\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD6"],
        ["\xF2\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD4"],
        ["\xF2\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x8F"],
        ["\xF2\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x90"],
        ["\xF2\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD5"],
        ["\xF2\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x97"],
        ["\xF2\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\x9A"],
        ["\xF2\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xA2"],
        ["\xF2\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xA5"],
        ["\xF2\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xA9"],
        ["\xF2\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xAC"],
        ["\xF2\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB1"],
        ["\xF2\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB3"],
        ["\xF2\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB4"],
        ["\xF2\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB5"],
        ["\xF2\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xB8"],
        ["\xF2\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xBA"],
        ["\xF2\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xBB"],
        ["\xF2\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xBD"],
        ["\xF2\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xBF"],
        ["\xF2\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xC4"],
        ["\xF2\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xC5"],
        ["\xF2\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xC6"],
        ["\xF2\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xC7"],
        ["\xF2\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xD8"],
        ["\xF2\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xC9"],
        ["\xF2\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xCA"],
        ["\xF2\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xCD"],
        ["\xF2\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xCF"],
        ["\xF2\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xD0"],
        ["\xF2\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xD7"],
        ["\xF2\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xD6"],
        ["\xF2\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xDB"],
        ["\xF2\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xDC"],
        ["\xF2\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xDE"],
        ["\xF2\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xE0"],
        ["\xF2\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xE1"],
        ["\xF2\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xE4"],
        ["\xF2\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xE5"],
        ["\xF2\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBC\xE6"],
        ["\xF2\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\xDA"],
        ["\xF2\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xD2"],
        ["\xF2\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x50"],
        ["\xF2\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xD9"],
        ["\xF2\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xDB"],
        ["\xF2\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xDC"],
        ["\xF2\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x53"],
        ["\xF2\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xE1"],
        ["\xF2\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xE2"],
        ["\xF2\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xE7"],
        ["\xF2\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x55"],
        ["\xF2\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x56"],
        ["\xF2\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x58"],
        ["\xF2\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xF1"],
        ["\xF2\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xF2"],
        ["\xF2\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBD\xF4"],
        ["\xF2\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x5A"],
        ["\xF2\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x5B"],
        ["\xF2\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x46"],
        ["\xF2\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x4D"],
        ["\xF2\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x50"],
        ["\xF2\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x56"],
        ["\xF2\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x59"],
        ["\xF2\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x5D"],
        ["\xF2\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x5E"],
        ["\xF2\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x65"],
        ["\xF2\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x66"],
        ["\xF2\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x5D"],
        ["\xF2\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x67"],
        ["\xF2\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x6A"],
        ["\xF2\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x6D"],
        ["\xF2\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x6E"],
        ["\xF2\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x6F"],
        ["\xF2\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x71"],
        ["\xF2\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x77"],
        ["\xF2\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x78"],
        ["\xF2\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x7A"],
        ["\xF2\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x7D"],
        ["\xF2\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x5F"],
        ["\xF2\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x83"],
        ["\xF2\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x5E"],
        ["\xF2\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x87"],
        ["\xF2\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x60"],
        ["\xF2\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x8F"],
        ["\xF2\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x98"],
        ["\xF2\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\x9F"],
        ["\xF2\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xA6"],
        ["\xF2\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x62"],
        ["\xF2\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xA7"],
        ["\xF2\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xA8"],
        ["\xF2\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xAB"],
        ["\xF2\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xAE"],
        ["\xF2\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xB5"],
        ["\xF2\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xB6"],
        ["\xF2\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x63"],
        ["\xF2\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xBA"],
        ["\xF2\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xC2"],
        ["\xF2\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xC3"],
        ["\xF2\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xC4"],
        ["\xF2\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xC8"],
        ["\xF2\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xCA"],
        ["\xF2\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x65"],
        ["\xF2\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x64"],
        ["\xF2\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xD2"],
        ["\xF2\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xD4"],
        ["\xF2\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xD7"],
        ["\xF2\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xDC"],
        ["\xF2\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x68"],
        ["\xF2\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xE4"],
        ["\xF2\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xE5"],
        ["\xF2\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xE6"],
        ["\xF2\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xEB"],
        ["\xF2\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xEC"],
        ["\xF2\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xEE"],
        ["\xF2\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x69"],
        ["\xF2\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xF7"],
        ["\xF2\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xF9"],
        ["\xF2\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBE\xFB"],
        ["\xF2\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x6B"],
        ["\xF2\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x6C"],
        ["\xF2\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x4A"],
        ["\xF2\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x4E"],
        ["\xF2\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x50"],
        ["\xF2\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x57"],
        ["\xF2\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x58"],
        ["\xF2\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x5A"],
        ["\xF2\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x5B"],
        ["\xF2\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x6E"],
        ["\xF2\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x60"],
        ["\xF2\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x6F"],
        ["\xF2\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x61"],
        ["\xF2\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x63"],
        ["\xF3\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x71"],
        ["\xF3\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x73"],
        ["\xF3\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x72"],
        ["\xF3\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x7A"],
        ["\xF3\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x7B"],
        ["\xF3\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x7F"],
        ["\xF3\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x80"],
        ["\xF3\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x77"],
        ["\xF3\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x78"],
        ["\xF3\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x73"],
        ["\xF3\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x87"],
        ["\xF3\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x74"],
        ["\xF3\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x8A"],
        ["\xF3\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x8B"],
        ["\xF3\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x8E"],
        ["\xF3\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x92"],
        ["\xF3\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x75"],
        ["\xF3\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x76"],
        ["\xF3\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x7C"],
        ["\xF3\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x79"],
        ["\xF3\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\x9A"],
        ["\xF3\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xA4"],
        ["\xF3\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xAA"],
        ["\xF3\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x7D"],
        ["\xF3\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xA8"],
        ["\xF3\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xB2"],
        ["\xF3\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x7E"],
        ["\xF3\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xB9"],
        ["\xF3\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xBA"],
        ["\xF3\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xBB"],
        ["\xF3\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xBC"],
        ["\xF3\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x7A"],
        ["\xF3\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xBF"],
        ["\xF3\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xC0"],
        ["\xF3\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xC4"],
        ["\xF3\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xCA"],
        ["\xF3\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xCE"],
        ["\xF3\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xCF"],
        ["\xF3\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xD1"],
        ["\xF3\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xDC"],
        ["\xF3\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xDD"],
        ["\xF3\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xDF"],
        ["\xF3\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xE4"],
        ["\xF3\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xE7"],
        ["\xF3\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xE9"],
        ["\xF3\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xEC"],
        ["\xF3\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xF0"],
        ["\xF3\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xFD"],
        ["\xF3\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xBF\xFE"],
        ["\xF3\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x43"],
        ["\xF3\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x44"],
        ["\xF3\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x80"],
        ["\xF3\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x45"],
        ["\xF3\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x46"],
        ["\xF3\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x4E"],
        ["\xF3\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x50"],
        ["\xF3\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x81"],
        ["\xF3\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x54"],
        ["\xF3\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x56"],
        ["\xF3\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x57"],
        ["\xF3\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x82"],
        ["\xF3\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x5A"],
        ["\xF3\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x83"],
        ["\xF3\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x84"],
        ["\xF3\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x69"],
        ["\xF3\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x6D"],
        ["\xF3\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x6E"],
        ["\xF3\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x70"],
        ["\xF3\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x86"],
        ["\xF3\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x71"],
        ["\xF3\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x72"],
        ["\xF3\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x7B"],
        ["\xF3\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x87"],
        ["\xF3\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x88"],
        ["\xF3\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x7E"],
        ["\xF3\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x7F"],
        ["\xF3\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x81"],
        ["\xF3\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x84"],
        ["\xF3\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x8A"],
        ["\xF3\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x89"],
        ["\xF3\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x8C"],
        ["\xF3\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x8C"],
        ["\xF3\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x8F"],
        ["\xF3\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x90"],
        ["\xF3\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x96"],
        ["\xF3\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\x9B"],
        ["\xF3\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xA3"],
        ["\xF3\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xA8"],
        ["\xF3\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xA7"],
        ["\xF3\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x8F"],
        ["\xF3\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x93"],
        ["\xF3\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xAA"],
        ["\xF3\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x92"],
        ["\xF3\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x96"],
        ["\xF3\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x91"],
        ["\xF3\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xAE"],
        ["\xF3\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xAF"],
        ["\xF3\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xB0"],
        ["\xF3\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x95"],
        ["\xF3\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xB5"],
        ["\xF3\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xB9"],
        ["\xF3\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xBD"],
        ["\xF3\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xBE"],
        ["\xF3\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x98"],
        ["\xF3\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xC4"],
        ["\xF3\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xC5"],
        ["\xF3\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xC6"],
        ["\xF3\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x99"],
        ["\xF3\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x9A"],
        ["\xF3\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xD4"],
        ["\xF3\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x8B"],
        ["\xF3\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x9D"],
        ["\xF3\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xD6"],
        ["\xF3\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x9E"],
        ["\xF3\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x9F"],
        ["\xF3\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xD9"],
        ["\xF3\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA3"],
        ["\xF3\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA2"],
        ["\xF3\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE2"],
        ["\xF3\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA0"],
        ["\xF3\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE3"],
        ["\xF3\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE5"],
        ["\xF3\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA1"],
        ["\xF3\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA8"],
        ["\xF3\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA4"],
        ["\xF3\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE8"],
        ["\xF3\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xE9"],
        ["\xF3\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA5"],
        ["\xF3\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA6"],
        ["\xF3\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA7"],
        ["\xF3\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x9C"],
        ["\xF3\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xAA"],
        ["\xF3\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xF5"],
        ["\xF3\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xF7"],
        ["\xF3\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xFC"],
        ["\xF3\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC0\xFE"],
        ["\xF3\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x42"],
        ["\xF3\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x44"],
        ["\xF3\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xA9"],
        ["\xF3\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x48"],
        ["\xF3\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x4B"],
        ["\xF3\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xAF"],
        ["\xF3\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB1"],
        ["\xF3\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB0"],
        ["\xF3\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xAC"],
        ["\xF3\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x50"],
        ["\xF3\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x54"],
        ["\xF3\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB2"],
        ["\xF3\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x58"],
        ["\xF3\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x59"],
        ["\xF3\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xAD"],
        ["\xF3\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x5B"],
        ["\xF3\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xAE"],
        ["\xF3\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x5D"],
        ["\xF3\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x5E"],
        ["\xF3\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x5F"],
        ["\xF3\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB9"],
        ["\xF3\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x62"],
        ["\xF3\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x63"],
        ["\xF3\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x6A"],
        ["\xF3\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x6C"],
        ["\xF3\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x6D"],
        ["\xF3\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB4"],
        ["\xF3\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x71"],
        ["\xF3\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB5"],
        ["\xF3\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x72"],
        ["\xF3\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB6"],
        ["\xF3\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x73"],
        ["\xF3\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x74"],
        ["\xF3\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x79"],
        ["\xF3\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB7"],
        ["\xF3\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xB8"],
        ["\xF3\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x7C"],
        ["\xF3\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x90"],
        ["\xF3\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xBF"],
        ["\xF3\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC4"],
        ["\xF3\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xBA"],
        ["\xF3\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x7D"],
        ["\xF3\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x7E"],
        ["\xF3\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x82"],
        ["\xF4\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x83"],
        ["\xF4\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xBB"],
        ["\xF4\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x86"],
        ["\xF4\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x8A"],
        ["\xF4\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xBC"],
        ["\xF4\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xBD"],
        ["\xF4\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xBE"],
        ["\xF4\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC1"],
        ["\xF4\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC0"],
        ["\xF4\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC5"],
        ["\xF4\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\x9F"],
        ["\xF4\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC2"],
        ["\xF4\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC3"],
        ["\xF4\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xAA"],
        ["\xF4\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xAB"],
        ["\xF4\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xAE"],
        ["\xF4\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xAF"],
        ["\xF4\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xB1"],
        ["\xF4\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xB4"],
        ["\xF4\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC6"],
        ["\xF4\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xB5"],
        ["\xF4\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xB8"],
        ["\xF4\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC7"],
        ["\xF4\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xBD"],
        ["\xF4\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xBF"],
        ["\xF4\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xC0"],
        ["\xF4\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xC8"],
        ["\xF4\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xC3"],
        ["\xF4\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xC4"],
        ["\xF4\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD3"],
        ["\xF4\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD5"],
        ["\xF4\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD2"],
        ["\xF4\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD4"],
        ["\xF4\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xCC"],
        ["\xF4\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xC7"],
        ["\xF4\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xC8"],
        ["\xF4\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xCA"],
        ["\xF4\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD6"],
        ["\xF4\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xCF"],
        ["\xF4\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xCC"],
        ["\xF4\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD1"],
        ["\xF4\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD3"],
        ["\xF4\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD4"],
        ["\xF4\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xDD"],
        ["\xF4\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD8"],
        ["\xF4\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD7"],
        ["\xF4\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xD9"],
        ["\xF4\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xDD"],
        ["\xF4\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xDF"],
        ["\xF4\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD8"],
        ["\xF4\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xE1"],
        ["\xF4\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xE4"],
        ["\xF4\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xE8"],
        ["\xF4\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xDC"],
        ["\xF4\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xED"],
        ["\xF4\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF1"],
        ["\xF4\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xD9"],
        ["\xF4\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF2"],
        ["\xF4\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF6"],
        ["\xF4\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xDB"],
        ["\xF4\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE0"],
        ["\xF4\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xF8"],
        ["\xF4\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC1\xFD"],
        ["\xF4\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x42"],
        ["\xF4\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x47"],
        ["\xF4\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x46"],
        ["\xF4\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x4A"],
        ["\xF4\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x4B"],
        ["\xF4\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE5"],
        ["\xF4\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE3"],
        ["\xF4\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x4D"],
        ["\xF4\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x4F"],
        ["\xF4\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x50"],
        ["\xF4\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE1"],
        ["\xF4\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x52"],
        ["\xF4\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE7"],
        ["\xF4\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE6"],
        ["\xF4\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x58"],
        ["\xF4\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x59"],
        ["\xF4\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x5A"],
        ["\xF4\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE8"],
        ["\xF4\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x5B"],
        ["\xF4\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xE9"],
        ["\xF4\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x62"],
        ["\xF4\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x68"],
        ["\xF4\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x6C"],
        ["\xF4\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xEB"],
        ["\xF4\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x73"],
        ["\xF4\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xED"],
        ["\xF4\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xEE"],
        ["\xF4\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x79"],
        ["\xF4\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x82"],
        ["\xF4\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF0"],
        ["\xF4\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x86"],
        ["\xF4\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x87"],
        ["\xF4\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF1"],
        ["\xF4\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF2"],
        ["\xF4\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x8A"],
        ["\xF4\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x8C"],
        ["\xF4\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x8F"],
        ["\xF4\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x90"],
        ["\xF4\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x91"],
        ["\xF4\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x92"],
        ["\xF4\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x96"],
        ["\xF4\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF5"],
        ["\xF4\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\x9B"],
        ["\xF4\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xA6"],
        ["\xF4\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xA7"],
        ["\xF4\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xA8"],
        ["\xF4\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF6"],
        ["\xF4\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xAC"],
        ["\xF4\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xB1"],
        ["\xF4\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xB4"],
        ["\xF4\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF7"],
        ["\xF4\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xBC"],
        ["\xF4\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xF8"],
        ["\xF4\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xBD"],
        ["\xF4\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xBE"],
        ["\xF4\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xBF"],
        ["\xF4\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xFA"],
        ["\xF4\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xC6"],
        ["\xF4\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xCA"],
        ["\xF4\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xFC"],
        ["\xF4\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xCE"],
        ["\xF4\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xCF"],
        ["\xF4\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xD2"],
        ["\xF4\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xD4"],
        ["\xF4\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xFB"],
        ["\xF4\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x44"],
        ["\xF4\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\xFE"],
        ["\xF4\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xD9"],
        ["\xF4\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x41"],
        ["\xF4\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xDF"],
        ["\xF4\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE0"],
        ["\xF4\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xB2"],
        ["\xF4\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE3"],
        ["\xF4\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE6"],
        ["\xF4\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x47"],
        ["\xF4\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xE9"],
        ["\xF4\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x48"],
        ["\xF4\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xEE"],
        ["\xF4\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x4A"],
        ["\xF4\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x4B"],
        ["\xF4\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x4D"],
        ["\xF4\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x4E"],
        ["\xF4\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xF1"],
        ["\xF4\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xF5"],
        ["\xF4\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x4F"],
        ["\xF4\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x56"],
        ["\xF4\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x58"],
        ["\xF4\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x57"],
        ["\xF4\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x55"],
        ["\xF4\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x50"],
        ["\xF4\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x51"],
        ["\xF4\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xF7"],
        ["\xF4\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x52"],
        ["\xF4\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x42"],
        ["\xF4\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC2\xFD"],
        ["\xF4\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x41"],
        ["\xF4\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x53"],
        ["\xF4\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x45"],
        ["\xF4\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x49"],
        ["\xF4\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x4D"],
        ["\xF4\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x53"],
        ["\xF4\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x50"],
        ["\xF4\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x51"],
        ["\xF4\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x5A"],
        ["\xF4\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x52"],
        ["\xF4\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x57"],
        ["\xF4\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x58"],
        ["\xF4\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x59"],
        ["\xF4\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x5C"],
        ["\xF4\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x5A"],
        ["\xF4\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x5B"],
        ["\xF4\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x5D"],
        ["\xF4\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x5E"],
        ["\xF4\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x5F"],
        ["\xF4\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x63"],
        ["\xF4\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x5D"],
        ["\xF5\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x69"],
        ["\xF5\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x6C"],
        ["\xF5\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x5F"],
        ["\xF5\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x74"],
        ["\xF5\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x77"],
        ["\xF5\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x60"],
        ["\xF5\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x64"],
        ["\xF5\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x7B"],
        ["\xF5\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x7E"],
        ["\xF5\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x7F"],
        ["\xF5\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x83"],
        ["\xF5\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x84"],
        ["\xF5\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x87"],
        ["\xF5\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x63"],
        ["\xF5\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x91"],
        ["\xF5\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x93"],
        ["\xF5\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x66"],
        ["\xF5\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x96"],
        ["\xF5\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x98"],
        ["\xF5\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x9A"],
        ["\xF5\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x65"],
        ["\xF5\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\x9F"],
        ["\xF5\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x67"],
        ["\xF5\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xA1"],
        ["\xF5\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xA8"],
        ["\xF5\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xAC"],
        ["\xF5\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x69"],
        ["\xF5\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xAE"],
        ["\xF5\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xB0"],
        ["\xF5\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xB5"],
        ["\xF5\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x68"],
        ["\xF5\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xBB"],
        ["\xF5\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x6A"],
        ["\xF5\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xBD"],
        ["\xF5\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xBE"],
        ["\xF5\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xC0"],
        ["\xF5\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x6C"],
        ["\xF5\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xC3"],
        ["\xF5\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xC5"],
        ["\xF5\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x6B"],
        ["\xF5\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xCA"],
        ["\xF5\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x6E"],
        ["\xF5\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xCE"],
        ["\xF5\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x6D"],
        ["\xF5\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xCF"],
        ["\xF5\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xD0"],
        ["\xF5\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x6F"],
        ["\xF5\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xD5"],
        ["\xF5\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x70"],
        ["\xF5\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xD7"],
        ["\xF5\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xDC"],
        ["\xF5\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x71"],
        ["\xF5\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xDD"],
        ["\xF5\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xDE"],
        ["\xF5\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xE0"],
        ["\xF5\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xE1"],
        ["\xF5\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xE2"],
        ["\xF5\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xE3"],
        ["\xF5\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xE5"],
        ["\xF5\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xE7"],
        ["\xF5\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x73"],
        ["\xF5\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x72"],
        ["\xF5\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xEC"],
        ["\xF5\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x74"],
        ["\xF5\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x75"],
        ["\xF5\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xEF"],
        ["\xF5\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF0"],
        ["\xF5\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF1"],
        ["\xF5\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF6"],
        ["\xF5\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xF9"],
        ["\xF5\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xFB"],
        ["\xF5\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xFC"],
        ["\xF5\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x76"],
        ["\xF5\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC3\xFE"],
        ["\xF5\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x77"],
        ["\xF5\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x45"],
        ["\xF5\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x47"],
        ["\xF5\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x4D"],
        ["\xF5\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x4B"],
        ["\xF5\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x7A"],
        ["\xF5\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x51"],
        ["\xF5\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x7B"],
        ["\xF5\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x7D"],
        ["\xF5\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x55"],
        ["\xF5\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x5B"],
        ["\xF5\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x5C"],
        ["\xF5\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x5D"],
        ["\xF5\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x7E"],
        ["\xF5\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x5E"],
        ["\xF5\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x61"],
        ["\xF5\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x7F"],
        ["\xF5\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x66"],
        ["\xF5\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x68"],
        ["\xF5\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x6A"],
        ["\xF5\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x6C"],
        ["\xF5\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x6F"],
        ["\xF5\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x80"],
        ["\xF5\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x82"],
        ["\xF5\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x78"],
        ["\xF5\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x7A"],
        ["\xF5\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x7B"],
        ["\xF5\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x7C"],
        ["\xF5\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x45"],
        ["\xF5\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x7E"],
        ["\xF5\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x84"],
        ["\xF5\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x83"],
        ["\xF5\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x8B"],
        ["\xF5\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x84"],
        ["\xF5\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x8E"],
        ["\xF5\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x8F"],
        ["\xF5\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x92"],
        ["\xF5\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x95"],
        ["\xF5\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x99"],
        ["\xF5\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x86"],
        ["\xF5\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x9D"],
        ["\xF5\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\x9E"],
        ["\xF5\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x87"],
        ["\xF5\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xA0"],
        ["\xF5\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x89"],
        ["\xF5\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xA3"],
        ["\xF5\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x8A"],
        ["\xF5\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x8B"],
        ["\xF5\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xA9"],
        ["\xF5\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xAB"],
        ["\xF5\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xB1"],
        ["\xF5\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xB4"],
        ["\xF5\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xB6"],
        ["\xF5\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xB7"],
        ["\xF5\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x8C"],
        ["\xF5\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x8F"],
        ["\xF5\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xBC"],
        ["\xF5\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xBD"],
        ["\xF5\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x8D"],
        ["\xF5\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xC2"],
        ["\xF5\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xC6"],
        ["\xF5\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x90"],
        ["\xF5\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD0"],
        ["\xF5\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD1"],
        ["\xF5\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x91"],
        ["\xF5\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD2"],
        ["\xF5\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD3"],
        ["\xF5\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD4"],
        ["\xF5\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xD8"],
        ["\xF5\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xDA"],
        ["\xF5\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x92"],
        ["\xF5\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x93"],
        ["\xF5\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE1"],
        ["\xF5\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE2"],
        ["\xF5\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE3"],
        ["\xF5\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xE7"],
        ["\xF5\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x94"],
        ["\xF5\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xEC"],
        ["\xF5\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xED"],
        ["\xF5\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xEE"],
        ["\xF5\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xEF"],
        ["\xF5\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xF0"],
        ["\xF5\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xF1"],
        ["\xF5\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xF3"],
        ["\xF5\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xF9"],
        ["\xF5\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC4\xFB"],
        ["\xF5\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x41"],
        ["\xF5\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x95"],
        ["\xF5\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x42"],
        ["\xF5\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x47"],
        ["\xF5\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x4D"],
        ["\xF5\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x54"],
        ["\xF5\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x55"],
        ["\xF5\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x97"],
        ["\xF5\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x56"],
        ["\xF5\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x57"],
        ["\xF5\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x5C"],
        ["\xF5\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x5E"],
        ["\xF5\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x60"],
        ["\xF5\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x67"],
        ["\xF5\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x6A"],
        ["\xF5\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x6B"],
        ["\xF5\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x98"],
        ["\xF5\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x9A"],
        ["\xF5\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x71"],
        ["\xF5\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x99"],
        ["\xF5\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x73"],
        ["\xF6\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x76"],
        ["\xF6\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x77"],
        ["\xF6\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x9B"],
        ["\xF6\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x7C"],
        ["\xF6\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x7D"],
        ["\xF6\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x83"],
        ["\xF6\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x84"],
        ["\xF6\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x9C"],
        ["\xF6\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x9D"],
        ["\xF6\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x8B"],
        ["\xF6\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x8E"],
        ["\xF6\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x94"],
        ["\xF6\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x93"],
        ["\xF6\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x9E"],
        ["\xF6\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x96"],
        ["\xF6\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x9F"],
        ["\xF6\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\x9E"],
        ["\xF6\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xA0"],
        ["\xF6\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xA3"],
        ["\xF6\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA1"],
        ["\xF6\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA0"],
        ["\xF6\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xA6"],
        ["\xF6\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xA7"],
        ["\xF6\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xA9"],
        ["\xF6\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xAC"],
        ["\xF6\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xAD"],
        ["\xF6\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xAE"],
        ["\xF6\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xAF"],
        ["\xF6\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA2"],
        ["\xF6\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA3"],
        ["\xF6\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xB4"],
        ["\xF6\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xB6"],
        ["\xF6\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xB9"],
        ["\xF6\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xBA"],
        ["\xF6\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xBB"],
        ["\xF6\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA4"],
        ["\xF6\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA5"],
        ["\xF6\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA7"],
        ["\xF6\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xC3"],
        ["\xF6\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA8"],
        ["\xF6\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xA9"],
        ["\xF6\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xAA"],
        ["\xF6\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xC7"],
        ["\xF6\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xC8"],
        ["\xF6\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xCB"],
        ["\xF6\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xCE"],
        ["\xF6\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xAB"],
        ["\xF6\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xAC"],
        ["\xF6\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD1"],
        ["\xF6\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD2"],
        ["\xF6\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD5"],
        ["\xF6\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD6"],
        ["\xF6\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD7"],
        ["\xF6\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xD9"],
        ["\xF6\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xDA"],
        ["\xF6\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xDD"],
        ["\xF6\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xAF"],
        ["\xF6\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xDF"],
        ["\xF6\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE3"],
        ["\xF6\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xAD"],
        ["\xF6\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xAE"],
        ["\xF6\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE5"],
        ["\xF6\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xE9"],
        ["\xF6\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xEA"],
        ["\xF6\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB0"],
        ["\xF6\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xEE"],
        ["\xF6\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB1"],
        ["\xF6\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xF8"],
        ["\xF6\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xF3"],
        ["\xF6\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB2"],
        ["\xF6\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB3"],
        ["\xF6\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xFA"],
        ["\xF6\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB4"],
        ["\xF6\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC5\xFE"],
        ["\xF6\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x43"],
        ["\xF6\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB5"],
        ["\xF6\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x49"],
        ["\xF6\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x51"],
        ["\xF6\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB6"],
        ["\xF6\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x54"],
        ["\xF6\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x59"],
        ["\xF6\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x5A"],
        ["\xF6\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB7"],
        ["\xF6\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xB9"],
        ["\xF6\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x60"],
        ["\xF6\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xBA"],
        ["\xF6\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x68"],
        ["\xF6\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x69"],
        ["\xF6\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xBB"],
        ["\xF6\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x76"],
        ["\xF6\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x78"],
        ["\xF6\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x7C"],
        ["\xF6\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x80"],
        ["\xF6\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xBD"],
        ["\xF6\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xBC"],
        ["\xF6\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC0"],
        ["\xF6\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xBE"],
        ["\xF6\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xBF"],
        ["\xF6\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x91"],
        ["\xF6\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x95"],
        ["\xF6\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC2"],
        ["\xF6\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x98"],
        ["\xF6\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC1"],
        ["\xF6\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\x9C"],
        ["\xF6\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC4"],
        ["\xF6\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC3"],
        ["\xF6\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xA4"],
        ["\xF6\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xA5"],
        ["\xF6\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xA6"],
        ["\xF6\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC5"],
        ["\xF6\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC6"],
        ["\xF6\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xB4"],
        ["\xF6\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xB5"],
        ["\xF6\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xB7"],
        ["\xF6\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xB8"],
        ["\xF6\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xB9"],
        ["\xF6\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xBA"],
        ["\xF6\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC7"],
        ["\xF6\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xBB"],
        ["\xF6\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xBD"],
        ["\xF6\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xBF"],
        ["\xF6\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC8"],
        ["\xF6\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xC0"],
        ["\xF6\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xC1"],
        ["\xF6\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xC2"],
        ["\xF6\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xC3"],
        ["\xF6\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xCA"],
        ["\xF6\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xC9"],
        ["\xF6\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xD0"],
        ["\xF6\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xDA"],
        ["\xF6\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xCF"],
        ["\xF6\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xDD"],
        ["\xF6\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xDF"],
        ["\xF6\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xE5"],
        ["\xF6\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xE1"],
        ["\xF6\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xE2"],
        ["\xF6\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xE3"],
        ["\xF6\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xED"],
        ["\xF6\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xF1"],
        ["\xF6\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xF3"],
        ["\xF6\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xF4"],
        ["\xF6\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xF7"],
        ["\xF6\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xFB"],
        ["\xF6\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xFC"],
        ["\xF6\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC6\xFE"],
        ["\xF6\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD1"],
        ["\xF6\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x46"],
        ["\xF6\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x47"],
        ["\xF6\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD2"],
        ["\xF6\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD3"],
        ["\xF6\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x4C"],
        ["\xF6\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xD4"],
        ["\xF6\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x52"],
        ["\xF6\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x59"],
        ["\xF6\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x5F"],
        ["\xF6\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x64"],
        ["\xF6\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x65"],
        ["\xF6\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xDC"],
        ["\xF6\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x67"],
        ["\xF6\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x6A"],
        ["\xF6\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x73"],
        ["\xF6\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x74"],
        ["\xF6\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x77"],
        ["\xF6\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x79"],
        ["\xF6\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x7D"],
        ["\xF6\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x7F"],
        ["\xF6\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x80"],
        ["\xF6\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x82"],
        ["\xF6\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xDF"],
        ["\xF6\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE0"],
        ["\xF6\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x87"],
        ["\xF6\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE2"],
        ["\xF6\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE3"],
        ["\xF6\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE4"],
        ["\xF6\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE5"],
        ["\xF6\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x98"],
        ["\xF6\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x9A"],
        ["\xF6\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x9B"],
        ["\xF6\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x9C"],
        ["\xF6\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\x9D"],
        ["\xF6\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xE6"],
        ["\xF6\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xA1"],
        ["\xF7\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xA6"],
        ["\xF7\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xAB"],
        ["\xF7\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xAD"],
        ["\xF7\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xAF"],
        ["\xF7\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB0"],
        ["\xF7\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB1"],
        ["\xF7\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB3"],
        ["\xF7\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB4"],
        ["\xF7\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB6"],
        ["\xF7\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB7"],
        ["\xF7\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xB9"],
        ["\xF7\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xBA"],
        ["\xF7\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xBD"],
        ["\xF7\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xC0"],
        ["\xF7\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xC2"],
        ["\xF7\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xC7"],
        ["\xF7\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xC8"],
        ["\xF7\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xEA"],
        ["\xF7\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xEB"],
        ["\xF7\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xCB"],
        ["\xF7\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xCD"],
        ["\xF7\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xEC"],
        ["\xF7\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xED"],
        ["\xF7\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xD0"],
        ["\xF7\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xD3"],
        ["\xF7\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xD7"],
        ["\xF7\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xEF"],
        ["\xF7\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xEE"],
        ["\xF7\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xDB"],
        ["\xF7\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF0"],
        ["\xF7\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xE9"],
        ["\xF7\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xDF"],
        ["\xF7\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xE1"],
        ["\xF7\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xE4"],
        ["\xF7\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xE5"],
        ["\xF7\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xE7"],
        ["\xF7\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF2"],
        ["\xF7\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF5"],
        ["\xF7\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF7"],
        ["\xF7\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xEC"],
        ["\xF7\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF4"],
        ["\xF7\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xEF"],
        ["\xF7\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF6"],
        ["\xF7\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF1"],
        ["\xF7\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF2"],
        ["\xF7\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF3"],
        ["\xF7\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xF8"],
        ["\xF7\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF9"],
        ["\xF7\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xF8"],
        ["\xF7\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xFD"],
        ["\xF7\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC7\xFE"],
        ["\xF7\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x42"],
        ["\xF7\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xFA"],
        ["\xF7\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x46"],
        ["\xF7\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x49"],
        ["\xF7\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x4D"],
        ["\xF7\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x50"],
        ["\xF7\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x52"],
        ["\xF7\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xFC"],
        ["\xF7\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xFD"],
        ["\xF7\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x53"],
        ["\xF7\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x54"],
        ["\xF7\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x57"],
        ["\xF7\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x5A"],
        ["\xF7\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\xFE"],
        ["\xF7\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x65"],
        ["\xF7\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x69"],
        ["\xF7\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x6B"],
        ["\xF7\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x6C"],
        ["\xF7\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x71"],
        ["\xF7\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x43"],
        ["\xF7\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x7B"],
        ["\xF7\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x7C"],
        ["\xF7\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x45"],
        ["\xF7\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x85"],
        ["\xF7\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x86"],
        ["\xF7\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x89"],
        ["\xF7\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x8B"],
        ["\xF7\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x46"],
        ["\xF7\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x8C"],
        ["\xF7\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x47"],
        ["\xF7\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x48"],
        ["\xF7\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x4A"],
        ["\xF7\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x97"],
        ["\xF7\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x49"],
        ["\xF7\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x99"],
        ["\xF7\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x9A"],
        ["\xF7\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x9E"],
        ["\xF7\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x4C"],
        ["\xF7\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\x9F"],
        ["\xF7\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x4B"],
        ["\xF7\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xA1"],
        ["\xF7\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xA3"],
        ["\xF7\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x4D"],
        ["\xF7\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xA8"],
        ["\xF7\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x4E"],
        ["\xF7\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xAC"],
        ["\xF7\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xAE"],
        ["\xF7\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x4F"],
        ["\xF7\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xAF"],
        ["\xF7\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB0"],
        ["\xF7\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB3"],
        ["\xF7\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x50"],
        ["\xF7\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xB6"],
        ["\xF7\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xBA"],
        ["\xF7\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x52"],
        ["\xF7\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x51"],
        ["\xF7\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xC1"],
        ["\xF7\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xC2"],
        ["\xF7\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xC3"],
        ["\xF7\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xC5"],
        ["\xF7\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x56"],
        ["\xF7\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x54"],
        ["\xF7\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x53"],
        ["\xF7\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xCA"],
        ["\xF7\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xCB"],
        ["\xF7\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xCF"],
        ["\xF7\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xD0"],
        ["\xF7\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x55"],
        ["\xF7\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xD4"],
        ["\xF7\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x57"],
        ["\xF7\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xD9"],
        ["\xF7\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xDA"],
        ["\xF7\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xDC"],
        ["\xF7\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE0"],
        ["\xF7\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x59"],
        ["\xF7\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE1"],
        ["\xF7\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE4"],
        ["\xF7\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE5"],
        ["\xF7\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xE7"],
        ["\xF7\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x58"],
        ["\xF7\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xF1"],
        ["\xF7\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xF2"],
        ["\xF7\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xF5"],
        ["\xF7\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xF9"],
        ["\xF7\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC8\xFC"],
        ["\xF7\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x5C"],
        ["\xF7\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x5E"],
        ["\xF7\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x5D"],
        ["\xF7\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x42"],
        ["\xF7\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x45"],
        ["\xF7\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x47"],
        ["\xF7\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x48"],
        ["\xF7\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x49"],
        ["\xF7\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x4B"],
        ["\xF7\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x52"],
        ["\xF7\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x5E"],
        ["\xF7\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x60"],
        ["\xF7\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x60"],
        ["\xF7\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x62"],
        ["\xF7\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x63"],
        ["\xF7\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x61"],
        ["\xF7\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x65"],
        ["\xF7\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x67"],
        ["\xF7\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x68"],
        ["\xF7\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x62"],
        ["\xF7\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x6C"],
        ["\xF7\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x6B"],
        ["\xF7\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x6E"],
        ["\xF7\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x70"],
        ["\xF7\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x71"],
        ["\xF7\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x72"],
        ["\xF7\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB3\x6E"],
        ["\xF7\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x63"],
        ["\xF7\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x73"],
        ["\xF7\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x64"],
        ["\xF7\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x78"],
        ["\xF7\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x79"],
        ["\xF7\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x7A"],
        ["\xF7\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x7D"],
        ["\xF7\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x7F"],
        ["\xF7\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x80"],
        ["\xF7\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x66"],
        ["\xF7\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x86"],
        ["\xF7\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x67"],
        ["\xF7\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB5\x45"],
        ["\xF7\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x88"],
        ["\xF7\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x8A"],
        ["\xF7\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x8E"],
        ["\xF7\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x68"],
        ["\xF7\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x93"],
        ["\xF7\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x96"],
        ["\xF7\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x99"],
        ["\xF7\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x9A"],
        ["\xF7\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x9E"],
        ["\xF8\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\x9F"],
        ["\xF8\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x69"],
        ["\xF8\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xA6"],
        ["\xF8\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xA5"],
        ["\xF8\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xA8"],
        ["\xF8\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xAA"],
        ["\xF8\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xAD"],
        ["\xF8\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xB2"],
        ["\xF8\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xB4"],
        ["\xF8\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xB6"],
        ["\xF8\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x6B"],
        ["\xF8\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xC2"],
        ["\xF8\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xC4"],
        ["\xF8\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xC5"],
        ["\xF8\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x6C"],
        ["\xF8\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x6D"],
        ["\xF8\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xC9"],
        ["\xF8\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x6E"],
        ["\xF8\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xCC"],
        ["\xF8\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xCE"],
        ["\xF8\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x72"],
        ["\xF8\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x6F"],
        ["\xF8\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xD5"],
        ["\xF8\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xD7"],
        ["\xF8\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x71"],
        ["\xF8\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x75"],
        ["\xF8\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x77"],
        ["\xF8\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x73"],
        ["\xF8\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x74"],
        ["\xF8\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x76"],
        ["\xF8\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xEE"],
        ["\xF8\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xE4"],
        ["\xF8\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xE8"],
        ["\xF8\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x78"],
        ["\xF8\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xEA"],
        ["\xF8\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xEB"],
        ["\xF8\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xEC"],
        ["\xF8\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x7B"],
        ["\xF8\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x79"],
        ["\xF8\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x7A"],
        ["\xF8\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xC9\xFB"],
        ["\xF8\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x7C"],
        ["\xF8\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x41"],
        ["\xF8\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x7D"],
        ["\xF8\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x42"],
        ["\xF8\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x43"],
        ["\xF8\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x7E"],
        ["\xF8\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x49"],
        ["\xF8\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x4E"],
        ["\xF8\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x7F"],
        ["\xF8\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x51"],
        ["\xF8\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x80"],
        ["\xF8\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x59"],
        ["\xF8\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x81"],
        ["\xF8\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x5D"],
        ["\xF8\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x82"],
        ["\xF8\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x5F"],
        ["\xF8\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x85"],
        ["\xF8\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x67"],
        ["\xF8\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x68"],
        ["\xF8\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x86"],
        ["\xF8\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x87"],
        ["\xF8\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x89"],
        ["\xF8\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x6E"],
        ["\xF8\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x71"],
        ["\xF8\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x72"],
        ["\xF8\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x8A"],
        ["\xF8\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x74"],
        ["\xF8\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x75"],
        ["\xF8\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x8B"],
        ["\xF8\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x7A"],
        ["\xF8\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x8C"],
        ["\xF8\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x79"],
        ["\xF8\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x8E"],
        ["\xF8\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x7B"],
        ["\xF8\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x8D"],
        ["\xF8\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x7D"],
        ["\xF8\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x8F"],
        ["\xF8\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x90"],
        ["\xF8\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x91"],
        ["\xF8\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x80"],
        ["\xF8\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x82"],
        ["\xF8\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x92"],
        ["\xF8\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x94"],
        ["\xF8\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x95"],
        ["\xF8\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x96"],
        ["\xF8\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x93"],
        ["\xF8\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x87"],
        ["\xF8\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x88"],
        ["\xF8\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x8B"],
        ["\xF8\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x8F"],
        ["\xF8\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x98"],
        ["\xF8\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x9B"],
        ["\xF8\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\x9C"],
        ["\xF8\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA1"],
        ["\xF8\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA2"],
        ["\xF8\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA4"],
        ["\xF8\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xA5"],
        ["\xF8\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xAD"],
        ["\xF8\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xAF"],
        ["\xF8\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xB4"],
        ["\xF8\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xB8"],
        ["\xF8\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xB9"],
        ["\xF8\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x99"],
        ["\xF8\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xD3"],
        ["\xF8\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xBC"],
        ["\xF8\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xBD"],
        ["\xF8\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xC5"],
        ["\xF8\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xC9"],
        ["\xF8\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xCD"],
        ["\xF8\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xD6"],
        ["\xF8\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x9B"],
        ["\xF8\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x9D"],
        ["\xF8\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\x9A"],
        ["\xF8\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xDE"],
        ["\xF8\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE0"],
        ["\xF8\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE1"],
        ["\xF8\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE4"],
        ["\xF8\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xE6"],
        ["\xF8\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xEF"],
        ["\xF8\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF1"],
        ["\xF8\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF3"],
        ["\xF8\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF4"],
        ["\xF8\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA0"],
        ["\xF8\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xF8"],
        ["\xF8\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xFD"],
        ["\xF8\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCA\xFE"],
        ["\xF8\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x41"],
        ["\xF8\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA1"],
        ["\xF8\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA2"],
        ["\xF8\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x44"],
        ["\xF8\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x47"],
        ["\xF8\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x49"],
        ["\xF8\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x4A"],
        ["\xF8\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x4B"],
        ["\xF8\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x4E"],
        ["\xF8\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x4F"],
        ["\xF8\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x50"],
        ["\xF8\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA4"],
        ["\xF8\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x53"],
        ["\xF8\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x59"],
        ["\xF8\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x5A"],
        ["\xF8\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x5B"],
        ["\xF8\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x5D"],
        ["\xF8\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA9"],
        ["\xF8\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA6"],
        ["\xF8\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x63"],
        ["\xF8\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x6B"],
        ["\xF8\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA7"],
        ["\xF8\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xA8"],
        ["\xF8\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x71"],
        ["\xF8\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x72"],
        ["\xF8\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xAC"],
        ["\xF8\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x73"],
        ["\xF8\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x74"],
        ["\xF8\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x75"],
        ["\xF8\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x76"],
        ["\xF8\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x77"],
        ["\xF8\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x7A"],
        ["\xF8\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x7C"],
        ["\xF8\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x80"],
        ["\xF8\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xAA"],
        ["\xF8\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x87"],
        ["\xF8\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x88"],
        ["\xF8\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x8B"],
        ["\xF8\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x8F"],
        ["\xF8\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x93"],
        ["\xF8\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA0"],
        ["\xF8\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xAD"],
        ["\xF8\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xAF"],
        ["\xF8\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xAE"],
        ["\xF8\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x95"],
        ["\xF8\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x9A"],
        ["\xF8\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x9D"],
        ["\xF8\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\x9E"],
        ["\xF8\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB0"],
        ["\xF8\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA3"],
        ["\xF8\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA4"],
        ["\xF8\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA5"],
        ["\xF8\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA6"],
        ["\xF8\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xA8"],
        ["\xF8\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xAD"],
        ["\xF8\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xAF"],
        ["\xF8\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xB0"],
        ["\xF8\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB3"],
        ["\xF9\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB1"],
        ["\xF9\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB2"],
        ["\xF9\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xB8"],
        ["\xF9\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xBA"],
        ["\xF9\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xBF"],
        ["\xF9\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC0"],
        ["\xF9\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC3"],
        ["\xF9\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB4"],
        ["\xF9\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC5"],
        ["\xF9\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB5"],
        ["\xF9\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xC7"],
        ["\xF9\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xCB"],
        ["\xF9\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xCE"],
        ["\xF9\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xD4"],
        ["\xF9\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xD9"],
        ["\xF9\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xDA"],
        ["\xF9\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB6"],
        ["\xF9\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xDB"],
        ["\xF9\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB8"],
        ["\xF9\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xB9"],
        ["\xF9\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xE0"],
        ["\xF9\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xBA"],
        ["\xF9\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xE2"],
        ["\xF9\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xE7"],
        ["\xF9\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xE8"],
        ["\xF9\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xF4"],
        ["\xF9\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xF7"],
        ["\xF9\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xF8"],
        ["\xF9\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xBE"],
        ["\xF9\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xBF"],
        ["\xF9\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xFA"],
        ["\xF9\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCB\xFB"],
        ["\xF9\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x41"],
        ["\xF9\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC0"],
        ["\xF9\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x45"],
        ["\xF9\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x47"],
        ["\xF9\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x48"],
        ["\xF9\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x50"],
        ["\xF9\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x51"],
        ["\xF9\x69",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x53"],
        ["\xF9\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x55"],
        ["\xF9\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x56"],
        ["\xF9\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x5A"],
        ["\xF9\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC1"],
        ["\xF9\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC2"],
        ["\xF9\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x61"],
        ["\xF9\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x62"],
        ["\xF9\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x64"],
        ["\xF9\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x66"],
        ["\xF9\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x67"],
        ["\xF9\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x69"],
        ["\xF9\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x6B"],
        ["\xF9\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x6C"],
        ["\xF9\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x6D"],
        ["\xF9\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x71"],
        ["\xF9\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x74"],
        ["\xF9\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x77"],
        ["\xF9\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x78"],
        ["\xF9\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x79"],
        ["\xF9\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC3"],
        ["\xF9\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x7C"],
        ["\xF9\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x7F"],
        ["\xF9\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x80"],
        ["\xF9\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x83"],
        ["\xF9\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC4"],
        ["\xF9\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC6"],
        ["\xF9\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC5"],
        ["\xF9\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x97"],
        ["\xF9\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x8B"],
        ["\xF9\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x8C"],
        ["\xF9\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x8F"],
        ["\xF9\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x95"],
        ["\xF9\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC7"],
        ["\xF9\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC8"],
        ["\xF9\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x9D"],
        ["\xF9\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xC9"],
        ["\xF9\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\x9F"],
        ["\xF9\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xA3"],
        ["\xF9\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xCF"],
        ["\xF9\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xA9"],
        ["\xF9\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xCB"],
        ["\xF9\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xAB"],
        ["\xF9\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xCC"],
        ["\xF9\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xCD"],
        ["\xF9\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xAD"],
        ["\xF9\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xAE"],
        ["\xF9\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xAF"],
        ["\xF9\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xB5"],
        ["\xF9\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xB6"],
        ["\xF9\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xBA"],
        ["\xF9\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xBD"],
        ["\xF9\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xC6"],
        ["\xF9\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xC8"],
        ["\xF9\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xCA"],
        ["\xF9\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xCD"],
        ["\xF9\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD0"],
        ["\xF9\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xD3"],
        ["\xF9\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xD9"],
        ["\xF9\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xDC"],
        ["\xF9\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xDE"],
        ["\xF9\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD2"],
        ["\xF9\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD1"],
        ["\xF9\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xDF"],
        ["\xF9\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD4"],
        ["\xF9\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD3"],
        ["\xF9\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xE9"],
        ["\xF9\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD5"],
        ["\xF9\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xED"],
        ["\xF9\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xEE"],
        ["\xF9\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xEF"],
        ["\xF9\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xF6"],
        ["\xF9\xB2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD7"],
        ["\xF9\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xF5"],
        ["\xF9\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xF7"],
        ["\xF9\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xF8"],
        ["\xF9\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xFC"],
        ["\xF9\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCC\xFD"],
        ["\xF9\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xD8"],
        ["\xF9\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x41"],
        ["\xF9\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xDA"],
        ["\xF9\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xDB"],
        ["\xF9\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xDC"],
        ["\xF9\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x57"],
        ["\xF9\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x58"],
        ["\xF9\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x5A"],
        ["\xF9\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xDD"],
        ["\xF9\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xDE"],
        ["\xF9\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x62"],
        ["\xF9\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xDF"],
        ["\xF9\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x6D"],
        ["\xF9\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x6F"],
        ["\xF9\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x74"],
        ["\xF9\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x77"],
        ["\xF9\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x7B"],
        ["\xF9\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x7F"],
        ["\xF9\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x81"],
        ["\xF9\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x84"],
        ["\xF9\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE1"],
        ["\xF9\xCD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x86"],
        ["\xF9\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x87"],
        ["\xF9\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x8A"],
        ["\xF9\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x8B"],
        ["\xF9\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE2"],
        ["\xF9\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x90"],
        ["\xF9\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x91"],
        ["\xF9\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE4"],
        ["\xF9\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE3"],
        ["\xF9\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x9B"],
        ["\xF9\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\x9D"],
        ["\xF9\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xA0"],
        ["\xF9\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xA3"],
        ["\xF9\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xA8"],
        ["\xF9\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xC1"],
        ["\xF9\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xBA"],
        ["\xF9\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xC5"],
        ["\xF9\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xD0"],
        ["\xF9\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xD6"],
        ["\xF9\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE7"],
        ["\xF9\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xDA"],
        ["\xF9\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xD8"],
        ["\xF9\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xE8"],
        ["\xF9\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xDD"],
        ["\xF9\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xDF"],
        ["\xF9\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xE0"],
        ["\xF9\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xE5"],
        ["\xF9\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xEA"],
        ["\xF9\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xEB"],
        ["\xF9\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xEE"],
        ["\xF9\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xF1"],
        ["\xF9\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xF6"],
        ["\xF9\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xF9"],
        ["\xF9\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xFC"],
        ["\xF9\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xFD"],
        ["\xF9\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCD\xFE"],
        ["\xF9\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x41"],
        ["\xF9\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x44"],
        ["\xF9\xF5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xEE"],
        ["\xF9\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x45"],
        ["\xF9\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xEF"],
        ["\xF9\xF8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF0"],
        ["\xF9\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x47"],
        ["\xF9\xFA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x48"],
        ["\xF9\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x4B"],
        ["\xF9\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x4E"],
        ["\xFA\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x68"],
        ["\xFA\x4B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x71"],
        ["\xFA\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x70"],
        ["\xFA\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x72"],
        ["\xFA\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF4"],
        ["\xFA\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF5"],
        ["\xFA\x51",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF7"],
        ["\xFA\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x80"],
        ["\xFA\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF8"],
        ["\xFA\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x85"],
        ["\xFA\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x89"],
        ["\xFA\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x8E"],
        ["\xFA\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x92"],
        ["\xFA\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xF9"],
        ["\xFA\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\x9E"],
        ["\xFA\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xA0"],
        ["\xFA\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xA7"],
        ["\xFA\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xFB"],
        ["\xFA\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xB0"],
        ["\xFA\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCE\xBB"],
        ["\xFA\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB6\xFE"],
        ["\xFA\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x46"],
        ["\xFA\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x76"],
        ["\xFA\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x95"],
        ["\xFA\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\x96"],
        ["\xFA\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x53"],
        ["\xFA\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xCF\xC5"],
        ["\xFA\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x84"],
        ["\xFA\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x8D"],
        ["\xFA\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x9A"],
        ["\xFA\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\x9F"],
        ["\xFB\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD0\xF3"],
        ["\xFB\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x6E"],
        ["\xFB\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\x88"],
        ["\xFB\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xAD"],
        ["\xFB\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xAF"],
        ["\xFB\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x77"],
        ["\xFB\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xB4"],
        ["\xFB\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xC4"],
        ["\xFB\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x7C"],
        ["\xFB\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x7F"],
        ["\xFB\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xD5"],
        ["\xFB\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x81"],
        ["\xFB\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x84"],
        ["\xFB\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xED"],
        ["\xFB\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD1\xF3"],
        ["\xFB\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x5A"],
        ["\xFB\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x71"],
        ["\xFB\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x73"],
        ["\xFB\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x74"],
        ["\xFB\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x8B"],
        ["\xFB\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\x79"],
        ["\xFB\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x97"],
        ["\xFB\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xB1"],
        ["\xFB\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xCD"],
        ["\xFB\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x9B"],
        ["\xFB\xF6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xE9"],
        ["\xFB\xF7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x9D"],
        ["\xFB\xF9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xF2"],
        ["\xFB\xFB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\x9F"],
        ["\xFB\xFC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xF5"],
        ["\xFC\x40",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA0"],
        ["\xFC\x41",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD2\xFE"],
        ["\xFC\x42",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x43"],
        ["\xFC\x43",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x47"],
        ["\xFC\x44",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA2"],
        ["\xFC\x45",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA3"],
        ["\xFC\x46",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x4F"],
        ["\xFC\x47",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA4"],
        ["\xFC\x48",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA5"],
        ["\xFC\x49",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA6"],
        ["\xFC\x4A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x54"],
        ["\xFC\x4C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x5A"],
        ["\xFC\x4D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x5D"],
        ["\xFC\x4E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x5E"],
        ["\xFC\x4F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x5F"],
        ["\xFC\x50",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xA8"],
        ["\xFC\x52",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x63"],
        ["\xFC\x53",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x65"],
        ["\xFC\x54",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x67"],
        ["\xFC\x55",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x73"],
        ["\xFC\x56",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x79"],
        ["\xFC\x57",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x7C"],
        ["\xFC\x58",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x7D"],
        ["\xFC\x59",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x7E"],
        ["\xFC\x5A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x81"],
        ["\xFC\x5B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x84"],
        ["\xFC\x5C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x86"],
        ["\xFC\x5D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x8C"],
        ["\xFC\x5E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xAA"],
        ["\xFC\x5F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x8E"],
        ["\xFC\x60",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x96"],
        ["\xFC\x61",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x97"],
        ["\xFC\x62",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x9B"],
        ["\xFC\x63",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x9C"],
        ["\xFC\x64",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\x9F"],
        ["\xFC\x65",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xAB"],
        ["\xFC\x66",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xA0"],
        ["\xFC\x67",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xB2"],
        ["\xFC\x68",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xB5"],
        ["\xFC\x6A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xAC"],
        ["\xFC\x6B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xAF"],
        ["\xFC\x6C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xB7"],
        ["\xFC\x6D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xB9"],
        ["\xFC\x6E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xBB"],
        ["\xFC\x6F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xBE"],
        ["\xFC\x70",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xCB"],
        ["\xFC\x71",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC3"],
        ["\xFC\x72",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC4"],
        ["\xFC\x73",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC7"],
        ["\xFC\x74",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC8"],
        ["\xFC\x75",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xC9"],
        ["\xFC\x76",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xCA"],
        ["\xFC\x77",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xAD"],
        ["\xFC\x78",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xAE"],
        ["\xFC\x79",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xCF"],
        ["\xFC\x7A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB2"],
        ["\xFC\x7B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xCC"],
        ["\xFC\x7C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB0"],
        ["\xFC\x7D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xD6"],
        ["\xFC\x7E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xD7"],
        ["\xFC\x80",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xD8"],
        ["\xFC\x81",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xD9"],
        ["\xFC\x82",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB1"],
        ["\xFC\x83",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xDC"],
        ["\xFC\x84",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xDF"],
        ["\xFC\x85",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xE1"],
        ["\xFC\x86",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xE2"],
        ["\xFC\x87",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB3"],
        ["\xFC\x88",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xE3"],
        ["\xFC\x89",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xE5"],
        ["\xFC\x8A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xE6"],
        ["\xFC\x8B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xEB"],
        ["\xFC\x8C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF6"],
        ["\xFC\x8D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB5"],
        ["\xFC\x8E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xEC"],
        ["\xFC\x8F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xED"],
        ["\xFC\x90",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB4"],
        ["\xFC\x91",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF2"],
        ["\xFC\x92",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF4"],
        ["\xFC\x93",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF5"],
        ["\xFC\x94",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF7"],
        ["\xFC\x95",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xF9"],
        ["\xFC\x96",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xFC"],
        ["\xFC\x97",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xFD"],
        ["\xFC\x98",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD3\xFE"],
        ["\xFC\x99",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB7"],
        ["\xFC\x9A",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x41"],
        ["\xFC\x9B",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x42"],
        ["\xFC\x9C",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x43"],
        ["\xFC\x9D",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x44"],
        ["\xFC\x9E",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB8"],
        ["\xFC\x9F",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x47"],
        ["\xFC\xA0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x48"],
        ["\xFC\xA1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x4C"],
        ["\xFC\xA2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x4B"],
        ["\xFC\xA3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xB9"],
        ["\xFC\xA4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x4D"],
        ["\xFC\xA5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x4E"],
        ["\xFC\xA6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x4F"],
        ["\xFC\xA7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xBD"],
        ["\xFC\xA8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xBA"],
        ["\xFC\xA9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xBB"],
        ["\xFC\xAA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x55"],
        ["\xFC\xAB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xBC"],
        ["\xFC\xAC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x5B"],
        ["\xFC\xAD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x5F"],
        ["\xFC\xAE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x62"],
        ["\xFC\xAF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x63"],
        ["\xFC\xB0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC2"],
        ["\xFC\xB1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x66"],
        ["\xFC\xB3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xBF"],
        ["\xFC\xB4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC0"],
        ["\xFC\xB5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x68"],
        ["\xFC\xB6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x69"],
        ["\xFC\xB7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x6C"],
        ["\xFC\xB8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x6E"],
        ["\xFC\xB9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x71"],
        ["\xFC\xBA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC1"],
        ["\xFC\xBB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x79"],
        ["\xFC\xBC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x81"],
        ["\xFC\xBD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x7E"],
        ["\xFC\xBE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x7F"],
        ["\xFC\xBF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC3"],
        ["\xFC\xC0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x82"],
        ["\xFC\xC1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x83"],
        ["\xFC\xC2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x84"],
        ["\xFC\xC3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x88"],
        ["\xFC\xC4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x8A"],
        ["\xFC\xC5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x8C"],
        ["\xFC\xC6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x8D"],
        ["\xFC\xC7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC5"],
        ["\xFC\xC8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x95"],
        ["\xFC\xC9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC7"],
        ["\xFC\xCA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x99"],
        ["\xFC\xCB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\x97"],
        ["\xFC\xCC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC8"],
        ["\xFC\xCE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xA0"],
        ["\xFC\xCF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xA1"],
        ["\xFC\xD0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xA3"],
        ["\xFC\xD1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB4\x52"],
        ["\xFC\xD2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xA5"],
        ["\xFC\xD3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xA9"],
        ["\xFC\xD4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xAF"],
        ["\xFC\xD5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xB2"],
        ["\xFC\xD6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xC9"],
        ["\xFC\xD7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xCA"],
        ["\xFC\xD8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xCC"],
        ["\xFC\xD9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xBE"],
        ["\xFC\xDA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xC0"],
        ["\xFC\xDB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xC3"],
        ["\xFC\xDC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xC9"],
        ["\xFC\xDD",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xCA"],
        ["\xFC\xDE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xCD"],
        ["\xFC\xDF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xCB"],
        ["\xFC\xE0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xD3"],
        ["\xFC\xE1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xD4"],
        ["\xFC\xE2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xDC"],
        ["\xFC\xE3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xE0"],
        ["\xFC\xE4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xE2"],
        ["\xFC\xE5",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xE4"],
        ["\xFC\xE6",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xE6"],
        ["\xFC\xE7",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xE9"],
        ["\xFC\xE8",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xEA"],
        ["\xFC\xE9",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xEC"],
        ["\xFC\xEA",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xED"],
        ["\xFC\xEB",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xF0"],
        ["\xFC\xEC",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xCE"],
        ["\xFC\xED",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xF2"],
        ["\xFC\xEE",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xCF"],
        ["\xFC\xEF",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xF5"],
        ["\xFC\xF0",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xD0"],
        ["\xFC\xF1",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xF6"],
        ["\xFC\xF2",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xF9"],
        ["\xFC\xF3",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xD4\xFC"],
        ["\xFC\xF4",'cp00930','sjis2004',{'INPUT_LAYOUT'=>'D'},"\xB7\xD1"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        $option_content .= qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}}        if exists $option->{'INPUT_LAYOUT'};
        $option_content .= qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}}  if exists $option->{'OUTPUT_SHIFTING'};
        $option_content .= qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}} if exists $option->{'SPACE'};
        $option_content .= qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}}   if exists $option->{'GETA'};
        $option_content = "{$option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
