/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graph2;

import java.util.ArrayList;
import java.util.List;
import java.util.PriorityQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Dijkstra {
    private final List<Vertex> vertices = new ArrayList<Vertex>();

    public Vertex addVertex(Object object) {
        Vertex vertex = new Vertex(object);
        this.vertices.add(vertex);
        return vertex;
    }

    private void computePaths(Vertex vertex) {
        vertex.minDistance = 0.0;
        PriorityQueue<Vertex> priorityQueue = new PriorityQueue<Vertex>();
        priorityQueue.add(vertex);
        while (!priorityQueue.isEmpty()) {
            Vertex vertex2 = (Vertex)priorityQueue.poll();
            for (Edge edge : vertex2.adjacencies) {
                Vertex vertex3 = edge.target;
                double d = edge.weight;
                double d2 = vertex2.minDistance + d;
                if (!(d2 < vertex3.minDistance)) continue;
                priorityQueue.remove(vertex3);
                vertex3.minDistance = d2;
                vertex3.previous = vertex2;
                priorityQueue.add(vertex3);
            }
        }
    }

    public List<Vertex> getShortestPathTo(Vertex vertex, Vertex vertex2) {
        this.computePaths(vertex);
        ArrayList<Vertex> arrayList = new ArrayList<Vertex>();
        Vertex vertex3 = vertex2;
        while (vertex3 != null) {
            arrayList.add(0, vertex3);
            vertex3 = vertex3.previous;
        }
        return arrayList;
    }

    static class Edge {
        private final Vertex target;
        private final double weight;

        Edge(Vertex vertex, double d) {
            this.target = vertex;
            this.weight = d;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Vertex
    implements Comparable<Vertex> {
        private final Object data;
        private final List<Edge> adjacencies = new ArrayList<Edge>();
        private double minDistance = Double.POSITIVE_INFINITY;
        private Vertex previous;

        Vertex(Object object) {
            this.data = object;
        }

        public void addAdjacencies(Vertex vertex, double d) {
            if (vertex == null) {
                throw new IllegalArgumentException();
            }
            this.adjacencies.add(new Edge(vertex, d));
        }

        public String toString() {
            return "[ " + this.data.toString() + " (" + this.minDistance + ") ] ";
        }

        @Override
        public int compareTo(Vertex vertex) {
            return Double.compare(this.minDistance, vertex.minDistance);
        }

        public final Object getData() {
            return this.data;
        }
    }
}

