# Generated by default/object.tt
package Paws::LexRuntimeV2::Message;
  use Moose;
  has Content => (is => 'ro', isa => 'Str', request_name => 'content', traits => ['NameInRequest']);
  has ContentType => (is => 'ro', isa => 'Str', request_name => 'contentType', traits => ['NameInRequest'], required => 1);
  has ImageResponseCard => (is => 'ro', isa => 'Paws::LexRuntimeV2::ImageResponseCard', request_name => 'imageResponseCard', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexRuntimeV2::Message

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexRuntimeV2::Message object:

  $service_obj->Method(Att1 => { Content => $value, ..., ImageResponseCard => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexRuntimeV2::Message object:

  $result = $service_obj->Method(...);
  $result->Att1->Content

=head1 DESCRIPTION

Container for text that is returned to the customer..

=head1 ATTRIBUTES


=head2 Content => Str

The text of the message.


=head2 B<REQUIRED> ContentType => Str

Indicates the type of response.


=head2 ImageResponseCard => L<Paws::LexRuntimeV2::ImageResponseCard>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexRuntimeV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

