# Generated by default/object.tt
package Paws::MediaLive::AncillarySourceSettings;
  use Moose;
  has SourceAncillaryChannelNumber => (is => 'ro', isa => 'Int', request_name => 'sourceAncillaryChannelNumber', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaLive::AncillarySourceSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaLive::AncillarySourceSettings object:

  $service_obj->Method(Att1 => { SourceAncillaryChannelNumber => $value, ..., SourceAncillaryChannelNumber => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaLive::AncillarySourceSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->SourceAncillaryChannelNumber

=head1 DESCRIPTION

Ancillary Source Settings

=head1 ATTRIBUTES


=head2 SourceAncillaryChannelNumber => Int

Specifies the number (1 to 4) of the captions channel you want to
extract from the ancillary captions. If you plan to convert the
ancillary captions to another format, complete this field. If you plan
to choose Embedded as the captions destination in the output (to pass
through all the channels in the ancillary captions), leave this field
blank because MediaLive ignores the field.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaLive>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

