# automatically generated file, don't edit



# Copyright 2024 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::KZ;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20240607153921;

my $formatters = [];

my $validators = {
                'fixed_line' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'geographic' => '
          (?:
            33622|
            7(?:
              1(?:
                0(?:
                  [23]\\d|
                  4[0-3]|
                  59|
                  63
                )|
                1(?:
                  [23]\\d|
                  4[0-79]|
                  59
                )|
                2(?:
                  [23]\\d|
                  59
                )|
                3(?:
                  2\\d|
                  3[0-79]|
                  4[0-35-9]|
                  59
                )|
                4(?:
                  [24]\\d|
                  3[013-9]|
                  5[1-9]|
                  97
                )|
                5(?:
                  2\\d|
                  3[1-9]|
                  4[0-7]|
                  59
                )|
                6(?:
                  [2-4]\\d|
                  5[19]|
                  61
                )|
                72\\d|
                8(?:
                  [27]\\d|
                  3[1-46-9]|
                  4[0-5]|
                  59
                )
              )|
              2(?:
                1(?:
                  [23]\\d|
                  4[46-9]|
                  5[3469]
                )|
                2(?:
                  2\\d|
                  3[0679]|
                  46|
                  5[12679]
                )|
                3(?:
                  [2-4]\\d|
                  5[139]
                )|
                4(?:
                  2\\d|
                  3[1-35-9]|
                  59
                )|
                5(?:
                  [23]\\d|
                  4[0-8]|
                  59|
                  61
                )|
                6(?:
                  2\\d|
                  3[1-9]|
                  4[0-4]|
                  59
                )|
                7(?:
                  [2379]\\d|
                  40|
                  5[279]
                )|
                8(?:
                  [23]\\d|
                  4[0-3]|
                  59
                )|
                9(?:
                  2\\d|
                  3[124578]|
                  59
                )
              )
            )
          )\\d{5}
        ',
                'mobile' => '
          7(?:
            0[0-25-8]|
            47|
            6[0-4]|
            7[15-8]|
            85
          )\\d{7}
        ',
                'pager' => '',
                'personal_number' => '808\\d{7}',
                'specialrate' => '(809\\d{7})',
                'toll_free' => '
          8(?:
            00|
            108\\d{3}
          )\\d{7}
        ',
                'voip' => '751\\d{7}'
              };
my %areanames = ();
$areanames{ru} = {"771039", "Приозерск",
"7847", "Республика\ Калмыкия",
"771144", "Казталовский\ р\-н",
"771041", "Актау\,\ Жезказган",
"771146", "Акжаикский\ р\-н",
"772435", "Жанакорганский\ р\-н",
"771531", "Магжана\ Жумабаева\ р\-н",
"771231", "Исатайский\ р\-н",
"772353", "Бородулихинский\ р\-н",
"772541", "Мырзакент",
"77149", "Костанай",
"772239", "Урджарский\ р\-н",
"772539", "Казыгурт",
"77272956", "Талгар",
"77187", "Экибастуз",
"771140", "Бокейординский\ р\-н",
"7841", "Пензенская\ обл\.",
"733", "Байконыр",
"7816", "Новгородская\ обл\.",
"771445", "Алтынсаринский\ р\-н",
"7865", "Ставропольский\ край",
"7862", "Краснодарский\ край",
"7851", "Астраханская\ обл\.",
"7475", "Тамбовская\ обл\.",
"7472", "Белгородская\ обл\.",
"7482", "Тверская\ обл\.",
"7485", "Ярославская\ обл\.",
"77292", "Актау",
"771831", "Железинский\ р\-н",
"77142", "Костанай",
"772433", "Аральский\ р\-н",
"772437", "Кармакшинский\ р\-н",
"771142", "Акжаикский\ р\-н",
"771443", "Мендыкаринский\ р\-н",
"7813", "Ленинградская\ обл\.",
"771447", "Карабалыкский\ р\-н",
"772132", "Нуринский\ р\-н",
"7342", "Пермский\ край",
"7345", "Тюменская\ обл\.",
"772839", "Саркандский\ р\-н",
"7352", "Курганская\ обл\.",
"772138", "Бухар\-Жырауский\ р\-н",
"772841", "Аксуский\ р\-н",
"771436", "Тарановский\ р\-н",
"7421", "Хабаровский\ край",
"771451", "Сарыкольский\ р\-н",
"771434", "Денисовский\ р\-н",
"7483", "Брянская\ обл\.",
"772775", "Енбекшиказахский\ р\-н",
"7473", "Воронежская\ обл\.",
"772934", "Жанаозен",
"7820", "Вологодская\ обл\.",
"771631", "Шортандинский\ р\-н",
"771649", "Жаксынский\ р\-н",
"7343", "Свердловская\ обл",
"772641", "Таласский\ р\-н",
"77279", "Алматы",
"7353", "Оренбургская\ обл\.",
"772639", "Сарысуский\ р\-н",
"771135", "Жанибекский\ р\-н",
"7815", "Мурманская\ обл\.",
"7812", "г\.\ Санкт\-Петербург",
"7866", "Республика\ Кабардино\-Балкарская",
"7427", "Чукотский\ АО",
"771430", "Аркалык",
"772777", "Райымбекский\ р\-н",
"772257", "Шульбинск",
"771349", "Шалкарский\ р\-н",
"771331", "Мартукский\ р\-н",
"771438", "Амангельдинский\ р\-н",
"772773", "Балхашский\ р\-н",
"772932", "Бейнеуский\ р\-н",
"7486", "Орловская\ обл\.",
"772147", "Каркаралинский\ р\-н",
"77272", "Алма\-Ата",
"7395", "Иркутская\ обл\.",
"772938", "Тупкараганский\ р\-н",
"771137", "Чингирлауский\ р\-н",
"7863", "Ростовская\ обл\.",
"77212", "Караганда",
"771133", "Бурлинский\ р\-н",
"7818", "Архангельская\ обл\.",
"772339", "Курчумский\ р\-н",
"772341", "Катон\-Карагайский\ р\-н",
"77245", "Кызылординская\ область",
"7346", "Ханты\ \-\ Мансийский\ \-\ Югра\ АО",
"771439", "Джангильдинский\ р\-н",
"7869", "г\.\ Севастополь",
"77272983", "Каскелен",
"771348", "Шалкарский\ р\-н",
"7834", "Республика\ Мордовия",
"771441", "Карабалыкский\ р\-н",
"77135", "Актюбинская\ область",
"771644", "Аршалынский\ р\-н",
"7384", "Кемеровская\ обл\.",
"771342", "Каргалинский\ р\-н",
"772843", "Лепсы",
"772545", "Икан",
"7817", "Вологодская\ обл\.",
"771646", "Буландинский\ р\-н",
"772634", "Жанатас",
"771837", "Аксуский\ р\-н",
"7846", "Самарская\ обл\.",
"772332", "Шемонаихинский\ р\-н",
"771640", "Сандыктауский\ р\-н",
"77282", "Талдыкорган",
"771833", "Качирский\ р\-н",
"771235", "Макатский\ р\-н",
"7811", "Псковская\ обл\.",
"771535", "Габита\ Мусрепова\ р\-н",
"772636", "Кордай",
"772338", "Уланский\ р\-н",
"772431", "Жалагашский\ р\-н",
"771346", "Темирский\ р\-н",
"7391", "Красноярский\ край",
"7717", "Астана",
"772543", "Аксумбе",
"7349", "Ямало\-Ненецкий\ АО",
"771642", "Егиндыкольский\ р\-н",
"772330", "Зыряновский\ р\-н",
"772547", "Ленгер",
"77102", "Жезказган",
"772153", "Абайский\ р\-н",
"771648", "Жаркаинский\ р\-н",
"771043", "Жайрем\ \(поселок\)",
"772638", "Шуский\ р\-н",
"772757", "Акший",
"772336", "Риддер",
"77222", "Семипалатинск",
"771533", "Айыртауский\ р\-н",
"771233", "Курмангазинский\ р\-н",
"77252", "Шымкент",
"772351", "Бородулихинский\ р\-н",
"7843", "Республика\ Татарстан",
"772632", "Меркенский\ р\-н",
"771340", "Хобдинский\ р\-н",
"771537", "Тимирязевский\ р\-н",
"772334", "Уланский\ р\-н",
"771237", "Жылыойский\ р\-н",
"77185", "Шалдай",
"771036", "Балхаш",
"771149", "Акжаикский\ р\-н",
"7494", "Костромская\ обл\.",
"771131", "Зеленовский\ р\-н",
"771034", "Улытауский\ р\-н",
"772343", "Курчумский\ р\-н",
"7426", "Еврейская\ автономная\ обл\.",
"7867", "Республика\ Северная\ Осетия\ \-\ Алания",
"771546", "Акжарский\ р\-н",
"771544", "Жамбылский\ р\-н",
"772347", "Жарминский\ р\-н",
"771842", "Майский\ р\-он",
"772230", "Урджарский\ р\-н",
"772530", "Темирлановка",
"7855", "Республика\ Татарстан",
"771333", "Мугалжарский\ р\-н",
"7861", "Краснодарский\ край",
"77232", "Усть\-Каменогорск",
"772236", "Бескарагайский\ р\-н",
"771635", "Жаксынский\ р\-н",
"772536", "Кентау",
"772534", "Жетысай",
"771337", "Алгинский\ р\-н",
"772771", "Карасайский\ р\-н",
"772832", "Аксуский\ р\-н",
"7842", "Ульяновская\ обл\.",
"7845", "Саратовская\ обл\.",
"771540", "Уалихановский\ р\-н",
"772251", "Курчатов",
"771455", "Костанайский\ р\-н",
"771030", "Жана\-Аркинский\ р\-н",
"772838", "Коксуский\ р\-н",
"772830", "Алакольский\ р\-н",
"771542", "Уалихановский\ р\-н",
"771844", "Иртышский\ р\-н",
"771038", "Сыры\-Шаган",
"772345", "Жарминский\ р\-н",
"7423", "Приморский\ край",
"772643", "Шуский\ р\-н",
"77273", "Алма\-Ата",
"771032", "Каражал",
"7481", "Смоленская\ обл\.",
"7347", "Республика\ Башкортостан",
"77125", "Атырауская\ область",
"7471", "Курская\ обл\.",
"772538", "имени\ Турара\ Рыскулова",
"771457", "Джангильдинский\ р\-н",
"7351", "Челябинская\ обл\.",
"7487", "Тульская\ обл\.",
"7341", "Республика\ Удмуртская",
"771453", "Аулиекольский\ р\-н",
"7848", "Самарская\ обл\.",
"771840", "Баянаульский\ р\-н",
"772532", "Абая",
"771637", "Коргалжынский\ р\-н",
"772834", "Каратальский\ р\-н",
"772836", "Ескельдинский\ р\-н",
"771335", "Шалкарский\ р\-н",
"77213", "Темиртау",
"771633", "Ерейментауский\ р\-н",
"77262", "Тараз",
"772774", "Талгарский\ р\-н",
"772935", "Каракиянский\ р\-н",
"772531", "Аксукент",
"772776", "Енбекшиказахский\ р\-н",
"772256", "Алгабас",
"772144", "Нуринский\ р\-н",
"772159", "Карагандинская\ область",
"771130", "Зеленовский\ р\-н",
"771435", "Житикаринский\ р\-н",
"772146", "Каркаралинск",
"7385", "Алтайский\ край",
"771031", "Шетский\ р\-н",
"771134", "Сырымский\ р\-н",
"772759", "Алматинская\ область",
"7382", "Томская\ обл\.",
"7424", "Сахалинская\ обл\.",
"771136", "Акжаикский\ р\-н",
"771539", "Кызылжарский\ р\-н",
"771239", "Макатский\ р\-н",
"7496", "г\.\ Москва",
"772770", "Жамбылский\ р\-н",
"7835", "Чувашская\ Республика\ \-\ Чувашия",
"771541", "Мамлютский\ р\-н",
"736", "Республика\ Крым",
"771433", "Лисаковск",
"77242", "Кызылорда",
"77224", "Эмельтау",
"772778", "Уйгурский\ р\-н",
"771437", "Камыстинский\ р\-н",
"7877", "Республика\ Адыгея",
"772937", "Каракиянский\ р\-н",
"772831", "Панфиловский\ р\-н",
"772772", "Капчагай",
"772148", "Осакаровский\ р\-н",
"772252", "Абайский\ р\-н",
"7871", "Республика\ Чеченская",
"771841", "Актогайский\ р\-н",
"771138", "Казталовский\ р\-н",
"771839", "Лебяжинский\ р\-н",
"7493", "Ивановская\ обл\.",
"771132", "Теректинский\ р\-н",
"7388", "Республика\ Алтай",
"772631", "Турара\ Рыскулова\ р\-н",
"7411", "Республика\ Саха\ \/Якутия\/",
"772436", "Сырдарьинский\ р\-н",
"771145", "Каратобинский\ р\-н",
"7301", "Республика\ Бурятия",
"7844", "Волгоградская\ обл\.",
"771440", "Амангельдинский\ р\-н",
"77106", "Сатпаев",
"771446", "Узункольский\ р\-н",
"771444", "Узункольский\ р\-н",
"771459", "Костанайская\ область",
"7712303", "Тензиз",
"7492", "Владимирская\ обл\.",
"771639", "Енбекшилдерский\ р\-н",
"7495", "Московская\ обл\.",
"7836", "Республика\ Марий\ Эл",
"740", "Калининградская\ обл\.",
"771641", "Астраханский\ р\-н",
"772432", "Шиелийский\ р\-н",
"7879", "Ставропольский\ край",
"771147", "Акжаикский\ р\-н",
"771143", "Теректинский\ р\-н",
"772438", "Казалинский\ р\-н",
"772331", "Глубоковский\ р\-н",
"771448", "Карасуский\ р\-н",
"7833", "Кировская\ обл\.",
"771341", "Хобдинский\ р\-н",
"7498", "Московская\ обл\.",
"771339", "Айтекебийский\ р\-н",
"77145834", "Красногорск",
"7390", "Республика\ Хакасия",
"771442", "Федоровский\ р\-н",
"772137", "Сарань",
"7383", "Новосибирская\ обл\.",
"77112", "Уральск",
"7302", "Забайкальский\ край",
"772342", "Катон\-Карагайский\ р\-н",
"771630", "Боровое",
"772644", "Таласский\ р\-н",
"771545", "Жамбылский\ р\-н",
"771843", "Майский\ р\-н",
"7415", "Камчатский\ край",
"772348", "Кокпектинский\ р\-н",
"772439", "Аральский\ р\-н",
"771035", "Улытауский\ р\-н",
"771431", "Рудный",
"771454", "Наурзумский\ р\-н",
"7491", "Рязанская\ обл\.",
"771449", "Тарановский\ р\-н",
"771456", "Качар",
"7873", "Республика\ Ингушетия",
"771332", "Уилский\ р\-н",
"772640", "Мойынкумский\ р\-н",
"7712302", "Тенгизшевройл",
"771651", "Целиноградский\ р\-н",
"772837", "Алакольский\ р\-н",
"772535", "Шардара",
"771636", "Щучинский\ р\-н",
"7821", "Республика\ Коми",
"772931", "Мангистауский\ р\-н",
"772833", "Алакольский\ р\-н",
"77182", "Павлодар",
"771033", "Шетский\ р\-н",
"771037", "Актогайский\ р\-н",
"771543", "Есильский\ р\-н",
"772346", "Тарбагатайский\ р\-н",
"771845", "Павлодар",
"771547", "Жамбылский\ р\-н",
"772344", "Тарбагатайский\ р\-н",
"771330", "Хромтауский\ р\-н",
"772642", "Мойынкумский\ р\-н",
"77152", "Петропавловск",
"772533", "Туркестан",
"77122", "Атырау",
"771336", "Хромтауский\ р\-н",
"772835", "Текели",
"772237", "Аязог",
"772537", "Сарыагаш",
"771334", "Мугалжарский\ р\-н",
"772340", "Зайсанский\ р\-н",
"771632", "Зерендинский\ р\-н",
"771458", "Костанайская\ область",
"7474", "Липецкая\ обл\.",
"7484", "Калужская\ обл\.",
"771638", "Аккольский\ р\-н",
"771452", "Карасуский\ р\-н",
"7814", "Республика\ Карелия",
"772546", "Шолаккорган",
"771645", "Степногорск",
"772725", "Отеген\-Батыр",
"7499", "г\.\ Москва",
"7416", "Амурская\ обл\.",
"771343", "Иргизский\ р\-н",
"772842", "Кербулакский\ р\-н",
"771230", "Атырауская\ область",
"772779", "Райымбекский\ р\-н",
"772544", "Шаульдер",
"771347", "Айтекебийский\ р\-н",
"772156", "Шахтинск",
"772131", "Абайский\ р\-н",
"772154", "Бухар\-Жырауский\ р\-н",
"772149", "Осакаровский\ р\-н",
"771040", "Жайрем\ \(ГОК\)",
"7878", "Республика\ Карачаево\-Черкесская",
"771838", "Майский\ р\-он",
"771141", "Жангалинский\ р\-н",
"7831", "Нижегородская\ обл\.",
"771139", "Таскалинский\ р\-н",
"771536", "Тайыншинский\ р\-н",
"772635", "Жуалынский\ р\-н",
"771236", "Махамбетский\ р\-н",
"77132", "Актобе\/Актюбинск",
"772333", "Кокпектинский\ р\-н",
"772540", "Арыс",
"771832", "Иртышский\ р\-н",
"771234", "Индерский\ р\-н",
"772337", "Серебрянск",
"771534", "Шал\ Акына\ р\-н",
"7381", "Омская\ обл\.",
"772548", "Шаян",
"771647", "Есильский\ р\-н",
"772542", "Асыката",
"771643", "Атбасарский\ р\-н",
"7413", "Магаданская\ обл\.",
"771345", "Байганинский\ р\-н",
"771834", "Успенский\ р\-н",
"772637", "Байзакский\ р\-н",
"771532", "Аккайынский\ р\-н",
"771232", "Атырауская\ область",
"772840", "Кербулакский\ р\-н",
"77162", "Кокшетау",
"77274", "Карасайский\ р\-н",
"772633", "Жамбылский\ р\-н",
"7394", "Республика\ Тыва",
"772335", "Зыряновск",
"771836", "Щербактинский\ р\-н",
"771042", "Акой",
"771238", "Кзылкогинский\ р\-н",
"771538", "Кызылжарский\ р\-н",
"772752", "Илийский\ р\-н",
"7872", "Республика\ Дагестан",};
$areanames{en} = {"7847", "Republic\ of\ Kalmykia",
"771039", "Priozersk",
"771144", "Kaztalovka",
"771041", "Aktau\,\ Zhezkazgan",
"771146", "Akzhaiksky\ District",
"772435", "Zhanakorgan",
"771231", "Akkystau",
"771531", "Bulayevo",
"772353", "Novaya\ Shulba",
"77149", "Kostanai",
"772541", "Myrzakent",
"772539", "Kazygurt",
"772239", "Makanchi",
"77272956", "Talgar",
"77187", "Ekibastuz",
"7841", "Penza",
"771140", "Saikhin",
"733", "Baikonur",
"771445", "Ubaganskoye",
"7816", "Veliky\ Novgorod",
"7862", "Sochi",
"7851", "Astrakhan",
"7865", "Stavropol\ territory",
"7472", "Belgorod",
"7475", "Tambov",
"7485", "Yaroslavl",
"7482", "Tver",
"77292", "Aktau",
"771831", "Zhelezinka",
"772433", "Aralsk",
"77142", "Kostanai",
"772437", "Zhosaly",
"771142", "Taipak",
"771443", "Borovskoi",
"7813", "Leningrad\ region",
"771447", "Karabalyksky\ District",
"772132", "Nurinsky\ District",
"7345", "Tyumen",
"7342", "Perm",
"7352", "Kurgan",
"772839", "Sarkand",
"772138", "Gabidena\ Mustafina",
"772841", "Kapal",
"771436", "Taranovskoye",
"7421", "Khabarovsk\ Territory",
"771451", "Sarykol",
"771434", "Denisovka",
"772775", "Esik",
"7483", "Bryansk",
"7820", "Cherepovets",
"7473", "Voronezh",
"772934", "Zhanaozen",
"771631", "Shortandy",
"771649", "Zhaksynsky\ District",
"7343", "Ekaterinburg",
"77279", "Almaty",
"772641", "Akkol",
"772639", "Saudakent",
"7353", "Orenburg",
"7812", "St\ Petersburg",
"771135", "Zhanibek",
"7815", "Murmansk",
"7427", "Chukotka\ Autonomous\ District",
"7866", "Kabardino\-Balkarian\ Republic",
"771430", "Arkalyk",
"772257", "Shulbinsk",
"771349", "Shalkarsky\ District",
"772777", "Kegen",
"771438", "Amangeldy",
"771331", "Martuk",
"772773", "Bakanas",
"772932", "Beineu",
"7486", "Orel",
"772147", "Egindybulak",
"77272", "Almaty",
"7395", "Irkutsk",
"772938", "Fort\ Shevchenko",
"771137", "Chingirlau",
"771133", "Aksai",
"77212", "Karaganda",
"7863", "Rostov",
"7818", "Arkhangelsk",
"772339", "Kurchum",
"772341", "Ulken\ Naryn",
"77245", "Kyzylorda\ Region",
"7346", "Surgut",
"77272983", "Kaskelen",
"771439", "Torgai",
"7869", "Sevastopol",
"771441", "Karabalyk",
"771348", "Shalkarsky\ District",
"7834", "Republic\ of\ Mordovia",
"77135", "Aktobe\ Region",
"7384", "Kemerovo",
"771644", "Arshaly",
"771342", "Badamsha",
"772843", "Lepsy",
"7817", "Vologda",
"772545", "Ikan",
"771646", "Makinsk",
"771837", "Aksu",
"772634", "Zhanatas",
"7846", "Samara",
"771640", "Balkashino",
"772332", "Shemonaikha",
"771833", "Terenkol",
"77282", "Taldykorgan",
"7811", "Pskov",
"771535", "Novoishimski",
"772636", "Kordai",
"771235", "Dossor",
"772431", "Zhalagash",
"772338", "Bozanbai\/Molodezhnyi",
"771346", "Shubarkuduk",
"7391", "Krasnoyarsk\ Territory",
"7717", "Astana",
"772543", "Aqsumbe",
"7349", "Yamalo\-Nenets\ Autonomous\ District",
"771642", "Egendykol",
"772330", "Zyryanovsky\ District",
"772547", "Lenger",
"77102", "Zhezkazgan",
"772153", "Topar",
"771648", "Derzhavinsk",
"771043", "Zhairem",
"772638", "Tole\ bi",
"772757", "Akshi",
"772336", "Ridder",
"771233", "Ganyushkino",
"77252", "Shymkent",
"77222", "Semey",
"771533", "Saumalkol",
"7843", "Republic\ of\ Tatarstan",
"772632", "Merke",
"771340", "Khobdinsky\ District",
"772351", "Borodulikha",
"771237", "Kulsary",
"771537", "Timiryazevo",
"772334", "Tavricheskoye",
"77185", "Shaldai",
"771036", "Balkhash",
"7494", "Kostroma",
"771149", "Zelenovsky\ District",
"771131", "Darinskoye",
"771034", "Zhezdy",
"7867", "Republic\ of\ North\ Ossetia",
"772343", "Terekty",
"7426", "Jewish\ Autonomous\ Region",
"771546", "Talshik",
"772347", "Kalbatau",
"771544", "Presnovka",
"772530", "Temirlanovka",
"772230", "Urdzhar",
"771842", "Koktobe",
"77232", "Ust\-Kamenogorsk",
"7861", "Krasnodar\ Territory",
"7855", "Naberezhnye\ Chelny",
"771333", "Kandyagash",
"771635", "Zhaksy",
"772536", "Kentau",
"772236", "Beskaragai",
"772534", "Zhetysai",
"771337", "Alga",
"771540", "Kishkenekol",
"7845", "Saratov",
"772251", "Kurchatov",
"772771", "Kaskelen",
"7842", "Ulyanovsk",
"772832", "Zhansugurov",
"771455", "Zatobolsk",
"771030", "Atasu",
"772838", "Balpyk\ bi",
"771542", "Kishkenekol",
"772830", "Alakolsky\ District",
"771844", "Irtyshsky\ District",
"771038", "Shashubai",
"772345", "Shar",
"7423", "Primorie\ territory",
"77273", "Almaty",
"772643", "Shu",
"771032", "Karazhal",
"7347", "Republic\ of\ Bashkortostan",
"7481", "Smolensk",
"7471", "Kursk",
"77125", "Atyrau\ Region",
"772538", "Turara\ Ryskulova",
"7351", "Chelyabinsk",
"771457", "Dzhangildinsky\ District",
"7341", "Udmurtian\ Republic",
"7487", "Tula",
"771453", "Auliekol",
"772532", "Abai",
"771840", "Bayanaul",
"7848", "Tolyatti",
"772834", "Ushtobe",
"771637", "Korgalzhyn",
"771335", "Shalkar",
"772836", "Karabulak",
"77262", "Taraz",
"77213", "Aktau\/Temirtau",
"771633", "Ereimentau",
"772774", "Talgar",
"772531", "Aksukent",
"772935", "Zhetybai",
"772256", "Kainar",
"772776", "Shelek",
"772159", "Karaganda\ Region",
"772144", "Kiyevka",
"771130", "Peremetnoye",
"771435", "Zhitikara",
"772146", "Karkaralinsk",
"772759", "Almaty\ Region",
"7382", "Tomsk",
"7385", "Altai\ Territory",
"771031", "Aksu\-Ayuly",
"771134", "Zhympity",
"7424", "Sakhalin\ Region",
"771136", "Chapayev",
"771239", "Makat",
"7496", "Moscow",
"771539", "Beskol",
"771541", "Mamlutka",
"772770", "Uzynagash",
"7835", "Chuvashi\ Republic",
"736", "Simferopol",
"77242", "Kyzylorda",
"77224", "Barshatas",
"771433", "Lisakovsk",
"772778", "Chundzha",
"771437", "Kamysty",
"7877", "Republic\ of\ Adygeya",
"772937", "Kuryk",
"772252", "Karaul",
"772831", "Zharkent",
"772148", "Molodezhnoye",
"772772", "Kapchagai",
"7871", "Chechen\ Republic",
"771841", "Aktogai",
"771138", "Zhalpaktal",
"771839", "Akku",
"771132", "Fyodorovka",
"7388", "Republic\ of\ Altai",
"772631", "Kulan",
"7411", "Republic\ of\ Sakha",
"772436", "Terenozek",
"771145", "Karatobe\ District",
"7844", "Volgograd",
"771440", "Amangeldy",
"7301", "Republic\ of\ Buryatia",
"771446", "Uzunkolsky\ District",
"77106", "Satpaev",
"771459", "Kostanai\ Region",
"771444", "Uzunkol",
"7712303", "Tengizs",
"7495", "Moscow",
"7492", "Vladimir",
"771639", "Stepnyak",
"740", "Kaliningrad",
"771641", "Astrakhanka",
"7836", "Republic\ of\ Marij\ El",
"7879", "Mineranye\ Vody",
"772432", "Shiyeli",
"771147", "Akzhaiksky\ District",
"771143", "Akzhaik",
"772331", "Glubokoye",
"772438", "Aiteke\ bi",
"771341", "Khobda",
"771448", "Oktyabrskoye",
"7833", "Kirov",
"77145834", "Krasnogorsk",
"771339", "Komsomolskoye",
"7498", "Moscow",
"7390", "Republic\ of\ Khakassia",
"771442", "Fyodorovka",
"772137", "Saran",
"7383", "Novosibirsk",
"77112", "Uralsk",
"7302", "Chita",
"771630", "Burabay",
"772342", "Katon\-Karagai",
"772644", "Karatau",
"771545", "Zhambylsky\ District",
"7415", "Kamchatka\ Region",
"771843", "Maisky\ District",
"772348", "Kokpekty",
"772439", "Aralsky\ District",
"771035", "Ulytau",
"771431", "Rudny",
"771449", "Taranovskoye",
"7491", "Ryazan",
"771454", "Karamendy",
"771456", "Kachar",
"7873", "Ingushi\ Republic",
"7712302", "Tengizshevroil",
"771651", "Kabanbai\ Batyr",
"771332", "Uil",
"772640", "Moiynkumsky\ District",
"772837", "Kabanbai",
"772931", "Shetpe",
"771636", "Shuchinsk",
"772535", "Shardara",
"7821", "Komi\ Republic",
"77182", "Pavlodar",
"772833", "Usharal",
"771033", "Agadyr",
"771037", "Aktogai",
"771543", "Yavlenka",
"771845", "Pavlodar\ Area",
"772346", "Aksuat",
"772344", "Akzhar",
"771547", "Zhambylsky\ District",
"771330", "Khromtau\ District",
"772642", "Moiynkum",
"772533", "Turkestan",
"77122", "Atyrau",
"77152", "Petropavlovsk",
"772835", "Tekeli",
"771336", "Khromtau",
"771334", "Emba",
"772537", "Saryagash",
"772237", "Ayagoz",
"771632", "Zerenda",
"772340", "Zaisan",
"771458", "Kostanai\ Region",
"7474", "Lipetsk",
"7484", "Kaluga",
"771638", "Akkol",
"771452", "Karasu",
"772725", "Otegen\ Batyra",
"771645", "Stepnogorsk",
"7814", "Republic\ of\ Karelia",
"772546", "Sholakkorgan",
"7416", "Amur\ Region",
"7499", "Moscow",
"771343", "Irgiz",
"771230", "Atyrau\ Region",
"772842", "Kogaly",
"771347", "Aitekebisky\ District",
"772544", "Shaulder",
"772779", "Narynkol",
"772156", "Shakhtinsk",
"772131", "Abai",
"772149", "Osakarovka",
"771040", "Zhairem\ \(GOK\)",
"772154", "Botakara",
"7878", "Karachayevo\-Cherkessian\ Republic",
"7831", "Nizhni\ Novgorod",
"771838", "Koktobe",
"771141", "Zhangala",
"771139", "Taskala",
"771236", "Makhambet",
"772635", "Bauyrzhan\ Mamyshuly",
"771536", "Taiynsha",
"772333", "Samarskoye",
"77132", "Aktobe\/Kargalinskoye",
"771832", "Irtyshsk",
"772540", "Arys",
"772337", "Serebryansk",
"771534", "Sergeyevka",
"7381", "Omsk",
"771234", "Indernborski",
"772548", "Shayan",
"771647", "Esil",
"772542", "Asykata",
"771643", "Atbasar",
"7413", "Magadan",
"771345", "Karauylkeldy",
"772637", "Sarykemer",
"771834", "Uspenka",
"772840", "Saryozek",
"771232", "Atyrau\ Region",
"771532", "Smirnovo",
"77274", "Karassaisky\ District",
"772633", "Asa",
"77162", "Kokshetau\/Krasni\ Yar",
"771836", "Sharbakty",
"7394", "Republic\ of\ Tuva",
"772335", "Zyryanovsk",
"771042", "Zharyk",
"771538", "Beskol",
"772752", "Otegen\ Batyra",
"771238", "Miyaly",
"7872", "Republic\ of\ Daghestan",};
my $timezones = {
               '' => [
                       'Asia/Almaty',
                       'Asia/Anadyr',
                       'Asia/Aqtobe',
                       'Asia/Irkutsk',
                       'Asia/Kamchatka',
                       'Asia/Krasnoyarsk',
                       'Asia/Magadan',
                       'Asia/Novosibirsk',
                       'Asia/Omsk',
                       'Asia/Sakhalin',
                       'Asia/Vladivostok',
                       'Asia/Yakutsk',
                       'Asia/Yekaterinburg',
                       'Europe/Bucharest',
                       'Europe/Moscow',
                       'Europe/Samara'
                     ],
               '301' => [
                          'Asia/Irkutsk'
                        ],
               '302' => [
                          'Asia/Yakutsk'
                        ],
               '33' => [
                         'Asia/Almaty'
                       ],
               '34' => [
                         'Asia/Yekaterinburg'
                       ],
               '341' => [
                          'Europe/Samara'
                        ],
               '35' => [
                         'Asia/Yekaterinburg'
                       ],
               '36' => [
                         'Europe/Moscow'
                       ],
               '381' => [
                          'Asia/Omsk'
                        ],
               '382' => [
                          'Asia/Novosibirsk'
                        ],
               '383' => [
                          'Asia/Novosibirsk'
                        ],
               '384' => [
                          'Asia/Krasnoyarsk'
                        ],
               '385' => [
                          'Asia/Krasnoyarsk'
                        ],
               '388' => [
                          'Asia/Krasnoyarsk'
                        ],
               '390' => [
                          'Asia/Krasnoyarsk'
                        ],
               '391' => [
                          'Asia/Krasnoyarsk'
                        ],
               '394' => [
                          'Asia/Krasnoyarsk'
                        ],
               '395' => [
                          'Asia/Irkutsk'
                        ],
               '40' => [
                         'Europe/Bucharest'
                       ],
               '411' => [
                          'Asia/Yakutsk'
                        ],
               '413' => [
                          'Asia/Magadan'
                        ],
               '415' => [
                          'Asia/Kamchatka'
                        ],
               '416' => [
                          'Asia/Yakutsk'
                        ],
               '421' => [
                          'Asia/Vladivostok'
                        ],
               '423' => [
                          'Asia/Vladivostok'
                        ],
               '424' => [
                          'Asia/Sakhalin'
                        ],
               '426' => [
                          'Asia/Vladivostok'
                        ],
               '427' => [
                          'Asia/Anadyr'
                        ],
               '47' => [
                         'Europe/Moscow'
                       ],
               '48' => [
                         'Europe/Moscow'
                       ],
               '49' => [
                         'Europe/Moscow'
                       ],
               '7' => [
                        'Asia/Almaty',
                        'Asia/Aqtobe'
                      ],
               '71' => [
                         'Asia/Almaty'
                       ],
               '711' => [
                          'Asia/Aqtobe'
                        ],
               '712' => [
                          'Asia/Aqtobe'
                        ],
               '713' => [
                          'Asia/Aqtobe'
                        ],
               '72' => [
                         'Asia/Almaty'
                       ],
               '729' => [
                          'Asia/Aqtobe'
                        ],
               '79' => [
                         'Asia/Almaty'
                       ],
               '800' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '803' => [
                          'Europe/Moscow'
                        ],
               '804' => [
                          'Europe/Moscow'
                        ],
               '808' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '809' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '81' => [
                         'Europe/Moscow'
                       ],
               '810' => [
                          'Asia/Almaty',
                          'Asia/Aqtobe',
                          'Europe/Moscow'
                        ],
               '82' => [
                         'Europe/Moscow'
                       ],
               '83' => [
                         'Europe/Moscow'
                       ],
               '840' => [
                          'Europe/Bucharest',
                          'Europe/Moscow'
                        ],
               '841' => [
                          'Europe/Moscow'
                        ],
               '842' => [
                          'Europe/Samara'
                        ],
               '843' => [
                          'Europe/Moscow'
                        ],
               '844' => [
                          'Europe/Moscow'
                        ],
               '845' => [
                          'Europe/Moscow'
                        ],
               '846' => [
                          'Europe/Samara'
                        ],
               '847' => [
                          'Europe/Moscow'
                        ],
               '848' => [
                          'Europe/Samara'
                        ],
               '851' => [
                          'Europe/Samara'
                        ],
               '855' => [
                          'Europe/Moscow'
                        ],
               '86' => [
                         'Europe/Moscow'
                       ],
               '87' => [
                         'Europe/Moscow'
                       ],
               '9' => [
                        'Europe/Moscow'
                      ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+7|\D)//g;
      my $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:8)//;
      $self = bless({ country_code => '7', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;