/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.expression.spel.support;

import org.springframework.core.convert.ConversionException;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.SpelEvaluationException;
import org.springframework.expression.spel.SpelMessage;
import org.springframework.util.Assert;

public class StandardTypeConverter
implements TypeConverter {
    private static ConversionService defaultConversionService;
    private final ConversionService conversionService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StandardTypeConverter() {
        StandardTypeConverter standardTypeConverter = this;
        synchronized (standardTypeConverter) {
            if (defaultConversionService == null) {
                defaultConversionService = new DefaultConversionService();
            }
        }
        this.conversionService = defaultConversionService;
    }

    public StandardTypeConverter(ConversionService conversionService) {
        Assert.notNull(conversionService, "ConversionService must not be null");
        this.conversionService = conversionService;
    }

    public boolean canConvert(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return this.conversionService.canConvert(sourceType, targetType);
    }

    public Object convertValue(Object value, TypeDescriptor sourceType, TypeDescriptor targetType) {
        try {
            return this.conversionService.convert(value, sourceType, targetType);
        }
        catch (ConversionException ex) {
            throw new SpelEvaluationException(ex, SpelMessage.TYPE_CONVERSION_ERROR, sourceType.toString(), targetType.toString());
        }
    }
}

