/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.pattern;

import java.awt.Paint;
import java.io.IOException;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDShadingPatternResources;
import org.apache.pdfbox.pdmodel.graphics.pattern.PDTilingPatternResources;

public abstract class PDPatternResources
implements COSObjectable {
    private COSDictionary patternDictionary;
    public static final int TILING_PATTERN = 1;
    public static final int SHADING_PATTERN = 2;

    public PDPatternResources() {
        this.patternDictionary = new COSDictionary();
        this.patternDictionary.setName(COSName.TYPE, COSName.PATTERN.getName());
    }

    public PDPatternResources(COSDictionary resourceDictionary) {
        this.patternDictionary = resourceDictionary;
    }

    public COSDictionary getCOSDictionary() {
        return this.patternDictionary;
    }

    public COSBase getCOSObject() {
        return this.patternDictionary;
    }

    public void setFilter(String filter) {
        this.patternDictionary.setItem(COSName.FILTER, (COSBase)COSName.getPDFName(filter));
    }

    public String getFilter() {
        return this.patternDictionary.getNameAsString(COSName.FILTER);
    }

    public void setLength(int length) {
        this.patternDictionary.setInt(COSName.LENGTH, length);
    }

    public int getLength() {
        return this.patternDictionary.getInt(COSName.LENGTH, 0);
    }

    public void setPaintType(int paintType) {
        this.patternDictionary.setInt(COSName.PAINT_TYPE, paintType);
    }

    public String getType() {
        return COSName.PATTERN.getName();
    }

    public void setPatternType(int patternType) {
        this.patternDictionary.setInt(COSName.PATTERN_TYPE, patternType);
    }

    public abstract int getPatternType();

    public static PDPatternResources create(COSDictionary resourceDictionary) throws IOException {
        PDPatternResources pattern = null;
        int patternType = resourceDictionary.getInt(COSName.PATTERN_TYPE, 0);
        switch (patternType) {
            case 1: {
                pattern = new PDTilingPatternResources(resourceDictionary);
                break;
            }
            case 2: {
                pattern = new PDShadingPatternResources(resourceDictionary);
                break;
            }
            default: {
                throw new IOException("Error: Unknown pattern type " + patternType);
            }
        }
        return pattern;
    }

    public abstract Paint getPaint(int var1) throws IOException;
}

