/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.File;
import java.io.Serializable;
import java.util.Formatter;
import java.util.HashMap;

public class CacheFile
implements Serializable {
    protected String shortName;
    protected long lastModified;
    protected long length;
    protected boolean isDirectory;
    private HashMap<String, Object> att;

    public String getShortName() {
        return this.shortName;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLength() {
        return this.length;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public CacheFile() {
    }

    public CacheFile(File f) {
        this.shortName = f.getName();
        this.lastModified = f.lastModified();
        this.length = f.length();
        this.isDirectory = f.isDirectory();
    }

    public void setAttribute(String key, Object value) {
        if (this.att == null) {
            this.att = new HashMap(5);
        }
        this.att.put(key, value);
    }

    public Object getAttribute(String key) {
        if (this.att == null) {
            return null;
        }
        return this.att.get(key);
    }

    public String toString() {
        Formatter f = new Formatter();
        f.format("CacheFile{ shortName='%s' lastModified=%d length=%d isDirectory=%s%n", this.shortName, this.lastModified, this.length, this.isDirectory);
        if (this.att != null) {
            f.format(" attributes:%n", new Object[0]);
            for (String key : this.att.keySet()) {
                f.format("  %s = %s %n", key, this.att.get(key));
            }
        }
        return f.toString();
    }
}

