package Net::Async::Spotify::Object::Generated::Cursor;

use strict;
use warnings;

our $VERSION = '0.002'; # VERSION
our $AUTHORITY = 'cpan:VNEALV'; # AUTHORITY

use mro;
use parent qw(Net::Async::Spotify::Object::Base);

=encoding utf8

=head1 NAME

Net::Async::Spotify::Object::Generated::Cursor - Package representing Spotify Cursor Object

=head1 DESCRIPTION

Autogenerated module.
Based on https://developer.spotify.com/documentation/web-api/reference/#objects-index
Check C<crawl-api-doc.pl> for more information.

=head1 PARAMETERS

Those are Spotify Cursor Object attributes:

=over 4

=item after

Type:String
Description:The cursor to use as key to find the next page of items.

=back

=cut

sub new {
    my ($class, %args) = @_;

    my $fields = {
        after => 'String',
    };

    my $obj = next::method($class, $fields, %args);

    return $obj;
}

1;
